/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common.support;

import com.ibm.db2.tools.common.AssistTree;
import com.ibm.db2.tools.common.support.AssistManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.io.Serializable;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.text.View;
import javax.swing.tree.TreeCellRenderer;

public class AssistTreeCellRenderer
extends JLabel
implements TreeCellRenderer,
Serializable {
    private static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected transient Icon closedIcon;
    protected transient Icon leafIcon;
    protected transient Icon openIcon;
    protected Color textSelectionColor;
    protected Color textNonSelectionColor;
    protected Color backgroundSelectionColor;
    protected Color backgroundNonSelectionColor;
    protected static Border focusBorder;
    protected static Border noFocusBorder;
    private boolean drawsFocusBorderAroundIcon;
    protected boolean selected;
    private static Rectangle paintIconR;
    private static Rectangle paintTextR;
    private static Rectangle paintViewR;
    private static Insets paintViewInsets;

    public AssistTreeCellRenderer() {
        Object object;
        this.setOpaque(true);
        this.setHorizontalAlignment(2);
        this.setLeafIcon(UIManager.getIcon("Tree.leafIcon"));
        this.setClosedIcon(UIManager.getIcon("Tree.closedIcon"));
        this.setOpenIcon(UIManager.getIcon("Tree.openIcon"));
        this.setTextSelectionColor(UIManager.getColor("Tree.selectionForeground"));
        this.setTextNonSelectionColor(UIManager.getColor("Tree.textForeground"));
        this.setBackgroundSelectionColor(UIManager.getColor("Tree.selectionBackground"));
        this.setBackgroundNonSelectionColor(UIManager.getColor("Tree.textBackground"));
        if (focusBorder == null) {
            focusBorder = (Border)UIManager.get("Tree.focusBorder");
        }
        if (noFocusBorder == null) {
            noFocusBorder = BorderFactory.createEmptyBorder(1, 0, 1, 1);
        }
        this.drawsFocusBorderAroundIcon = (object = UIManager.get("Tree.drawsFocusBorderAroundIcon")) != null && (Boolean)object != false;
    }

    public Icon getDefaultOpenIcon() {
        return this.openIcon;
    }

    public Icon getDefaultClosedIcon() {
        return this.closedIcon;
    }

    public Icon getDefaultLeafIcon() {
        return this.leafIcon;
    }

    public void setOpenIcon(Icon icon) {
        this.openIcon = icon;
    }

    public Icon getOpenIcon() {
        return this.openIcon;
    }

    public void setClosedIcon(Icon icon) {
        this.closedIcon = icon;
    }

    public Icon getClosedIcon() {
        return this.closedIcon;
    }

    public void setLeafIcon(Icon icon) {
        this.leafIcon = icon;
    }

    public Icon getLeafIcon() {
        return this.leafIcon;
    }

    public void setTextSelectionColor(Color color) {
        this.textSelectionColor = color;
    }

    public Color getTextSelectionColor() {
        return this.textSelectionColor;
    }

    public void setTextNonSelectionColor(Color color) {
        this.textNonSelectionColor = color;
    }

    public Color getTextNonSelectionColor() {
        return this.textNonSelectionColor;
    }

    public void setBackgroundSelectionColor(Color color) {
        this.backgroundSelectionColor = color;
    }

    public Color getBackgroundSelectionColor() {
        return this.backgroundSelectionColor;
    }

    public void setBackgroundNonSelectionColor(Color color) {
        this.backgroundNonSelectionColor = color;
    }

    public Color getBackgroundNonSelectionColor() {
        return this.backgroundNonSelectionColor;
    }

    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n2, boolean bl4) {
        this.setText(jTree.convertValueToText(object, bl, bl2, bl3, n2, bl4));
        this.setEnabled(jTree.isEnabled());
        if (jTree.isEnabled()) {
            this.setEnabled(true);
            if (bl3) {
                this.setIcon(this.getLeafIcon());
            } else if (bl2) {
                this.setIcon(this.getOpenIcon());
            } else {
                this.setIcon(this.getClosedIcon());
            }
        } else {
            this.setEnabled(false);
            if (bl3) {
                this.setDisabledIcon(this.getLeafIcon());
            } else if (bl2) {
                this.setDisabledIcon(this.getOpenIcon());
            } else {
                this.setDisabledIcon(this.getClosedIcon());
            }
        }
        if (bl && jTree.isEnabled()) {
            this.setForeground(this.getTextSelectionColor());
            this.setBackground(this.getBackgroundSelectionColor());
        } else if (jTree.isEnabled()) {
            this.setForeground(this.getTextNonSelectionColor());
            this.setBackground(this.getBackgroundNonSelectionColor());
        } else if (((AssistTree)jTree).getClearDisabled()) {
            Color color = UIManager.getColor("control");
            this.setBackground(color);
            this.setForeground(color);
        } else {
            this.setForeground(this.getTextNonSelectionColor());
            this.setBackground(UIManager.getColor("control"));
        }
        if (bl4) {
            if (jTree instanceof AssistTree && !((AssistTree)jTree).isRowValid(n2)) {
                this.setBorder(AssistManager.getBorder("Assist.nested.error.border"));
            } else {
                this.setBorder(focusBorder);
            }
        } else if (jTree instanceof AssistTree && !((AssistTree)jTree).isRowValid(n2)) {
            this.setBorder(AssistManager.getBorder("Assist.nested.error.border"));
        } else {
            this.setBorder(noFocusBorder);
        }
        this.selected = bl;
        return this;
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (dimension != null) {
            dimension = new Dimension(dimension.width + 2, dimension.height);
        }
        return dimension;
    }

    protected void paintComponent(Graphics graphics) {
        if (this.ui != null) {
            Graphics graphics2 = graphics.create();
            try {
                if (this.selected) {
                    Color color = this.getBackgroundSelectionColor();
                    if (!this.isEnabled() || color == null) {
                        color = this.getBackground();
                    }
                    if (color != null) {
                        int n2 = this.drawsFocusBorderAroundIcon ? 0 : this.getLabelStart();
                        graphics.setColor(color);
                        if (this.getComponentOrientation().isLeftToRight()) {
                            graphics.fillRect(n2, 0, this.getWidth() - 1 - n2, this.getHeight());
                        } else {
                            graphics.fillRect(0, 0, this.getWidth() - 1 - n2, this.getHeight());
                        }
                    }
                    paintViewInsets = this.getInsets(paintViewInsets);
                    AssistTreeCellRenderer.paintViewR.x = AssistTreeCellRenderer.paintViewInsets.left;
                    AssistTreeCellRenderer.paintViewR.y = AssistTreeCellRenderer.paintViewInsets.top;
                    AssistTreeCellRenderer.paintViewR.width = this.getWidth() - (AssistTreeCellRenderer.paintViewInsets.left + AssistTreeCellRenderer.paintViewInsets.right);
                    AssistTreeCellRenderer.paintViewR.height = this.getHeight() - (AssistTreeCellRenderer.paintViewInsets.top + AssistTreeCellRenderer.paintViewInsets.bottom);
                    AssistTreeCellRenderer.paintIconR.height = 0;
                    AssistTreeCellRenderer.paintIconR.width = 0;
                    AssistTreeCellRenderer.paintIconR.y = 0;
                    AssistTreeCellRenderer.paintIconR.x = 0;
                    AssistTreeCellRenderer.paintTextR.height = 0;
                    AssistTreeCellRenderer.paintTextR.width = 0;
                    AssistTreeCellRenderer.paintTextR.y = 0;
                    AssistTreeCellRenderer.paintTextR.x = 0;
                    FontMetrics fontMetrics = graphics2.getFontMetrics();
                    Icon icon = this.getIcon();
                    String string = SwingUtilities.layoutCompoundLabel(this, fontMetrics, this.getText(), icon, this.getVerticalAlignment(), this.getHorizontalAlignment(), this.getVerticalTextPosition(), this.getHorizontalTextPosition(), paintViewR, paintIconR, paintTextR, this.getIconTextGap());
                    if (icon != null) {
                        icon.paintIcon(this, graphics2, AssistTreeCellRenderer.paintIconR.x, AssistTreeCellRenderer.paintIconR.y);
                    }
                    if (this.getText() != null) {
                        View view = (View)this.getClientProperty("html");
                        if (view != null) {
                            view.paint(graphics, paintTextR);
                        } else if (this.isEnabled()) {
                            graphics2.setColor(this.getForeground());
                            graphics2.drawString(string, AssistTreeCellRenderer.paintTextR.x, AssistTreeCellRenderer.paintTextR.y + fontMetrics.getAscent());
                        } else {
                            this.ui.update(graphics2, this);
                        }
                    }
                } else {
                    this.ui.update(graphics2, this);
                }
                Object var9_9 = null;
                graphics2.dispose();
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                graphics2.dispose();
                throw throwable;
            }
        }
    }

    protected void paintBorder(Graphics graphics) {
        int n2 = this.drawsFocusBorderAroundIcon ? 0 : this.getLabelStart();
        Border border = this.getBorder();
        if (border != null) {
            border.paintBorder(this, graphics, n2, 0, this.getWidth() - n2, this.getHeight());
        }
    }

    protected int getLabelStart() {
        Icon icon = this.getIcon();
        if (icon != null && this.getText() != null) {
            return icon.getIconWidth() + Math.max(0, this.getIconTextGap() - 1);
        }
        return 0;
    }

    static {
        paintIconR = new Rectangle();
        paintTextR = new Rectangle();
        paintViewR = new Rectangle();
        paintViewInsets = new Insets(0, 0, 0, 0);
    }
}

