/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common.support;

import com.ibm.db2.tools.common.AssistField;
import com.ibm.db2.tools.common.AssistTree;
import com.ibm.db2.tools.common.support.AssistManager;
import com.ibm.db2.tools.common.support.AssistTreeCellRenderer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.EventObject;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.Border;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreePath;

public class AssistTreeCellEditor
implements Serializable,
ActionListener,
TreeCellEditor,
TreeSelectionListener {
    private static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected EventListenerList listenerList;
    protected transient ChangeEvent changeEvent;
    protected AssistTreeCellRenderer renderer;
    protected transient AssistField editingComponent;
    protected transient String editingText;
    protected int clickCountToStart;
    protected boolean canEdit;
    protected transient int offset;
    protected transient AssistTree tree;
    protected transient TreePath lastPath;
    protected transient Timer timer;
    protected transient int lastRow;
    protected transient Icon editingIcon;
    protected Font font;
    static /* synthetic */ Class class$javax$swing$event$CellEditorListener;

    public AssistTreeCellEditor(AssistTree assistTree, AssistTreeCellRenderer assistTreeCellRenderer) {
        this.renderer = assistTreeCellRenderer;
        this.setClickCountToStart(1);
        this.setTree(assistTree);
        this.listenerList = new EventListenerList();
        this.changeEvent = null;
    }

    public void setClickCountToStart(int n2) {
        this.clickCountToStart = n2;
    }

    public int getClickCountToStart() {
        return this.clickCountToStart;
    }

    public Component getTreeCellEditorComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n2) {
        this.setTree((AssistTree)jTree);
        this.lastRow = n2;
        this.determineOffset(jTree, object, bl, bl2, bl3, n2);
        String string = jTree.convertValueToText(object, bl, bl2, bl3, n2, false);
        this.editingComponent = new AssistTreeEditor(this.tree, new Integer(n2), string == null ? "" : string, n2);
        TreePath treePath = jTree.getPathForRow(n2);
        this.canEdit = this.lastPath != null && treePath != null && this.lastPath.equals(treePath);
        Font font = null;
        if (this.renderer != null) {
            font = this.renderer.getFont();
        }
        if (font == null) {
            font = jTree.getFont();
        }
        this.editingComponent.setFont(font);
        return this.editingComponent;
    }

    public Object getCellEditorValue() {
        if (this.editingText == null) {
            return null;
        }
        return this.editingText;
    }

    public boolean isCellEditable(EventObject eventObject) {
        boolean bl = false;
        if (this.canEditImmediately(eventObject)) {
            bl = true;
        } else if (this.canEdit && this.shouldStartEditingTimer(eventObject)) {
            this.startEditingTimer();
        } else if (this.timer != null && this.timer.isRunning()) {
            this.timer.stop();
        }
        return bl;
    }

    public boolean shouldSelectCell(EventObject eventObject) {
        if (this.isCellEditable(eventObject) && (eventObject == null || ((MouseEvent)eventObject).getClickCount() >= this.clickCountToStart)) {
            this.editingComponent.requestFocus();
        }
        return true;
    }

    public boolean stopCellEditing() {
        this.editingText = this.editingComponent.getText();
        this.editingComponent = null;
        this.fireEditingStopped();
        return true;
    }

    public void cancelCellEditing() {
        this.editingText = null;
        this.editingComponent = null;
        this.fireEditingCanceled();
    }

    public void addCellEditorListener(CellEditorListener cellEditorListener) {
        this.listenerList.add(class$javax$swing$event$CellEditorListener == null ? (class$javax$swing$event$CellEditorListener = AssistTreeCellEditor.class$("javax.swing.event.CellEditorListener")) : class$javax$swing$event$CellEditorListener, cellEditorListener);
        if (this.changeEvent == null) {
            this.changeEvent = new ChangeEvent(this);
        }
    }

    public void removeCellEditorListener(CellEditorListener cellEditorListener) {
        this.listenerList.remove(class$javax$swing$event$CellEditorListener == null ? (class$javax$swing$event$CellEditorListener = AssistTreeCellEditor.class$("javax.swing.event.CellEditorListener")) : class$javax$swing$event$CellEditorListener, cellEditorListener);
    }

    protected void fireEditingStopped() {
        Object[] objectArray = this.listenerList.getListenerList();
        int n2 = objectArray.length - 2;
        while (n2 >= 0) {
            if (objectArray[n2] == (class$javax$swing$event$CellEditorListener == null ? AssistTreeCellEditor.class$("javax.swing.event.CellEditorListener") : class$javax$swing$event$CellEditorListener)) {
                ((CellEditorListener)objectArray[n2 + 1]).editingStopped(this.changeEvent);
            }
            n2 -= 2;
        }
    }

    protected void fireEditingCanceled() {
        Object[] objectArray = this.listenerList.getListenerList();
        int n2 = objectArray.length - 2;
        while (n2 >= 0) {
            if (objectArray[n2] == (class$javax$swing$event$CellEditorListener == null ? AssistTreeCellEditor.class$("javax.swing.event.CellEditorListener") : class$javax$swing$event$CellEditorListener)) {
                ((CellEditorListener)objectArray[n2 + 1]).editingCanceled(this.changeEvent);
            }
            n2 -= 2;
        }
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        if (this.tree != null) {
            this.lastPath = this.tree.getSelectionCount() == 1 ? this.tree.getSelectionPath() : null;
        }
        if (this.timer != null) {
            this.timer.stop();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.tree != null && this.lastPath != null) {
            this.tree.startEditingAtPath(this.lastPath);
        }
    }

    protected void setTree(AssistTree assistTree) {
        if (this.tree != assistTree) {
            if (this.tree != null) {
                this.tree.removeTreeSelectionListener(this);
            }
            this.tree = assistTree;
            if (this.tree != null) {
                this.tree.addTreeSelectionListener(this);
            }
            if (this.timer != null) {
                this.timer.stop();
            }
        }
    }

    protected boolean shouldStartEditingTimer(EventObject eventObject) {
        if (eventObject instanceof MouseEvent && SwingUtilities.isLeftMouseButton((MouseEvent)eventObject)) {
            MouseEvent mouseEvent = (MouseEvent)eventObject;
            return mouseEvent.getClickCount() == 1 && this.inHitRegion(mouseEvent.getX(), mouseEvent.getY());
        }
        return false;
    }

    protected void startEditingTimer() {
        if (this.timer == null) {
            this.timer = new Timer(1200, this);
            this.timer.setRepeats(false);
        }
        this.timer.start();
    }

    protected boolean canEditImmediately(EventObject eventObject) {
        if (eventObject instanceof MouseEvent && SwingUtilities.isLeftMouseButton((MouseEvent)eventObject)) {
            MouseEvent mouseEvent = (MouseEvent)eventObject;
            return mouseEvent.getClickCount() > 2 && this.inHitRegion(mouseEvent.getX(), mouseEvent.getY());
        }
        return eventObject == null;
    }

    protected boolean inHitRegion(int n2, int n3) {
        Rectangle rectangle;
        return this.lastRow == -1 || this.tree == null || (rectangle = this.tree.getRowBounds(this.lastRow)) == null || n2 > rectangle.x + this.offset || this.offset >= rectangle.width - 5;
    }

    protected void determineOffset(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n2) {
        if (this.renderer != null) {
            this.editingIcon = bl3 ? this.renderer.getLeafIcon() : (bl2 ? this.renderer.getOpenIcon() : this.renderer.getClosedIcon());
            this.offset = this.editingIcon != null ? this.renderer.getIconTextGap() + this.editingIcon.getIconWidth() : this.renderer.getIconTextGap();
        } else {
            this.editingIcon = null;
            this.offset = 0;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class AssistTreeEditor
    extends AssistField {
        private final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
        protected AssistTree tree;
        protected int minWidth;
        protected int row;

        public AssistTreeEditor(AssistTree assistTree, Object object, String string, int n2) {
            super(string);
            this.nested = true;
            this.setContext(object);
            this.tree = assistTree;
            this.addAssistListener(assistTree);
            this.minWidth = 100;
            this.row = n2;
            this.setBorder(AssistManager.getBorder("Tree.editorBorder"));
        }

        public Border getBorder() {
            if (this.isValueValid()) {
                return AssistManager.getBorder("Tree.editorBorder");
            }
            return AssistManager.getBorder("Assist.nested.error.border");
        }

        public void processKeyEvent(KeyEvent keyEvent) {
            int n2 = keyEvent.getID();
            int n3 = keyEvent.getKeyCode();
            if (n3 == 10) {
                if (this.tree != null && n2 == 402) {
                    this.tree.stopEditing();
                }
                keyEvent.consume();
            } else {
                super.processKeyEvent(keyEvent);
            }
        }

        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            if (AssistTreeCellEditor.this.renderer != null) {
                Dimension dimension2 = AssistTreeCellEditor.this.renderer.getPreferredSize();
                dimension.height = dimension2.height;
                dimension.width = (int)(1.5 * (dimension.width < this.minWidth ? (double)this.minWidth : (double)dimension.width));
            }
            return dimension;
        }
    }
}

