/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common.support;

import com.ibm.db2.tools.common.support.AssistCollator;
import com.ibm.db2.tools.common.support.AssistIndex;
import com.ibm.db2.tools.common.support.AssistKey;
import com.ibm.db2.tools.common.support.AssistManager;
import com.ibm.db2.tools.common.support.MultiValuedCell;
import java.io.Serializable;
import java.util.BitSet;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableModel;

public class AssistTableModel
extends DefaultTableModel
implements Serializable {
    private static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected Vector columnClasses;
    protected BitSet editableFlags;
    protected int firstEditableRow = 0;
    protected int trailingNonEditableRows = 0;
    protected int sortAlgorithm = 4;
    protected boolean sorted;
    protected AssistIndex sortOrder;
    protected int prevSortColumn;
    protected int[] sortSequence;
    protected int[] sortDirection;
    protected AssistKey[][] savedKeys;
    protected AssistKey[][] keys;
    protected AssistIndex[] savedIndex;
    protected AssistIndex rowIndexes;
    protected static AssistCollator theCollator;
    static /* synthetic */ Class class$java$util$Vector;
    static /* synthetic */ Class class$java$util$Date;

    public AssistTableModel() {
        super((Vector)null, 0);
        this.configureColumns(0);
    }

    public AssistTableModel(int n2, int n3) {
        super(n2, n3);
        this.configureRowIndexes(n2);
        this.configureColumns(n3);
    }

    public AssistTableModel(Vector vector, int n2) {
        super(vector, n2);
        this.configureRowIndexes(n2);
        this.configureColumns(vector.size());
    }

    public AssistTableModel(Object[] objectArray, int n2) {
        super(objectArray, n2);
        this.configureRowIndexes(n2);
        this.configureColumns(objectArray.length);
    }

    public AssistTableModel(Vector vector, Vector vector2) {
        super(vector, vector2);
        this.configureRowIndexes(vector.size());
        this.configureColumns(vector2.size());
    }

    public AssistTableModel(Object[][] objectArray, Object[] objectArray2) {
        super(objectArray, objectArray2);
        this.configureRowIndexes(objectArray.length);
        this.configureColumns(objectArray2.length);
    }

    public AssistTableModel(Object[] objectArray) {
        this.setColumnIdentifiers(DefaultTableModel.convertToVector(objectArray));
        this.configureRowIndexes(0);
        this.configureColumns(objectArray.length);
    }

    public AssistTableModel(String[] stringArray) {
        this.setColumnIdentifiers(DefaultTableModel.convertToVector(stringArray));
        this.configureRowIndexes(0);
        this.configureColumns(stringArray.length);
    }

    public AssistTableModel(Vector vector) {
        this.setColumnIdentifiers(vector);
        this.configureRowIndexes(0);
        this.configureColumns(vector.size());
    }

    public synchronized void addRow(Vector vector) {
        int n2 = this.getRowCount();
        if (vector == null) {
            vector = new Vector(this.getColumnCount());
        } else {
            vector.setSize(this.getColumnCount());
        }
        this.replaceMultiValuedCellsInRow(vector);
        this.dataVector.addElement(vector);
        this.rowIndexes.addInt(n2);
        this.configureIndexes(this.getColumnCount());
        this.fireTableRowsInserted(n2, n2);
    }

    public void insertRow(int n2, Vector vector) {
        if (vector == null) {
            vector = new Vector(this.getColumnCount());
        } else {
            vector.setSize(this.getColumnCount());
        }
        this.replaceMultiValuedCellsInRow(vector);
        this.dataVector.insertElementAt(vector, n2);
        int n3 = this.rowIndexes.size();
        int n4 = n3 - 1;
        while (n4 >= 0) {
            int n5 = this.rowIndexes.intAt(n4);
            if (n5 >= n2) {
                this.rowIndexes.setIntAt(n5 + 1, n4);
            }
            --n4;
        }
        this.rowIndexes.insertIntAt(n2, n2);
        this.configureIndexes(this.getColumnCount());
        this.fireTableRowsInserted(n2, n2);
    }

    public Object getValueAt(int n2, int n3) {
        if (n2 > -1 && n3 > -1 && n2 < this.getRowCount() && n3 < this.getColumnCount()) {
            Vector vector = this.dataVector.elementAt(this.actualRow(n2));
            if (vector == null || n3 >= vector.size()) {
                return null;
            }
            Object e2 = vector.elementAt(n3);
            if (e2 instanceof MultiValuedCell) {
                return ((MultiValuedCell)e2).getSelectedItem();
            }
            return e2;
        }
        return null;
    }

    public Vector getValuesAt(int n2, int n3) {
        if (n2 > -1 && n3 > -1 && n2 < this.getRowCount() && n3 < this.getColumnCount()) {
            Vector vector = this.dataVector.elementAt(this.actualRow(n2));
            if (vector == null || n3 >= vector.size()) {
                return null;
            }
            Object e2 = vector.elementAt(n3);
            if (e2 instanceof MultiValuedCell) {
                return ((MultiValuedCell)e2).getValues();
            }
            Vector vector2 = new Vector(1);
            vector2.addElement(e2);
            return vector2;
        }
        return null;
    }

    public void setSelectedIndexAt(int n2, int n3, int n4) {
        Vector vector = this.dataVector.elementAt(this.actualRow(n3));
        if (vector == null || n4 >= vector.size()) {
            return;
        }
        Object e2 = vector.elementAt(n4);
        if (e2 instanceof MultiValuedCell && n2 != ((MultiValuedCell)e2).getSelectedIndex()) {
            ((MultiValuedCell)e2).setSelectedIndex(n2);
            this.fireTableCellUpdated(n3, n4);
        }
    }

    public int getSelectedIndexAt(int n2, int n3) {
        Vector vector = this.dataVector.elementAt(this.actualRow(n2));
        if (vector == null || n3 >= vector.size()) {
            return -1;
        }
        Object e2 = vector.elementAt(n3);
        if (e2 instanceof MultiValuedCell) {
            return ((MultiValuedCell)e2).getSelectedIndex();
        }
        return -1;
    }

    public void setValueAt(Object object, int n2, int n3) {
        Vector vector = this.dataVector.elementAt(this.actualRow(n2));
        Object e2 = vector.elementAt(n3);
        if (e2 != null && e2.equals(object)) {
            return;
        }
        if (e2 != null && e2 instanceof MultiValuedCell) {
            if (object != null) {
                if (object.getClass().isArray()) {
                    ((MultiValuedCell)e2).setValues(DefaultTableModel.convertToVector((Object[])object));
                } else if (object instanceof Vector) {
                    ((MultiValuedCell)e2).setValues((Vector)object);
                } else {
                    ((MultiValuedCell)e2).setSelectedItem(object);
                }
            }
        } else if (vector != null && vector.size() > n3) {
            vector.setElementAt(object, n3);
        }
        this.clearSort(n3);
        this.fireTableCellUpdated(n2, n3);
    }

    public Class getColumnClass(int n2) {
        if (n2 > this.getColumnCount() - 1) {
            return AssistManager.getClass("Object");
        }
        return (Class)this.columnClasses.elementAt(n2);
    }

    public void setColumnClass(Class clazz, int n2) {
        if (n2 > this.getColumnCount() - 1) {
            return;
        }
        this.columnClasses.setElementAt(clazz, n2);
    }

    protected void configureRowIndexes(int n2) {
        if (this.rowIndexes == null) {
            this.rowIndexes = new AssistIndex(n2, 10);
            this.rowIndexes.setSize(n2);
        } else {
            this.rowIndexes.setSize(n2);
        }
        int n3 = n2 - 1;
        while (n3 >= 0) {
            this.rowIndexes.setIntAt(n3, n3);
            --n3;
        }
    }

    protected void configureColumns(int n2) {
        this.columnClasses = new Vector(n2);
        this.editableFlags = new BitSet(n2);
        Class clazz = AssistManager.getClass("Object");
        int n3 = 0;
        while (n3 < n2) {
            this.columnClasses.addElement(clazz);
            this.editableFlags.clear(n3);
            ++n3;
        }
        this.configureIndexes(n2);
    }

    protected void configureIndexes(int n2) {
        this.savedIndex = new AssistIndex[n2];
        this.savedKeys = new AssistKey[n2][0];
        this.sortOrder = new AssistIndex(n2);
        this.prevSortColumn = -1;
        int n3 = 0;
        while (n3 < n2) {
            this.sortOrder.addInt(1);
            this.savedKeys[n3] = null;
            ++n3;
        }
    }

    public void setColumns(String[] stringArray) {
        this.setColumnIdentifiers(DefaultTableModel.convertToVector(stringArray));
        this.configureColumns(stringArray.length);
    }

    public void setDataVector(Vector vector, Vector vector2) {
        super.setDataVector(vector, vector2);
        this.configureRowIndexes(vector.size());
    }

    /*
     * Unable to fully structure code
     */
    public void setNumRows(int var1_1) {
        block2: {
            if (var1_1 < 0 || var1_1 == this.getRowCount()) {
                return;
            }
            super.setNumRows(var1_1);
            var2_2 = this.rowIndexes.size();
            if (var1_1 > var2_2) ** GOTO lbl9
            this.rowIndexes.setSize(var1_1);
            break block2;
lbl-1000:
            // 1 sources

            {
                this.rowIndexes.addInt(var2_2++);
lbl9:
                // 2 sources

                ** while (this.rowIndexes.size() < var1_1)
            }
        }
        this.configureIndexes(this.getColumnCount());
    }

    public void setDataArray(Object[][] objectArray) {
        this.setData(DefaultTableModel.convertToVector(objectArray));
    }

    public void setData(Vector vector) {
        this.dataVector = vector;
        this.replaceMultiValuedCellsInTable(this.dataVector);
        this.configureRowIndexes(vector.size());
        this.fireTableDataChanged();
    }

    protected void replaceMultiValuedCellsInTable(Vector vector) {
        int n2 = 0;
        while (n2 < vector.size()) {
            Vector vector2 = (Vector)vector.elementAt(n2);
            if (vector2 != null) {
                this.replaceMultiValuedCellsInRow(vector2);
            }
            ++n2;
        }
    }

    protected void replaceMultiValuedCellsInRow(Vector vector) {
        int n2 = 0;
        while (n2 < vector.size()) {
            Object e2 = vector.elementAt(n2);
            if (e2 != null) {
                if (e2.getClass().isArray() && !e2.getClass().getComponentType().isPrimitive()) {
                    vector.setElementAt(new MultiValuedCell(DefaultTableModel.convertToVector((Object[])vector.elementAt(n2))), n2);
                } else if (vector.elementAt(n2) instanceof Vector) {
                    vector.setElementAt(new MultiValuedCell((Vector)vector.elementAt(n2)), n2);
                }
            }
            ++n2;
        }
    }

    public Vector getData() {
        if (this.sorted) {
            Vector<Vector> vector = new Vector<Vector>();
            int n2 = this.rowIndexes.size();
            int n3 = 0;
            while (n3 < n2) {
                vector.addElement(this.dataVector.elementAt(this.rowIndexes.intAt(n3)));
                ++n3;
            }
            return vector;
        }
        return this.dataVector;
    }

    public Object[] getRowArray(int n2) {
        if (this.getRowCount() > n2) {
            return AssistTableModel.convertRowToArray(this.dataVector.elementAt(this.actualRow(n2)));
        }
        return null;
    }

    public Vector getRow(int n2) {
        if (this.getRowCount() > n2) {
            return this.dataVector.elementAt(this.actualRow(n2));
        }
        return null;
    }

    public void appendDataArray(Object[][] objectArray, int n2) {
        this.dataVector.setSize(n2);
        int n3 = this.getRowCount();
        if (objectArray != null) {
            int n4 = 0;
            while (n4 < objectArray.length) {
                int n5 = objectArray[n4].length;
                Vector<Object> vector = new Vector<Object>(n5);
                int n6 = 0;
                while (n6 < n5) {
                    vector.addElement(objectArray[n4][n6]);
                    ++n6;
                }
                this.replaceMultiValuedCellsInRow(vector);
                this.dataVector.addElement(vector);
                ++n4;
            }
            int n7 = n3;
            while (n7 < n3 + objectArray.length) {
                this.rowIndexes.addInt(n7);
                ++n7;
            }
        }
        this.configureIndexes(this.getColumnCount());
        this.fireTableRowsInserted(n3, this.getRowCount() - 1);
    }

    public void replaceRow(int n2, Object[] objectArray) {
        Vector<Object> vector = null;
        if (objectArray != null) {
            vector = DefaultTableModel.convertToVector(objectArray);
        }
        this.replaceRow(n2, vector);
    }

    public void replaceRow(int n2, Vector vector) {
        if (vector == null) {
            vector = new Vector(this.getColumnCount());
        } else {
            vector.setSize(this.getColumnCount());
        }
        this.replaceMultiValuedCellsInRow(vector);
        int n3 = this.actualRow(n2);
        this.dataVector.setElementAt(vector, n3);
        this.fireTableRowsUpdated(n3, n3);
    }

    public void moveUpARow(int n2) {
        if (n2 > 0 && n2 < this.getRowCount()) {
            if (!this.sorted) {
                this.setSorted(true);
            }
            this.rowIndexes.swap(n2, n2 - 1);
            this.fireTableChanged(new TableModelEvent(this, n2, n2 - 1, -1, -10));
        }
    }

    public void moveDownARow(int n2) {
        if (n2 > -1 && n2 < this.getRowCount() - 1) {
            if (!this.sorted) {
                this.setSorted(true);
            }
            this.rowIndexes.swap(n2, n2 + 1);
            this.fireTableChanged(new TableModelEvent(this, n2, n2 + 1, -1, 10));
        }
    }

    public void removeRow(int n2) {
        this.dataVector.removeElementAt(this.actualRow(n2));
        this.rowIndexes.removeIntAt(n2);
        this.fireTableRowsDeleted(n2, n2);
    }

    protected void printIndexes() {
        System.out.println(this.rowIndexes.toString());
    }

    public void clear() {
        int n2 = this.getRowCount();
        if (n2 > 0) {
            this.dataVector.removeAllElements();
            this.rowIndexes.setSize(0);
            this.fireTableRowsDeleted(0, n2 - 1);
        }
    }

    public void clearReset() {
        this.rowIndexes.removeAllInts();
        this.dataVector.removeAllElements();
        this.columnIdentifiers = new Vector(1);
        this.fireTableStructureChanged();
    }

    public boolean contains(Object object, int n2) {
        String string = object.toString();
        Enumeration<Vector> enumeration = this.dataVector.elements();
        while (enumeration.hasMoreElements()) {
            Vector vector = enumeration.nextElement();
            if (!AssistManager.equal(vector.elementAt(n2).toString(), string)) continue;
            return true;
        }
        return false;
    }

    public int find(String string, int n2) {
        String string2 = string.toString();
        if (this.sorted) {
            int n3 = 0;
            while (n3 < this.rowIndexes.size()) {
                Vector vector = this.dataVector.elementAt(this.actualRow(n3));
                if (AssistManager.equal(vector.elementAt(n2).toString(), string2)) {
                    return n3;
                }
                ++n3;
            }
        } else {
            int n4 = 0;
            Enumeration<Vector> enumeration = this.dataVector.elements();
            while (enumeration.hasMoreElements()) {
                Vector vector = enumeration.nextElement();
                if (AssistManager.equal(vector.elementAt(n2).toString(), string2)) {
                    return n4;
                }
                ++n4;
            }
        }
        return -1;
    }

    protected static Object[] convertRowToArray(Vector vector) {
        if (vector == null) {
            return null;
        }
        Object[] objectArray = new Object[vector.size()];
        int n2 = 0;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            objectArray[n2] = enumeration.nextElement();
            ++n2;
        }
        return objectArray;
    }

    public void setColEditable(int n2, boolean bl) {
        if (bl) {
            this.editableFlags.set(n2);
        } else {
            this.editableFlags.clear(n2);
        }
    }

    public boolean isColEditable(int n2) {
        return this.editableFlags.get(n2);
    }

    public void setFirstEditableRow(int n2) {
        this.firstEditableRow = this.actualRow(n2);
    }

    public int getFirstEditableRow() {
        return this.firstEditableRow;
    }

    public void setTrailingNonEditableRows(int n2) {
        this.trailingNonEditableRows = n2;
    }

    public int getTrailingNonEditableRows() {
        return this.trailingNonEditableRows;
    }

    public boolean isRowEditable(int n2) {
        int n3 = this.actualRow(n2);
        return n3 >= this.firstEditableRow && n3 < super.getRowCount() - this.trailingNonEditableRows;
    }

    public boolean isCellEditable(int n2, int n3) {
        if (n3 < this.columnIdentifiers.size()) {
            int n4 = this.actualRow(n2);
            if (this.isRowEditable(n4)) {
                boolean bl = this.editableFlags.get(n3);
                if (bl && this.getColumnClass(n3) == (class$java$util$Vector == null ? (class$java$util$Vector = AssistTableModel.class$("java.util.Vector")) : class$java$util$Vector) && !(this.dataVector.elementAt(n4).elementAt(n3) instanceof MultiValuedCell)) {
                    bl = false;
                }
                return bl;
            }
            return false;
        }
        return false;
    }

    public int actualRow(int n2) {
        if (this.sorted && n2 > -1 && n2 < this.rowIndexes.size()) {
            return this.rowIndexes.intAt(n2);
        }
        return n2;
    }

    public int visualRow(int n2) {
        if (this.sorted && n2 > -1 && n2 < this.rowIndexes.size()) {
            return this.rowIndexes.positionOf(n2);
        }
        return n2;
    }

    public void setSorted(boolean bl) {
        this.sorted = bl;
        if (this.sorted && theCollator == null) {
            theCollator = (AssistCollator)AssistCollator.getInstance();
        }
        if (!bl) {
            this.configureRowIndexes(this.getRowCount());
        }
    }

    public boolean getSorted() {
        return this.sorted;
    }

    public void setSortAlgorithm(int n2) {
        this.sortAlgorithm = n2;
        this.rowIndexes = null;
        this.configureRowIndexes(this.getRowCount());
        this.configureIndexes(this.getColumnCount());
    }

    public void clearSort(int n2) {
        if (this.prevSortColumn == n2) {
            this.prevSortColumn = -1;
        }
        this.savedIndex[n2] = null;
        this.savedKeys[n2] = null;
    }

    public void sort(int n2, int n3) {
        if (this.sortSequence == null || this.sortSequence.length > 1) {
            this.sortSequence = new int[1];
            this.sortDirection = new int[1];
        }
        this.sortSequence[0] = n3;
        this.sortDirection[0] = n2;
        this.sortData();
        this.fireTableRowsUpdated(0, this.getRowCount() - 1);
    }

    public void multiColumnSort(int[] nArray, int[] nArray2) {
        this.sortSequence = nArray;
        this.sortDirection = nArray2;
        this.sortData();
        this.sortSequence = null;
        this.sortDirection = null;
        this.fireTableRowsUpdated(0, this.getRowCount() - 1);
    }

    public synchronized void sortData() {
        int n2 = this.dataVector.size();
        if (n2 < 2) {
            return;
        }
        int n3 = -1;
        if (this.prevSortColumn != -1) {
            n3 = this.sortOrder.intAt(this.prevSortColumn);
        }
        if (this.sortSequence[0] == this.prevSortColumn && this.sortSequence.length == 1 && this.savedIndex[this.prevSortColumn] != null) {
            if (this.sortDirection[0] == n3) {
                return;
            }
            if (this.sortDirection[0] == 1) {
                this.configureRowIndexes(this.getRowCount());
            } else {
                if (n3 == 1) {
                    this.rowIndexes = (AssistIndex)this.savedIndex[this.prevSortColumn].clone();
                }
                if (this.sortDirection[0] == 256) {
                    this.rowIndexes.setDescending(true);
                } else {
                    this.rowIndexes.setDescending(false);
                }
            }
            this.sortOrder.setIntAt(this.sortDirection[0], this.prevSortColumn);
            return;
        }
        this.sortOrder.setIntAt(this.sortDirection[0], this.sortSequence[0]);
        if (this.sortDirection[0] == 1) {
            this.configureRowIndexes(this.getRowCount());
        } else {
            Object object;
            if (this.savedIndex[this.sortSequence[0]] != null && this.sortSequence.length == 1) {
                this.rowIndexes = (AssistIndex)this.savedIndex[this.sortSequence[0]].clone();
                if (this.sortDirection[0] == 256) {
                    this.rowIndexes.setDescending(true);
                } else {
                    this.rowIndexes.setDescending(false);
                }
                this.prevSortColumn = this.sortSequence[0];
                return;
            }
            int[] nArray = null;
            int n4 = this.prevSortColumn;
            if (this.sortSequence != null) {
                if (this.keys == null || this.keys[0].length != this.sortSequence.length) {
                    this.keys = new AssistKey[n2][this.sortSequence.length];
                }
                int n5 = 0;
                while (n5 < this.sortSequence.length) {
                    int n6;
                    if (this.savedKeys[this.sortSequence[n5]] != null) {
                        n6 = n2 - 1;
                        while (n6 >= 0) {
                            this.keys[n6][n5] = this.savedKeys[this.sortSequence[n5]][n6];
                            --n6;
                        }
                    } else {
                        this.savedKeys[this.sortSequence[n5]] = new AssistKey[n2];
                        n6 = n2 - 1;
                        while (n6 >= 0) {
                            object = this.dataVector.elementAt(n6).elementAt(this.sortSequence[n5]);
                            this.keys[n6][n5] = theCollator.getCollationKey(object, n6);
                            this.savedKeys[this.sortSequence[n5]][n6] = this.keys[n6][n5];
                            --n6;
                        }
                    }
                    ++n5;
                }
                if (this.sortAlgorithm == 2) {
                    AssistIndex assistIndex = null;
                    assistIndex = n4 > -1 && this.savedIndex[n4] != null ? this.savedIndex[n4] : this.rowIndexes;
                    nArray = assistIndex.getIntArray();
                }
            } else {
                object = null;
                object = n4 > -1 && this.savedIndex[n4] != null ? this.savedIndex[n4] : this.rowIndexes;
                nArray = object.getIntArray();
                if (this.keys == null || this.keys[0].length != 1) {
                    this.keys = new AssistKey[n2][1];
                }
                this.savedKeys[this.sortSequence[0]] = new AssistKey[n2];
                int n7 = n2 - 1;
                while (n7 >= 0) {
                    Object e2 = this.dataVector.elementAt(nArray[n7]).elementAt(this.sortSequence[0]);
                    this.keys[n7][0] = theCollator.getCollationKey(e2, nArray[n7]);
                    this.savedKeys[this.sortSequence[0]][n7] = this.keys[n7][0];
                    --n7;
                }
            }
            this.rowIndexes.setDescending(false);
            if (this.sortAlgorithm == 4) {
                object = new AssistKey[n2][0];
                System.arraycopy(this.keys, 0, object, 0, n2);
                this.msort((AssistKey[][])object, this.keys, 0, n2);
                int n8 = 0;
                while (n8 < n2) {
                    this.rowIndexes.setIntAt(this.keys[n8][0].getSourceIndex(), n8);
                    ++n8;
                }
            } else if (this.sortAlgorithm == 1) {
                object = new AssistKey[n2][0];
                System.arraycopy(this.keys, 0, object, 0, n2);
                this.shuttleSort((AssistKey[][])object, this.keys, 0, n2);
                int n9 = 0;
                while (n9 < n2) {
                    this.rowIndexes.setIntAt(this.keys[n9][0].getSourceIndex(), n9);
                    ++n9;
                }
            } else if (this.sortAlgorithm == 5) {
                this.qsort(this.keys, 0, n2);
                int n10 = 0;
                while (n10 < n2) {
                    this.rowIndexes.setIntAt(this.keys[n10][0].getSourceIndex(), n10);
                    ++n10;
                }
            } else if (this.sortAlgorithm != 0) {
                if (this.sortAlgorithm == 2) {
                    object = new int[n2];
                    System.arraycopy(nArray, 0, object, 0, n2);
                    this.shuttleSlow((int[])object, nArray, 0, n2, this.sortSequence[0]);
                    this.rowIndexes.setIntArray(nArray);
                } else if (this.sortAlgorithm == 3) {
                    this.shellSort(this.keys, 0, n2);
                    int n11 = 0;
                    while (n11 < n2) {
                        this.rowIndexes.setIntAt(this.keys[n11][0].getSourceIndex(), n11);
                        ++n11;
                    }
                } else if (this.sortAlgorithm == 6) {
                    this.insertionSort(0, n2 - 1);
                    int n12 = 0;
                    while (n12 < n2) {
                        this.rowIndexes.setIntAt(this.keys[n12][0].getSourceIndex(), n12);
                        ++n12;
                    }
                }
            }
            if (this.sortDirection[0] == 256) {
                this.rowIndexes.setDescending(true);
            }
            this.savedIndex[this.sortSequence[0]] = (AssistIndex)this.rowIndexes.clone();
        }
        this.prevSortColumn = this.sortSequence[0];
    }

    protected int compare(AssistKey[] assistKeyArray, AssistKey[] assistKeyArray2) {
        int n2 = assistKeyArray.length;
        int n3 = 0;
        int n4 = assistKeyArray[0].compareTo(assistKeyArray2[0]);
        while (n4 == 0 && ++n3 < n2) {
            n4 = assistKeyArray[n3].compareTo(assistKeyArray2[n3]);
        }
        if (n3 == 0 || n4 == 0) {
            return n4;
        }
        return this.sortDirection[n3] == this.sortDirection[0] ? n4 : n4 * -1;
    }

    protected void insertionSort(int n2, int n3) {
        int n4 = n2 + 1;
        while (n4 <= n3) {
            AssistKey[] assistKeyArray = this.keys[n4];
            int n5 = n4;
            while (n5 > n2 && this.compare(this.keys[n5 - 1], assistKeyArray) > 0) {
                this.keys[n5] = this.keys[n5 - 1];
                --n5;
            }
            if (n5 < n4) {
                this.keys[n5] = assistKeyArray;
            }
            ++n4;
        }
    }

    protected void shuttleSort(AssistKey[][] assistKeyArray, AssistKey[][] assistKeyArray2, int n2, int n3) {
        int n4 = n3 - n2;
        if (n4 < 2) {
            return;
        }
        int n5 = (n2 + n3) / 2;
        this.shuttleSort(assistKeyArray2, assistKeyArray, n2, n5);
        this.shuttleSort(assistKeyArray2, assistKeyArray, n5, n3);
        if (n3 - n2 >= 4 && this.compare(assistKeyArray[n5 - 1], assistKeyArray[n5]) <= 0) {
            System.arraycopy(assistKeyArray, n2, assistKeyArray2, n2, n4);
            return;
        }
        int n6 = n2;
        int n7 = n5;
        int n8 = n2;
        while (n8 < n3) {
            assistKeyArray2[n8] = n7 >= n3 || n6 < n5 && this.compare(assistKeyArray[n6], assistKeyArray[n7]) <= 0 ? assistKeyArray[n6++] : assistKeyArray[n7++];
            ++n8;
        }
    }

    protected void shuttleSlow(int[] nArray, int[] nArray2, int n2, int n3, int n4) {
        if (n3 - n2 < 2) {
            return;
        }
        int n5 = (n2 + n3) / 2;
        this.shuttleSlow(nArray2, nArray, n2, n5, n4);
        this.shuttleSlow(nArray2, nArray, n5, n3, n4);
        if (n3 - n2 >= 4 && this.slowCompare(nArray[n5 - 1], nArray[n5], n4) <= 0) {
            int n6 = n2;
            while (n6 < n3) {
                nArray2[n6] = nArray[n6];
                ++n6;
            }
            return;
        }
        int n7 = n2;
        int n8 = n5;
        int n9 = n2;
        while (n9 < n3) {
            nArray2[n9] = n8 >= n3 || n7 < n5 && this.slowCompare(nArray[n7], nArray[n8], n4) <= 0 ? nArray[n7++] : nArray[n8++];
            ++n9;
        }
    }

    public int slowCompare(int n2, int n3, int n4) {
        Class clazz = this.getColumnClass(n4);
        Object object = this.getValueAt(n2, n4);
        Object object2 = this.getValueAt(n3, n4);
        if (object == null && object2 == null) {
            return 0;
        }
        if (object == null) {
            return -1;
        }
        if (object2 == null) {
            return 1;
        }
        if (clazz.getSuperclass() == AssistManager.getClass("Number")) {
            double d2 = 0.0;
            double d3 = 0.0;
            if (object instanceof Number && object2 instanceof Number) {
                d2 = ((Number)object).doubleValue();
                if (d2 < (d3 = ((Number)object2).doubleValue())) {
                    return -1;
                }
                if (d2 > d3) {
                    return 1;
                }
                return 0;
            }
            if (object instanceof String && object2 instanceof Number) {
                String string = "";
                try {
                    d3 = ((Number)object2).doubleValue();
                    string = new Double(d3).toString();
                }
                catch (Throwable throwable) {
                    System.out.println("No doubleValue");
                }
                return theCollator.compare((String)object, string);
            }
            if (object instanceof Number && object2 instanceof String) {
                String string = "";
                try {
                    d2 = ((Number)object).doubleValue();
                    string = new Double(d2).toString();
                }
                catch (Throwable throwable) {
                    System.out.println("No doubleValue");
                }
                return theCollator.compare(string, (String)object2);
            }
            return theCollator.compare((String)object, (String)object2);
        }
        if (clazz == (class$java$util$Date == null ? (class$java$util$Date = AssistTableModel.class$("java.util.Date")) : class$java$util$Date)) {
            Date date;
            long l2;
            Date date2 = (Date)object;
            long l3 = date2.getTime();
            if (l3 < (l2 = (date = (Date)object2).getTime())) {
                return -1;
            }
            if (l3 > l2) {
                return 1;
            }
            return 0;
        }
        if (clazz == AssistManager.getClass("String")) {
            String string = object.toString();
            String string2 = object2.toString();
            return theCollator.compare(string, string2);
        }
        if (clazz == AssistManager.getClass("Boolean")) {
            Boolean bl;
            boolean bl2;
            Boolean bl3 = (Boolean)object;
            boolean bl4 = bl3;
            if (bl4 == (bl2 = (bl = (Boolean)object2).booleanValue())) {
                return 0;
            }
            if (bl4) {
                return 1;
            }
            return -1;
        }
        Object object3 = object;
        String string = object3.toString();
        Object object4 = object2;
        String string3 = object4.toString();
        return theCollator.compare(string, string3);
    }

    public void shellSort(AssistKey[][] assistKeyArray, int n2, int n3) {
        int n4 = n3 - n2;
        int n5 = 1;
        while (n5 <= n4 / 3) {
            n5 = n5 * 3 + 1;
        }
        while (n5 > 0) {
            int n6 = n5;
            while (n6 < n4) {
                AssistKey[] assistKeyArray2 = assistKeyArray[n6 + n2];
                int n7 = n6 + n2;
                while (n7 > n5 - 1 && this.compare(assistKeyArray[n7 - n5], assistKeyArray[n6 + n2]) >= 0) {
                    assistKeyArray[n7] = assistKeyArray[n7 - n5];
                    n7 -= n5;
                }
                assistKeyArray[n7] = assistKeyArray2;
                ++n6;
            }
            n5 = (n5 - 1) / 3;
        }
    }

    private void msort(AssistKey[][] assistKeyArray, AssistKey[][] assistKeyArray2, int n2, int n3) {
        int n4 = n3 - n2;
        if (n4 < 7) {
            int n5 = n2 + 1;
            while (n5 < n3) {
                AssistKey[] assistKeyArray3 = assistKeyArray2[n5];
                int n6 = n5;
                while (n6 > n2 && this.compare(assistKeyArray2[n6 - 1], assistKeyArray3) > 0) {
                    assistKeyArray2[n6] = assistKeyArray2[n6 - 1];
                    --n6;
                }
                if (n6 != n5) {
                    assistKeyArray2[n6] = assistKeyArray3;
                }
                ++n5;
            }
            return;
        }
        int n7 = (n2 + n3) / 2;
        this.msort(assistKeyArray2, assistKeyArray, n2, n7);
        this.msort(assistKeyArray2, assistKeyArray, n7, n3);
        if (this.compare(assistKeyArray[n7 - 1], assistKeyArray[n7]) <= 0) {
            System.arraycopy(assistKeyArray, n2, assistKeyArray2, n2, n4);
            return;
        }
        int n8 = n2;
        int n9 = n2;
        int n10 = n7;
        while (n8 < n3) {
            assistKeyArray2[n8] = n10 >= n3 || n9 < n7 && this.compare(assistKeyArray[n9], assistKeyArray[n10]) <= 0 ? assistKeyArray[n9++] : assistKeyArray[n10++];
            ++n8;
        }
    }

    protected void qsort(AssistKey[][] assistKeyArray, int n2, int n3) {
        int n4;
        int n5;
        int n6;
        if (n3 < 7) {
            int n7 = n2;
            while (n7 < n3 + n2) {
                int n8 = n7;
                while (n8 > n2 && this.compare(assistKeyArray[n8 - 1], assistKeyArray[n8]) > 0) {
                    this.swap(assistKeyArray, n8, n8 - 1);
                    --n8;
                }
                ++n7;
            }
            return;
        }
        int n9 = n2 + n3 / 2;
        if (n3 > 7) {
            int n10 = n2;
            n6 = n2 + n3 - 1;
            if (n3 > 40) {
                n5 = n3 / 8;
                n10 = this.med3(assistKeyArray, n10, n10 + n5, n10 + 2 * n5);
                n9 = this.med3(assistKeyArray, n9 - n5, n9, n9 + n5);
                n6 = this.med3(assistKeyArray, n6 - 2 * n5, n6 - n5, n6);
            }
            n9 = this.med3(assistKeyArray, n10, n9, n6);
        }
        AssistKey[] assistKeyArray2 = assistKeyArray[n9];
        n5 = n6 = n2;
        int n11 = n4 = n2 + n3 - 1;
        while (true) {
            if (n5 <= n4 && this.compare(assistKeyArray[n5], assistKeyArray2) <= 0) {
                if (this.compare(assistKeyArray[n5], assistKeyArray2) == 0) {
                    this.swap(assistKeyArray, n6++, n5);
                }
                ++n5;
                continue;
            }
            while (n4 >= n5 && this.compare(assistKeyArray[n4], assistKeyArray2) >= 0) {
                if (this.compare(assistKeyArray[n4], assistKeyArray2) == 0) {
                    this.swap(assistKeyArray, n4, n11--);
                }
                --n4;
            }
            if (n5 > n4) break;
            this.swap(assistKeyArray, n5++, n4--);
        }
        int n12 = n2 + n3;
        int n13 = Math.min(n6 - n2, n5 - n6);
        this.vecswap(assistKeyArray, n2, n5 - n13, n13);
        n13 = Math.min(n11 - n4, n12 - n11 - 1);
        this.vecswap(assistKeyArray, n5, n12 - n13, n13);
        n13 = n5 - n6;
        if (n13 > 1) {
            this.qsort(assistKeyArray, n2, n13);
        }
        if ((n13 = n11 - n4) > 1) {
            this.qsort(assistKeyArray, n12 - n13, n13);
        }
    }

    private void swap(AssistKey[][] assistKeyArray, int n2, int n3) {
        AssistKey[] assistKeyArray2 = assistKeyArray[n2];
        assistKeyArray[n2] = assistKeyArray[n3];
        assistKeyArray[n3] = assistKeyArray2;
    }

    private void vecswap(AssistKey[][] assistKeyArray, int n2, int n3, int n4) {
        int n5 = 0;
        while (n5 < n4) {
            this.swap(assistKeyArray, n2, n3);
            ++n5;
            ++n2;
            ++n3;
        }
    }

    private int med3(AssistKey[][] assistKeyArray, int n2, int n3, int n4) {
        return this.compare(assistKeyArray[n2], assistKeyArray[n3]) < 0 ? (this.compare(assistKeyArray[n3], assistKeyArray[n4]) < 0 ? n3 : (this.compare(assistKeyArray[n2], assistKeyArray[n4]) < 0 ? n4 : n2)) : (this.compare(assistKeyArray[n3], assistKeyArray[n4]) > 0 ? n3 : (this.compare(assistKeyArray[n2], assistKeyArray[n4]) > 0 ? n4 : n2));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

