/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common.support;

import com.ibm.db2.tools.common.CmStringPool;
import com.ibm.db2.tools.common.support.ArrowheadIcon;
import com.ibm.db2.tools.common.support.AssistManager;
import com.ibm.db2.tools.common.support.DashedBorder;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.Serializable;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleStateSet;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;

public class AssistTableHeaderRenderer
extends JPanel
implements TableCellRenderer,
Serializable {
    private static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected JLabel label;
    protected JLabel sortOrder;
    protected JPanel directionPanel;
    protected CardLayout cardLayout;
    protected int sort;
    protected int indicators;
    protected boolean showIndicators;
    protected Border normalBorder;
    protected Border focusBorder;

    public AssistTableHeaderRenderer() {
        this(0, false);
    }

    public AssistTableHeaderRenderer(int n2, boolean bl) {
        super(new GridBagLayout());
        this.indicators = n2;
        this.showIndicators = bl;
        this.label = this.createLabel("", null);
        this.sortOrder = this.createLabel("", null);
        this.sortOrder.getAccessibleContext().setAccessibleDescription(CmStringPool.get(430));
        this.constructIndicators();
        this.focusBorder = BorderFactory.createCompoundBorder(UIManager.getBorder("TableHeader.cellBorder"), DashedBorder.createBlackDashedBorder());
        this.normalBorder = BorderFactory.createCompoundBorder(UIManager.getBorder("TableHeader.cellBorder"), BorderFactory.createEmptyBorder(1, 1, 1, 1));
    }

    protected void constructIndicators() {
        if (this.getComponentCount() > 0) {
            this.removeAll();
        }
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        if (this.showIndicators && this.indicators > 0) {
            AssistManager.setGridBagConstraints(gridBagConstraints, -1, -1, 1, 1, 2, new Insets(0, 0, 0, 0), -1, 1.0, 0.0);
            this.add((Component)this.label, gridBagConstraints);
            AssistManager.setGridBagConstraints(gridBagConstraints2, -1, -1, 1, 1, 2, new Insets(0, 0, 0, 0), -1, 0.0, 0.0);
            this.add((Component)this.sortOrder, gridBagConstraints2);
            this.cardLayout = new CardLayout();
            this.directionPanel = new JPanel(this.cardLayout);
            JLabel jLabel = null;
            int n2 = 3;
            if ((this.indicators & 0x10) > 0 && (this.indicators & 0x100) > 0) {
                JLabel jLabel2 = this.createLabel(null, new ArrowheadIcon(true, true, true, 1, n2, false));
                jLabel2.getAccessibleContext().setAccessibleName(CmStringPool.get(424));
                jLabel2.getAccessibleContext().setAccessibleDescription(CmStringPool.get(425));
                this.directionPanel.add((Component)jLabel2, "unsorted");
                jLabel2 = this.createLabel(null, new ArrowheadIcon(true, true, true, 16, n2, false));
                jLabel2.getAccessibleContext().setAccessibleName(CmStringPool.get(426));
                jLabel2.getAccessibleContext().setAccessibleDescription(CmStringPool.get(427));
                this.directionPanel.add((Component)jLabel2, "ascending");
                jLabel2 = this.createLabel(null, new ArrowheadIcon(true, true, true, 256, n2, false));
                jLabel2.getAccessibleContext().setAccessibleName(CmStringPool.get(428));
                jLabel2.getAccessibleContext().setAccessibleDescription(CmStringPool.get(429));
                this.directionPanel.add((Component)jLabel2, "descending");
                jLabel = this.createLabel(null, new ArrowheadIcon(true, true, true));
            } else if ((this.indicators & 0x10) > 0) {
                JLabel jLabel3 = this.createLabel(null, new ArrowheadIcon(true, false, true, 1, n2, false));
                jLabel3.getAccessibleContext().setAccessibleName(CmStringPool.get(424));
                jLabel3.getAccessibleContext().setAccessibleDescription(CmStringPool.get(425));
                this.directionPanel.add((Component)jLabel3, "unsorted");
                jLabel3 = this.createLabel(null, new ArrowheadIcon(true, false, true, 16, n2, false));
                jLabel3.getAccessibleContext().setAccessibleName(CmStringPool.get(426));
                jLabel3.getAccessibleContext().setAccessibleDescription(CmStringPool.get(427));
                this.directionPanel.add((Component)jLabel3, "ascending");
                jLabel = this.createLabel(null, new ArrowheadIcon(true, false, true));
            } else if ((this.indicators & 0x100) > 0) {
                JLabel jLabel4 = this.createLabel(null, new ArrowheadIcon(false, false, true, 1, n2, false));
                jLabel4.getAccessibleContext().setAccessibleName(CmStringPool.get(424));
                jLabel4.getAccessibleContext().setAccessibleDescription(CmStringPool.get(425));
                this.directionPanel.add((Component)jLabel4, "unsorted");
                jLabel4 = this.createLabel(null, new ArrowheadIcon(false, false, true, 256, n2, false));
                jLabel4.getAccessibleContext().setAccessibleName(CmStringPool.get(428));
                jLabel4.getAccessibleContext().setAccessibleDescription(CmStringPool.get(429));
                this.directionPanel.add((Component)jLabel4, "descending");
                jLabel = this.createLabel(null, new ArrowheadIcon(false, false, true));
            }
            jLabel.setDisabledIcon(jLabel.getIcon());
            jLabel.setEnabled(false);
            this.directionPanel.add((Component)jLabel, "disabled");
            AssistManager.setGridBagConstraints(gridBagConstraints, -1, -1, 1, 1, 3, new Insets(0, 0, 0, 1), -1, 0.0, 1.0);
            this.add((Component)this.directionPanel, gridBagConstraints);
            this.setSort(1);
        } else {
            AssistManager.setGridBagConstraints(gridBagConstraints, -1, -1, 1, 1, 2, new Insets(0, 0, 0, 0), -1, 1.0, 0.0);
            this.add((Component)this.label, gridBagConstraints);
            this.setSort(this.indicators);
        }
    }

    public void showSortableIndicators(boolean bl) {
        if (this.showIndicators != bl) {
            this.showIndicators = bl;
            this.constructIndicators();
        }
    }

    public int getSortableIndicators() {
        return this.indicators;
    }

    protected JLabel createLabel(String string, ArrowheadIcon arrowheadIcon) {
        JLabel jLabel = new JLabel(string);
        if (arrowheadIcon != null) {
            jLabel.setIcon(arrowheadIcon);
        }
        jLabel.setFont(UIManager.getFont("TableHeader.font"));
        jLabel.setForeground(UIManager.getColor("TableHeader.foreground"));
        jLabel.setBackground(UIManager.getColor("TableHeader.background"));
        return jLabel;
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n2, int n3) {
        JTableHeader jTableHeader;
        if (jTable != null && (jTableHeader = jTable.getTableHeader()) != null) {
            this.setForeground(jTableHeader.getForeground());
            this.setBackground(jTableHeader.getBackground());
        }
        this.label.setText(object == null ? "" : object.toString());
        if (bl2) {
            this.setBorder(this.focusBorder);
        } else {
            this.setBorder(this.normalBorder);
        }
        return this;
    }

    public int nextSort() {
        if (this.indicators == 0) {
            return this.indicators;
        }
        int n2 = this.sort;
        switch (this.sort) {
            case 1: {
                if ((this.indicators & 0x10) > 0) {
                    n2 = 16;
                    break;
                }
                n2 = 256;
                break;
            }
            case 16: {
                if ((this.indicators & 0x100) > 0) {
                    n2 = 256;
                    break;
                }
                n2 = 1;
                break;
            }
            case 256: {
                if ((this.indicators & 1) > 0) {
                    n2 = 1;
                    break;
                }
                if ((this.indicators & 0x10) <= 0) break;
                n2 = 16;
            }
        }
        this.setSort(n2);
        return n2;
    }

    public void setSort(int n2) {
        if (this.indicators != 0) {
            this.sort = n2;
            if (this.showIndicators && this.label.isEnabled()) {
                switch (n2) {
                    case 1: {
                        this.cardLayout.show(this.directionPanel, "unsorted");
                        break;
                    }
                    case 16: {
                        this.cardLayout.show(this.directionPanel, "ascending");
                        break;
                    }
                    case 256: {
                        this.cardLayout.show(this.directionPanel, "descending");
                    }
                }
            }
        }
    }

    public void setSortOrdinal(int n2) {
        String string = null;
        if (n2 > 0 && this.indicators != 0) {
            string = new Integer(n2).toString() + " ";
        }
        this.sortOrder.setText(string);
        if (string != null) {
            Dimension dimension = this.sortOrder.getPreferredSize();
            dimension.width = AssistManager.getStringWidth(string, this.sortOrder, this.sortOrder.getFont());
            this.sortOrder.setPreferredSize(dimension);
        }
    }

    public int getState() {
        return this.sort;
    }

    public int getPreferredWidth(FontMetrics fontMetrics, String string) {
        if (string == null) {
            return 40;
        }
        int n2 = fontMetrics.stringWidth(string);
        if (this.showIndicators) {
            n2 += this.directionPanel.getPreferredSize().width + 13;
        }
        return n2;
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        dimension.width -= 2;
        dimension.height -= 2;
        return dimension;
    }

    public void setEnabled(boolean bl) {
        if (bl) {
            this.setSort(this.sort);
        } else if (this.showIndicators && this.directionPanel != null) {
            this.cardLayout.show(this.directionPanel, "disabled");
        }
        this.label.setEnabled(bl);
    }

    public void setHorizontalAlignment(int n2) {
        this.label.setHorizontalAlignment(n2);
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleAssistTableHeaderRenderer();
        }
        return this.accessibleContext;
    }

    protected class AccessibleAssistTableHeaderRenderer
    extends JPanel.AccessibleJPanel
    implements AccessibleAction {
        private static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

        protected AccessibleAssistTableHeaderRenderer() {
            super(AssistTableHeaderRenderer.this);
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.COLUMN_HEADER;
        }

        public AccessibleAction getAccessibleAction() {
            return this;
        }

        public int getAccessibleActionCount() {
            return 1;
        }

        public String getAccessibleActionDescription(int n2) {
            if (n2 == 0) {
                return CmStringPool.get(432);
            }
            return null;
        }

        public boolean doAccessibleAction(int n2) {
            if (n2 == 0) {
                AssistTableHeaderRenderer.this.nextSort();
                return true;
            }
            return false;
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            return accessibleStateSet;
        }
    }
}

