/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common.support;

import com.ibm.db2.tools.common.AssistArea;
import com.ibm.db2.tools.common.AssistCombo;
import com.ibm.db2.tools.common.AssistEllipsis;
import com.ibm.db2.tools.common.AssistField;
import com.ibm.db2.tools.common.AssistPassword;
import com.ibm.db2.tools.common.AssistSpinner;
import com.ibm.db2.tools.common.support.AssistComponent;
import com.ibm.db2.tools.common.support.AssistManager;
import com.ibm.db2.tools.common.support.AssistTableModel;
import java.awt.Component;
import java.io.Serializable;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import javax.swing.text.JTextComponent;

public class AssistTableCellRenderer
extends JLabel
implements TableCellRenderer,
Serializable {
    private static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected JComponent rendComponent;
    protected boolean beep;
    protected Hashtable rendComps;
    protected StringBuffer key;
    protected StringBuffer valbuf;
    protected JTable table = null;

    public AssistTableCellRenderer() {
        this((JComponent)null);
    }

    public AssistTableCellRenderer(JComponent jComponent) {
        this.setOpaque(true);
        this.rendComponent = jComponent;
        if (this.rendComponent instanceof JCheckBox) {
            this.rendComponent.setOpaque(true);
            ((JCheckBox)this.rendComponent).setBorderPainted(true);
        } else if (this.rendComponent instanceof JComboBox) {
            if (this.rendComponent instanceof AssistCombo) {
                ((AssistCombo)this.rendComponent).setNestedBorders(true);
            } else {
                this.rendComponent.setBorder(null);
            }
            ((JComboBox)this.rendComponent).setEditable(false);
        } else if (this.rendComponent instanceof AssistField) {
            ((AssistField)this.rendComponent).setNestedBorders(true);
        } else if (this.rendComponent instanceof AssistPassword) {
            ((AssistPassword)this.rendComponent).setNestedBorders(true);
        } else if (this.rendComponent instanceof AssistArea) {
            ((AssistArea)this.rendComponent).setNestedBorders(true);
        } else if (this.rendComponent instanceof AssistEllipsis) {
            ((AssistEllipsis)this.rendComponent).setNestedBorders(true);
        } else if (this.rendComponent instanceof AssistSpinner) {
            ((AssistSpinner)this.rendComponent).setNestedBorders(true);
            ((AssistSpinner)this.rendComponent).setBorder(null);
        } else {
            this.rendComponent.setBorder(null);
        }
        this.beep = AssistManager.getBeepPolicy();
        this.rendComps = new Hashtable(50);
        this.key = new StringBuffer();
        this.valbuf = new StringBuffer();
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n2, int n3) {
        this.table = jTable;
        int n4 = this.table.convertColumnIndexToModel(n3);
        boolean bl3 = this.table.getModel().isCellEditable(n2, n4);
        int n5 = n2;
        TableModel tableModel = this.table.getModel();
        if (tableModel instanceof AssistTableModel) {
            n5 = ((AssistTableModel)tableModel).actualRow(n5);
        }
        this.key.setLength(0);
        this.key.append(n5).append('.').append(n4);
        JComponent jComponent = (JComponent)this.rendComps.get(this.key.toString());
        if (bl3 && this.rendComponent instanceof AssistField) {
            this.valbuf.setLength(0);
            if (object != null) {
                this.valbuf.append(object.toString());
            }
            if (this.beep) {
                AssistManager.setBeepPolicy(false);
            }
            if (jComponent == null) {
                TableCellEditor tableCellEditor = this.table.getColumnModel().getColumn(n3).getCellEditor();
                if (tableCellEditor == null) {
                    tableCellEditor = this.table.getDefaultEditor(this.table.getColumnClass(n3));
                }
                if ((jComponent = (JComponent)this.table.prepareEditor(tableCellEditor, n2, n3)) instanceof AssistField) {
                    jComponent = ((AssistField)jComponent).getRenderer(true, this.valbuf.toString());
                    ((AssistField)jComponent).verify();
                }
                this.rendComps.put(this.key.toString(), jComponent);
            } else if (jComponent instanceof JTextField && !((JTextField)jComponent).getText().equals(this.valbuf.toString())) {
                ((JTextField)jComponent).setText(this.valbuf.toString());
                if (jComponent instanceof AssistField) {
                    ((AssistField)jComponent).verify();
                }
            }
            this.configureRendererComponent(jComponent, bl, bl2, n2, n3);
            if (this.table.isEnabled() && jComponent instanceof AssistComponent && AssistManager.getErrorBordersPolicy() && !((AssistComponent)((Object)jComponent)).isValueValid()) {
                jComponent.setBorder(AssistManager.getBorder("Assist.nested.error.border"));
            }
            AssistManager.setBeepPolicy(this.beep);
            return jComponent;
        }
        if (bl3 && this.rendComponent instanceof AssistPassword) {
            this.valbuf.setLength(0);
            if (object != null && object instanceof char[]) {
                AssistManager.appendChars((char[])object, this.valbuf);
            } else if (object != null) {
                this.valbuf.append(object.toString());
            }
            if (this.beep) {
                AssistManager.setBeepPolicy(false);
            }
            if (jComponent == null) {
                TableCellEditor tableCellEditor = this.table.getColumnModel().getColumn(n3).getCellEditor();
                if (tableCellEditor == null) {
                    tableCellEditor = this.table.getDefaultEditor(this.table.getColumnClass(n3));
                }
                if ((jComponent = (JComponent)this.table.prepareEditor(tableCellEditor, n2, n3)) instanceof AssistPassword) {
                    jComponent = ((AssistPassword)jComponent).getRenderer(true, this.valbuf.toString());
                    ((AssistPassword)jComponent).verify();
                }
                this.rendComps.put(this.key.toString(), jComponent);
            } else if (jComponent instanceof JPasswordField) {
                ((JTextComponent)((JPasswordField)jComponent)).setText(this.valbuf.toString());
                if (jComponent instanceof AssistPassword) {
                    ((AssistPassword)jComponent).verify();
                }
            }
            this.configureRendererComponent(jComponent, bl, bl2, n2, n3);
            if (this.table.isEnabled() && jComponent instanceof AssistComponent && AssistManager.getErrorBordersPolicy() && !((AssistComponent)((Object)jComponent)).isValueValid()) {
                jComponent.setBorder(AssistManager.getBorder("Assist.nested.error.border"));
            }
            AssistManager.setBeepPolicy(this.beep);
            return jComponent;
        }
        if (bl3 && this.rendComponent instanceof AssistArea) {
            this.valbuf.setLength(0);
            if (object != null) {
                this.valbuf.append(object.toString());
            }
            if (this.beep) {
                AssistManager.setBeepPolicy(false);
            }
            if (jComponent == null) {
                TableCellEditor tableCellEditor = this.table.getColumnModel().getColumn(n3).getCellEditor();
                if (tableCellEditor == null) {
                    tableCellEditor = this.table.getDefaultEditor(this.table.getColumnClass(n3));
                }
                if ((jComponent = (JComponent)this.table.prepareEditor(tableCellEditor, n2, n3)) != null && jComponent instanceof JScrollPane) {
                    jComponent = (JComponent)((JScrollPane)jComponent).getViewport().getView();
                }
                if (jComponent instanceof AssistArea) {
                    jComponent = ((AssistArea)jComponent).clone(this.valbuf.toString());
                    ((AssistArea)jComponent).verify();
                }
                this.rendComps.put(this.key.toString(), jComponent);
            } else if (jComponent instanceof JTextArea && !((JTextArea)jComponent).getText().equals(this.valbuf.toString())) {
                ((JTextArea)jComponent).setText(this.valbuf.toString());
                if (jComponent instanceof AssistArea) {
                    ((AssistArea)jComponent).verify();
                }
            }
            this.configureRendererComponent(jComponent, bl, bl2, n2, n3);
            if (this.table.isEnabled() && jComponent instanceof AssistComponent && AssistManager.getErrorBordersPolicy() && !((AssistComponent)((Object)jComponent)).isValueValid()) {
                jComponent.setBorder(AssistManager.getBorder("Assist.nested.error.border"));
            }
            AssistManager.setBeepPolicy(this.beep);
            if (jComponent instanceof AssistArea) {
                ((AssistArea)jComponent).getScrollPane().setBorder(null);
                ((AssistArea)jComponent).getScrollPane().getVerticalScrollBar().setValue(0);
                return ((AssistArea)jComponent).getScrollPane();
            }
            return jComponent;
        }
        if (bl3 && this.rendComponent instanceof AssistCombo) {
            boolean bl4 = false;
            if (object != null) {
                bl4 = ((AssistCombo)this.rendComponent).containsObject(object);
            }
            if (bl4) {
                ((AssistCombo)this.rendComponent).setSelectedItem(object);
            } else if (object != null) {
                ((AssistCombo)this.rendComponent).insertItemAt(object, 0);
                ((AssistCombo)this.rendComponent).setSelectedIndex(0);
            } else {
                ((AssistCombo)this.rendComponent).removeAllItems();
            }
            this.configureRendererComponent(this.rendComponent, bl, bl2, n2, n3);
            return this.rendComponent;
        }
        if (bl3 && this.rendComponent instanceof JComboBox) {
            boolean bl5 = false;
            if (object != null) {
                int n6 = 0;
                while (n6 < ((JComboBox)this.rendComponent).getItemCount()) {
                    if (((JComboBox)this.rendComponent).getItemAt(n6) == object) {
                        bl5 = true;
                        break;
                    }
                    ++n6;
                }
            }
            if (bl5) {
                ((JComboBox)this.rendComponent).setSelectedItem(object);
            } else if (object != null) {
                ((JComboBox)this.rendComponent).insertItemAt(object, 0);
                ((JComboBox)this.rendComponent).setSelectedIndex(0);
            } else {
                ((JComboBox)this.rendComponent).removeAllItems();
            }
            this.configureRendererComponent(this.rendComponent, bl, bl2, n2, n3);
            return this.rendComponent;
        }
        if (bl3 && this.rendComponent instanceof AssistEllipsis) {
            if (this.beep) {
                AssistManager.setBeepPolicy(false);
            }
            if (jComponent == null) {
                TableCellEditor tableCellEditor = this.table.getColumnModel().getColumn(n3).getCellEditor();
                if (tableCellEditor == null) {
                    tableCellEditor = this.table.getDefaultEditor(this.table.getColumnClass(n3));
                }
                if ((jComponent = (JComponent)this.table.prepareEditor(tableCellEditor, n2, n3)) instanceof AssistEllipsis) {
                    jComponent = ((AssistEllipsis)jComponent).getRenderer(false, "");
                    ((AssistEllipsis)jComponent).verify();
                    ((AssistEllipsis)jComponent).setTitle(this.table.getColumnName(n3));
                }
                this.rendComps.put(this.key.toString(), jComponent);
            }
            if (jComponent instanceof AssistEllipsis) {
                ((AssistEllipsis)jComponent).setValue(object);
                ((AssistEllipsis)jComponent).verify();
            }
            this.configureRendererComponent(jComponent, bl, bl2, n2, n3);
            if (jComponent instanceof AssistComponent && !((AssistComponent)((Object)jComponent)).isValueValid()) {
                jComponent.setBorder(AssistManager.getBorder("Assist.nested.error.border"));
            }
            AssistManager.setBeepPolicy(this.beep);
            return jComponent;
        }
        if (bl3 && this.rendComponent instanceof AssistSpinner) {
            if (this.beep) {
                AssistManager.setBeepPolicy(false);
            }
            if (jComponent == null) {
                TableCellEditor tableCellEditor = this.table.getColumnModel().getColumn(n3).getCellEditor();
                if (tableCellEditor == null) {
                    tableCellEditor = this.table.getDefaultEditor(this.table.getColumnClass(n3));
                }
                if ((jComponent = (JComponent)this.table.prepareEditor(tableCellEditor, n2, n3)) instanceof AssistSpinner) {
                    jComponent = ((AssistSpinner)jComponent).getRenderer(true, "");
                    ((AssistSpinner)jComponent).verify();
                }
                this.rendComps.put(this.key.toString(), jComponent);
            }
            if (jComponent instanceof AssistSpinner) {
                if (object instanceof Number) {
                    ((AssistSpinner)jComponent).setValue(((Number)object).longValue());
                } else {
                    ((AssistSpinner)jComponent).setText(this.valbuf.toString());
                }
                ((AssistSpinner)jComponent).verify();
            }
            this.configureRendererComponent(jComponent, bl, bl2, n2, n3);
            if (jComponent instanceof AssistComponent && !((AssistComponent)((Object)jComponent)).isValueValid()) {
                jComponent.setBorder(AssistManager.getBorder("Assist.nested.error.border"));
            }
            AssistManager.setBeepPolicy(this.beep);
            return jComponent;
        }
        if (this.rendComponent instanceof JCheckBox) {
            if (object == null) {
                object = Boolean.FALSE;
            }
            ((JCheckBox)this.rendComponent).setSelected((Boolean)object);
            this.configureRendererComponent(this.rendComponent, bl, bl2, n2, n3);
            return this.rendComponent;
        }
        this.setText(object == null ? " " : object.toString());
        this.configureRendererComponent(this, bl, bl2, n2, n3);
        return this;
    }

    public void configureRendererComponent(JComponent jComponent, boolean bl, boolean bl2, int n2, int n3) {
        if (bl) {
            jComponent.setForeground(this.table.getSelectionForeground());
            jComponent.setBackground(this.table.getSelectionBackground());
        } else if (this.table.getModel().isCellEditable(n2, this.table.convertColumnIndexToModel(n3))) {
            jComponent.setForeground(UIManager.getColor("controlText"));
            jComponent.setBackground(UIManager.getColor("window"));
        } else {
            jComponent.setForeground(UIManager.getColor("controlText"));
            jComponent.setBackground(UIManager.getColor("control"));
        }
        jComponent.setFont(this.table.getFont());
        if (bl2) {
            jComponent.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
        } else {
            jComponent.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        }
        if (jComponent instanceof JLabel && this.table.getModel().getColumnClass(this.table.convertColumnIndexToModel(n3)) == AssistManager.getClass("Number")) {
            ((JLabel)jComponent).setHorizontalAlignment(4);
        }
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        if (this.rendComponent != null) {
            this.rendComponent.setEnabled(bl);
        }
    }

    public void updateUI() {
        super.updateUI();
        if (this.rendComponent != null) {
            this.rendComponent.updateUI();
        }
    }
}

