/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common.support;

import com.ibm.db2.tools.common.AssistArea;
import com.ibm.db2.tools.common.AssistCombo;
import com.ibm.db2.tools.common.AssistEllipsis;
import com.ibm.db2.tools.common.AssistField;
import com.ibm.db2.tools.common.AssistPassword;
import com.ibm.db2.tools.common.AssistSpinner;
import com.ibm.db2.tools.common.AssistTable;
import com.ibm.db2.tools.common.support.AssistComponent;
import com.ibm.db2.tools.common.support.AssistManager;
import com.ibm.db2.tools.common.support.AssistTableModel;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.EventObject;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.EventListenerList;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;

public class AssistTableCellEditor
implements TableCellEditor,
Serializable,
ItemListener {
    private static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected EventListenerList listenerList = new EventListenerList();
    protected transient ChangeEvent changeEvent = null;
    protected JTable table = null;
    protected JComponent editorComponent;
    protected int clickCountToStart = 1;
    protected boolean beep;
    protected Hashtable editComps;
    protected StringBuffer key;
    protected StringBuffer valbuf;
    static /* synthetic */ Class class$javax$swing$event$CellEditorListener;

    public AssistTableCellEditor() {
        this(new AssistField());
    }

    public AssistTableCellEditor(JTextField jTextField) {
        this.editorComponent = jTextField;
        this.construct();
    }

    public AssistTableCellEditor(JPasswordField jPasswordField) {
        this.editorComponent = jPasswordField;
        this.construct();
    }

    public AssistTableCellEditor(JCheckBox jCheckBox) {
        this.editorComponent = jCheckBox;
        jCheckBox.setOpaque(true);
        jCheckBox.setBorderPainted(true);
        jCheckBox.addItemListener(this);
        this.editorComponent.setBackground(UIManager.getColor("window"));
        this.construct();
    }

    public AssistTableCellEditor(JComboBox jComboBox) {
        this.editorComponent = jComboBox;
        this.construct();
    }

    public AssistTableCellEditor(JTextArea jTextArea) {
        this.editorComponent = jTextArea;
        this.construct();
    }

    public AssistTableCellEditor(AssistEllipsis assistEllipsis) {
        this.editorComponent = assistEllipsis;
        this.construct();
    }

    public AssistTableCellEditor(AssistSpinner assistSpinner) {
        this.editorComponent = assistSpinner;
        this.construct();
    }

    private void construct() {
        if (this.editorComponent instanceof AssistField) {
            ((AssistField)this.editorComponent).setNestedBorders(true);
        } else if (this.editorComponent instanceof AssistPassword) {
            ((AssistPassword)this.editorComponent).setNestedBorders(true);
        } else if (this.editorComponent instanceof AssistArea) {
            ((AssistArea)this.editorComponent).setNestedBorders(true);
        } else if (this.editorComponent instanceof AssistEllipsis) {
            ((AssistEllipsis)this.editorComponent).setNestedBorders(true);
        } else if (this.editorComponent instanceof AssistSpinner) {
            ((AssistSpinner)this.editorComponent).setNestedBorders(true);
            ((AssistSpinner)this.editorComponent).setBorder(null);
        } else {
            this.editorComponent.setBorder(null);
        }
        this.beep = AssistManager.getBeepPolicy();
        this.editComps = new Hashtable(50);
        this.key = new StringBuffer();
        this.valbuf = new StringBuffer();
    }

    protected String getKey(JTable jTable, int n2, int n3) {
        TableModel tableModel = jTable.getModel();
        int n4 = n2;
        if (tableModel instanceof AssistTableModel) {
            n4 = ((AssistTableModel)tableModel).actualRow(n4);
        }
        int n5 = this.table.convertColumnIndexToModel(n3);
        this.key.setLength(0);
        this.key.append(n4).append('.').append(n5);
        return this.key.toString();
    }

    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n2, int n3) {
        this.table = jTable;
        TableModel tableModel = this.table.getModel();
        int n4 = n2;
        if (tableModel instanceof AssistTableModel) {
            n4 = ((AssistTableModel)tableModel).actualRow(n4);
        }
        int n5 = this.table.convertColumnIndexToModel(n3);
        this.key.setLength(0);
        this.key.append(n4).append('.').append(n5);
        JComponent jComponent = (JComponent)this.editComps.get(this.key.toString());
        if (this.editorComponent instanceof AssistField) {
            this.valbuf.setLength(0);
            if (object != null) {
                this.valbuf.append(object.toString());
            }
            if (jComponent == null) {
                jComponent = ((AssistField)this.editorComponent).getRenderer(true, this.valbuf.toString());
                this.editComps.put(this.key.toString(), jComponent);
                if (this.beep) {
                    AssistManager.setBeepPolicy(false);
                }
                ((AssistField)jComponent).verify();
                if (this.beep) {
                    AssistManager.setBeepPolicy(true);
                }
            } else {
                if (!((AssistField)jComponent).getText().equals(this.valbuf.toString())) {
                    ((AssistField)jComponent).setText(this.valbuf.toString());
                }
                ((AssistField)jComponent).verify();
            }
            this.configureRendererComponent(jComponent, false, false, n2, n3);
            if (((AssistComponent)((Object)jComponent)).isValueValid()) {
                jComponent.setBorder(AssistManager.getBorder("Assist.nested.border", true, true, "ATCEnntt"));
            } else {
                jComponent.setBorder(AssistManager.getBorder("Assist.nested.error.border"));
            }
            return jComponent;
        }
        if (this.editorComponent instanceof AssistPassword) {
            this.valbuf.setLength(0);
            if (object != null && object instanceof char[]) {
                AssistManager.appendChars((char[])object, this.valbuf);
            } else if (object != null) {
                this.valbuf.append(object.toString());
            }
            if (jComponent == null) {
                jComponent = ((AssistPassword)this.editorComponent).getRenderer(true, this.valbuf.toString());
                this.editComps.put(this.key.toString(), jComponent);
                if (this.beep) {
                    AssistManager.setBeepPolicy(false);
                }
                ((AssistPassword)jComponent).verify();
                if (this.beep) {
                    AssistManager.setBeepPolicy(true);
                }
            } else {
                ((AssistPassword)jComponent).setText(this.valbuf.toString());
                ((AssistPassword)jComponent).verify();
            }
            this.configureRendererComponent(jComponent, false, false, n2, n3);
            if (((AssistComponent)((Object)jComponent)).isValueValid()) {
                jComponent.setBorder(AssistManager.getBorder("Assist.nested.border", true, true, "ATCEnntt"));
            } else {
                jComponent.setBorder(AssistManager.getBorder("Assist.nested.error.border"));
            }
            return jComponent;
        }
        if (this.editorComponent instanceof AssistArea) {
            this.valbuf.setLength(0);
            if (object != null) {
                this.valbuf.append(object.toString());
            }
            if (jComponent == null) {
                jComponent = ((AssistArea)this.editorComponent).clone(this.valbuf.toString());
                this.editComps.put(this.key.toString(), jComponent);
                if (this.beep) {
                    AssistManager.setBeepPolicy(false);
                }
                ((AssistArea)jComponent).verify();
                if (this.beep) {
                    AssistManager.setBeepPolicy(true);
                }
            } else {
                if (!((AssistArea)jComponent).getText().equals(this.valbuf.toString())) {
                    ((AssistArea)jComponent).setText(this.valbuf.toString());
                }
                ((AssistArea)jComponent).verify();
            }
            this.configureRendererComponent(jComponent, false, false, n2, n3);
            ((AssistArea)jComponent).getScrollPane().setBorder(null);
            if (((AssistComponent)((Object)jComponent)).isValueValid()) {
                jComponent.setBorder(AssistManager.getBorder("Assist.nested.border", true, true, "ATCEnntt"));
            } else {
                jComponent.setBorder(AssistManager.getBorder("Assist.nested.error.border"));
            }
            return ((AssistArea)jComponent).getScrollPane();
        }
        if (this.editorComponent instanceof AssistCombo) {
            if (jComponent == null) {
                jComponent = ((AssistCombo)this.editorComponent).clone(((AssistTableModel)tableModel).getValuesAt(n2, n5));
                ((AssistCombo)jComponent).setSelectedIndex(((AssistTableModel)tableModel).getSelectedIndexAt(n2, n5));
                this.editComps.put(this.key.toString(), jComponent);
            }
            this.configureRendererComponent(jComponent, false, false, n2, n3);
            if (((AssistComponent)((Object)jComponent)).isValueValid()) {
                jComponent.setBorder(AssistManager.getBorder("Assist.nested.border", true, true, "ATCEnntt"));
            } else {
                jComponent.setBorder(AssistManager.getBorder("Assist.nested.error.border"));
            }
            return (AssistCombo)jComponent;
        }
        if (this.editorComponent instanceof JComboBox) {
            if (object != null) {
                ((JComboBox)this.editorComponent).setSelectedItem(object);
            } else {
                ((JComboBox)this.editorComponent).setSelectedIndex(0);
            }
            this.editorComponent.setBorder(AssistManager.getBorder("Assist.nested.border", true, true, "ATCEnntt"));
            return this.editorComponent;
        }
        if (this.editorComponent instanceof JTextField || this.editorComponent instanceof JPasswordField) {
            this.valbuf.setLength(0);
            if (object != null) {
                this.valbuf.append(object.toString());
            }
            ((JTextField)this.editorComponent).setText(this.valbuf.toString());
            this.editorComponent.setBorder(AssistManager.getBorder("Assist.nested.border", true, true, "ATCEnntt"));
            return this.editorComponent;
        }
        if (this.editorComponent instanceof AssistEllipsis) {
            if (jComponent == null) {
                jComponent = ((AssistEllipsis)this.editorComponent).getRenderer(true, "");
                this.editComps.put(this.key.toString(), jComponent);
            }
            ((AssistEllipsis)jComponent).setTitle(this.table.getColumnName(n3));
            ((AssistEllipsis)jComponent).setValue(object);
            if (((AssistComponent)((Object)jComponent)).isValueValid()) {
                jComponent.setBorder(AssistManager.getBorder("Assist.nested.border", true, true, "ATCEnntt"));
            } else {
                jComponent.setBorder(AssistManager.getBorder("Assist.nested.error.border"));
            }
            return jComponent;
        }
        if (this.editorComponent instanceof AssistSpinner) {
            if (jComponent == null) {
                jComponent = ((AssistSpinner)this.editorComponent).getRenderer(true, "");
                this.editComps.put(this.key.toString(), jComponent);
            }
            if (object != null && object instanceof Number) {
                ((AssistSpinner)jComponent).setValue(((Number)object).longValue());
            } else {
                ((AssistSpinner)jComponent).setText(this.valbuf.toString());
            }
            ((AssistComponent)((Object)jComponent)).setBorder();
            if (((AssistComponent)((Object)jComponent)).isValueValid()) {
                jComponent.setBorder(AssistManager.getBorder("Assist.nested.border", true, true, "ATCEnntt"));
            } else {
                jComponent.setBorder(AssistManager.getBorder("Assist.nested.error.border"));
            }
            return jComponent;
        }
        if (this.editorComponent instanceof JCheckBox) {
            if (object == null) {
                object = Boolean.FALSE;
            }
            if (object instanceof Boolean) {
                ((JCheckBox)this.editorComponent).setSelected((Boolean)object);
            } else if (object instanceof String) {
                Boolean bl2 = new Boolean((String)object);
                ((JCheckBox)this.editorComponent).setSelected(bl2);
            } else {
                ((JCheckBox)this.editorComponent).setSelected(false);
            }
            this.editorComponent.setBorder(AssistManager.getBorder("Assist.nested.border", true, true, "ATCEnntt"));
            return this.editorComponent;
        }
        if (this.editorComponent instanceof JComboBox) {
            if (object != null) {
                ((JComboBox)this.editorComponent).setSelectedItem(object);
            } else {
                ((JComboBox)this.editorComponent).setSelectedIndex(0);
            }
            this.editorComponent.setBorder(AssistManager.getBorder("Assist.nested.border", true, true, "ATCEnntt"));
            return this.editorComponent;
        }
        this.editorComponent.setBorder(AssistManager.getBorder("Assist.nested.border", true, true, "ATCEnntt"));
        return this.editorComponent;
    }

    public void configureRendererComponent(JComponent jComponent, boolean bl, boolean bl2, int n2, int n3) {
        if (bl) {
            jComponent.setForeground(this.table.getSelectionForeground());
            jComponent.setBackground(this.table.getSelectionBackground());
        } else if (this.table.getModel().isCellEditable(n2, this.table.convertColumnIndexToModel(n3))) {
            jComponent.setForeground(UIManager.getColor("controlText"));
            jComponent.setBackground(UIManager.getColor("window"));
        } else {
            jComponent.setForeground(UIManager.getColor("controlText"));
            jComponent.setBackground(UIManager.getColor("control"));
        }
        jComponent.setFont(this.table.getFont());
        if (!bl2) {
            jComponent.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        }
        if (jComponent instanceof JLabel && this.table.getModel().getColumnClass(this.table.convertColumnIndexToModel(n3)) == AssistManager.getClass("Number")) {
            ((JLabel)jComponent).setHorizontalAlignment(4);
        }
    }

    public JComponent getEditingComponent() {
        return this.editorComponent;
    }

    public JComponent getEditingComponent(AssistTable assistTable, int n2, int n3) {
        this.table = assistTable;
        TableModel tableModel = assistTable.getModel();
        int n4 = n2;
        if (tableModel instanceof AssistTableModel) {
            n4 = ((AssistTableModel)tableModel).actualRow(n4);
        }
        int n5 = assistTable.convertColumnIndexToModel(n3);
        this.key.setLength(0);
        this.key.append(n4).append('.').append(n5);
        JComponent jComponent = (JComponent)this.editComps.get(this.key.toString());
        if (jComponent == null) {
            Object object = ((AssistTableModel)tableModel).getValueAt(n2, n5);
            if (this.editorComponent instanceof AssistField) {
                jComponent = ((AssistField)this.editorComponent).getRenderer(true, object == null ? "" : object.toString());
                this.editComps.put(this.key.toString(), jComponent);
                this.configureRendererComponent(jComponent, false, false, n2, n3);
                ((AssistField)jComponent).setNestedBorders(true);
            } else if (this.editorComponent instanceof AssistPassword) {
                this.valbuf.setLength(0);
                if (object != null && object instanceof char[]) {
                    AssistManager.appendChars((char[])object, this.valbuf);
                } else if (object != null) {
                    this.valbuf.append(object.toString());
                }
                jComponent = ((AssistPassword)this.editorComponent).getRenderer(true, this.valbuf.toString());
                this.editComps.put(this.key.toString(), jComponent);
                this.configureRendererComponent(jComponent, false, false, n2, n3);
                ((AssistPassword)jComponent).setNestedBorders(true);
            } else {
                if (this.editorComponent instanceof AssistArea) {
                    jComponent = ((AssistArea)this.editorComponent).clone(object == null ? "" : object.toString());
                    this.editComps.put(this.key.toString(), jComponent);
                    this.configureRendererComponent(jComponent, false, false, n2, n3);
                    ((AssistArea)jComponent).setNestedBorders(true);
                    ((AssistArea)jComponent).getScrollPane().setBorder(null);
                    return ((AssistArea)jComponent).getScrollPane();
                }
                if (this.editorComponent instanceof AssistCombo) {
                    jComponent = ((AssistCombo)this.editorComponent).clone(((AssistTableModel)tableModel).getValuesAt(n2, n5));
                    ((AssistCombo)jComponent).setSelectedIndex(((AssistTableModel)tableModel).getSelectedIndexAt(n2, n5));
                    this.editComps.put(this.key.toString(), jComponent);
                    this.configureRendererComponent(jComponent, false, false, n2, n3);
                } else if (this.editorComponent instanceof AssistEllipsis) {
                    jComponent = ((AssistEllipsis)this.editorComponent).getRenderer(true, "");
                    this.editComps.put(this.key.toString(), jComponent);
                    ((AssistEllipsis)jComponent).setTitle(assistTable.getColumnName(n3));
                    ((AssistEllipsis)jComponent).setValue(object);
                } else if (this.editorComponent instanceof AssistSpinner) {
                    jComponent = ((AssistSpinner)this.editorComponent).getRenderer(true, "");
                    this.editComps.put(this.key.toString(), jComponent);
                    if (object != null && object instanceof Number) {
                        ((AssistSpinner)jComponent).setValue(((Number)object).longValue());
                    } else {
                        ((AssistSpinner)jComponent).setText(object == null ? "" : object.toString());
                    }
                }
            }
            this.editComps.put(this.key.toString(), jComponent);
        }
        return jComponent;
    }

    public void updateUI() {
        this.editorComponent.updateUI();
    }

    public Object getCellEditorValue() {
        int n2 = this.table.getEditingRow();
        int n3 = this.table.getEditingColumn();
        int n4 = n2;
        TableModel tableModel = this.table.getModel();
        if (tableModel instanceof AssistTableModel) {
            n4 = ((AssistTableModel)tableModel).actualRow(n4);
        }
        int n5 = this.table.convertColumnIndexToModel(n3);
        this.key.setLength(0);
        this.key.append(n4).append('.').append(n5);
        JComponent jComponent = (JComponent)this.editComps.get(this.key.toString());
        if (jComponent == null) {
            jComponent = this.editorComponent;
        }
        if (this.editorComponent instanceof JComboBox) {
            return ((JComboBox)jComponent).getSelectedItem();
        }
        if (this.editorComponent instanceof JTextField) {
            return ((JTextField)jComponent).getText();
        }
        if (this.editorComponent instanceof JPasswordField) {
            return ((JPasswordField)jComponent).getPassword();
        }
        if (this.editorComponent instanceof AssistEllipsis) {
            return ((AssistEllipsis)jComponent).getValue();
        }
        if (this.editorComponent instanceof AssistSpinner) {
            return new Long(((AssistSpinner)jComponent).getValue());
        }
        if (this.editorComponent instanceof JTextArea) {
            return ((JTextArea)jComponent).getText();
        }
        if (this.editorComponent instanceof JCheckBox) {
            return new Boolean(((JCheckBox)this.editorComponent).isSelected());
        }
        return "";
    }

    public boolean isCellEditable(EventObject eventObject) {
        if (eventObject instanceof MouseEvent) {
            return true;
        }
        if (eventObject instanceof KeyEvent) {
            return true;
        }
        return true;
    }

    public boolean shouldSelectCell(EventObject eventObject) {
        boolean bl = true;
        if (eventObject == null || ((MouseEvent)eventObject).getClickCount() >= this.clickCountToStart) {
            bl = true;
        }
        return bl;
    }

    public boolean stopCellEditing() {
        this.fireEditingStopped();
        return true;
    }

    public void cancelCellEditing() {
        this.fireEditingCanceled();
    }

    public void addCellEditorListener(CellEditorListener cellEditorListener) {
        this.listenerList.add(class$javax$swing$event$CellEditorListener == null ? (class$javax$swing$event$CellEditorListener = AssistTableCellEditor.class$("javax.swing.event.CellEditorListener")) : class$javax$swing$event$CellEditorListener, cellEditorListener);
    }

    public void removeCellEditorListener(CellEditorListener cellEditorListener) {
        this.listenerList.remove(class$javax$swing$event$CellEditorListener == null ? (class$javax$swing$event$CellEditorListener = AssistTableCellEditor.class$("javax.swing.event.CellEditorListener")) : class$javax$swing$event$CellEditorListener, cellEditorListener);
    }

    public void setClickCountToStart(int n2) {
        this.clickCountToStart = n2;
    }

    public int getClickCountToStart() {
        return this.clickCountToStart;
    }

    protected void fireEditingStopped() {
        Object[] objectArray = this.listenerList.getListenerList();
        int n2 = objectArray.length - 2;
        while (n2 >= 0) {
            if (objectArray[n2] == (class$javax$swing$event$CellEditorListener == null ? AssistTableCellEditor.class$("javax.swing.event.CellEditorListener") : class$javax$swing$event$CellEditorListener)) {
                if (this.changeEvent == null) {
                    this.changeEvent = new ChangeEvent(this);
                }
                ((CellEditorListener)objectArray[n2 + 1]).editingStopped(this.changeEvent);
            }
            n2 -= 2;
        }
    }

    protected void fireEditingCanceled() {
        Object[] objectArray = this.listenerList.getListenerList();
        int n2 = objectArray.length - 2;
        while (n2 >= 0) {
            if (objectArray[n2] == (class$javax$swing$event$CellEditorListener == null ? AssistTableCellEditor.class$("javax.swing.event.CellEditorListener") : class$javax$swing$event$CellEditorListener)) {
                if (this.changeEvent == null) {
                    this.changeEvent = new ChangeEvent(this);
                }
                ((CellEditorListener)objectArray[n2 + 1]).editingCanceled(this.changeEvent);
            }
            n2 -= 2;
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (this.table != null) {
            int n2 = this.table.getEditingRow();
            int n3 = this.table.getEditingColumn();
            this.table.setValueAt(this.getCellEditorValue(), n2, n3);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

