/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common.support;

import com.ibm.db2.tools.common.CommonTrace;
import com.ibm.db2.tools.common.support.AssistTableModel;
import com.ibm.db2.tools.common.support.CUtil;
import com.ibm.db2.tools.common.support.ViewObjectInterface;
import com.ibm.db2.tools.common.support.ViewTableModel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.BitSet;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.TimeZone;
import javax.swing.BorderFactory;
import javax.swing.JApplet;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.text.JTextComponent;

public class AssistManager
implements Serializable {
    private static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected static boolean hasNativeSupport = true;
    protected static boolean supportsServerLangsOnly = true;
    protected static Boolean serverLanguage = null;
    protected static Boolean langInstalled = null;
    protected static boolean skipsCurrentLangInstalledCheck = false;
    protected static boolean beepPolicy = false;
    protected static int verifyDelayPolicy = 125;
    protected static boolean errorBordersPolicy = true;
    protected static boolean clearDisabledPolicy = false;
    protected static boolean insideBordersPolicy = true;
    protected static boolean thinBordersPolicy = false;
    protected static boolean selectScrollPolicy = false;
    protected static boolean defaultColorsPolicy = true;
    public static final int DOCKING_MAP_AND_SYMBOLS = 2;
    public static final int DOCKING_MAP = 1;
    public static final int NO_DOCKING_MAP = 0;
    protected static int dockingMapPolicy = 2;
    protected static String lookAndFeel;
    protected static String languagePolicy;
    protected static String localePolicy;
    public static transient Hashtable borderCache;
    public static final Insets zeroInsets;
    protected static Hashtable classObjects;
    protected static Hashtable vkeys;
    protected static FontRenderContext DefaultRenderContext;
    protected static int jvVersion;
    protected static int jvRelease;
    protected static int jvModification;
    protected static String cutilLibrary;
    protected static int[] db2Levels;
    static /* synthetic */ Class class$java$awt$event$KeyEvent;
    static /* synthetic */ Class class$java$lang$Number;

    public static void setSupportsServerLangsOnly(boolean bl) {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common.support", "AssistManager", "setSupportsServerLangsOnly(boolean value)", new Object[]{new Boolean(bl)});
        }
        supportsServerLangsOnly = bl;
        CommonTrace.exit(commonTrace);
    }

    public static boolean getSupportsServerLangsOnly() {
        return supportsServerLangsOnly;
    }

    public static void setBeepPolicy(boolean bl) {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common.support", "AssistManager", "setBeepPolicy(boolean value)", new Object[]{new Boolean(bl)});
        }
        beepPolicy = bl;
        CommonTrace.exit(commonTrace);
    }

    public static boolean getBeepPolicy() {
        return beepPolicy;
    }

    public static void setVerifyDelayPolicy(int n2) {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common.support", "AssistManager", "setVerifyDelayPolicy(int value)", new Object[]{new Integer(n2)});
        }
        verifyDelayPolicy = n2;
        CommonTrace.exit(commonTrace);
    }

    public static int getVerifyDelayPolicy() {
        return verifyDelayPolicy;
    }

    public static void setErrorBordersPolicy(boolean bl) {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common.support", "AssistManager", "setErrorBordersPolicy(boolean value)", new Object[]{new Boolean(bl)});
        }
        errorBordersPolicy = bl;
        CommonTrace.exit(commonTrace);
    }

    public static boolean getErrorBordersPolicy() {
        return errorBordersPolicy;
    }

    public static void setClearDisabledPolicy(boolean bl) {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common.support", "AssistManager", "setClearDisabledPolicy(boolean value)", new Object[]{new Boolean(bl)});
        }
        clearDisabledPolicy = bl;
        CommonTrace.exit(commonTrace);
    }

    public static boolean getClearDisabledPolicy() {
        return clearDisabledPolicy;
    }

    public static void setInsideBordersPolicy(boolean bl) {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common.support", "AssistManager", "setInsideBordersPolicy(boolean value)", new Object[]{new Boolean(bl)});
        }
        insideBordersPolicy = bl;
        CommonTrace.exit(commonTrace);
    }

    public static boolean getInsideBordersPolicy() {
        return insideBordersPolicy;
    }

    public static void setThinBordersPolicy(boolean bl) {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common.support", "AssistManager", "setThinBordersPolicy(boolean value)", new Object[]{new Boolean(bl)});
        }
        thinBordersPolicy = bl;
        CommonTrace.exit(commonTrace);
    }

    public static boolean getThinBordersPolicy() {
        return thinBordersPolicy;
    }

    public static void setSelectScrollPolicy(boolean bl) {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common.support", "AssistManager", "setSelectScrollPolicy(boolean value)", new Object[]{new Boolean(bl)});
        }
        selectScrollPolicy = bl;
        CommonTrace.exit(commonTrace);
    }

    public static boolean getSelectScrollPolicy() {
        return selectScrollPolicy;
    }

    public static void setDefaultColorsPolicy(boolean bl) {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common.support", "AssistManager", "setDefaultColorsPolicy(boolean value)", new Object[]{new Boolean(bl)});
        }
        defaultColorsPolicy = bl;
        CommonTrace.exit(commonTrace);
    }

    public static boolean getDefaultColorsPolicy() {
        return defaultColorsPolicy;
    }

    public static void setDockingMapPolicy(int n2) {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common.support", "AssistManager", "setDockingMapPolicy(String value)", new Object[]{new Integer(n2)});
        }
        dockingMapPolicy = n2;
        CommonTrace.exit(commonTrace);
    }

    public static int getDockingMapPolicy() {
        return dockingMapPolicy;
    }

    public static void setLanguagePolicy(String string) {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common.support", "AssistManager", "setLanguagePolicy(String value)", new Object[]{string});
        }
        languagePolicy = string != null && (string.equals("DB2") || string.equals("OS")) ? string : AssistManager.normalizeLanguageString(string);
        CommonTrace.exit(commonTrace);
    }

    public static String getLanguagePolicy() {
        return languagePolicy;
    }

    public static void setLocalePolicy(String string) {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common.support", "AssistManager", "setLocalePolicy(String value)", new Object[]{string});
        }
        localePolicy = string != null && (string.equals("DB2") || string.equals("OS")) ? string : AssistManager.normalizeLocaleString(string);
        CommonTrace.exit(commonTrace);
    }

    public static String getLocalePolicy() {
        return localePolicy;
    }

    public static void setHasNativeSupport(boolean bl) {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common.support", "AssistManager", "setHasNativeSupport(boolean supportNativeCalls)", new Object[]{new Boolean(bl)});
        }
        hasNativeSupport = bl;
        CommonTrace.exit(commonTrace);
    }

    public static String getPreferredLanguageName() {
        String string = "C";
        if (hasNativeSupport && languagePolicy.equals("DB2")) {
            try {
                string = CUtil.getDB2Language();
            }
            catch (LinkageError linkageError) {
                hasNativeSupport = false;
            }
        } else {
            string = languagePolicy.equals("DB2") || languagePolicy.equals("OS") ? Locale.getDefault().toString() : languagePolicy;
        }
        if (new String("C").equals(string)) {
            string = "en_US";
        }
        return string;
    }

    public static String getPreferredLocaleName() {
        String string = "C";
        if (hasNativeSupport && localePolicy.equals("DB2")) {
            try {
                string = CUtil.getDB2Locale();
            }
            catch (LinkageError linkageError) {
                hasNativeSupport = false;
            }
        } else {
            string = localePolicy.equals("DB2") || localePolicy.equals("OS") ? Locale.getDefault().toString() : localePolicy;
        }
        if (new String("C").equals(string)) {
            string = "en_US";
        }
        return string;
    }

    public static Locale getPreferredLanguage() {
        return AssistManager.normalizeLanguage(AssistManager.getPreferredLanguageName());
    }

    public static Locale getPreferredLocale() {
        return AssistManager.normalizeLanguage(AssistManager.getPreferredLocaleName());
    }

    public static String normalizeLanguageString(String string) {
        if (string == null || string.length() == 0) {
            languagePolicy = "DB2";
            return AssistManager.getPreferredLanguageName();
        }
        if (hasNativeSupport && (string.length() == 5 || string.length() == 2)) {
            String string2 = null;
            try {
                string2 = CUtil.getNormalizedLocaleFromString(string);
                if (string2 != null && string2.equals("C")) {
                    string2 = "en_US";
                }
            }
            catch (LinkageError linkageError) {
                hasNativeSupport = false;
                if (string.length() == 5) {
                    String string3 = string.substring(0, 2);
                    String string4 = string.substring(3);
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append(string3.toLowerCase(Locale.ENGLISH)).append('_').append(string4.toUpperCase(Locale.ENGLISH));
                    string2 = stringBuffer.toString();
                }
                string2 = string;
            }
            return string2;
        }
        if (!hasNativeSupport && string.length() == 5) {
            String string5 = string.substring(0, 2);
            String string6 = string.substring(3);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(string5.toLowerCase(Locale.ENGLISH)).append('_').append(string6.toUpperCase(Locale.ENGLISH));
            return stringBuffer.toString();
        }
        return string;
    }

    public static String normalizeLocaleString(String string) {
        if (string == null || string.length() == 0) {
            localePolicy = "DB2";
            return AssistManager.getPreferredLocaleName();
        }
        if (hasNativeSupport && (string.length() == 5 || string.length() == 2)) {
            String string2 = null;
            try {
                string2 = CUtil.getNormalizedLocaleFromString(string);
                if (string2 != null && string2.equals("C")) {
                    string2 = "en_US";
                }
            }
            catch (LinkageError linkageError) {
                hasNativeSupport = false;
                if (string.length() == 5) {
                    String string3 = string.substring(0, 2);
                    String string4 = string.substring(3);
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append(string3.toLowerCase(Locale.ENGLISH)).append('_').append(string4.toUpperCase(Locale.ENGLISH));
                    string2 = stringBuffer.toString();
                }
                string2 = string;
            }
            return string2;
        }
        if (!hasNativeSupport && string.length() == 5) {
            String string5 = string.substring(0, 2);
            String string6 = string.substring(3);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(string5.toLowerCase(Locale.ENGLISH)).append('_').append(string6.toUpperCase(Locale.ENGLISH));
            return stringBuffer.toString();
        }
        return string;
    }

    public static Locale normalizeLanguage(String string) {
        String string2 = null;
        String string3 = null;
        if (string == null || string.length() == 0) {
            return Locale.getDefault();
        }
        try {
            string2 = string.substring(0, 2);
            string3 = string.substring(3, 5);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return Locale.getDefault();
        }
        Locale locale = new Locale(string2.toLowerCase(Locale.ENGLISH), string3.toUpperCase(Locale.ENGLISH));
        return locale;
    }

    public static String getISOTerritory() {
        String string = "C";
        if (hasNativeSupport) {
            try {
                string = CUtil.getISOTerritory();
            }
            catch (LinkageError linkageError) {
                hasNativeSupport = false;
            }
        }
        if (new String("C").equals(string)) {
            string = "en_US";
        }
        return string;
    }

    public static String getISOTerritoryFromString(String string) {
        String string2 = "C";
        if (hasNativeSupport) {
            try {
                string2 = CUtil.getISOTerritoryFromString(string);
            }
            catch (LinkageError linkageError) {
                hasNativeSupport = false;
            }
        }
        if (new String("C").equals(string2)) {
            string2 = "en_US";
        }
        return string2;
    }

    public static String getInitializedDB2SettingsPath(String string) {
        Object object;
        String string2 = System.getProperty("os.name");
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append(System.getProperty("user.home"));
        if (string2.indexOf("Windows") >= 0) {
            if (string2.indexOf("Windows XP") >= 0 || string2.indexOf("Windows 2000") >= 0) {
                stringBuffer.append(File.separator).append("Application Data").append(File.separator).append("IBM").append(File.separator).append("DB2");
            } else if (string2.indexOf("Windows NT") >= 0) {
                stringBuffer.append(File.separator).append("Application Data").append(File.separator).append("IBM").append(File.separator).append("DB2");
            } else if (string2.indexOf("Windows Me") >= 0 || string2.indexOf("Windows 98") >= 0) {
                object = System.getProperty("user.name");
                if (((String)object).equals("unknown")) {
                    stringBuffer.append(File.separator).append("Application Data").append(File.separator).append("IBM").append(File.separator).append("DB2");
                } else {
                    stringBuffer.append(File.separator).append("profiles").append(File.separator).append((String)object).append(File.separator).append("Application Data").append(File.separator).append("IBM").append(File.separator).append("DB2");
                }
            } else {
                stringBuffer.append(File.separator).append("Application Data").append(File.separator).append("IBM").append(File.separator).append("DB2");
            }
        } else {
            if (null != string && string.length() > 0) {
                string = string.toLowerCase();
            }
            stringBuffer.append(File.separator).append(".ibm").append(File.separator).append("db2");
        }
        if (null != string && string.length() > 0) {
            stringBuffer.append(File.separator).append(string);
        }
        if (!((File)(object = new File(stringBuffer.toString()))).exists()) {
            ((File)object).mkdirs();
            if (!((File)object).exists() && CommonTrace.isTrace()) {
                CommonTrace commonTrace = CommonTrace.create("com.ibm.db2.tools.common.support", "AssistManager", "getInitializedDB2SettingsPath()");
                CommonTrace.write(commonTrace, "An unexpected error occured: cannot create the settings directory for the current user. The path to create is: " + stringBuffer.toString());
                CommonTrace.exit(commonTrace);
            }
        }
        return ((File)object).getPath();
    }

    public static boolean isRootUserid() {
        int n2 = -1;
        if (hasNativeSupport) {
            try {
                n2 = CUtil.getuid();
            }
            catch (LinkageError linkageError) {
                hasNativeSupport = false;
            }
        }
        return 0 == n2;
    }

    public static boolean isServerLanguage() {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common.support", "AssistManager", "isServerLanguage()");
        }
        if (null == serverLanguage) {
            boolean bl = true;
            if (languagePolicy.equals("DB2") && hasNativeSupport) {
                try {
                    bl = CUtil.isServerLanguage();
                }
                catch (LinkageError linkageError) {
                    CommonTrace.catchBlock(commonTrace);
                    hasNativeSupport = false;
                }
            }
            serverLanguage = new Boolean(bl);
        }
        return CommonTrace.exit(commonTrace, serverLanguage);
    }

    public static void setSkipsCurrentLangInstalledCheck(boolean bl) {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common.support", "AssistManager", "setSkipsCurrentLangInstalledCheck(boolean flag)", new Object[]{new Boolean(bl)});
        }
        skipsCurrentLangInstalledCheck = bl;
        CommonTrace.exit(commonTrace);
    }

    public static boolean isSkipsCurrentLangInstalledCheck() {
        return skipsCurrentLangInstalledCheck;
    }

    public static boolean isCurrentLangInstalledLocally() {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common.support", "AssistManager", "isCurrentLangInstalledLocally()");
        }
        if (null == langInstalled) {
            boolean bl = true;
            try {
                Locale locale = AssistManager.getPreferredLanguage();
                Class<?> clazz = Class.forName("com.ibm.db2.common.objmodels.dbobjs.DefaultClientInstance");
                Method method = clazz.getDeclaredMethod("getDB2Path", null);
                String string = (String)method.invoke(null, null);
                if (CommonTrace.isTrace()) {
                    CommonTrace.write(commonTrace, "path = " + string);
                }
                if (null != string && 0 != string.trim().length()) {
                    StringBuffer stringBuffer = new StringBuffer(256);
                    stringBuffer.append(string).append(File.separator).append("msg").append(File.separator).append(CUtil.getDB2LanguageDirName());
                    String string2 = stringBuffer.toString();
                    if (CommonTrace.isTrace()) {
                        CommonTrace.write(commonTrace, "msgDirName = " + string2);
                    }
                    File file = new File(string2);
                    bl = file.exists();
                }
            }
            catch (Exception exception) {
                CommonTrace.catchBlock(commonTrace);
                CommonTrace.write(commonTrace, exception.getMessage());
            }
            catch (LinkageError linkageError) {
                CommonTrace.catchBlock(commonTrace);
                CommonTrace.write(commonTrace, linkageError.getMessage());
            }
            langInstalled = new Boolean(bl);
        }
        return CommonTrace.exit(commonTrace, langInstalled);
    }

    public static void updateUI() {
    }

    public static Border getBorder(String string) {
        Border border = (Border)borderCache.get(string);
        if (border == null) {
            border = UIManager.getBorder(string);
        }
        return border;
    }

    public static Border getBorder(String string, boolean bl) {
        return AssistManager.getBorder(string, bl, null);
    }

    public static Border getBorder(String string, boolean bl, String string2) {
        if (bl) {
            return UIManager.getBorder(string);
        }
        if (insideBordersPolicy) {
            Border border = null;
            if (string2 != null) {
                border = (Border)borderCache.get(string2);
            }
            if (border == null) {
                if (string.equals("TextField.border")) {
                    string = "Assist.simple.TextField.border";
                }
                border = thinBordersPolicy ? BorderFactory.createCompoundBorder(UIManager.getBorder(string), UIManager.getBorder("Assist.nested.error.border")) : BorderFactory.createCompoundBorder(UIManager.getBorder(string), UIManager.getBorder("Assist.error.border"));
                if (string2 != null) {
                    borderCache.put(string2, border);
                }
            }
            return border;
        }
        if (thinBordersPolicy) {
            return UIManager.getBorder("Assist.nested.error.border");
        }
        return UIManager.getBorder("Assist.error.border");
    }

    public static Border getBorder(String string, boolean bl, boolean bl2) {
        return AssistManager.getBorder(string, bl, bl2, null);
    }

    public static Border getBorder(String string, boolean bl, boolean bl2, String string2) {
        if (bl) {
            if (bl2) {
                return UIManager.getBorder("AssistTable.editor.border");
            }
            Border border = (Border)borderCache.get("1111");
            if (border == null) {
                border = BorderFactory.createEmptyBorder(1, 1, 1, 1);
                borderCache.put("1111", border);
            }
            return border;
        }
        Border border = null;
        if (string2 != null) {
            border = (Border)borderCache.get(string2);
        }
        if (border == null) {
            if (bl2) {
                border = BorderFactory.createCompoundBorder(AssistManager.getBorder(string, true, string2), UIManager.getBorder("AssistTable.editor.border"));
            } else {
                Border border2 = (Border)borderCache.get("1111");
                if (border2 == null) {
                    border2 = BorderFactory.createEmptyBorder(1, 1, 1, 1);
                    borderCache.put("1111", border2);
                }
                border = BorderFactory.createCompoundBorder(AssistManager.getBorder(string, true, string2), border2);
            }
            if (string2 != null) {
                borderCache.put(string2, border);
            }
        }
        return border;
    }

    public static Border padBorder(JComponent jComponent, Border border) {
        return AssistManager.padBorder(4, jComponent, border, null);
    }

    public static Border padBorder(JComponent jComponent, Border border, String string) {
        return AssistManager.padBorder(4, jComponent, border, string);
    }

    public static Border padBorder(int n2, JComponent jComponent, Border border) {
        return AssistManager.padBorder(n2, jComponent, border, null);
    }

    public static Border padBorder(int n2, JComponent jComponent, Border border, String string) {
        Border border2 = null;
        StringBuffer stringBuffer = new StringBuffer(8);
        if (border == null) {
            int n3 = n2;
            int n4 = n2 + 1;
            stringBuffer.append(n3).append(n4).append(n3).append(n4);
            border2 = (Border)borderCache.get(stringBuffer.toString());
            if (border2 == null) {
                border2 = BorderFactory.createEmptyBorder(n3, n4, n3, n4);
                borderCache.put(stringBuffer.toString(), border2);
            }
        } else {
            Insets insets = border.getBorderInsets(jComponent);
            int n5 = n2 - insets.right;
            int n6 = n2 - insets.left + 1;
            int n7 = n2 - insets.bottom;
            int n8 = n2 - insets.right + 1;
            stringBuffer.append(n5).append(n6).append(n7).append(n8);
            Border border3 = (Border)borderCache.get(stringBuffer.toString());
            if (border3 == null) {
                border3 = BorderFactory.createEmptyBorder(n5, n6, n7, n8);
                borderCache.put(stringBuffer.toString(), border3);
            }
            if (string != null) {
                stringBuffer.append(string);
                border2 = (Border)borderCache.get(stringBuffer.toString());
            }
            if (border2 == null) {
                border2 = BorderFactory.createCompoundBorder(border, border3);
                if (string != null) {
                    borderCache.put(stringBuffer.toString(), border2);
                }
            }
        }
        return border2;
    }

    public static Calendar getCalendar() {
        return Calendar.getInstance(TimeZone.getDefault(), AssistManager.getPreferredLocale());
    }

    public static void indentText(JTextComponent jTextComponent) {
        AssistManager.indentText(jTextComponent, false);
    }

    public static void indentText(JTextComponent jTextComponent, boolean bl) {
        int n2 = 1;
        if (bl) {
            n2 = thinBordersPolicy ? 2 : 3;
        }
        Border border = jTextComponent.getBorder();
        jTextComponent.setBorder(BorderFactory.createCompoundBorder(border, BorderFactory.createEmptyBorder(0, n2, 0, 0)));
    }

    public static int setFlag(int n2, int n3, boolean bl) {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common.support", "AssistManager", "setFlag(int flags, int index, boolean aValue)", new Object[]{new Integer(n2), new Integer(n3), new Boolean(bl)});
        }
        n2 = bl ? (n2 |= 1 << n3) : (n2 &= ~(1 << n3));
        return CommonTrace.exit(commonTrace, n2);
    }

    public static void dumpFlags(int n2, String string) {
        System.err.println("Dumping flags for " + string + ":");
        int n3 = 0;
        while (n3 < 32) {
            if (AssistManager.getFlag(n2, n3)) {
                System.err.println("\t" + n3 + ": " + AssistManager.getFlag(n2, n3));
            }
            ++n3;
        }
    }

    public static boolean getFlag(int n2, int n3) {
        int n4 = 1 << n3;
        return (n2 & n4) == n4;
    }

    public static void setBit(BitSet bitSet, int n2, boolean bl) {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common.support", "AssistManager", "setBit(BitSet bits, int index, boolean aValue)", new Object[]{bitSet, new Integer(n2), new Boolean(bl)});
        }
        if (!bl) {
            bitSet.set(n2);
        } else {
            bitSet.clear(n2);
        }
        CommonTrace.exit(commonTrace);
    }

    public static boolean getBit(BitSet bitSet, int n2) {
        return !bitSet.get(n2);
    }

    public static boolean getBitSetValue(BitSet bitSet) {
        int n2 = 0;
        while (n2 < bitSet.size()) {
            if (bitSet.get(n2)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static void setKey(Hashtable hashtable, Object object, boolean bl) {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common.support", "AssistManager", "setKey(Hashtable table, Object key, boolean aValue)", new Object[]{hashtable, object, new Boolean(bl)});
        }
        if (bl) {
            hashtable.put(object, Boolean.TRUE);
        } else {
            hashtable.put(object, Boolean.FALSE);
        }
        CommonTrace.exit(commonTrace);
    }

    public static boolean getKey(Hashtable hashtable, Object object) {
        Boolean bl = (Boolean)hashtable.get(object);
        return bl == null || bl != false;
    }

    public static boolean getKeysValue(Hashtable hashtable) {
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            if (((Boolean)enumeration.nextElement()).booleanValue()) continue;
            return false;
        }
        return true;
    }

    public static boolean equal(String string, String string2) {
        return AssistManager.equalize(string).equals(AssistManager.equalize(string2));
    }

    protected static String equalize(String string) {
        String string2 = string.trim();
        if (string2.startsWith("\"")) {
            string2 = string2.substring(1, string2.length() - 1);
            int n2 = 0;
            int n3 = string2.indexOf("\"\"");
            if (n3 > -1) {
                StringBuffer stringBuffer = new StringBuffer();
                while (n3 > -1) {
                    stringBuffer.append(string2.substring(n2, n3));
                    n2 = n3 + 2;
                    n3 = string2.indexOf("\"\"", n2);
                }
                string2 = stringBuffer.toString();
            }
        } else {
            string2 = string2.toUpperCase();
        }
        return string2;
    }

    public static void setGridBagConstraints(GridBagConstraints gridBagConstraints, int n2, int n3, int n4, int n5, int n6, Insets insets, int n7, double d2, double d3) {
        gridBagConstraints.gridx = n2 < 0 ? -1 : n2;
        gridBagConstraints.gridy = n3 < 0 ? -1 : n3;
        gridBagConstraints.gridwidth = n4 < 0 ? -1 : n4;
        gridBagConstraints.gridheight = n5 < 0 ? -1 : n5;
        gridBagConstraints.fill = n6 < 0 ? 2 : n6;
        gridBagConstraints.insets = insets == null ? zeroInsets : insets;
        gridBagConstraints.anchor = n7 < 0 ? 18 : n7;
        gridBagConstraints.weightx = d2 < 0.0 ? 0.0 : d2;
        gridBagConstraints.weighty = d3 < 0.0 ? 0.0 : d3;
    }

    public static void redirectMouseEvent(MouseEvent mouseEvent, Component component) {
        Component component2 = (Component)mouseEvent.getSource();
        Point point = mouseEvent.getPoint();
        point = SwingUtilities.convertPoint(component2, point, component);
        MouseEvent mouseEvent2 = new MouseEvent(component, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), point.x, point.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
        mouseEvent.consume();
        component.dispatchEvent(mouseEvent2);
    }

    public static void redirectKeyEvent(KeyEvent keyEvent, Component component) {
        RedirectedKeyEvent redirectedKeyEvent = new RedirectedKeyEvent(component, keyEvent.getID(), keyEvent.getWhen(), keyEvent.getModifiers(), keyEvent.getKeyCode(), keyEvent.getKeyChar());
        keyEvent.consume();
        component.dispatchEvent(redirectedKeyEvent);
    }

    public static Class getClass(String string) {
        if (classObjects == null) {
            classObjects = new Hashtable(10);
            try {
                classObjects.put("Object", Class.forName("java.lang.Object"));
                classObjects.put("Number", Class.forName("java.lang.Number"));
                classObjects.put("Boolean", Class.forName("java.lang.Boolean"));
                classObjects.put("String", Class.forName("java.lang.String"));
                classObjects.put("StringBuffer", Class.forName("java.lang.StringBuffer"));
                classObjects.put("Vector", Class.forName("java.util.Vector"));
                classObjects.put("char[]", new char[0].getClass());
                classObjects.put("ItemListener", Class.forName("java.awt.event.ItemListener"));
                classObjects.put("PopupMenuListener", Class.forName("javax.swing.event.PopupMenuListener"));
                classObjects.put("AssistListener", Class.forName("com.ibm.db2.tools.common.event.AssistListener"));
                classObjects.put("EditListener", Class.forName("com.ibm.db2.tools.common.event.EditListener"));
                classObjects.put("ImageIcon", Class.forName("javax.swing.ImageIcon"));
                classObjects.put("BigDecimal", Class.forName("java.math.BigDecimal"));
                classObjects.put("Date", Class.forName("java.util.Date"));
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.gc();
            }
        }
        return (Class)classObjects.get(string);
    }

    public static void appendChars(char[] cArray, StringBuffer stringBuffer) {
        int n2 = cArray.length;
        int n3 = 0;
        while (n3 < n2) {
            stringBuffer.append(cArray[n3]);
            ++n3;
        }
    }

    public static boolean popupFit(Rectangle rectangle, Component component) {
        if (component != null) {
            Container container = component.getParent();
            while (container != null) {
                if (container instanceof JFrame || container instanceof JDialog || container instanceof JWindow) {
                    Rectangle rectangle2 = container.getBounds();
                    Insets insets = container.getInsets();
                    rectangle2.y += insets.top;
                    rectangle2.height -= insets.top;
                    return SwingUtilities.isRectangleContainingRectangle(rectangle2, rectangle);
                }
                if (container instanceof JApplet) {
                    Rectangle rectangle3 = container.getBounds();
                    Point point = null;
                    if (!container.isShowing()) {
                        return false;
                    }
                    point = container.getLocationOnScreen();
                    rectangle3.x = point.x;
                    rectangle3.y = point.y;
                    return SwingUtilities.isRectangleContainingRectangle(rectangle3, rectangle);
                }
                if (container instanceof Frame) {
                    return SwingUtilities.isRectangleContainingRectangle(container.getBounds(), rectangle);
                }
                container = container.getParent();
            }
        }
        return false;
    }

    public static int getVirtualKeyCode(String string) {
        Integer n2;
        int n3 = string.lastIndexOf("+");
        if (n3 > -1) {
            string = string.substring(n3 + 1).trim();
        }
        if ((n2 = (Integer)vkeys.get(string)) == null && string.length() == 1) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("VK_").append(string);
            n2 = (Integer)vkeys.get(stringBuffer.toString());
        }
        if (n2 == null) {
            return 0;
        }
        return n2;
    }

    public static int getAcceleratorModifierMask(String string) {
        int n2;
        int n3 = 0;
        int n4 = 0;
        int n5 = string.indexOf("+");
        while (n5 > -1) {
            String string2 = string.substring(n4, n5).trim();
            if (string2.equalsIgnoreCase("SHIFT") || string2.equalsIgnoreCase("SHIFT_MASK")) {
                ++n3;
            } else if (string2.equalsIgnoreCase("CTRL") || string2.equalsIgnoreCase("CTRL_MASK")) {
                n3 += 2;
            } else if (string2.equalsIgnoreCase("META") || string2.equalsIgnoreCase("META_MASK")) {
                n3 += 4;
            } else if (string2.equalsIgnoreCase("ALT") || string2.equalsIgnoreCase("ALT_MASK")) {
                n3 += 8;
            }
            n4 = n5 + 1;
            n5 = string.indexOf("+", n4);
        }
        if (n3 == 0 && 44 <= (n2 = AssistManager.getVirtualKeyCode(string)) && n2 <= 222) {
            n3 = 2;
        }
        return n3;
    }

    protected static void loadVKeys() {
        if (vkeys == null) {
            vkeys = new Hashtable(120);
            try {
                Field[] fieldArray = (class$java$awt$event$KeyEvent == null ? (class$java$awt$event$KeyEvent = AssistManager.class$("java.awt.event.KeyEvent")) : class$java$awt$event$KeyEvent).getFields();
                int n2 = 0;
                while (n2 < fieldArray.length) {
                    String string = fieldArray[n2].getName();
                    Object object = fieldArray[n2].get(null);
                    if (object instanceof Integer && string.startsWith("VK_")) {
                        vkeys.put(string, (Integer)object);
                    }
                    ++n2;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static Graphics getParentGraphics(Container container) {
        Container container2 = container;
        Graphics graphics = container.getGraphics();
        while (graphics == null) {
            if ((container2 = container2.getParent()) == null) break;
            graphics = container2.getGraphics();
        }
        if (graphics == null) {
            return null;
        }
        return graphics.create();
    }

    public static Rectangle2D getStringBounds(String string, JComponent jComponent, Font font) {
        FontRenderContext fontRenderContext;
        if (jComponent == null) {
            if (DefaultRenderContext == null) {
                DefaultRenderContext = new FontRenderContext(null, false, false);
            }
            fontRenderContext = DefaultRenderContext;
        } else {
            Graphics2D graphics2D = (Graphics2D)jComponent.getGraphics();
            fontRenderContext = graphics2D != null ? graphics2D.getFontRenderContext() : DefaultRenderContext;
        }
        if (fontRenderContext != null) {
            return font.getStringBounds(string, fontRenderContext);
        }
        return null;
    }

    public static int getStringWidth(String string, JComponent jComponent, Font font) {
        Rectangle2D rectangle2D = AssistManager.getStringBounds(string, jComponent, font);
        if (rectangle2D != null) {
            return (int)rectangle2D.getWidth();
        }
        FontMetrics fontMetrics = ((Component)jComponent).getFontMetrics(font);
        return fontMetrics.stringWidth(string);
    }

    public static LineMetrics getLineMetrics(String string, JComponent jComponent, Font font) {
        FontRenderContext fontRenderContext;
        if (string == null) {
            string = "X";
        }
        if (font == null) {
            font = UIManager.getFont("TextField.font");
        }
        if (jComponent == null) {
            if (DefaultRenderContext == null) {
                DefaultRenderContext = new FontRenderContext(new AffineTransform(), false, false);
            }
            fontRenderContext = DefaultRenderContext;
        } else {
            Graphics2D graphics2D = (Graphics2D)jComponent.getGraphics();
            if (graphics2D != null) {
                fontRenderContext = graphics2D.getFontRenderContext();
            } else {
                if (DefaultRenderContext == null) {
                    DefaultRenderContext = new FontRenderContext(new AffineTransform(), false, false);
                }
                fontRenderContext = DefaultRenderContext;
            }
        }
        return font.getLineMetrics(string, fontRenderContext);
    }

    public static void configureRendererComponent(JTable jTable, Object object, JComponent jComponent, boolean bl, boolean bl2, int n2, int n3) {
        if (bl) {
            jComponent.setForeground(jTable.getSelectionForeground());
            jComponent.setBackground(jTable.getSelectionBackground());
        } else {
            boolean bl3 = false;
            if (jTable.getModel() instanceof AssistTableModel) {
                bl3 = jTable.getModel().isCellEditable(n2, jTable.convertColumnIndexToModel(n3));
            } else if (jTable.getModel() instanceof ViewTableModel) {
                ViewTableModel viewTableModel = (ViewTableModel)jTable.getModel();
                bl3 = ((ViewObjectInterface)viewTableModel.getDataVector().elementAt(n2)).isEditable(jTable.convertColumnIndexToModel(n3), object);
            }
            if (bl3) {
                jComponent.setForeground(UIManager.getColor("controlText"));
                jComponent.setBackground(UIManager.getColor("window"));
            } else {
                jComponent.setForeground(UIManager.getColor("controlText"));
                jComponent.setBackground(UIManager.getColor("control"));
            }
        }
        jComponent.setFont(jTable.getFont());
        if (bl2) {
            jComponent.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
        } else {
            jComponent.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        }
        if (jComponent instanceof JLabel && jTable.getModel().getColumnClass(jTable.convertColumnIndexToModel(n3)) == (class$java$lang$Number == null ? (class$java$lang$Number = AssistManager.class$("java.lang.Number")) : class$java$lang$Number)) {
            ((JLabel)jComponent).setHorizontalAlignment(4);
        }
    }

    public static synchronized String blankWhitespaces(String string) {
        if (string == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = string.length();
        int n3 = 0;
        while (n3 < n2) {
            char c2 = string.charAt(n3);
            if (Character.isWhitespace(c2)) {
                c2 = ' ';
            }
            stringBuffer.append(c2);
            ++n3;
        }
        return stringBuffer.toString();
    }

    public static boolean isJavaVersionAtLeast(int n2, int n3, int n4) {
        if (jvVersion == 0) {
            String string = System.getProperty("java.version");
            StringTokenizer stringTokenizer = new StringTokenizer(string, ".", false);
            try {
                jvVersion = Integer.parseInt(stringTokenizer.nextToken());
                jvRelease = Integer.parseInt(stringTokenizer.nextToken());
                jvModification = Integer.parseInt(stringTokenizer.nextToken());
            }
            catch (NumberFormatException numberFormatException) {
                return true;
            }
            catch (NoSuchElementException noSuchElementException) {
                return true;
            }
        }
        return n2 <= jvVersion && n3 <= jvRelease && n4 <= jvModification;
    }

    public static Component getDescendantOfClass(Container container, Class clazz) {
        Component component = null;
        Component[] componentArray = container.getComponents();
        int n2 = componentArray.length;
        int n3 = 0;
        while (n3 < n2) {
            if (clazz.isInstance(componentArray[n3])) {
                return componentArray[n3];
            }
            ++n3;
        }
        n3 = 0;
        while (n3 < n2) {
            if (componentArray[n3] instanceof Container) {
                component = AssistManager.getDescendantOfClass((Container)componentArray[n3], clazz);
            }
            if (component != null) {
                return component;
            }
            ++n3;
        }
        return null;
    }

    public static boolean isDescendant(Container container, Component component) {
        Object var2_2 = null;
        Component[] componentArray = container.getComponents();
        int n2 = componentArray.length;
        int n3 = 0;
        while (n3 < n2) {
            if (component == componentArray[n3]) {
                return true;
            }
            ++n3;
        }
        n3 = 0;
        while (n3 < n2) {
            if (componentArray[n3] instanceof Container && AssistManager.isDescendant((Container)componentArray[n3], component)) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    public static Component getFocusableChild(Container container) {
        Component component = null;
        Component[] componentArray = container.getComponents();
        int n2 = componentArray.length;
        int n3 = 0;
        while (n3 < n2) {
            if (componentArray[n3].isFocusTraversable()) {
                return componentArray[n3];
            }
            ++n3;
        }
        n3 = 0;
        while (n3 < n2) {
            if (componentArray[n3] instanceof Container) {
                component = AssistManager.getFocusableChild((Container)componentArray[n3]);
            }
            if (component != null) {
                return component;
            }
            ++n3;
        }
        return null;
    }

    public static String toUpperCase(String string) {
        return AssistManager.toUpperCase(string, AssistManager.getPreferredLanguage());
    }

    public static String toUpperCase(String string, Locale locale) {
        String string2 = string.toUpperCase(locale);
        if (string2.indexOf(223) > -1) {
            char[] cArray = string2.toCharArray();
            StringBuffer stringBuffer = new StringBuffer(cArray.length + 10);
            int n2 = 0;
            while (n2 < cArray.length) {
                switch (cArray[n2]) {
                    case '\u00df': {
                        stringBuffer.append("SS");
                        break;
                    }
                    default: {
                        stringBuffer.append(cArray[n2]);
                    }
                }
                ++n2;
            }
            string2 = stringBuffer.toString();
        }
        return string2;
    }

    public static String buildPatternToken(String string, char c2, char c3, boolean bl) {
        if (string == null) {
            return null;
        }
        String string2 = string.trim();
        if (string2.length() == 0 || string2.charAt(0) == c3) {
            return new String(string2);
        }
        if (string2.charAt(0) == '\"') {
            if (string2.charAt(string2.length() - 1) != '\"') {
                return string2;
            }
            char[] cArray = new char[]{c3};
            char[] cArray2 = new char[]{c2};
            String string3 = new String(cArray);
            String string4 = new String(cArray2);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(c3).append(AssistManager.undelimited(string2, string3, string4)).append(c3);
            return stringBuffer.toString();
        }
        StringBuffer stringBuffer = new StringBuffer(string2);
        int n2 = 0;
        while (n2 < stringBuffer.length()) {
            char c4 = stringBuffer.charAt(n2);
            if (c4 == c3) {
                stringBuffer.insert(n2, c3);
                ++n2;
            } else if (bl && 'a' <= c4 && c4 <= 'z') {
                stringBuffer.setCharAt(n2, Character.toUpperCase(c4));
            }
            ++n2;
        }
        stringBuffer.insert(0, c3);
        stringBuffer.append(c3);
        return stringBuffer.toString();
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     */
    public static String buildPatternExpression(String var0, char var1_1, char var2_2, boolean var3_3, int var4_4, boolean var5_5) {
        var6_6 = null;
        if (CommonTrace.isTrace()) {
            var6_6 = CommonTrace.create("common", "CMUtil", "buildPatternExpression(String srcStr, char escCh, char delimiter, boolean bCommaToAnd, int maxTokens, boolean foldToUpper)", new Object[]{var0, new Character(var1_1), new Character(var2_2), new Boolean(var3_3), new Integer(var4_4), new Boolean(var5_5)});
        }
        var7_7 = 0;
        var8_8 = 1;
        var9_9 = 2;
        var10_10 = 3;
        var11_11 = 1;
        var12_12 = 2;
        var13_13 = 0;
        var14_14 = 0;
        var15_15 = false;
        var17_16 = var2_2;
        if (var0 == null) {
            return (String)CommonTrace.exit(var6_6, null);
        }
        if (var0.length() == 0) {
            return (String)CommonTrace.exit(var6_6, var0);
        }
        var18_17 = var7_7;
        var19_18 = var12_12;
        var22_19 = new StringBuffer(var0);
        var23_20 = 0;
        while (var23_20 < var22_19.length()) {
            block50: {
                block62: {
                    block59: {
                        block61: {
                            block60: {
                                block57: {
                                    block58: {
                                        block55: {
                                            block56: {
                                                block54: {
                                                    block51: {
                                                        block53: {
                                                            block52: {
                                                                var20_21 = false;
                                                                var21_22 = var22_19.charAt(var23_20);
                                                                if (var21_22 != var2_2 && var21_22 != '\"') break block51;
                                                                if (var18_17 != var7_7) break block52;
                                                                var13_13 = var23_20;
                                                                ++var14_14;
                                                                var18_17 = var8_8;
                                                                var15_15 = true;
                                                                var17_16 = var21_22;
                                                                if (var21_22 == '\"') {
                                                                    var22_19.setCharAt(var23_20, var2_2);
                                                                }
                                                                break block50;
                                                            }
                                                            if (var18_17 != var8_8) break block53;
                                                            if (var21_22 == var17_16) {
                                                                var18_17 = var10_10;
                                                                break block50;
                                                            } else if (var17_16 == '\"') {
                                                                var22_19.insert(var23_20, var2_2);
                                                                ++var23_20;
                                                            }
                                                            break block50;
                                                        }
                                                        if (var18_17 == var10_10) {
                                                            var18_17 = var8_8;
                                                            if (var21_22 == '\"') {
                                                                var24_23 = var22_19.toString();
                                                                var22_19.setLength(0);
                                                                var22_19.append(var24_23.substring(0, var23_20 - 1)).append('\"').append(var24_23.substring(var23_20 + 1, var24_23.length()));
                                                                --var23_20;
                                                            }
                                                            break block50;
                                                        } else if (var21_22 == var2_2) {
                                                            var22_19.insert(var23_20, var2_2);
                                                            ++var23_20;
                                                        }
                                                        break block50;
                                                    }
                                                    if (var21_22 != var1_1) break block54;
                                                    if (var18_17 == var7_7) {
                                                        var13_13 = var23_20;
                                                        var22_19.insert(var23_20, var1_1);
                                                        ++var23_20;
                                                        ++var14_14;
                                                        var18_17 = var9_9;
                                                        var15_15 = false;
                                                        break block50;
                                                    } else if (var18_17 == var9_9) {
                                                        var22_19.insert(var23_20, var1_1);
                                                        ++var23_20;
                                                        break block50;
                                                    } else {
                                                        if (var18_17 != var8_8) {
                                                            CommonTrace.write(var6_6, "Error: escape char used outside a quoted expression!!");
                                                            return (String)CommonTrace.exit(var6_6, new String(var0));
                                                        }
                                                        var19_18 = var19_18 == var11_11 ? var12_12 : var11_11;
                                                    }
                                                    break block50;
                                                }
                                                if (var21_22 != '_' && var21_22 != '%') break block55;
                                                if (var18_17 != var7_7) break block56;
                                                var13_13 = var23_20;
                                                ++var14_14;
                                                var18_17 = var9_9;
                                                var15_15 = false;
                                                break block50;
                                            }
                                            if (var18_17 != var9_9) {
                                                if (var18_17 != var8_8) {
                                                    CommonTrace.write(var6_6, "Error: special char used outside a quoted expression!!");
                                                    return (String)CommonTrace.exit(var6_6, new String(var0));
                                                }
                                                if (var19_18 == var11_11) {
                                                    var19_18 = var12_12;
                                                }
                                            }
                                            break block50;
                                        }
                                        if (var21_22 != ',') break block57;
                                        if (var18_17 == var7_7) {
                                            CommonTrace.write(var6_6, "Error: missing token between 2 commas!!");
                                            return (String)CommonTrace.exit(var6_6, new String(var0));
                                        }
                                        if (var18_17 != var9_9) break block58;
                                        if (var15_15) break block59;
                                        var24_24 = var23_20 - 1;
                                        if (true) ** GOTO lbl152
                                    }
                                    if (var18_17 == var10_10) {
                                        if (var22_19.charAt(var23_20 - 1) == '\"') {
                                            var22_19.setCharAt(var23_20 - 1, var2_2);
                                        }
                                        if (var3_3) {
                                            if (var22_19.charAt(var23_20 - 1) != ' ') {
                                                var22_19.insert(var23_20, ' ');
                                                ++var23_20;
                                            }
                                            var22_19.setCharAt(var23_20, 'A');
                                            var22_19.insert(var23_20 + 1, 'N');
                                            var22_19.insert(++var23_20 + 1, 'D');
                                            if (var22_19.charAt(++var23_20 + 1) != ' ') {
                                                var22_19.insert(var23_20 + 1, ' ');
                                                ++var23_20;
                                            }
                                        }
                                        var18_17 = var7_7;
                                    }
                                    break block50;
                                }
                                if (var21_22 != ' ') break block60;
                                if (var18_17 == var7_7) {
                                    var13_13 = var23_20;
                                    break block50;
                                } else if (var18_17 == var10_10 && var22_19.charAt(var23_20 - 1) == '\"') {
                                    var22_19.setCharAt(var23_20 - 1, var2_2);
                                }
                                break block50;
                            }
                            if (var21_22 != 'A' && var21_22 != 'a') break block61;
                            if (var18_17 == var10_10 && var22_19.charAt(var23_20 - 1) == '\"') {
                                var22_19.setCharAt(var23_20 - 1, var2_2);
                            }
                            var20_21 = true;
                            if (!var3_3 || var18_17 != var9_9 && var18_17 != var10_10 || var22_19.length() <= var23_20 + 3 || var22_19.charAt(var23_20 - 1) != ' ' || var22_19.charAt(var23_20 + 3) != ' ' || var22_19.charAt(var23_20 + 1) != 'N' && var22_19.charAt(var23_20 + 1) != 'n' || var22_19.charAt(var23_20 + 2) != 'D' && var22_19.charAt(var23_20 + 2) != 'd') break block50;
                            var22_19.setCharAt(var23_20, 'A');
                            var22_19.setCharAt(var23_20 + 1, 'N');
                            var22_19.setCharAt(var23_20 + 2, 'D');
                            if (var18_17 != var9_9 || var15_15) break block62;
                            var24_25 = var23_20 - 1;
                            if (true) ** GOTO lbl178
                        }
                        var20_21 = true;
                        break block50;
                        do {
                            --var24_24;
lbl152:
                            // 2 sources

                        } while (var22_19.charAt(var24_24) == ' ' && var24_24 > var13_13);
                        var22_19.insert(var24_24 + 1, var2_2);
                        ++var23_20;
                        var22_19.insert(var13_13, var2_2);
                        ++var23_20;
                    }
                    if (var3_3) {
                        if (var22_19.charAt(var23_20 - 1) != ' ') {
                            var22_19.insert(var23_20, ' ');
                            ++var23_20;
                        }
                        var22_19.setCharAt(var23_20, 'A');
                        var22_19.insert(var23_20 + 1, 'N');
                        var22_19.insert(++var23_20 + 1, 'D');
                        if (var22_19.charAt(++var23_20 + 1) != ' ') {
                            var22_19.insert(var23_20 + 1, ' ');
                            ++var23_20;
                        }
                    }
                    var18_17 = var7_7;
                    break block50;
                    do {
                        --var24_25;
lbl178:
                        // 2 sources

                    } while (var22_19.charAt(var24_25) == ' ' && var24_25 > var13_13);
                    var22_19.insert(var24_25 + 1, var2_2);
                    ++var23_20;
                    var22_19.insert(var13_13, var2_2);
                    ++var23_20;
                }
                var23_20 += 3;
                var18_17 = var7_7;
                var20_21 = false;
            }
            if (var20_21) {
                if (var18_17 == var7_7) {
                    var13_13 = var23_20;
                    ++var14_14;
                    var18_17 = var9_9;
                    var15_15 = false;
                    if (var5_5 && 'a' <= var21_22 && var21_22 <= 'z') {
                        var22_19.setCharAt(var23_20, Character.toUpperCase(var21_22));
                    }
                } else if (var18_17 == var9_9) {
                    if (var5_5 && 'a' <= var21_22 && var21_22 <= 'z') {
                        var22_19.setCharAt(var23_20, Character.toUpperCase(var21_22));
                    }
                } else {
                    if (var18_17 == var10_10) {
                        CommonTrace.write(var6_6, "Error: invalid char follows right after quoted token!!");
                        return (String)CommonTrace.exit(var6_6, new String(var0));
                    }
                    if (var18_17 == var8_8 && var19_18 == var11_11) {
                        CommonTrace.write(var6_6, "Error: escape char must be followed by esc, %, or _!!");
                        return (String)CommonTrace.exit(var6_6, new String(var0));
                    }
                }
            }
            CommonTrace.write(var6_6, "state=" + var18_17 + "; state2=" + var19_18 + "; nbrTokens=" + var14_14);
            ++var23_20;
        }
        if (var18_17 == var10_10 && var22_19.charAt(var24_26 = var22_19.length() - 1) == '\"') {
            var22_19.setCharAt(var24_26, var2_2);
        }
        if (var18_17 == var8_8 || var18_17 == var7_7 && var14_14 > 0) {
            CommonTrace.write(var6_6, "Error: missing matching closing quote or missing token!!");
            return (String)CommonTrace.exit(var6_6, new String(var0));
        }
        if (var19_18 == var11_11) {
            CommonTrace.write(var6_6, "Error: escape char by itself in a quoted expression!!");
            return (String)CommonTrace.exit(var6_6, new String(var0));
        }
        if (var4_4 > 0 && var14_14 > var4_4) {
            CommonTrace.write(var6_6, "Error: too many tokens in the expression!!");
            return (String)CommonTrace.exit(var6_6, new String(var0));
        }
        if (var14_14 > 0 && var18_17 == var9_9) {
            var24_27 = var22_19.length() - 1;
            while (var22_19.charAt(var24_27) == ' ' && var24_27 > var13_13) {
                --var24_27;
            }
            var22_19.insert(var24_27 + 1, var2_2);
            var22_19.insert(var13_13, var2_2);
        }
        CommonTrace.write(var6_6, "String returned=" + var22_19.toString());
        return (String)CommonTrace.exit(var6_6, var22_19.toString());
    }

    public static String undelimited(String string, String string2) {
        String string3 = string2.equals("\"") ? "'" : "\"";
        return AssistManager.undelimited(string, string2, string3);
    }

    public static String undelimited(String string, String string2, String string3) {
        boolean bl = false;
        int n2 = 0;
        String string4 = "";
        char c2 = string2.charAt(0);
        char c3 = string3.charAt(0);
        int n3 = string.length();
        if (n3 > 0) {
            char[] cArray = string.toCharArray();
            if (cArray[0] == c3) {
                bl = true;
                ++n2;
                --n3;
            }
            while (n2 < n3) {
                string4 = bl || 'a' > cArray[n2] || cArray[n2] > 'z' ? string4 + new Character(cArray[n2]).toString() : string4 + new Character(Character.toUpperCase(cArray[n2])).toString();
                if (cArray[n2] == c2) {
                    string4 = string4 + string2;
                }
                if (cArray[n2] == c3 && cArray[n2 + 1] == c3) {
                    ++n2;
                }
                ++n2;
            }
        }
        return string4;
    }

    public static boolean arrayequals(Object object, Object object2) {
        if (object == object2) {
            return true;
        }
        if (object != null && object2 != null && object.getClass().isArray() && object2.getClass().isArray() && object.getClass().getComponentType().equals(object2.getClass().getComponentType())) {
            Class<?> clazz = object.getClass().getComponentType();
            int n2 = Array.getLength(object);
            if (n2 == Array.getLength(object2)) {
                int n3 = 0;
                while (n3 < n2) {
                    if (clazz.isArray() ? !AssistManager.arrayequals(Array.get(object, n3), Array.get(object2, n3)) : !Array.get(object, n3).equals(Array.get(object2, n3))) {
                        return false;
                    }
                    ++n3;
                }
                return true;
            }
            return false;
        }
        return object == null && object2 == null;
    }

    public static void registerLibrary(String string) {
        if (string != null && string.length() > 0) {
            cutilLibrary = string;
        }
    }

    public static String getRegisteredLibrary() {
        return cutilLibrary;
    }

    public static int[] getDB2Levels() {
        int n2;
        String string;
        if (db2Levels == null && (string = AssistManager.getLevelInfo()) != null && (n2 = string.indexOf("DB2 v")) > -1) {
            n2 += 5;
            db2Levels = new int[4];
            try {
                int n3 = string.indexOf(".", n2);
                AssistManager.db2Levels[0] = Integer.parseInt(string.substring(n2, n3));
                n2 = n3 + 1;
                n3 = string.indexOf(".", n2);
                AssistManager.db2Levels[1] = Integer.parseInt(string.substring(n2, n3));
                n2 = n3 + 1;
                n3 = string.indexOf(".", n2);
                AssistManager.db2Levels[2] = Integer.parseInt(string.substring(n2, n3));
                n2 = n3 + 1;
                n3 = string.indexOf("\"", n2);
                AssistManager.db2Levels[3] = Integer.parseInt(string.substring(n2, n3));
            }
            catch (NumberFormatException numberFormatException) {
                db2Levels = null;
            }
        }
        return db2Levels;
    }

    protected static String getLevelInfo() {
        Runtime runtime = Runtime.getRuntime();
        try {
            String[] stringArray = new String[]{};
            Process process = runtime.exec("db2level", stringArray);
            process.waitFor();
            int n2 = process.exitValue();
            InputStreamReader inputStreamReader = new InputStreamReader(new BufferedInputStream(process.getInputStream()));
            char[] cArray = new char[350];
            int n3 = inputStreamReader.read(cArray, 0, 350);
            return new String(cArray, 0, n3);
        }
        catch (SecurityException securityException) {
        }
        catch (InterruptedException interruptedException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        languagePolicy = "DB2";
        localePolicy = "DB2";
        lookAndFeel = "init";
        AssistManager.updateUI();
        AssistManager.loadVKeys();
        borderCache = new Hashtable(27);
        zeroInsets = new Insets(0, 0, 0, 0);
        jvVersion = 0;
        jvRelease = 0;
        jvModification = 0;
        cutilLibrary = "db2jcc";
        db2Levels = null;
    }

    public static class RedirectedKeyEvent
    extends KeyEvent {
        public RedirectedKeyEvent(Component component, int n2, long l2, int n3, int n4, char c2) {
            super(component, n2, l2, n3, n4, c2);
        }

        public void setSource(Object object) {
        }
    }
}

