/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common.support;

import com.ibm.db2.tools.common.support.AssistCollator;
import java.io.Serializable;
import java.text.CollationKey;

public class AssistKey
implements Comparable,
Serializable {
    private static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected int index = -1;
    protected byte[] key;

    public AssistKey(int n2, CollationKey collationKey) {
        this.index = n2;
        this.key = collationKey.toByteArray();
    }

    public AssistKey(int n2, byte[] byArray) {
        this.index = n2;
        this.key = byArray;
    }

    public byte[] getKey() {
        return this.key;
    }

    public int compareTo(Object object) {
        if (object instanceof AssistKey) {
            return this.compareTo((AssistKey)object);
        }
        if (object instanceof CollationKey) {
            return this.compareTo((CollationKey)object);
        }
        return this.compareTo(((AssistCollator)AssistCollator.getInstance()).getCollationKey(object, 0));
    }

    public int compareTo(AssistKey assistKey) {
        int n2 = this.key.length;
        byte[] byArray = assistKey.getKey();
        int n3 = byArray.length;
        int n4 = n2 <= n3 ? n2 : n3;
        int n5 = 0;
        while (n5 < n4) {
            int n6 = (this.key[n5] & 0xFF) << 16;
            int n7 = (byArray[n5++] & 0xFF) << 16;
            if (n5 < n4) {
                n6 |= (this.key[n5] & 0xFF) << 8;
                n7 |= (byArray[n5++] & 0xFF) << 8;
            }
            if (n5 < n4) {
                n6 |= this.key[n5] & 0xFF;
                n7 |= byArray[n5++] & 0xFF;
            }
            if (n6 == n7) continue;
            return n6 - n7;
        }
        return n2 - n3;
    }

    public int compareTo(CollationKey collationKey) {
        int n2 = this.key.length;
        byte[] byArray = collationKey.toByteArray();
        int n3 = byArray.length;
        int n4 = n2 <= n3 ? n2 : n3;
        int n5 = 0;
        while (n4-- != 0) {
            int n6;
            int n7 = this.key[n5] & 0xFF;
            if (n7 == (n6 = byArray[n5++] & 0xFF)) continue;
            return n7 - n6;
        }
        return n2 - n3;
    }

    public boolean equals(Object object) {
        if (object instanceof AssistKey) {
            return this.compareTo((AssistKey)object) == 0;
        }
        return this.compareTo((CollationKey)object) == 0;
    }

    public int hashCode() {
        int n2 = 0;
        int n3 = 0;
        int n4 = this.key.length;
        if (n4 < 16) {
            int n5 = n4;
            while (n5 > 0) {
                n2 = n2 * 37 + this.key[n3++];
                --n5;
            }
        } else {
            int n6 = n4 / 8;
            int n7 = n4;
            while (n7 > 0) {
                n2 = n2 * 39 + this.key[n3];
                n7 -= n6;
                n3 += n6;
            }
        }
        return n2;
    }

    public int getSourceIndex() {
        return this.index;
    }

    public void setSourceIndex(int n2) {
        this.index = n2;
    }

    public byte[] toByteArray() {
        return this.key;
    }
}

