/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common.support;

import java.io.Serializable;
import java.util.NoSuchElementException;

public class AssistIndex
implements Serializable {
    private static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected int[] intData;
    protected boolean descending;
    protected int intCount;
    protected int capacityIncrement;

    public AssistIndex(int n2, int n3) {
        this.intData = new int[n2];
        this.capacityIncrement = n3;
    }

    public AssistIndex(int n2) {
        this(n2, 0);
    }

    public AssistIndex() {
        this(10);
    }

    public synchronized void ensureCapacity(int n2) {
        if (n2 > this.intData.length) {
            this.ensureCapacityHelper(n2);
        }
    }

    protected void ensureCapacityHelper(int n2) {
        int n3;
        int n4 = this.intData.length;
        int[] nArray = this.intData;
        int n5 = n3 = this.capacityIncrement > 0 ? n4 + this.capacityIncrement : n4 * 2;
        if (n3 < n2) {
            n3 = n2;
        }
        this.intData = new int[n3];
        System.arraycopy(nArray, 0, this.intData, 0, this.intCount);
    }

    public synchronized void setSize(int n2) {
        if (n2 > this.intCount && n2 > this.intData.length) {
            this.ensureCapacityHelper(n2);
        }
        this.intCount = n2;
    }

    public int capacity() {
        return this.intData.length;
    }

    public int size() {
        return this.intCount;
    }

    public boolean isEmpty() {
        return this.intCount == 0;
    }

    public boolean getDescending() {
        return this.descending;
    }

    public void setDescending(boolean bl) {
        this.descending = bl;
    }

    public int positionOf(int n2) {
        if (n2 < 0) {
            throw new ArrayIndexOutOfBoundsException(n2 + " < 0");
        }
        if (n2 >= this.intCount) {
            throw new ArrayIndexOutOfBoundsException(n2 + " >= " + this.intCount);
        }
        return this.indexOf(n2);
    }

    public int indexOf(int n2) {
        return this.indexOf(n2, 0);
    }

    public synchronized int indexOf(int n2, int n3) {
        if (this.descending) {
            int n4 = this.intCount - n3 - 1;
            while (n4 > -1) {
                if (n2 == this.intData[n4]) {
                    return this.intCount - n4 - 1;
                }
                --n4;
            }
        } else {
            int n5 = n3;
            while (n5 < this.intCount) {
                if (n2 == this.intData[n5]) {
                    return n5;
                }
                ++n5;
            }
        }
        return -1;
    }

    public synchronized int intAt(int n2) {
        if (n2 < 0) {
            throw new ArrayIndexOutOfBoundsException(n2 + " < 0");
        }
        if (n2 >= this.intCount) {
            throw new ArrayIndexOutOfBoundsException(n2 + " >= " + this.intCount);
        }
        return this.descending ? this.intData[this.intCount - n2 - 1] : this.intData[n2];
    }

    public synchronized int firstInt() {
        if (this.intCount == 0) {
            throw new NoSuchElementException();
        }
        return this.descending ? this.intData[this.intCount - 1] : this.intData[0];
    }

    public synchronized int lastInt() {
        if (this.intCount == 0) {
            throw new NoSuchElementException();
        }
        return this.descending ? this.intData[0] : this.intData[this.intCount - 1];
    }

    public synchronized void setIntAt(int n2, int n3) {
        if (n3 >= this.intCount) {
            throw new ArrayIndexOutOfBoundsException(n3 + " >= " + this.intCount);
        }
        if (n3 < 0) {
            throw new ArrayIndexOutOfBoundsException(n3 + " < 0");
        }
        int n4 = this.descending ? this.intCount - n3 - 1 : n3;
        this.intData[n4] = n2;
    }

    public synchronized void swap(int n2, int n3) {
        int n4 = this.descending ? this.intCount - n2 - 1 : n2;
        int n5 = this.descending ? this.intCount - n3 - 1 : n3;
        int n6 = this.intData[n4];
        this.intData[n4] = this.intData[n5];
        this.intData[n5] = n6;
    }

    public synchronized void removeIntAt(int n2) {
        this.removeIntAt(n2, true);
    }

    public synchronized void removeIntAt(int n2, boolean bl) {
        if (n2 >= this.intCount) {
            throw new ArrayIndexOutOfBoundsException(n2 + " >= " + this.intCount);
        }
        if (n2 < 0) {
            throw new ArrayIndexOutOfBoundsException(n2 + " < 0");
        }
        int n3 = this.descending ? this.intCount - n2 - 1 : n2;
        int n4 = this.intData[n3];
        int n5 = this.intCount - n3 - 1;
        if (n5 > 0) {
            System.arraycopy(this.intData, n3 + 1, this.intData, n3, n5);
        }
        if (bl) {
            int n6 = 0;
            while (n6 < this.intCount - 1) {
                if (this.intData[n6] >= n4) {
                    int n7 = n6;
                    this.intData[n7] = this.intData[n7] - 1;
                }
                ++n6;
            }
        }
        --this.intCount;
    }

    public synchronized void insertIntAt(int n2, int n3) {
        this.insertIntAt(n2, n3, true);
    }

    public synchronized void insertIntAt(int n2, int n3, boolean bl) {
        int n4 = this.intCount + 1;
        if (n3 >= n4) {
            throw new ArrayIndexOutOfBoundsException(n3 + " > " + this.intCount);
        }
        if (n3 < 0) {
            throw new ArrayIndexOutOfBoundsException(n3 + " < 0");
        }
        if (n4 > this.intData.length) {
            this.ensureCapacityHelper(n4);
        }
        int n5 = this.descending ? this.intCount - n3 - 1 : n3;
        System.arraycopy(this.intData, n5, this.intData, n5 + 1, this.intCount - n5);
        if (bl) {
            int n6 = 0;
            while (n6 < this.intCount) {
                if (this.intData[n6] >= n5) {
                    int n7 = n6;
                    this.intData[n7] = this.intData[n7] + 1;
                }
                ++n6;
            }
        }
        this.intData[n5] = n2;
        ++this.intCount;
    }

    public synchronized void addInt(int n2) {
        int n3 = this.intCount + 1;
        if (n3 > this.intData.length) {
            this.ensureCapacityHelper(n3);
        }
        this.intData[this.intCount] = n2;
        ++this.intCount;
    }

    public synchronized void removeAllInts() {
        this.intCount = 0;
    }

    public synchronized Object clone() {
        AssistIndex assistIndex = new AssistIndex(this.intCount, this.capacityIncrement);
        assistIndex.setDescending(this.descending);
        assistIndex.setIntArray(this.getAscendingIntArray());
        return assistIndex;
    }

    public void setIntArray(int[] nArray) {
        this.intCount = nArray.length;
        System.arraycopy(nArray, 0, this.intData, 0, this.intCount);
    }

    public final int[] getIntArray() {
        if (this.descending) {
            return this.getDescendingIntArray();
        }
        return this.getAscendingIntArray();
    }

    public int[] getAscendingIntArray() {
        int[] nArray = new int[this.intCount];
        System.arraycopy(this.intData, 0, nArray, 0, this.intCount);
        return nArray;
    }

    public int[] getDescendingIntArray() {
        int[] nArray = new int[this.intCount];
        int n2 = this.intCount - 1;
        int n3 = 0;
        while (n3 < this.intCount) {
            nArray[n2] = this.intData[n3];
            --n2;
            ++n3;
        }
        return nArray;
    }

    public void shift(int n2, boolean bl, boolean bl2) {
        boolean bl3;
        int n3 = this.intCount - n2;
        boolean bl4 = this.descending ? !bl : (bl3 = bl);
        if (bl2) {
            int[] nArray = new int[n2];
            if (bl3) {
                System.arraycopy(this.intData, n3, nArray, 0, n2);
                System.arraycopy(this.intData, 0, this.intData, n2, n3);
                System.arraycopy(nArray, 0, this.intData, 0, n2);
            } else {
                System.arraycopy(this.intData, 0, nArray, 0, n2);
                System.arraycopy(this.intData, n2, this.intData, 0, n3);
                System.arraycopy(nArray, 0, this.intData, n3, n2);
            }
        } else if (bl3) {
            System.arraycopy(this.intData, 0, this.intData, n2, n3);
            int n4 = 0;
            while (n4 < n2) {
                this.intData[n4] = -1;
                ++n4;
            }
        } else {
            System.arraycopy(this.intData, n2, this.intData, 0, n3);
            int n5 = 0;
            while (n5 < n2) {
                this.intData[n3 + n5] = -1;
                ++n5;
            }
        }
    }

    public synchronized String toString() {
        int n2 = this.intCount - 1;
        StringBuffer stringBuffer = new StringBuffer("[");
        if (this.descending) {
            int n3 = n2;
            while (n3 > -1) {
                stringBuffer.append(this.intData[n3]);
                if (n3 > 0) {
                    stringBuffer.append(",");
                }
                --n3;
            }
        } else {
            int n4 = 0;
            while (n4 <= n2) {
                stringBuffer.append(this.intData[n4]);
                if (n4 < n2) {
                    stringBuffer.append(",");
                }
                ++n4;
            }
        }
        stringBuffer.append("]");
        stringBuffer.append(", descending: " + this.descending);
        return stringBuffer.toString();
    }
}

