/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common.support;

import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.text.BreakIterator;
import java.util.Hashtable;
import javax.swing.Action;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JRootPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import javax.swing.text.TextAction;
import javax.swing.text.Utilities;

public class AssistEditorKit
extends DefaultEditorKit
implements Serializable {
    private static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String defaultButtonPress = "defaultButtonPress";
    public static final String defaultButtonRelease = "defaultButtonRelease";
    protected static Hashtable textActions;

    public static Action getTextAction(String string) {
        if (textActions == null) {
            textActions = AssistEditorKit.setTextActions(new DefaultEditorKit().getActions());
        }
        return (Action)textActions.get(string);
    }

    public static Hashtable setTextActions(Action[] actionArray) {
        Hashtable<Object, Action> hashtable = new Hashtable<Object, Action>(actionArray.length * 5);
        int n2 = 0;
        while (n2 < actionArray.length) {
            hashtable.put(actionArray[n2].getValue("Name"), actionArray[n2]);
            ++n2;
        }
        hashtable.put("default-typed", new DefaultKeyTypedAction());
        hashtable.put("caret-forward", new ForwardAction2("caret-forward", false));
        hashtable.put("caret-backward", new BackwardAction2("caret-backward", false));
        hashtable.put("caret-previous-word", new PreviousWordAction("caret-previous-word", false));
        hashtable.put("selection-previous-word", new PreviousWordAction("selection-previous-word", true));
        hashtable.put("caret-next-word", new NextWordAction("caret-next-word", false));
        hashtable.put("selection-next-word", new NextWordAction("selection-next-word", true));
        hashtable.put(defaultButtonPress, new DefaultButtonAction(defaultButtonPress, true));
        hashtable.put(defaultButtonRelease, new DefaultButtonAction(defaultButtonRelease, false));
        hashtable.put("paste-from-clipboard", new PasteAction());
        return hashtable;
    }

    public static void enhanceKeymap(Keymap keymap) {
        if (keymap == null) {
            return;
        }
        keymap.setDefaultAction(AssistEditorKit.getTextAction("default-typed"));
        keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(36, 2), AssistEditorKit.getTextAction("caret-begin"));
        keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(35, 2), AssistEditorKit.getTextAction("caret-end"));
        keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(39, 2), AssistEditorKit.getTextAction("caret-next-word"));
        keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(37, 2), AssistEditorKit.getTextAction("caret-previous-word"));
        keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(37, 0), AssistEditorKit.getTextAction("caret-backward"));
        keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(39, 0), AssistEditorKit.getTextAction("caret-forward"));
        keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(36, 3), AssistEditorKit.getTextAction("selection-begin"));
        keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(35, 3), AssistEditorKit.getTextAction("selection-end"));
        keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(39, 3), AssistEditorKit.getTextAction("selection-next-word"));
        keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(37, 3), AssistEditorKit.getTextAction("selection-previous-word"));
        keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(155, 2), AssistEditorKit.getTextAction("copy-to-clipboard"));
        keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(88, 2), AssistEditorKit.getTextAction("cut-to-clipboard"));
        keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(67, 2), AssistEditorKit.getTextAction("copy-to-clipboard"));
        keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(86, 2), AssistEditorKit.getTextAction("paste-from-clipboard"));
        keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(155, 1), AssistEditorKit.getTextAction("paste-from-clipboard"));
        keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(127, 1), AssistEditorKit.getTextAction("cut-to-clipboard"));
    }

    public static int getNextWord(JTextComponent jTextComponent, int n2) throws BadLocationException {
        Element element = Utilities.getParagraphElement(jTextComponent, n2);
        int n3 = AssistEditorKit.getNextWordInParagraph(element, n2, false);
        while (n3 == -1) {
            n2 = element.getEndOffset();
            if ((element = Utilities.getParagraphElement(jTextComponent, n2)) == null) break;
            n3 = AssistEditorKit.getNextWordInParagraph(element, n2, true);
        }
        return n3;
    }

    static int getNextWordInParagraph(Element element, int n2, boolean bl) throws BadLocationException {
        if (element == null) {
            throw new BadLocationException("No more words", n2);
        }
        Document document = element.getDocument();
        int n3 = element.getStartOffset();
        int n4 = Math.min(element.getEndOffset(), document.getLength());
        if (n2 >= n4 || n2 < n3) {
            throw new BadLocationException("No more words", n2);
        }
        String string = document.getText(n3, n4 - n3);
        BreakIterator breakIterator = BreakIterator.getWordInstance();
        breakIterator.setText(string);
        if (bl && breakIterator.first() == n2 - n3 && !Character.isWhitespace(string.charAt(breakIterator.first()))) {
            return n2;
        }
        int n5 = breakIterator.following(n2 - n3);
        if (n5 == -1 || n5 >= string.length()) {
            return -1;
        }
        char c2 = string.charAt(n5);
        if (!Character.isWhitespace(c2)) {
            return n3 + n5;
        }
        n5 = breakIterator.next();
        if (n5 != -1 && (n2 = n3 + n5) != n4) {
            return n2;
        }
        return -1;
    }

    public static boolean canPaste(JTextComponent jTextComponent) {
        boolean bl;
        block5: {
            bl = false;
            Transferable transferable = jTextComponent.getToolkit().getSystemClipboard().getContents(jTextComponent);
            if (transferable != null) {
                try {
                    String string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                    if (string == null || string.length() <= 0) break block5;
                    char[] cArray = string.toCharArray();
                    int n2 = 0;
                    while (n2 < cArray.length) {
                        if (AssistEditorKit.isPastable(cArray[n2], jTextComponent)) {
                            bl = true;
                            break;
                        }
                        ++n2;
                    }
                }
                catch (Exception exception) {
                    bl = false;
                }
            }
        }
        return bl;
    }

    public static boolean isPastable(char c2, JTextComponent jTextComponent) {
        switch (Character.getType(c2)) {
            case 0: 
            case 16: 
            case 18: {
                return false;
            }
            case 15: {
                return !(!(jTextComponent instanceof JTextArea) && !(jTextComponent instanceof JEditorPane) || c2 != '\n' && c2 != '\t' && c2 != '\r');
            }
            case 13: 
            case 14: {
                return jTextComponent instanceof JTextArea;
            }
        }
        return true;
    }

    public static String getPastable(JTextComponent jTextComponent) {
        Toolkit toolkit = jTextComponent.getToolkit();
        Transferable transferable = toolkit.getSystemClipboard().getContents(jTextComponent);
        if (transferable != null) {
            try {
                String string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                if (string != null && string.length() > 0) {
                    char[] cArray = string.toCharArray();
                    StringBuffer stringBuffer = new StringBuffer(cArray.length);
                    int n2 = 0;
                    while (n2 < cArray.length) {
                        if (AssistEditorKit.isPastable(cArray[n2], jTextComponent)) {
                            stringBuffer.append(cArray[n2]);
                        }
                        ++n2;
                    }
                    if (stringBuffer.length() > 0) {
                        return stringBuffer.toString();
                    }
                    toolkit.beep();
                    return null;
                }
            }
            catch (Exception exception) {
                toolkit.beep();
                return null;
            }
        }
        toolkit.beep();
        return null;
    }

    public static class NextWordAction
    extends TextAction {
        private final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
        private boolean select;

        NextWordAction(String string, boolean bl) {
            super(string);
            this.select = bl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null) {
                try {
                    int n2 = jTextComponent.getCaretPosition();
                    int n3 = AssistEditorKit.getNextWord(jTextComponent, n2);
                    int n4 = jTextComponent.getText().length();
                    n2 = n3 == -1 && n2 < n4 ? n4 : n3;
                    if (this.select) {
                        jTextComponent.moveCaretPosition(n2);
                    } else {
                        jTextComponent.setCaretPosition(n2);
                    }
                }
                catch (BadLocationException badLocationException) {
                    jTextComponent.getToolkit().beep();
                }
            }
        }
    }

    public static class PasteAction
    extends TextAction {
        private final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

        public PasteAction() {
            super("paste-from-clipboard");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (AssistEditorKit.canPaste(jTextComponent)) {
                if (jTextComponent != null && jTextComponent.isEditable()) {
                    jTextComponent.paste();
                }
            } else {
                jTextComponent.getToolkit().beep();
            }
        }
    }

    protected static class PreviousWordAction
    extends TextAction {
        private final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
        private boolean select;

        PreviousWordAction(String string, boolean bl) {
            super(string);
            this.select = bl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null) {
                try {
                    int n2 = jTextComponent.getCaretPosition();
                    int n3 = Utilities.getPreviousWord(jTextComponent, n2);
                    n3 = Utilities.getWordStart(jTextComponent, n3);
                    if (n3 == n2 && n3 > 0) {
                        --n3;
                        n3 = Utilities.getPreviousWord(jTextComponent, n3);
                        ++n3;
                    }
                    if (this.select) {
                        jTextComponent.moveCaretPosition(n3);
                    } else {
                        jTextComponent.setCaretPosition(n3);
                    }
                }
                catch (BadLocationException badLocationException) {
                    jTextComponent.getToolkit().beep();
                }
            }
        }
    }

    protected static class BackwardAction2
    extends TextAction {
        private final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
        private boolean select;

        BackwardAction2(String string, boolean bl) {
            super(string);
            this.select = bl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null) {
                int n2 = jTextComponent.getCaretPosition();
                if (n2 > 0) {
                    --n2;
                    if (this.select) {
                        jTextComponent.moveCaretPosition(n2);
                    } else {
                        jTextComponent.setCaretPosition(n2);
                    }
                } else if (n2 != jTextComponent.getCaret().getMark()) {
                    jTextComponent.setCaretPosition(n2);
                } else {
                    jTextComponent.getToolkit().beep();
                }
                jTextComponent.getCaret().setMagicCaretPosition(null);
            }
        }
    }

    protected static class ForwardAction2
    extends TextAction {
        private final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
        private boolean select;

        ForwardAction2(String string, boolean bl) {
            super(string);
            this.select = bl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null) {
                Document document = jTextComponent.getDocument();
                int n2 = jTextComponent.getCaretPosition();
                if (n2 < document.getLength()) {
                    ++n2;
                    if (this.select) {
                        jTextComponent.moveCaretPosition(n2);
                    } else {
                        jTextComponent.setCaretPosition(n2);
                    }
                } else if (n2 != jTextComponent.getCaret().getMark()) {
                    jTextComponent.setCaretPosition(n2);
                } else {
                    jTextComponent.getToolkit().beep();
                }
                jTextComponent.getCaret().setMagicCaretPosition(null);
            }
        }
    }

    public static class DefaultKeyTypedAction
    extends TextAction {
        private final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

        public DefaultKeyTypedAction() {
            super("default-typed");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null && actionEvent != null) {
                char c2;
                String string = actionEvent.getActionCommand();
                int n2 = actionEvent.getModifiers();
                if (!jTextComponent.isEditable() || !jTextComponent.isEnabled()) {
                    if (string.charAt(0) == '\u0003') {
                        return;
                    }
                    jTextComponent.getToolkit().beep();
                    return;
                }
                if (string != null && string.length() > 0 && (n2 & 8) == 0 && (c2 = string.charAt(0)) >= ' ' && c2 != '\u007f') {
                    jTextComponent.replaceSelection(string);
                }
            }
        }
    }

    protected static class DefaultButtonAction
    extends TextAction {
        private final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
        protected JButton owner;
        protected JRootPane root;
        protected boolean press;

        DefaultButtonAction(String string, boolean bl) {
            super(bl ? "pressedAction" : "releasedAction");
            this.press = bl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.root = SwingUtilities.getRootPane((JComponent)actionEvent.getSource());
            this.owner = this.root.getDefaultButton();
            if (this.owner != null) {
                ButtonModel buttonModel = this.owner.getModel();
                if (this.press) {
                    buttonModel.setArmed(true);
                    buttonModel.setPressed(true);
                } else {
                    buttonModel.setPressed(false);
                }
            }
        }

        public boolean isEnabled() {
            return this.owner.getModel().isEnabled();
        }
    }
}

