/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common.support;

import com.ibm.db2.tools.common.support.AssistKey;
import com.ibm.db2.tools.common.support.AssistManager;
import com.ibm.db2.tools.common.support.ViewIconNameObjectInterface;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.CollationKey;
import java.text.Collator;
import java.util.Date;
import java.util.Hashtable;
import java.util.Locale;

public class AssistCollator
extends Collator
implements Serializable {
    private static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected transient Collator delegate;
    protected static final BigInteger MAXBIGINTEGER = new BigInteger("99999999999999999999999999999999");
    protected static final Long MINLONG = new Long(Long.MIN_VALUE);
    protected static final Long MAXLONG = new Long(Long.MAX_VALUE);
    protected static final Integer MININTEGER = new Integer(Integer.MIN_VALUE);
    protected static final Short MINSHORT = new Short(Short.MIN_VALUE);
    protected static final Character MINCHAR = new Character('\u0000');
    protected static final Byte MINBYTE = new Byte(-128);
    protected static final byte BYTE0 = 0;
    protected static final byte BYTE1 = 1;
    protected static final byte BYTE2 = 2;
    protected static final byte BYTE3 = 3;
    protected boolean b1;
    protected boolean b2;
    protected double d1;
    protected double d2;
    protected long n1;
    protected long n2;
    protected int i1;
    protected int i2;
    protected int i3;
    protected short s1;
    protected static Hashtable cache = new Hashtable();

    protected AssistCollator(Collator collator) {
        this.delegate = collator;
    }

    public static synchronized Collator getInstance() {
        return AssistCollator.getInstance(AssistManager.getPreferredLocale());
    }

    public static synchronized Collator getInstance(Locale locale) {
        AssistCollator assistCollator = (AssistCollator)cache.get(locale);
        if (assistCollator == null) {
            assistCollator = new AssistCollator(Collator.getInstance(locale));
            cache.put(locale, assistCollator);
        }
        return assistCollator;
    }

    public int compare(String string, String string2) {
        if (string == null && string2 == null) {
            return 0;
        }
        if (string == null) {
            return -1;
        }
        if (string2 == null) {
            return 1;
        }
        return this.delegate.compare(string, string2);
    }

    public int compare(Boolean bl, Boolean bl2) {
        if (bl == null && bl2 == null) {
            return 0;
        }
        if (bl == null) {
            return -1;
        }
        if (bl2 == null) {
            return 1;
        }
        this.b1 = bl;
        this.b2 = bl2;
        if (this.b1 == this.b2) {
            return 0;
        }
        if (this.b1) {
            return 1;
        }
        return -1;
    }

    public int compare(BigInteger bigInteger, BigInteger bigInteger2) {
        return bigInteger.compareTo(bigInteger2);
    }

    public int compare(BigDecimal bigDecimal, BigDecimal bigDecimal2) {
        return bigDecimal.compareTo(bigDecimal2);
    }

    public int compare(Number number, Number number2) {
        if (number == null && number2 == null) {
            return 0;
        }
        if (number == null) {
            return -1;
        }
        if (number2 == null) {
            return 1;
        }
        this.d1 = number.doubleValue();
        this.d2 = number2.doubleValue();
        if (this.d1 < this.d2) {
            return -1;
        }
        if (this.d1 > this.d2) {
            return 1;
        }
        return 0;
    }

    public int compare(Character c2, Character c3) {
        return this.compare(c2.toString(), c3.toString());
    }

    public int compare(Date date, Date date2) {
        if (date == null && date2 == null) {
            return 0;
        }
        if (date == null) {
            return -1;
        }
        if (date2 == null) {
            return 1;
        }
        this.n1 = date.getTime();
        this.n2 = date2.getTime();
        if (this.n1 < this.n2) {
            return -1;
        }
        if (this.n1 > this.n2) {
            return 1;
        }
        return 0;
    }

    public int compare(Object object, Object object2) {
        if (object == null && object2 == null) {
            return 0;
        }
        if (object == null) {
            return -1;
        }
        if (object2 == null) {
            return 1;
        }
        if (object instanceof Boolean && object2 instanceof Boolean) {
            return this.compare((Boolean)object, (Boolean)object2);
        }
        if (object instanceof Date && object2 instanceof Date) {
            return this.compare((Date)object, (Date)object2);
        }
        if (object instanceof BigInteger && object2 instanceof BigInteger) {
            return this.compare((BigInteger)object, (BigInteger)object2);
        }
        if (object instanceof BigDecimal && object2 instanceof BigDecimal) {
            return this.compare((BigDecimal)object, (BigDecimal)object2);
        }
        if (object instanceof Number && object2 instanceof Number) {
            return this.compare((Number)object, (Number)object2);
        }
        if (object instanceof Character && object2 instanceof Character) {
            return this.compare((Character)object, (Character)object2);
        }
        if (object instanceof ViewIconNameObjectInterface && object2 instanceof ViewIconNameObjectInterface) {
            return this.compare(((ViewIconNameObjectInterface)object).getName(), ((ViewIconNameObjectInterface)object2).getName());
        }
        if (!(object instanceof String)) {
            object = object.toString();
        }
        if (!(object2 instanceof String)) {
            object2 = object2.toString();
        }
        return this.delegate.compare((String)object, (String)object2);
    }

    public CollationKey getCollationKey(String string) {
        return this.delegate.getCollationKey(string);
    }

    public AssistKey getCollationKey(Object object, int n2) {
        if (object == null) {
            return this.getCollationKey(MINLONG, n2);
        }
        if (object instanceof String) {
            return this.getCollationKey((String)object, n2);
        }
        if (object instanceof Boolean) {
            return this.getCollationKey((Boolean)object, n2);
        }
        if (object instanceof Byte) {
            return this.getCollationKey((Byte)object, n2);
        }
        if (object instanceof Character) {
            return this.getCollationKey((Character)object, n2);
        }
        if (object instanceof Date) {
            return this.getCollationKey((Date)object, n2);
        }
        if (object instanceof Float) {
            return this.getCollationKey((Float)object, n2);
        }
        if (object instanceof Double) {
            return this.getCollationKey((Double)object, n2);
        }
        if (object instanceof Long) {
            return this.getCollationKey((Long)object, n2);
        }
        if (object instanceof Integer) {
            return this.getCollationKey((Integer)object, n2);
        }
        if (object instanceof Short) {
            return this.getCollationKey((Short)object, n2);
        }
        if (object instanceof BigDecimal) {
            return this.getCollationKey((BigDecimal)object, n2);
        }
        if (object instanceof BigInteger) {
            return this.getCollationKey((BigInteger)object, n2);
        }
        if (object instanceof ViewIconNameObjectInterface) {
            return this.getCollationKey(((ViewIconNameObjectInterface)object).getName(), n2);
        }
        return this.getCollationKey(object.toString(), n2);
    }

    public AssistKey getCollationKey(String string, int n2) {
        if (string == null) {
            return this.getCollationKey(MINLONG, n2);
        }
        return new AssistKey(n2, this.delegate.getCollationKey(string));
    }

    public AssistKey getCollationKey(Boolean bl, int n2) {
        if (bl == null) {
            return this.getCollationKey(MINLONG, n2);
        }
        if (bl.booleanValue()) {
            return new AssistKey(n2, new byte[]{2});
        }
        return new AssistKey(n2, new byte[]{1});
    }

    public AssistKey getCollationKey(Byte by, int n2) {
        if (by == null) {
            return this.getCollationKey(MINBYTE, n2);
        }
        return this.getCollationKey(new Short((short)((short)by.byteValue() - (short)MINBYTE.byteValue())), n2);
    }

    public AssistKey getCollationKey(Character c2, int n2) {
        return this.getCollationKey(c2.toString(), n2);
    }

    public AssistKey getCollationKey(Date date, int n2) {
        this.n1 = date.getTime();
        Long l2 = new Long(this.n1);
        return new AssistKey(n2, this.getByteArray(l2));
    }

    public AssistKey getCollationKey(BigInteger bigInteger, int n2) {
        return new AssistKey(n2, this.getByteArray(bigInteger));
    }

    public AssistKey getCollationKey(BigDecimal bigDecimal, int n2) {
        return new AssistKey(n2, this.getByteArray(bigDecimal));
    }

    public AssistKey getCollationKey(Float f2, int n2) {
        return new AssistKey(n2, this.getByteArray(f2));
    }

    public AssistKey getCollationKey(Double d2, int n2) {
        return new AssistKey(n2, this.getByteArray(d2));
    }

    public AssistKey getCollationKey(Long l2, int n2) {
        return new AssistKey(n2, this.getByteArray(l2));
    }

    public AssistKey getCollationKey(Integer n2, int n3) {
        return new AssistKey(n3, this.getByteArray(n2));
    }

    public AssistKey getCollationKey(Short s2, int n2) {
        return new AssistKey(n2, this.getByteArray(s2));
    }

    protected byte[] getByteArray(Object object) {
        if (object == null) {
            return this.getByteArray(MINLONG);
        }
        if (object instanceof String) {
            return this.getByteArray((String)object);
        }
        if (object instanceof Boolean) {
            return this.getByteArray((Boolean)object);
        }
        if (object instanceof Date) {
            return this.getByteArray((Date)object);
        }
        if (object instanceof Float) {
            return this.getByteArray((Float)object);
        }
        if (object instanceof Double) {
            return this.getByteArray((Double)object);
        }
        if (object instanceof Long) {
            return this.getByteArray((Long)object);
        }
        if (object instanceof Integer) {
            return this.getByteArray((Integer)object);
        }
        if (object instanceof Short) {
            return this.getByteArray((Short)object);
        }
        if (object instanceof Character) {
            return this.getByteArray((Character)object);
        }
        if (object instanceof Byte) {
            return this.getByteArray((Byte)object);
        }
        if (object instanceof BigDecimal) {
            return this.getByteArray((BigDecimal)object);
        }
        if (object instanceof BigInteger) {
            return this.getByteArray((BigInteger)object);
        }
        return this.getByteArray(object.toString());
    }

    protected byte[] getByteArray(String string) {
        if (string == null) {
            return this.getByteArray(MINLONG);
        }
        return this.delegate.getCollationKey(string).toByteArray();
    }

    protected byte[] getByteArray(Boolean bl) {
        if (bl == null) {
            return this.getByteArray(MINLONG);
        }
        byte[] byArray = new byte[]{bl != false ? (byte)2 : 1};
        return byArray;
    }

    protected byte[] getByteArray(Date date) {
        this.n1 = date.getTime();
        return this.getByteArray(new Long(this.n1));
    }

    protected byte[] getByteArray(BigDecimal bigDecimal) {
        byte[] byArray;
        this.i1 = bigDecimal.signum();
        if (this.i1 == 0) {
            byArray = new byte[]{2};
        } else {
            byte[] byArray2;
            if (this.i1 < 0) {
                bigDecimal = bigDecimal.negate();
            }
            BigDecimal bigDecimal2 = bigDecimal.setScale(0, 1);
            BigDecimal bigDecimal3 = bigDecimal.subtract(bigDecimal2);
            BigInteger bigInteger = bigDecimal2.toBigInteger();
            if (this.i1 < 0) {
                bigDecimal3 = bigDecimal3.movePointRight(bigDecimal.scale());
                bigInteger = MAXBIGINTEGER.subtract(bigInteger);
                byArray2 = bigInteger.toByteArray();
                this.i2 = byArray2.length;
                bigInteger = bigDecimal3.toBigInteger();
                bigInteger = MAXBIGINTEGER.subtract(bigInteger);
            } else {
                bigDecimal3 = bigDecimal3.movePointRight(31);
                byArray2 = bigInteger.toByteArray();
                this.i2 = byArray2.length;
                bigInteger = bigDecimal3.toBigInteger();
            }
            byte[] byArray3 = bigInteger.toByteArray();
            this.i3 = byArray3.length;
            byArray = new byte[15 + this.i3];
            byArray[0] = this.i1 < 0 ? 1 : (this.i1 == 0 ? 2 : 3);
            System.arraycopy(byArray2, 0, byArray, 1, this.i2);
            while (this.i2 < 14) {
                byArray[++this.i2] = 0;
            }
            System.arraycopy(byArray3, 0, byArray, 15, this.i3);
        }
        return byArray;
    }

    protected byte[] getByteArray(BigInteger bigInteger) {
        byte[] byArray;
        if (bigInteger == null) {
            return this.getByteArray(MINLONG);
        }
        this.i1 = bigInteger.signum();
        if (this.i1 == 0) {
            byArray = new byte[]{2};
        } else {
            if (this.i1 < 0) {
                bigInteger = MAXBIGINTEGER.add(bigInteger);
            }
            byte[] byArray2 = bigInteger.toByteArray();
            this.i2 = byArray2.length;
            int n2 = 0;
            while (byArray2[n2] == 0) {
                ++n2;
            }
            byArray = new byte[this.i2 + 1 - n2];
            byArray[0] = this.i1 < 0 ? 1 : (this.i1 == 0 ? 2 : 3);
            System.arraycopy(byArray2, n2, byArray, 1, this.i2 - n2);
        }
        return byArray;
    }

    protected byte[] getByteArray(Float f2) {
        byte[] byArray;
        if (f2 == null) {
            return this.getByteArray(MINLONG);
        }
        this.i1 = Float.floatToIntBits(f2.floatValue());
        boolean bl = this.b1 = (this.i1 & Integer.MIN_VALUE) != 0;
        if (this.i1 == Integer.MIN_VALUE) {
            ++this.i1;
        }
        if (this.i1 == 0) {
            byArray = new byte[]{2};
        } else {
            byArray = new byte[6];
            this.s1 = (short)((this.i1 & 0x7F800000) >> 23);
            if (this.b1) {
                this.s1 = (short)(this.s1 ^ 0xFFFF);
                this.i1 ^= 0x7FFFFF;
            }
            byArray[0] = this.b1 ? 1 : (this.i1 == 0 ? 2 : 3);
            byArray[1] = (byte)(this.s1 >> 8);
            byArray[2] = (byte)(this.s1 & 0xFF);
            byArray[3] = (byte)((this.i1 & 0xFF0000) >> 16);
            byArray[4] = (byte)((this.i1 & 0xFF00) >> 8);
            byArray[5] = (byte)(this.i1 & 0xFF);
        }
        return byArray;
    }

    protected byte[] getByteArray(Double d2) {
        byte[] byArray;
        if (d2 == null) {
            return this.getByteArray(MINLONG);
        }
        this.n1 = 0L;
        this.n1 = Double.doubleToLongBits(d2);
        boolean bl = this.b1 = (this.n1 & Long.MIN_VALUE) != 0L;
        if (this.n1 == Long.MIN_VALUE) {
            ++this.n1;
        }
        if (this.n1 == 0L) {
            byArray = new byte[]{2};
        } else {
            byArray = new byte[10];
            this.s1 = (short)((this.n1 & 0x7FF0000000000000L) >> 52);
            if (this.b1) {
                this.s1 = (short)(this.s1 ^ 0xFFFF);
                this.n1 ^= 0xFFFFFFFFFFFFFL;
            }
            byArray[0] = this.b1 ? 1 : (this.n1 == 0L ? 2 : 3);
            byArray[1] = (byte)(this.s1 >> 8);
            byArray[2] = (byte)(this.s1 & 0xFF);
            byArray[3] = (byte)((this.n1 & 0xFF00000000000L) >> 44);
            byArray[4] = (byte)((this.n1 & 0xFF000000000L) >> 36);
            byArray[5] = (byte)((this.n1 & 0xFF0000000L) >> 28);
            byArray[6] = (byte)((this.n1 & 0xFF00000L) >> 20);
            byArray[7] = (byte)((this.n1 & 0xFF000L) >> 12);
            byArray[8] = (byte)((this.n1 & 0xFF0L) >> 4);
            byArray[9] = (byte)(this.n1 & 0xFL);
        }
        return byArray;
    }

    protected byte[] getByteArray(Long l2) {
        byte[] byArray;
        if (l2 == null) {
            return this.getByteArray(MINLONG);
        }
        this.n1 = l2;
        boolean bl = this.b1 = (this.n1 & Long.MIN_VALUE) != 0L;
        if (this.n1 == 0L) {
            byArray = new byte[]{2};
        } else {
            byArray = new byte[9];
            if (this.b1) {
                this.n1 ^= 0xFFFFFFFFFFFFFFFFL;
                this.n1 = Long.MAX_VALUE - this.n1;
            }
            byArray[0] = this.b1 ? 1 : (this.n1 == 0L ? 2 : 3);
            byArray[1] = (byte)((this.n1 & 0x7F00000000000000L) >> 56);
            byArray[2] = (byte)((this.n1 & 0xFF000000000000L) >> 48);
            byArray[3] = (byte)((this.n1 & 0xFF0000000000L) >> 40);
            byArray[4] = (byte)((this.n1 & 0xFF00000000L) >> 32);
            byArray[5] = (byte)((this.n1 & 0xFF000000L) >> 24);
            byArray[6] = (byte)((this.n1 & 0xFF0000L) >> 16);
            byArray[7] = (byte)((this.n1 & 0xFF00L) >> 8);
            byArray[8] = (byte)(this.n1 & 0xFFL);
        }
        return byArray;
    }

    protected byte[] getByteArray(Integer n2) {
        byte[] byArray;
        if (n2 == null) {
            return this.getByteArray(MININTEGER);
        }
        this.i1 = n2;
        boolean bl = this.b1 = (this.i1 & Integer.MIN_VALUE) != 0;
        if (this.i1 == 0) {
            byArray = new byte[]{2};
        } else {
            byArray = new byte[5];
            if (this.b1) {
                this.i1 = (int)((long)this.i1 ^ 0xFFFFFFFFL);
                this.i1 = Integer.MAX_VALUE - this.i1;
            }
            byArray[0] = this.b1 ? 1 : (this.i1 == 0 ? 2 : 3);
            byArray[1] = (byte)((this.i1 & 0x7F000000) >> 24);
            byArray[2] = (byte)((this.i1 & 0xFF0000) >> 16);
            byArray[3] = (byte)((this.i1 & 0xFF00) >> 8);
            byArray[4] = (byte)(this.i1 & 0xFF);
        }
        return byArray;
    }

    protected byte[] getByteArray(Short s2) {
        byte[] byArray;
        if (s2 == null) {
            return this.getByteArray(MINSHORT);
        }
        this.s1 = s2;
        boolean bl = this.b1 = (this.s1 & Short.MIN_VALUE) != 0;
        if (this.s1 == 0) {
            byArray = new byte[]{2};
        } else {
            byArray = new byte[3];
            if (this.b1) {
                this.s1 = (short)((long)this.s1 ^ 0xFFFFL);
                this.s1 = (short)(Short.MAX_VALUE - this.s1);
            }
            byArray[0] = this.b1 ? 1 : (this.s1 == 0 ? 2 : 3);
            byArray[1] = (byte)(this.s1 >> 8);
            byArray[2] = (byte)(this.s1 & 0xFF);
        }
        return byArray;
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public Object clone() {
        return new AssistCollator(this.delegate);
    }
}

