/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common.support;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.IllegalComponentStateException;
import java.awt.Polygon;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Locale;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleIcon;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleStateSet;
import javax.swing.Icon;

public class ArrowheadIcon
implements Icon,
Serializable,
Accessible {
    private static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected boolean left;
    protected boolean doubled;
    protected boolean vertical;
    protected int direction;
    protected int width;
    protected int height;
    protected Polygon arrow;
    protected Polygon farrow;
    protected boolean fillBlack;
    protected String description;
    protected AccessibleArrowheadIcon accessibleContext = null;

    public ArrowheadIcon(boolean bl) {
        this(bl, false, false, 1, -1);
    }

    public ArrowheadIcon(boolean bl, boolean bl2) {
        this(bl, bl2, false, 1, -1);
    }

    public ArrowheadIcon(boolean bl, boolean bl2, int n2) {
        this(bl, bl2, false, 1, n2);
    }

    public ArrowheadIcon(boolean bl, boolean bl2, boolean bl3) {
        this(bl, bl2, bl3, 1, -1);
    }

    public ArrowheadIcon(boolean bl, boolean bl2, boolean bl3, int n2) {
        this(bl, bl2, bl3, n2, -1);
    }

    public ArrowheadIcon(boolean bl, boolean bl2, boolean bl3, int n2, boolean bl4) {
        this(bl, bl2, bl3, n2, -1);
        this.fillBlack = bl4;
    }

    public ArrowheadIcon(boolean bl, boolean bl2, boolean bl3, int n2, int n3, boolean bl4) {
        this(bl, bl2, bl3, n2, n3);
        this.fillBlack = bl4;
    }

    public ArrowheadIcon(boolean bl, boolean bl2, boolean bl3, int n2, int n3) {
        this.left = bl;
        this.doubled = bl2;
        this.vertical = bl3;
        this.direction = n2;
        this.width = n3;
        if (n3 != -1) {
            this.createPolygons();
        }
        this.fillBlack = true;
        this.description = null;
    }

    protected void createPolygons() {
        int n2 = this.width * 2 + 1;
        this.height = n2 > 10 ? n2 : 10;
        this.arrow = new Polygon();
        if (this.left && !this.vertical) {
            this.arrow.addPoint(0, this.width);
            this.arrow.addPoint(this.width, this.width * 2);
            this.arrow.addPoint(this.width, 0);
        } else if (!this.left && !this.vertical) {
            this.arrow.addPoint(0, 0);
            this.arrow.addPoint(this.width, this.width);
            this.arrow.addPoint(0, this.width * 2);
        } else if (this.left && this.vertical) {
            this.arrow.addPoint(this.width, 0);
            this.arrow.addPoint(this.width * 2, this.width);
            this.arrow.addPoint(0, this.width);
            if (this.doubled) {
                this.farrow = new Polygon();
                this.farrow.addPoint(0, 0);
                this.farrow.addPoint(this.width * 2, 0);
                this.farrow.addPoint(this.width, this.width);
            }
        } else {
            this.arrow.addPoint(0, 0);
            this.arrow.addPoint(this.width * 2, 0);
            this.arrow.addPoint(this.width, this.width);
            if (this.doubled) {
                this.farrow = new Polygon();
                this.farrow.addPoint(this.width, 0);
                this.farrow.addPoint(this.width * 2, this.width);
                this.farrow.addPoint(0, this.width);
            }
        }
    }

    public void paintIcon(Component component, Graphics graphics, int n2, int n3) {
        if (this.width == -1) {
            int n4 = component.getFont().getSize();
            this.width = n4 > 7 ? (n4 - n4 % 2) / 4 : 3;
            this.createPolygons();
        }
        if (component.isEnabled()) {
            Color color = null;
            Color color2 = null;
            if (!this.vertical || this.direction == 1) {
                color = component.getForeground();
            } else if (this.direction == 16) {
                color = Color.cyan;
                color2 = component.getForeground();
            } else if (this.direction == 256) {
                color = component.getForeground();
                color2 = Color.cyan;
            }
            graphics.setColor(color);
            this.drawArrowheads(graphics, n2, n3, color2);
        } else {
            Color color = component.getBackground();
            graphics.setColor(color.brighter());
            this.drawArrowheads(graphics, n2 + 1, n3 + 1, null);
            graphics.setColor(color.darker());
            this.drawArrowheads(graphics, n2, n3, null);
        }
    }

    protected void drawArrowheads(Graphics graphics, int n2, int n3, Color color) {
        int n4 = this.height - this.width * 2;
        if (!this.vertical) {
            n4 /= 2;
        } else if (this.vertical) {
            n4 = 0;
        }
        graphics.translate(n2, n3 + n4);
        if (!this.doubled && this.vertical && this.direction != 1) {
            graphics.setColor(Color.cyan);
            graphics.drawPolygon(this.arrow);
            graphics.fillPolygon(this.arrow);
        } else {
            graphics.drawPolygon(this.arrow);
            if (this.fillBlack || !graphics.getColor().equals(Color.black)) {
                graphics.fillPolygon(this.arrow);
            }
        }
        if (this.doubled && !this.vertical) {
            graphics.translate(this.width + 3, 0);
            graphics.drawPolygon(this.arrow);
            if (this.fillBlack || !graphics.getColor().equals(Color.black)) {
                graphics.fillPolygon(this.arrow);
            }
            graphics.translate(-n2 - 3 - this.width, -n3 - n4);
        } else if (this.doubled && this.vertical) {
            if (color != null) {
                graphics.setColor(color);
            }
            graphics.translate(0, this.width + 3);
            graphics.drawPolygon(this.farrow);
            if (this.fillBlack || !graphics.getColor().equals(Color.black)) {
                graphics.fillPolygon(this.farrow);
            }
            graphics.translate(-n2, -n3 - n4 - 3 - this.width);
        } else {
            graphics.translate(-n2, -n3 - n4);
        }
    }

    public int getIconWidth() {
        int n2 = 3;
        if (this.width != -1) {
            n2 = this.width;
        }
        if (this.doubled) {
            return (n2 + 1) * 2;
        }
        if (this.vertical) {
            return n2 * 2 + 1;
        }
        return n2;
    }

    public int getIconHeight() {
        int n2 = 3;
        if (this.width != -1) {
            n2 = this.width;
        }
        if (this.vertical) {
            if (this.doubled) {
                return (n2 + 1) * 2;
            }
            return n2 + 2;
        }
        int n3 = n2 * 2 + 1;
        return n3 > 10 ? n3 : 10;
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleArrowheadIcon();
        }
        return this.accessibleContext;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    protected class AccessibleArrowheadIcon
    extends AccessibleContext
    implements AccessibleIcon,
    Serializable {
        private static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

        protected AccessibleArrowheadIcon() {
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.ICON;
        }

        public AccessibleStateSet getAccessibleStateSet() {
            return null;
        }

        public Accessible getAccessibleParent() {
            return null;
        }

        public int getAccessibleIndexInParent() {
            return -1;
        }

        public int getAccessibleChildrenCount() {
            return 0;
        }

        public Accessible getAccessibleChild(int n2) {
            return null;
        }

        public Locale getLocale() throws IllegalComponentStateException {
            return null;
        }

        public String getAccessibleIconDescription() {
            return ArrowheadIcon.this.getDescription();
        }

        public void setAccessibleIconDescription(String string) {
            ArrowheadIcon.this.setDescription(string);
        }

        public int getAccessibleIconHeight() {
            return ArrowheadIcon.this.getIconHeight();
        }

        public int getAccessibleIconWidth() {
            return ArrowheadIcon.this.getIconWidth();
        }

        private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
            objectInputStream.defaultReadObject();
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            objectOutputStream.defaultWriteObject();
        }
    }
}

