/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common.smartx.support.diagnoser;

import com.ibm.db2.tools.common.smartx.event.Diagnosis;
import com.ibm.db2.tools.common.smartx.support.SmartConstraints;
import com.ibm.db2.tools.common.smartx.support.SmartManager;
import com.ibm.db2.tools.common.smartx.support.SmartResources;
import com.ibm.db2.tools.common.smartx.support.SmartUtil;
import com.ibm.db2.tools.common.smartx.support.diagnoser.DiagnoserUtil;
import com.ibm.db2.tools.common.smartx.support.diagnoser.SmartDiagnoser;
import com.ibm.db2.tools.common.support.ReuseStringBuffer;

public class WholeNumberDiagnoser
implements SmartDiagnoser {
    public static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected static WholeNumberDiagnoser myself;

    public static WholeNumberDiagnoser getDiagnoserInstance() {
        if (myself == null) {
            myself = new WholeNumberDiagnoser();
        }
        return myself;
    }

    public boolean smartVerify(StringBuffer stringBuffer, int[] nArray, SmartConstraints smartConstraints, Diagnosis diagnosis) {
        if (smartConstraints.getConstraintFlag(8).booleanValue()) {
            smartConstraints.setConstraintFlag(8, false);
            return true;
        }
        if (smartConstraints.getConstraintFlag(7).booleanValue()) {
            diagnosis.clearDiagnoses();
        }
        char c2 = SmartUtil.getMinusSign();
        String string = smartConstraints.getDefaultString();
        long l2 = 0L;
        Object object = smartConstraints.getConstraint("MinimumSize");
        if (object != null && object instanceof Number) {
            l2 = ((Number)object).longValue();
        } else {
            object = smartConstraints.getConstraint("MinimumDoubleSize");
            if (object != null && object instanceof Number) {
                l2 = ((Number)object).longValue();
            }
        }
        long l3 = Long.MAX_VALUE;
        Object object2 = smartConstraints.getConstraint("MaximumSize");
        if (object2 != null && object2 instanceof Number) {
            l3 = ((Number)object2).longValue();
        } else {
            object2 = smartConstraints.getConstraint("MaximumDoubleSize");
            if (object2 != null && object2 instanceof Number) {
                l3 = ((Number)object2).longValue();
            }
        }
        boolean bl = smartConstraints.getConstraintFlag(0);
        boolean bl2 = smartConstraints.getConstraintFlag(6);
        boolean bl3 = smartConstraints.getConstraintFlag(5);
        DiagnoserUtil.trimText(stringBuffer, nArray[1], smartConstraints);
        int n2 = stringBuffer.length();
        if (string == null || string.length() == 0) {
            string = String.valueOf(l2);
            n2 = stringBuffer.length();
        }
        if (n2 == 0 || n2 == 1 && (stringBuffer.charAt(0) == c2 || stringBuffer.charAt(0) == '+')) {
            if (bl) {
                diagnosis.addDiagnostic(-760, SmartResources.get(73));
                if (bl3 || SmartManager.getFixPolicy()) {
                    stringBuffer.setLength(0);
                    stringBuffer.append(string);
                    n2 = stringBuffer.length();
                }
            }
            if (n2 > 0) {
                Object[] objectArray;
                if (l2 < 0L) {
                    objectArray = new Object[]{String.valueOf(c2)};
                    diagnosis.addDiagnostic(-962, SmartResources.get(158, objectArray));
                } else {
                    diagnosis.addDiagnostic(-957, SmartResources.get(157));
                }
                objectArray = new Object[]{new Long(l2), new Long(l3)};
                diagnosis.addDiagnostic(-764, SmartResources.get(77, objectArray));
            }
        } else {
            int n3 = 0;
            ReuseStringBuffer reuseStringBuffer = ReuseStringBuffer.getBuffer();
            ReuseStringBuffer reuseStringBuffer2 = ReuseStringBuffer.getBuffer();
            int n4 = 0;
            while (n4 < n2) {
                char c3 = stringBuffer.charAt(n4);
                if (Character.isDigit(c3) || l2 < 0L && n4 == 0 && c3 == c2 || n4 == 0 && c3 == '+') {
                    reuseStringBuffer2.append(c3);
                } else {
                    ++n3;
                    if (reuseStringBuffer.length() > 0) {
                        reuseStringBuffer.append(' ');
                    }
                    if (Character.isSpaceChar(c3)) {
                        reuseStringBuffer.append(SmartResources.get(222));
                    } else {
                        SmartUtil.htmlMeta(reuseStringBuffer, c3);
                    }
                }
                ++n4;
            }
            stringBuffer.setLength(0);
            stringBuffer.append(reuseStringBuffer2.toString());
            n2 = stringBuffer.length();
            if (n3 > 0) {
                Object[] objectArray = new Object[]{String.valueOf(c2), reuseStringBuffer.toString()};
                if (n3 > 1) {
                    if (l2 < 0L) {
                        diagnosis.addDiagnostic(-763, SmartResources.get(76, objectArray));
                    } else {
                        diagnosis.addDiagnostic(-758, SmartResources.get(71, objectArray));
                    }
                } else if (l2 < 0L) {
                    diagnosis.addDiagnostic(-762, SmartResources.get(75, objectArray));
                } else {
                    diagnosis.addDiagnostic(-758, SmartResources.get(71, objectArray));
                }
                if ((bl3 || SmartManager.getFixPolicy()) && bl && stringBuffer.length() == 0) {
                    stringBuffer.setLength(1);
                    stringBuffer.setCharAt(0, '0');
                    n2 = stringBuffer.length();
                }
            }
            if (n2 > 0 && (n2 != 1 || stringBuffer.charAt(0) != c2 && stringBuffer.charAt(0) != '+')) {
                long l4 = 0L;
                boolean bl4 = false;
                String string2 = reuseStringBuffer2.toString();
                if (string2.charAt(0) == '+') {
                    string2 = reuseStringBuffer2.substring(1);
                }
                try {
                    l4 = Long.valueOf(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    bl4 = true;
                }
                if (!bl4 && l4 < l2) {
                    stringBuffer.setLength(0);
                    stringBuffer.append(String.valueOf(l2));
                    Object[] objectArray = new Object[]{new Long(l2), new Long(l3)};
                    diagnosis.addDiagnostic(-764, SmartResources.get(77, objectArray));
                } else if (bl4 || l4 > l3) {
                    stringBuffer.setLength(0);
                    stringBuffer.append(String.valueOf(l3));
                    Object[] objectArray = new Object[]{new Long(l2), new Long(l3)};
                    diagnosis.addDiagnostic(-764, SmartResources.get(77, objectArray));
                }
            }
            ReuseStringBuffer.freeBuffer(reuseStringBuffer);
            ReuseStringBuffer.freeBuffer(reuseStringBuffer2);
        }
        if (diagnosis != null && diagnosis.hasError()) {
            if (!diagnosis.hasCode(-764)) {
                Object[] objectArray = new Object[]{new Long(l2), new Long(l3)};
                diagnosis.addDiagnostic(-764, SmartResources.get(77, objectArray));
            }
            nArray[0] = 0;
            nArray[1] = stringBuffer.length();
            if (bl3 || SmartManager.getFixPolicy()) {
                if (bl && stringBuffer.length() == 0) {
                    stringBuffer.setLength(0);
                    stringBuffer.append(string);
                }
                nArray[0] = 0;
                nArray[1] = stringBuffer.length();
                smartConstraints.setConstraintFlag(8, true);
            }
            return bl3;
        }
        return true;
    }
}

