/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common.smartx.support.diagnoser;

import com.ibm.db2.tools.common.smartx.event.Diagnosis;
import com.ibm.db2.tools.common.smartx.support.SmartConstraints;
import com.ibm.db2.tools.common.smartx.support.SmartManager;
import com.ibm.db2.tools.common.smartx.support.SmartResources;
import com.ibm.db2.tools.common.smartx.support.SmartUtil;
import com.ibm.db2.tools.common.smartx.support.diagnoser.DiagnoserUtil;
import com.ibm.db2.tools.common.smartx.support.diagnoser.SmartDiagnoser;
import com.ibm.db2.tools.common.support.ReuseStringBuffer;

public class StringLengthDiagnoser
implements SmartDiagnoser {
    public static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected static String units = "KkMmGg";
    protected static StringLengthDiagnoser myself;

    public static StringLengthDiagnoser getDiagnoserInstance() {
        if (myself == null) {
            myself = new StringLengthDiagnoser();
        }
        return myself;
    }

    public boolean smartVerify(StringBuffer stringBuffer, int[] nArray, SmartConstraints smartConstraints, Diagnosis diagnosis) {
        if (smartConstraints.getConstraintFlag(8).booleanValue()) {
            smartConstraints.setConstraintFlag(8, false);
            return true;
        }
        if (smartConstraints.getConstraintFlag(7).booleanValue()) {
            diagnosis.clearDiagnoses();
        }
        int n2 = 452;
        Integer n3 = (Integer)smartConstraints.getConstraint("StringLengthType");
        if (n3 != null) {
            n2 = n3;
        }
        int n4 = 1;
        Integer n5 = (Integer)smartConstraints.getConstraint("MinimumLength");
        if (n5 != null) {
            n4 = n5;
        }
        int n6 = -1;
        Integer n7 = (Integer)smartConstraints.getConstraint("Unit");
        if (n7 != null) {
            n6 = n7;
        }
        String string = smartConstraints.getDefaultString();
        boolean bl = smartConstraints.getConstraintFlag(0);
        boolean bl2 = smartConstraints.getConstraintFlag(6);
        boolean bl3 = smartConstraints.getConstraintFlag(5);
        boolean bl4 = false;
        int n8 = DiagnoserUtil.trimText(stringBuffer, nArray[1], smartConstraints);
        int n9 = 0;
        int n10 = stringBuffer.length();
        if (string == null || string.length() == 0) {
            string = "1";
        }
        if (stringBuffer.length() == 0) {
            if (bl) {
                if (bl3 || SmartManager.getFixPolicy()) {
                    stringBuffer.append(string);
                }
                diagnosis.addDiagnostic(-701, SmartResources.get(16));
            }
        } else {
            ReuseStringBuffer reuseStringBuffer = ReuseStringBuffer.getBuffer();
            ReuseStringBuffer reuseStringBuffer2 = ReuseStringBuffer.getBuffer();
            int n11 = 0;
            String string2 = SmartUtil.getString(222);
            int n12 = 0;
            while (n12 < n10) {
                int n13;
                char c2 = stringBuffer.charAt(n12);
                if (Character.isDigit(c2) || SmartUtil.getMinusSign() == c2 && n12 == 0) {
                    reuseStringBuffer.append(c2);
                } else if (n6 == -1 && (n13 = units.indexOf(c2)) > -1) {
                    int n14;
                    bl4 = true;
                    switch (c2) {
                        case 'K': 
                        case 'k': {
                            n6 = 1;
                            break;
                        }
                        case 'M': 
                        case 'm': {
                            n6 = 2;
                            break;
                        }
                        case 'G': 
                        case 'g': {
                            n6 = 3;
                        }
                    }
                    if (reuseStringBuffer2.length() >= string2.length() && reuseStringBuffer2.substring(n14 = reuseStringBuffer2.length() - string2.length()).equals(string2)) {
                        if (n14 <= 0 || reuseStringBuffer2.charAt(n14 - 1) == ' ') {
                            // empty if block
                        }
                        reuseStringBuffer2.setLength(--n14);
                        --n11;
                    }
                } else {
                    ++n11;
                    if (reuseStringBuffer2.length() == 0) {
                        reuseStringBuffer2.append(' ');
                    }
                    if (Character.isSpaceChar(c2)) {
                        reuseStringBuffer2.append(SmartUtil.getString(222));
                    } else {
                        SmartUtil.htmlMeta(reuseStringBuffer2, c2);
                    }
                }
                ++n12;
            }
            if (n11 > 0) {
                if (bl3 || SmartManager.getFixPolicy()) {
                    if (bl && reuseStringBuffer.length() == 0) {
                        reuseStringBuffer.append("1");
                    }
                    stringBuffer.setLength(0);
                    stringBuffer.append(reuseStringBuffer.toString());
                }
                Object[] objectArray = new Object[]{reuseStringBuffer2.toString()};
                if (n11 > 1) {
                    diagnosis.addDiagnostic(-713, SmartResources.get(28, objectArray));
                } else {
                    diagnosis.addDiagnostic(-702, SmartResources.get(17, objectArray));
                }
            }
            long l2 = 0L;
            boolean bl5 = false;
            try {
                l2 = Long.valueOf(reuseStringBuffer.toString());
            }
            catch (NumberFormatException numberFormatException) {
                bl5 = true;
            }
            if (!bl5 && l2 < 1L) {
                if (bl3 || SmartManager.getFixPolicy()) {
                    stringBuffer.setLength(0);
                    stringBuffer.append("1");
                }
                diagnosis.addDiagnostic(-703, SmartResources.get(18));
            } else if (n2 == 404 || n2 == 408 || n2 == 412) {
                switch (n6) {
                    case 1: {
                        n9 = 0x200000;
                        break;
                    }
                    case 2: {
                        n9 = 2048;
                        break;
                    }
                    case 3: {
                        n9 = 2;
                        break;
                    }
                    default: {
                        n9 = Integer.MAX_VALUE;
                    }
                }
                if (n2 == 412) {
                    n9 /= 2;
                }
                if (bl5 || l2 > (long)n9) {
                    if (bl3 || SmartManager.getFixPolicy()) {
                        stringBuffer.setLength(0);
                        stringBuffer.append(String.valueOf(n9).trim());
                    }
                    String string3 = "LOB";
                    switch (n2) {
                        case 404: {
                            string3 = "BLOB";
                            break;
                        }
                        case 408: {
                            string3 = "CLOB";
                            break;
                        }
                        case 412: {
                            string3 = "DBCLOB";
                        }
                    }
                    int n15 = SmartUtil.getMagnitudeKey(n6);
                    Object[] objectArray = new Object[]{string3, new Integer(n9), SmartUtil.getString(n15)};
                    diagnosis.addDiagnostic(-717, SmartResources.get(32, objectArray));
                }
            } else if (n2 == 604 || n2 == 608 || n2 == 612) {
                switch (n6) {
                    case 1: {
                        n9 = 15360;
                        break;
                    }
                    case 2: {
                        n9 = 15;
                        break;
                    }
                    default: {
                        n9 = 0xF00000;
                    }
                }
                if (n2 == 612) {
                    n9 /= 2;
                }
                if (!bl5 && n2 == 608 && n6 == 0 && l2 < (long)n4) {
                    if (bl3 || SmartManager.getFixPolicy()) {
                        stringBuffer.setLength(0);
                        stringBuffer.append(String.valueOf(n4).trim());
                    }
                    Object[] objectArray = new Object[]{new Integer(n4)};
                    diagnosis.addDiagnostic(-718, SmartResources.get(33, objectArray));
                } else if (bl5 || l2 > (long)n9) {
                    if (bl3 || SmartManager.getFixPolicy()) {
                        stringBuffer.setLength(0);
                        stringBuffer.append(String.valueOf(n9).trim());
                    }
                    String string4 = "LOB";
                    switch (n2) {
                        case 604: {
                            string4 = "BLOB";
                            break;
                        }
                        case 608: {
                            string4 = "CLOB";
                            break;
                        }
                        case 612: {
                            string4 = "DBCLOB";
                        }
                    }
                    int n16 = SmartUtil.getMagnitudeKey(n6);
                    Object[] objectArray = new Object[]{string4, new Integer(n9), SmartUtil.getString(n16)};
                    diagnosis.addDiagnostic(-717, SmartResources.get(32, objectArray));
                }
            } else {
                if (n2 == 484) {
                    n9 = 31;
                    if (l2 > (long)n9) {
                        diagnosis.addDiagnostic(-706, SmartResources.get(21));
                    }
                } else if (n2 == 464) {
                    n9 = 16336;
                    if (l2 > (long)n9) {
                        Object[] objectArray = new Object[]{new Integer(n9)};
                        diagnosis.addDiagnostic(-726, SmartResources.get(41, objectArray));
                    }
                } else if (n2 == 664) {
                    n9 = 16369;
                    if (l2 > (long)n9) {
                        Object[] objectArray = new Object[]{new Integer(n9)};
                        diagnosis.addDiagnostic(-726, SmartResources.get(41, objectArray));
                    }
                } else if (n2 == 448) {
                    n9 = 32672;
                    if (l2 > (long)n9) {
                        Object[] objectArray = new Object[]{new Integer(n9)};
                        diagnosis.addDiagnostic(-727, SmartResources.get(42, objectArray));
                    }
                } else if (n2 == 648) {
                    n9 = 32739;
                    if (l2 < (long)n4) {
                        Object[] objectArray = new Object[]{new Integer(n4)};
                        diagnosis.addDiagnostic(-718, SmartResources.get(33, objectArray));
                        bl5 = true;
                    } else if (l2 > (long)n9) {
                        Object[] objectArray = new Object[]{new Integer(n9)};
                        diagnosis.addDiagnostic(-727, SmartResources.get(42, objectArray));
                    }
                } else if (n2 == 948) {
                    n9 = 32672;
                    if (l2 > (long)n9) {
                        diagnosis.addDiagnostic(-736, SmartResources.get(51));
                    }
                } else if (n2 == 452) {
                    n9 = 254;
                    if (l2 > (long)n9) {
                        Object[] objectArray = new Object[]{new Integer(n9)};
                        diagnosis.addDiagnostic(-728, SmartResources.get(43, objectArray));
                    }
                } else if (n2 == 652) {
                    n9 = 32765;
                    if (l2 < (long)n4) {
                        Object[] objectArray = new Object[]{new Integer(n4)};
                        diagnosis.addDiagnostic(-718, SmartResources.get(33, objectArray));
                        bl5 = true;
                    } else if (l2 > (long)n9) {
                        Object[] objectArray = new Object[]{new Integer(n9)};
                        diagnosis.addDiagnostic(-728, SmartResources.get(43, objectArray));
                    }
                } else if (n2 == 468) {
                    n9 = 127;
                    if (l2 > (long)n9) {
                        Object[] objectArray = new Object[]{new Integer(n9)};
                        diagnosis.addDiagnostic(-729, SmartResources.get(44, objectArray));
                    }
                } else if (n2 == 668) {
                    n9 = 16382;
                    if (l2 > (long)n9) {
                        Object[] objectArray = new Object[]{new Integer(n9)};
                        diagnosis.addDiagnostic(-729, SmartResources.get(44, objectArray));
                    }
                } else if (n2 == 396) {
                    n9 = 200;
                    if (l2 > (long)n9) {
                        diagnosis.addDiagnostic(-738, SmartResources.get(53));
                    }
                } else if (n2 == 696) {
                    n9 = 32717;
                    if (l2 < (long)n4) {
                        Object[] objectArray = new Object[]{new Integer(n4)};
                        diagnosis.addDiagnostic(-718, SmartResources.get(33, objectArray));
                        bl5 = true;
                    } else if (l2 > (long)n9) {
                        Object[] objectArray = new Object[]{new Integer(n9)};
                        diagnosis.addDiagnostic(-719, SmartResources.get(34, objectArray));
                    }
                }
                if ((bl5 || l2 > (long)n9) && (bl3 || SmartManager.getFixPolicy())) {
                    stringBuffer.setLength(0);
                    stringBuffer.append(String.valueOf(n9).trim());
                }
            }
            ReuseStringBuffer.freeBuffer(reuseStringBuffer2);
            ReuseStringBuffer.freeBuffer(reuseStringBuffer);
        }
        if (diagnosis != null && diagnosis.hasError()) {
            nArray[0] = n8;
            nArray[1] = n8;
            if (bl3 || SmartManager.getFixPolicy()) {
                if (bl && stringBuffer.length() == 0) {
                    stringBuffer.append(String.valueOf(n9).trim());
                }
                if (bl4) {
                    stringBuffer.append(this.getMagnitudeString(n6));
                }
                nArray[0] = 0;
                nArray[1] = stringBuffer.length();
                smartConstraints.setConstraintFlag(8, true);
            }
            return bl3;
        }
        return true;
    }

    protected String getMagnitudeString(int n2) {
        switch (n2) {
            case 1: {
                return "K";
            }
            case 2: {
                return "M";
            }
            case 3: {
                return "G";
            }
        }
        return "";
    }
}

