/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common.smartx.support.diagnoser;

import com.ibm.db2.tools.common.smartx.support.diagnoser.SmartDateField;
import com.ibm.db2.tools.common.support.AssistManager;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import java.util.Locale;
import java.util.SimpleTimeZone;
import java.util.TimeZone;

public class SmartDateFormat
extends DateFormat {
    private static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected String pattern;
    protected DateFormatSymbols formatData;
    protected char[] currentPatternChars;
    protected int[] currentPatternCounts;
    protected static final int CAL_STRING = 0;
    protected static final int CAL_INT = 1;
    protected static final int CAL_TRANS = 2;
    protected static final int[] PATTERN_INDEX_TO_CALENDAR_FIELD = new int[]{0, 1, 2, 5, 11, 11, 12, 13, 14, 7, 6, 8, 3, 4, 9, 10, 10, 15};
    protected static final int[] PATTERN_INDEX_TO_DATE_FORMAT_FIELD = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17};
    protected Date defaultCenturyStart;
    protected transient int defaultCenturyStartYear;
    protected static final int millisPerHour = 3600000;
    protected static final int millisPerMinute = 60000;
    protected static final String GMT_PLUS = "GMT+";
    protected static final String GMT_MINUS = "GMT-";
    protected static final String GMT = "GMT";
    protected static final String patternChars = "GyMdkHmsSEDFwWahKz";
    protected static Hashtable cachedLocaleData = new Hashtable(3);

    public SmartDateFormat(String string) {
        this.pattern = string;
        Locale locale = AssistManager.getPreferredLocale();
        this.formatData = new DateFormatSymbols(locale);
        this.initialize(locale);
    }

    public void setPattern(String string) {
        this.pattern = string;
        this.calendar.clear();
        this.currentPatternChars = null;
        this.currentPatternCounts = null;
    }

    public StringBuffer format(Date date, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        fieldPosition.setBeginIndex(0);
        fieldPosition.setEndIndex(0);
        this.calendar.setTime(date);
        boolean bl = false;
        char c2 = '\u0000';
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.pattern.length()) {
            char c3 = this.pattern.charAt(n3);
            if (c3 != c2 && n2 > 0) {
                stringBuffer.append(this.subFormat(c2, n2, stringBuffer.length(), fieldPosition));
                n2 = 0;
            }
            if (c3 == '\'') {
                if (n3 + 1 < this.pattern.length() && this.pattern.charAt(n3 + 1) == '\'') {
                    stringBuffer.append('\'');
                    ++n3;
                } else {
                    bl = !bl;
                }
            } else if (!bl && (c3 >= 'a' && c3 <= 'z' || c3 >= 'A' && c3 <= 'Z')) {
                c2 = c3;
                ++n2;
            } else {
                stringBuffer.append(c3);
            }
            ++n3;
        }
        if (n2 > 0) {
            stringBuffer.append(this.subFormat(c2, n2, stringBuffer.length(), fieldPosition));
        }
        return stringBuffer;
    }

    public Date parse(String string, ParsePosition parsePosition) {
        Date date;
        int n2;
        int n3;
        int n4 = n3 = parsePosition.getIndex();
        boolean[] blArray = new boolean[]{false};
        this.calendar.clear();
        boolean bl = false;
        int n5 = 0;
        int n6 = 0;
        int n7 = 1;
        int n8 = 0;
        while (n8 < this.pattern.length()) {
            n2 = this.pattern.charAt(n8);
            if (bl) {
                if (n2 == 39) {
                    bl = false;
                    if (n6 == 0) {
                        if (n3 > -1 && (n3 >= string.length() || n2 != string.charAt(n3))) {
                            parsePosition.setIndex(n4);
                            parsePosition.setErrorIndex(n3);
                            return null;
                        }
                        ++n3;
                    }
                    n6 = 0;
                    n7 = 0;
                } else {
                    if (n3 > -1 && (n3 >= string.length() || n2 != string.charAt(n3))) {
                        parsePosition.setIndex(n4);
                        parsePosition.setErrorIndex(n3);
                        return null;
                    }
                    ++n6;
                    ++n3;
                }
            } else {
                int n9;
                if (n2 == 39) {
                    bl = true;
                    if (n6 > 0) {
                        n9 = n3;
                        if ((n3 = this.subParse(string, n3, (char)n5, n6, false, blArray)) < 0) {
                            parsePosition.setIndex(n4);
                            parsePosition.setErrorIndex(n9);
                            return null;
                        }
                        n6 = 0;
                    }
                    if (n7 == 0) {
                        n9 = n3;
                        if (n3 > -1 && (n3 >= string.length() || n2 != string.charAt(n3))) {
                            parsePosition.setIndex(n4);
                            parsePosition.setErrorIndex(n9);
                            return null;
                        }
                        ++n3;
                        n6 = 1;
                    }
                } else if (n2 >= 97 && n2 <= 122 || n2 >= 65 && n2 <= 90) {
                    if (n2 != n5 && n6 > 0) {
                        n9 = n3;
                        if ((n3 = this.subParse(string, n3, (char)n5, n6, true, blArray)) < 0) {
                            parsePosition.setIndex(n4);
                            parsePosition.setErrorIndex(n9);
                            return null;
                        }
                        n5 = n2;
                        n6 = 1;
                    } else {
                        if (n2 != n5) {
                            n5 = n2;
                        }
                        ++n6;
                    }
                } else if (n6 > 0) {
                    n9 = n3;
                    if ((n3 = this.subParse(string, n3, (char)n5, n6, false, blArray)) < 0) {
                        parsePosition.setIndex(n4);
                        parsePosition.setErrorIndex(n9);
                        return null;
                    }
                    if (n3 > -1 && (n3 >= string.length() || n2 != string.charAt(n3))) {
                        parsePosition.setIndex(n4);
                        parsePosition.setErrorIndex(n3);
                        return null;
                    }
                    ++n3;
                    n6 = 0;
                    n5 = 0;
                } else {
                    if (n3 > -1 && (n3 >= string.length() || n2 != string.charAt(n3))) {
                        parsePosition.setIndex(n4);
                        parsePosition.setErrorIndex(n3);
                        return null;
                    }
                    ++n3;
                }
                ++n7;
            }
            ++n8;
        }
        if (n6 > 0) {
            n2 = n3;
            if ((n3 = this.subParse(string, n3, (char)n5, n6, false, blArray)) < 0) {
                parsePosition.setIndex(n4);
                parsePosition.setErrorIndex(n2);
                return null;
            }
        }
        parsePosition.setIndex(n3);
        try {
            if (blArray[0]) {
                Calendar calendar = (Calendar)this.calendar.clone();
                date = this.calendar.getTime();
                if (date.before(this.defaultCenturyStart)) {
                    calendar.set(1, this.defaultCenturyStartYear + 100);
                    date = calendar.getTime();
                }
            } else {
                date = this.calendar.getTime();
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            parsePosition.setIndex(n4);
            parsePosition.setErrorIndex(n3);
            return null;
        }
        return date;
    }

    public char[] getCurrentPatternChars() {
        if (this.currentPatternChars == null) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            char c2 = '\u0000';
            int n2 = 0;
            while (n2 < this.pattern.length()) {
                char c3 = this.pattern.charAt(n2);
                if (bl && c3 == '\'') {
                    bl = false;
                } else if (!bl && c3 == '\'') {
                    bl = false;
                } else if (!bl && c3 != c2 && patternChars.indexOf(c3) > 0) {
                    stringBuffer.append(c3);
                    c2 = c3;
                }
                ++n2;
            }
            this.currentPatternChars = stringBuffer.toString().toCharArray();
        }
        return this.currentPatternChars;
    }

    public int[] getCurrentPatternCounts() {
        if (this.currentPatternCounts == null) {
            char[] cArray = this.getCurrentPatternChars();
            this.currentPatternCounts = new int[cArray.length];
            boolean bl = false;
            char c2 = '\u0000';
            int n2 = -1;
            int n3 = 0;
            while (n3 < this.pattern.length()) {
                char c3 = this.pattern.charAt(n3);
                if (patternChars.indexOf(c3) > 0) {
                    if (bl && c3 == '\'') {
                        bl = false;
                    } else if (!bl && c3 == '\'') {
                        bl = false;
                    } else if (!bl && c3 != c2) {
                        int n4 = ++n2;
                        this.currentPatternCounts[n4] = this.currentPatternCounts[n4] + 1;
                        c2 = c3;
                    } else if (!bl) {
                        int n5 = n2;
                        this.currentPatternCounts[n5] = this.currentPatternCounts[n5] + 1;
                    }
                }
                ++n3;
            }
        }
        return this.currentPatternCounts;
    }

    public ArrayList parseFields(String string) throws ParseException {
        int n2;
        int n3;
        SmartDateField smartDateField;
        Object object;
        int n4 = 0;
        ParsePosition parsePosition = new ParsePosition(n4);
        boolean[] blArray = new boolean[]{false};
        boolean bl = false;
        char c2 = '\u0000';
        int n5 = 0;
        int n6 = 1;
        int n7 = 0;
        char[] cArray = this.getCurrentPatternChars();
        int[] nArray = this.getCurrentPatternCounts();
        ArrayList<SmartDateField> arrayList = new ArrayList<SmartDateField>(nArray.length);
        int n8 = 0;
        char c3 = '\u0000';
        this.calendar.clear();
        n8 = 0;
        while (n8 < cArray.length) {
            arrayList.add(new SmartDateField(cArray[n8]));
            ++n8;
        }
        n8 = 0;
        while (n8 < this.pattern.length() && n4 < string.length()) {
            c3 = this.pattern.charAt(n8);
            n4 = parsePosition.getIndex();
            if (bl) {
                if (c3 == '\'') {
                    bl = false;
                    if (n5 == 0) {
                        if (n4 > -1 && (n4 >= string.length() || c3 != string.charAt(n4))) {
                            throw new ParseException("Bad date or time pattern; empty literal in \"" + this.pattern + "\" at position " + n8 + ".", n8);
                        }
                        parsePosition.setIndex(parsePosition.getIndex() + 1);
                    }
                    n5 = 0;
                    n6 = 0;
                } else {
                    if (n4 > -1 && (n4 >= string.length() || c3 != string.charAt(n4))) {
                        ((SmartDateField)arrayList.get(n7)).addSeparatorError(-601, this.pattern.substring(n8, n8 + 1), n4 >= string.length() ? string : string.substring(n4, n4 + 1));
                    }
                    ++n5;
                    parsePosition.setIndex(parsePosition.getIndex() + 1);
                }
            } else {
                if (c3 == '\'') {
                    bl = true;
                    if (n5 > 0) {
                        n7 = SmartDateFormat.arrayIndexOf(c2, cArray);
                        if (n7 > -1) {
                            object = this.subParseField(string, parsePosition, c2, n5, false, blArray);
                            if (parsePosition.getIndex() < 0 || object instanceof Integer && (Integer)object < 0) {
                                ((SmartDateField)arrayList.get(n7)).setCode(-n7);
                            } else {
                                String string2 = string.substring(n4);
                                if (string2.length() > parsePosition.getIndex() - n4) {
                                    string2 = string2.substring(0, parsePosition.getIndex() - n4);
                                }
                                smartDateField = (SmartDateField)arrayList.get(n7);
                                smartDateField.setCode(0);
                                smartDateField.setInput(string2);
                                smartDateField.setNumeric((Integer)object);
                            }
                        }
                        n5 = 0;
                    }
                    if (n6 == 0) {
                        if (n4 > -1 && (n4 >= string.length() || c3 != string.charAt(n4))) {
                            throw new ParseException("Bad date or time pattern; two single quotation marks ('') out of place in \"" + this.pattern + "\" at position " + n8 + ".", n8);
                        }
                        parsePosition.setIndex(parsePosition.getIndex() + 1);
                        n5 = 1;
                    }
                } else if (c3 >= 'a' && c3 <= 'z' || c3 >= 'A' && c3 <= 'Z') {
                    if (c3 != c2 && n5 > 0) {
                        n7 = SmartDateFormat.arrayIndexOf(c2, cArray);
                        if (n7 > -1) {
                            smartDateField = (SmartDateField)arrayList.get(n7);
                            n3 = parsePosition.getIndex();
                            object = this.subParseField(string, parsePosition, c2, n5, true, blArray);
                            if (parsePosition.getIndex() < 0 || object instanceof Integer && (Integer)object < 0) {
                                int n9 = patternChars.indexOf(c2);
                                n2 = n3;
                                if (SmartDateFormat.isNumericField(n9, n5)) {
                                    if (string.length() > 0) {
                                        smartDateField.setCode(-605);
                                    } else {
                                        smartDateField.setCode(-612);
                                    }
                                    while (n2 < string.length() && (Character.isWhitespace(string.charAt(n2)) || Character.isLetter(string.charAt(n2)))) {
                                        ++n2;
                                    }
                                } else {
                                    if (string.length() > 0) {
                                        smartDateField.setCode(-606);
                                    } else {
                                        smartDateField.setCode(-613);
                                    }
                                    while (n2 < string.length() && Character.isDigit(string.charAt(n2))) {
                                        ++n2;
                                    }
                                }
                                smartDateField.setInput(string.substring(n3, n2));
                                parsePosition.setIndex(n2);
                            } else {
                                smartDateField.setCode(0);
                                String string3 = string.substring(n4);
                                if (string3.length() > parsePosition.getIndex() - n4) {
                                    string3 = string3.substring(0, parsePosition.getIndex() - n4);
                                }
                                if (object.getClass().isArray()) {
                                    smartDateField.setInput(string3);
                                    smartDateField.setNumeric((Integer)((Object[])object)[0]);
                                    smartDateField.setTranslations((String[])((Object[])object)[1]);
                                } else {
                                    smartDateField.setInput(string3);
                                    smartDateField.setNumeric((Integer)object);
                                }
                            }
                        }
                        c2 = c3;
                        n5 = 1;
                    } else {
                        if (c3 != c2) {
                            c2 = c3;
                        }
                        ++n5;
                    }
                } else if (n5 > 0) {
                    n7 = SmartDateFormat.arrayIndexOf(c2, cArray);
                    if (n7 > -1) {
                        smartDateField = (SmartDateField)arrayList.get(n7);
                        n3 = parsePosition.getIndex();
                        object = this.subParseField(string, parsePosition, c2, n5, false, blArray);
                        if (parsePosition.getIndex() < 0 || object instanceof Integer && (Integer)object < 0) {
                            int n10 = patternChars.indexOf(c2);
                            n2 = n3;
                            if (SmartDateFormat.isNumericField(n10, n5)) {
                                if (string.length() > 0) {
                                    smartDateField.setCode(-605);
                                } else {
                                    smartDateField.setCode(-612);
                                }
                                while (n2 < string.length() && (Character.isWhitespace(string.charAt(n2)) || Character.isLetter(string.charAt(n2)))) {
                                    ++n2;
                                }
                            } else {
                                if (string.length() > 0) {
                                    smartDateField.setCode(-606);
                                } else {
                                    smartDateField.setCode(-613);
                                }
                                while (n2 < string.length() && Character.isDigit(string.charAt(n2))) {
                                    ++n2;
                                }
                            }
                            smartDateField.setInput(string.substring(n3, n2));
                            parsePosition.setIndex(n2);
                        } else {
                            smartDateField.setCode(0);
                            String string4 = string.substring(n4);
                            if (string4.length() > parsePosition.getIndex() - n4) {
                                string4 = string4.substring(0, parsePosition.getIndex() - n4);
                            }
                            if (object.getClass().isArray()) {
                                smartDateField.setInput(string4);
                                smartDateField.setNumeric((Integer)((Object[])object)[0]);
                                smartDateField.setTranslations((String[])((Object[])object)[1]);
                            } else {
                                smartDateField.setInput(string4);
                                smartDateField.setNumeric((Integer)object);
                            }
                        }
                        n4 = parsePosition.getIndex();
                        if (smartDateField.getCode() == 0 && n4 > -1 && (n4 >= string.length() || c3 != string.charAt(n4))) {
                            smartDateField.addSeparatorError(-602, this.pattern.substring(n8, n8 + 1), string.substring(n4, string.length() > n4 ? n4 + 1 : n4));
                        }
                    }
                    parsePosition.setIndex(parsePosition.getIndex() + 1);
                    n5 = 0;
                    c2 = '\u0000';
                } else {
                    if (n4 > -1 && (n4 >= string.length() || c3 != string.charAt(n4))) {
                        smartDateField = (SmartDateField)arrayList.get(n7);
                        smartDateField.addSeparatorError(-602, this.pattern.substring(n8, n8 + 1), string.substring(n4, string.length() > n4 ? n4 + 1 : n4));
                    }
                    parsePosition.setIndex(parsePosition.getIndex() + 1);
                }
                ++n6;
            }
            ++n8;
        }
        if (n5 > 0 && parsePosition.getIndex() < string.length() && (n7 = SmartDateFormat.arrayIndexOf(c2, cArray)) > -1) {
            smartDateField = (SmartDateField)arrayList.get(n7);
            n3 = parsePosition.getIndex();
            if (n3 < 0) {
                n3 = 0;
            }
            object = this.subParseField(string, parsePosition, c2, n5, false, blArray);
            if (parsePosition.getIndex() < 0 || object == null || object instanceof Integer && (Integer)object < 0) {
                int n11 = patternChars.indexOf(c2);
                n2 = n3;
                if (SmartDateFormat.isNumericField(n11, n5)) {
                    if (string.length() > 0) {
                        smartDateField.setCode(-605);
                    } else {
                        smartDateField.setCode(-612);
                    }
                    while (n2 < string.length() && (Character.isWhitespace(string.charAt(n2)) || Character.isLetter(string.charAt(n2)))) {
                        ++n2;
                    }
                } else {
                    if (string.length() > 0) {
                        smartDateField.setCode(-606);
                    } else {
                        smartDateField.setCode(-613);
                    }
                    while (n2 < string.length() && Character.isDigit(string.charAt(n2))) {
                        ++n2;
                    }
                }
                n2 = Math.max(n2, n5);
                smartDateField.setInput(string.substring(n3, n2));
                parsePosition.setIndex(n2);
            } else {
                smartDateField.setCode(0);
                String string5 = string.substring(n4);
                if (string5.length() > parsePosition.getIndex() - n4) {
                    string5 = string5.substring(0, parsePosition.getIndex() - n4);
                }
                if (object.getClass().isArray()) {
                    smartDateField.setInput(string5);
                    smartDateField.setNumeric((Integer)((Object[])object)[0]);
                    smartDateField.setTranslations((String[])((Object[])object)[1]);
                } else {
                    smartDateField.setInput(string5);
                    smartDateField.setNumeric((Integer)object);
                }
            }
            if (parsePosition.getIndex() < string.length()) {
                n4 = parsePosition.getIndex();
                if (n4 < 0) {
                    n4 = 0;
                }
                smartDateField.addSeparatorError(-604, "", string.substring(n4));
            }
        }
        return arrayList;
    }

    public Object subParseField(String string, ParsePosition parsePosition, char c2, int n2, boolean bl, boolean[] blArray) {
        int n3 = parsePosition.getIndex();
        if (n3 < 0 || n3 >= string.length()) {
            return null;
        }
        int n4 = 0;
        int n5 = -1;
        n5 = patternChars.indexOf(c2);
        if (n5 == -1) {
            return new Integer(-n3);
        }
        int n6 = PATTERN_INDEX_TO_CALENDAR_FIELD[n5];
        n4 = this.getSubValue(string, parsePosition, n5, n2, bl);
        if (n4 < 0) {
            return new Integer(-1);
        }
        n3 = parsePosition.getIndex();
        switch (n5) {
            case 0: {
                String[] stringArray = this.formatData.getEras();
                n3 = this.matchString(string, n3, 0, stringArray);
                parsePosition.setIndex(n3);
                return new Object[]{new Integer(this.calendar.get(0)), stringArray};
            }
            case 1: {
                if (n2 <= 2 && parsePosition.getIndex() - n3 == 2 && Character.isDigit(string.charAt(n3)) && Character.isDigit(string.charAt(n3 + 1))) {
                    int n7 = this.defaultCenturyStartYear % 100;
                    blArray[0] = n4 == n7;
                    n4 += this.defaultCenturyStartYear / 100 * 100 + (n4 < n7 ? 100 : 0);
                }
                this.calendar.set(1, n4);
                return new Integer(n4);
            }
            case 2: {
                if (n2 <= 2) {
                    this.calendar.set(2, n4 - 1);
                    return new Integer(n4 - 1);
                }
                int n8 = 0;
                String[] stringArray = this.formatData.getMonths();
                n8 = this.matchString(string, n3, 2, stringArray);
                if (n8 > 0) {
                    parsePosition.setIndex(n8);
                    return new Object[]{new Integer(this.calendar.get(2)), stringArray};
                }
                stringArray = this.formatData.getShortMonths();
                n8 = this.matchString(string, n3, 2, stringArray);
                parsePosition.setIndex(n8);
                return new Object[]{new Integer(this.calendar.get(2)), stringArray};
            }
            case 4: {
                if (n4 == this.calendar.getMaximum(11) + 1) {
                    n4 = 0;
                }
                this.calendar.set(11, n4);
                return new Integer(n4);
            }
            case 9: {
                int n9 = 0;
                String[] stringArray = this.formatData.getWeekdays();
                n9 = this.matchString(string, n3, 7, stringArray);
                if (n9 > 0) {
                    parsePosition.setIndex(n9);
                    return new Object[]{new Integer(this.calendar.get(7)), stringArray};
                }
                stringArray = this.formatData.getShortWeekdays();
                n9 = this.matchString(string, n3, 7, stringArray);
                if (n9 > 0) {
                    parsePosition.setIndex(n9);
                    return new Object[]{new Integer(this.calendar.get(7)), stringArray};
                }
                return new Integer(-1);
            }
            case 14: {
                String[] stringArray = this.formatData.getAmPmStrings();
                int n10 = this.matchString(string, n3, 9, stringArray);
                parsePosition.setIndex(n10);
                return new Object[]{new Integer(this.calendar.get(9)), stringArray};
            }
            case 15: {
                if (n4 == this.calendar.getLeastMaximum(10) + 1) {
                    n4 = 0;
                }
                this.calendar.set(10, n4);
                return new Integer(n4);
            }
            case 17: {
                int n11;
                int n12 = 0;
                if (string.length() - n3 >= GMT.length() && string.regionMatches(true, n3, GMT, 0, GMT.length())) {
                    this.calendar.set(16, 0);
                    parsePosition.setIndex(n3 + GMT.length());
                    try {
                        if (string.charAt(parsePosition.getIndex()) == '+') {
                            n12 = 1;
                        } else if (string.charAt(parsePosition.getIndex()) == '-') {
                            n12 = -1;
                        }
                    }
                    catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                        // empty catch block
                    }
                    if (n12 == 0) {
                        this.calendar.set(15, 0);
                        return new Integer(0);
                    }
                    int n13 = parsePosition.getIndex();
                    parsePosition.setIndex(n13++);
                    Number number = this.numberFormat.parse(string, parsePosition);
                    if (number == null) {
                        return new Integer(-1);
                    }
                    if (string.charAt(parsePosition.getIndex()) == ':') {
                        n11 = number.intValue() * 60;
                        n13 = parsePosition.getIndex();
                        parsePosition.setIndex(n13++);
                        number = this.numberFormat.parse(string, parsePosition);
                        if (number == null) {
                            return new Integer(-1);
                        }
                        n11 += number.intValue();
                    } else {
                        n11 = number.intValue();
                        n11 = n11 < 24 ? (n11 *= 60) : n11 % 100 + n11 / 100 * 60;
                    }
                } else {
                    int n14 = this.subParseZoneString(string, n3);
                    if (n14 != 0) {
                        return new Integer(n14);
                    }
                    DecimalFormat decimalFormat = new DecimalFormat("+####;-####");
                    decimalFormat.setParseIntegerOnly(true);
                    Number number = decimalFormat.parse(string, parsePosition);
                    if (number == null) {
                        return new Integer(-1);
                    }
                    n11 = number.intValue();
                    n12 = 1;
                    if (n11 < 0) {
                        n12 = -1;
                        n11 = -n11;
                    }
                    n11 = n11 < 24 ? (n11 *= 60) : n11 % 100 + n11 / 100 * 60;
                }
                if (n12 != 0) {
                    n11 *= 60000 * n12;
                    if (this.calendar.getTimeZone().useDaylightTime()) {
                        this.calendar.set(16, 3600000);
                        n11 -= 3600000;
                    }
                    this.calendar.set(15, n11);
                    return new Integer(n11);
                }
                return new Integer(-1);
            }
        }
        this.calendar.set(n6, n4);
        return new Integer(n4);
    }

    public Date getParsedDate() {
        return this.calendar.getTime();
    }

    public static boolean arrayContains(char c2, char[] cArray) {
        return SmartDateFormat.arrayIndexOf(c2, cArray) > -1;
    }

    public static int arrayIndexOf(char c2, char[] cArray) {
        int n2 = 0;
        while (n2 < cArray.length) {
            if (c2 == cArray[n2]) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public Object[] getCalendarField(int n2, int n3) {
        int n4 = -1;
        String string = null;
        String[] stringArray = null;
        switch (n2) {
            case 0: {
                n4 = this.calendar.get(0);
                stringArray = this.formatData.getEras();
                string = stringArray[n4];
                break;
            }
            case 1: {
                n4 = this.calendar.get(1);
                string = String.valueOf(n4);
                break;
            }
            case 2: {
                n4 = this.calendar.get(2);
                if (n3 > 2) {
                    stringArray = this.formatData.getMonths();
                    string = stringArray[n4];
                    break;
                }
                string = String.valueOf(n4);
                break;
            }
            case 3: {
                n4 = this.calendar.get(5);
                string = String.valueOf(n4);
                break;
            }
            case 4: {
                n4 = this.calendar.get(11) + 1;
                if (n4 == this.calendar.getMaximum(11)) {
                    n4 = 0;
                }
                string = String.valueOf(n4);
                break;
            }
            case 5: {
                n4 = this.calendar.get(11);
                string = this.zeroPaddingNumber(n4, n3, Integer.MAX_VALUE);
                break;
            }
            case 6: {
                n4 = this.calendar.get(12);
                string = String.valueOf(n4);
                string = this.zeroPaddingNumber(n4, n3, Integer.MAX_VALUE);
                break;
            }
            case 7: {
                n4 = this.calendar.get(13);
                string = String.valueOf(n4);
                string = this.zeroPaddingNumber(n4, n3, Integer.MAX_VALUE);
                break;
            }
            case 8: {
                n4 = this.calendar.get(14);
                string = this.zeroPaddingNumber(n4, n3, Integer.MAX_VALUE);
                break;
            }
            case 9: {
                n4 = this.calendar.get(7);
                stringArray = n3 >= 4 ? this.formatData.getWeekdays() : this.formatData.getShortWeekdays();
                string = stringArray[n4];
                break;
            }
            case 10: {
                n4 = this.calendar.get(6);
                string = String.valueOf(n4);
                break;
            }
            case 11: {
                n4 = this.calendar.get(8);
                string = String.valueOf(n4);
                break;
            }
            case 12: {
                n4 = this.calendar.get(3);
                string = String.valueOf(n4);
                break;
            }
            case 13: {
                n4 = this.calendar.get(4);
                string = String.valueOf(n4);
                break;
            }
            case 14: {
                n4 = this.calendar.get(9);
                stringArray = this.formatData.getAmPmStrings();
                string = stringArray[n4];
                break;
            }
            case 15: {
                n4 = this.calendar.get(10) + 1;
                if (n4 == this.calendar.getMaximum(10)) {
                    n4 = 0;
                }
                string = String.valueOf(n4);
                break;
            }
            case 16: {
                n4 = this.calendar.get(10);
                string = String.valueOf(n4);
                break;
            }
            case 17: {
                n4 = this.calendar.get(15);
                stringArray = this.formatData.getZoneStrings();
                string = this.subFormat('z', n3, 0, new FieldPosition(0));
            }
        }
        return new Object[]{string, new Integer(n4), stringArray};
    }

    public void setCalendarField(int n2, Object object) {
        int n3 = (Integer)((Object[])object)[1];
        switch (n2) {
            case 0: {
                this.calendar.set(0, n3);
                break;
            }
            case 1: {
                this.calendar.set(1, n3);
                break;
            }
            case 2: {
                this.calendar.set(2, n3);
                break;
            }
            case 3: {
                this.calendar.set(5, n3);
                break;
            }
            case 4: {
                this.calendar.set(11, n3);
                break;
            }
            case 5: {
                this.calendar.set(11, n3);
                break;
            }
            case 6: {
                this.calendar.set(12, n3);
                break;
            }
            case 7: {
                this.calendar.set(13, n3);
                break;
            }
            case 8: {
                this.calendar.set(14, n3);
                break;
            }
            case 9: {
                this.calendar.set(7, n3);
                break;
            }
            case 10: {
                this.calendar.set(6, n3);
                break;
            }
            case 11: {
                this.calendar.set(8, n3);
                break;
            }
            case 12: {
                this.calendar.set(3, n3);
                break;
            }
            case 13: {
                this.calendar.set(4, n3);
                break;
            }
            case 14: {
                this.calendar.set(9, n3);
                break;
            }
            case 15: {
                this.calendar.set(10, n3);
                break;
            }
            case 16: {
                this.calendar.set(10, n3);
                break;
            }
            case 17: {
                this.calendar.set(15, n3);
            }
        }
    }

    protected void initialize(Locale locale) {
        this.calendar = Calendar.getInstance(TimeZone.getDefault(), locale);
        this.numberFormat = NumberFormat.getInstance(locale);
        this.numberFormat.setGroupingUsed(false);
        if (this.numberFormat instanceof DecimalFormat) {
            ((DecimalFormat)this.numberFormat).setDecimalSeparatorAlwaysShown(false);
        }
        this.numberFormat.setParseIntegerOnly(true);
        this.numberFormat.setMinimumFractionDigits(0);
        this.initializeDefaultCentury();
    }

    protected void initializeDefaultCentury() {
        this.calendar.setTime(new Date());
        this.calendar.add(1, -80);
        this.parseAmbiguousDatesAsAfter(this.calendar.getTime());
    }

    protected void parseAmbiguousDatesAsAfter(Date date) {
        this.defaultCenturyStart = date;
        this.calendar.setTime(date);
        this.defaultCenturyStartYear = this.calendar.get(1);
    }

    public String subFormat(char c2, int n2, int n3, FieldPosition fieldPosition) throws IllegalArgumentException {
        int n4 = -1;
        int n5 = Integer.MAX_VALUE;
        String string = "";
        n4 = patternChars.indexOf(c2);
        if (n4 == -1) {
            throw new IllegalArgumentException("Illegal pattern character '" + c2 + "'");
        }
        int n6 = PATTERN_INDEX_TO_CALENDAR_FIELD[n4];
        int n7 = this.calendar.get(n6);
        switch (n4) {
            case 0: {
                string = this.formatData.getEras()[n7];
                break;
            }
            case 1: {
                if (n2 >= 4) {
                    string = this.zeroPaddingNumber(n7, 4, n5);
                    break;
                }
                string = this.zeroPaddingNumber(n7, 2, 2);
                break;
            }
            case 2: {
                if (n2 >= 4) {
                    string = this.formatData.getMonths()[n7];
                    break;
                }
                if (n2 == 3) {
                    string = this.formatData.getShortWeekdays()[n7];
                    break;
                }
                string = this.zeroPaddingNumber(n7 + 1, n2, n5);
                break;
            }
            case 4: {
                if (n7 == 0) {
                    string = this.zeroPaddingNumber(this.calendar.getMaximum(11) + 1, n2, n5);
                    break;
                }
                string = this.zeroPaddingNumber(n7, n2, n5);
                break;
            }
            case 9: {
                if (n2 >= 4) {
                    string = this.formatData.getWeekdays()[n7];
                    break;
                }
                string = this.formatData.getShortWeekdays()[n7];
                break;
            }
            case 14: {
                string = this.formatData.getAmPmStrings()[n7];
                break;
            }
            case 15: {
                if (n7 == 0) {
                    string = this.zeroPaddingNumber(this.calendar.getLeastMaximum(10) + 1, n2, n5);
                    break;
                }
                string = this.zeroPaddingNumber(n7, n2, n5);
                break;
            }
            case 17: {
                int n8 = this.getZoneIndex(this.calendar.getTimeZone().getID());
                if (n8 == -1) {
                    StringBuffer stringBuffer = new StringBuffer();
                    n7 = this.calendar.get(15) + this.calendar.get(16);
                    if (n7 < 0) {
                        stringBuffer.append(GMT_MINUS);
                        n7 = -n7;
                    } else {
                        stringBuffer.append(GMT_PLUS);
                    }
                    stringBuffer.append(this.zeroPaddingNumber(n7 / 3600000, 2, 2));
                    stringBuffer.append(':');
                    stringBuffer.append(this.zeroPaddingNumber(n7 % 3600000 / 60000, 2, 2));
                    string = stringBuffer.toString();
                    break;
                }
                if (this.calendar.get(16) != 0) {
                    if (n2 >= 4) {
                        string = this.formatData.getZoneStrings()[n8][3];
                        break;
                    }
                    string = this.formatData.getZoneStrings()[n8][4];
                    break;
                }
                if (n2 >= 4) {
                    string = this.formatData.getZoneStrings()[n8][1];
                    break;
                }
                string = this.formatData.getZoneStrings()[n8][2];
                break;
            }
            default: {
                string = this.zeroPaddingNumber(n7, n2, n5);
            }
        }
        if (fieldPosition.getField() == PATTERN_INDEX_TO_DATE_FORMAT_FIELD[n4] && fieldPosition.getBeginIndex() == 0 && fieldPosition.getEndIndex() == 0) {
            fieldPosition.setBeginIndex(n3);
            fieldPosition.setEndIndex(n3 + string.length());
        }
        return string;
    }

    protected String zeroPaddingNumber(long l2, int n2, int n3) {
        this.numberFormat.setMinimumIntegerDigits(n2);
        this.numberFormat.setMaximumIntegerDigits(n3);
        return this.numberFormat.format(l2);
    }

    protected static boolean isNumericField(int n2, int n3) {
        switch (n2) {
            case 2: {
                if (n3 > 2) {
                    return false;
                }
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: {
                return true;
            }
        }
        return false;
    }

    protected int getSubValue(String string, ParsePosition parsePosition, int n2, int n3, boolean bl) {
        int n4 = parsePosition.getIndex();
        if (n4 < 0 || n4 >= string.length()) {
            return -1;
        }
        int n5 = n4;
        while (true) {
            if (n5 >= string.length()) {
                return -1;
            }
            char c2 = string.charAt(n5);
            if (!Character.isWhitespace(c2)) break;
            ++n5;
        }
        parsePosition.setIndex(n5);
        if (SmartDateFormat.isNumericField(n2, n3)) {
            if (!Character.isDigit(string.charAt(n5))) {
                return -1;
            }
            Number number = null;
            if (bl) {
                if (n5 + n3 > string.length()) {
                    return -1;
                }
                number = this.numberFormat.parse(string.substring(0, n5 + n3), parsePosition);
            } else {
                number = this.numberFormat.parse(string, parsePosition);
            }
            if (number == null) {
                return -1;
            }
            return number.intValue();
        }
        return 0;
    }

    public int subParse(String string, int n2, char c2, int n3, boolean bl, boolean[] blArray) {
        int n4 = 0;
        ParsePosition parsePosition = new ParsePosition(0);
        int n5 = patternChars.indexOf(c2);
        if (n5 == -1) {
            return -1;
        }
        parsePosition.setIndex(n2);
        int n6 = PATTERN_INDEX_TO_CALENDAR_FIELD[n5];
        n4 = this.getSubValue(string, parsePosition, n5, n3, bl);
        if (n4 < 0) {
            return -1;
        }
        n2 = parsePosition.getIndex();
        switch (n5) {
            case 0: {
                return this.matchString(string, n2, 0, this.formatData.getEras());
            }
            case 1: {
                if (n3 <= 2 && parsePosition.getIndex() - n2 == 2 && Character.isDigit(string.charAt(n2)) && Character.isDigit(string.charAt(n2 + 1))) {
                    int n7 = this.defaultCenturyStartYear % 100;
                    blArray[0] = n4 == n7;
                    n4 += this.defaultCenturyStartYear / 100 * 100 + (n4 < n7 ? 100 : 0);
                }
                this.calendar.set(1, n4);
                return parsePosition.getIndex();
            }
            case 2: {
                if (n3 <= 2) {
                    this.calendar.set(2, n4 - 1);
                    return parsePosition.getIndex();
                }
                int n8 = 0;
                n8 = this.matchString(string, n2, 2, this.formatData.getMonths());
                if (n8 > 0) {
                    return n8;
                }
                return this.matchString(string, n2, 2, this.formatData.getShortMonths());
            }
            case 4: {
                if (n4 == this.calendar.getMaximum(11) + 1) {
                    n4 = 0;
                }
                this.calendar.set(11, n4);
                return parsePosition.getIndex();
            }
            case 9: {
                int n9 = 0;
                n9 = this.matchString(string, n2, 7, this.formatData.getWeekdays());
                if (n9 > 0) {
                    return n9;
                }
                n9 = this.matchString(string, n2, 7, this.formatData.getShortWeekdays());
                if (n9 > 0) {
                    return n9;
                }
                return -1;
            }
            case 14: {
                return this.matchString(string, n2, 9, this.formatData.getAmPmStrings());
            }
            case 15: {
                if (n4 == this.calendar.getLeastMaximum(10) + 1) {
                    n4 = 0;
                }
                this.calendar.set(10, n4);
                return parsePosition.getIndex();
            }
            case 17: {
                int n10;
                int n11 = 0;
                if (string.length() - n2 >= GMT.length() && string.regionMatches(true, n2, GMT, 0, GMT.length())) {
                    this.calendar.set(16, 0);
                    parsePosition.setIndex(n2 + GMT.length());
                    try {
                        if (string.charAt(parsePosition.getIndex()) == '+') {
                            n11 = 1;
                        } else if (string.charAt(parsePosition.getIndex()) == '-') {
                            n11 = -1;
                        }
                    }
                    catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                        // empty catch block
                    }
                    if (n11 == 0) {
                        this.calendar.set(15, 0);
                        return parsePosition.getIndex();
                    }
                    int n12 = parsePosition.getIndex();
                    parsePosition.setIndex(n12++);
                    Number number = this.numberFormat.parse(string, parsePosition);
                    if (number == null) {
                        return -1;
                    }
                    if (string.charAt(parsePosition.getIndex()) == ':') {
                        n10 = number.intValue() * 60;
                        n12 = parsePosition.getIndex();
                        parsePosition.setIndex(n12++);
                        number = this.numberFormat.parse(string, parsePosition);
                        if (number == null) {
                            return -n2;
                        }
                        n10 += number.intValue();
                    } else {
                        n10 = number.intValue();
                        n10 = n10 < 24 ? (n10 *= 60) : n10 % 100 + n10 / 100 * 60;
                    }
                } else {
                    int n13 = this.subParseZoneString(string, n2);
                    if (n13 != 0) {
                        return n13;
                    }
                    DecimalFormat decimalFormat = new DecimalFormat("+####;-####");
                    decimalFormat.setParseIntegerOnly(true);
                    Number number = decimalFormat.parse(string, parsePosition);
                    if (number == null) {
                        return -n2;
                    }
                    n10 = number.intValue();
                    n11 = 1;
                    if (n10 < 0) {
                        n11 = -1;
                        n10 = -n10;
                    }
                    n10 = n10 < 24 ? (n10 *= 60) : n10 % 100 + n10 / 100 * 60;
                }
                if (n11 != 0) {
                    n10 *= 60000 * n11;
                    if (this.calendar.getTimeZone().useDaylightTime()) {
                        this.calendar.set(16, 3600000);
                        n10 -= 3600000;
                    }
                    this.calendar.set(15, n10);
                    return parsePosition.getIndex();
                }
                return -n2;
            }
        }
        this.calendar.set(n6, n4);
        return parsePosition.getIndex();
    }

    protected int matchString(String string, int n2, int n3, String[] stringArray) {
        int n4 = 0;
        int n5 = stringArray.length;
        if (n3 == 7) {
            n4 = 1;
        }
        int n6 = 0;
        int n7 = -1;
        int n8 = 0;
        while (n4 < n5) {
            n8 = this.matchLeftOrRight(string, n2, stringArray[n4]);
            if (n8 > n6) {
                n7 = n4;
                n6 = n8;
            }
            ++n4;
        }
        if (n7 >= 0) {
            this.calendar.set(n3, n7);
            return n2 + n6;
        }
        return -n2;
    }

    protected int matchLeftOrRight(String string, int n2, String string2) {
        int n3 = string2.length();
        if (string.regionMatches(true, n2, string2, 0, n3)) {
            return n3;
        }
        int n4 = 0;
        char c2 = Character.toUpperCase(string.charAt(n2 + n4));
        char c3 = Character.toUpperCase(string2.charAt(n4));
        while (c2 == c3 && string.length() > n2 + n4 + 1 && string2.length() > n4 + 1) {
            c2 = Character.toUpperCase(string.charAt(n2 + ++n4));
            c3 = Character.toUpperCase(string2.charAt(n4));
        }
        return n4;
    }

    protected int matchZoneString(String string, int n2, int n3) {
        int n4 = 1;
        while (n4 <= 4) {
            if (string.regionMatches(true, n2, this.formatData.getZoneStrings()[n3][n4], 0, this.formatData.getZoneStrings()[n3][n4].length())) break;
            ++n4;
        }
        return n4 > 4 ? -1 : n4;
    }

    final int getZoneIndex(String string) {
        String[][] stringArray = this.formatData.getZoneStrings();
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (string.equalsIgnoreCase(stringArray[n2][0])) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    protected int subParseZoneString(String string, int n2) {
        int n3 = this.getZoneIndex(this.getTimeZone().getID());
        TimeZone timeZone = null;
        int n4 = 0;
        int n5 = 0;
        if (n3 != -1 && (n4 = this.matchZoneString(string, n2, n3)) > 0) {
            timeZone = TimeZone.getTimeZone(this.formatData.getZoneStrings()[n3][0]);
            n5 = n3;
        }
        if (timeZone == null && (n3 = this.getZoneIndex(TimeZone.getDefault().getID())) != -1 && (n4 = this.matchZoneString(string, n2, n3)) > 0) {
            timeZone = TimeZone.getTimeZone(this.formatData.getZoneStrings()[n3][0]);
            n5 = n3;
        }
        if (timeZone == null) {
            n5 = 0;
            while (n5 < this.formatData.getZoneStrings().length) {
                n4 = this.matchZoneString(string, n2, n5);
                if (n4 > 0) {
                    timeZone = TimeZone.getTimeZone(this.formatData.getZoneStrings()[n5][0]);
                    break;
                }
                ++n5;
            }
        }
        if (timeZone != null) {
            this.calendar.set(15, timeZone.getRawOffset());
            this.calendar.set(16, n4 >= 3 ? ((SimpleTimeZone)timeZone).getDSTSavings() : 0);
            return n2 + this.formatData.getZoneStrings()[n5][n4].length();
        }
        return 0;
    }

    public Object clone() {
        SmartDateFormat smartDateFormat = (SmartDateFormat)super.clone();
        smartDateFormat.formatData = (DateFormatSymbols)this.formatData.clone();
        return smartDateFormat;
    }

    public int hashCode() {
        return this.pattern.hashCode();
    }

    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        SmartDateFormat smartDateFormat = (SmartDateFormat)object;
        return this.pattern.equals(smartDateFormat.pattern) && this.formatData.equals(smartDateFormat.formatData);
    }

    protected void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.parseAmbiguousDatesAsAfter(this.defaultCenturyStart);
    }
}

