/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common.smartx.support.diagnoser;

import java.util.ArrayList;

public class SmartDateField {
    private static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected char patternChar;
    protected int code;
    protected String input;
    protected int ivalue;
    protected String[] translations;
    protected ArrayList separatorErrors;

    protected SmartDateField() {
    }

    public SmartDateField(char c2) {
        this.patternChar = c2;
        this.code = -1;
        this.input = null;
        this.ivalue = -1;
        this.translations = null;
        this.separatorErrors = null;
    }

    public char getPatternChar() {
        return this.patternChar;
    }

    public void setCode(int n2) {
        this.code = n2;
    }

    public int getCode() {
        return this.code;
    }

    public void setInput(String string) {
        this.input = string;
    }

    public String getInput() {
        return this.input;
    }

    public void setNumeric(int n2) {
        this.ivalue = n2;
    }

    public int getNumeric() {
        return this.ivalue;
    }

    public void setTranslations(String[] stringArray) {
        this.translations = stringArray;
    }

    public String[] getTranslations() {
        return this.translations;
    }

    public String getTranslation() {
        String string = null;
        if (this.ivalue > -1 && this.translations != null) {
            string = this.translations[this.ivalue];
        }
        return string;
    }

    public int getSeparatorErrorCount() {
        if (this.separatorErrors == null) {
            return 0;
        }
        return this.separatorErrors.size();
    }

    public int getSeparatorErrorCode(int n2) {
        if (this.separatorErrors == null || this.separatorErrors.size() <= n2) {
            return 0;
        }
        return ((SeparatorError)this.separatorErrors.get(n2)).getCode();
    }

    public String getSeparatorErrorExpected(int n2) {
        if (this.separatorErrors == null || this.separatorErrors.size() <= n2) {
            return null;
        }
        return ((SeparatorError)this.separatorErrors.get(n2)).getExpected();
    }

    public String getSeparatorErrorFound(int n2) {
        if (this.separatorErrors == null || this.separatorErrors.size() <= n2) {
            return null;
        }
        return ((SeparatorError)this.separatorErrors.get(n2)).getFound();
    }

    public void addSeparatorError(int n2, String string, String string2) {
        SeparatorError separatorError;
        if (this.separatorErrors == null) {
            this.separatorErrors = new ArrayList(2);
        }
        if (this.separatorErrors.size() > 0 && (separatorError = (SeparatorError)this.separatorErrors.get(this.separatorErrors.size() - 1)).getCode() == n2) {
            separatorError.setExpected(separatorError.getExpected() + string);
            separatorError.setFound(separatorError.getFound() + string2);
            return;
        }
        this.separatorErrors.add(new SeparatorError(n2, string, string2));
    }

    public static void dumpFields(ArrayList arrayList) {
        if (arrayList == null || arrayList.size() == 0) {
            return;
        }
        System.out.print("Fields: [");
        int n2 = arrayList.size();
        int n3 = 0;
        while (n3 < n2) {
            System.out.print(((SmartDateField)arrayList.get(n3)).getPatternChar());
            if (n3 < n2 - 1) {
                System.out.print(",");
            }
            ++n3;
        }
        System.out.println("]");
        n3 = 0;
        while (n3 < n2) {
            int n4;
            int n5;
            SmartDateField smartDateField = (SmartDateField)arrayList.get(n3);
            System.out.print("\t");
            System.out.print(smartDateField.getCode());
            if (smartDateField.getInput() == null) {
                System.out.print(": ");
            } else {
                System.out.print(": \"");
            }
            System.out.print(smartDateField.getInput());
            if (smartDateField.getInput() == null) {
                System.out.print(", ");
            } else {
                System.out.print("\", ");
            }
            System.out.print(smartDateField.getNumeric());
            String[] stringArray = smartDateField.getTranslations();
            if (stringArray != null) {
                System.out.print(", [");
                n5 = stringArray.length;
                n4 = 0;
                while (n4 < n5) {
                    System.out.print(stringArray[n4]);
                    if (n4 < n5 - 1) {
                        System.out.print(",");
                    }
                    ++n4;
                }
                System.out.print("]");
            }
            if ((n5 = smartDateField.getSeparatorErrorCount()) > 0) {
                n4 = 0;
                while (n4 < n5) {
                    System.out.print("\n\t[");
                    System.out.print(smartDateField.getSeparatorErrorCode(n4));
                    System.out.print(",\"");
                    System.out.print(smartDateField.getSeparatorErrorExpected(n4));
                    System.out.print("\",\"");
                    System.out.print(smartDateField.getSeparatorErrorFound(n4));
                    System.out.print("\"]");
                    ++n4;
                }
            }
            System.out.print("\n");
            ++n3;
        }
    }

    protected class SeparatorError {
        private static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
        protected int code;
        protected String expected;
        protected String found;

        public SeparatorError(int n2, String string, String string2) {
            this.code = n2;
            this.expected = string;
            this.found = string2;
        }

        public int getCode() {
            return this.code;
        }

        public void setExpected(String string) {
            this.expected = string;
        }

        public String getExpected() {
            return this.expected;
        }

        public void setFound(String string) {
            this.found = string;
        }

        public String getFound() {
            return this.found;
        }
    }
}

