/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common.smartx.support.diagnoser;

import com.ibm.db2.tools.common.smartx.event.Diagnosis;
import com.ibm.db2.tools.common.smartx.support.SmartConstraints;
import com.ibm.db2.tools.common.smartx.support.SmartManager;
import com.ibm.db2.tools.common.smartx.support.SmartResources;
import com.ibm.db2.tools.common.smartx.support.SmartUtil;
import com.ibm.db2.tools.common.smartx.support.diagnoser.DiagnoserUtil;
import com.ibm.db2.tools.common.smartx.support.diagnoser.SmartDiagnoser;
import com.ibm.db2.tools.common.support.ReuseStringBuffer;
import java.util.HashSet;

public class PasswordDiagnoser
implements SmartDiagnoser {
    public static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected static PasswordDiagnoser myself;
    protected static final String upperchars = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    protected static final String lowerchars = "abcdefghijklmnopqrstuvwxyz";
    protected static final String mixedchars = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
    protected static HashSet sqlReserved;
    protected static HashSet sqlReservedPasswords;

    public static PasswordDiagnoser getDiagnoserInstance() {
        if (myself == null) {
            myself = new PasswordDiagnoser();
        }
        return myself;
    }

    public boolean smartVerify(StringBuffer stringBuffer, int[] nArray, SmartConstraints smartConstraints, Diagnosis diagnosis) {
        if (smartConstraints.getConstraintFlag(8).booleanValue()) {
            smartConstraints.setConstraintFlag(8, false);
            return true;
        }
        if (smartConstraints.getConstraintFlag(7).booleanValue()) {
            diagnosis.clearDiagnoses();
        }
        String string = smartConstraints.getDefaultString();
        int n2 = (Integer)smartConstraints.getConstraint("Type");
        boolean bl = smartConstraints.getConstraintFlag(0);
        int n3 = 1;
        if (!bl) {
            n3 = 0;
        }
        int n4 = 40;
        Integer n5 = (Integer)smartConstraints.getConstraint("MinimumLength");
        Integer n6 = (Integer)smartConstraints.getConstraint("MaximumLength");
        if (n5 != null) {
            int n7 = n3 = n3 > n5 ? n3 : n5;
        }
        if (n6 != null) {
            int n8 = n4 = n4 < n6 ? n4 : n6;
        }
        if ((n2 & 0x100004) > 0) {
            int n9 = n4 = n4 < 14 ? n4 : 14;
        }
        if ((n2 & 0x100020) > 0) {
            n4 = n4 < 10 ? n4 : 10;
        }
        boolean bl2 = smartConstraints.getConstraintFlag(6);
        boolean bl3 = smartConstraints.getConstraintFlag(5);
        int n10 = DiagnoserUtil.trimText(stringBuffer, nArray[1], smartConstraints);
        int n11 = 0;
        int n12 = stringBuffer.length();
        if (string == null || string.length() == 0) {
            string = System.getProperty("user.name");
        }
        if (stringBuffer.length() == 0) {
            if (bl) {
                if (bl3 || SmartManager.getFixPolicy()) {
                    stringBuffer.append(string);
                    n10 = n12 = stringBuffer.length();
                }
                diagnosis.addDiagnostic(-760, SmartResources.get(73));
                if (n3 > 0 && n4 > 0) {
                    Object[] objectArray = new Object[]{new Integer(n3), new Integer(n4)};
                    diagnosis.addDiagnostic(-756, SmartResources.get(69, objectArray));
                } else if (n4 > 0) {
                    if (n4 == 1) {
                        diagnosis.addDiagnostic(-759, SmartResources.get(72));
                    } else {
                        Object[] objectArray = new Object[]{new Integer(n4)};
                        diagnosis.addDiagnostic(-761, SmartResources.get(74, objectArray));
                    }
                }
            }
        } else {
            Object[] objectArray;
            boolean bl4 = false;
            String string2 = mixedchars;
            if (n2 == 0x100002) {
                string2 = lowerchars;
            } else if (n2 == 0x100008) {
                string2 = upperchars;
            }
            int n13 = 0;
            ReuseStringBuffer reuseStringBuffer = ReuseStringBuffer.getBuffer();
            ReuseStringBuffer reuseStringBuffer2 = ReuseStringBuffer.getBuffer();
            int n14 = 0;
            while (n14 < n12) {
                char c2 = stringBuffer.charAt(n14);
                if (c2 == '@' || c2 == '#' || c2 == '$' || Character.isDigit(c2) || string2.indexOf(c2) > -1) {
                    reuseStringBuffer.append(c2);
                } else {
                    ++n13;
                    if (reuseStringBuffer2.length() == 0) {
                        diagnosis.addDiagnostic(-803, SmartResources.get(116));
                    } else {
                        reuseStringBuffer2.append(' ');
                    }
                    if (Character.isSpaceChar(c2)) {
                        reuseStringBuffer2.append(SmartResources.get(222));
                    } else {
                        SmartUtil.htmlMeta(reuseStringBuffer2, c2);
                    }
                    if (n14 <= n10) {
                        ++n11;
                    }
                    if (!bl4 && n2 == 0x100002 && mixedchars.indexOf(c2) > -1 && upperchars.indexOf(c2) > -1) {
                        bl4 = true;
                    } else if (!bl4 && n2 == 0x100008 && mixedchars.indexOf(c2) > -1 && lowerchars.indexOf(c2) > -1) {
                        bl4 = true;
                    }
                }
                ++n14;
            }
            n10 -= n11;
            stringBuffer.setLength(0);
            stringBuffer.append(ReuseStringBuffer.toString(reuseStringBuffer));
            n12 = stringBuffer.length();
            if (n13 > 0) {
                if (bl4 && n2 == 0x100002) {
                    diagnosis.addDiagnostic(-804, SmartResources.get(117));
                } else if (bl4 && n2 == 0x100008) {
                    diagnosis.addDiagnostic(-805, SmartResources.get(118));
                }
                objectArray = new Object[]{reuseStringBuffer2.toString()};
                if (n13 > 1) {
                    diagnosis.addDiagnostic(-999, SmartResources.get(165, objectArray));
                } else {
                    diagnosis.addDiagnostic(-998, SmartResources.get(164, objectArray));
                }
            }
            if (!bl2 && n12 > 0 && (sqlReserved.contains(objectArray = stringBuffer.toString().toUpperCase()) || sqlReservedPasswords.contains(objectArray))) {
                if (n10 == n12) {
                    ++n10;
                }
                diagnosis.addDiagnostic(-802, SmartResources.get(115));
            }
            if (n12 > 0) {
                if (!bl2 && n12 < n3) {
                    objectArray = new Object[]{new Integer(n3), new Integer(n4)};
                    diagnosis.addDiagnostic(-756, SmartResources.get(69, objectArray));
                } else if (n4 > n3 && n12 > n4) {
                    if (n10 == n12 - n4 - 1) {
                        stringBuffer.delete(0, n10 + 1);
                        n10 = 0;
                    } else if (n10 >= n12) {
                        stringBuffer.setLength(n4);
                        n10 = n4;
                    } else if (n10 - (n12 - n4) > -1) {
                        stringBuffer.delete(n10 - (n12 - n4), n10);
                        n10 -= n12 - n4;
                    } else {
                        stringBuffer.setLength(n4);
                        n10 = n4;
                    }
                    if (n4 == 1) {
                        diagnosis.addDiagnostic(-759, SmartResources.get(72));
                    } else {
                        objectArray = new Object[]{new Integer(n4)};
                        diagnosis.addDiagnostic(-761, SmartResources.get(74, objectArray));
                    }
                }
            }
            ReuseStringBuffer.freeBuffer(reuseStringBuffer2);
        }
        if (diagnosis != null && diagnosis.hasError()) {
            nArray[0] = n10;
            nArray[1] = n10;
            if (bl3 || SmartManager.getFixPolicy()) {
                if (bl && stringBuffer.length() == 0) {
                    stringBuffer.append(string);
                }
                nArray[0] = 0;
                nArray[1] = stringBuffer.length();
                smartConstraints.setConstraintFlag(8, true);
            }
            return bl3;
        }
        return true;
    }

    public PasswordDiagnoser() {
        if (sqlReserved == null) {
            sqlReserved = new HashSet(123);
            sqlReservedPasswords = new HashSet(10);
            this.initReservedSets();
        }
    }

    protected void initReservedSets() {
        sqlReserved.add("ACQUIRE");
        sqlReserved.add("ADD");
        sqlReserved.add("ALL");
        sqlReserved.add("ALLOCATE");
        sqlReserved.add("ALTER");
        sqlReserved.add("AND");
        sqlReserved.add("ANY");
        sqlReserved.add("AS");
        sqlReserved.add("ASC");
        sqlReserved.add("AUDIT");
        sqlReserved.add("AUTHORIZATION");
        sqlReserved.add("AVG");
        sqlReserved.add("BETWEEN");
        sqlReserved.add("BUFFERPOOL");
        sqlReserved.add("BY");
        sqlReserved.add("CALL");
        sqlReserved.add("CAPTURE");
        sqlReserved.add("CASE");
        sqlReserved.add("CAST");
        sqlReserved.add("CCSID");
        sqlReserved.add("CHAR");
        sqlReserved.add("CHARACTER");
        sqlReserved.add("CHECK");
        sqlReserved.add("CLUSTER");
        sqlReserved.add("COLLECTION");
        sqlReserved.add("COLUMN");
        sqlReserved.add("COMMENT");
        sqlReserved.add("COMMIT");
        sqlReserved.add("CONCAT");
        sqlReserved.add("CONNECT");
        sqlReserved.add("CONNECTION");
        sqlReserved.add("CONSTRAINT");
        sqlReserved.add("COUNT");
        sqlReserved.add("CREATE");
        sqlReserved.add("CROSS");
        sqlReserved.add("CURRENT");
        sqlReserved.add("CURRENT_DATE");
        sqlReserved.add("CURRENT_SERVER");
        sqlReserved.add("CURRENT_TIME");
        sqlReserved.add("CURRENT_TIMESTAMP");
        sqlReserved.add("CURRENT_TIMEZONE");
        sqlReserved.add("CURRENT_USER");
        sqlReserved.add("CURSOR");
        sqlReserved.add("DATABASE");
        sqlReserved.add("DATE");
        sqlReserved.add("DAY");
        sqlReserved.add("DAYS");
        sqlReserved.add("DBA");
        sqlReserved.add("DBSPACE");
        sqlReserved.add("DEFAULT");
        sqlReserved.add("DELETE");
        sqlReserved.add("DESC");
        sqlReserved.add("DESCRIPTOR");
        sqlReserved.add("DISTINCT");
        sqlReserved.add("DOUBLE");
        sqlReserved.add("DROP");
        sqlReserved.add("EDITPROC");
        sqlReserved.add("ELSE");
        sqlReserved.add("END-EXEC");
        sqlReserved.add("ERASE");
        sqlReserved.add("ESCAPE");
        sqlReserved.add("EXCEPT");
        sqlReserved.add("EXCEPTION");
        sqlReserved.add("EXCLUSIVE");
        sqlReserved.add("EXECUTE");
        sqlReserved.add("EXISTS");
        sqlReserved.add("EXPLAIN");
        sqlReserved.add("EXTERNAL");
        sqlReserved.add("FETCH");
        sqlReserved.add("FIELDPROC");
        sqlReserved.add("FOR");
        sqlReserved.add("FOREIGN");
        sqlReserved.add("FROM");
        sqlReserved.add("FULL");
        sqlReserved.add("GO");
        sqlReserved.add("GOTO");
        sqlReserved.add("GRANT");
        sqlReserved.add("GRAPHIC");
        sqlReserved.add("GROUP");
        sqlReserved.add("HAVING");
        sqlReserved.add("HOUR");
        sqlReserved.add("HOURS");
        sqlReserved.add("IDENTIFIED");
        sqlReserved.add("IMMEDIATE");
        sqlReserved.add("IN");
        sqlReserved.add("INDEX");
        sqlReserved.add("INDICATOR");
        sqlReserved.add("INNER");
        sqlReserved.add("INOUT");
        sqlReserved.add("INSERT");
        sqlReserved.add("INTERSECT");
        sqlReserved.add("INTO");
        sqlReserved.add("IS");
        sqlReserved.add("ISOLATION");
        sqlReserved.add("JOIN");
        sqlReserved.add("KEY");
        sqlReserved.add("LABEL");
        sqlReserved.add("LEFT");
        sqlReserved.add("LIKE");
        sqlReserved.add("LOCK");
        sqlReserved.add("LOCKSIZE");
        sqlReserved.add("LONG");
        sqlReserved.add("MAX");
        sqlReserved.add("MICROSECOND");
        sqlReserved.add("MICROSECONDS");
        sqlReserved.add("MIN");
        sqlReserved.add("MINUTE");
        sqlReserved.add("MINUTES");
        sqlReserved.add("MODE");
        sqlReserved.add("MONTH");
        sqlReserved.add("MONTHS");
        sqlReserved.add("NAMED");
        sqlReserved.add("NHEADER");
        sqlReserved.add("NOT");
        sqlReserved.add("NULL");
        sqlReserved.add("NUMPARTS");
        sqlReserved.add("OBID");
        sqlReserved.add("OF");
        sqlReserved.add("ON");
        sqlReserved.add("ONLY");
        sqlReserved.add("OPTIMIZE");
        sqlReserved.add("OPTION");
        sqlReserved.add("OR");
        sqlReserved.add("ORDER");
        sqlReserved.add("OUT");
        sqlReserved.add("OUTER");
        sqlReserved.add("PACKAGE");
        sqlReserved.add("PAGE");
        sqlReserved.add("PAGES");
        sqlReserved.add("PART");
        sqlReserved.add("PCTFREE");
        sqlReserved.add("PCTINDEX");
        sqlReserved.add("PLAN");
        sqlReserved.add("PRECISION");
        sqlReserved.add("PRIMARY");
        sqlReserved.add("PRIQTY");
        sqlReserved.add("PRIVATE");
        sqlReserved.add("PRIVILEGES");
        sqlReserved.add("PROCEDURE");
        sqlReserved.add("PROGRAM");
        sqlReserved.add("PUBLIC");
        sqlReserved.add("REFERENCES");
        sqlReserved.add("RELEASE");
        sqlReserved.add("RESET");
        sqlReserved.add("RESOURCE");
        sqlReserved.add("RETURN");
        sqlReserved.add("REVOKE");
        sqlReserved.add("RIGHT");
        sqlReserved.add("ROLLBACK");
        sqlReserved.add("ROW");
        sqlReserved.add("ROWS");
        sqlReserved.add("RRN");
        sqlReserved.add("RUN");
        sqlReserved.add("SCHEDULE");
        sqlReserved.add("SCHEMA");
        sqlReserved.add("SECOND");
        sqlReserved.add("SECONDS");
        sqlReserved.add("SECQTY");
        sqlReserved.add("SELECT");
        sqlReserved.add("SET");
        sqlReserved.add("SHARE");
        sqlReserved.add("SIMPLE");
        sqlReserved.add("SOME");
        sqlReserved.add("STATISTICS");
        sqlReserved.add("STOGROUP");
        sqlReserved.add("STORPOOL");
        sqlReserved.add("SUBPAGES");
        sqlReserved.add("SUBSTRING");
        sqlReserved.add("SUM");
        sqlReserved.add("SYNONYM");
        sqlReserved.add("TABLE");
        sqlReserved.add("TABLESPACE");
        sqlReserved.add("TO");
        sqlReserved.add("TRANSACTION");
        sqlReserved.add("TRIM");
        sqlReserved.add("UNION");
        sqlReserved.add("UNIQUE");
        sqlReserved.add("UPDATE");
        sqlReserved.add("USER");
        sqlReserved.add("USING");
        sqlReserved.add("VALIDPROC");
        sqlReserved.add("VALUES");
        sqlReserved.add("VARIABLE");
        sqlReserved.add("VCAT");
        sqlReserved.add("VIEW");
        sqlReserved.add("VOLUMES");
        sqlReserved.add("WHERE");
        sqlReserved.add("WITH");
        sqlReserved.add("WORK");
        sqlReserved.add("YEAR");
        sqlReserved.add("YEARS");
        sqlReservedPasswords.add("USERS");
        sqlReservedPasswords.add("ADMINS");
        sqlReservedPasswords.add("GUESTS");
        sqlReservedPasswords.add("PUBLIC");
        sqlReservedPasswords.add("LOCAL");
    }
}

