/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common.smartx.support.diagnoser;

import com.ibm.db2.tools.common.smartx.event.Diagnosis;
import com.ibm.db2.tools.common.smartx.support.SmartConstraints;
import com.ibm.db2.tools.common.smartx.support.SmartManager;
import com.ibm.db2.tools.common.smartx.support.SmartResources;
import com.ibm.db2.tools.common.smartx.support.SmartUtil;
import com.ibm.db2.tools.common.smartx.support.diagnoser.DiagnoserUtil;
import com.ibm.db2.tools.common.smartx.support.diagnoser.SmartDiagnoser;
import com.ibm.db2.tools.common.support.ReuseStringBuffer;
import java.util.Hashtable;

public class HostIDDiagnoser
implements SmartDiagnoser {
    public static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected static HostIDDiagnoser myself;

    public static HostIDDiagnoser getDiagnoserInstance() {
        if (myself == null) {
            myself = new HostIDDiagnoser();
        }
        return myself;
    }

    public boolean smartVerify(StringBuffer stringBuffer, int[] nArray, SmartConstraints smartConstraints, Diagnosis diagnosis) {
        String string;
        if (smartConstraints.getConstraintFlag(8).booleanValue()) {
            smartConstraints.setConstraintFlag(8, false);
            return true;
        }
        if (smartConstraints.getConstraintFlag(7).booleanValue()) {
            diagnosis.clearDiagnoses();
        }
        if ((string = smartConstraints.getDefaultString()) == null) {
            string = "var";
        }
        boolean bl = smartConstraints.getConstraintFlag(0);
        boolean bl2 = smartConstraints.getConstraintFlag(5);
        int n2 = DiagnoserUtil.trimText(stringBuffer, nArray[1], smartConstraints);
        int n3 = stringBuffer.length();
        String string2 = "";
        int n4 = (Integer)smartConstraints.getConstraint("Type");
        if (n3 == 0) {
            if (bl) {
                if (bl2 || SmartManager.getFixPolicy()) {
                    stringBuffer.append(string);
                    n2 = n3 = stringBuffer.length();
                }
                diagnosis.addDiagnostic(-760, SmartResources.get(73));
            }
        } else if (n4 == 3072 || n4 == 3328) {
            Object object;
            string2 = n4 == 3072 ? "C" : "C++";
            char c2 = stringBuffer.charAt(0);
            int n5 = 0;
            while (n5 < n3 && !Character.isLetter(c2)) {
                c2 = stringBuffer.charAt(n5);
                ++n5;
            }
            if (n5 > 0) {
                stringBuffer.delete(0, --n5);
                n3 -= n5;
                n2 = n2 > n5 ? (n2 -= n5) : 0;
                Object[] objectArray = new Object[]{string2};
                diagnosis.addDiagnostic(-740, SmartResources.get(54, objectArray));
            }
            boolean bl3 = false;
            ReuseStringBuffer reuseStringBuffer = ReuseStringBuffer.getBuffer();
            reuseStringBuffer.append(c2);
            n5 = 1;
            while (n5 < n3) {
                c2 = stringBuffer.charAt(n5);
                if (!Character.isLetterOrDigit(c2) && c2 != '_') {
                    if (n5 <= n2) {
                        --n2;
                    }
                    bl3 = true;
                } else {
                    reuseStringBuffer.append(c2);
                }
                ++n5;
            }
            if (bl3) {
                stringBuffer.setLength(0);
                stringBuffer.append(ReuseStringBuffer.toString(reuseStringBuffer));
                n3 = stringBuffer.length();
                object = new Object[]{string2};
                diagnosis.addDiagnostic(-741, SmartResources.get(55, object));
            }
            if (n3 > 0) {
                bl3 = false;
                if (n4 == 3072) {
                    object = (Object[])SmartUtil.getResource("CReserved");
                    if (object != null && object.get(stringBuffer.toString()) != null) {
                        bl3 = true;
                    }
                } else {
                    object = (Hashtable)SmartUtil.getResource("C++Reserved");
                    if (object != null && object.get(stringBuffer.toString()) != null) {
                        bl3 = true;
                    }
                }
                if (bl3) {
                    stringBuffer.append('1');
                    if (n2 == n3) {
                        ++n2;
                    }
                    object = new Object[]{string2};
                    diagnosis.addDiagnostic(-742, SmartResources.get(56, object));
                }
            }
        } else if (n4 == 2816) {
            char c3 = stringBuffer.charAt(0);
            int n6 = 0;
            while (n6 < n3 && !SmartUtil.isIdentifierStart(c3, true)) {
                c3 = stringBuffer.charAt(n6);
                ++n6;
            }
            if (n6 > 0) {
                stringBuffer.delete(0, --n6);
                n3 -= n6;
                n2 = n2 > n6 ? (n2 -= n6) : 0;
                diagnosis.addDiagnostic(-743, SmartResources.get(57));
            }
            boolean bl4 = false;
            ReuseStringBuffer reuseStringBuffer = ReuseStringBuffer.getBuffer();
            reuseStringBuffer.append(c3);
            n6 = 1;
            while (n6 < stringBuffer.length()) {
                c3 = stringBuffer.charAt(n6);
                if (!SmartUtil.isIdentifierPart(c3)) {
                    if (n6 <= n2) {
                        --n2;
                    }
                    bl4 = true;
                } else {
                    reuseStringBuffer.append(c3);
                }
                ++n6;
            }
            n3 = reuseStringBuffer.length();
            if (!bl4 && n3 > 0) {
                Hashtable hashtable = (Hashtable)SmartUtil.getResource("JavaReserved");
                if (hashtable != null && hashtable.get(stringBuffer.toString()) != null) {
                    bl4 = true;
                    stringBuffer.append('1');
                    if (n2 == n3) {
                        ++n2;
                    }
                    ++n3;
                    Object[] objectArray = new Object[]{string2};
                    diagnosis.addDiagnostic(-745, SmartResources.get(59));
                }
            } else if (bl4) {
                stringBuffer.setLength(0);
                stringBuffer.append(ReuseStringBuffer.toString(reuseStringBuffer));
                n3 = stringBuffer.length();
                diagnosis.addDiagnostic(-744, SmartResources.get(58));
            }
        } else {
            System.out.println("HostIDVerifier: No host identifer validation for language " + n4);
        }
        if (diagnosis != null && diagnosis.hasError()) {
            nArray[0] = n2;
            nArray[1] = n2;
            if (bl2 || SmartManager.getFixPolicy()) {
                if (bl && stringBuffer.length() == 0) {
                    stringBuffer.append(string);
                }
                nArray[0] = 0;
                nArray[1] = stringBuffer.length();
                smartConstraints.setConstraintFlag(8, true);
            }
            return bl2;
        }
        return true;
    }
}

