/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common.smartx.support.diagnoser;

import com.ibm.db2.tools.common.smartx.event.Diagnosis;
import com.ibm.db2.tools.common.smartx.support.SmartConstraints;
import com.ibm.db2.tools.common.smartx.support.SmartManager;
import com.ibm.db2.tools.common.smartx.support.SmartResources;
import com.ibm.db2.tools.common.smartx.support.SmartUtil;
import com.ibm.db2.tools.common.smartx.support.diagnoser.DiagnoserUtil;
import com.ibm.db2.tools.common.smartx.support.diagnoser.SmartDiagnoser;
import com.ibm.db2.tools.common.support.ReuseStringBuffer;

public class GenericNameDiagnoser
implements SmartDiagnoser {
    public static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected static GenericNameDiagnoser myself;

    public static GenericNameDiagnoser getDiagnoserInstance() {
        if (myself == null) {
            myself = new GenericNameDiagnoser();
        }
        return myself;
    }

    public boolean smartVerify(StringBuffer stringBuffer, int[] nArray, SmartConstraints smartConstraints, Diagnosis diagnosis) {
        if (smartConstraints.getConstraintFlag(8).booleanValue()) {
            smartConstraints.setConstraintFlag(8, false);
            return true;
        }
        if (smartConstraints.getConstraintFlag(7).booleanValue()) {
            diagnosis.clearDiagnoses();
        }
        String string = smartConstraints.getDefaultString();
        boolean bl = smartConstraints.getConstraintFlag(0);
        boolean bl2 = smartConstraints.getConstraintFlag(6);
        boolean bl3 = smartConstraints.getConstraintFlag(5);
        int n2 = 254;
        Integer n3 = (Integer)smartConstraints.getConstraint("MaximumLength");
        if (n3 != null) {
            n2 = n3;
        }
        int n4 = DiagnoserUtil.trimText(stringBuffer, nArray[1], smartConstraints);
        int n5 = 0;
        int n6 = stringBuffer.length();
        if (string == null || string.length() == 0) {
            string = SmartUtil.getDefaultSpecificName(true);
        }
        if (stringBuffer.length() == 0) {
            if (bl) {
                if (bl3 || SmartManager.getFixPolicy()) {
                    stringBuffer.append(string);
                }
                diagnosis.addDiagnostic(-720, SmartResources.get(35));
            }
        } else {
            boolean bl4 = false;
            ReuseStringBuffer reuseStringBuffer = ReuseStringBuffer.getBuffer();
            int n7 = 0;
            while (n7 < n6) {
                char c2 = stringBuffer.charAt(n7);
                if (!Character.isLetterOrDigit(c2) && c2 != '_') {
                    bl4 = true;
                    if (n7 <= n4) {
                        ++n5;
                    }
                } else {
                    reuseStringBuffer.append(c2);
                }
                ++n7;
            }
            if (bl4) {
                n4 -= n5;
                stringBuffer.setLength(0);
                stringBuffer.append(reuseStringBuffer.toString());
                n6 = stringBuffer.length();
                diagnosis.addDiagnostic(-752, SmartResources.get(66));
            }
            if (n6 > 0 && n6 > n2) {
                if (n4 == n6 - n2 - 1) {
                    stringBuffer.delete(0, n4 + 1);
                    n4 = 0;
                } else if (n4 >= n6) {
                    stringBuffer.setLength(n2);
                    n4 = n2;
                } else if (n4 - (n6 - n2) > -1) {
                    stringBuffer.delete(n4 - (n6 - n2), n4);
                    n4 -= n6 - n2;
                } else {
                    stringBuffer.setLength(n2);
                    n4 = n2;
                }
                Object[] objectArray = new Object[]{new Integer(n2)};
                diagnosis.addDiagnostic(-750, SmartResources.get(64, objectArray));
            }
            ReuseStringBuffer.freeBuffer(reuseStringBuffer);
        }
        if (diagnosis != null && diagnosis.hasError()) {
            nArray[0] = n4;
            nArray[1] = n4;
            if (bl3 || SmartManager.getFixPolicy()) {
                if (bl && stringBuffer.length() == 0) {
                    stringBuffer.append(string);
                }
                nArray[0] = 0;
                nArray[1] = stringBuffer.length();
                smartConstraints.setConstraintFlag(8, true);
            }
            return bl3;
        }
        return true;
    }
}

