/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common.smartx.support.diagnoser;

import com.ibm.db2.tools.common.smartx.event.Diagnosis;
import com.ibm.db2.tools.common.smartx.support.SmartConstraints;
import com.ibm.db2.tools.common.smartx.support.SmartManager;
import com.ibm.db2.tools.common.smartx.support.SmartResources;
import com.ibm.db2.tools.common.smartx.support.diagnoser.DiagnoserUtil;
import com.ibm.db2.tools.common.smartx.support.diagnoser.SmartDiagnoser;
import com.ibm.db2.tools.common.support.AssistManager;
import com.ibm.db2.tools.common.support.ReuseStringBuffer;
import java.io.File;
import java.io.IOException;

public class FilenameDiagnoser
implements SmartDiagnoser {
    public static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected static FilenameDiagnoser myself;
    protected String ALPHAS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
    protected char slash = System.getProperty("file.separator").charAt(0);
    protected char wonyen = (char)(AssistManager.getPreferredLanguage().getLanguage().equals("ko") ? 63 : (AssistManager.getPreferredLanguage().getLanguage().equals("ja") ? 165 : 65));
    protected final String WINDOWS_CHARS = "~!`@#$%^&()_-=[]{}:;'+,.\"'";
    protected final String UNIX_CHARS = "~!@#$%^_-=[]{}:'+,.";

    public static FilenameDiagnoser getDiagnoserInstance() {
        if (myself == null) {
            myself = new FilenameDiagnoser();
        }
        return myself;
    }

    protected int countChar(StringBuffer stringBuffer, char c2) {
        int n2 = 0;
        int n3 = DiagnoserUtil.indexOf(stringBuffer, c2);
        while (n3 > -1) {
            ++n2;
            DiagnoserUtil.indexOf(stringBuffer, c2, n3 + 1);
        }
        return n2;
    }

    protected boolean isValidCharacter(StringBuffer stringBuffer, int n2) {
        char c2 = stringBuffer.charAt(n2);
        if (Character.isSpaceChar(c2) || Character.isLetterOrDigit(c2) || c2 == this.slash || c2 == this.wonyen) {
            return true;
        }
        if (System.getProperty("os.name").startsWith("Windows")) {
            if ("~!`@#$%^&()_-=[]{}:;'+,.\"'".indexOf(c2) > -1) {
                return c2 != ':' || DiagnoserUtil.indexOf(stringBuffer, ':') >= n2;
            }
        } else {
            int n3;
            if ("~!@#$%^_-=[]{}:'+,.".indexOf(c2) > -1) {
                return true;
            }
            if ((c2 == '\'' || c2 == '\"' || c2 == '`') && (n3 = this.countChar(stringBuffer, c2)) > 0 && n3 % 2 == 0) {
                return true;
            }
        }
        return false;
    }

    public boolean smartVerify(StringBuffer stringBuffer, int[] nArray, SmartConstraints smartConstraints, Diagnosis diagnosis) {
        if (smartConstraints.getConstraintFlag(8).booleanValue()) {
            smartConstraints.setConstraintFlag(8, false);
            return true;
        }
        if (smartConstraints.getConstraintFlag(7).booleanValue()) {
            diagnosis.clearDiagnoses();
        }
        String string = smartConstraints.getDefaultString();
        int n2 = (Integer)smartConstraints.getConstraint("Type");
        StringBuffer stringBuffer2 = (StringBuffer)smartConstraints.getConstraint("MateText");
        int[] nArray2 = (int[])smartConstraints.getConstraint("MateMarkDot");
        SmartConstraints smartConstraints2 = (SmartConstraints)smartConstraints.getConstraint("MateConstraints");
        Diagnosis diagnosis2 = (Diagnosis)smartConstraints.getConstraint("MateDiagnosis");
        boolean bl = smartConstraints.getConstraintFlag(0);
        boolean bl2 = smartConstraints.getConstraintFlag(6);
        boolean bl3 = smartConstraints.getConstraintFlag(5);
        int n3 = DiagnoserUtil.trimText(stringBuffer, nArray[1], smartConstraints);
        int n4 = stringBuffer.length();
        int n5 = 0;
        int n6 = 259;
        if (string == null || string.length() == 0) {
            string = "TEMP";
        }
        if (stringBuffer.length() == 0) {
            if (bl) {
                if (bl3 || SmartManager.getFixPolicy()) {
                    stringBuffer.append(string);
                }
                switch (n2) {
                    case 768: {
                        diagnosis.addDiagnostic(-850, SmartResources.get(130));
                        break;
                    }
                    case 1024: {
                        diagnosis.addDiagnostic(-851, SmartResources.get(131));
                        break;
                    }
                    case 1280: 
                    case 1792: {
                        diagnosis.addDiagnostic(-852, SmartResources.get(132));
                        break;
                    }
                    case 1536: {
                        diagnosis.addDiagnostic(-853, SmartResources.get(133));
                        break;
                    }
                    case 2048: {
                        diagnosis.addDiagnostic(-861, SmartResources.get(138));
                    }
                }
            }
        } else {
            boolean bl4 = false;
            ReuseStringBuffer reuseStringBuffer = ReuseStringBuffer.getBuffer();
            char c2 = System.getProperty("file.separator").charAt(0);
            String string2 = AssistManager.getPreferredLanguage().getLanguage();
            char c3 = c2;
            int n7 = 126;
            if (string2.equals("ko")) {
                c3 = '?';
            } else if (string2.equals("ja")) {
                c3 = '\u00a5';
            }
            int n8 = DiagnoserUtil.indexOf(stringBuffer, ':');
            if (n8 != -1) {
                Object[] objectArray;
                String string3 = stringBuffer.substring(0, n8);
                if (n8 != 1) {
                    objectArray = new Object[]{string3};
                    diagnosis.addDiagnostic(-865, SmartResources.get(142, objectArray));
                    stringBuffer.replace(0, n8, "C");
                    n4 = stringBuffer.length();
                } else if (this.ALPHAS.indexOf(string3) == -1) {
                    objectArray = new Object[]{string3};
                    diagnosis.addDiagnostic(-865, SmartResources.get(142, objectArray));
                    stringBuffer.replace(0, n8, "C");
                    n4 = stringBuffer.length();
                }
            }
            int n9 = 0;
            while (n9 < n4) {
                char c4 = stringBuffer.charAt(n9);
                if (!this.isValidCharacter(stringBuffer, n9)) {
                    bl4 = true;
                    if (n9 <= n3) {
                        ++n5;
                    }
                } else if (n2 == 2048) {
                    if (c4 == c2 || c4 == c3 || c4 == ':' || c4 == '*' || c4 == '?' || c4 == '<' || c4 == '>' || c4 == '|') {
                        bl4 = true;
                        if (n9 <= n3) {
                            ++n5;
                        }
                    }
                } else {
                    reuseStringBuffer.append(c4);
                }
                ++n9;
            }
            if (bl4) {
                n3 -= n5;
                stringBuffer.setLength(0);
                stringBuffer.append(reuseStringBuffer.toString());
                n4 = stringBuffer.length();
                diagnosis.addDiagnostic(-860, SmartResources.get(137));
            }
            if (!bl4 && !bl2) {
                int n10;
                int n11;
                String string4;
                boolean bl5;
                int n12 = n2;
                File file = null;
                if (n2 == 2048 && stringBuffer2 != null && stringBuffer2.length() > 0) {
                    bl5 = this.smartVerify(stringBuffer2, nArray2, smartConstraints2, diagnosis2);
                    if (bl5) {
                        file = new File(stringBuffer2.toString(), stringBuffer.toString());
                        n12 += 1024;
                    } else {
                        file = new File(stringBuffer.toString());
                    }
                } else if (n2 == 1024 && stringBuffer2 != null && stringBuffer2.length() > 0) {
                    bl5 = this.smartVerify(stringBuffer2, nArray2, smartConstraints2, diagnosis2);
                    if (bl5) {
                        file = new File(stringBuffer.toString(), stringBuffer2.toString());
                        n12 += 1024;
                    } else {
                        file = new File(stringBuffer.toString());
                    }
                } else {
                    file = new File(stringBuffer.toString());
                }
                String string5 = null;
                try {
                    string5 = file.getCanonicalPath();
                }
                catch (IOException iOException) {
                    string5 = null;
                    bl4 = true;
                    string4 = file.getAbsolutePath();
                    n11 = string4.length();
                    if (n11 > n6) {
                        if (n3 == n11 - n6 - 1) {
                            stringBuffer.delete(0, n3 + 1);
                            n3 = 0;
                            n4 = stringBuffer.length();
                        } else if (n3 >= n4) {
                            stringBuffer.setLength(n6);
                            n3 = n6;
                            n4 = stringBuffer.length();
                        } else if (n3 - (n4 - n6) > -1) {
                            stringBuffer.delete(n3 - (n11 - n6), n3);
                            n3 -= n11 - n6;
                            n4 = stringBuffer.length();
                        } else {
                            stringBuffer.setLength(n6);
                            n3 = n6;
                            n4 = stringBuffer.length();
                        }
                        Object[] objectArray = new Object[]{new Integer(n6)};
                        diagnosis.addDiagnostic(-750, SmartResources.get(64, objectArray));
                    }
                    if (n12 == 1024) {
                        diagnosis.addDiagnostic(-862, SmartResources.get(139));
                    }
                    if (n12 == 2048) {
                        diagnosis.addDiagnostic(-863, SmartResources.get(140));
                    }
                    diagnosis.addDiagnostic(-864, SmartResources.get(141));
                }
                if (!bl4 && string5 == null) {
                    switch (n2) {
                        case 768: 
                        case 1536: 
                        case 1792: {
                            diagnosis.addDiagnostic(-850, SmartResources.get(130));
                            break;
                        }
                        case 1024: 
                        case 1280: {
                            diagnosis.addDiagnostic(-851, SmartResources.get(131));
                            break;
                        }
                        case 2048: {
                            diagnosis.addDiagnostic(-861, SmartResources.get(138));
                        }
                    }
                } else if (!bl4 && (n10 = string5.length()) > 0) {
                    file = new File(string5);
                    if (n2 == 1024) {
                        if (!file.isDirectory()) {
                            if (file.isFile()) {
                                diagnosis.addDiagnostic(-851, SmartResources.get(131));
                            } else if (!FilenameDiagnoser.hasWritableParent(file)) {
                                diagnosis.addDiagnostic(-854, SmartResources.get(134));
                                string4 = stringBuffer.toString();
                                stringBuffer.setLength(0);
                                stringBuffer.append(System.getProperty("user.home"));
                                n11 = string4.indexOf(File.separatorChar);
                                if (n11 > -1) {
                                    stringBuffer.append(string4.substring(n11));
                                }
                                n4 = stringBuffer.length();
                            }
                        }
                    } else if (n2 == 768) {
                        if (file.isDirectory()) {
                            diagnosis.addDiagnostic(-850, SmartResources.get(130));
                        } else if (!file.isFile()) {
                            if (!FilenameDiagnoser.hasWritableParent(file)) {
                                diagnosis.addDiagnostic(-856, SmartResources.get(136));
                                string4 = stringBuffer.toString();
                                stringBuffer.setLength(0);
                                stringBuffer.append(System.getProperty("user.home"));
                                n11 = string4.indexOf(File.separatorChar);
                                if (n11 > -1) {
                                    stringBuffer.append(string4.substring(n11));
                                }
                                n4 = stringBuffer.length();
                            }
                        } else if (!file.canWrite()) {
                            diagnosis.addDiagnostic(-856, SmartResources.get(136));
                        }
                    } else if (n2 == 1280) {
                        if (file.isDirectory()) {
                            diagnosis.addDiagnostic(-850, SmartResources.get(130));
                        } else if (file.isFile()) {
                            if (!file.canWrite()) {
                                diagnosis.addDiagnostic(-856, SmartResources.get(136));
                            }
                        } else {
                            string4 = file.getParent();
                            if (string4 != null && !(file = new File(string4)).exists()) {
                                diagnosis.addDiagnostic(-852, SmartResources.get(132));
                            }
                        }
                    } else if (n2 == 1536) {
                        if (file.isDirectory()) {
                            diagnosis.addDiagnostic(-850, SmartResources.get(130));
                        } else if (!file.isFile()) {
                            diagnosis.addDiagnostic(-853, SmartResources.get(133));
                        } else if (!file.canRead()) {
                            diagnosis.addDiagnostic(-855, SmartResources.get(135));
                        }
                    } else if (n2 == 1792) {
                        if (file.isDirectory()) {
                            diagnosis.addDiagnostic(-850, SmartResources.get(130));
                        } else if (!file.exists()) {
                            if (!FilenameDiagnoser.hasWritableParent(file)) {
                                diagnosis.addDiagnostic(-856, SmartResources.get(136));
                                stringBuffer.setLength(0);
                                stringBuffer.append(System.getProperty("user.home"));
                                int n13 = string5.indexOf(File.separatorChar);
                                if (n13 > -1) {
                                    stringBuffer.append(string5.substring(n13));
                                }
                                n4 = stringBuffer.length();
                            }
                        } else if (!file.canWrite()) {
                            diagnosis.addDiagnostic(-856, SmartResources.get(136));
                        }
                    }
                }
            }
            ReuseStringBuffer.freeBuffer(reuseStringBuffer);
        }
        if (diagnosis != null && diagnosis.hasError()) {
            nArray[0] = n3;
            nArray[1] = n3;
            if (bl3 || SmartManager.getFixPolicy()) {
                if (bl && stringBuffer.length() == 0) {
                    stringBuffer.append(string);
                }
                nArray[0] = 0;
                nArray[1] = stringBuffer.length();
                smartConstraints.setConstraintFlag(8, true);
            }
            return bl3;
        }
        return true;
    }

    public static boolean hasWritableParent(File file) {
        File file2 = file;
        String string = file2.getParent();
        if (string != null) {
            file2 = new File(string);
            while (string != null && !file2.canWrite()) {
                string = file2.getParent();
                if (string == null) continue;
                file2 = new File(string);
            }
            return file2.canWrite();
        }
        return false;
    }
}

