/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common.smartx.support.diagnoser;

import com.ibm.db2.tools.common.smartx.event.Diagnosis;
import com.ibm.db2.tools.common.smartx.support.SmartConstraints;
import com.ibm.db2.tools.common.smartx.support.SmartManager;
import com.ibm.db2.tools.common.smartx.support.SmartResources;
import com.ibm.db2.tools.common.smartx.support.diagnoser.DiagnoserUtil;
import com.ibm.db2.tools.common.smartx.support.diagnoser.SmartDateField;
import com.ibm.db2.tools.common.smartx.support.diagnoser.SmartDateFormat;
import com.ibm.db2.tools.common.smartx.support.diagnoser.SmartDiagnoser;
import com.ibm.db2.tools.common.support.ReuseStringBuffer;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.StringTokenizer;

public class DateTimeDiagnoser
implements SmartDiagnoser {
    public static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected Diagnosis diagnosis;
    protected SmartDateFormat df;
    protected ArrayList fields;
    protected BitSet okfields;
    protected Object[][] formatFix;
    protected static DateTimeDiagnoser myself;

    public static DateTimeDiagnoser getDiagnoserInstance() {
        if (myself == null) {
            myself = new DateTimeDiagnoser();
        }
        return myself;
    }

    public boolean smartVerify(StringBuffer stringBuffer, int[] nArray, SmartConstraints smartConstraints, Diagnosis diagnosis) {
        if (smartConstraints.getConstraintFlag(8).booleanValue()) {
            smartConstraints.setConstraintFlag(8, false);
            return true;
        }
        this.diagnosis = diagnosis;
        if (smartConstraints.getConstraintFlag(7).booleanValue()) {
            this.diagnosis.clearDiagnoses();
        }
        int n2 = smartConstraints.getType();
        String string = smartConstraints.getDefaultString();
        boolean bl = smartConstraints.getConstraintFlag(0);
        boolean bl2 = smartConstraints.getConstraintFlag(6);
        boolean bl3 = smartConstraints.getConstraintFlag(5);
        DiagnoserUtil.trimText(stringBuffer, nArray[1], smartConstraints);
        String string2 = (String)smartConstraints.getConstraint("Format");
        int n3 = -1;
        String[] stringArray = null;
        if (string2 == null || string2.length() == 0) {
            string2 = this.getDefaultFormats();
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ";", false);
        int n4 = stringTokenizer.countTokens();
        stringArray = new String[n4];
        int[] nArray2 = new int[n4];
        int n5 = 0;
        while (n5 < n4) {
            stringArray[n5] = stringTokenizer.nextToken().trim();
            nArray2[n5] = 0;
            ++n5;
        }
        this.df = new SmartDateFormat(stringArray[0]);
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        if (string == null || string.length() == 0) {
            this.df.setCalendar(gregorianCalendar);
            this.initFixes(this.df);
        } else {
            try {
                this.df.parse(string);
                this.initFixes(this.df);
            }
            catch (ParseException parseException) {
                this.df.setCalendar(gregorianCalendar);
                this.initFixes(this.df);
                this.diagnosis.addDiagnostic(-603, SmartResources.get(2, new Object[]{string, new Integer(parseException.getErrorOffset())}));
            }
        }
        if (stringBuffer.length() == 0) {
            if (bl) {
                if (bl3 || SmartManager.getFixPolicy()) {
                    this.fixCalendar(this.df);
                    stringBuffer.setLength(0);
                    stringBuffer.append(this.df.format(this.df.getCalendar().getTime()));
                }
                this.diagnosis.addDiagnostic(-760, SmartResources.get(73));
                if (n2 == 40960) {
                    if (stringArray.length > 1) {
                        this.diagnosis.addDiagnostic(-975, SmartResources.get(161, new Object[]{this.nlFormat(string2)}));
                    } else {
                        this.diagnosis.addDiagnostic(-976, SmartResources.get(13, new Object[]{this.nlFormat(string2)}));
                    }
                } else if (stringArray.length > 1) {
                    this.diagnosis.addDiagnostic(-990, SmartResources.get(163, new Object[]{this.nlFormat(string2)}));
                } else {
                    this.diagnosis.addDiagnostic(-977, SmartResources.get(14, new Object[]{this.nlFormat(string2)}));
                }
            }
        } else {
            int n6;
            int n7;
            SmartDateField smartDateField;
            n3 = this.evaluateFormats(this.df, stringArray, nArray2, stringBuffer.toString());
            if (n3 < 0 || this.fields == null) {
                return false;
            }
            char[] cArray = this.df.getCurrentPatternChars();
            int[] nArray3 = this.df.getCurrentPatternCounts();
            if (nArray2[n3] > 0) {
                int n8 = this.fields.size();
                int n9 = 0;
                while (n9 < n8) {
                    smartDateField = (SmartDateField)this.fields.get(n9);
                    n7 = smartDateField.getSeparatorErrorCount();
                    if (n7 > 0) {
                        int n10 = 0;
                        while (n10 < n7) {
                            switch (smartDateField.getSeparatorErrorCode(n10)) {
                                case -601: {
                                    this.diagnosis.addDiagnostic(-601, SmartResources.get(0, new Object[]{smartDateField.getSeparatorErrorExpected(n10), smartDateField.getSeparatorErrorFound(n10)}));
                                    break;
                                }
                                case -602: {
                                    this.diagnosis.addDiagnostic(-602, SmartResources.get(1, new Object[]{smartDateField.getSeparatorErrorExpected(n10), smartDateField.getSeparatorErrorFound(n10)}));
                                    break;
                                }
                                case -604: {
                                    this.diagnosis.addDiagnostic(-604, SmartResources.get(3, new Object[]{smartDateField.getSeparatorErrorFound(n10)}));
                                }
                            }
                            ++n10;
                        }
                    }
                    if ((n6 = smartDateField.getCode()) != 0 && n6 < 0) {
                        switch (n6) {
                            case -605: {
                                this.diagnosis.addDiagnostic(-605, SmartResources.get(4, new Object[]{this.nlField(cArray[n9], nArray3[n9]), smartDateField.getInput()}));
                                break;
                            }
                            case -606: {
                                this.diagnosis.addDiagnostic(-606, SmartResources.get(5, new Object[]{this.nlField(cArray[n9], nArray3[n9]), smartDateField.getInput()}));
                                break;
                            }
                            case -612: {
                                this.diagnosis.addDiagnostic(-612, SmartResources.get(11, new Object[]{this.nlField(cArray[n9], nArray3[n9])}));
                                break;
                            }
                            case -613: {
                                this.diagnosis.addDiagnostic(-613, SmartResources.get(12, new Object[]{this.nlField(cArray[n9], nArray3[n9])}));
                            }
                        }
                    }
                    ++n9;
                }
            }
            n6 = this.fields.size();
            n7 = 0;
            while (n7 < n6) {
                smartDateField = (SmartDateField)this.fields.get(n7);
                this.checkSemantics(bl2, cArray[n7], nArray3[n7], smartDateField);
                ++n7;
            }
            if (this.diagnosis.hasError()) {
                if (n2 == 40960) {
                    if (stringArray.length > 1) {
                        this.diagnosis.addDiagnostic(-975, SmartResources.get(161, new Object[]{this.nlFormat(string2)}));
                    } else {
                        this.diagnosis.addDiagnostic(-976, SmartResources.get(13, new Object[]{this.nlFormat(string2)}));
                    }
                } else if (stringArray.length > 1) {
                    this.diagnosis.addDiagnostic(-990, SmartResources.get(163, new Object[]{this.nlFormat(string2)}));
                } else {
                    this.diagnosis.addDiagnostic(-977, SmartResources.get(14, new Object[]{this.nlFormat(string2)}));
                }
            }
        }
        if (this.diagnosis != null && this.diagnosis.hasError()) {
            nArray[0] = stringBuffer.length();
            nArray[1] = stringBuffer.length();
            if (bl3 || SmartManager.getFixPolicy()) {
                this.fixCalendar(this.df);
                stringBuffer.setLength(0);
                stringBuffer.append(this.df.format(this.df.getCalendar().getTime()));
                smartConstraints.setConstraintFlag(8, true);
                nArray[0] = 0;
                nArray[1] = stringBuffer.length();
            }
            return bl3;
        }
        return true;
    }

    protected int evaluateFormats(SmartDateFormat smartDateFormat, String[] stringArray, int[] nArray, String string) {
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        int n5 = stringArray.length;
        while (n3 <= n5) {
            if (n2 > -1 && nArray[n2] == 0) {
                return n2;
            }
            if (++n3 >= n5) {
                smartDateFormat.setPattern(stringArray[n4]);
                return n4;
            }
            n2 = n3;
            smartDateFormat.setPattern(stringArray[n2]);
            char[] cArray = smartDateFormat.getCurrentPatternChars();
            int[] nArray2 = smartDateFormat.getCurrentPatternCounts();
            try {
                ArrayList arrayList = smartDateFormat.parseFields(string);
                nArray[n2] = this.evaluateFields(smartDateFormat, cArray, nArray2, arrayList, string);
                if (n4 < 0) {
                    n4 = n2;
                    this.fields = arrayList;
                    continue;
                }
                if (nArray[n2] >= nArray[n4]) continue;
                n4 = n2;
                this.fields = arrayList;
            }
            catch (ParseException parseException) {
                System.out.println("Programming error: " + parseException.getMessage());
                return -1;
            }
        }
        return n2;
    }

    protected int evaluateFields(SmartDateFormat smartDateFormat, char[] cArray, int[] nArray, ArrayList arrayList, String string) {
        int n2 = 0;
        int n3 = arrayList.size();
        int n4 = 0;
        while (n4 < n3) {
            int n5;
            SmartDateField smartDateField = (SmartDateField)arrayList.get(n4);
            int n6 = smartDateField.getCode();
            if (n6 != 0) {
                if (n6 < 0) {
                    switch (n6) {
                        case -605: {
                            n2 += 7;
                            break;
                        }
                        case -606: {
                            n2 += 7;
                            break;
                        }
                        case -612: {
                            n2 += 3;
                            break;
                        }
                        case -613: {
                            n2 += 3;
                            break;
                        }
                        default: {
                            n2 += 11;
                            break;
                        }
                    }
                } else {
                    String string2 = smartDateField.getInput();
                    int n7 = string2.length();
                    if (string2 == null) {
                        n2 += 6;
                    } else if (SmartDateFormat.isNumericField("GyMdkHmsSEDFwWahKz".indexOf(cArray[n4]), nArray[n4]) && n7 > nArray[n4]) {
                        n2 += 4;
                    } else if ((cArray[n4] == 'h' || cArray[n4] == 'm') && n7 < nArray[n4]) {
                        n2 += 3;
                    } else if (cArray[n4] == 'y' && n7 < nArray[n4]) {
                        n2 += 2;
                    }
                }
            }
            if ((n5 = smartDateField.getSeparatorErrorCount()) > 0) {
                int n8 = 0;
                while (n8 < n5) {
                    switch (smartDateField.getSeparatorErrorCode(n8)) {
                        case -601: {
                            n2 += 3;
                            break;
                        }
                        case -602: {
                            n2 += 5;
                            break;
                        }
                        case -604: {
                            n2 += smartDateField.getSeparatorErrorFound(n8).length();
                        }
                    }
                    ++n8;
                }
            }
            ++n4;
        }
        return n2;
    }

    protected void checkSemantics(boolean bl, char c2, int n2, SmartDateField smartDateField) {
        int n3;
        if (smartDateField.getCode() != 0) {
            return;
        }
        String string = smartDateField.getInput();
        int n4 = smartDateField.getNumeric();
        int n5 = "GyMdkHmsSEDFwWahKz".indexOf(c2);
        this.okfields.set(n5);
        switch (n5) {
            case 0: {
                this.formatFix[n5][0] = string;
                this.formatFix[n5][1] = new Integer(n4);
                break;
            }
            case 1: {
                try {
                    if (string != null && string.length() > n2) {
                        this.diagnosis.addDiagnostic(-779, SmartResources.get(92, new Object[]{new Integer(n2), string}));
                        string = this.trimNum(string, string.length(), n2);
                        this.formatFix[n5][1] = new Integer(string);
                        this.formatFix[n5][0] = string;
                        n4 = (Integer)this.formatFix[n5][1];
                    } else {
                        this.formatFix[n5][1] = new Integer(string);
                        this.formatFix[n5][0] = string;
                        n4 = (Integer)this.formatFix[n5][1];
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    n4 = (Integer)this.formatFix[n5][1];
                }
                if (n4 >= 1) break;
                this.diagnosis.addDiagnostic(-755, SmartResources.get(68, new Object[]{string}));
                break;
            }
            case 2: {
                if (n2 <= 2) {
                    if (string != null && string.length() > n2) {
                        this.diagnosis.addDiagnostic(-780, SmartResources.get(93, new Object[]{new Integer(n2), string}));
                        string = this.trimNum(string, string.length(), n2);
                        try {
                            n4 = Integer.parseInt(string) - 1;
                            this.formatFix[n5][1] = new Integer(n4);
                            this.formatFix[n5][0] = string;
                        }
                        catch (NumberFormatException numberFormatException) {
                            n4 = (Integer)this.formatFix[n5][1];
                        }
                    } else {
                        n4 = Integer.parseInt(string) - 1;
                        this.formatFix[n5][1] = new Integer(n4);
                        this.formatFix[n5][0] = string;
                    }
                    if (!bl && n4 < 0) {
                        this.diagnosis.addDiagnostic(-776, SmartResources.get(89, new Object[]{string}));
                        break;
                    }
                    if (n4 <= 11) break;
                    this.diagnosis.addDiagnostic(-776, SmartResources.get(89, new Object[]{string}));
                    this.formatFix[n5][0] = "12";
                    this.formatFix[n5][1] = new Integer(11);
                    break;
                }
                this.formatFix[n5][0] = smartDateField.getTranslations()[n4];
                this.formatFix[n5][1] = new Integer(n4);
                break;
            }
            case 3: {
                this.formatFix[n5][0] = string;
                this.formatFix[n5][1] = new Integer(n4);
                break;
            }
            case 4: {
                if (!bl && string != null && string.length() < n2) {
                    this.diagnosis.addDiagnostic(-608, SmartResources.get(7, new Object[]{this.nlFormat(String.valueOf(c2)), new Integer(n2), string}));
                    string = this.padNum(string, string.length(), n2);
                } else if (string != null && string.length() > n2) {
                    this.diagnosis.addDiagnostic(-608, SmartResources.get(7, new Object[]{this.nlFormat(String.valueOf(c2)), new Integer(n2), string}));
                    string = this.trimNum(string, string.length(), n2);
                    this.formatFix[n5][1] = new Integer((String)this.formatFix[n5][0]);
                    n4 = (Integer)this.formatFix[n5][1];
                }
                if (n4 < 1) {
                    this.diagnosis.addDiagnostic(-610, SmartResources.get(9, new Object[]{this.nlFormat(String.valueOf(c2)), new Integer(1), string}));
                    string = "1";
                    this.formatFix[n5][1] = new Integer(1);
                } else if (n4 > 12) {
                    this.diagnosis.addDiagnostic(-611, SmartResources.get(10, new Object[]{this.nlFormat(String.valueOf(c2)), new Integer(12), string}));
                    string = "12";
                    this.formatFix[n5][1] = new Integer(12);
                }
                this.formatFix[n5][0] = string;
                break;
            }
            case 9: {
                this.formatFix[n5][0] = string;
                this.formatFix[n5][1] = new Integer(n4);
                break;
            }
            case 14: {
                this.formatFix[n5][0] = string;
                this.formatFix[n5][1] = new Integer(n4);
                break;
            }
            case 16: {
                this.formatFix[n5][0] = string;
                this.formatFix[n5][1] = new Integer(n4);
                break;
            }
            case 15: {
                if (!bl && string != null && string.length() < n2) {
                    this.diagnosis.addDiagnostic(-608, SmartResources.get(7, new Object[]{this.nlFormat(String.valueOf(c2)), new Integer(n2), string}));
                    this.formatFix[n5][0] = this.padNum(string, string.length(), n2);
                } else if (string != null && string.length() > n2) {
                    this.diagnosis.addDiagnostic(-608, SmartResources.get(7, new Object[]{this.nlFormat(String.valueOf(c2)), new Integer(n2), string}));
                    this.formatFix[n5][0] = this.trimNum(string, string.length(), n2);
                    this.formatFix[n5][1] = new Integer((String)this.formatFix[n5][0]);
                    n4 = (Integer)this.formatFix[n5][1];
                }
                if (n4 < 0) {
                    this.diagnosis.addDiagnostic(-610, SmartResources.get(9, new Object[]{this.nlFormat(String.valueOf(c2)), new Integer(0), string}));
                    string = n2 == 1 ? "0" : "00";
                    this.formatFix[n5][1] = new Integer(0);
                } else if (n4 > 12) {
                    this.diagnosis.addDiagnostic(-786, SmartResources.get(99, new Object[]{"12", string}));
                    string = "12";
                    this.formatFix[n5][1] = new Integer(12);
                }
                this.formatFix[n5][0] = string;
                break;
            }
            case 5: {
                if (string != null && string.length() < n2) {
                    string = this.padNum(string, string.length(), n2);
                } else if (string != null && string.length() > n2) {
                    this.diagnosis.addDiagnostic(-782, SmartResources.get(95, new Object[]{string}));
                    string = this.trimNum(string, string.length(), n2);
                    this.formatFix[n5][1] = new Integer(string);
                }
                if (n4 < 0) {
                    this.diagnosis.addDiagnostic(-610, SmartResources.get(9, new Object[]{this.nlFormat(String.valueOf(c2)), new Integer(0), string}));
                    string = n2 == 1 ? "0" : "00";
                    this.formatFix[n5][1] = new Integer(0);
                } else if (n4 > 24) {
                    this.diagnosis.addDiagnostic(-786, SmartResources.get(99, new Object[]{"24", string}));
                    string = "23";
                    this.formatFix[n5][1] = new Integer(23);
                }
                this.formatFix[n5][0] = string;
                break;
            }
            case 6: {
                if (!bl && string != null && string.length() < n2) {
                    this.diagnosis.addDiagnostic(-608, SmartResources.get(7, new Object[]{this.nlFormat(String.valueOf(c2)), new Integer(n2), string}));
                    string = this.padNum(string, string.length(), n2);
                } else if (string != null && string.length() > n2) {
                    this.diagnosis.addDiagnostic(-608, SmartResources.get(7, new Object[]{this.nlFormat(String.valueOf(c2)), new Integer(n2), string}));
                    string = this.trimNum(string, string.length(), n2);
                    this.formatFix[n5][1] = new Integer(string);
                    n4 = (Integer)this.formatFix[n5][1];
                }
                if (n4 > 59) {
                    this.diagnosis.addDiagnostic(-787, SmartResources.get(100, new Object[]{"", new Integer(n4)}));
                    string = "59";
                    this.formatFix[n5][1] = new Integer(59);
                }
                this.formatFix[n5][0] = string;
                break;
            }
            case 7: {
                if (string != null && string.length() > n2) {
                    this.diagnosis.addDiagnostic(-608, SmartResources.get(7, new Object[]{this.nlFormat(String.valueOf(c2)), new Integer(n2), string}));
                    string = this.trimNum(string, string.length(), n2);
                    this.formatFix[n5][1] = new Integer(string);
                    n4 = (Integer)this.formatFix[n5][1];
                }
                if (n4 > 59) {
                    this.diagnosis.addDiagnostic(-788, SmartResources.get(101, new Object[]{"", new Integer(n4)}));
                    string = "59";
                    this.formatFix[n5][1] = new Integer(59);
                }
                this.formatFix[n5][0] = string;
                break;
            }
            case 8: {
                this.formatFix[n5][0] = string;
                this.formatFix[n5][1] = new Integer(n4);
                break;
            }
            case 10: {
                this.formatFix[n5][0] = string;
                this.formatFix[n5][1] = new Integer(n4);
                break;
            }
            case 11: {
                this.formatFix[n5][0] = string;
                this.formatFix[n5][1] = new Integer(n4);
                break;
            }
            case 12: {
                this.formatFix[n5][0] = string;
                this.formatFix[n5][1] = new Integer(n4);
                break;
            }
            case 13: {
                this.formatFix[n5][0] = string;
                this.formatFix[n5][1] = new Integer(n4);
                break;
            }
            case 17: {
                this.formatFix[n5][0] = string;
                this.formatFix[n5][1] = new Integer(n4);
                break;
            }
        }
        if (this.okfields.get(1) && this.okfields.get(2) && this.okfields.get(3) && (n3 = this.getMaxDate((Integer)this.formatFix[1][1], (Integer)this.formatFix[2][1])) < (Integer)this.formatFix[3][1]) {
            Integer n6 = new Integer(n3);
            this.diagnosis.addDiagnostic(-778, SmartResources.get(91, new Object[]{new Integer((Integer)this.formatFix[2][1] + 1), n6, (Integer)this.formatFix[3][1]}));
            this.formatFix[3][0] = n6.toString();
            this.formatFix[3][1] = n6;
        }
        if (this.okfields.get(15) && this.okfields.get(14)) {
            int n7 = (Integer)this.formatFix[15][1];
            boolean bl2 = (Integer)this.formatFix[14][1] == 0;
            int n8 = 1;
            int n9 = 12;
            int n10 = 0;
            int n11 = 0;
            if (this.okfields.get(6)) {
                n10 = (Integer)this.formatFix[6][1];
            }
            if (this.okfields.get(7)) {
                n11 = (Integer)this.formatFix[7][1];
            }
            if (bl2) {
                n9 = 11;
                if (n10 + n11 == 0) {
                    n8 = 0;
                    n9 = 12;
                }
            }
            if (n7 < n8) {
                Integer n12 = new Integer(n8);
                this.diagnosis.addDiagnostic(-610, SmartResources.get(9, new Object[]{this.nlFormat(String.valueOf(c2)), n12, string}));
                this.formatFix[n5][0] = String.valueOf(n8);
                this.formatFix[n5][1] = n12;
            } else if (n7 > n9) {
                Integer n13 = new Integer(n9);
                this.diagnosis.addDiagnostic(-611, SmartResources.get(10, new Object[]{this.nlFormat(String.valueOf(c2)), n13, string}));
                this.formatFix[n5][0] = String.valueOf(n9);
                this.formatFix[n5][1] = n13;
            }
        } else if (this.okfields.get(5)) {
            int n14 = (Integer)this.formatFix[5][1];
            int n15 = 24;
            int n16 = 0;
            int n17 = 0;
            if (this.okfields.get(6)) {
                n16 = (Integer)this.formatFix[6][1];
            }
            if (this.okfields.get(7)) {
                n17 = (Integer)this.formatFix[7][1];
            }
            if (n16 + n17 == 0) {
                n15 = 24;
            }
            if (n14 > n15) {
                Integer n18 = new Integer(n15);
                this.diagnosis.addDiagnostic(-786, SmartResources.get(99, new Object[]{n18, this.formatFix[n5][0]}));
                this.formatFix[n5][0] = String.valueOf(n15);
                this.formatFix[n5][1] = n18;
            }
        }
    }

    protected int getMaxDate(int n2, int n3) {
        int n4 = 0;
        switch (n3) {
            case 1: {
                if (((GregorianCalendar)this.df.getCalendar()).isLeapYear(n2)) {
                    n4 = 29;
                    break;
                }
                n4 = 28;
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 10: {
                n4 = 30;
                break;
            }
            default: {
                n4 = 31;
            }
        }
        return n4;
    }

    protected String nlFormat(String string) {
        return DiagnoserUtil.nlFormat(string);
    }

    protected String nlField(char c2, int n2) {
        ReuseStringBuffer reuseStringBuffer = ReuseStringBuffer.getBuffer();
        reuseStringBuffer.append(c2);
        String string = DiagnoserUtil.nlFormat(reuseStringBuffer.toString());
        reuseStringBuffer.setCharAt(0, string.charAt(0));
        while (reuseStringBuffer.length() < n2) {
            reuseStringBuffer.append(string.charAt(0));
        }
        return ReuseStringBuffer.toString(reuseStringBuffer);
    }

    protected String padNum(String string, int n2, int n3) {
        if (n2 == n3) {
            return string;
        }
        if (n2 < n3) {
            ReuseStringBuffer reuseStringBuffer = ReuseStringBuffer.getBuffer(string);
            while (reuseStringBuffer.length() < n3) {
                reuseStringBuffer.insert(0, "0");
            }
            return ReuseStringBuffer.toString(reuseStringBuffer);
        }
        return this.trimNum(string, n2, n3);
    }

    protected String trimNum(String string, int n2, int n3) {
        String string2 = string;
        int n4 = 0;
        while (n4 < n2 && n4 < n2 - n3 && string2.charAt(n4) == '0') {
            ++n4;
        }
        string2 = string2.substring(n4);
        if (n3 < n2 - n4) {
            return string2.substring(0, n3);
        }
        return string2;
    }

    protected String formatDate(String string, Calendar calendar) {
        this.df.setPattern(string);
        return this.df.format(calendar.getTime());
    }

    protected String formatDate(String string, String string2, String string3, String string4, String string5) {
        ReuseStringBuffer reuseStringBuffer = ReuseStringBuffer.getBuffer();
        if (string2.length() == 0) {
            int n2 = string.length();
            char c2 = string.charAt(0);
            int n3 = 1;
            int n4 = 1;
            while (n4 < n2) {
                char c3 = string.charAt(n4);
                if (c3 == c2) {
                    ++n3;
                } else {
                    n3 = 1;
                    c2 = c3;
                }
                ++n4;
            }
        } else {
            StringTokenizer stringTokenizer = new StringTokenizer(string, string2, true);
            while (stringTokenizer.hasMoreTokens()) {
                String string6 = stringTokenizer.nextToken();
                if (string6.charAt(0) == 'y') {
                    reuseStringBuffer.append(string3);
                    continue;
                }
                if (string6.charAt(0) == 'M') {
                    reuseStringBuffer.append(string4);
                    continue;
                }
                if (string6.charAt(0) == 'd') {
                    reuseStringBuffer.append(string5);
                    continue;
                }
                reuseStringBuffer.append(string6);
            }
        }
        return ReuseStringBuffer.toString(reuseStringBuffer);
    }

    protected void initFixes(SmartDateFormat smartDateFormat) {
        boolean bl = true;
        if (this.formatFix == null) {
            this.formatFix = new Object[17][3];
            this.okfields = new BitSet(17);
        }
        char[] cArray = smartDateFormat.getCurrentPatternChars();
        int[] nArray = smartDateFormat.getCurrentPatternCounts();
        int n2 = 0;
        while (n2 < cArray.length) {
            int n3 = "GyMdkHmsSEDFwWahKz".indexOf(cArray[n2]);
            this.formatFix[n3] = smartDateFormat.getCalendarField(n3, nArray[n2]);
            this.okfields.set(n3);
            ++n2;
        }
    }

    protected void fixCalendar(SmartDateFormat smartDateFormat) {
        smartDateFormat.getCalendar().clear();
        char[] cArray = smartDateFormat.getCurrentPatternChars();
        int n2 = 0;
        while (n2 < cArray.length) {
            int n3 = "GyMdkHmsSEDFwWahKz".indexOf(cArray[n2]);
            smartDateFormat.setCalendarField(n3, this.formatFix[n3]);
            ++n2;
        }
    }

    protected String getDefaultFormats() {
        return "yyyy-MM-dd;dd.MM.yyyy;MM/dd/yyyy";
    }
}

