/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common.smartx.support.diagnoser;

import com.ibm.db2.tools.common.smartx.event.Diagnosis;
import com.ibm.db2.tools.common.smartx.support.SmartConstraints;
import com.ibm.db2.tools.common.smartx.support.SmartManager;
import com.ibm.db2.tools.common.smartx.support.SmartResources;
import com.ibm.db2.tools.common.smartx.support.SmartUtil;
import com.ibm.db2.tools.common.smartx.support.diagnoser.DiagnoserUtil;
import com.ibm.db2.tools.common.smartx.support.diagnoser.SmartDiagnoser;
import com.ibm.db2.tools.common.support.ReuseStringBuffer;

public class DatabaseDiagnoser
implements SmartDiagnoser {
    public static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected static final String initChars = "@#$ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
    protected static final String moreChars = "_0123456789";
    protected static DatabaseDiagnoser myself;

    public static DatabaseDiagnoser getDiagnoserInstance() {
        if (myself == null) {
            myself = new DatabaseDiagnoser();
        }
        return myself;
    }

    public boolean smartVerify(StringBuffer stringBuffer, int[] nArray, SmartConstraints smartConstraints, Diagnosis diagnosis) {
        if (smartConstraints.getConstraintFlag(8).booleanValue()) {
            smartConstraints.setConstraintFlag(8, false);
            return true;
        }
        if (smartConstraints.getConstraintFlag(7).booleanValue()) {
            diagnosis.clearDiagnoses();
        }
        String string = smartConstraints.getDefaultString();
        boolean bl = smartConstraints.getConstraintFlag(0);
        boolean bl2 = smartConstraints.getConstraintFlag(6);
        boolean bl3 = smartConstraints.getConstraintFlag(5);
        int n2 = DiagnoserUtil.trimText(stringBuffer, nArray[1], smartConstraints);
        int n3 = 0;
        int n4 = stringBuffer.length();
        if (string == null || string.length() == 0) {
            string = "SAMPLE";
        }
        if (stringBuffer.length() == 0) {
            if (bl) {
                if (bl3 || SmartManager.getFixPolicy()) {
                    stringBuffer.append(string);
                }
                diagnosis.addDiagnostic(-720, SmartResources.get(35));
            }
        } else {
            Object[] objectArray;
            ReuseStringBuffer reuseStringBuffer = ReuseStringBuffer.getBuffer();
            ReuseStringBuffer reuseStringBuffer2 = ReuseStringBuffer.getBuffer();
            int n5 = 0;
            char c2 = stringBuffer.charAt(0);
            if (initChars.indexOf(c2) == -1) {
                SmartUtil.htmlMeta(reuseStringBuffer, c2);
                Object[] objectArray2 = new Object[]{reuseStringBuffer.toString()};
                diagnosis.addDiagnostic(-746, SmartResources.get(60, objectArray2));
                if (0 <= n2) {
                    ++n3;
                }
                reuseStringBuffer.setLength(0);
            } else {
                reuseStringBuffer.append(c2);
            }
            int n6 = 1;
            while (n6 < n4) {
                c2 = stringBuffer.charAt(n6);
                if (initChars.indexOf(c2) == -1 && moreChars.indexOf(c2) == -1) {
                    ++n5;
                    if (reuseStringBuffer2.length() > 0) {
                        reuseStringBuffer2.append(' ');
                    }
                    if (Character.isSpaceChar(c2)) {
                        reuseStringBuffer2.append(SmartUtil.getString(222));
                    } else {
                        SmartUtil.htmlMeta(reuseStringBuffer2, c2);
                    }
                    if (n6 <= n2) {
                        ++n3;
                    }
                } else {
                    reuseStringBuffer.append(c2);
                }
                ++n6;
            }
            if (n5 > 0) {
                n2 -= n3;
                stringBuffer.setLength(0);
                stringBuffer.append(reuseStringBuffer.toString());
                n4 = stringBuffer.length();
                objectArray = new Object[]{reuseStringBuffer2.toString()};
                if (n5 > 1) {
                    diagnosis.addDiagnostic(-748, SmartResources.get(62, objectArray));
                } else {
                    diagnosis.addDiagnostic(-747, SmartResources.get(61, objectArray));
                }
            } else if (n4 > reuseStringBuffer.length()) {
                n2 -= n3;
                stringBuffer.setLength(0);
                stringBuffer.append(reuseStringBuffer.toString());
                n4 = stringBuffer.length();
            }
            ReuseStringBuffer.freeBuffer(reuseStringBuffer);
            ReuseStringBuffer.freeBuffer(reuseStringBuffer2);
            if (n4 > 0 && n4 > 18) {
                if (n2 == n4 - 19) {
                    stringBuffer.delete(0, n2 + 1);
                    n2 = 0;
                } else if (n2 >= n4) {
                    stringBuffer.setLength(18);
                    n2 = 18;
                } else if (n2 <= n4 - 18) {
                    stringBuffer.setLength(18);
                } else {
                    stringBuffer.delete(n2 - (n4 - 18), n2);
                    n2 -= n4 - 18;
                }
                objectArray = new Object[]{new Integer(18)};
                diagnosis.addDiagnostic(-749, SmartResources.get(64, objectArray));
            }
        }
        if (diagnosis != null && diagnosis.hasError()) {
            nArray[0] = n2;
            nArray[1] = n2;
            if (bl3 || SmartManager.getFixPolicy()) {
                if (bl && stringBuffer.length() == 0) {
                    stringBuffer.setLength(0);
                    stringBuffer.append(string);
                }
                nArray[0] = 0;
                nArray[1] = stringBuffer.length();
                smartConstraints.setConstraintFlag(8, true);
            }
            return bl3;
        }
        return true;
    }
}

