/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common.smartx.support.diagnoser;

import com.ibm.db2.tools.common.smartx.event.Diagnosis;
import com.ibm.db2.tools.common.smartx.support.SmartConstraints;
import com.ibm.db2.tools.common.smartx.support.SmartManager;
import com.ibm.db2.tools.common.smartx.support.SmartResources;
import com.ibm.db2.tools.common.smartx.support.SmartUtil;
import com.ibm.db2.tools.common.smartx.support.diagnoser.DiagnoserUtil;
import com.ibm.db2.tools.common.smartx.support.diagnoser.SmartDiagnoser;
import com.ibm.db2.tools.common.support.ReuseStringBuffer;
import com.ibm.db2.tools.common.support.SQLIdentifier;

public class DB2PackageDiagnoser
implements SmartDiagnoser {
    public static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected static DB2PackageDiagnoser myself;

    public static DB2PackageDiagnoser getDiagnoserInstance() {
        if (myself == null) {
            myself = new DB2PackageDiagnoser();
        }
        return myself;
    }

    public static String getDefault(String string, int n2, String string2) {
        ReuseStringBuffer reuseStringBuffer = ReuseStringBuffer.getBuffer();
        if (string2 != null && (string2.equalsIgnoreCase("Java") || string2.equalsIgnoreCase("SQLJ"))) {
            reuseStringBuffer.append("QUSRSYS.");
        }
        if (string == null || string.length() == 0) {
            reuseStringBuffer.append("App_SJPro0");
        } else if (string.length() <= 10) {
            reuseStringBuffer.append(string);
        } else {
            int n3 = string.length() - 1;
            while (n3 > -1 && n3 < 11 && Character.isDigit(string.charAt(n3))) {
                --n3;
            }
            if (n3 > -1 && n3 < 11) {
                reuseStringBuffer.append(string.substring(0, 11 - n3)).append(string.substring(n3 + 1));
            } else {
                reuseStringBuffer.append(string);
            }
        }
        return ReuseStringBuffer.toString(reuseStringBuffer);
    }

    public boolean smartVerify(StringBuffer stringBuffer, int[] nArray, SmartConstraints smartConstraints, Diagnosis diagnosis) {
        String string;
        if (smartConstraints.getConstraintFlag(8).booleanValue()) {
            smartConstraints.setConstraintFlag(8, false);
            return true;
        }
        if (smartConstraints.getConstraintFlag(7).booleanValue()) {
            diagnosis.clearDiagnoses();
        }
        String string2 = smartConstraints.getDefaultString();
        char c2 = '\"';
        String string3 = (String)smartConstraints.getConstraint("Delimiter");
        if (string3 != null && string3.length() > 0) {
            c2 = string3.charAt(0);
        }
        if ((string = ((String)smartConstraints.getConstraint("NamingOption")).toUpperCase()) == null) {
            string = "SQL";
        }
        char c3 = '/';
        if (string.equals("SQL")) {
            c3 = '.';
        }
        boolean bl = smartConstraints.getConstraintFlag(0);
        boolean bl2 = smartConstraints.getConstraintFlag(6);
        boolean bl3 = smartConstraints.getConstraintFlag(5);
        int n2 = DiagnoserUtil.trimText(stringBuffer, nArray[1], smartConstraints);
        int n3 = 7;
        Integer n4 = (Integer)smartConstraints.getConstraint("System");
        if (n4 != null) {
            n3 = n4;
        }
        boolean bl4 = false;
        int n5 = stringBuffer.length();
        if (string2 == null || string2.length() == 0) {
            string2 = "PACKAGE";
        }
        if (stringBuffer.length() == 0) {
            if (bl) {
                if (bl3 || SmartManager.getFixPolicy()) {
                    stringBuffer.append(string2);
                }
                diagnosis.addDiagnostic(-720, SmartResources.get(35));
            }
        } else {
            int n6;
            int n7;
            Object[] objectArray;
            String[] stringArray = DiagnoserUtil.divideIdentifier(stringBuffer.toString(), c2, c3);
            String[] stringArray2 = DiagnoserUtil.divideIdentifier(string2, c2, c3);
            if (stringArray[0] != null) {
                SmartDiagnoser smartDiagnoser = null;
                objectArray = new StringBuffer(stringArray[0]);
                SmartConstraints smartConstraints2 = (SmartConstraints)smartConstraints.getConstraint("Qualifier.Constraints");
                int n8 = 0;
                if (smartConstraints2 == null) {
                    String string4 = smartConstraints.getDescription();
                    boolean bl5 = false;
                    smartConstraints2 = new SmartConstraints(string4, bl5, stringArray2[0], 0);
                    if ((n3 & 4) > 0) {
                        smartConstraints2.setMaxLengthConstraint(10);
                        if (c3 == '.') {
                            n8 = 12;
                            smartDiagnoser = DiagnoserUtil.getSharedDiagnoser(n8);
                        } else {
                            n8 = 256;
                            smartDiagnoser = DiagnoserUtil.getSharedDiagnoser(n8);
                        }
                    } else if ((n3 & 2) > 0) {
                        smartConstraints2.setMaxLengthConstraint(18);
                        n8 = 192;
                        smartDiagnoser = DiagnoserUtil.getSharedDiagnoser(n8);
                    } else {
                        smartConstraints2.setMaxLengthConstraint(30);
                        n8 = 12;
                        smartDiagnoser = DiagnoserUtil.getSharedDiagnoser(n8);
                    }
                    smartConstraints2.setType(n8);
                    smartConstraints.setQualifierConstraints(smartConstraints2);
                } else {
                    n8 = smartConstraints2.getType();
                    smartDiagnoser = DiagnoserUtil.getSharedDiagnoser(n8);
                }
                int n9 = stringArray[0].length();
                int[] nArray2 = new int[]{n9, n9};
                if (nArray[0] < n9) {
                    nArray2[0] = nArray[0];
                }
                if (nArray[1] < n9) {
                    nArray2[1] = nArray[1];
                }
                n7 = smartDiagnoser.smartVerify((StringBuffer)objectArray, nArray2, smartConstraints2, diagnosis) ? 1 : 0;
                stringArray[0] = objectArray.toString();
                n2 = nArray2[1];
            }
            if (!SQLIdentifier.isUserInputOrdinary(stringArray[1], c2, n3)) {
                int n10 = n2 - stringArray[0].length() + 1;
                int n11 = 0;
                int n12 = 0;
                ReuseStringBuffer reuseStringBuffer = ReuseStringBuffer.getBuffer();
                ReuseStringBuffer reuseStringBuffer2 = ReuseStringBuffer.getBuffer();
                n7 = stringArray[1].length();
                int n13 = 0;
                while (n13 < n7) {
                    char c4 = stringArray[1].charAt(n13);
                    if (SQLIdentifier.isOrdinaryChar(c4, n3) || SQLIdentifier.isOrdinaryDigit(c4) || c4 == '_') {
                        reuseStringBuffer2.append(c4);
                    } else {
                        if (++n12 > 1) {
                            reuseStringBuffer.append(' ');
                        }
                        if (Character.isSpaceChar(c4)) {
                            reuseStringBuffer.append(SmartResources.get(222));
                        } else {
                            SmartUtil.htmlMeta(reuseStringBuffer, c4);
                        }
                        if (n13 <= n10) {
                            ++n11;
                        }
                    }
                    ++n13;
                }
                if (n12 > 0) {
                    stringArray[1] = reuseStringBuffer2.toString();
                    n2 -= n11;
                    Object[] objectArray2 = new Object[]{reuseStringBuffer.toString()};
                    if (n12 > 1) {
                        diagnosis.addDiagnostic(-871, SmartResources.get(144, objectArray2));
                    } else {
                        diagnosis.addDiagnostic(-870, SmartResources.get(143, objectArray2));
                    }
                }
                ReuseStringBuffer.freeBuffer(reuseStringBuffer);
                ReuseStringBuffer.freeBuffer(reuseStringBuffer2);
            }
            if ((n3 & 1) > 0) {
                int n14 = stringArray[1].length();
                if (n14 > 8) {
                    objectArray = new Object[]{new Integer(8)};
                    diagnosis.addDiagnostic(-872, SmartResources.get(145, objectArray));
                }
            } else if ((n3 & 4) > 0) {
                int n15 = stringArray[1].length();
                if (n15 > 10) {
                    objectArray = new Object[]{new Integer(10)};
                    diagnosis.addDiagnostic(-872, SmartResources.get(145, objectArray));
                }
            } else if ((n3 & 2) > 0 && (n6 = stringArray[1].length()) > 8) {
                objectArray = new Object[]{new Integer(8)};
                diagnosis.addDiagnostic(-872, SmartResources.get(145, objectArray));
            }
        }
        if (diagnosis != null && diagnosis.hasError()) {
            nArray[0] = n2;
            nArray[1] = n2;
            if (bl3 || SmartManager.getFixPolicy()) {
                if (bl && stringBuffer.length() == 0) {
                    stringBuffer.setLength(0);
                    stringBuffer.append(string2);
                }
                nArray[0] = 0;
                nArray[1] = stringBuffer.length();
                smartConstraints.setConstraintFlag(8, true);
            }
            return bl3;
        }
        return true;
    }
}

