/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common.smartx.support.diagnoser;

import com.ibm.db2.tools.common.smartx.event.Diagnosis;
import com.ibm.db2.tools.common.smartx.support.SmartConstraints;
import com.ibm.db2.tools.common.smartx.support.SmartManager;
import com.ibm.db2.tools.common.smartx.support.SmartResources;
import com.ibm.db2.tools.common.smartx.support.SmartUtil;
import com.ibm.db2.tools.common.smartx.support.diagnoser.DiagnoserUtil;
import com.ibm.db2.tools.common.smartx.support.diagnoser.SmartDiagnoser;
import com.ibm.db2.tools.common.support.ReuseStringBuffer;

public class CollectionIDDiagnoser
implements SmartDiagnoser {
    public static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected static final String initChars = "@#$ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
    protected static final String moreChars = "_0123456789";
    protected static CollectionIDDiagnoser myself;

    public static CollectionIDDiagnoser getDiagnoserInstance() {
        if (myself == null) {
            myself = new CollectionIDDiagnoser();
        }
        return myself;
    }

    public boolean smartVerify(StringBuffer stringBuffer, int[] nArray, SmartConstraints smartConstraints, Diagnosis diagnosis) {
        if (smartConstraints.getConstraintFlag(8).booleanValue()) {
            smartConstraints.setConstraintFlag(8, false);
            return true;
        }
        if (smartConstraints.getConstraintFlag(7).booleanValue()) {
            diagnosis.clearDiagnoses();
        }
        int n2 = 18;
        Integer n3 = (Integer)smartConstraints.getConstraint("MaximumLength");
        if (n3 != null) {
            n2 = n3;
        }
        String string = smartConstraints.getDefaultString();
        boolean bl = smartConstraints.getConstraintFlag(0);
        boolean bl2 = smartConstraints.getConstraintFlag(6);
        boolean bl3 = smartConstraints.getConstraintFlag(5);
        int n4 = DiagnoserUtil.trimText(stringBuffer, nArray[1], smartConstraints);
        int n5 = 0;
        int n6 = stringBuffer.length();
        if (string == null || string.length() == 0) {
            string = "COLLID1";
        }
        if (stringBuffer.length() == 0) {
            if (bl) {
                if (bl3 || SmartManager.getFixPolicy()) {
                    stringBuffer.append(string);
                }
                diagnosis.addDiagnostic(-720, SmartResources.get(35));
            }
        } else {
            ReuseStringBuffer reuseStringBuffer = ReuseStringBuffer.getBuffer();
            ReuseStringBuffer reuseStringBuffer2 = ReuseStringBuffer.getBuffer();
            int n7 = 0;
            char c2 = stringBuffer.charAt(0);
            if (initChars.indexOf(c2) == -1) {
                SmartUtil.htmlMeta(reuseStringBuffer, c2);
                Object[] objectArray = new Object[]{reuseStringBuffer.toString()};
                diagnosis.addDiagnostic(-794, SmartResources.get(107, objectArray));
                if (0 <= n4) {
                    ++n5;
                }
                reuseStringBuffer.setLength(0);
            } else {
                reuseStringBuffer.append(c2);
            }
            int n8 = 1;
            while (n8 < n6) {
                c2 = stringBuffer.charAt(n8);
                if (initChars.indexOf(c2) == -1 && moreChars.indexOf(c2) == -1) {
                    ++n7;
                    if (reuseStringBuffer2.length() > 0) {
                        reuseStringBuffer2.append(' ');
                    }
                    if (Character.isSpaceChar(c2)) {
                        reuseStringBuffer2.append(SmartUtil.getString(222));
                    } else {
                        SmartUtil.htmlMeta(reuseStringBuffer2, c2);
                    }
                    if (n8 <= n4) {
                        ++n5;
                    }
                } else {
                    reuseStringBuffer.append(c2);
                }
                ++n8;
            }
            if (n7 > 0) {
                n4 -= n5;
                stringBuffer.setLength(0);
                stringBuffer.append(reuseStringBuffer.toString());
                n6 = stringBuffer.length();
                Object[] objectArray = new Object[]{reuseStringBuffer2.toString()};
                if (n7 > 1) {
                    diagnosis.addDiagnostic(-796, SmartResources.get(109, objectArray));
                } else {
                    diagnosis.addDiagnostic(-795, SmartResources.get(108, objectArray));
                }
            } else if (n6 > reuseStringBuffer.length()) {
                n4 -= n5;
                stringBuffer.setLength(0);
                stringBuffer.append(reuseStringBuffer.toString());
                n6 = stringBuffer.length();
            }
            ReuseStringBuffer.freeBuffer(reuseStringBuffer);
            ReuseStringBuffer.freeBuffer(reuseStringBuffer2);
            if (n6 > 0 && n6 > n2) {
                if (n4 == n6 - n2 - 1) {
                    stringBuffer.delete(0, n4 + 1);
                    n4 = 0;
                } else if (n4 >= n6) {
                    stringBuffer.setLength(n2);
                    n4 = n2;
                } else if (n4 <= n6 - n2) {
                    stringBuffer.setLength(n2);
                } else {
                    stringBuffer.delete(n4 - (n6 - n2), n4);
                    n4 -= n6 - n2;
                }
                if (n2 == 18) {
                    diagnosis.addDiagnostic(-797, SmartResources.get(110));
                } else {
                    diagnosis.addDiagnostic(-737, SmartResources.get(52));
                }
            }
        }
        if (diagnosis != null && diagnosis.hasError()) {
            nArray[0] = n4;
            nArray[1] = n4;
            if (bl3 || SmartManager.getFixPolicy()) {
                if (bl && stringBuffer.length() == 0) {
                    stringBuffer.setLength(0);
                    stringBuffer.append(string);
                }
                nArray[0] = 0;
                nArray[1] = stringBuffer.length();
                smartConstraints.setConstraintFlag(8, true);
            }
            return bl3;
        }
        return true;
    }
}

