/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common.smartx.support.diagnoser;

import com.ibm.db2.tools.common.smartx.event.Diagnosis;
import com.ibm.db2.tools.common.smartx.support.SmartConstraints;
import com.ibm.db2.tools.common.smartx.support.SmartManager;
import com.ibm.db2.tools.common.smartx.support.SmartResources;
import com.ibm.db2.tools.common.smartx.support.SmartUtil;
import com.ibm.db2.tools.common.smartx.support.diagnoser.DiagnoserUtil;
import com.ibm.db2.tools.common.smartx.support.diagnoser.SmartDiagnoser;
import com.ibm.db2.tools.common.support.ReuseStringBuffer;

public class BinaryStringDiagnoser
implements SmartDiagnoser {
    public static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected static final String hexchars = "0123456789ABCDEFabcdef";
    protected static BinaryStringDiagnoser myself;

    public static BinaryStringDiagnoser getDiagnoserInstance() {
        if (myself == null) {
            myself = new BinaryStringDiagnoser();
        }
        return myself;
    }

    public boolean smartVerify(StringBuffer stringBuffer, int[] nArray, SmartConstraints smartConstraints, Diagnosis diagnosis) {
        int n2;
        Object[] objectArray;
        if (smartConstraints.getConstraintFlag(8).booleanValue()) {
            smartConstraints.setConstraintFlag(8, false);
            return true;
        }
        if (smartConstraints.getConstraintFlag(7).booleanValue()) {
            diagnosis.clearDiagnoses();
        }
        String string = smartConstraints.getDefaultString();
        boolean bl = smartConstraints.getConstraintFlag(0);
        int n3 = bl ? 1 : 0;
        Object object = smartConstraints.getConstraint("MinimumLength");
        if (object != null && object instanceof Number) {
            n3 = ((Number)object).intValue() * 2;
        }
        int n4 = Integer.MAX_VALUE;
        Object object2 = smartConstraints.getConstraint("MaximumLength");
        if (object2 != null && object2 instanceof Number) {
            n4 = ((Number)object2).intValue() * 2;
        }
        boolean bl2 = smartConstraints.getConstraintFlag(6);
        boolean bl3 = smartConstraints.getConstraintFlag(5);
        int n5 = DiagnoserUtil.trimText(stringBuffer, nArray[1], smartConstraints);
        int n6 = 0;
        int n7 = stringBuffer.length();
        if (string == null) {
            objectArray = ReuseStringBuffer.getBuffer();
            n2 = 0;
            while (n2 < n3) {
                objectArray.append("00");
                ++n2;
            }
            string = ReuseStringBuffer.toString((ReuseStringBuffer)objectArray);
        }
        if (stringBuffer.length() == 0) {
            if (bl) {
                if (bl3 || SmartManager.getFixPolicy()) {
                    stringBuffer.append(string);
                }
                diagnosis.addDiagnostic(-760, SmartResources.get(73));
                if (n4 == 1) {
                    diagnosis.addDiagnostic(-759, SmartResources.get(72));
                } else {
                    objectArray = new Object[]{new Integer(n4)};
                    diagnosis.addDiagnostic(-761, SmartResources.get(74, objectArray));
                }
            }
        } else {
            Object[] objectArray2;
            objectArray = ReuseStringBuffer.getBuffer();
            n2 = 0;
            ReuseStringBuffer reuseStringBuffer = ReuseStringBuffer.getBuffer();
            int n8 = 0;
            while (n8 < n7) {
                char c2 = stringBuffer.charAt(n8);
                if (hexchars.indexOf(c2) < 0) {
                    ++n2;
                    if (objectArray.length() > 0) {
                        objectArray.append(' ');
                    }
                    if (Character.isSpaceChar(c2)) {
                        objectArray.append(SmartUtil.getString(222));
                    } else {
                        SmartUtil.htmlMeta((ReuseStringBuffer)objectArray, c2);
                    }
                    if (n8 <= n5) {
                        ++n6;
                    }
                } else {
                    reuseStringBuffer.append(c2);
                }
                ++n8;
            }
            stringBuffer.setLength(0);
            stringBuffer.append(ReuseStringBuffer.toString(reuseStringBuffer));
            n7 = stringBuffer.length();
            if (n2 > 0) {
                n5 -= n6;
                n7 = stringBuffer.length();
                objectArray2 = new Object[]{ReuseStringBuffer.toString((ReuseStringBuffer)objectArray)};
                if (n2 > 1) {
                    diagnosis.addDiagnostic(-771, SmartResources.get(84, objectArray2));
                } else {
                    diagnosis.addDiagnostic(-770, SmartResources.get(83, objectArray2));
                }
            }
            if (!bl2 && n7 % 2 == 1) {
                stringBuffer.insert(0, "0");
                ++n5;
                diagnosis.addDiagnostic(-769, SmartResources.get(82));
            } else if (!bl2 && n7 < n3) {
                objectArray2 = ReuseStringBuffer.getBuffer();
                objectArray2.append(stringBuffer);
                int n9 = n7;
                while (n9 < n3) {
                    objectArray2.append("0");
                    ++n9;
                }
                stringBuffer.setLength(0);
                stringBuffer.append(ReuseStringBuffer.toString((ReuseStringBuffer)objectArray2));
                Object[] objectArray3 = new Object[]{new Integer(n3), new Integer(n4)};
                diagnosis.addDiagnostic(-756, SmartResources.get(69, objectArray3));
            } else if (n4 > n3 && n7 > n4) {
                if (n5 == n7 - n4 - 1) {
                    stringBuffer.delete(0, n5 + 1);
                    n5 = 0;
                } else if (n5 >= n7) {
                    stringBuffer.setLength(n4);
                    n5 = n4;
                } else if (n5 - (n7 - n4) > -1) {
                    stringBuffer.delete(n5 - (n7 - n4), n5);
                    n5 -= n7 - n4;
                } else {
                    stringBuffer.setLength(n4);
                    n5 = n4;
                }
                if (n4 == 1) {
                    diagnosis.addDiagnostic(-759, SmartResources.get(72));
                } else {
                    objectArray2 = new Object[]{new Integer(n4)};
                    diagnosis.addDiagnostic(-761, SmartResources.get(74, objectArray2));
                }
            }
        }
        if (diagnosis != null && diagnosis.hasError()) {
            nArray[0] = n5;
            nArray[1] = n5;
            if (bl3 || SmartManager.getFixPolicy()) {
                if (bl && stringBuffer.length() == 0) {
                    stringBuffer.setLength(0);
                    stringBuffer.append(string);
                }
                nArray[0] = 0;
                nArray[1] = stringBuffer.length();
                smartConstraints.setConstraintFlag(8, true);
            }
            return bl3;
        }
        return true;
    }
}

