/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common.smartx.support;

import com.ibm.db2.tools.common.smartx.event.Diagnosis;
import com.ibm.db2.tools.common.smartx.support.SmartComponent;
import com.ibm.db2.tools.common.smartx.support.SmartConstraints;
import com.ibm.db2.tools.common.smartx.support.SmartManager;
import com.ibm.db2.tools.common.smartx.support.SmartResources;
import com.ibm.db2.tools.common.smartx.support.SmartUtil;
import com.ibm.db2.tools.common.smartx.support.SmartVerifier;
import com.ibm.db2.tools.common.smartx.support.diagnoser.DiagnoserUtil;
import com.ibm.db2.tools.common.smartx.support.diagnoser.SmartDiagnoser;
import com.ibm.db2.tools.common.smartx.support.verifier.BinaryStringVerifier;
import com.ibm.db2.tools.common.smartx.support.verifier.CollectionIDVerifier;
import com.ibm.db2.tools.common.smartx.support.verifier.CommentVerifier;
import com.ibm.db2.tools.common.smartx.support.verifier.DatabaseVerifier;
import com.ibm.db2.tools.common.smartx.support.verifier.DateVerifier;
import com.ibm.db2.tools.common.smartx.support.verifier.DecimalVerifier;
import com.ibm.db2.tools.common.smartx.support.verifier.FilenameVerifier;
import com.ibm.db2.tools.common.smartx.support.verifier.FloatingPointVerifier;
import com.ibm.db2.tools.common.smartx.support.verifier.GenericNameVerifier;
import com.ibm.db2.tools.common.smartx.support.verifier.HostIDVerifier;
import com.ibm.db2.tools.common.smartx.support.verifier.JarIDVerifier;
import com.ibm.db2.tools.common.smartx.support.verifier.JavaPackageVerifier;
import com.ibm.db2.tools.common.smartx.support.verifier.PasswordVerifier;
import com.ibm.db2.tools.common.smartx.support.verifier.PrecisionScaleVerifier;
import com.ibm.db2.tools.common.smartx.support.verifier.SQLIdentifierVerifier;
import com.ibm.db2.tools.common.smartx.support.verifier.StringLengthVerifier;
import com.ibm.db2.tools.common.smartx.support.verifier.StringVerifier;
import com.ibm.db2.tools.common.smartx.support.verifier.TCPIPAddressVerifier;
import com.ibm.db2.tools.common.smartx.support.verifier.TimeVerifier;
import com.ibm.db2.tools.common.smartx.support.verifier.TimestampVerifier;
import com.ibm.db2.tools.common.smartx.support.verifier.WholeNumberVerifier;
import java.io.Serializable;
import java.util.Hashtable;
import javax.swing.JComponent;
import javax.swing.text.Caret;
import javax.swing.text.JTextComponent;

public class VerifierUtil
extends DiagnoserUtil
implements Serializable {
    public static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected static Hashtable verifiers = new Hashtable(50);

    public static String[] divideIdentifier(String string) {
        return DiagnoserUtil.divideIdentifier(string, '\"');
    }

    public static int getLastDot(String string, boolean bl) {
        return DiagnoserUtil.getLastDot(string, bl, '\"');
    }

    public static boolean startsWith(String string, String string2) {
        return DiagnoserUtil.startsWith(string, string2, '\"');
    }

    public static String delCharsBefore(String string, int n2, int n3) {
        return DiagnoserUtil.delCharsBefore(string, n2, n3, '\"');
    }

    public static void setSharedVerifier(int n2, SmartVerifier smartVerifier) {
        verifiers.put(new Integer(n2), smartVerifier);
    }

    public static SmartVerifier getSharedVerifier(int n2) {
        if (n2 == 0) {
            return null;
        }
        int n3 = DiagnoserUtil.getCommonType(n2);
        SmartVerifier smartVerifier = (SmartVerifier)verifiers.get(new Integer(n3));
        if (smartVerifier == null) {
            smartVerifier = VerifierUtil.getDefaultVerifier(n3);
            if (smartVerifier != null) {
                verifiers.put(new Integer(n3), smartVerifier);
            } else {
                System.err.println("Internal error--VerifierUtil.getSharedVerifier: No default SmartVerifier for type: " + n2);
            }
        }
        return smartVerifier;
    }

    public static SmartVerifier getDefaultVerifier(int n2) {
        switch (n2) {
            case 45056: {
                return new TimeVerifier();
            }
            case 49152: {
                return new TimestampVerifier();
            }
            case 2816: 
            case 3072: 
            case 3328: {
                return new HostIDVerifier();
            }
            case 40960: {
                return new DateVerifier();
            }
            case 20480: 
            case 24576: 
            case 28672: {
                return new FloatingPointVerifier();
            }
            case 16384: {
                return new DecimalVerifier();
            }
            case 12288: {
                return new WholeNumberVerifier();
            }
            case 4096: {
                return new StringVerifier();
            }
            case 8192: {
                return new BinaryStringVerifier();
            }
            case 3584: 
            case 3840: 
            case 7936: {
                return new TCPIPAddressVerifier();
            }
            case 1: 
            case 2: 
            case 4: 
            case 8: 
            case 10: 
            case 12: 
            case 16: 
            case 18: 
            case 20: 
            case 144: 
            case 160: 
            case 65536: 
            case 131072: 
            case 196608: 
            case 327680: 
            case 393216: 
            case 458752: 
            case 589824: 
            case 655360: 
            case 720896: 
            case 0x110000: 
            case 0x150000: 
            case 0x190000: {
                return new SQLIdentifierVerifier();
            }
            case 512: {
                return new JavaPackageVerifier();
            }
            case 48: 
            case 64: {
                return new PrecisionScaleVerifier();
            }
            case 176: {
                return new DatabaseVerifier();
            }
            case 192: {
                return new CollectionIDVerifier();
            }
            case 32: {
                return new StringLengthVerifier();
            }
            case 96: 
            case 128: {
                return new CommentVerifier();
            }
            case 0x100001: 
            case 0x100002: 
            case 0x100004: 
            case 0x100008: 
            case 0x100010: 
            case 0x100020: {
                return new PasswordVerifier();
            }
            case 256: {
                return new GenericNameVerifier();
            }
            case 768: 
            case 1024: 
            case 1280: 
            case 1536: 
            case 1792: 
            case 2048: {
                return new FilenameVerifier();
            }
            case 2304: {
                return new JarIDVerifier();
            }
        }
        return null;
    }

    public static Object[] prepareDiagnosis(JComponent jComponent, SmartConstraints smartConstraints) {
        Object[] objectArray = new Object[3];
        JTextComponent jTextComponent = (JTextComponent)jComponent;
        objectArray[0] = new StringBuffer(jTextComponent.getText());
        Caret caret = jTextComponent.getCaret();
        objectArray[1] = new int[]{caret.getMark(), caret.getDot()};
        Diagnosis diagnosis = (Diagnosis)jTextComponent.getClientProperty("Diagnosis_object");
        if (diagnosis == null) {
            diagnosis = new Diagnosis();
            jTextComponent.putClientProperty("Diagnosis_object", diagnosis);
        } else if (smartConstraints.getConstraintFlag(7).booleanValue()) {
            diagnosis.clearDiagnoses();
        }
        objectArray[2] = diagnosis;
        return objectArray;
    }

    public static void conveyDiagnosis(boolean bl, JComponent jComponent, StringBuffer stringBuffer, int[] nArray, SmartConstraints smartConstraints, Diagnosis diagnosis) {
        if (diagnosis != null && diagnosis.hasError()) {
            Boolean bl2;
            JTextComponent jTextComponent = (JTextComponent)jComponent;
            Boolean bl3 = smartConstraints.getConstraintFlag(4);
            if (bl3 != null && bl3.booleanValue()) {
                SmartUtil.beep(diagnosis.getLastCode(), jTextComponent);
            }
            if ((bl2 = smartConstraints.getConstraintFlag(8)) != null && bl2.booleanValue()) {
                jTextComponent.setText(stringBuffer.toString());
                Caret caret = jTextComponent.getCaret();
                caret.setDot(nArray[0]);
                if (nArray[1] != nArray[0]) {
                    caret.moveDot(nArray[1]);
                }
                if (bl & !SmartManager.getFixPolicy()) {
                    SmartUtil.moveFixedDiagnosis(jTextComponent);
                }
            }
        }
    }

    public static boolean smartVerify(SmartDiagnoser smartDiagnoser, JComponent jComponent, SmartConstraints smartConstraints) {
        Object object;
        if (smartConstraints.getConstraintFlag(8).booleanValue() || !(jComponent instanceof JTextComponent)) {
            smartConstraints.setConstraintFlag(8, false);
            return true;
        }
        JTextComponent jTextComponent = (JTextComponent)jComponent;
        StringBuffer stringBuffer = new StringBuffer(jTextComponent.getText());
        Caret caret = jTextComponent.getCaret();
        int[] nArray = new int[]{caret.getMark(), caret.getDot()};
        Diagnosis diagnosis = (Diagnosis)jTextComponent.getClientProperty("Diagnosis_object");
        if (diagnosis == null) {
            diagnosis = new Diagnosis();
            String string = (String)smartConstraints.getConstraint("TipDescription");
            if ((string == null || string.equals(SmartResources.get(217))) && (object = jTextComponent.getAccessibleContext().getAccessibleName()) != null && ((String)object).length() > 0) {
                smartConstraints.setDescription((String)object);
            }
            jTextComponent.putClientProperty("Diagnosis_object", diagnosis);
        }
        boolean bl = smartDiagnoser.smartVerify(stringBuffer, nArray, smartConstraints, diagnosis);
        if (diagnosis != null && diagnosis.hasError()) {
            Boolean bl2;
            object = smartConstraints.getConstraintFlag(4);
            if (object != null && ((Boolean)object).booleanValue()) {
                SmartUtil.beep(diagnosis.getLastCode(), jTextComponent);
            }
            if ((bl2 = smartConstraints.getConstraintFlag(8)) != null && bl2.booleanValue()) {
                jTextComponent.setText(stringBuffer.toString());
                if (jTextComponent.isEnabled() && jTextComponent.hasFocus()) {
                    caret.setDot(nArray[0]);
                    if (nArray[1] != nArray[0]) {
                        caret.moveDot(nArray[1]);
                    }
                } else {
                    caret.setDot(nArray[1]);
                }
                if (bl & !SmartManager.getFixPolicy()) {
                    SmartUtil.moveFixedDiagnosis(jTextComponent);
                }
            }
        }
        return bl;
    }

    public static void initializeMate(SmartComponent smartComponent, SmartConstraints smartConstraints) {
        if (smartComponent != null && smartComponent instanceof JTextComponent && ((JTextComponent)((Object)smartComponent)).isEnabled()) {
            StringBuffer stringBuffer = (StringBuffer)smartConstraints.getConstraint("MateText");
            if (stringBuffer == null) {
                stringBuffer = new StringBuffer(((JTextComponent)((Object)smartComponent)).getText());
                smartConstraints.setConstraint("MateText", stringBuffer);
            } else {
                stringBuffer.setLength(0);
                stringBuffer.append(((JTextComponent)((Object)smartComponent)).getText());
            }
            int[] nArray = (int[])smartConstraints.getConstraint("MateMarkDot");
            Caret caret = ((JTextComponent)((Object)smartComponent)).getCaret();
            if (nArray == null) {
                nArray = new int[]{caret.getMark(), caret.getDot()};
                smartConstraints.setConstraint("MateMarkDot", nArray);
            } else {
                nArray[0] = caret.getMark();
                nArray[1] = caret.getDot();
            }
            if (smartConstraints.getConstraint("MateConstraints") == null) {
                smartConstraints.setConstraint("MateConstraints", smartComponent.getConstraints());
            }
            if (smartConstraints.getConstraint("MateDiagnosis") == null) {
                Diagnosis diagnosis = (Diagnosis)((JTextComponent)((Object)smartComponent)).getClientProperty("Diagnosis_object");
                if (diagnosis == null) {
                    String string;
                    diagnosis = new Diagnosis();
                    String string2 = smartComponent.getConstraints().getDescription();
                    if (string2.equals(SmartUtil.getString(217)) && (string = ((JTextComponent)((Object)smartComponent)).getAccessibleContext().getAccessibleName()) != null && string.length() > 0) {
                        smartComponent.getConstraints().setDescription(string);
                    }
                    ((JTextComponent)((Object)smartComponent)).putClientProperty("Diagnosis_object", diagnosis);
                }
                smartConstraints.setConstraint("MateDiagnosis", diagnosis);
            }
        }
    }
}

