/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common.smartx.support;

import com.ibm.db2.tools.common.smartx.SmartField;
import com.ibm.db2.tools.common.smartx.event.Diagnosis;
import com.ibm.db2.tools.common.smartx.event.SmartException;
import com.ibm.db2.tools.common.smartx.support.SmartManager;
import com.ibm.db2.tools.common.smartx.support.SmartResources;
import com.ibm.db2.tools.common.support.AssistComponent;
import com.ibm.db2.tools.common.support.AssistEditorKit;
import com.ibm.db2.tools.common.support.AssistManager;
import com.ibm.db2.tools.common.support.ReuseStringBuffer;
import java.awt.Toolkit;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.JTextComponent;

public class SmartUtil
implements Serializable {
    private static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String KEY_RESERVED_C = "CReserved";
    public static final String KEY_RESERVED_CPP = "C++Reserved";
    public static final String KEY_RESERVED_JAVA = "JavaReserved";
    public static final String KEY_SQL_1 = "FirstSQLkeywords";
    protected static final String ok = "OK";
    protected static Toolkit toolkit = Toolkit.getDefaultToolkit();
    protected static DecimalFormatSymbols decimalSymbols;
    protected static String exponential;
    protected static boolean fixing;
    protected static boolean fixed;
    protected static Hashtable resources;
    protected static Hashtable textActions;
    protected static int prevCode;
    protected static JComponent prevComp;

    public static boolean beginsWith(String string, String string2) {
        String string3;
        String string4;
        int n2 = string2.length();
        int n3 = string.length();
        if (string2.startsWith("\"") && n2 > 1) {
            string4 = string2.substring(1);
            if (string4.endsWith("\"") && n2 > 2) {
                string4 = string4.substring(0, n2 - 2);
            }
        } else {
            string4 = string2;
        }
        if (string.startsWith("\"") && n3 > 1) {
            string3 = string.substring(1);
            if (string3.endsWith("\"") && n3 > 2) {
                string3 = string3.substring(0, n3 - 2);
            }
        } else {
            string3 = string;
        }
        if (string3.length() < string4.length()) {
            return false;
        }
        return string4.equals(string3 = string3.substring(0, string4.length()));
    }

    public static void putResource(String string, Object object) {
        resources.put(string, object);
    }

    public static Object getResource(String string) {
        return resources.get(string);
    }

    public static String getString(int n2) {
        return SmartResources.get(n2);
    }

    public static String getString(int n2, Object[] objectArray) {
        return SmartResources.get(n2, objectArray);
    }

    protected static void except(JComponent jComponent, boolean bl) throws SmartException {
        Diagnosis diagnosis = (Diagnosis)jComponent.getClientProperty("Diagnosis_object");
        if (bl && diagnosis != null && diagnosis.hasDiagnosis()) {
            throw new SmartException(diagnosis);
        }
    }

    public static void appendDiag(JComponent jComponent, int n2, int n3) {
        Diagnosis diagnosis = (Diagnosis)jComponent.getClientProperty("Diagnosis_object");
        if (diagnosis == null) {
            diagnosis = new Diagnosis();
            jComponent.putClientProperty("Diagnosis_object", diagnosis);
        }
        diagnosis.addDiagnostic(n2, SmartUtil.getString(n3));
    }

    public static void appendDiag(JComponent jComponent, int n2, int n3, Object[] objectArray) {
        Diagnosis diagnosis = (Diagnosis)jComponent.getClientProperty("Diagnosis_object");
        if (diagnosis == null) {
            diagnosis = new Diagnosis();
            jComponent.putClientProperty("Diagnosis_object", diagnosis);
        }
        diagnosis.addDiagnostic(n2, SmartUtil.getString(n3, objectArray));
    }

    public static Diagnosis getDiagnosis(JComponent jComponent) {
        Diagnosis diagnosis = (Diagnosis)jComponent.getClientProperty("Diagnosis_object");
        if (diagnosis == null || !diagnosis.hasDiagnosis()) {
            return null;
        }
        return diagnosis;
    }

    public static Diagnosis findDiagnosis(JComponent jComponent) {
        Diagnosis diagnosis = (Diagnosis)jComponent.getClientProperty("Diagnosis_object");
        if (diagnosis == null) {
            diagnosis = new Diagnosis();
            jComponent.putClientProperty("Diagnosis_object", diagnosis);
        }
        return diagnosis;
    }

    public static Diagnosis getFixedDiagnosis(JComponent jComponent) {
        return (Diagnosis)jComponent.getClientProperty("Diagnosis_fixed");
    }

    public static void moveFixedDiagnosis(JComponent jComponent) {
        Diagnosis diagnosis = SmartUtil.getDiagnosis(jComponent);
        if (diagnosis != null) {
            jComponent.putClientProperty("Diagnosis_fixed", diagnosis);
            jComponent.putClientProperty("Diagnosis_object", null);
        } else {
            jComponent.putClientProperty("Diagnosis_fixed", null);
        }
    }

    public static String[] getDiagnoses(JComponent jComponent) {
        Diagnosis diagnosis = (Diagnosis)jComponent.getClientProperty("Diagnosis_object");
        if (diagnosis == null || !diagnosis.hasDiagnosis()) {
            return null;
        }
        return diagnosis.getDiagnosesArray();
    }

    public static int[] getCodes(JComponent jComponent) {
        Diagnosis diagnosis = (Diagnosis)jComponent.getClientProperty("Diagnosis_object");
        if (diagnosis == null || !diagnosis.hasDiagnosis()) {
            int[] nArray = new int[]{0};
            return nArray;
        }
        return diagnosis.getCodesArray();
    }

    public static void setFixing(boolean bl) {
        fixing = bl;
        if (bl) {
            fixed = false;
        }
    }

    public static char getDecimalSeparator() {
        if (decimalSymbols == null) {
            decimalSymbols = new DecimalFormatSymbols(AssistManager.getPreferredLocale());
        }
        return decimalSymbols.getDecimalSeparator();
    }

    public static char getMinusSign() {
        if (decimalSymbols == null) {
            decimalSymbols = new DecimalFormatSymbols(AssistManager.getPreferredLocale());
        }
        return decimalSymbols.getMinusSign();
    }

    public static String getExponentialSymbols() {
        if (exponential == null) {
            String[] stringArray;
            char c2;
            exponential = "Ee";
            Locale locale = AssistManager.getPreferredLocale();
            ResourceBundle resourceBundle = null;
            try {
                resourceBundle = AssistManager.isJavaVersionAtLeast(1, 4, 0) ? ResourceBundle.getBundle("sun.text.resources.LocaleElements", locale) : ResourceBundle.getBundle("java.text.resources.LocaleElements", locale);
            }
            catch (MissingResourceException missingResourceException) {
                return exponential;
            }
            if (resourceBundle != null && (c2 = (stringArray = resourceBundle.getStringArray("NumberElements"))[7].charAt(0)) != 'E') {
                ReuseStringBuffer reuseStringBuffer = ReuseStringBuffer.getBuffer();
                reuseStringBuffer.append(c2).append(Character.toLowerCase(c2)).append(exponential);
                exponential = ReuseStringBuffer.toString(reuseStringBuffer);
            }
        }
        return exponential;
    }

    protected static char getGroupingSeparator() {
        if (decimalSymbols == null) {
            decimalSymbols = new DecimalFormatSymbols(AssistManager.getPreferredLocale());
        }
        return decimalSymbols.getGroupingSeparator();
    }

    public static String getHostAddress() {
        try {
            return InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
    }

    public static void smartValueRequired(JComponent jComponent, boolean bl) {
        Diagnosis diagnosis = (Diagnosis)jComponent.getClientProperty("Diagnosis_object");
        if (!bl) {
            diagnosis = new Diagnosis();
            diagnosis.addDiagnostic(-760, SmartResources.get(73));
            jComponent.putClientProperty("Diagnosis_object", diagnosis);
        } else if (bl && diagnosis != null) {
            jComponent.putClientProperty("Diagnosis_object", null);
        }
    }

    public static boolean smartSQLStatement(boolean bl, String string, JTextComponent jTextComponent, boolean bl2) {
        try {
            return SmartUtil.smartSQLStatement_Implementation(bl, string, jTextComponent, bl2, false);
        }
        catch (SmartException smartException) {
            return false;
        }
    }

    public static void smartSQLStatement_Ex(boolean bl, String string, JTextComponent jTextComponent, boolean bl2) throws SmartException {
        SmartUtil.smartSQLStatement_Implementation(bl, string, jTextComponent, bl2, true);
    }

    protected static boolean smartSQLStatement_Implementation(boolean bl, String string, JTextComponent jTextComponent, boolean bl2, boolean bl3) throws SmartException {
        if (fixed) {
            fixed = false;
            prevCode = 0;
            return true;
        }
        jTextComponent.putClientProperty("Diagnosis_object", null);
        return true;
    }

    public static boolean isIdentifierStart(char c2, boolean bl) {
        return c2 >= 'A' && c2 <= 'Z' || c2 >= 'a' && c2 <= 'z' || bl && c2 == '$' || c2 == '_';
    }

    public static boolean isIdentifierPart(char c2) {
        return c2 >= 'A' && c2 <= 'Z' || c2 >= 'a' && c2 <= 'z' || c2 >= '0' && c2 <= '9' || c2 == '$' || c2 == '_';
    }

    protected static boolean startsWith(JTextComponent jTextComponent, String string) {
        String string2;
        String string3 = jTextComponent.getText();
        int n2 = 0;
        if (string3.startsWith("\"")) {
            n2 = 1;
            string2 = string3.substring(1, string.length() + 1);
        } else {
            string2 = AssistManager.toUpperCase(string3);
            string2 = string2.substring(0, string.length());
        }
        if (string.equals(string2)) {
            if (SmartManager.getFixPolicy() || fixing) {
                StringBuffer stringBuffer = new StringBuffer();
                if (n2 == 1) {
                    stringBuffer.append(string3.charAt(0));
                }
                stringBuffer.append("S").append(string3.substring(n2 + 3));
                fixed = true;
                jTextComponent.setText(stringBuffer.toString());
                jTextComponent.select(n2 + 1, n2 + 3);
            }
            return false;
        }
        return true;
    }

    public static boolean smartLOBLength(SmartField smartField, int n2, int n3) {
        try {
            return SmartUtil.smartLOBLength_Implementation(smartField, n2, n3, 408, false);
        }
        catch (SmartException smartException) {
            return false;
        }
    }

    public static void smartLOBLength_Ex(SmartField smartField, int n2, int n3) throws SmartException {
        SmartUtil.smartLOBLength_Implementation(smartField, n2, n3, 408, true);
    }

    public static boolean smartLOBLength(SmartField smartField, int n2, int n3, int n4) {
        try {
            return SmartUtil.smartLOBLength_Implementation(smartField, n2, n3, n4, false);
        }
        catch (SmartException smartException) {
            return false;
        }
    }

    public static void smartLOBLength_Ex(SmartField smartField, int n2, int n3, int n4) throws SmartException {
        SmartUtil.smartLOBLength_Implementation(smartField, n2, n3, n4, true);
    }

    protected static boolean smartLOBLength_Implementation(SmartField smartField, int n2, int n3, int n4, boolean bl) throws SmartException {
        int n5;
        int n6;
        if (fixed) {
            fixed = false;
            prevCode = 0;
            return true;
        }
        if (!SmartManager.getScaleLOBLengthPolicy()) {
            return true;
        }
        if (!smartField.isValueValid()) {
            return false;
        }
        smartField.putClientProperty("Diagnosis_object", null);
        if (n2 < 0) {
            n2 = 0;
        }
        if (n2 == n3) {
            return true;
        }
        long l2 = 0L;
        try {
            l2 = Long.valueOf(smartField.getText());
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        long l3 = l2 < 0L ? -1L * l2 : l2;
        switch (n2) {
            case 1: {
                n6 = 1024;
                n5 = 0x200000;
                break;
            }
            case 2: {
                n6 = 0x100000;
                n5 = 2048;
                break;
            }
            case 3: {
                n6 = 0x40000000;
                n5 = 2;
                break;
            }
            default: {
                n6 = 1;
                n5 = Integer.MAX_VALUE;
            }
        }
        if (n4 == 412 || n4 == 612) {
            n5 /= 2;
        }
        switch (n3) {
            case 1: {
                if (l3 >= (long)n5) {
                    l3 = 0x200000L;
                    break;
                }
                l3 = l3 * (long)n6 / 1024L;
                break;
            }
            case 2: {
                if (l3 >= (long)n5) {
                    l3 = 2048L;
                    break;
                }
                l3 = l3 * (long)n6 / 0x100000L;
                break;
            }
            case 3: {
                if (l3 >= (long)n5) {
                    l3 = 2L;
                    break;
                }
                l3 = l3 * (long)n6 / 0x40000000L;
                break;
            }
            default: {
                if (l3 >= (long)n5) {
                    l3 = Integer.MAX_VALUE;
                    break;
                }
                l3 *= (long)n6;
            }
        }
        if (n4 == 412 || n4 == 612) {
            l3 /= 2L;
        }
        if (l3 == 0L) {
            l3 = 1L;
        }
        if (l2 != l3) {
            fixed = true;
            smartField.setText(String.valueOf(l3));
            int n7 = smartField.getText().length();
            smartField.setCaretPosition(n7);
            smartField.select(0, n7);
            smartField.grabFocus();
            String string = SmartUtil.getString(SmartUtil.getMagnitudeKey(n2));
            String string2 = SmartUtil.getString(SmartUtil.getMagnitudeKey(n3));
            Object[] objectArray = new Object[]{string, string2};
            SmartUtil.appendDiag(smartField, 710, 25, objectArray);
            SmartUtil.except(smartField, bl);
            return false;
        }
        return true;
    }

    protected static char getCaretChar(JTextField jTextField) {
        int n2 = jTextField.getCaretPosition();
        if (n2 > 0) {
            return jTextField.getText().charAt(n2 - 1);
        }
        return '\uffff';
    }

    protected static void delCaretChar(JTextField jTextField) {
        SmartUtil.delCaretChars(jTextField, 1);
    }

    protected static void delCaretChars(JTextField jTextField, int n2) {
        String string = jTextField.getText();
        int n3 = string.length();
        int n4 = jTextField.getCaretPosition();
        int n5 = 0;
        int n6 = 0;
        while (n6 < n2) {
            n5 = string.charAt(n4 - n6 - 1) != '\"' ? ++n5 : (n5 += 2);
            ++n6;
        }
        if (n4 < n5 - 1) {
            n4 = n5 - 1;
        }
        if (n4 == n3) {
            fixed = true;
            jTextField.setText(string.substring(0, n3 - n5));
        } else {
            fixed = true;
            jTextField.setText(string.substring(0, n4 - n5) + string.substring(n4));
            jTextField.setCaretPosition(n4 - n5);
        }
    }

    protected static void setRange(JTextField jTextField, String string, int n2, int n3) {
        String string2 = jTextField.getText();
        int n4 = string2.length();
        if (n2 == 0) {
            fixed = true;
            if (n3 == n4) {
                jTextField.setText(string);
            } else {
                jTextField.setText(string + string2.substring(n3));
            }
        } else {
            StringBuffer stringBuffer = new StringBuffer();
            if (n2 > 0) {
                stringBuffer.append(string2.substring(0, n2));
            }
            stringBuffer.append(string);
            if (n3 < n4) {
                stringBuffer.append(string2.substring(n3));
            }
            fixed = true;
            jTextField.setText(stringBuffer.toString());
        }
    }

    public static int getDot(String string, boolean bl) {
        return SmartUtil.getDot(string, bl, '\"');
    }

    public static int getDot(String string, boolean bl, char c2) {
        int n2 = string.length();
        if (n2 == 0) {
            return -1;
        }
        int n3 = 0;
        int n4 = 0;
        int n5 = string.indexOf(46, 0);
        while (n5 > -1) {
            ++n4;
            n5 = string.indexOf(46, n5 + 1);
        }
        StringBuffer stringBuffer = new StringBuffer(string.length());
        stringBuffer.append(c2).append(c2);
        String string2 = stringBuffer.toString();
        stringBuffer.setLength(0);
        stringBuffer.append(string.charAt(0));
        n5 = 1;
        int n6 = string.indexOf(string2, 1);
        while (n6 > -1) {
            stringBuffer.append(string.substring(n5, n6));
            stringBuffer.append("--");
            n5 = n6 + 2;
            n6 = string.indexOf(string2, n5);
        }
        if (n5 < n2 - 1) {
            stringBuffer.append(string.substring(n5));
        }
        String string3 = stringBuffer.toString();
        int n7 = 0;
        n5 = 1;
        while (n6 > -1 && n6 < string3.length()) {
            ++n7;
            n6 = string3.indexOf(c2, n6 + 1);
        }
        if (n7 % 2 == 0) {
            switch (n4) {
                case 0: {
                    n3 = -1;
                    break;
                }
                default: {
                    if (bl) {
                        int n8 = string.indexOf(46);
                        if (n8 == 0) {
                            n3 = -1;
                            break;
                        }
                        if (n8 == n2 - 1) {
                            n3 = n2;
                            break;
                        }
                        n3 = n8;
                        break;
                    }
                    n3 = -1;
                    break;
                }
            }
        } else {
            switch (n4) {
                case 0: {
                    n3 = -1;
                    break;
                }
                default: {
                    if (bl) {
                        int n9 = string.indexOf(46);
                        if (n9 == 0) {
                            n3 = 0;
                            break;
                        }
                        if (n9 == n2 - 1) {
                            n3 = n9;
                            break;
                        }
                        n3 = n9;
                        break;
                    }
                    n3 = -1;
                }
            }
        }
        return n3;
    }

    public static boolean checkUniqueness(JTextField jTextField, String string, Vector vector, boolean bl) {
        try {
            return SmartUtil.checkUniqueness_Implementation(jTextField, string, vector, bl, false);
        }
        catch (SmartException smartException) {
            return false;
        }
    }

    public static void checkUniqueness_Ex(JTextField jTextField, String string, Vector vector, boolean bl) throws SmartException {
        SmartUtil.checkUniqueness_Implementation(jTextField, string, vector, bl, true);
    }

    protected static boolean checkUniqueness_Implementation(JTextField jTextField, String string, Vector vector, boolean bl, boolean bl2) throws SmartException {
        String string2;
        if (fixed) {
            fixed = false;
            prevCode = 0;
            return true;
        }
        jTextField.putClientProperty("Diagnosis_object", null);
        String string3 = jTextField.getText().trim();
        String string4 = null;
        int n2 = SmartUtil.getDot(string3, true);
        if (n2 != -1) {
            string4 = string3.substring(0, n2);
            string2 = n2 < string3.length() ? string3.substring(n2 + 1) : "";
        } else {
            string2 = string3;
        }
        String string5 = null;
        boolean bl3 = false;
        if (string2.length() == 0) {
            string2 = SmartUtil.concatName(string, 0, bl);
            bl3 = true;
        }
        boolean bl4 = false;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Object e2 = enumeration.nextElement();
            if (e2 == null) continue;
            String string6 = e2.toString().trim();
            n2 = SmartUtil.getDot(string6, true);
            if (string4 != null && n2 > 0) {
                if (SmartUtil.equal(string4, string6.substring(0, n2))) {
                    if (!SmartUtil.equal(string2, string6.substring(n2 + 1))) continue;
                    bl4 = true;
                    break;
                }
                bl4 = false;
                continue;
            }
            if (!SmartUtil.equal(string3, string6)) continue;
            bl4 = true;
            break;
        }
        if (bl4) {
            boolean bl5 = false;
            if (string2.charAt(string2.length() - 1) == '\"') {
                bl5 = true;
                string2 = string2.substring(0, string2.length());
            }
            int n3 = string2.length() - 1;
            while (Character.isDigit(string2.charAt(n3)) && n3 > 0) {
                --n3;
            }
            if (n3 < string2.length() - 1) {
                string2 = string2.substring(0, n3 + 1);
            }
            if (bl5) {
                string2 = string2 + "\"";
            }
            int n4 = 0;
            boolean bl6 = true;
            while (bl6) {
                string5 = SmartUtil.concatName(string2, ++n4, bl);
                bl6 = SmartUtil.checkName(vector, string5);
            }
            string2 = string5;
            bl3 = true;
        }
        if (bl3) {
            SmartUtil.beep(-721, jTextField);
            if (SmartManager.getFixPolicy() || fixing) {
                fixed = true;
                if (string4 == null) {
                    jTextField.setText(string2);
                } else {
                    jTextField.setText(string4 + "." + string2);
                }
            }
            SmartUtil.appendDiag(jTextField, -721, 36);
            SmartUtil.except(jTextField, bl2);
            return false;
        }
        return true;
    }

    public static Action getTextAction(String string) {
        if (textActions == null) {
            textActions = AssistEditorKit.setTextActions(new DefaultEditorKit().getActions());
        }
        return (Action)textActions.get(string);
    }

    public static String concatName(String string, int n2, boolean bl) {
        return SmartUtil.concatName(string, n2, bl, '\"');
    }

    public static String concatName(String string, int n2, boolean bl, char c2) {
        String string2 = string.trim();
        int n3 = string2.length();
        int n4 = string2.length() - 1;
        int n5 = 8;
        if (bl) {
            n5 = 18;
        }
        string2 = string2.charAt(n4) == c2 ? string2.substring(0, n4 - 1) + n2 + c2 : string2 + n2;
        int n6 = string2.length();
        int n7 = SmartUtil.lengthID(string2, c2);
        if (n7 > n5) {
            int n8 = n3;
            if (n7 != n6) {
                n8 = n3 - 1;
            }
            int n9 = n8;
            int n10 = 0;
            while (n10 < n7 - n5) {
                n9 = string2.charAt(n9 - n10 - 1) != c2 ? --n9 : (n9 -= 2);
                ++n10;
            }
            string2 = string2.substring(0, n9) + string2.substring(n8);
        }
        return string2;
    }

    protected static int lengthID(String string) {
        return SmartUtil.lengthID(string, '\"');
    }

    protected static int lengthID(String string, char c2) {
        if (string == null) {
            return 0;
        }
        String string2 = string.trim();
        int n2 = string2.length();
        if (n2 == 0) {
            return 0;
        }
        if (string2.charAt(0) == c2) {
            int n3 = n2 - 2;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(c2).append(c2);
            String string3 = stringBuffer.toString();
            int n4 = string2.indexOf(string3, 1);
            while (n4 > -1 && n4 < n2 - 2) {
                --n3;
                n4 = string2.indexOf(string3, n4 + 2);
            }
            return n3;
        }
        return n2;
    }

    public static boolean checkName(Vector vector, String string) {
        return SmartUtil.checkName(vector, string, '\"');
    }

    public static boolean checkName(Vector vector, String string, char c2) {
        boolean bl = false;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            if (!SmartUtil.equal(enumeration.nextElement().toString(), string, c2)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    protected static Object[] checkDigits(String string, int n2) {
        int n3 = string.length();
        StringBuffer stringBuffer = null;
        int n4 = 0;
        int n5 = 0;
        StringBuffer stringBuffer2 = new StringBuffer();
        int n6 = 0;
        while (n6 < n3) {
            char c2 = string.charAt(n6);
            if (Character.isDigit(c2)) {
                stringBuffer2.append(c2);
            } else {
                ++n4;
                if (stringBuffer == null) {
                    stringBuffer = new StringBuffer();
                } else {
                    stringBuffer.append(' ');
                }
                if (Character.isSpaceChar(c2)) {
                    stringBuffer.append(SmartUtil.getString(222));
                } else {
                    SmartUtil.htmlMeta(stringBuffer, c2);
                }
                if (n6 <= n2) {
                    ++n5;
                }
            }
            ++n6;
        }
        if (n4 == 0) {
            return null;
        }
        Object[] objectArray = new Object[]{stringBuffer2.toString(), stringBuffer.toString(), new Integer(n2 -= n5), new Integer(n4)};
        return objectArray;
    }

    public static boolean isDelimited(String string, int n2, char c2) {
        if (string.charAt(0) == c2) {
            return true;
        }
        return string.indexOf(c2) >= n2;
    }

    public static boolean equal(String string, String string2) {
        return SmartUtil.equal(string, string2, '\"');
    }

    public static boolean equal(String string, String string2, char c2) {
        return SmartUtil.equalize(string, c2).equals(SmartUtil.equalize(string2, c2));
    }

    protected static String equalize(String string) {
        return SmartUtil.equalize(string, '\"');
    }

    protected static String equalize(String string, char c2) {
        if (string == null) {
            return "";
        }
        String string2 = string.trim();
        if (string2.length() > 0) {
            if (string2.charAt(0) == c2 && string.length() > 2) {
                string2 = string2.substring(1, string2.length() - 1);
                int n2 = 0;
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(c2).append(c2);
                String string3 = stringBuffer.toString();
                int n3 = string2.indexOf(string3);
                if (n3 > -1) {
                    StringBuffer stringBuffer2 = new StringBuffer();
                    while (n3 > -1) {
                        stringBuffer2.append(string2.substring(n2, n3));
                        n2 = n3 + 2;
                        n3 = string2.indexOf(string3, n2);
                    }
                    string2 = stringBuffer2.toString();
                }
            } else {
                string2 = AssistManager.toUpperCase(string2);
            }
        }
        return string2;
    }

    public static int getMagnitudeKey(int n2) {
        int n3 = -1;
        switch (n2) {
            case 1: {
                n3 = 186;
                break;
            }
            case 2: {
                n3 = 187;
                break;
            }
            case 3: {
                n3 = 188;
                break;
            }
            default: {
                n3 = 185;
            }
        }
        return n3;
    }

    public static void htmlMeta(StringBuffer stringBuffer, char c2) {
        switch (c2) {
            case '<': {
                stringBuffer.append("&lt;");
                break;
            }
            case '>': {
                stringBuffer.append("&gt;");
                break;
            }
            case '&': {
                stringBuffer.append("&amp;");
                break;
            }
            case '\"': {
                stringBuffer.append("&quot;");
                break;
            }
            default: {
                stringBuffer.append(c2);
            }
        }
    }

    public static void htmlMeta(ReuseStringBuffer reuseStringBuffer, char c2) {
        switch (c2) {
            case '<': {
                reuseStringBuffer.append("&lt;");
                break;
            }
            case '>': {
                reuseStringBuffer.append("&gt;");
                break;
            }
            case '&': {
                reuseStringBuffer.append("&amp;");
                break;
            }
            case '\"': {
                reuseStringBuffer.append("&quot;");
                break;
            }
            default: {
                reuseStringBuffer.append(c2);
            }
        }
    }

    public static String getDefaultSpecificName(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        DecimalFormat decimalFormat = new DecimalFormat("00");
        Calendar calendar = Calendar.getInstance();
        StringBuffer stringBuffer2 = new StringBuffer();
        if (bl) {
            stringBuffer2.append("SQL");
            stringBuffer2.append(calendar.get(1) % 100);
            stringBuffer2.append(decimalFormat.format(calendar.get(2)));
            stringBuffer2.append(decimalFormat.format(calendar.get(5)));
        } else {
            stringBuffer2.append("S");
        }
        stringBuffer2.append(decimalFormat.format(calendar.get(10)));
        stringBuffer2.append(decimalFormat.format(calendar.get(12)));
        stringBuffer2.append(decimalFormat.format(calendar.get(13)));
        stringBuffer2.append(decimalFormat.format(calendar.get(14) / 10));
        stringBuffer2.append('0');
        return new String(stringBuffer2.toString());
    }

    public static void beep(int n2, JComponent jComponent) {
        boolean bl = SmartManager.getSmartBeepPolicy();
        if (jComponent instanceof AssistComponent && ((AssistComponent)((Object)jComponent)).getBeepPolicy() != null) {
            bl = ((AssistComponent)((Object)jComponent)).getBeepPolicy();
        }
        if (bl && (n2 != prevCode || jComponent != prevComp)) {
            prevCode = n2;
            prevComp = jComponent;
            toolkit.beep();
        }
    }

    static {
        fixed = false;
        prevCode = 0;
        prevComp = null;
        resources = new Hashtable(200);
        Hashtable<String, String> hashtable = new Hashtable<String, String>(47);
        hashtable.put("asm", ok);
        hashtable.put("auto", ok);
        hashtable.put("break", ok);
        hashtable.put("case", ok);
        hashtable.put("char", ok);
        hashtable.put("continue", ok);
        hashtable.put("default", ok);
        hashtable.put("do", ok);
        hashtable.put("double", ok);
        hashtable.put("else", ok);
        hashtable.put("entry", ok);
        hashtable.put("enum", ok);
        hashtable.put("extern", ok);
        hashtable.put("float", ok);
        hashtable.put("for", ok);
        hashtable.put("fortran", ok);
        hashtable.put("goto", ok);
        hashtable.put("if", ok);
        hashtable.put("int", ok);
        hashtable.put("long", ok);
        hashtable.put("register", ok);
        hashtable.put("return", ok);
        hashtable.put("short", ok);
        hashtable.put("sizeof", ok);
        hashtable.put("static", ok);
        hashtable.put("struct", ok);
        hashtable.put("switch", ok);
        hashtable.put("typedef", ok);
        hashtable.put("union", ok);
        hashtable.put("unsigned", ok);
        hashtable.put("void", ok);
        hashtable.put("while", ok);
        resources.put(KEY_RESERVED_C, hashtable);
        Hashtable<String, String> hashtable2 = new Hashtable<String, String>(61);
        hashtable2.put("asm", ok);
        hashtable2.put("auto", ok);
        hashtable2.put("break", ok);
        hashtable2.put("case", ok);
        hashtable2.put("catch", ok);
        hashtable2.put("char", ok);
        hashtable2.put("class", ok);
        hashtable2.put("const", ok);
        hashtable2.put("continue", ok);
        hashtable2.put("default", ok);
        hashtable2.put("delete", ok);
        hashtable2.put("do", ok);
        hashtable2.put("double", ok);
        hashtable2.put("else", ok);
        hashtable2.put("enum", ok);
        hashtable2.put("extern", ok);
        hashtable2.put("float", ok);
        hashtable2.put("for", ok);
        hashtable2.put("friend", ok);
        hashtable2.put("goto", ok);
        hashtable2.put("if", ok);
        hashtable2.put("inline", ok);
        hashtable2.put("int", ok);
        hashtable2.put("long", ok);
        hashtable2.put("new", ok);
        hashtable2.put("operator", ok);
        hashtable2.put("private", ok);
        hashtable2.put("protected", ok);
        hashtable2.put("public", ok);
        hashtable2.put("register", ok);
        hashtable2.put("return", ok);
        hashtable2.put("short", ok);
        hashtable2.put("signed", ok);
        hashtable2.put("sizeof", ok);
        hashtable2.put("static", ok);
        hashtable2.put("struct", ok);
        hashtable2.put("switch", ok);
        hashtable2.put("template", ok);
        hashtable2.put("this", ok);
        hashtable2.put("throw", ok);
        hashtable2.put("try", ok);
        hashtable2.put("typedef", ok);
        hashtable2.put("union", ok);
        hashtable2.put("unsigned", ok);
        hashtable2.put("virtual", ok);
        hashtable2.put("void", ok);
        hashtable2.put("volatile", ok);
        hashtable2.put("while", ok);
        resources.put(KEY_RESERVED_CPP, hashtable2);
        Hashtable<String, String> hashtable3 = new Hashtable<String, String>(47);
        hashtable3.put("abstract", ok);
        hashtable3.put("boolean", ok);
        hashtable3.put("break", ok);
        hashtable3.put("byte", ok);
        hashtable3.put("case", ok);
        hashtable3.put("catch", ok);
        hashtable3.put("char", ok);
        hashtable3.put("class", ok);
        hashtable3.put("const", ok);
        hashtable3.put("continue", ok);
        hashtable3.put("default", ok);
        hashtable3.put("do", ok);
        hashtable3.put("double", ok);
        hashtable3.put("else", ok);
        hashtable3.put("extends", ok);
        hashtable3.put("final", ok);
        hashtable3.put("finally", ok);
        hashtable3.put("float", ok);
        hashtable3.put("for", ok);
        hashtable3.put("goto", ok);
        hashtable3.put("if", ok);
        hashtable3.put("implements", ok);
        hashtable3.put("import", ok);
        hashtable3.put("instanceof", ok);
        hashtable3.put("int", ok);
        hashtable3.put("interface", ok);
        hashtable3.put("long", ok);
        hashtable3.put("native", ok);
        hashtable3.put("new", ok);
        hashtable3.put("null", ok);
        hashtable3.put("package", ok);
        hashtable3.put("private", ok);
        hashtable3.put("protected", ok);
        hashtable3.put("public", ok);
        hashtable3.put("return", ok);
        hashtable3.put("short", ok);
        hashtable3.put("static", ok);
        hashtable3.put("super", ok);
        hashtable3.put("switch", ok);
        hashtable3.put("synchronized", ok);
        hashtable3.put("this", ok);
        hashtable3.put("throw", ok);
        hashtable3.put("throws", ok);
        hashtable3.put("transient", ok);
        hashtable3.put("try", ok);
        hashtable3.put("void", ok);
        hashtable3.put("volatile", ok);
        hashtable3.put("while", ok);
        resources.put(KEY_RESERVED_JAVA, hashtable3);
    }
}

