/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common.smartx.support;

import java.io.Serializable;
import javax.swing.JMenuItem;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;

public class SmartUndoManager
extends UndoManager
implements Serializable {
    private static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public void enableUndo(JMenuItem jMenuItem, JMenuItem jMenuItem2) {
        if (jMenuItem != null) {
            if (super.canUndo()) {
                jMenuItem.setEnabled(true);
            } else {
                jMenuItem.setEnabled(false);
            }
        }
        if (jMenuItem2 != null) {
            if (super.canRedo()) {
                jMenuItem2.setEnabled(true);
            } else {
                jMenuItem2.setEnabled(false);
            }
        }
    }

    public void undo() {
        try {
            if (super.canUndo()) {
                super.undo();
            }
        }
        catch (CannotUndoException cannotUndoException) {
            System.gc();
        }
    }

    public void redo() {
        try {
            if (super.canRedo()) {
                super.redo();
            }
        }
        catch (CannotRedoException cannotRedoException) {
            System.gc();
        }
    }

    public void combine1(UndoableEdit undoableEdit) {
        if (this.edits.size() == 0) {
            this.addEdit(undoableEdit);
        } else {
            CompoundEdit compoundEdit = new CompoundEdit();
            int n2 = this.edits.size();
            UndoableEdit undoableEdit2 = this.edits.elementAt(n2 - 1);
            this.edits.removeElementAt(n2 - 1);
            compoundEdit.addEdit(undoableEdit2);
            compoundEdit.addEdit(undoableEdit);
            compoundEdit.end();
            this.addEdit(compoundEdit);
        }
    }

    public void combine3(UndoableEdit undoableEdit) {
        int n2 = this.edits.size();
        if (n2 > 1) {
            CompoundEdit compoundEdit = new CompoundEdit();
            UndoableEdit undoableEdit2 = this.edits.elementAt(n2 - 1);
            UndoableEdit undoableEdit3 = this.edits.elementAt(n2 - 2);
            this.edits.removeElementAt(n2 - 1);
            this.edits.removeElementAt(n2 - 2);
            compoundEdit.addEdit(undoableEdit3);
            compoundEdit.addEdit(undoableEdit2);
            compoundEdit.addEdit(undoableEdit);
            compoundEdit.end();
            this.addEdit(compoundEdit);
        } else {
            this.addEdit(undoableEdit);
        }
    }

    public void combine4(UndoableEdit undoableEdit) {
        int n2 = this.edits.size();
        if (n2 > 2) {
            CompoundEdit compoundEdit = new CompoundEdit();
            UndoableEdit undoableEdit2 = this.edits.elementAt(n2 - 1);
            UndoableEdit undoableEdit3 = this.edits.elementAt(n2 - 2);
            UndoableEdit undoableEdit4 = this.edits.elementAt(n2 - 3);
            this.edits.removeElementAt(n2 - 1);
            this.edits.removeElementAt(n2 - 2);
            this.edits.removeElementAt(n2 - 3);
            compoundEdit.addEdit(undoableEdit4);
            compoundEdit.addEdit(undoableEdit3);
            compoundEdit.addEdit(undoableEdit2);
            compoundEdit.addEdit(undoableEdit);
            compoundEdit.end();
            this.addEdit(compoundEdit);
        } else {
            this.addEdit(undoableEdit);
        }
    }
}

