/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common.smartx.support;

import com.ibm.db2.tools.common.smartx.SmartField;
import com.ibm.db2.tools.common.smartx.event.Diagnosis;
import com.ibm.db2.tools.common.smartx.event.LinkEvent;
import com.ibm.db2.tools.common.smartx.event.LinkListener;
import com.ibm.db2.tools.common.smartx.support.DiagnosisRenderer;
import com.ibm.db2.tools.common.smartx.support.LinkComponent;
import com.ibm.db2.tools.common.smartx.support.SmartComponent;
import com.ibm.db2.tools.common.smartx.support.SmartManager;
import com.ibm.db2.tools.common.smartx.support.SmartTip;
import com.ibm.db2.tools.common.smartx.support.SmartUtil;
import com.ibm.db2.tools.common.support.AssistManager;
import com.ibm.db2.tools.common.support.JPanelPopup;
import com.ibm.db2.tools.common.support.PanelPopup;
import com.ibm.db2.tools.common.support.Popup;
import com.ibm.db2.tools.common.support.WindowPopup;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Iterator;
import java.util.Vector;
import java.util.WeakHashMap;
import javax.accessibility.AccessibleContext;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

public class SmartTipManager
implements LinkComponent,
LinkListener,
FocusListener,
ComponentListener,
AncestorListener,
ActionListener,
MouseMotionListener,
MouseListener,
Serializable {
    private static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final int NOWHERE = -1;
    public static final int TOP = 1;
    public static final int BOTTOM = 2;
    public static final int LEFT = 3;
    public static final int RIGHT = 4;
    protected Timer moveTimer;
    protected WeakHashMap tips = new WeakHashMap(100);
    protected WeakHashMap directions = new WeakHashMap(100);
    protected static final SmartTipManager sharedInstance = new SmartTipManager();
    protected Popup tipWindow;
    protected JPanelPopup jpanelPopup;
    protected PanelPopup panelPopup;
    protected WindowPopup windowPopup;
    protected JComponent diagHidden;
    protected boolean lightWeightPopupEnabled = true;
    public static FontMetrics fm;
    protected boolean reshowPopup;
    protected boolean tipShowing;
    protected boolean inTip;
    protected Vector ears;
    protected int minWidth;
    static /* synthetic */ Class class$java$awt$Window;
    static /* synthetic */ Class class$javax$swing$JRootPane;

    public SmartTipManager() {
        this.moveTimer = new Timer(500, this);
        this.moveTimer.setRepeats(false);
        this.ears = new Vector();
        this.reshowPopup = true;
        this.tipShowing = false;
    }

    public void setLightWeightPopupEnabled(boolean bl) {
        this.lightWeightPopupEnabled = bl;
    }

    public boolean isLightWeightPopupEnabled() {
        return this.lightWeightPopupEnabled;
    }

    public boolean isDiagnosisVisible() {
        return this.tipWindow != null && this.tipWindow.isVisible();
    }

    protected boolean parentWindowActive(Object object) {
        Container container = (Container)object;
        while (container != null) {
            if (container instanceof Window && ((Window)container).getFocusOwner() != null) {
                return true;
            }
            container = container.getParent();
        }
        return false;
    }

    protected void showTipWindow(JComponent jComponent, SmartTip smartTip, Rectangle rectangle) {
        if (jComponent != null && jComponent.isShowing() && this.parentWindowActive(jComponent) && jComponent.getRootPane().getLayeredPane().getComponentCountInLayer(JLayeredPane.PALETTE_LAYER) == 0) {
            Dimension dimension = new Dimension(rectangle.width + 1, rectangle.height + 1);
            if (this.tipShowing) {
                this.hideDiagnosis();
            }
            this.diagHidden = null;
            if (this.windowPopup != null) {
                this.windowPopup.disappear();
                this.windowPopup.dispose();
                this.windowPopup = null;
            }
            if (this.lightWeightPopupEnabled) {
                if (this.jpanelPopup == null) {
                    this.jpanelPopup = new JPanelPopup();
                }
                this.tipWindow = this.jpanelPopup;
            } else {
                if (this.panelPopup == null) {
                    this.panelPopup = new PanelPopup();
                }
                this.tipWindow = this.panelPopup;
            }
            if (!AssistManager.popupFit(rectangle, jComponent)) {
                Window window = (Window)SwingUtilities.getAncestorOfClass(class$java$awt$Window == null ? (class$java$awt$Window = SmartTipManager.class$("java.awt.Window")) : class$java$awt$Window, jComponent);
                this.windowPopup = new WindowPopup(window);
                this.tipWindow = this.windowPopup;
            }
            if (this.jpanelPopup != null && this.jpanelPopup.isVisible() && this.jpanelPopup != this.tipWindow) {
                this.jpanelPopup.disappear();
            }
            if (this.panelPopup != null && this.panelPopup.isVisible() && this.panelPopup != this.tipWindow) {
                this.panelPopup.disappear();
            }
            if (this.windowPopup != null && this.windowPopup.isVisible() && this.windowPopup != this.tipWindow) {
                this.windowPopup.disappear();
                this.windowPopup.dispose();
                this.windowPopup = null;
            }
            smartTip.setVisible(true);
            this.tipWindow.appear(smartTip, dimension, jComponent, rectangle.x + 1, rectangle.y + 1);
            this.tipShowing = true;
        }
    }

    public void hideDiagnosis() {
        if (this.isDiagnosisVisible()) {
            JComponent jComponent = this.tipWindow.getInvoker();
            if (jComponent instanceof SmartComponent) {
                if (!(((SmartComponent)((Object)jComponent)).allowLink() || ((SmartComponent)((Object)jComponent)).allowPopup() && jComponent instanceof SmartField && ((SmartField)jComponent).isPopupShowing())) {
                    this.tipWindow.disappear();
                    this.tipWindow = null;
                } else {
                    ((SmartComponent)((Object)jComponent)).setAllowPopup(false);
                    ((SmartComponent)((Object)jComponent)).setAllowLink(false);
                }
            } else {
                this.tipWindow.disappear();
                this.tipWindow = null;
            }
            this.tipShowing = false;
            this.reshowPopup = true;
        }
    }

    public static SmartTipManager sharedInstance() {
        return sharedInstance;
    }

    public void dispose() {
        if (this.tipShowing) {
            this.hideDiagnosis();
        }
        this.diagHidden = null;
        Iterator iterator = ((AbstractMap)this.tips).keySet().iterator();
        while (iterator.hasNext()) {
            JComponent jComponent = (JComponent)iterator.next();
            jComponent.removeFocusListener(this);
            jComponent.removeComponentListener(this);
            jComponent.removeAncestorListener(this);
            Component component = (Component)this.tips.get(jComponent);
            if (component instanceof SmartTip) {
                component.removeMouseListener(this);
                component.removeMouseMotionListener(this);
            }
            this.tips.remove(jComponent);
            this.directions.remove(jComponent);
        }
        this.moveTimer.removeActionListener(this);
    }

    public void showDiagnosis(JComponent jComponent, int n2, Diagnosis diagnosis) {
        if (diagnosis != null) {
            Frame frame = SmartTipManager.frameForComponent(jComponent);
            if (frame == null) {
                jComponent.removeFocusListener(this);
                jComponent.removeComponentListener(this);
                jComponent.removeAncestorListener(this);
                jComponent.addFocusListener(this);
                jComponent.addComponentListener(this);
                jComponent.addAncestorListener(this);
            } else {
                Object object;
                SmartTip smartTip = (SmartTip)this.tips.get(jComponent);
                if (smartTip == null) {
                    smartTip = new SmartTip();
                    smartTip.addLinkListener(this);
                    if (this.ears.size() > 0) {
                        object = this.ears.elements();
                        while (object.hasMoreElements()) {
                            smartTip.addLinkListener((LinkListener)object.nextElement());
                        }
                    }
                    this.tips.put(jComponent, smartTip);
                    if (smartTip instanceof SmartTip) {
                        smartTip.removeMouseListener(this);
                        smartTip.removeMouseMotionListener(this);
                        smartTip.addMouseListener(this);
                        smartTip.addMouseMotionListener(this);
                    }
                    jComponent.removeFocusListener(this);
                    jComponent.removeComponentListener(this);
                    jComponent.removeAncestorListener(this);
                    jComponent.addFocusListener(this);
                    jComponent.addComponentListener(this);
                    jComponent.addAncestorListener(this);
                }
                this.directions.put(jComponent, new Integer(n2));
                if (SmartManager.getDiagnosisPolicy() == 0 && jComponent.hasFocus() && jComponent.isShowing()) {
                    int n3;
                    object = frame.getGraphics();
                    int n4 = this.getTipWidth(jComponent, n2);
                    if (n4 <= (n3 = smartTip.getLeastWidth())) {
                        int n5 = n2 % 4 + 1;
                        while (n4 <= n3 && n5 != n2) {
                            n4 = this.getTipWidth(jComponent, n5);
                            n5 = n5 % 4 + 1;
                        }
                        if (n4 <= n3) {
                            return;
                        }
                        n2 = n5;
                    }
                    smartTip.configure((Graphics)object, n4, diagnosis);
                    JComponent jComponent2 = jComponent;
                    String string = SmartManager.translateHtml(diagnosis.taggedString());
                    AccessibleContext accessibleContext = jComponent2.getAccessibleContext();
                    if (accessibleContext != null) {
                        accessibleContext.setAccessibleDescription(string);
                    }
                    if ((accessibleContext = smartTip.getAccessibleContext()) != null) {
                        accessibleContext.setAccessibleDescription(string);
                    }
                    if (jComponent2.getParent().getParent() instanceof JScrollPane) {
                        jComponent2 = (JComponent)jComponent2.getParent().getParent();
                    }
                    Rectangle rectangle = this.getTipBounds(jComponent2, n2, smartTip);
                    this.showTipWindow(jComponent, smartTip, rectangle);
                } else if (jComponent.isShowing()) {
                    object = frame.getGraphics();
                    int n6 = this.getTipWidth(jComponent, n2);
                    smartTip.configure((Graphics)object, n6, diagnosis);
                } else {
                    smartTip.configure(frame.getGraphics(), 400, diagnosis);
                }
            }
        }
    }

    protected int getTipWidth(JComponent jComponent, int n2) {
        if (fm == null) {
            fm = SmartTipManager.frameForComponent(jComponent).getGraphics().getFontMetrics();
        }
        int n3 = 0;
        int n4 = this.minWidth;
        if (n4 == 0) {
            n4 = fm.getHeight() * 10;
        }
        int n5 = jComponent.getWidth();
        Point point = null;
        point = jComponent.isShowing() ? jComponent.getLocationOnScreen() : new Point();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        switch (n2) {
            case 4: {
                n3 = dimension.width - point.x - n5 - 7;
                n3 = n3 < n4 ? n4 : n3;
                break;
            }
            case 1: 
            case 2: {
                n3 = dimension.width - point.x;
                n5 = n5 < n4 ? n4 : n5;
                n3 = n3 < n5 ? n3 : n5;
                break;
            }
            default: {
                n3 = point.x;
                n4 = n4 < point.x - 3 ? point.x - 3 : n4;
                n3 = n3 < n4 ? n4 : n3;
            }
        }
        return n3;
    }

    protected Rectangle getTipBounds(JComponent jComponent, int n2, SmartTip smartTip) {
        if (jComponent == null || !jComponent.isShowing()) {
            return null;
        }
        Rectangle rectangle = new Rectangle();
        JRootPane jRootPane = (JRootPane)SwingUtilities.getAncestorOfClass(class$javax$swing$JRootPane == null ? (class$javax$swing$JRootPane = SmartTipManager.class$("javax.swing.JRootPane")) : class$javax$swing$JRootPane, jComponent);
        if (jRootPane != null && !jRootPane.isValid()) {
            jRootPane.validate();
        }
        Point point = null;
        point = jComponent.isShowing() ? jComponent.getLocationOnScreen() : new Point();
        if (fm == null) {
            fm = SmartTipManager.frameForComponent(jComponent).getGraphics().getFontMetrics();
        }
        Dimension dimension = smartTip.getPreferredSize();
        rectangle.width = dimension.width;
        rectangle.height = dimension.height;
        rectangle.x = 0;
        rectangle.y = 0;
        switch (n2) {
            case 4: {
                rectangle.x = point.x - 1 + jComponent.getWidth();
                rectangle.y = point.y - 1;
                break;
            }
            case 2: {
                rectangle.x = point.x - 1;
                rectangle.y = point.y - 1 + jComponent.getSize().height;
                break;
            }
            case 1: {
                rectangle.x = point.x - 1;
                rectangle.y = point.y - rectangle.height - 2;
                break;
            }
            default: {
                rectangle.x = point.x - rectangle.width - 1;
                rectangle.y = point.y - 1;
            }
        }
        return rectangle;
    }

    protected void reshowDiagnosis(JComponent jComponent) {
        if (jComponent.hasFocus() && jComponent.isShowing()) {
            SmartTip smartTip = (SmartTip)this.tips.get(jComponent);
            if (smartTip != null) {
                if (jComponent instanceof SmartComponent && ((SmartComponent)((Object)jComponent)).isValueValid()) {
                    return;
                }
                if (SmartManager.getDiagnosisPolicy() == 0) {
                    int n2 = (Integer)this.directions.get(jComponent);
                    JComponent jComponent2 = jComponent;
                    if (jComponent2.getParent().getParent() instanceof JScrollPane) {
                        jComponent2 = (JComponent)jComponent2.getParent().getParent();
                    }
                    Rectangle rectangle = this.getTipBounds(jComponent2, n2, smartTip);
                    this.showTipWindow(jComponent, smartTip, rectangle);
                }
            } else {
                int n3 = ((SmartComponent)((Object)jComponent)).getTipPosition();
                Diagnosis diagnosis = SmartUtil.getDiagnosis(jComponent);
                if (diagnosis != null && n3 != -1) {
                    this.showDiagnosis(jComponent, n3, diagnosis);
                }
            }
        }
    }

    public void focusGained(FocusEvent focusEvent) {
        if (!this.tipShowing && !this.inTip) {
            this.reshowDiagnosis((JComponent)focusEvent.getSource());
        }
        if (this.diagHidden != null && this.diagHidden != focusEvent.getSource()) {
            this.inTip = false;
            this.diagHidden = null;
        }
    }

    public void focusLost(FocusEvent focusEvent) {
        boolean bl;
        JComponent jComponent = (JComponent)focusEvent.getSource();
        boolean bl2 = jComponent instanceof SmartComponent ? !((SmartComponent)focusEvent.getSource()).allowPopup() : (bl = true);
        if (this.tipShowing && !focusEvent.isTemporary() && bl) {
            if (jComponent instanceof SmartComponent) {
                ((SmartComponent)((Object)jComponent)).setAllowPopup(false);
                ((SmartComponent)((Object)jComponent)).setAllowLink(false);
            }
            this.hideDiagnosis();
            this.diagHidden = jComponent;
        }
    }

    public void addLinkListener(LinkListener linkListener) {
        if (this.ears.indexOf(linkListener) == -1) {
            this.ears.addElement(linkListener);
        }
        Iterator iterator = ((AbstractMap)this.tips).values().iterator();
        while (iterator.hasNext()) {
            ((LinkComponent)iterator.next()).addLinkListener(linkListener);
        }
    }

    public void removeLinkListener(LinkListener linkListener) {
        int n2 = this.ears.indexOf(linkListener);
        if (n2 > -1) {
            this.ears.removeElementAt(n2);
        }
    }

    public void linkStateChanged(LinkEvent linkEvent) {
        JComponent jComponent;
        if (linkEvent.getEventType() == 1001) {
            JComponent jComponent2 = this.tipWindow.getInvoker();
            if (jComponent2 instanceof SmartComponent) {
                ((SmartComponent)((Object)jComponent2)).setAllowLink(true);
            }
        } else if (linkEvent.getEventType() == 1002 && (jComponent = this.tipWindow.getInvoker()) instanceof SmartComponent) {
            ((SmartComponent)((Object)jComponent)).setAllowLink(false);
        }
    }

    public void componentHidden(ComponentEvent componentEvent) {
        if (this.tipShowing) {
            this.hideDiagnosis();
        }
    }

    public void componentMoved(ComponentEvent componentEvent) {
        if (!this.tipShowing && this.tipWindow instanceof WindowPopup) {
            this.reshowDiagnosis((JComponent)componentEvent.getSource());
        }
    }

    public void componentResized(ComponentEvent componentEvent) {
        if (this.tipShowing) {
            this.reshowDiagnosis((JComponent)componentEvent.getSource());
        }
    }

    public void componentShown(ComponentEvent componentEvent) {
        if (!this.tipShowing && this.tipWindow instanceof WindowPopup) {
            this.reshowDiagnosis((JComponent)componentEvent.getSource());
        }
    }

    public void ancestorAdded(AncestorEvent ancestorEvent) {
        if (!this.tipShowing) {
            this.reshowDiagnosis((JComponent)ancestorEvent.getSource());
        }
    }

    public void ancestorRemoved(AncestorEvent ancestorEvent) {
        if (this.tipShowing) {
            this.hideDiagnosis();
        }
        this.diagHidden = null;
    }

    public void ancestorMoved(AncestorEvent ancestorEvent) {
        if (ancestorEvent.getSource() != ancestorEvent.getAncestor() && this.tipWindow instanceof WindowPopup) {
            this.moveTimer.restart();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.moveTimer && this.tipWindow != null) {
            this.reshowDiagnosis(this.tipWindow.getInvoker());
        }
    }

    public boolean showPopupMenu() {
        if (this.isDiagnosisVisible()) {
            Rectangle rectangle = this.tipWindow.getBounds();
            Point point = new Point(rectangle.width - 7, rectangle.height - 7);
            ((SmartComponent)((Object)this.tipWindow.getInvoker())).showPopup((Component)((Object)this.tipWindow), point);
            return true;
        }
        return false;
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        DiagnosisRenderer diagnosisRenderer;
        if (this.tipWindow != null && (diagnosisRenderer = (DiagnosisRenderer)this.tips.get(this.tipWindow.getInvoker())) != null && diagnosisRenderer instanceof SmartTip) {
            Point point = mouseEvent.getPoint();
            Dimension dimension = this.tipWindow.getSize();
            if (point.x > dimension.width - 14 && point.y > dimension.height - 14) {
                if (this.reshowPopup) {
                    this.reshowPopup = false;
                    JComponent jComponent = this.tipWindow.getInvoker();
                    if (jComponent instanceof SmartComponent && diagnosisRenderer instanceof SmartTip) {
                        ((SmartComponent)((Object)jComponent)).setAllowPopup(true);
                        ((SmartComponent)((Object)jComponent)).showPopup((Component)((Object)this.tipWindow), point);
                    }
                }
            } else {
                JComponent jComponent = this.tipWindow.getInvoker();
                if (jComponent instanceof SmartComponent && diagnosisRenderer instanceof SmartTip) {
                    ((SmartComponent)((Object)jComponent)).hidePopup();
                    this.reshowPopup = true;
                }
            }
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.tipShowing) {
            this.hideDiagnosis();
        }
        this.diagHidden = null;
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        if (this.tipWindow != null) {
            this.inTip = true;
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
        if (this.tipWindow != null) {
            this.inTip = false;
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    protected static Frame frameForComponent(JComponent jComponent) {
        Container container = jComponent;
        while (!(container instanceof Frame) & container != null) {
            container = container.getParent();
        }
        return (Frame)container;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

