/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common.smartx.support;

import com.ibm.db2.tools.common.smartx.event.Diagnosis;
import com.ibm.db2.tools.common.smartx.support.DiagnosisRenderer;
import com.ibm.db2.tools.common.smartx.support.SmartConstants;
import com.ibm.db2.tools.common.support.AssistRole;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Polygon;
import java.io.Serializable;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.UIManager;

public class SmartTip
extends DiagnosisRenderer
implements Serializable {
    private static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected Polygon arrow;

    public SmartTip() {
        this.setOpaque(true);
        this.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 8));
        Color color = UIManager.getColor("ToolTip.border");
        if (color == null) {
            color = Color.black;
        }
        this.setBorderColor(color);
        this.setForeground(UIManager.getColor("ToolTip.foreground"));
        this.setBackground(SmartConstants.SMARTTIP_BACKGROUND_COLOR);
        this.setFont(UIManager.getFont("ToolTip.font"));
    }

    public void configure(Graphics graphics, int n2, Diagnosis diagnosis) {
        if (graphics != null) {
            graphics.setFont(this.getFont());
            this.configure(graphics, diagnosis);
            if (this.multiLineMsg != null) {
                this.wrap(n2 - 5);
            }
            Dimension dimension = this.getPreferredSize();
            dimension.width = this.minWidth;
            this.setPreferredSize(dimension);
            this.arrow = new Polygon();
            this.arrow.addPoint(0, 0);
            this.arrow.addPoint(0, 6);
            this.arrow.addPoint(3, 3);
        }
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        Dimension dimension = this.getSize();
        Insets insets = this.getBorder().getBorderInsets(this);
        graphics.translate(dimension.width - insets.right - 1, dimension.height - insets.bottom - 7);
        graphics.drawPolygon(this.arrow);
        graphics.fillPolygon(this.arrow);
        graphics.translate(insets.right + 1 - dimension.width, insets.bottom + 7 - dimension.height);
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleSmartTip();
        }
        return this.accessibleContext;
    }

    protected class AccessibleSmartTip
    extends JComponent.AccessibleJComponent {
        private static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

        protected AccessibleSmartTip() {
            super(SmartTip.this);
        }

        public AccessibleRole getAccessibleRole() {
            return AssistRole.DIAGNOSIS_TEXT;
        }
    }
}

