/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common.smartx.support;

import com.ibm.db2.tools.common.AssistArea;
import com.ibm.db2.tools.common.AssistEllipsis;
import com.ibm.db2.tools.common.AssistField;
import com.ibm.db2.tools.common.AssistPassword;
import com.ibm.db2.tools.common.AssistSpinner;
import com.ibm.db2.tools.common.ViewTable;
import com.ibm.db2.tools.common.smartx.SmartArea;
import com.ibm.db2.tools.common.smartx.SmartCombo;
import com.ibm.db2.tools.common.smartx.SmartEllipsis;
import com.ibm.db2.tools.common.smartx.SmartField;
import com.ibm.db2.tools.common.smartx.SmartPassword;
import com.ibm.db2.tools.common.smartx.SmartSpinner;
import com.ibm.db2.tools.common.smartx.support.SmartComponent;
import com.ibm.db2.tools.common.smartx.support.SmartConstraints;
import com.ibm.db2.tools.common.smartx.support.SmartManager;
import com.ibm.db2.tools.common.smartx.support.SmartTableModel;
import com.ibm.db2.tools.common.smartx.support.SmartVerifier;
import com.ibm.db2.tools.common.smartx.support.VerifierUtil;
import com.ibm.db2.tools.common.support.AssistManager;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.EventObject;
import java.util.HashMap;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPasswordField;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.EventListenerList;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;

public class SmartTableCellEditor
implements Serializable,
TableCellEditor,
ItemListener {
    private static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected EventListenerList listenerList = new EventListenerList();
    protected transient ChangeEvent changeEvent = null;
    protected JComponent editorComponent;
    protected int clickCountToStart = 1;
    protected JTable table;
    protected boolean beep;
    protected HashMap editComps;
    protected StringBuffer key;
    protected StringBuffer valbuf;
    protected Object scope;
    static /* synthetic */ Class class$javax$swing$event$CellEditorListener;

    public SmartTableCellEditor(JTable jTable) {
        this(jTable, new SmartField());
    }

    public SmartTableCellEditor(JTable jTable, JTextField jTextField) {
        this.editorComponent = jTextField;
        this.table = jTable;
        this.construct();
    }

    public SmartTableCellEditor(JTable jTable, JPasswordField jPasswordField) {
        this.editorComponent = jPasswordField;
        this.table = jTable;
        this.construct();
    }

    public SmartTableCellEditor(JTable jTable, JCheckBox jCheckBox) {
        this.editorComponent = jCheckBox;
        jCheckBox.setOpaque(true);
        jCheckBox.setBorderPainted(true);
        this.table = jTable;
        jCheckBox.addItemListener(this);
        this.editorComponent.setBackground(UIManager.getColor("window"));
        this.construct();
    }

    public SmartTableCellEditor(JTable jTable, JComboBox jComboBox) {
        this.editorComponent = jComboBox;
        this.table = jTable;
        this.construct();
    }

    public SmartTableCellEditor(JTable jTable, JTextArea jTextArea) {
        this.editorComponent = jTextArea;
        this.table = jTable;
        this.construct();
    }

    public SmartTableCellEditor(JTable jTable, AssistEllipsis assistEllipsis) {
        this.editorComponent = assistEllipsis;
        this.table = jTable;
        this.construct();
    }

    public SmartTableCellEditor(JTable jTable, AssistSpinner assistSpinner) {
        this.editorComponent = assistSpinner;
        this.table = jTable;
        this.construct();
    }

    private void construct() {
        if (this.editorComponent instanceof AssistField) {
            ((AssistField)this.editorComponent).setNestedBorders(true);
        } else if (this.editorComponent instanceof AssistPassword) {
            ((AssistPassword)this.editorComponent).setNestedBorders(true);
        } else if (this.editorComponent instanceof AssistArea) {
            ((AssistArea)this.editorComponent).setNestedBorders(true);
        } else if (this.editorComponent instanceof AssistEllipsis) {
            ((AssistEllipsis)this.editorComponent).setNestedBorders(true);
        } else if (this.editorComponent instanceof AssistSpinner) {
            ((AssistSpinner)this.editorComponent).setNestedBorders(true);
            ((AssistSpinner)this.editorComponent).setBorder(null);
        } else {
            this.editorComponent.setBorder(null);
        }
        this.beep = AssistManager.getBeepPolicy();
        this.editComps = new HashMap(50);
        this.key = new StringBuffer();
        this.valbuf = new StringBuffer();
        this.scope = null;
    }

    public void setScope(Object object) {
        this.scope = object;
    }

    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n2, int n3) {
        int n4 = n2;
        TableModel tableModel = jTable.getModel();
        if (tableModel instanceof SmartTableModel) {
            n4 = ((SmartTableModel)tableModel).actualRow(n4);
        } else if (jTable instanceof ViewTable) {
            n4 = ((ViewTable)jTable).convertRowIndexToModel(n4);
        }
        int n5 = jTable.convertColumnIndexToModel(n3);
        this.key.setLength(0);
        this.key.append(n4).append('.').append(n5);
        JComponent jComponent = (JComponent)this.editComps.get(this.key.toString());
        if (this.editorComponent instanceof SmartField) {
            this.valbuf.setLength(0);
            if (object != null) {
                this.valbuf.append(object.toString());
            }
            if (jComponent == null) {
                jComponent = ((SmartField)this.editorComponent).clone(this.valbuf.toString());
                this.editComps.put(this.key.toString(), jComponent);
                if (((SmartField)jComponent).getConstraints().getType() != 0) {
                    if (this.beep) {
                        AssistManager.setBeepPolicy(false);
                    }
                    ((SmartField)jComponent).verify();
                    if (this.beep) {
                        AssistManager.setBeepPolicy(true);
                    }
                }
            } else {
                if (!((SmartField)jComponent).getText().equals(this.valbuf.toString())) {
                    ((SmartField)jComponent).setText(this.valbuf.toString());
                }
                if (((SmartField)jComponent).getConstraints().getType() != 0) {
                    ((SmartField)jComponent).verify();
                }
            }
            AssistManager.configureRendererComponent(jTable, this.scope, jComponent, false, false, n2, n3);
            ((SmartField)jComponent).setNestedBorders(true);
            return jComponent;
        }
        if (this.editorComponent instanceof SmartPassword) {
            this.valbuf.setLength(0);
            if (object != null && object instanceof char[]) {
                AssistManager.appendChars((char[])object, this.valbuf);
            } else if (object != null) {
                this.valbuf.append(object.toString());
            }
            if (jComponent == null) {
                jComponent = ((SmartPassword)this.editorComponent).clone(this.valbuf.toString());
                this.editComps.put(this.key.toString(), jComponent);
                if (((SmartPassword)jComponent).getConstraints().getType() != 0) {
                    if (this.beep) {
                        AssistManager.setBeepPolicy(false);
                    }
                    ((SmartPassword)jComponent).verify();
                    if (this.beep) {
                        AssistManager.setBeepPolicy(true);
                    }
                }
            } else {
                ((SmartPassword)jComponent).setText(this.valbuf.toString());
                if (((SmartPassword)jComponent).getConstraints().getType() != 0) {
                    ((SmartPassword)jComponent).verify();
                }
            }
            AssistManager.configureRendererComponent(jTable, this.scope, jComponent, false, false, n2, n3);
            ((SmartPassword)jComponent).setNestedBorders(true);
            return jComponent;
        }
        if (this.editorComponent instanceof SmartArea) {
            this.valbuf.setLength(0);
            if (object != null) {
                this.valbuf.append(object.toString());
            }
            if (jComponent == null) {
                jComponent = ((SmartArea)this.editorComponent).clone(this.valbuf.toString());
                this.editComps.put(this.key.toString(), jComponent);
                if (((SmartArea)jComponent).getConstraints().getType() != 0) {
                    if (this.beep) {
                        AssistManager.setBeepPolicy(false);
                    }
                    ((SmartArea)jComponent).verify();
                    if (this.beep) {
                        AssistManager.setBeepPolicy(true);
                    }
                }
            } else {
                if (!((SmartArea)jComponent).getText().equals(this.valbuf.toString())) {
                    ((SmartArea)jComponent).setText(this.valbuf.toString());
                }
                if (((SmartArea)jComponent).getConstraints().getType() != 0) {
                    ((SmartArea)jComponent).verify();
                }
            }
            AssistManager.configureRendererComponent(jTable, this.scope, jComponent, false, false, n2, n3);
            ((SmartArea)jComponent).setNestedBorders(true);
            return ((SmartArea)jComponent).getScrollPane();
        }
        if (this.editorComponent instanceof SmartCombo) {
            if (jComponent == null) {
                jComponent = ((SmartCombo)this.editorComponent).clone(((SmartTableModel)tableModel).getValuesAt(n2, n5));
                ((SmartCombo)jComponent).setSelectedIndex(((SmartTableModel)tableModel).getSelectedIndexAt(n2, n5));
                this.editComps.put(this.key.toString(), jComponent);
            }
            AssistManager.configureRendererComponent(jTable, this.scope, jComponent, false, false, n2, n3);
            return (SmartCombo)jComponent;
        }
        if (this.editorComponent instanceof JComboBox) {
            if (object != null) {
                ((JComboBox)this.editorComponent).setSelectedItem(object);
            } else {
                ((JComboBox)this.editorComponent).setSelectedIndex(0);
            }
            return this.editorComponent;
        }
        if (this.editorComponent instanceof JTextField || this.editorComponent instanceof JPasswordField) {
            this.valbuf.setLength(0);
            if (object != null) {
                this.valbuf.append(object.toString());
            }
            ((JTextField)this.editorComponent).setText(this.valbuf.toString());
            return this.editorComponent;
        }
        if (this.editorComponent instanceof SmartEllipsis) {
            if (jComponent == null) {
                jComponent = (SmartEllipsis)((SmartEllipsis)this.editorComponent).getRenderer(true, "");
                this.editComps.put(this.key.toString(), jComponent);
            }
            ((SmartEllipsis)jComponent).setTitle(jTable.getColumnName(n3));
            ((SmartEllipsis)jComponent).setNestedBorders(true);
            ((SmartEllipsis)jComponent).setValue(object);
            if (((SmartField)((SmartEllipsis)jComponent).getTextField()).getConstraints().getType() != 0) {
                if (this.beep) {
                    AssistManager.setBeepPolicy(false);
                }
                ((SmartEllipsis)jComponent).verify();
                if (this.beep) {
                    AssistManager.setBeepPolicy(true);
                }
            }
            return jComponent;
        }
        if (this.editorComponent instanceof AssistSpinner) {
            if (jComponent == null) {
                jComponent = (SmartSpinner)((SmartSpinner)this.editorComponent).getRenderer(true, "");
                this.editComps.put(this.key.toString(), jComponent);
            }
            if (object != null && object instanceof Number) {
                ((SmartSpinner)jComponent).setValue(((Number)object).longValue());
            } else {
                ((SmartSpinner)jComponent).setText(this.valbuf.toString());
            }
            ((SmartComponent)((Object)jComponent)).setBorder();
            if (((SmartSpinner)jComponent).getConstraints().getType() != 0) {
                if (this.beep) {
                    AssistManager.setBeepPolicy(false);
                }
                ((SmartSpinner)jComponent).verify();
                if (this.beep) {
                    AssistManager.setBeepPolicy(true);
                }
            }
            return jComponent;
        }
        if (this.editorComponent instanceof JCheckBox) {
            if (object == null) {
                object = Boolean.FALSE;
            }
            if (object instanceof Boolean) {
                ((JCheckBox)this.editorComponent).setSelected((Boolean)object);
            } else if (object instanceof String) {
                Boolean bl2 = new Boolean((String)object);
                ((JCheckBox)this.editorComponent).setSelected(bl2);
            } else {
                ((JCheckBox)this.editorComponent).setSelected(false);
            }
            this.editorComponent.setBorder(SmartManager.getBorder("Assist.nested.border", true, true, "STCEnntt"));
            return this.editorComponent;
        }
        return this.editorComponent;
    }

    public JComponent getEditingComponent() {
        return this.editorComponent;
    }

    public JComponent getEditingComponent(int n2, int n3) {
        TableModel tableModel = this.table.getModel();
        int n4 = n2;
        if (tableModel instanceof SmartTableModel) {
            n4 = ((SmartTableModel)tableModel).actualRow(n4);
        }
        int n5 = this.table.convertColumnIndexToModel(n3);
        this.key.setLength(0);
        this.key.append(n4).append('.').append(n5);
        JComponent jComponent = (JComponent)this.editComps.get(this.key.toString());
        if (jComponent == null) {
            Object object = ((SmartTableModel)tableModel).getValueAt(n2, n5);
            if (this.editorComponent instanceof SmartField) {
                jComponent = ((SmartField)this.editorComponent).clone(object == null ? "" : object.toString());
                this.editComps.put(this.key.toString(), jComponent);
                AssistManager.configureRendererComponent(this.table, this.scope, jComponent, false, false, n2, n3);
                ((SmartField)jComponent).setNestedBorders(true);
            } else if (this.editorComponent instanceof SmartPassword) {
                jComponent = ((SmartPassword)this.editorComponent).clone(object == null ? "" : object.toString());
                this.editComps.put(this.key.toString(), jComponent);
                AssistManager.configureRendererComponent(this.table, this.scope, jComponent, false, false, n2, n3);
                ((SmartPassword)jComponent).setNestedBorders(true);
            } else {
                if (this.editorComponent instanceof SmartArea) {
                    jComponent = ((SmartArea)this.editorComponent).clone(object == null ? "" : object.toString());
                    this.editComps.put(this.key.toString(), jComponent);
                    AssistManager.configureRendererComponent(this.table, this.scope, jComponent, false, false, n2, n3);
                    ((SmartArea)jComponent).setNestedBorders(true);
                    ((SmartArea)jComponent).getScrollPane().setBorder(null);
                    return ((SmartArea)jComponent).getScrollPane();
                }
                if (this.editorComponent instanceof SmartCombo) {
                    jComponent = ((SmartCombo)this.editorComponent).clone(((SmartTableModel)tableModel).getValuesAt(n2, n5));
                    ((SmartCombo)jComponent).setSelectedIndex(((SmartTableModel)tableModel).getSelectedIndexAt(n2, n5));
                    this.editComps.put(this.key.toString(), jComponent);
                    AssistManager.configureRendererComponent(this.table, this.scope, jComponent, false, false, n2, n3);
                } else {
                    if (this.editorComponent instanceof SmartEllipsis) {
                        jComponent = ((SmartEllipsis)this.editorComponent).getRenderer(true, object == null ? "" : object.toString());
                        this.editComps.put(this.key.toString(), jComponent);
                        AssistManager.configureRendererComponent(this.table, this.scope, jComponent, false, false, n2, n3);
                        ((SmartEllipsis)jComponent).setNestedBorders(true);
                        ((SmartEllipsis)jComponent).setTitle(this.table.getColumnName(n3));
                        ((SmartEllipsis)jComponent).setValue(object);
                        return jComponent;
                    }
                    if (this.editorComponent instanceof AssistSpinner) {
                        if (jComponent == null) {
                            jComponent = ((AssistSpinner)this.editorComponent).getRenderer(true, "");
                            this.editComps.put(this.key.toString(), jComponent);
                        }
                        AssistManager.configureRendererComponent(this.table, this.scope, jComponent, false, false, n2, n3);
                        ((SmartSpinner)jComponent).setNestedBorders(true);
                        if (object != null && object instanceof Number) {
                            ((SmartSpinner)jComponent).setValue(((Number)object).longValue());
                        } else {
                            ((SmartSpinner)jComponent).setText(object == null ? "" : object.toString());
                        }
                    }
                }
            }
        }
        return jComponent;
    }

    public void configureCellEditor(SmartConstraints smartConstraints, SmartVerifier smartVerifier) {
        if (this.editorComponent instanceof SmartComponent) {
            ((SmartComponent)((Object)this.editorComponent)).setConstraints(smartConstraints);
            if (smartConstraints != null && smartVerifier == null && smartConstraints.getType() > 0) {
                smartVerifier = VerifierUtil.getSharedVerifier(smartConstraints.getType());
            }
            ((SmartComponent)((Object)this.editorComponent)).addSmartVerifier(smartVerifier);
        }
    }

    public void configureCellEditor(SmartConstraints smartConstraints, SmartVerifier smartVerifier, int n2, int n3) {
        JComponent jComponent = this.getEditingComponent(n2, n3);
        if (jComponent instanceof SmartComponent) {
            ((SmartComponent)((Object)jComponent)).setConstraints(smartConstraints);
            if (smartConstraints != null && smartVerifier == null && smartConstraints.getType() > 0) {
                smartVerifier = VerifierUtil.getSharedVerifier(smartConstraints.getType());
            }
            ((SmartComponent)((Object)jComponent)).addSmartVerifier(smartVerifier);
            if (this.beep) {
                AssistManager.setBeepPolicy(false);
            }
            ((SmartComponent)((Object)jComponent)).verify();
            if (this.beep) {
                AssistManager.setBeepPolicy(true);
            }
        }
    }

    public void configureCellEditor(int n2, String string) {
        if (this.editorComponent instanceof SmartComponent) {
            SmartConstraints smartConstraints = ((SmartComponent)((Object)this.editorComponent)).getConstraints();
            if (smartConstraints == null) {
                smartConstraints = new SmartConstraints(string, true, n2);
                ((SmartComponent)((Object)this.editorComponent)).setConstraints(smartConstraints);
                ((SmartComponent)((Object)this.editorComponent)).addSmartVerifier(VerifierUtil.getSharedVerifier(n2));
            } else {
                smartConstraints.setType(n2);
                smartConstraints.setDescription(string);
            }
        }
    }

    public void configureCellEditor(int n2, int n3, String string) {
        if (this.editorComponent instanceof SmartComponent) {
            SmartConstraints smartConstraints = ((SmartComponent)((Object)this.editorComponent)).getConstraints();
            if (smartConstraints == null) {
                smartConstraints = new SmartConstraints(string, true, n2);
                ((SmartComponent)((Object)this.editorComponent)).setConstraints(smartConstraints);
                ((SmartComponent)((Object)this.editorComponent)).addSmartVerifier(VerifierUtil.getSharedVerifier(n2));
            } else {
                smartConstraints.setType(n2);
                smartConstraints.setDescription(string);
            }
            smartConstraints.setMaxLengthConstraint(n3);
        }
    }

    public void configureCellEditor(int n2, long l2, long l3, String string) {
        if (this.editorComponent instanceof SmartField) {
            SmartConstraints smartConstraints = ((SmartComponent)((Object)this.editorComponent)).getConstraints();
            if (smartConstraints == null) {
                smartConstraints = new SmartConstraints(string, true, n2);
                ((SmartComponent)((Object)this.editorComponent)).setConstraints(smartConstraints);
                ((SmartComponent)((Object)this.editorComponent)).addSmartVerifier(VerifierUtil.getSharedVerifier(n2));
            } else {
                smartConstraints.setType(n2);
                smartConstraints.setDescription(string);
            }
            smartConstraints.setNumericRangeConstraints(l2, l3);
        }
    }

    public void configureCellEditor(int n2, short s2, short s3, String string) {
        if (this.editorComponent instanceof SmartField) {
            SmartConstraints smartConstraints = ((SmartComponent)((Object)this.editorComponent)).getConstraints();
            if (smartConstraints == null) {
                smartConstraints = new SmartConstraints(string, true, n2);
                ((SmartComponent)((Object)this.editorComponent)).setConstraints(smartConstraints);
                ((SmartComponent)((Object)this.editorComponent)).addSmartVerifier(VerifierUtil.getSharedVerifier(n2));
            } else {
                smartConstraints.setType(n2);
                smartConstraints.setDescription(string);
            }
            smartConstraints.setDecimalConstraints(s2, s3);
        }
    }

    public void configureCellEditor(int n2, short s2, String string) {
        if (this.editorComponent instanceof SmartField) {
            SmartConstraints smartConstraints = ((SmartComponent)((Object)this.editorComponent)).getConstraints();
            if (smartConstraints == null) {
                smartConstraints = new SmartConstraints(string, true, n2);
                ((SmartComponent)((Object)this.editorComponent)).setConstraints(smartConstraints);
                ((SmartComponent)((Object)this.editorComponent)).addSmartVerifier(VerifierUtil.getSharedVerifier(n2));
            } else {
                smartConstraints.setType(n2);
                smartConstraints.setDescription(string);
            }
            smartConstraints.setPrecisionConstraint(s2);
        }
    }

    public void configureCellEditor(int n2, String string, String string2) {
        if (this.editorComponent instanceof SmartField) {
            SmartConstraints smartConstraints = ((SmartComponent)((Object)this.editorComponent)).getConstraints();
            if (smartConstraints == null) {
                smartConstraints = new SmartConstraints(string2, true, n2);
                ((SmartComponent)((Object)this.editorComponent)).setConstraints(smartConstraints);
                ((SmartComponent)((Object)this.editorComponent)).addSmartVerifier(VerifierUtil.getSharedVerifier(n2));
            } else {
                smartConstraints.setType(n2);
                smartConstraints.setDescription(string2);
            }
            smartConstraints.setFormatConstraint(string);
        }
    }

    public void configureCellEditor(int n2, String string, int n3, int n4) {
        JComponent jComponent = this.getEditingComponent(n3, n4);
        if (jComponent instanceof SmartComponent) {
            SmartConstraints smartConstraints = ((SmartComponent)((Object)this.editorComponent)).getConstraints();
            if (smartConstraints == null) {
                smartConstraints = new SmartConstraints(string, true, n2);
                ((SmartComponent)((Object)this.editorComponent)).setConstraints(smartConstraints);
                ((SmartComponent)((Object)this.editorComponent)).addSmartVerifier(VerifierUtil.getSharedVerifier(n2));
            } else {
                smartConstraints.setType(n2);
                smartConstraints.setDescription(string);
            }
            if (this.beep) {
                AssistManager.setBeepPolicy(false);
            }
            ((SmartComponent)((Object)jComponent)).verify();
            if (this.beep) {
                AssistManager.setBeepPolicy(true);
            }
        }
    }

    public void configureCellEditor(int n2, int n3, String string, int n4, int n5) {
        JComponent jComponent = this.getEditingComponent(n4, n5);
        if (jComponent instanceof SmartComponent) {
            SmartConstraints smartConstraints = ((SmartComponent)((Object)this.editorComponent)).getConstraints();
            if (smartConstraints == null) {
                smartConstraints = new SmartConstraints(string, true, n2);
                ((SmartComponent)((Object)this.editorComponent)).setConstraints(smartConstraints);
                ((SmartComponent)((Object)this.editorComponent)).addSmartVerifier(VerifierUtil.getSharedVerifier(n2));
            } else {
                smartConstraints.setType(n2);
                smartConstraints.setDescription(string);
            }
            smartConstraints.setMaxLengthConstraint(n3);
            if (this.beep) {
                AssistManager.setBeepPolicy(false);
            }
            ((SmartComponent)((Object)jComponent)).verify();
            if (this.beep) {
                AssistManager.setBeepPolicy(true);
            }
        }
    }

    public void configureCellEditor(int n2, long l2, long l3, String string, int n3, int n4) {
        JComponent jComponent = this.getEditingComponent(n3, n4);
        if (jComponent instanceof SmartComponent) {
            SmartConstraints smartConstraints = ((SmartComponent)((Object)this.editorComponent)).getConstraints();
            if (smartConstraints == null) {
                smartConstraints = new SmartConstraints(string, true, n2);
                ((SmartComponent)((Object)this.editorComponent)).setConstraints(smartConstraints);
                ((SmartComponent)((Object)this.editorComponent)).addSmartVerifier(VerifierUtil.getSharedVerifier(n2));
            } else {
                smartConstraints.setType(n2);
                smartConstraints.setDescription(string);
            }
            smartConstraints.setNumericRangeConstraints(l2, l3);
            if (this.beep) {
                AssistManager.setBeepPolicy(false);
            }
            ((SmartComponent)((Object)jComponent)).verify();
            if (this.beep) {
                AssistManager.setBeepPolicy(true);
            }
        }
    }

    public void configureCellEditor(int n2, short s2, short s3, String string, int n3, int n4) {
        JComponent jComponent = this.getEditingComponent(n3, n4);
        if (jComponent instanceof SmartComponent) {
            SmartConstraints smartConstraints = ((SmartComponent)((Object)this.editorComponent)).getConstraints();
            if (smartConstraints == null) {
                smartConstraints = new SmartConstraints(string, true, n2);
                ((SmartComponent)((Object)this.editorComponent)).setConstraints(smartConstraints);
                ((SmartComponent)((Object)this.editorComponent)).addSmartVerifier(VerifierUtil.getSharedVerifier(n2));
            } else {
                smartConstraints.setType(n2);
                smartConstraints.setDescription(string);
            }
            smartConstraints.setDecimalConstraints(s2, s3);
            if (this.beep) {
                AssistManager.setBeepPolicy(false);
            }
            ((SmartComponent)((Object)jComponent)).verify();
            if (this.beep) {
                AssistManager.setBeepPolicy(true);
            }
        }
    }

    public void configureCellEditor(int n2, short s2, String string, int n3, int n4) {
        JComponent jComponent = this.getEditingComponent(n3, n4);
        if (jComponent instanceof SmartComponent) {
            SmartConstraints smartConstraints = ((SmartComponent)((Object)this.editorComponent)).getConstraints();
            if (smartConstraints == null) {
                smartConstraints = new SmartConstraints(string, true, n2);
                ((SmartComponent)((Object)this.editorComponent)).setConstraints(smartConstraints);
                ((SmartComponent)((Object)this.editorComponent)).addSmartVerifier(VerifierUtil.getSharedVerifier(n2));
            } else {
                smartConstraints.setType(n2);
                smartConstraints.setDescription(string);
            }
            smartConstraints.setPrecisionConstraint(s2);
            if (this.beep) {
                AssistManager.setBeepPolicy(false);
            }
            ((SmartComponent)((Object)jComponent)).verify();
            if (this.beep) {
                AssistManager.setBeepPolicy(true);
            }
        }
    }

    public void configureCellEditor(int n2, String string, String string2, int n3, int n4) {
        JComponent jComponent = this.getEditingComponent(n3, n4);
        if (jComponent instanceof SmartComponent) {
            SmartConstraints smartConstraints = ((SmartComponent)((Object)this.editorComponent)).getConstraints();
            if (smartConstraints == null) {
                smartConstraints = new SmartConstraints(string2, true, n2);
                ((SmartComponent)((Object)this.editorComponent)).setConstraints(smartConstraints);
                ((SmartComponent)((Object)this.editorComponent)).addSmartVerifier(VerifierUtil.getSharedVerifier(n2));
            } else {
                smartConstraints.setType(n2);
                smartConstraints.setDescription(string2);
            }
            smartConstraints.setFormatConstraint(string);
            if (this.beep) {
                AssistManager.setBeepPolicy(false);
            }
            ((SmartComponent)((Object)jComponent)).verify();
            if (this.beep) {
                AssistManager.setBeepPolicy(true);
            }
        }
    }

    public void clearEditorComponents() {
        this.editComps.clear();
    }

    public void updateUI() {
        this.editorComponent.updateUI();
    }

    public Object getCellEditorValue() {
        int n2 = this.table.getEditingRow();
        int n3 = this.table.getEditingColumn();
        int n4 = n2;
        TableModel tableModel = this.table.getModel();
        if (tableModel instanceof SmartTableModel) {
            n4 = ((SmartTableModel)tableModel).actualRow(n4);
        }
        int n5 = this.table.convertColumnIndexToModel(n3);
        this.key.setLength(0);
        this.key.append(n4).append('.').append(n5);
        JComponent jComponent = (JComponent)this.editComps.get(this.key.toString());
        if (jComponent == null) {
            jComponent = this.editorComponent;
        }
        if (this.editorComponent instanceof JComboBox) {
            return ((JComboBox)jComponent).getSelectedItem();
        }
        if (this.editorComponent instanceof JTextField) {
            return ((JTextField)jComponent).getText();
        }
        if (this.editorComponent instanceof JPasswordField) {
            return ((JPasswordField)jComponent).getPassword();
        }
        if (this.editorComponent instanceof SmartEllipsis) {
            return ((SmartEllipsis)jComponent).getValue();
        }
        if (this.editorComponent instanceof SmartSpinner) {
            return new Long(((SmartSpinner)jComponent).getValue());
        }
        if (this.editorComponent instanceof JTextArea) {
            return ((JTextArea)jComponent).getText();
        }
        if (this.editorComponent instanceof JCheckBox) {
            return new Boolean(((JCheckBox)this.editorComponent).isSelected());
        }
        return "";
    }

    public boolean isCellEditable(EventObject eventObject) {
        if (eventObject instanceof MouseEvent) {
            return ((MouseEvent)eventObject).getClickCount() >= this.clickCountToStart;
        }
        return true;
    }

    public boolean shouldSelectCell(EventObject eventObject) {
        return true;
    }

    public boolean stopCellEditing() {
        this.fireEditingStopped();
        return true;
    }

    public void cancelCellEditing() {
        this.fireEditingCanceled();
    }

    public void addCellEditorListener(CellEditorListener cellEditorListener) {
        this.listenerList.add(class$javax$swing$event$CellEditorListener == null ? (class$javax$swing$event$CellEditorListener = SmartTableCellEditor.class$("javax.swing.event.CellEditorListener")) : class$javax$swing$event$CellEditorListener, cellEditorListener);
    }

    public void removeCellEditorListener(CellEditorListener cellEditorListener) {
        this.listenerList.remove(class$javax$swing$event$CellEditorListener == null ? (class$javax$swing$event$CellEditorListener = SmartTableCellEditor.class$("javax.swing.event.CellEditorListener")) : class$javax$swing$event$CellEditorListener, cellEditorListener);
    }

    public void setClickCountToStart(int n2) {
        this.clickCountToStart = n2;
    }

    public int getClickCountToStart() {
        return this.clickCountToStart;
    }

    protected void fireEditingStopped() {
        Object[] objectArray = this.listenerList.getListenerList();
        int n2 = objectArray.length - 2;
        while (n2 >= 0) {
            if (objectArray[n2] == (class$javax$swing$event$CellEditorListener == null ? SmartTableCellEditor.class$("javax.swing.event.CellEditorListener") : class$javax$swing$event$CellEditorListener)) {
                if (this.changeEvent == null) {
                    this.changeEvent = new ChangeEvent(this);
                }
                ((CellEditorListener)objectArray[n2 + 1]).editingStopped(this.changeEvent);
            }
            n2 -= 2;
        }
    }

    protected void fireEditingCanceled() {
        Object[] objectArray = this.listenerList.getListenerList();
        int n2 = objectArray.length - 2;
        while (n2 >= 0) {
            if (objectArray[n2] == (class$javax$swing$event$CellEditorListener == null ? SmartTableCellEditor.class$("javax.swing.event.CellEditorListener") : class$javax$swing$event$CellEditorListener)) {
                if (this.changeEvent == null) {
                    this.changeEvent = new ChangeEvent(this);
                }
                ((CellEditorListener)objectArray[n2 + 1]).editingCanceled(this.changeEvent);
            }
            n2 -= 2;
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (this.table != null) {
            int n2 = this.table.getEditingRow();
            int n3 = this.table.getEditingColumn();
            this.table.setValueAt(this.getCellEditorValue(), n2, n3);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

