/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common.smartx.support;

import com.ibm.db2.tools.common.smartx.support.SmartComponent;
import com.ibm.db2.tools.common.smartx.support.SmartMenuItem;
import com.ibm.db2.tools.common.support.AssistManager;
import com.ibm.db2.tools.common.support.JPanelPopup;
import com.ibm.db2.tools.common.support.PanelPopup;
import com.ibm.db2.tools.common.support.Popup;
import com.ibm.db2.tools.common.support.WindowPopup;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JApplet;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JWindow;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SingleSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class SmartPopup
extends JPopupMenu {
    private static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected Component invoker;
    protected Popup popup;
    protected Frame frame;
    protected String label = null;
    protected boolean paintBorder = true;
    protected Insets margin = null;
    protected int desiredLocationX;
    protected int desiredLocationY;
    protected int lastPopupType = 0;
    static Hashtable appContextTable = new Hashtable(2);
    protected static final Object heavyPopupCacheKey = new StringBuffer("SmartPopup.heavyPopupCache");
    protected static final Object lightPopupCacheKey = new StringBuffer("SmartPopup.lightPopupCache");
    protected static final Object mediumPopupCacheKey = new StringBuffer("SmartPopup.mediumPopupCache");
    protected static final Object defaultLWPopupEnabledKey = new StringBuffer("SmartPopup.defaultLWPopupEnabledKey");
    protected static final int MAX_CACHE_SIZE = 5;
    protected boolean lightWeightPopupEnabled = true;
    protected static final int LIGHT_WEIGHT_POPUP = 0;
    protected static final int MEDIUM_WEIGHT_POPUP = 1;
    protected static final int HEAVY_WEIGHT_POPUP = 2;
    private static final Object classLock = new Object();
    private static boolean solaris = false;

    public SmartPopup() {
        this(null);
    }

    public SmartPopup(String string) {
        super(string);
        String string2 = System.getProperty("os.name").toUpperCase();
        if (string2.startsWith("SOLARIS") || string2.startsWith("SUN")) {
            solaris = true;
        }
    }

    public JMenuItem add(String string) {
        return super.add(new SmartMenuItem(string));
    }

    protected JMenuItem createActionComponent(Action action) {
        SmartMenuItem smartMenuItem = new SmartMenuItem((String)action.getValue("Name"), (Icon)action.getValue("SmallIcon")){

            protected PropertyChangeListener createActionPropertyChangeListener(Action action) {
                PropertyChangeListener propertyChangeListener = SmartPopup.super.createActionChangeListener(this);
                if (propertyChangeListener == null) {
                    propertyChangeListener = super.createActionPropertyChangeListener(action);
                }
                return propertyChangeListener;
            }
        };
        smartMenuItem.setHorizontalTextPosition(4);
        smartMenuItem.setVerticalTextPosition(0);
        smartMenuItem.setEnabled(action.isEnabled());
        return smartMenuItem;
    }

    public void addSeparator() {
        super.add(new SmartSeparator());
    }

    public void insertSeparator(int n2) {
        super.add((Component)new SmartSeparator(), n2);
    }

    public static void setDefaultLightWeightPopupEnabled(boolean bl) {
        appContextTable.put(defaultLWPopupEnabledKey, new Boolean(bl));
    }

    public static boolean getDefaultLightWeightPopupEnabled() {
        Boolean bl = (Boolean)appContextTable.get(defaultLWPopupEnabledKey);
        if (bl == null) {
            appContextTable.put(defaultLWPopupEnabledKey, Boolean.TRUE);
            return true;
        }
        return bl;
    }

    protected static Hashtable getHeavyPopupCache() {
        Hashtable hashtable = (Hashtable)appContextTable.get(heavyPopupCacheKey);
        if (hashtable == null) {
            hashtable = new Hashtable(2);
            appContextTable.put(heavyPopupCacheKey, hashtable);
        }
        return hashtable;
    }

    protected static Vector getLightPopupCache() {
        Vector vector = (Vector)appContextTable.get(lightPopupCacheKey);
        if (vector == null) {
            vector = new Vector();
            appContextTable.put(lightPopupCacheKey, vector);
        }
        return vector;
    }

    protected static Vector getMediumPopupCache() {
        Vector vector = (Vector)appContextTable.get(mediumPopupCacheKey);
        if (vector == null) {
            vector = new Vector();
            appContextTable.put(mediumPopupCacheKey, vector);
        }
        return vector;
    }

    protected static void recycleLightPopup(Popup popup) {
        Object object = classLock;
        synchronized (object) {
            Vector vector = SmartPopup.getLightPopupCache();
            if (vector.size() < 5) {
                vector.addElement(popup);
            }
        }
    }

    protected static Popup getRecycledLightPopupS() {
        Object object = classLock;
        synchronized (object) {
            Popup popup;
            Vector vector = SmartPopup.getLightPopupCache();
            if (vector.size() > 0 && (popup = (Popup)vector.elementAt(0)) instanceof Popup) {
                Popup popup2 = popup;
                vector.removeElementAt(0);
                Popup popup3 = popup2;
                return popup3;
            }
            popup = null;
            return popup;
        }
    }

    protected static void recycleMediumPopup(Popup popup) {
        Object object = classLock;
        synchronized (object) {
            Vector vector = SmartPopup.getMediumPopupCache();
            if (vector.size() < 5) {
                vector.addElement(popup);
            }
        }
    }

    protected static Popup getRecycledMediumPopupS() {
        Object object = classLock;
        synchronized (object) {
            Popup popup;
            Vector vector = SmartPopup.getMediumPopupCache();
            if (vector.size() > 0 && (popup = (Popup)vector.elementAt(0)) instanceof Popup) {
                Popup popup2 = popup;
                vector.removeElementAt(0);
                Popup popup3 = popup2;
                return popup3;
            }
            popup = null;
            return popup;
        }
    }

    protected static void recyclePopup(Popup popup) {
        if (popup instanceof JPanelPopup) {
            SmartPopup.recycleLightPopup(popup);
        } else if (popup instanceof PanelPopup) {
            SmartPopup.recycleMediumPopup(popup);
        }
    }

    public void setLightWeightPopupEnabled(boolean bl) {
        this.lightWeightPopupEnabled = bl;
    }

    public boolean isLightWeightPopupEnabled() {
        return this.lightWeightPopupEnabled;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String string) {
        String string2 = string;
        this.label = string;
        this.firePropertyChange("label", string2, string);
        if (this.accessibleContext != null) {
            this.accessibleContext.firePropertyChange("AccessibleVisibleData", string2, string);
        }
        this.invalidate();
        this.repaint();
    }

    protected void firePopupMenuWillBecomeVisible() {
        Object[] objectArray = this.listenerList.getListenerList();
        PopupMenuEvent popupMenuEvent = null;
        int n2 = objectArray.length - 2;
        while (n2 >= 0) {
            if (objectArray[n2] == AssistManager.getClass("PopupMenuListener")) {
                if (popupMenuEvent == null) {
                    popupMenuEvent = new PopupMenuEvent(this);
                }
                ((PopupMenuListener)objectArray[n2 + 1]).popupMenuWillBecomeVisible(popupMenuEvent);
            }
            n2 -= 2;
        }
    }

    public void pack() {
        if (this.popup != null) {
            this.popup.pack();
        }
    }

    protected Popup createLightWeightPopup() {
        Popup popup = SmartPopup.getRecycledLightPopupS();
        if (popup == null) {
            popup = new JPanelPopup();
        }
        return popup;
    }

    protected Popup createMediumWeightPopup() {
        Popup popup = SmartPopup.getRecycledMediumPopupS();
        if (popup == null) {
            popup = new PanelPopup();
        }
        return popup;
    }

    protected Popup createHeavyWeightPopup() {
        Window window = this.invoker != null ? (this.invoker instanceof Window ? (Window)this.invoker : SwingUtilities.getWindowAncestor(this.invoker)) : null;
        WindowPopup windowPopup = new WindowPopup(window);
        ((Window)windowPopup).setName("###overrideRedirect###");
        return windowPopup;
    }

    protected boolean ancestorIsDialog(Component component) {
        Container container = component.getParent();
        while (container != null) {
            if (container instanceof Dialog) {
                return true;
            }
            container = container.getParent();
        }
        return false;
    }

    protected void replacePopup(int n2) {
        this.popup.removeComponent(this);
        SmartPopup.recyclePopup(this.popup);
        switch (n2) {
            case 0: {
                this.popup = this.createLightWeightPopup();
                break;
            }
            case 1: {
                this.popup = this.createMediumWeightPopup();
                break;
            }
            case 2: {
                this.popup = this.createHeavyWeightPopup();
            }
        }
        this.popup.addComponent(this, "Center");
        this.setLocation(this.desiredLocationX, this.desiredLocationY);
        this.popup.setBackground(this.getBackground());
        this.popup.pack();
    }

    private boolean invokerInHeavyWeightPopupS(Component component) {
        if (component != null) {
            Container container = component.getParent();
            while (container != null) {
                if (container instanceof WindowPopup) {
                    return true;
                }
                if (container instanceof PanelPopup || container instanceof JPanelPopup || container instanceof JFrame || container instanceof JApplet || container instanceof JWindow || container instanceof JDialog) break;
                if (container instanceof Component && !(container instanceof JComponent)) {
                    return true;
                }
                container = container.getParent();
            }
        }
        return false;
    }

    public void setVisible(boolean bl) {
        Object object;
        if (bl == this.isVisible()) {
            return;
        }
        if (!bl) {
            this.getSelectionModel().clearSelection();
        } else if (this.isPopupMenu()) {
            if (this.getSubElements().length > 0) {
                object = new MenuElement[]{this, this.getSubElements()[0]};
                MenuSelectionManager.defaultManager().setSelectedPath((MenuElement[])object);
            } else {
                object = new MenuElement[]{this};
                MenuSelectionManager.defaultManager().setSelectedPath((MenuElement[])object);
            }
        }
        if (bl) {
            boolean bl2 = this.ancestorIsDialog(this.invoker);
            this.firePopupMenuWillBecomeVisible();
            switch (this.lastPopupType) {
                case 0: {
                    this.popup = this.createLightWeightPopup();
                    break;
                }
                case 1: {
                    this.popup = this.createMediumWeightPopup();
                    break;
                }
                case 2: {
                    this.popup = this.createHeavyWeightPopup();
                }
            }
            int n2 = this.lastPopupType;
            this.popup.addComponent(this, "Center");
            this.setLocation(this.desiredLocationX, this.desiredLocationY);
            this.popup.setBackground(this.getBackground());
            this.popup.pack();
            Rectangle rectangle = new Rectangle(this.desiredLocationX, this.desiredLocationY, this.popup.getWidth(), this.popup.getHeight());
            int n3 = this.invoker == null || this.invokerInHeavyWeightPopupS(this.invoker) ? 2 : (AssistManager.popupFit(rectangle, this.invoker) ? (this.isLightWeightPopupEnabled() && this.lightWeightPopupEnabled ? 0 : 1) : 2);
            if (n3 != n2) {
                this.replacePopup(n3);
                n2 = n3;
            }
            this.lastPopupType = n2;
            if (this.invoker instanceof JComponent) {
                this.popup.appear((JComponent)this.invoker);
            }
        } else if (this.popup != null) {
            object = this.popup.getInvoker();
            if (!((Component)object).hasFocus() && object instanceof SmartComponent) {
                ((SmartComponent)object).setAllowPopup(false);
                ((SmartComponent)object).setAllowLink(false);
                ((SmartComponent)object).setBorder();
            }
            this.firePopupMenuWillBecomeInvisible();
            this.closeCascades(this);
            this.popup.disappear();
            this.popup.removeComponent(this);
            SmartPopup.recyclePopup(this.popup);
            this.popup = null;
        }
        if (this.accessibleContext != null) {
            if (bl) {
                this.accessibleContext.firePropertyChange("AccessibleState", null, AccessibleState.VISIBLE);
            } else {
                this.accessibleContext.firePropertyChange("AccessibleState", AccessibleState.VISIBLE, null);
            }
        }
    }

    protected boolean parentIsHeavy() {
        Container container = null;
        if (this.getInvoker() != null) {
            container = this.getInvoker().getParent();
        }
        return container != null && container instanceof SmartPopup && container.getParent() != null && container.getParent() instanceof WindowPopup;
    }

    public boolean isVisible() {
        if (this.popup != null) {
            return this.popup.isShowing();
        }
        return false;
    }

    protected void closeCascades(JPopupMenu jPopupMenu) {
        Stack<Component> stack = new Stack<Component>();
        Component[] componentArray = jPopupMenu.getComponents();
        int n2 = componentArray.length - 1;
        while (n2 > -1) {
            if (componentArray[n2] instanceof JMenu && ((JMenu)componentArray[n2]).isPopupMenuVisible()) {
                stack.push(componentArray[n2]);
                componentArray = ((JMenu)componentArray[n2]).getMenuComponents();
                n2 = componentArray.length - 1;
                continue;
            }
            --n2;
        }
        while (stack.size() > 0) {
            ((JMenu)stack.pop()).setPopupMenuVisible(false);
        }
    }

    public void setLocation(int n2, int n3) {
        if (this.popup != null) {
            this.popup.setLocationOnScreen(n2, n3);
        }
        this.desiredLocationX = n2;
        this.desiredLocationY = n3;
    }

    protected boolean isPopupMenu() {
        return this.invoker != null && !(this.invoker instanceof JMenu);
    }

    public Component getInvoker() {
        return this.invoker;
    }

    public void setInvoker(Component component) {
        Component component2 = this.invoker;
        this.invoker = component;
        if (component2 != this.invoker && this.ui != null) {
            this.ui.uninstallUI(this);
            this.ui.installUI(this);
        }
        this.invalidate();
    }

    public void show(Component component, int n2, int n3) {
        this.setInvoker(component);
        Frame frame = SmartPopup.getFrame(component);
        if (frame != this.frame && frame != null) {
            this.frame = frame;
            if (this.popup != null) {
                this.setVisible(false);
            }
        }
        Point point = null;
        if (component != null) {
            if (!component.isShowing()) {
                return;
            }
            point = component.getLocationOnScreen();
            this.setLocation(point.x + n2, point.y + n3);
        } else {
            this.setLocation(n2, n3);
        }
        this.setVisible(true);
        if (this.popup instanceof JWindow) {
            Container container = this.getTopLevelAncestor();
            if (container != null) {
                container.requestFocus();
            }
            this.requestFocus();
        }
    }

    public SmartPopup getRootSmartPopup() {
        SmartPopup smartPopup = this;
        while (smartPopup != null && !smartPopup.isPopupMenu() && smartPopup.getInvoker() != null && smartPopup.getInvoker().getParent() != null && smartPopup.getInvoker().getParent() instanceof SmartPopup) {
            smartPopup = (SmartPopup)smartPopup.getInvoker().getParent();
        }
        return smartPopup;
    }

    public int getComponentIndex(Component component) {
        int n2 = this.getComponentCount();
        Component[] componentArray = this.getComponents();
        int n3 = 0;
        while (n3 < n2) {
            Component component2 = componentArray[n3];
            if (component2 == component) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    public Component getComponent(int n2) {
        int n3 = this.getComponentCount();
        if (n2 <= n3) {
            Component[] componentArray = this.getComponents();
            return componentArray[n2];
        }
        return null;
    }

    public void setPopupSize(Dimension dimension) {
        this.popup.setSize(dimension.width, dimension.height);
    }

    public void setPopupSize(int n2, int n3) {
        this.popup.setSize(n2, n3);
    }

    public void setSelected(Component component) {
        SingleSelectionModel singleSelectionModel = this.getSelectionModel();
        int n2 = this.getComponentIndex(component);
        singleSelectionModel.setSelectedIndex(n2);
    }

    public boolean isBorderPainted() {
        return this.paintBorder;
    }

    public void setBorderPainted(boolean bl) {
        this.paintBorder = bl;
        this.repaint();
    }

    protected void paintBorder(Graphics graphics) {
        if (this.isBorderPainted()) {
            super.paintBorder(graphics);
        }
    }

    public Insets getMargin() {
        if (this.margin == null) {
            return new Insets(0, 0, 0, 0);
        }
        return this.margin;
    }

    protected static Window getWindow(Component component) {
        Component component2 = component;
        while (!(component2 instanceof Window) && component2 != null) {
            component2 = component2.getParent();
        }
        return (Window)component2;
    }

    protected static Frame getFrame(Component component) {
        Component component2 = component;
        while (!(component2 instanceof Frame) && component2 != null) {
            component2 = component2.getParent();
        }
        return (Frame)component2;
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleSmartPopup();
        }
        return this.accessibleContext;
    }

    protected void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        Vector<Object> vector = new Vector<Object>();
        objectOutputStream.defaultWriteObject();
        if (this.invoker != null && this.invoker instanceof Serializable) {
            vector.addElement("invoker");
            vector.addElement(this.invoker);
        }
        if (this.popup != null && this.popup instanceof Serializable) {
            vector.addElement("popup");
            vector.addElement(this.popup);
        }
        if (this.frame != null && this.frame instanceof Serializable) {
            vector.addElement("frame");
            vector.addElement(this.frame);
        }
        objectOutputStream.writeObject(vector);
    }

    protected void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        Vector vector = (Vector)objectInputStream.readObject();
        int n2 = 0;
        int n3 = vector.size();
        if (n2 < n3 && vector.elementAt(n2).equals("invoker")) {
            this.invoker = (Component)vector.elementAt(++n2);
            ++n2;
        }
        if (n2 < n3 && vector.elementAt(n2).equals("popup")) {
            this.popup = (Popup)vector.elementAt(++n2);
            ++n2;
        }
        if (n2 < n3 && vector.elementAt(n2).equals("frame")) {
            this.frame = (Frame)vector.elementAt(++n2);
            ++n2;
        }
    }

    public void processMouseEvent(MouseEvent mouseEvent, MenuElement[] menuElementArray, MenuSelectionManager menuSelectionManager) {
    }

    public void processKeyEvent(KeyEvent keyEvent, MenuElement[] menuElementArray, MenuSelectionManager menuSelectionManager) {
    }

    public void menuSelectionChanged(boolean bl) {
        if (this.invoker instanceof JMenu) {
            JMenu jMenu = (JMenu)this.invoker;
            if (bl) {
                jMenu.setPopupMenuVisible(true);
            } else {
                jMenu.setPopupMenuVisible(false);
            }
        }
        if (this.isPopupMenu() && !bl) {
            this.setVisible(false);
        }
    }

    public MenuElement[] getSubElements() {
        Vector<Component> vector = new Vector<Component>();
        int n2 = this.getComponentCount();
        int n3 = 0;
        while (n3 < n2) {
            Component component = this.getComponent(n3);
            if (component instanceof MenuElement) {
                vector.addElement(component);
            }
            ++n3;
        }
        MenuElement[] menuElementArray = new MenuElement[vector.size()];
        n3 = 0;
        n2 = vector.size();
        while (n3 < n2) {
            menuElementArray[n3] = (MenuElement)vector.elementAt(n3);
            ++n3;
        }
        return menuElementArray;
    }

    public Component getComponent() {
        return this;
    }

    public boolean isFocusTraversable() {
        return false;
    }

    public boolean isRequestFocusEnabled() {
        return null != this.getRootSmartPopup().getParent();
    }

    protected class AccessibleSmartPopup
    extends JComponent.AccessibleJComponent {
        private final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

        protected AccessibleSmartPopup() {
            super(SmartPopup.this);
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.POPUP_MENU;
        }
    }

    public class SmartSeparator
    extends JSeparator {
        public SmartSeparator() {
            super(0);
            super.setEnabled(false);
        }

        public String getUIClassID() {
            return "PopupMenuSeparatorUI";
        }

        public boolean isFocusTraversable() {
            return false;
        }

        public boolean isRequestFocusEnabled() {
            return null != SmartPopup.this.getRootSmartPopup().getParent();
        }
    }
}

