/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common.smartx.support;

import com.ibm.db2.tools.common.smartx.support.SmartManager;
import com.ibm.db2.tools.common.smartx.support.SmartMenuItem;
import com.ibm.db2.tools.common.smartx.support.SmartPopup;
import com.ibm.db2.tools.common.support.Popup;
import java.awt.Component;
import java.awt.Container;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import javax.accessibility.AccessibleContext;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.UIManager;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.MenuItemUI;
import javax.swing.plaf.PopupMenuUI;

public class SmartMenu
extends JMenu
implements Serializable,
PopupMenuListener {
    protected SmartPopup smartPopup;

    public SmartMenu() {
        this("");
    }

    public SmartMenu(String string) {
        this.init(string, null);
        this.updateUI();
    }

    public SmartMenu(Action action) {
        this("");
        this.setAction(action);
    }

    public SmartMenu(String string, boolean bl) {
        this(string);
    }

    public void updateUI() {
        this.setUI((MenuItemUI)UIManager.getUI(this));
        if (this.smartPopup != null) {
            this.smartPopup.setUI((PopupMenuUI)UIManager.getUI(this.smartPopup));
        }
    }

    public void setMnemonic(int n2) {
        if (SmartManager.getUseMnemonicsPolicy()) {
            super.setMnemonic(n2);
        }
    }

    public void setMnemonic(char c2) {
        if (SmartManager.getUseMnemonicsPolicy()) {
            super.setMnemonic(c2);
        }
    }

    public void setAccelerator(KeyStroke keyStroke) {
        if (SmartManager.getUseAcceleratorsPolicy()) {
            super.setAccelerator(keyStroke);
        }
    }

    public boolean isPopupMenuVisible() {
        this.ensurePopupMenuCreated();
        return this.smartPopup.isVisible();
    }

    public void setPopupMenu(SmartPopup smartPopup) {
        if (this.smartPopup != null) {
            this.smartPopup.setVisible(false);
            this.smartPopup.removePopupMenuListener(this);
        }
        this.smartPopup = smartPopup;
        this.smartPopup.setInvoker(this);
        this.smartPopup.addPopupMenuListener(this);
    }

    private void ensurePopupMenuCreated() {
        if (this.smartPopup == null) {
            this.smartPopup = new SmartPopup();
            this.smartPopup.setInvoker(this);
            this.smartPopup.addPopupMenuListener(this);
        }
    }

    public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
    }

    public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
    }

    public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
        super.fireMenuCanceled();
    }

    public void remove(JMenuItem jMenuItem) {
        if (this.smartPopup != null) {
            this.smartPopup.remove(jMenuItem);
        }
    }

    public void remove(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("index less than zero.");
        }
        if (n2 > this.getItemCount()) {
            throw new IllegalArgumentException("index greater than the number of items.");
        }
        if (this.smartPopup != null) {
            this.smartPopup.remove(n2);
        }
    }

    public void remove(Component component) {
        if (this.smartPopup != null) {
            this.smartPopup.remove(component);
        }
    }

    public void removeAll() {
        if (this.smartPopup != null) {
            this.smartPopup.removeAll();
        }
    }

    public void setMenuLocation(int n2, int n3) {
        if (this.smartPopup != null) {
            this.smartPopup.setLocation(n2, n3);
        }
    }

    public JMenuItem add(JMenuItem jMenuItem) {
        AccessibleContext accessibleContext = jMenuItem.getAccessibleContext();
        accessibleContext.setAccessibleParent(this);
        this.ensurePopupMenuCreated();
        return this.smartPopup.add(jMenuItem);
    }

    public Component add(Component component) {
        AccessibleContext accessibleContext;
        if (component instanceof JComponent && (accessibleContext = ((JComponent)component).getAccessibleContext()) != null) {
            accessibleContext.setAccessibleParent(this);
        }
        this.ensurePopupMenuCreated();
        this.smartPopup.add(component);
        return component;
    }

    public Component add(Component component, int n2) {
        AccessibleContext accessibleContext;
        if (component instanceof JComponent && (accessibleContext = ((JComponent)component).getAccessibleContext()) != null) {
            accessibleContext.setAccessibleParent(this);
        }
        this.ensurePopupMenuCreated();
        this.smartPopup.add(component, n2);
        return component;
    }

    public JMenuItem add(String string) {
        return this.add(new SmartMenuItem(string));
    }

    public JMenuItem add(Action action) {
        SmartMenuItem smartMenuItem = new SmartMenuItem((String)action.getValue("Name"), (Icon)action.getValue("SmallIcon"));
        smartMenuItem.setHorizontalTextPosition(4);
        smartMenuItem.setVerticalTextPosition(0);
        smartMenuItem.setEnabled(action.isEnabled());
        smartMenuItem.addActionListener(action);
        this.add(smartMenuItem);
        PropertyChangeListener propertyChangeListener = this.createActionChangeListener(smartMenuItem);
        action.addPropertyChangeListener(propertyChangeListener);
        return smartMenuItem;
    }

    public void addSeparator() {
        this.ensurePopupMenuCreated();
        this.smartPopup.addSeparator();
    }

    public void insert(String string, int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("index less than zero.");
        }
        this.ensurePopupMenuCreated();
        this.smartPopup.insert(new JMenuItem(string), n2);
    }

    public JMenuItem insert(JMenuItem jMenuItem, int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("index less than zero.");
        }
        AccessibleContext accessibleContext = jMenuItem.getAccessibleContext();
        accessibleContext.setAccessibleParent(this);
        this.ensurePopupMenuCreated();
        this.smartPopup.insert(jMenuItem, n2);
        return jMenuItem;
    }

    public JMenuItem insert(Action action, int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("index less than zero.");
        }
        this.ensurePopupMenuCreated();
        SmartMenuItem smartMenuItem = new SmartMenuItem((String)action.getValue("Name"), (Icon)action.getValue("SmallIcon"));
        smartMenuItem.addActionListener(action);
        this.smartPopup.insert(smartMenuItem, n2);
        action.addPropertyChangeListener(new ActionChangedListener(smartMenuItem));
        return smartMenuItem;
    }

    public void insertSeparator(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("index less than zero.");
        }
        this.ensurePopupMenuCreated();
        this.smartPopup.insertSeparator(n2);
    }

    public JPopupMenu getPopupMenu() {
        this.ensurePopupMenuCreated();
        return this.smartPopup;
    }

    public int getMenuComponentCount() {
        int n2 = 0;
        if (this.smartPopup != null) {
            n2 = this.smartPopup.getComponentCount();
        }
        return n2;
    }

    public Component getMenuComponent(int n2) {
        if (this.smartPopup != null) {
            return this.smartPopup.getComponent(n2);
        }
        return null;
    }

    public Component[] getMenuComponents() {
        if (this.smartPopup != null) {
            return this.smartPopup.getComponents();
        }
        return new Component[0];
    }

    protected Component[] getDeepestComponents() {
        Component[] componentArray = this.smartPopup.getComponents();
        int n2 = this.getArmedItem(componentArray);
        while (n2 > -1 && componentArray[n2] instanceof JMenu && ((JMenu)componentArray[n2]).isPopupMenuVisible()) {
            componentArray = ((JMenu)componentArray[n2]).getMenuComponents();
            n2 = this.getArmedItem(componentArray);
        }
        return componentArray;
    }

    public void menuSelectionChanged(boolean bl) {
        super.menuSelectionChanged(bl);
        Container container = this.getParent();
        if (container != null) {
            container = container.getParent();
        }
        if (container instanceof Popup && !this.isFocusTraversable()) {
            ((Popup)((Object)container)).getInvoker().requestFocus();
        }
    }

    protected int getArmedItem(Component[] componentArray) {
        int n2 = componentArray.length;
        int n3 = 0;
        while (n3 < n2) {
            Component component = componentArray[n3];
            if (component.isEnabled() && component instanceof JMenuItem && ((JMenuItem)component).isArmed()) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    public MenuElement[] getSubElements() {
        if (this.smartPopup == null) {
            return new MenuElement[0];
        }
        MenuElement[] menuElementArray = new MenuElement[]{this.smartPopup};
        return menuElementArray;
    }

    private class ActionChangedListener
    implements PropertyChangeListener {
        private final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
        JMenuItem menuItem;

        ActionChangedListener(JMenuItem jMenuItem) {
            this.menuItem = jMenuItem;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (propertyChangeEvent.getPropertyName().equals("Name")) {
                String string2 = (String)propertyChangeEvent.getNewValue();
                this.menuItem.setText(string2);
            } else if (string.equals("enabled")) {
                Boolean bl = (Boolean)propertyChangeEvent.getNewValue();
                this.menuItem.setEnabled(bl);
            } else if (propertyChangeEvent.getPropertyName().equals("SmallIcon")) {
                Icon icon = (Icon)propertyChangeEvent.getNewValue();
                this.menuItem.setIcon(icon);
                this.menuItem.invalidate();
                this.menuItem.repaint();
            }
        }
    }
}

