/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common.smartx.support;

import com.ibm.db2.tools.common.smartx.support.SmartComponent;
import com.ibm.db2.tools.common.smartx.support.SmartManager;
import com.ibm.db2.tools.common.smartx.support.SmartResources;
import com.ibm.db2.tools.common.smartx.support.diagnoser.DiagnoserUtil;
import com.ibm.db2.tools.common.support.AssistManager;
import java.io.Serializable;
import java.util.BitSet;
import java.util.Hashtable;

public class SmartConstraints
implements Serializable {
    public static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static int ARRAY_INCREMENT = 10;
    protected Object[] constraints;
    protected SmartComponent smartComponent;

    public SmartConstraints() {
        this.constraints = new Object[ARRAY_INCREMENT * 2];
    }

    public SmartConstraints(boolean bl, Object object) {
        this(null, bl, object, 0);
    }

    public SmartConstraints(boolean bl, int n2) {
        this(null, bl, SmartManager.getDefaultText(new Integer(n2)), n2);
    }

    public SmartConstraints(boolean bl, Object object, int n2) {
        this(null, bl, object, n2);
    }

    public SmartConstraints(String string, boolean bl, Object object) {
        this(string, bl, object, 0);
    }

    public SmartConstraints(String string, boolean bl, int n2) {
        this(string, bl, SmartManager.getDefaultText(new Integer(n2)), n2);
    }

    public SmartConstraints(String string, boolean bl, Object object, int n2) {
        String[] stringArray;
        BitSet bitSet = new BitSet(5);
        if (bl) {
            bitSet.set(0);
        } else {
            bitSet.clear(0);
        }
        bitSet.set(1);
        bitSet.set(2);
        if (AssistManager.getBeepPolicy()) {
            bitSet.set(4);
        } else {
            bitSet.clear(4);
        }
        Integer n3 = new Integer(n2);
        Hashtable<Integer, Object> hashtable = new Hashtable<Integer, Object>(11);
        this.constraints = new Object[ARRAY_INCREMENT * 2];
        int n4 = 0;
        if (string != null) {
            this.constraints[n4++] = "TipDescription";
            this.constraints[n4++] = string;
        }
        this.constraints[n4++] = "Type";
        this.constraints[n4++] = n3;
        this.constraints[n4++] = "Flags";
        this.constraints[n4++] = bitSet;
        this.constraints[n4++] = "DefaultTable";
        this.constraints[n4++] = hashtable;
        char c2 = '\"';
        String string2 = (String)this.getConstraint("Delimiter");
        if (string2 != null && string2.length() > 0) {
            c2 = string2.charAt(0);
        }
        SmartConstraints smartConstraints = null;
        if ((n2 & 0x1F) == n2 && (n2 & 8) == 0 || (n2 & 0x1F0000) == n2 && (n2 & 0x40000) == 0) {
            stringArray = new Integer(12);
            boolean bl2 = bl && (n2 & 0x10) == 0;
            smartConstraints = new SmartConstraints(string, bl2, stringArray.intValue());
            smartConstraints.setMaxLengthConstraint(8);
            this.constraints[n4++] = "Qualifier.Constraints";
            this.constraints[n4++] = smartConstraints;
        }
        if (object == null) {
            object = this.getDefaultValue();
        }
        if (object != null) {
            hashtable.put(n3, object);
            if (smartConstraints != null) {
                stringArray = DiagnoserUtil.divideIdentifier(object.toString(), c2);
                smartConstraints.setDefaultValue(stringArray[0]);
                hashtable.put(n3, stringArray[1]);
            } else {
                hashtable.put(n3, object);
            }
        }
        if ((n2 & 0x1F) == n2) {
            int n5 = 8;
            if ((n2 & 2) > 0) {
                n5 = 18;
            }
            this.constraints[n4++] = "MaximumLength";
            this.constraints[n4++] = new Integer(n5);
        } else if ((n2 & 0x1F0000) == n2) {
            int n6 = 10;
            if ((n2 & 0x10000) > 0) {
                n6 = 128;
            }
            this.constraints[n4++] = "MaximumLength";
            this.constraints[n4++] = new Integer(n6);
        }
    }

    public void addConstraint(Object object, Object object2) {
        Object[] objectArray = this.constraints;
        synchronized (objectArray) {
            int n2 = this.constraints.length;
            int n3 = 0;
            while (n3 < n2) {
                if (this.constraints[n3] == null) break;
                n3 += 2;
            }
            if (n3 < n2) {
                this.constraints[n3++] = object;
                this.constraints[n3] = object2;
            } else {
                Object[] objectArray2 = new Object[n2 + ARRAY_INCREMENT];
                System.arraycopy(this.constraints, 0, objectArray2, 0, n2);
                objectArray2[n2++] = object;
                objectArray2[n2] = object2;
                this.constraints = objectArray2;
            }
        }
    }

    public void removeConstraint(Object object) {
        Object[] objectArray = this.constraints;
        synchronized (objectArray) {
            int n2 = this.constraints.length;
            int n3 = 0;
            while (n3 < n2) {
                if (this.constraints[n3].equals(object)) break;
                n3 += 2;
            }
            if (n3 < n2) {
                this.constraints[n3++] = null;
                this.constraints[n3] = null;
            }
        }
    }

    public Object getConstraint(Object object) {
        Object[] objectArray = this.constraints;
        synchronized (objectArray) {
            int n2 = this.constraints.length;
            int n3 = 0;
            while (n3 < n2) {
                if (this.constraints[n3] == null || this.constraints[n3].equals(object)) break;
                n3 += 2;
            }
            if (n3 < n2 && this.constraints[n3] != null) {
                Object object2 = this.constraints[++n3];
                return object2;
            }
            Object var6_6 = null;
            return var6_6;
        }
    }

    public void setConstraint(Object object, Object object2) {
        Object[] objectArray = this.constraints;
        synchronized (objectArray) {
            int n2 = this.constraints.length;
            Object object3 = null;
            int n3 = 0;
            while (n3 < n2) {
                if (this.constraints[n3] != null && this.constraints[n3].equals(object)) break;
                n3 += 2;
            }
            if (n3 < n2) {
                object3 = this.constraints[++n3];
                this.constraints[n3] = object2;
            } else {
                this.addConstraint(object, object2);
            }
            if (this.smartComponent != null && this.smartComponent instanceof SmartComponent) {
                this.smartComponent.constraintChanged(object, object3, object2);
            }
        }
    }

    public void setConstraintFlag(int n2, Boolean bl) {
        Object[] objectArray = this.constraints;
        synchronized (objectArray) {
            if (bl == null) {
                this.setConstraintFlag(n2, AssistManager.getBeepPolicy());
            } else {
                this.setConstraintFlag(n2, (boolean)bl);
            }
        }
    }

    public void setConstraintFlag(int n2, boolean bl) {
        Object[] objectArray = this.constraints;
        synchronized (objectArray) {
            BitSet bitSet;
            Object object = this.getConstraint("Flags");
            if (object == null) {
                bitSet = new BitSet(5);
                this.setConstraint("Flags", bitSet);
            } else {
                bitSet = (BitSet)object;
            }
            boolean bl2 = bitSet.get(n2);
            if (bl) {
                bitSet.set(n2);
            } else {
                bitSet.clear(n2);
            }
            if (this.smartComponent != null && this.smartComponent instanceof SmartComponent && bl2 != bl) {
                this.smartComponent.constraintFlagChanged(n2, bl);
            }
        }
    }

    public Boolean getConstraintFlag(int n2) {
        Object object = this.getConstraint("Flags");
        if (object == null) {
            return null;
        }
        if (((BitSet)object).get(n2)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public void setRequired(boolean bl) {
        this.setConstraintFlag(0, bl);
    }

    public boolean getRequired() {
        Object object = this.getConstraint("Flags");
        if (object == null) {
            return false;
        }
        return ((BitSet)object).get(0);
    }

    public void setType(int n2) {
        this.setConstraint("Type", new Integer(n2));
        if ((n2 & 0x1F) == n2 && (n2 & 8) == 0 || (n2 & 0x1F0000) == n2 && (n2 & 0x40000) == 0) {
            SmartConstraints smartConstraints = (SmartConstraints)this.getConstraint("Qualifier.Constraints");
            if (smartConstraints == null) {
                Integer n3 = new Integer(12);
                boolean bl = this.getRequired() && (n2 & 0x10) == 0;
                char c2 = '\"';
                String string = (String)this.getConstraint("Delimiter");
                if (string != null && string.length() > 0) {
                    c2 = string.charAt(0);
                }
                String[] stringArray = DiagnoserUtil.divideIdentifier(this.getDefaultString(), c2);
                smartConstraints = new SmartConstraints(this.getDescription(), bl, stringArray[0], n3);
                smartConstraints.setMaxLengthConstraint(8);
                this.setConstraint("Qualifier.Constraints", smartConstraints);
            }
        } else {
            this.removeConstraint("Qualifier.Constraints");
        }
    }

    public int getType() {
        Integer n2 = (Integer)this.getConstraint("Type");
        if (n2 == null) {
            return 0;
        }
        return n2;
    }

    public void setDescription(String string) {
        this.setConstraint("TipDescription", string);
    }

    public String getDescription() {
        String string = (String)this.getConstraint("TipDescription");
        if (string == null) {
            string = SmartResources.get(217);
        }
        return string;
    }

    public Object clone() {
        Object[] objectArray = this.constraints;
        synchronized (objectArray) {
            int n2 = this.constraints.length;
            SmartConstraints smartConstraints = new SmartConstraints();
            int n3 = 0;
            while (n3 < n2) {
                Object object = this.constraints[n3 + 1];
                if (object instanceof Hashtable) {
                    object = ((Hashtable)object).clone();
                } else if (object instanceof BitSet) {
                    object = ((BitSet)object).clone();
                }
                smartConstraints.setConstraint(this.constraints[n3], object);
                n3 += 2;
            }
            SmartConstraints smartConstraints2 = smartConstraints;
            return smartConstraints2;
        }
    }

    public void setDefaultValue(Object object) {
        Integer n2 = (Integer)this.getConstraint("Type");
        Integer n3 = (Integer)this.getConstraint("StringLengthType");
        this.setDefaultValue(n2, n3, object);
    }

    public void setDefaultValue(Integer n2, Object object) {
        Integer n3 = (Integer)this.getConstraint("StringLengthType");
        this.setDefaultValue(n2, n3, object);
    }

    public void setDefaultValue(Integer n2, Integer n3, Object object) {
        Object[] objectArray = this.constraints;
        synchronized (objectArray) {
            Object object2;
            Hashtable<Integer, Object> hashtable = (Hashtable<Integer, Object>)this.getConstraint("DefaultTable");
            if (hashtable == null) {
                hashtable = new Hashtable<Integer, Object>(11);
                this.setConstraint("DefaultTable", hashtable);
            }
            if ((object2 = this.getDefaultValue(n2, n3)) != null && object2.equals(object)) {
                return;
            }
            int n4 = -1;
            if (n2 != null) {
                n4 = n2;
            }
            if (n3 != null && n4 == 32) {
                hashtable.put(new Integer(32000 + n3), object);
            } else if ((n4 & 0x1F) == n4 && (n4 & 8) == 0 || (n4 & 0x1F0000) == n4 && (n4 & 0x40000) == 0) {
                char c2 = '\"';
                String string = (String)this.getConstraint("Delimiter");
                if (string != null && string.length() > 0) {
                    c2 = string.charAt(0);
                }
                String[] stringArray = DiagnoserUtil.divideIdentifier(object.toString(), c2);
                Integer n5 = new Integer(12);
                SmartConstraints smartConstraints = (SmartConstraints)this.getConstraint("Qualifier.Constraints");
                if (smartConstraints == null) {
                    boolean bl = this.getRequired() && (n4 & 0x10) == 0;
                    smartConstraints = new SmartConstraints(this.getDescription(), bl, stringArray[0], n5);
                    smartConstraints.setMaxLengthConstraint(8);
                    this.setConstraint("Qualifier.Constraints", smartConstraints);
                } else if (stringArray[0] != null) {
                    smartConstraints.setDefaultValue(n5, stringArray[0]);
                }
                if (stringArray[1] != null) {
                    hashtable.put(n2, stringArray[1]);
                } else {
                    hashtable.put(n2, object);
                }
            } else if (object != null) {
                hashtable.put(n2, object);
            }
        }
    }

    public String getDefaultString(Object object) {
        String string = null;
        Object object2 = this.getDefaultValue(object);
        if (object2 != null) {
            string = object2.toString();
        }
        return string;
    }

    public String getDefaultString(Integer n2, Integer n3) {
        String string = null;
        Object object = this.getDefaultValue(n2, n3);
        if (object != null) {
            string = object.toString();
        }
        return string;
    }

    public String getDefaultString() {
        String string = null;
        Object object = this.getDefaultValue();
        if (object != null) {
            string = object.toString();
        }
        return string;
    }

    public Object getDefaultValue(Object object) {
        Object[] objectArray = this.constraints;
        synchronized (objectArray) {
            SmartConstraints smartConstraints;
            String string = null;
            Hashtable hashtable = (Hashtable)this.getConstraint("DefaultTable");
            if (hashtable == null) {
                hashtable = new Hashtable(11);
                this.setConstraint("DefaultTable", hashtable);
            }
            Integer n2 = (Integer)this.getConstraint("StringLengthType");
            Object object2 = object;
            if (n2 != null && object2 instanceof Integer && (Integer)object2 == 32) {
                object2 = new Integer(32000 + n2);
            }
            if ((string = (String)hashtable.get(object2)) == null) {
                string = SmartManager.getDefaultText(object2);
            }
            if ((smartConstraints = (SmartConstraints)this.getConstraint("Qualifier.Constraints")) != null && string != null) {
                Object object3 = smartConstraints.getDefaultValue();
                if (object3 == null) {
                    String string2 = string.toString();
                    return string2;
                }
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(object3.toString()).append('.').append(string.toString());
                String string3 = stringBuffer.toString();
                return string3;
            }
            String string4 = string;
            return string4;
        }
    }

    public Object getDefaultValue(Integer n2, Integer n3) {
        if (n3 != null && n2 == 32) {
            return this.getDefaultValue(new Integer(32000 + n3));
        }
        return this.getDefaultValue(n2);
    }

    public Object getDefaultValue() {
        Integer n2 = (Integer)this.getConstraint("Type");
        Integer n3 = (Integer)this.getConstraint("StringLengthType");
        if (n3 != null && n2 == 32) {
            return this.getDefaultValue(new Integer(32000 + n3));
        }
        return this.getDefaultValue(n2);
    }

    public char getDelimiterChar(char c2) {
        Object object = this.getConstraint("Delimiter");
        if (object != null) {
            if (object instanceof String && ((String)object).length() > 0) {
                c2 = ((String)object).charAt(0);
            } else if (object instanceof Character) {
                c2 = ((Character)object).charValue();
            }
        }
        return c2;
    }

    public void setDecimalConstraints(short s2, short s3) {
        this.setConstraint("Precision", new Short(s2));
        this.setConstraint("Scale", new Short(s3));
    }

    public void setPrecisionConstraint(short s2) {
        this.setConstraint("Precision", new Short(s2));
    }

    public void setNumericRangeConstraints(long l2, long l3) {
        this.setConstraint("MinimumSize", new Long(l2));
        this.setConstraint("MaximumSize", new Long(l3));
        Object object = this.getDefaultValue();
        if (object == null) {
            this.setDefaultValue(String.valueOf(l2));
        } else {
            long l4 = 0L;
            if (object instanceof String) {
                try {
                    l4 = Long.valueOf((String)object);
                }
                catch (NumberFormatException numberFormatException) {
                    l4 = l2;
                }
            }
            if (l4 < l2) {
                this.setDefaultValue(String.valueOf(l2));
            } else if (l4 > l3) {
                this.setDefaultValue(String.valueOf(l3));
            }
        }
    }

    public void setNumericRangeConstraints(double d2, double d3) {
        this.setConstraint("MinimumDoubleSize", new Double(d2));
        this.setConstraint("MaximumDoubleSize", new Double(d3));
        Object object = this.getDefaultValue();
        if (object == null) {
            this.setDefaultValue(String.valueOf(d2));
        } else {
            double d4 = 0.0;
            if (object instanceof String) {
                try {
                    d4 = Double.valueOf((String)object);
                }
                catch (NumberFormatException numberFormatException) {
                    d4 = d2;
                }
            }
            if (d4 < d2) {
                this.setDefaultValue(String.valueOf(d2));
            } else if (d4 > d3) {
                this.setDefaultValue(String.valueOf(d3));
            }
        }
    }

    public void setNameLengthConstraints(int n2, int n3) {
        this.setConstraint("MinimumLength", new Integer(n2));
        this.setConstraint("MaximumLength", new Integer(n3));
    }

    public void setLengthTypeConstraints(int n2, int n3) {
        this.setConstraint("StringLengthType", new Integer(n2));
        if (n3 != 0) {
            this.setConstraint("Unit", new Integer(n3));
        }
    }

    public void setLengthConstraints(int n2, int n3) {
        this.setConstraint("MinimumLength", new Integer(n2));
        this.setConstraint("MaximumLength", new Integer(n3));
    }

    public void setMaxLengthConstraint(int n2) {
        this.setConstraint("MaximumLength", new Integer(n2));
    }

    public void setFormatConstraint(Object object) {
        this.setConstraint("Format", object);
    }

    public void setSystemConstraint(Object object) {
        this.setConstraint("System", object);
    }

    public void setQualifierConstraints(SmartConstraints smartConstraints) {
        this.setConstraint("Qualifier.Constraints", smartConstraints);
    }

    public void dump() {
        this.dump(1);
    }

    protected void dump(int n2) {
        int n3 = this.constraints.length;
        int n4 = 0;
        while (n4 < n3) {
            if (this.constraints[n4] != null) {
                int n5;
                if (this.constraints[n4].equals("Qualifier.Constraints")) {
                    n5 = 0;
                    while (n5 < n2) {
                        System.out.print("\t");
                        ++n5;
                    }
                    System.out.print("Qualifier.Constraints");
                    System.out.print(": ");
                    System.out.println(this.constraints[n4 + 1].hashCode());
                    ((SmartConstraints)this.constraints[n4 + 1]).dump(n2 + 1);
                } else {
                    n5 = 0;
                    while (n5 < n2) {
                        System.out.print("\t");
                        ++n5;
                    }
                    System.out.print(this.constraints[n4]);
                    System.out.print(": ");
                    System.out.println(this.constraints[n4 + 1]);
                }
            }
            n4 += 2;
        }
    }

    public void setSmartComponent(SmartComponent smartComponent) {
        this.smartComponent = smartComponent;
    }
}

