/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common.smartx.support;

import com.ibm.db2.tools.common.smartx.support.SmartComboModel;
import com.ibm.db2.tools.common.support.AssistCollator;
import com.ibm.db2.tools.common.support.AssistKey;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.AbstractListModel;

public class SmartComboBoxModel
extends AbstractListModel
implements SmartComboModel {
    private static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected int currentIndex;
    protected Vector cache;
    protected Vector keys;
    public static int UNSORTED = 0;
    public static int ASCENDING = 1;
    public static int DESCENDING = 2;
    protected int sortMode;

    public SmartComboBoxModel() {
        this.cache = new Vector();
        this.currentIndex = -1;
        this.sortMode = UNSORTED;
    }

    public SmartComboBoxModel(Vector vector) {
        if (vector != null) {
            this.cache = vector;
            this.currentIndex = vector.size() == 0 ? -1 : 0;
        } else {
            this.cache = new Vector();
            this.currentIndex = -1;
        }
        this.sortMode = UNSORTED;
    }

    public SmartComboBoxModel(Collection collection) {
        if (collection != null) {
            this.cache = new Vector(collection);
            this.currentIndex = collection.size() == 0 ? -1 : 0;
        } else {
            this.cache = new Vector();
            this.currentIndex = -1;
        }
        this.sortMode = UNSORTED;
    }

    public SmartComboBoxModel(Object[] objectArray) {
        this.cache = new Vector();
        this.cache.ensureCapacity(objectArray.length);
        int n2 = 0;
        int n3 = objectArray.length;
        while (n2 < n3) {
            this.cache.add(objectArray[n2]);
            ++n2;
        }
        if (this.getSize() > 0) {
            this.currentIndex = 0;
        }
        this.sortMode = UNSORTED;
    }

    public Vector getData() {
        if (this.sortMode != UNSORTED) {
            Vector vector = new Vector(this.cache.size());
            Enumeration enumeration = this.keys.elements();
            while (enumeration.hasMoreElements()) {
                vector.add(this.cache.get(((AssistKey)enumeration.nextElement()).getSourceIndex()));
            }
            return vector;
        }
        return this.cache;
    }

    public void setData(Vector vector) {
        this.setData(vector.elements());
    }

    public void setSelectedItem(Object object) {
        if (object == null) {
            this.currentIndex = -1;
        } else {
            int n2 = 0;
            Enumeration enumeration = this.cache.elements();
            while (enumeration.hasMoreElements()) {
                if (enumeration.nextElement().equals(object)) break;
                ++n2;
            }
            if (this.currentIndex != n2) {
                this.currentIndex = n2;
                this.fireContentsChanged(this, this.currentIndex, this.currentIndex);
            }
        }
    }

    public void removeItem(Object object) {
        this.removeElement(object);
    }

    public void removeItemAt(int n2) {
        this.removeElementAt(n2);
    }

    public void insertItemAt(Object object, int n2) {
        this.insertElementAt(object, n2);
    }

    public boolean contains(Object object) {
        Enumeration enumeration = this.cache.elements();
        while (enumeration.hasMoreElements()) {
            if (enumeration.nextElement() != object) continue;
            return true;
        }
        return false;
    }

    public Object getSelectedItem() {
        if (this.currentIndex > -1 && this.currentIndex < this.getSize()) {
            return this.cache.elementAt(this.currentIndex);
        }
        return null;
    }

    public int getSize() {
        return this.cache.size();
    }

    public Object getElementAt(int n2) {
        if (n2 < this.cache.size()) {
            return this.getSorted(n2);
        }
        return null;
    }

    public void setData(Enumeration enumeration) {
        if (this.getSize() != 0) {
            this.cache.removeAllElements();
            if (this.sortMode != UNSORTED) {
                this.keys.removeAllElements();
            }
        }
        if (enumeration == null || !enumeration.hasMoreElements()) {
            return;
        }
        int n2 = 0;
        while (enumeration.hasMoreElements()) {
            Object e2 = enumeration.nextElement();
            this.cache.add(e2);
            if (this.sortMode != UNSORTED) {
                this.keys.add(((AssistCollator)AssistCollator.getInstance()).getCollationKey(e2, n2));
            }
            ++n2;
        }
        if (this.sortMode != UNSORTED && this.keys.size() > 1) {
            this.sort();
        }
        this.currentIndex = 0;
        this.fireContentsChanged(this, 0, n2);
    }

    public void addElement(Object object) {
        int n2 = this.insertSorted(object);
        this.fireIntervalAdded(this, n2, n2);
    }

    public void removeElement(Object object) {
        int n2 = this.getSortedIndex(object);
        if (n2 != -1) {
            this.removeElementAt(n2);
        }
    }

    public void insertElementAt(Object object, int n2) {
        if (this.sortMode != UNSORTED) {
            this.addElement(object);
        } else {
            this.cache.insertElementAt(object, n2);
            this.fireIntervalAdded(this, n2, n2);
        }
    }

    public void removeElementAt(int n2) {
        n2 = this.removeSorted(n2);
        this.cache.removeElementAt(n2);
        if (this.getSize() == 0) {
            this.currentIndex = -1;
        } else if (this.currentIndex >= n2) {
            --this.currentIndex;
        }
        this.fireIntervalRemoved(this, n2, n2);
    }

    protected void sort() {
        Object[] objectArray = this.keys.toArray();
        Arrays.sort(objectArray);
        if (this.sortMode == DESCENDING) {
            int n2 = 0;
            int n3 = objectArray.length - 1;
            while (n3 > -1) {
                this.keys.setElementAt(objectArray[n3], n2);
                --n3;
                ++n2;
            }
        } else {
            int n4 = objectArray.length;
            int n5 = 0;
            while (n5 < n4) {
                this.keys.setElementAt(objectArray[n5], n5);
                ++n5;
            }
        }
    }

    public void setSortingMode(int n2) {
        int n3 = this.sortMode;
        this.sortMode = n2;
        if (n3 != this.sortMode && this.cache.size() > 0 && this.sortMode != UNSORTED) {
            if (this.keys == null) {
                this.keys = new Vector();
                AssistCollator assistCollator = (AssistCollator)AssistCollator.getInstance();
                int n4 = this.cache.size() - 1;
                while (n4 > -1) {
                    this.keys.add(assistCollator.getCollationKey(this.cache.get(n4), n4));
                    --n4;
                }
            }
            if (this.keys.size() > 1) {
                this.sort();
            }
        }
    }

    protected int insertSorted(Object object) {
        int n2 = this.cache.size();
        if (this.sortMode != UNSORTED) {
            if (this.keys == null) {
                this.keys = new Vector();
            }
            this.cache.add(object);
            this.keys.add(((AssistCollator)AssistCollator.getInstance()).getCollationKey(object, n2));
            int n3 = this.keys.size();
            if (n3 > 1) {
                this.sort();
                this.fireContentsChanged(this, 0, n3);
                int n4 = 0;
                while (n4 < n3) {
                    if (((AssistKey)this.keys.get(n4)).getSourceIndex() == n2) {
                        return n4;
                    }
                    ++n4;
                }
            }
        } else {
            this.cache.add(object);
        }
        return n2;
    }

    protected int getSortedIndex(Object object) {
        if (this.sortMode != UNSORTED) {
            int n2 = this.keys.size();
            int n3 = 0;
            while (n3 < n2) {
                AssistKey assistKey = (AssistKey)this.keys.get(n3);
                if (object == this.cache.elementAt(assistKey.getSourceIndex())) {
                    return n3;
                }
                ++n3;
            }
            return -1;
        }
        return this.cache.indexOf(object);
    }

    protected Object getSorted(int n2) {
        if (this.sortMode != UNSORTED) {
            return this.cache.elementAt(((AssistKey)this.keys.get(n2)).getSourceIndex());
        }
        return this.cache.elementAt(n2);
    }

    protected int removeSorted(int n2) {
        if (this.sortMode != UNSORTED) {
            int n3 = ((AssistKey)this.keys.get(n2)).getSourceIndex();
            this.keys.remove(n2);
            int n4 = this.keys.size();
            int n5 = 0;
            while (n5 < n4) {
                AssistKey assistKey = (AssistKey)this.keys.get(n5);
                int n6 = assistKey.getSourceIndex();
                if (n6 >= n3) {
                    assistKey.setSourceIndex(n6 - 1);
                }
                ++n5;
            }
            return n3;
        }
        return n2;
    }
}

