/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common.smartx.support;

import java.io.Serializable;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class HtmlSymbols
implements Serializable {
    private static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected static final String AMPER = "&";
    protected static final String HASH = "#";
    protected static final String SEMI = ";";
    protected static final String SLASH = "\\";
    protected static final String DIGITS = "0123456789";
    protected static Hashtable symTable = new Hashtable(200);

    public static char symbolToChar(String string) throws Exception {
        Character c2 = (Character)symTable.get(string);
        if (c2 == null) {
            throw new Exception(string);
        }
        return c2.charValue();
    }

    public static String symbolsToChars(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "&;#\\", true);
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (AMPER.equals(string2)) {
                if (stringTokenizer.hasMoreTokens()) {
                    String string3;
                    String string4 = stringTokenizer.nextToken();
                    if (HASH.equals(string4)) {
                        string2 = "&#";
                        if (!stringTokenizer.hasMoreTokens()) continue;
                        string4 = stringTokenizer.nextToken();
                        if (stringTokenizer.hasMoreTokens()) {
                            string3 = stringTokenizer.nextToken();
                            if (!SEMI.equals(string3)) continue;
                            if (HtmlSymbols.isDigits(string4)) {
                                stringBuffer.append((char)Integer.valueOf(string4).intValue());
                                continue;
                            }
                            stringBuffer.append(string2).append(string4).append(string3);
                            continue;
                        }
                        stringBuffer.append(string2).append(string4);
                        continue;
                    }
                    if (stringTokenizer.hasMoreTokens()) {
                        string3 = stringTokenizer.nextToken();
                        if (!SEMI.equals(string3)) continue;
                        try {
                            stringBuffer.append(HtmlSymbols.symbolToChar(string4));
                        }
                        catch (Exception exception) {
                            stringBuffer.append(string2).append(string4).append(string3);
                        }
                        continue;
                    }
                    stringBuffer.append(string2).append(string4);
                    continue;
                }
                stringBuffer.append(string2);
                continue;
            }
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    protected static boolean isDigits(String string) {
        if (string == null) {
            return false;
        }
        int n2 = string.length();
        if (n2 == 0) {
            return false;
        }
        int n3 = 0;
        while (n3 < n2) {
            char c2 = string.charAt(n3);
            if (DIGITS.indexOf(c2) == -1) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    static {
        symTable.put("AElig", new Character('\u00c6'));
        symTable.put("Aacute", new Character('\u00c1'));
        symTable.put("Acirc", new Character('\u00c2'));
        symTable.put("Agrave", new Character('\u00c0'));
        symTable.put("Aring", new Character('\u00c5'));
        symTable.put("Atilde", new Character('\u00c3'));
        symTable.put("Auml", new Character('\u00c4'));
        symTable.put("Ccedil", new Character('\u00c7'));
        symTable.put("ETH", new Character('\u00d0'));
        symTable.put("Eacute", new Character('\u00c9'));
        symTable.put("Ecirc", new Character('\u00ca'));
        symTable.put("Egrave", new Character('\u00c8'));
        symTable.put("Euml", new Character('\u00cb'));
        symTable.put("Iacute", new Character('\u00cd'));
        symTable.put("Icirc", new Character('\u00ce'));
        symTable.put("Igrave", new Character('\u00cc'));
        symTable.put("Iuml", new Character('\u00cf'));
        symTable.put("Ntilde", new Character('\u00d1'));
        symTable.put("Oacute", new Character('\u00d3'));
        symTable.put("Ocirc", new Character('\u00d4'));
        symTable.put("Ograve", new Character('\u00d2'));
        symTable.put("Oslash", new Character('\u00d8'));
        symTable.put("Otilde", new Character('\u00d5'));
        symTable.put("Ouml", new Character('\u00d6'));
        symTable.put("THORN", new Character('\u00de'));
        symTable.put("Uacute", new Character('\u00da'));
        symTable.put("Ucirc", new Character('\u00db'));
        symTable.put("Ugrave", new Character('\u00d9'));
        symTable.put("Uuml", new Character('\u00dc'));
        symTable.put("Yacute", new Character('\u00dd'));
        symTable.put("aacute", new Character('\u00e1'));
        symTable.put("acirc", new Character('\u00e2'));
        symTable.put("acute", new Character('\u00b4'));
        symTable.put("aelig", new Character('\u00e6'));
        symTable.put("agrave", new Character('\u00e0'));
        symTable.put("amp", new Character('&'));
        symTable.put("aring", new Character('\u00e5'));
        symTable.put("atilde", new Character('\u00e3'));
        symTable.put("auml", new Character('\u00e4'));
        symTable.put("brvbar", new Character('\u00a6'));
        symTable.put("ccedil", new Character('\u00e7'));
        symTable.put("cedil", new Character('\u00b8'));
        symTable.put("cent", new Character('\u00a2'));
        symTable.put("copy", new Character('\u00a9'));
        symTable.put("curren", new Character('\u00a4'));
        symTable.put("deg", new Character('\u00b0'));
        symTable.put("divide", new Character('\u00f7'));
        symTable.put("eacute", new Character('\u00e9'));
        symTable.put("ecirc", new Character('\u00ea'));
        symTable.put("egrave", new Character('\u00e8'));
        symTable.put("eth", new Character('\u00f0'));
        symTable.put("euml", new Character('\u00eb'));
        symTable.put("frac12", new Character('\u00bd'));
        symTable.put("frac14", new Character('\u00bc'));
        symTable.put("frac34", new Character('\u00be'));
        symTable.put("gt", new Character('>'));
        symTable.put("iacute", new Character('\u00ed'));
        symTable.put("iexcl", new Character('\u00a1'));
        symTable.put("igrave", new Character('\u00ec'));
        symTable.put("icirc", new Character('\u00ee'));
        symTable.put("iquest", new Character('\u00bf'));
        symTable.put("iuml", new Character('\u00ef'));
        symTable.put("laquo", new Character('\u00ab'));
        symTable.put("lt", new Character('<'));
        symTable.put("macr", new Character('\u00af'));
        symTable.put("mdash", new Character('\u2014'));
        symTable.put("micro", new Character('\u00b5'));
        symTable.put("middot", new Character('\u00b7'));
        symTable.put("nbsp", new Character('\u00a0'));
        symTable.put("not", new Character('\u00ac'));
        symTable.put("ntilde", new Character('\u00f1'));
        symTable.put("oacute", new Character('\u00f3'));
        symTable.put("ocirc", new Character('\u00f4'));
        symTable.put("ograve", new Character('\u00f2'));
        symTable.put("ordf", new Character('\u00aa'));
        symTable.put("ordm", new Character('\u00ba'));
        symTable.put("oslash", new Character('\u00f8'));
        symTable.put("otilde", new Character('\u00f5'));
        symTable.put("ouml", new Character('\u00f6'));
        symTable.put("para", new Character('\u00b6'));
        symTable.put("plusmn", new Character('\u00b1'));
        symTable.put("pound", new Character('\u00a3'));
        symTable.put("quot", new Character('\"'));
        symTable.put("raquo", new Character('\u00bb'));
        symTable.put("reg", new Character('\u00ae'));
        symTable.put("sect", new Character('\u00a7'));
        symTable.put("shy", new Character('\u00ad'));
        symTable.put("sup1", new Character('\u00b9'));
        symTable.put("sup2", new Character('\u00b2'));
        symTable.put("sup3", new Character('\u00b3'));
        symTable.put("szlig", new Character('\u00df'));
        symTable.put("thorn", new Character('\u00fe'));
        symTable.put("times", new Character('\u00d7'));
        symTable.put("uacute", new Character('\u00fa'));
        symTable.put("ucirc", new Character('\u00fb'));
        symTable.put("ugrave", new Character('\u00f9'));
        symTable.put("uml", new Character('\u00a8'));
        symTable.put("uuml", new Character('\u00fc'));
        symTable.put("yacute", new Character('\u00fd'));
        symTable.put("yen", new Character('\u00a5'));
        symTable.put("yuml", new Character('\u00ff'));
    }
}

