/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common.smartx.support;

import com.ibm.db2.tools.common.ComponentGroup;
import com.ibm.db2.tools.common.smartx.support.DiagnosisManager;
import com.ibm.db2.tools.common.smartx.support.DiagnosisModel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.Serializable;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class DiagnosisView
extends JDialog
implements MouseListener,
WindowListener,
ActionListener,
ListSelectionListener,
ComponentListener,
Serializable {
    private static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected DiagnosisModel model;
    protected DiagnosisManager manager;
    protected int prevRow;
    protected JList diagList;
    protected JScrollPane scrollPane;
    protected JButton bFix;
    protected JButton bShow;
    protected JButton bClose;

    public DiagnosisView(DiagnosisManager diagnosisManager, JFrame jFrame, String string) {
        super((Frame)null, false);
        this.setTitle(string);
        this.manager = diagnosisManager;
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        Insets insets = new Insets(5, 5, 0, 5);
        Insets insets2 = new Insets(5, 5, 5, 5);
        this.diagList = diagnosisManager.getList();
        this.scrollPane = diagnosisManager.getScrollPane();
        this.model = diagnosisManager.getModel();
        gridBagConstraints.insets = insets;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagLayout.setConstraints(this.scrollPane, gridBagConstraints);
        jPanel.add(this.scrollPane);
        this.bFix = new JButton("Fix");
        this.bShow = new JButton("Show");
        this.bClose = new JButton("Close");
        Box box = Box.createHorizontalBox();
        box.add(Box.createHorizontalGlue());
        box.add(this.bFix);
        box.add(Box.createHorizontalStrut(5));
        box.add(this.bShow);
        box.add(Box.createHorizontalStrut(5));
        box.add(this.bClose);
        Dimension dimension = this.bClose.getPreferredSize();
        int n2 = this.bShow.getPreferredSize().width;
        dimension.width = dimension.width < n2 ? n2 : dimension.width;
        n2 = this.bFix.getPreferredSize().width;
        dimension.width = dimension.width < n2 ? n2 : dimension.width;
        this.bClose.setPreferredSize(dimension);
        this.bShow.setPreferredSize(dimension);
        this.bFix.setPreferredSize(dimension);
        if (this.model.getSize() == 0) {
            this.bFix.setEnabled(false);
            this.bShow.setEnabled(false);
        }
        ComponentGroup componentGroup = new ComponentGroup();
        componentGroup.add(this.bClose, true);
        componentGroup.add(this.bFix);
        componentGroup.add(this.bShow);
        this.getRootPane().setDefaultButton(this.bClose);
        gridBagConstraints.insets = insets2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagLayout.setConstraints(box, gridBagConstraints);
        jPanel.add(box);
        this.getContentPane().add(jPanel);
        this.diagList.addMouseListener(this);
        this.diagList.addListSelectionListener(this);
        this.bFix.addActionListener(this);
        this.bShow.addActionListener(this);
        this.bClose.addActionListener(this);
        this.scrollPane.addComponentListener(this);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        Object object = mouseEvent.getSource();
        if (object == this.diagList) {
            int n2 = this.diagList.locationToIndex(mouseEvent.getPoint());
            int n3 = this.model.getSize();
            if (mouseEvent.getClickCount() >= 2 && n2 >= 0 && n2 < n3) {
                this.manager.openListener(n2);
            }
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        block5: {
            Object object;
            block6: {
                block4: {
                    object = actionEvent.getSource();
                    if (object != this.bClose) break block4;
                    ((Component)this).setVisible(false);
                    break block5;
                }
                if (object != this.bShow) break block6;
                int[] nArray = this.diagList.getSelectedIndices();
                int n2 = this.model.getSize();
                int n3 = nArray.length - 1;
                while (n3 > -1) {
                    if (nArray[n3] >= 0 && nArray[n3] < n2) {
                        this.manager.openListener(nArray[n3]);
                    }
                    --n3;
                }
                break block5;
            }
            if (object != this.bFix) break block5;
            int[] nArray = this.diagList.getSelectedIndices();
            int n4 = this.model.getSize();
            int n5 = nArray.length - 1;
            while (n5 > -1) {
                if (nArray[n5] >= 0 && nArray[n5] < n4) {
                    this.manager.fixListener(nArray[n5]);
                }
                --n5;
            }
        }
    }

    public void setSelectedIndex(int n2) {
        this.diagList.setSelectedIndex(n2);
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getSource() == this.diagList) {
            int n2 = this.diagList.getSelectedIndex();
            int n3 = this.model.getSize();
            if (n2 >= 0 && n2 < n3) {
                this.bFix.setEnabled(true);
                this.bShow.setEnabled(true);
                this.prevRow = n2;
            } else if (n3 > 0) {
                if (this.prevRow > n3 - 1) {
                    this.diagList.setSelectedIndex(n3 - 1);
                } else if (this.prevRow > -1) {
                    this.diagList.setSelectedIndex(this.prevRow);
                } else {
                    this.diagList.setSelectedIndex(0);
                }
            } else {
                this.bFix.setEnabled(false);
                this.bShow.setEnabled(false);
                this.prevRow = -1;
            }
        }
    }

    public void windowClosing(WindowEvent windowEvent) {
        ((Component)this).setVisible(false);
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentResized(ComponentEvent componentEvent) {
        this.manager.resizeList();
    }

    public void componentShown(ComponentEvent componentEvent) {
        this.diagList.requestFocus();
    }
}

