/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common.smartx.support;

import com.ibm.db2.tools.common.AppearanceManager;
import com.ibm.db2.tools.common.MultiLineEvent;
import com.ibm.db2.tools.common.MultiLineListener;
import com.ibm.db2.tools.common.smartx.event.Diagnosis;
import com.ibm.db2.tools.common.smartx.event.LinkEvent;
import com.ibm.db2.tools.common.smartx.event.LinkListener;
import com.ibm.db2.tools.common.smartx.support.HtmlSymbols;
import com.ibm.db2.tools.common.smartx.support.LinkComponent;
import com.ibm.db2.tools.common.smartx.support.SmartManager;
import com.ibm.db2.tools.common.support.AssistIndex;
import com.ibm.db2.tools.common.support.AssistManager;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.font.LineMetrics;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.BreakIterator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Stack;
import java.util.Vector;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.BorderFactory;
import javax.swing.FocusManager;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.EventListenerList;

public class DiagnosisRenderer
extends JComponent
implements Serializable,
LinkComponent,
MouseListener,
MouseMotionListener {
    private static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected static Hashtable imageCache;
    protected Vector ears;
    protected EventListenerList listenerList;
    protected Vector anchors;
    protected int focusAnchor;
    protected String curHref;
    public String multiLineMsg;
    protected int leastWidth;
    protected int indexOfLongest;
    protected Vector msgBucket;
    public Point loc;
    protected Font font;
    protected Font normalFont;
    protected Font boldFont;
    protected Font preFont;
    protected Font italFont;
    protected Font bolditalFont;
    protected Color borderColor;
    protected Color backColor;
    protected Color foreColor;
    protected Color linkColor;
    protected int maxWidth;
    protected int minWidth;
    protected Rectangle viewRect;
    protected Diagnosis gnosis;
    protected boolean hyperLinkPolicy;
    protected static String otherEndPunctuationMarks;
    protected Locale locale;
    protected StringBuffer lbuf;
    protected StringBuffer cbuf;
    protected StringBuffer dbuf;
    protected Stack inWhat;
    protected Stack fonts;
    protected Stack heights;
    protected AssistIndex position;
    protected int hangingIndent;
    protected float paragraphSpacing;
    static /* synthetic */ Class class$com$ibm$db2$tools$common$MultiLineListener;

    public static void putIcon(String string, Icon icon) {
        if (string == null) {
            throw new IllegalArgumentException("DiagnosisRenderer.putIcon--The key must not be null.");
        }
        if (icon == null) {
            throw new IllegalArgumentException("DiagnosisRenderer.putIcon--The image must not be null.");
        }
        if (!(icon instanceof Icon)) {
            throw new IllegalArgumentException("DiagnosisRenderer.putIcon--The image must be an Icon.");
        }
        if (imageCache == null) {
            imageCache = new Hashtable();
        }
        imageCache.put(string, icon);
    }

    public static Icon getIcon(String string) {
        if (string == null) {
            throw new IllegalArgumentException("DiagnosisRenderer.putIcon--The key must not be null.");
        }
        if (imageCache == null) {
            return null;
        }
        return (Icon)imageCache.get(string);
    }

    public DiagnosisRenderer() {
        this.setVisible(false);
        this.msgBucket = new Vector(23);
        this.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 4));
        this.leastWidth = 80;
        this.loc = new Point(0, 0);
        this.listenerList = new EventListenerList();
        this.anchors = new Vector();
        this.focusAnchor = 0;
        this.foreColor = UIManager.getColor("controlText");
        this.setForeground(this.foreColor);
        this.linkColor = Color.blue;
        this.hyperLinkPolicy = SmartManager.getHyperLinkPolicy();
        this.locale = AssistManager.getPreferredLanguage();
        this.lbuf = new StringBuffer();
        this.inWhat = new Stack();
        this.fonts = new Stack();
        this.heights = new Stack();
        this.hangingIndent = 0;
        this.paragraphSpacing = 1.0f;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        super.disableEvents(4L);
    }

    public void setHangingIndent(int n2) {
        this.hangingIndent = n2;
    }

    public int getHangingIndent() {
        return this.hangingIndent;
    }

    public void configure(Graphics graphics, Diagnosis diagnosis) {
        this.gnosis = diagnosis;
        Font font = null;
        if (graphics != null) {
            font = graphics.getFont();
        } else {
            font = this.getFont();
            if (font == null) {
                font = UIManager.getFont("Tooltip.font");
            }
        }
        this.setFonts(font);
        this.multiLineMsg = this.gnosis != null ? this.gnosis.taggedString() : null;
        this.loc.x = 0;
        this.loc.y = 0;
    }

    public void wrap(int n2) {
        if (this.multiLineMsg == null) {
            return;
        }
        if (n2 < this.leastWidth && this.multiLineMsg.indexOf(60) < 0) {
            this.msgBucket.setSize(0);
            this.msgBucket.addElement(this.multiLineMsg);
            this.font = this.normalFont;
            return;
        }
        this.maxWidth = n2;
        this.minWidth = 0;
        this.msgBucket.setSize(0);
        this.anchors.setSize(0);
        this.lbuf.setLength(0);
        BreakIterator breakIterator = BreakIterator.getLineInstance(this.locale);
        BreakIterator breakIterator2 = null;
        BreakIterator breakIterator3 = null;
        int n3 = 0;
        int n4 = 0;
        this.multiLineMsg = this.mdashes(this.multiLineMsg, this.lbuf);
        this.inWhat.clear();
        this.fonts.clear();
        this.heights.clear();
        this.font = this.fonts.push(this.normalFont);
        Insets insets = this.getInsets();
        int n5 = this.getLineHeight(this.multiLineMsg, this.normalFont);
        this.heights.push(new Integer(n5));
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        boolean bl = false;
        if (this.multiLineMsg.length() > 0) {
            int n9 = this.multiLineMsg.length();
            int n10 = 0;
            int n11 = DiagnosisRenderer.tagScan(this.multiLineMsg, n9, n10);
            while (n11 <= n9) {
                int n12;
                String string = this.multiLineMsg.substring(n10, n11);
                if (this.multiLineMsg.charAt(n10) == '<' || string.charAt(0) == '\n') {
                    int n13;
                    String string2 = "";
                    if (string.charAt(0) == '\n') {
                        n13 = 1;
                        string2 = "BR";
                    } else {
                        n13 = string.indexOf(32);
                        if (n13 == -1) {
                            n13 = string.length() - 1;
                        }
                        if (n13 > 1) {
                            string2 = string.substring(1, n13).toUpperCase();
                        }
                    }
                    if (this.supportedTag(string2)) {
                        if (this.lbuf.length() > 0) {
                            this.msgBucket.addElement(this.lbuf.toString());
                            this.lbuf.setLength(0);
                        }
                        if (string2.equalsIgnoreCase("BR")) {
                            this.removeBlanks();
                            if (!this.removeTag("<BR>") && !this.removeTag("<P>") && (n3 > this.indentWhat(this.inWhat) + n8 || this.onNewline(this.msgBucket.size()) && this.paragraphSpacing > 1.0f)) {
                                n6 = this.onNewline(this.msgBucket.size()) && this.paragraphSpacing > 1.0f ? (n6 += (int)((float)n5 * (this.paragraphSpacing - 1.0f))) : (n6 += Math.max(n5, n7));
                                n7 = 0;
                            }
                            if (this.minWidth < n3) {
                                this.minWidth = n3;
                            }
                            n3 = this.indentWhat(this.inWhat) + n8;
                            if (this.inWhat.empty() || !this.inWhat.peek().equals("PRE")) {
                                char c2 = this.multiLineMsg.charAt(n11);
                                while (n11 < this.multiLineMsg.length() && c2 != '\n' && Character.isWhitespace(c2)) {
                                    c2 = this.multiLineMsg.charAt(++n11);
                                }
                            }
                        } else if (string2.equalsIgnoreCase("P")) {
                            this.removeBlanks();
                            int n14 = 0;
                            if (!this.removeTag("<BR>") && !this.removeTag("<P>") && this.msgBucket.size() > 0 && n3 > this.indentWhat(this.inWhat) + n8) {
                                n14 = Math.max(n5, n7);
                                if (this.paragraphSpacing > 1.0f) {
                                    n14 += (int)((float)n5 * (this.paragraphSpacing - 1.0f));
                                }
                                n7 = 0;
                            }
                            if (this.removeTag("<DD>")) {
                                string2 = "DD";
                            } else {
                                if (this.minWidth < n3) {
                                    this.minWidth = n3;
                                }
                                n3 = this.indentWhat(this.inWhat) + n8;
                                n6 += n14;
                            }
                            n11 = this.skipBlanks(this.multiLineMsg, n11);
                        } else if (string2.equalsIgnoreCase("PRE")) {
                            this.removeBlanks();
                            this.font = this.fonts.push(this.preFont);
                            n5 = this.getLineHeight(this.multiLineMsg, this.font);
                            this.heights.push(new Integer(n5));
                            this.inWhat.push("PRE");
                            if (!this.removeTag("<BR>") && !this.removeTag("<P>") && n3 > this.indentWhat(this.inWhat) + n8) {
                                n6 += Math.max(n5, n7);
                                n7 = 0;
                            }
                            if (this.minWidth < n3) {
                                this.minWidth = n3;
                            }
                            n3 = this.indentWhat(this.inWhat) + n8;
                        } else if (string.equalsIgnoreCase("/PRE")) {
                            if (this.fonts.size() > 1) {
                                this.fonts.pop();
                                this.heights.pop();
                            }
                            if (!this.fonts.empty()) {
                                this.font = (Font)this.fonts.peek();
                                n5 = (Integer)this.heights.peek();
                            }
                            if (!this.inWhat.empty()) {
                                this.inWhat.pop();
                            }
                            if (this.minWidth < n3) {
                                this.minWidth = n3;
                            }
                            if (n3 > this.indentWhat(this.inWhat) + n8) {
                                n6 += Math.max(n5, n7);
                                n7 = 0;
                            }
                            n3 = this.indentWhat(this.inWhat) + n8;
                        } else if (string2.equalsIgnoreCase("B") || string2.equalsIgnoreCase("STRONG")) {
                            string2 = "B";
                            if (!this.removeTag("<B>")) {
                                this.font = this.fonts.push(this.boldFont);
                                n5 = this.getLineHeight(this.multiLineMsg, this.font);
                                this.heights.push(new Integer(n5));
                            }
                        } else if (string2.equalsIgnoreCase("/B") || string2.equalsIgnoreCase("/STRONG")) {
                            string2 = "/B";
                            if (!this.removeTag("</B>")) {
                                if (this.fonts.size() > 1) {
                                    this.fonts.pop();
                                    this.heights.pop();
                                }
                                if (!this.fonts.empty()) {
                                    this.font = (Font)this.fonts.peek();
                                    n5 = (Integer)this.heights.peek();
                                }
                            }
                        } else if (string2.equalsIgnoreCase("I") || string2.equalsIgnoreCase("EM") || string2.equalsIgnoreCase("CITE") || string2.equalsIgnoreCase("VAR")) {
                            string2 = "I";
                            this.font = this.fonts.push(this.italFont);
                            n5 = this.getLineHeight(this.multiLineMsg, this.font);
                            this.heights.push(new Integer(n5));
                        } else if (string2.equalsIgnoreCase("/I") || string2.equalsIgnoreCase("/EM") || string2.equalsIgnoreCase("/CITE") || string2.equalsIgnoreCase("/VAR")) {
                            string2 = "/I";
                            if (this.fonts.size() > 1) {
                                this.fonts.pop();
                                this.heights.pop();
                            }
                            if (!this.fonts.empty()) {
                                this.font = (Font)this.fonts.peek();
                                n5 = (Integer)this.heights.peek();
                            }
                        } else if (string2.equalsIgnoreCase("TT") || string2.equalsIgnoreCase("CODE") || string2.equalsIgnoreCase("SAMP")) {
                            string2 = "TT";
                            this.font = this.fonts.push(this.preFont);
                            n5 = this.getLineHeight(this.multiLineMsg, this.font);
                            this.heights.push(new Integer(n5));
                        } else if (string2.equalsIgnoreCase("/TT") || string2.equalsIgnoreCase("/CODE") || string2.equalsIgnoreCase("/SAMP")) {
                            string2 = "/TT";
                            if (this.fonts.size() > 1) {
                                this.fonts.pop();
                                this.heights.pop();
                            }
                            if (!this.fonts.empty()) {
                                this.font = (Font)this.fonts.peek();
                                n5 = (Integer)this.heights.peek();
                            }
                        } else if (string2.equalsIgnoreCase("S") || string2.equalsIgnoreCase("STRIKE")) {
                            string2 = "S";
                        } else if (string2.equalsIgnoreCase("/S") || string2.equalsIgnoreCase("/STRIKE")) {
                            string2 = "/S";
                        } else if (!string2.equalsIgnoreCase("U") && !string2.equalsIgnoreCase("/U")) {
                            if (string2.equalsIgnoreCase("DD")) {
                                this.removeBlanks();
                                if (n3 > this.indentWhat(this.inWhat) + n8) {
                                    n6 += Math.max(n5, n7);
                                    n7 = 0;
                                }
                                if (this.minWidth < n3) {
                                    this.minWidth = n3;
                                }
                                n3 = this.indentWhat(this.inWhat) + n8;
                            } else if (string2.equalsIgnoreCase("DL")) {
                                this.removeBlanks();
                                this.removeTag("<BR>");
                                this.removeTag("<P>");
                                this.inWhat.push("DL");
                            } else if (string2.equalsIgnoreCase("/DL") && !this.inWhat.empty()) {
                                this.removeBlanks();
                                this.inWhat.pop();
                                if (!this.removeTag("<BR>") && !this.removeTag("<P>") && n3 > this.indentWhat(this.inWhat) + n8) {
                                    n6 += Math.max(n5, n7);
                                    n7 = 0;
                                }
                                this.msgBucket.addElement("</DL>");
                                string2 = "P";
                                if (this.paragraphSpacing > 1.0f) {
                                    n6 += (int)((float)n5 * (this.paragraphSpacing - 1.0f));
                                }
                                n11 = this.skipBlanks(this.multiLineMsg, n11);
                                n3 = this.indentWhat(this.inWhat) + n8;
                            } else if (string2.equalsIgnoreCase("UL")) {
                                this.removeBlanks();
                                this.removeTag("<BR>");
                                this.removeTag("<P>");
                                this.inWhat.push("UL");
                            } else if (string2.equalsIgnoreCase("/UL") && !this.inWhat.empty()) {
                                this.removeBlanks();
                                this.inWhat.pop();
                                if (!this.removeTag("<BR>") && !this.removeTag("<P>") && n3 > this.indentWhat(this.inWhat) + n8) {
                                    n6 += Math.max(n5, n7);
                                    n7 = 0;
                                }
                                this.msgBucket.addElement("</UL>");
                                string2 = "P";
                                if (this.paragraphSpacing > 1.0f) {
                                    n6 += (int)((float)n5 * (this.paragraphSpacing - 1.0f));
                                }
                                n11 = this.skipBlanks(this.multiLineMsg, n11);
                                n3 = this.indentWhat(this.inWhat) + n8;
                            } else if (string2.equalsIgnoreCase("OL")) {
                                this.removeBlanks();
                                this.removeTag("<BR>");
                                this.removeTag("<P>");
                                this.inWhat.push(new Integer(1));
                                n8 += 4;
                            } else if (string2.equalsIgnoreCase("/OL") && !this.inWhat.empty()) {
                                this.removeBlanks();
                                this.inWhat.pop();
                                if (!this.removeTag("<BR>") && !this.removeTag("<P>") && n3 > this.indentWhat(this.inWhat) + (n8 -= 4)) {
                                    n6 += Math.max(n5, n7);
                                }
                                this.msgBucket.addElement("</OL>");
                                string2 = "P";
                                if (this.paragraphSpacing > 1.0f) {
                                    n6 += (int)((float)n5 * (this.paragraphSpacing - 1.0f));
                                }
                                n11 = this.skipBlanks(this.multiLineMsg, n11);
                                n3 = this.indentWhat(this.inWhat) + n8;
                            } else if (string2.equalsIgnoreCase("LI")) {
                                this.removeBlanks();
                                if (!this.removeTag("<BR>") && !this.removeTag("<P>") && n3 > this.indentWhat(this.inWhat) + n8 || this.paragraphSpacing > 1.0f) {
                                    n6 += Math.max(n5, n7);
                                    if (this.paragraphSpacing > 1.0f) {
                                        n6 += (int)((float)n5 * (this.paragraphSpacing - 1.0f));
                                    }
                                    n7 = 0;
                                }
                                if (this.minWidth < n3) {
                                    this.minWidth = n3;
                                }
                                n3 = this.indentWhat(this.inWhat) + n8;
                            } else if (string2.equalsIgnoreCase("DT")) {
                                this.removeBlanks();
                                if (!this.removeTag("<BR>") && !this.removeTag("<P>") && n3 > this.indentWhat(this.inWhat) + n8) {
                                    n6 += Math.max(n5, n7);
                                    if (this.paragraphSpacing > 1.0f) {
                                        n6 += (int)((float)n5 * (this.paragraphSpacing - 1.0f));
                                    }
                                    n7 = 0;
                                }
                                if (this.minWidth < n3) {
                                    this.minWidth = n3;
                                }
                                n3 = this.indentWhat(this.inWhat) + n8;
                            } else if (string2.equalsIgnoreCase("IMG")) {
                                URL uRL;
                                Dimension dimension = null;
                                String string3 = this.getAttrValue("WIDTH", string);
                                String string4 = this.getAttrValue("HEIGHT", string);
                                String string5 = this.getAttrValue("HSPACE", string);
                                String string6 = this.getAttrValue("ALIGN", string);
                                if (string6 == null) {
                                    string6 = "BOTTOM";
                                }
                                n12 = 0;
                                int n15 = 0;
                                if (string4 != null && string3 != null) {
                                    boolean bl2 = true;
                                    try {
                                        n12 = Math.max(0, Integer.parseInt(string3));
                                        n15 = Math.max(0, Integer.parseInt(string4));
                                    }
                                    catch (NumberFormatException numberFormatException) {
                                        bl2 = false;
                                    }
                                    if (bl2) {
                                        dimension = new Dimension(n12, n15);
                                    }
                                }
                                String string7 = this.getAttrValue("SRC", string);
                                Icon icon = null;
                                if (imageCache != null) {
                                    icon = (Icon)imageCache.get(string7);
                                }
                                if (icon == null && (uRL = this.getSourceURL(string7)) != null) {
                                    Image image = Toolkit.getDefaultToolkit().getImage(uRL);
                                    icon = new ImageIcon(image);
                                    if (dimension != null) {
                                        n4 = dimension.width;
                                        icon = new ImageIcon(((ImageIcon)icon).getImage().getScaledInstance(dimension.width, dimension.height, 4));
                                    }
                                    if (imageCache == null) {
                                        imageCache = new Hashtable();
                                    }
                                    imageCache.put(string7, icon);
                                }
                                n4 = dimension == null ? icon.getIconWidth() : dimension.width;
                                if (string5 != null) {
                                    try {
                                        int n16 = Integer.parseInt(string5);
                                        n4 += n16;
                                        if (n3 > this.indentWhat(this.inWhat) + insets.left) {
                                            n4 += n16;
                                        }
                                    }
                                    catch (NumberFormatException numberFormatException) {
                                        string5 = null;
                                    }
                                }
                                if (n3 + n4 < this.maxWidth - insets.left - insets.right) {
                                    if (this.minWidth < (n3 += n4)) {
                                        this.minWidth = n3;
                                    }
                                } else {
                                    this.msgBucket.addElement("<BR>");
                                    n6 += Math.max(n5, n7);
                                    n7 = 0;
                                    if (this.minWidth < n3) {
                                        this.minWidth = n3;
                                    }
                                    n3 = this.indentWhat(this.inWhat) + n4 + n8 + this.hangingIndent;
                                }
                                this.lbuf.append("<IMG ").append(string6);
                                if (string5 != null) {
                                    this.lbuf.append(';').append(string5);
                                }
                                this.lbuf.append('>');
                                this.msgBucket.addElement(this.lbuf.toString());
                                this.lbuf.setLength(0);
                                this.msgBucket.addElement(string7);
                                n7 = Math.max(n7, icon.getIconHeight());
                            } else if (!string2.equalsIgnoreCase("A") && !string2.equalsIgnoreCase("/A") && n3 > 0) {
                                n6 += Math.max(n5, n7);
                                n7 = 0;
                                if (this.minWidth < n3) {
                                    this.minWidth = n3;
                                }
                                n3 = this.indentWhat(this.inWhat) + n8;
                            }
                        }
                        if (!string2.equalsIgnoreCase("IMG")) {
                            this.lbuf.append('<').append(string2).append('>');
                            this.msgBucket.addElement(this.lbuf.toString());
                            this.lbuf.setLength(0);
                        }
                    }
                    if (string2.equalsIgnoreCase("A")) {
                        bl = true;
                        String string8 = this.getAttrValue("HREF", string);
                        if (string8 == null) {
                            string8 = this.getAttrValue("NAME", string);
                        }
                        this.anchors.addElement(new Anchor(string8));
                    } else {
                        bl = false;
                    }
                } else {
                    int n17;
                    string = HtmlSymbols.symbolsToChars(string);
                    if (!this.inWhat.empty() && this.inWhat.peek().equals("PRE")) {
                        n17 = 0;
                        int n18 = string.indexOf(10);
                        while (n18 > -1) {
                            this.msgBucket.addElement(string.substring(n17, n18));
                            if (this.minWidth < (n3 += this.getLineWidth((String)this.msgBucket.lastElement(), this.font))) {
                                this.minWidth = n3;
                            }
                            n3 = this.indentWhat(this.inWhat) + n8;
                            this.msgBucket.addElement("<BR>");
                            n6 += Math.max(n5, n7);
                            n7 = 0;
                            n17 = n18 + 1;
                            n18 = string.indexOf(10, n17);
                        }
                        if (n17 < string.length()) {
                            this.msgBucket.addElement(string.substring(n17));
                            if (this.minWidth < (n3 += this.getLineWidth((String)this.msgBucket.lastElement(), this.font))) {
                                this.minWidth = n3;
                            }
                            n3 = this.indentWhat(this.inWhat) + n8;
                            n6 += Math.max(n5, n7);
                            n7 = 0;
                        }
                    } else {
                        breakIterator.setText(string);
                        n17 = breakIterator.first();
                        int n19 = breakIterator.next();
                        while (n19 != -1) {
                            int n20;
                            int n21;
                            int n22;
                            String string9 = string.substring(n17, n19);
                            n4 = this.getLineWidth(string9, this.font);
                            if (n4 > this.maxWidth - insets.left - insets.right) {
                                n22 = string9.length();
                                n21 = 0;
                                n20 = 0;
                                if (breakIterator2 == null) {
                                    breakIterator2 = BreakIterator.getWordInstance(this.locale);
                                }
                                boolean bl3 = false;
                                while (n20 < n22) {
                                    int n23 = n21;
                                    breakIterator2.setText(string9.substring(n23));
                                    int n24 = breakIterator2.first();
                                    n21 = n24 + n23;
                                    n20 = breakIterator2.next();
                                    if (n20 > 1 && !this.isLeadingPunctuation(string9.substring(n20 + n23 - 1, n20 + n23)) && n3 + this.getLineWidth(string9.substring(n21, n20 + n23), this.font) < this.maxWidth - insets.left - insets.right) {
                                        bl3 = false;
                                        if (this.position == null) {
                                            this.position = new AssistIndex(50);
                                        } else {
                                            this.position.setSize(0);
                                        }
                                        this.position.addInt(n21);
                                        while (n20 != -1) {
                                            this.position.addInt(n20 + n23);
                                            n20 = breakIterator2.next();
                                        }
                                        n12 = this.position.size() - 1;
                                        while (n12 > 0 && n3 + this.getLineWidth(string9.substring(n21, this.position.intAt(n12)), this.font) > this.maxWidth - insets.left - insets.right) {
                                            --n12;
                                        }
                                        n20 = this.position.intAt(n12);
                                    } else {
                                        bl3 = true;
                                        if (breakIterator3 == null) {
                                            breakIterator3 = BreakIterator.getCharacterInstance(this.locale);
                                        }
                                        breakIterator3.setText(string9.substring(n23));
                                        n24 = breakIterator3.first();
                                        n21 = n24 + n23;
                                        n20 = breakIterator3.next();
                                        if (this.position == null) {
                                            this.position = new AssistIndex(50);
                                        } else {
                                            this.position.setSize(0);
                                        }
                                        this.position.addInt(n21);
                                        while (n20 != -1) {
                                            this.position.addInt(n20 + n23);
                                            n20 = breakIterator3.next();
                                        }
                                        n12 = this.position.size() - 1;
                                        while (n12 > 0 && n3 + this.getLineWidth(string9.substring(n21, this.position.intAt(n12)), this.font) > this.maxWidth - insets.left - insets.right) {
                                            --n12;
                                        }
                                        n20 = this.position.intAt(n12);
                                    }
                                    if (n20 > string9.length()) {
                                        n20 = string9.length();
                                    }
                                    if (n20 > 0 && this.isLeadingPunctuation(string9.substring(n20 - 1, n20))) {
                                        --n20;
                                    }
                                    if (n20 >= 1) {
                                        if (n20 > n21) {
                                            this.lbuf.append(string9.substring(n21, n20));
                                            if (this.minWidth < (n3 += this.getLineWidth(string9.substring(n21, n20), this.font))) {
                                                this.minWidth = n3;
                                            }
                                        }
                                        if (n20 >= n22) continue;
                                        this.msgBucket.addElement(this.lbuf.toString());
                                        this.msgBucket.addElement("<BR>");
                                        this.lbuf.setLength(0);
                                        n3 = this.indentWhat(this.inWhat) + n8;
                                        n6 += Math.max(n5, n7);
                                        n7 = 0;
                                        if (bl3) {
                                            this.lbuf.append("..");
                                            n3 += this.getLineWidth("..", this.font);
                                        }
                                        n21 = n20;
                                        continue;
                                    }
                                    break;
                                }
                            } else if (n3 + n4 < this.maxWidth - insets.left - insets.right) {
                                this.lbuf.append(string9);
                                if (this.minWidth < (n3 += n4)) {
                                    this.minWidth = n3;
                                }
                            } else if (this.lbuf.toString().trim().length() > 0 && this.isLeadingPunctuation(this.lbuf.toString().trim())) {
                                n22 = this.lbuf.length() - 1;
                                while (n22 > -1 && Character.getType(this.lbuf.charAt(n22)) != 21) {
                                    --n22;
                                }
                                char[] cArray = new char[this.lbuf.length() - n22];
                                this.lbuf.getChars(n22, this.lbuf.length(), cArray, 0);
                                this.lbuf.setLength(n22);
                                string9 = String.valueOf(cArray) + string9;
                                n4 = this.getLineWidth(string9, this.font);
                                if (this.lbuf.length() > 0) {
                                    this.msgBucket.addElement(this.lbuf.toString());
                                    this.lbuf.setLength(0);
                                }
                                this.msgBucket.addElement("<BR>");
                                this.lbuf.append(string9);
                                if (bl) {
                                    n3 += n4;
                                } else {
                                    n6 += Math.max(n5, n7);
                                    n7 = 0;
                                    if (this.minWidth < n3) {
                                        this.minWidth = n3;
                                    }
                                    n3 = this.indentWhat(this.inWhat) + n4 + n8;
                                }
                            } else if (this.lbuf.toString().trim().length() == 0 && this.isLeadingPunctuation(null)) {
                                n22 = this.getPreviousTextIndex();
                                String string10 = (String)this.msgBucket.elementAt(n22);
                                if (string10.length() > 0) {
                                    int n25 = string10.length() - 1;
                                    while (n25 > -1 && Character.getType(string10.charAt(n25)) != 21) {
                                        --n25;
                                    }
                                    this.msgBucket.setElementAt(string10.substring(0, n25), n22);
                                    this.msgBucket.insertElementAt("<BR>", n22 + 1);
                                    this.msgBucket.insertElementAt(string10.substring(n25), n22 + 2);
                                    if (this.lbuf.length() > 0) {
                                        n3 += this.getLineWidth(this.lbuf.toString(), this.font);
                                        this.msgBucket.addElement(this.lbuf.toString());
                                        this.lbuf.setLength(0);
                                    }
                                    n21 = 0;
                                    while (n21 < string9.length() && Character.isWhitespace(string9.charAt(n21))) {
                                        ++n21;
                                    }
                                    if (n21 > 0 && n21 < string9.length()) {
                                        string9 = string9.substring(n21);
                                        n4 = this.getLineWidth(string9, this.font);
                                    }
                                    this.lbuf.append(string9);
                                    if (bl) {
                                        n3 += n4;
                                        n3 += this.getLineWidth(string10.substring(n25), this.font);
                                    } else {
                                        n6 += Math.max(n5, n7);
                                        n7 = 0;
                                        if (this.minWidth < n3) {
                                            this.minWidth = n3;
                                        }
                                        n3 = this.indentWhat(this.inWhat) + n4 + n8;
                                        n3 += this.getLineWidth(string10.substring(n25), this.font);
                                    }
                                }
                            } else if (DiagnosisRenderer.isTrailingPunctuation(string9)) {
                                n22 = breakIterator.preceding(n19 - 1);
                                if (n22 > -1) {
                                    breakIterator.next();
                                    int n26 = this.lbuf.length() - n19 + n22;
                                    if (n26 > 0) {
                                        String string11 = this.lbuf.substring(n26);
                                        n21 = 0;
                                        while (n21 < string11.length() && Character.isWhitespace(string11.charAt(n21))) {
                                            ++n21;
                                        }
                                        if (n21 > 0 && n21 < string11.length()) {
                                            string11 = string11.substring(n21);
                                        }
                                        n20 = this.getLineWidth(string11, this.font);
                                        n4 += n20;
                                        n3 -= n20;
                                        this.msgBucket.addElement(this.lbuf.substring(0, n26));
                                        this.msgBucket.addElement("<BR>");
                                        n6 += Math.max(n5, n7);
                                        n7 = 0;
                                        this.lbuf.setLength(0);
                                        this.lbuf.append(string11);
                                        if (this.minWidth < n3) {
                                            this.minWidth = n3;
                                        }
                                    }
                                }
                                this.lbuf.append(string9.trim());
                            } else {
                                if (this.lbuf.length() > 0) {
                                    this.msgBucket.addElement(this.lbuf.toString());
                                    this.lbuf.setLength(0);
                                }
                                this.msgBucket.addElement("<BR>");
                                n22 = 0;
                                while (n22 < string9.length() && Character.isWhitespace(string9.charAt(n22))) {
                                    ++n22;
                                }
                                if (n22 > 0 && n22 < string9.length()) {
                                    string9 = string9.substring(n22);
                                    n4 = this.getLineWidth(string9, this.font);
                                }
                                this.lbuf.append(string9);
                                n6 += Math.max(n5, n7);
                                n7 = 0;
                                if (this.minWidth < n3) {
                                    this.minWidth = n3;
                                }
                                n3 = this.indentWhat(this.inWhat) + n4 + n8;
                            }
                            n17 = n19;
                            n19 = breakIterator.next();
                        }
                    }
                }
                n10 = n11;
                n11 = DiagnosisRenderer.tagScan(this.multiLineMsg, n9, n10);
            }
        }
        if (this.lbuf.toString().trim().length() > 0) {
            this.msgBucket.addElement(this.lbuf.toString());
        }
        if (n3 > this.indentWhat(this.inWhat) + n8) {
            n6 += Math.max(n5, n7);
        }
        if (this.minWidth < n3) {
            this.minWidth = n3;
        }
        this.minWidth += insets.left + insets.right + 5;
        if (n6 > 0) {
            LineMetrics lineMetrics = this.getLineMetrics(this.lbuf.toString(), this.font);
            n6 = (int)((float)n6 + (lineMetrics.getLeading() + lineMetrics.getDescent() + (float)insets.bottom));
        }
        Dimension dimension = new Dimension(this.minWidth, n6);
        this.setPreferredSize(dimension);
    }

    protected void paintComponent(Graphics graphics) {
        if (this.multiLineMsg == null) {
            if (this.gnosis == null) {
                return;
            }
            this.configure(graphics, this.gnosis);
            this.wrap(super.getPreferredSize().width);
        }
        Graphics graphics2 = graphics.create();
        graphics2.setColor(this.backColor);
        Dimension dimension = super.getPreferredSize();
        if (this.viewRect != null) {
            graphics2.setClip(this.viewRect.x, this.viewRect.y, this.viewRect.width, this.viewRect.height);
            if (this.isOpaque()) {
                graphics2.fillRect(this.viewRect.x, this.viewRect.y, this.viewRect.width, this.viewRect.height);
            }
        } else if (this.isOpaque()) {
            graphics2.fillRect(this.loc.x, this.loc.y, dimension.width, dimension.height);
        }
        if (this.borderColor != null) {
            graphics2.setColor(this.borderColor);
            graphics2.drawRect(this.loc.x, this.loc.y, dimension.width, dimension.height);
        }
        if (this.isEnabled()) {
            graphics2.setColor(this.foreColor);
            this.paintText(graphics2);
        } else {
            graphics2.setColor(this.backColor.brighter());
            this.paintText(graphics2);
            graphics2.setColor(this.backColor.darker());
            graphics2.translate(-1, -1);
            this.paintText(graphics2);
            graphics2.translate(1, 1);
        }
    }

    protected Color getLinkColor(Graphics graphics) {
        if (this.isEnabled()) {
            return this.linkColor;
        }
        return graphics.getColor();
    }

    protected void paintText(Graphics graphics) {
        boolean bl = false;
        Color color = graphics.getColor();
        int[] nArray = new int[2];
        int n2 = 0;
        int n3 = 2;
        Dimension dimension = super.getPreferredSize();
        Insets insets = this.getInsets();
        int n4 = dimension.width;
        int n5 = dimension.height;
        int n6 = this.msgBucket.size();
        if (n6 == 0) {
            return;
        }
        int n7 = this.loc.x;
        int n8 = (int)this.getLineMetrics((String)this.msgBucket.firstElement(), this.font).getAscent();
        int n9 = (int)this.getLineMetrics((String)this.msgBucket.firstElement(), this.font).getDescent();
        int n10 = n8 + this.loc.y + insets.top;
        this.lbuf.setLength(0);
        this.inWhat.clear();
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        Rectangle rectangle = null;
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        if (!((String)this.msgBucket.elementAt(0)).equalsIgnoreCase("<P>") && (nArray = this.getLineOffsets(this.msgBucket, 0))[0] > 0) {
            n10 += nArray[0] - n8;
        }
        this.fonts.clear();
        graphics.setFont(this.fonts.push(this.normalFont));
        while (n13 < n6) {
            int n14;
            int n15;
            int n16;
            int n17;
            int n18;
            String string = (String)this.msgBucket.elementAt(n13);
            if (string.length() > 2 && string.charAt(0) == '<' && string.charAt(string.length() - 1) == '>') {
                if (string.equalsIgnoreCase("<B>")) {
                    graphics.setFont(this.fonts.push(this.boldFont));
                    this.font = this.boldFont;
                } else if (string.equalsIgnoreCase("</B>")) {
                    if (this.fonts.size() > 1) {
                        this.fonts.pop();
                    }
                    if (!this.fonts.empty()) {
                        this.font = (Font)this.fonts.peek();
                        graphics.setFont(this.font);
                    }
                } else if (string.equalsIgnoreCase("<I>")) {
                    graphics.setFont(this.fonts.push(this.italFont));
                    this.font = this.italFont;
                } else if (string.equalsIgnoreCase("</I>")) {
                    if (this.fonts.size() > 1) {
                        this.fonts.pop();
                    }
                    if (!this.fonts.empty()) {
                        this.font = (Font)this.fonts.peek();
                        graphics.setFont(this.font);
                    }
                } else if (string.equalsIgnoreCase("<TT>")) {
                    graphics.setFont(this.fonts.push(this.preFont));
                    this.font = this.preFont;
                } else if (string.equalsIgnoreCase("</TT>")) {
                    if (this.fonts.size() > 1) {
                        this.fonts.pop();
                    }
                    if (!this.fonts.empty()) {
                        this.font = (Font)this.fonts.peek();
                        graphics.setFont(this.font);
                    }
                } else if (string.equalsIgnoreCase("<S>")) {
                    bl4 = true;
                } else if (string.equalsIgnoreCase("</S>")) {
                    bl4 = false;
                } else if (string.equalsIgnoreCase("<U>")) {
                    bl5 = true;
                } else if (string.equalsIgnoreCase("</U>")) {
                    bl5 = false;
                } else if (string.equalsIgnoreCase("<UL>")) {
                    this.inWhat.push("UL");
                    n11 = 0;
                    this.lbuf.setLength(0);
                } else if (string.equalsIgnoreCase("<OL>")) {
                    this.inWhat.push(new Integer(1));
                    n11 = 0;
                    this.lbuf.setLength(0);
                    n12 += 4;
                } else if (string.equalsIgnoreCase("<PRE>")) {
                    this.inWhat.push("PRE");
                    graphics.setFont(this.fonts.push(this.preFont));
                    this.font = this.preFont;
                    if (n13 != 0) {
                        n10 += this.getLineHeight(this.lbuf.toString(), this.font);
                        if (nArray[1] > 0) {
                            n10 += nArray[1] - n9;
                        }
                    }
                    if ((nArray = this.getLineOffsets(this.msgBucket, n13))[0] > 0) {
                        n10 += nArray[0] - n8;
                    }
                    n11 = 0;
                    this.lbuf.setLength(0);
                } else if (string.equalsIgnoreCase("</UL>") && !this.inWhat.empty()) {
                    this.inWhat.pop();
                    n11 = 0;
                    this.lbuf.setLength(0);
                } else if (string.equalsIgnoreCase("</OL>") && !this.inWhat.empty()) {
                    this.inWhat.pop();
                    n11 = 0;
                    this.lbuf.setLength(0);
                    n12 -= 4;
                } else if (string.equalsIgnoreCase("</PRE>")) {
                    if (this.fonts.size() > 1) {
                        this.fonts.pop();
                    }
                    if (!this.fonts.empty()) {
                        this.font = (Font)this.fonts.peek();
                        graphics.setFont(this.font);
                    }
                    if (!this.inWhat.empty()) {
                        this.inWhat.pop();
                    }
                    n11 = 0;
                    this.lbuf.setLength(0);
                } else if (string.equalsIgnoreCase("<LI>")) {
                    if (n13 != 0) {
                        n10 = this.paragraphSpacing > 1.0f ? (int)((float)n10 + (float)this.getLineHeight(this.lbuf.toString(), this.font) * (this.paragraphSpacing - 0.0f)) : (n10 += this.getLineHeight(this.lbuf.toString(), this.font));
                        if (nArray[1] > 0) {
                            n10 += nArray[1] - n9;
                        }
                        if ((nArray = this.getLineOffsets(this.msgBucket, n13))[0] > 0) {
                            n10 += nArray[0] - n8;
                        }
                    }
                    if (!this.inWhat.empty()) {
                        Object e2 = this.inWhat.peek();
                        if (e2 instanceof String) {
                            graphics.fillOval(insets.left + n7 + this.indentWhat(this.inWhat) - 8, n10 - this.getLineHeight(this.lbuf.toString(), this.font) / 2, 2 * n3, 2 * n3);
                            n11 = 0;
                            this.lbuf.setLength(0);
                        } else if (e2 instanceof Integer) {
                            graphics.drawString(e2.toString() + ". ", insets.left + n7 + this.indentWhat(this.inWhat) - 10, n10);
                            this.inWhat.pop();
                            this.inWhat.push(new Integer((Integer)e2 + 1));
                            n11 = 4;
                        }
                    }
                } else if (string.equalsIgnoreCase("<BR>") || string.equalsIgnoreCase("<P>")) {
                    if (bl3) {
                        rectangle.width = Math.abs(n7 + n11 + this.indentWhat(this.inWhat) - this.loc.x - rectangle.x);
                        rectangle.height = Math.abs(n10 + (int)this.getLineMetrics(this.lbuf.toString(), this.font).getDescent() - this.loc.y - rectangle.y);
                        ((Anchor)this.anchors.elementAt(n2)).addRectangle(rectangle);
                        graphics.drawLine(rectangle.x, n10 + 2, insets.left + n7 + n11 + this.indentWhat(this.inWhat), n10 + 2);
                        if (this.hasFocus() && n2 == this.focusAnchor && rectangle.width > 0) {
                            Border border = UIManager.getBorder("Label.border");
                            border.paintBorder(this, graphics.create(), rectangle.x - 1, rectangle.y, rectangle.width + 2, rectangle.height + 1);
                        }
                        rectangle = new Rectangle(this.loc.x + this.indentWhat(this.inWhat), rectangle.y + this.getLineHeight(this.lbuf.toString(), this.font), rectangle.width, rectangle.height);
                    }
                    n7 = this.loc.x + this.hangingIndent;
                    if (n13 != 0 && !bl2) {
                        n10 = string.equalsIgnoreCase("<P>") && this.paragraphSpacing > 1.0f ? (int)((float)n10 + (float)this.getLineHeight(this.lbuf.toString(), this.font) * (this.paragraphSpacing - 0.0f)) : (this.onNewline(n13) ? (int)((float)n10 + (float)this.getLineHeight(this.lbuf.toString(), this.font) * (this.paragraphSpacing - 1.0f)) : (n10 += this.getLineHeight(this.lbuf.toString(), this.font)));
                        if (nArray[1] > 0) {
                            n10 += nArray[1] - n9;
                        }
                    }
                    if ((nArray = this.getLineOffsets(this.msgBucket, n13))[0] > 0) {
                        n10 += nArray[0] - n8;
                    }
                    n11 = 0;
                    this.lbuf.setLength(0);
                    n11 = string.equalsIgnoreCase("<BR>") ? n12 : 0;
                } else if (n6 > n13 + 1 && string.toUpperCase().startsWith("<IMG ")) {
                    Icon icon;
                    String string2 = null;
                    String string3 = null;
                    n18 = string.length() - 1;
                    n17 = string.indexOf(59, 5);
                    if (n17 > -1) {
                        string2 = string.substring(5, n17).toUpperCase();
                        string3 = string.substring(n17 + 1, n18);
                    } else {
                        string2 = string.substring(5, n18).toUpperCase();
                    }
                    String string4 = (String)this.msgBucket.elementAt(++n13);
                    if (imageCache != null && (icon = (Icon)imageCache.get(string4)) != null) {
                        int n19 = icon.getIconWidth();
                        int n20 = icon.getIconHeight();
                        int n21 = 0;
                        if (string3 != null) {
                            try {
                                n21 = Integer.parseInt(string3);
                            }
                            catch (NumberFormatException numberFormatException) {
                                n21 = 0;
                            }
                        }
                        int n22 = n10;
                        n22 = string2.equalsIgnoreCase("TOP") || string2.equalsIgnoreCase("TEXTTOP") ? (n22 -= n8) : (string2.equalsIgnoreCase("MIDDLE") || string2.equalsIgnoreCase("CENTER") || string2.equalsIgnoreCase("ABSCENTER") ? (n22 -= (n8 + n9) / 2 + n20 / 2 - Math.min(n8, n9) + 1) : n22 + n9 - n20);
                        if (n11 > 0) {
                            n11 += n21;
                        }
                        icon.paintIcon(this, graphics, n7 + insets.left + n11 + this.indentWhat(this.inWhat), n22);
                        n11 += n19;
                        n11 += n21;
                    }
                } else if (string.equalsIgnoreCase("<A>")) {
                    bl3 = true;
                    rectangle = new Rectangle();
                    rectangle.x = n7 + n11 + this.indentWhat(this.inWhat) - this.loc.x;
                    rectangle.y = n10 - (int)this.getLineMetrics(this.lbuf.toString(), this.font).getAscent() - this.loc.y;
                    graphics.setColor(this.getLinkColor(graphics));
                } else if (string.equalsIgnoreCase("</A>")) {
                    bl3 = false;
                    rectangle.width = Math.abs(n7 + n11 + this.indentWhat(this.inWhat) - this.loc.x - rectangle.x);
                    if (rectangle.height == 0) {
                        rectangle.height = Math.abs(n10 + (int)this.getLineMetrics(this.lbuf.toString(), this.font).getDescent() - this.loc.y - rectangle.y);
                    }
                    ((Anchor)this.anchors.elementAt(n2)).addRectangle(rectangle);
                    graphics.drawLine(rectangle.x, n10 + 2, insets.left + n7 + n11 + this.indentWhat(this.inWhat), n10 + 2);
                    graphics.setColor(color);
                    if (this.hasFocus() && n2 == this.focusAnchor) {
                        Border border = UIManager.getBorder("Label.border");
                        border.paintBorder(this, graphics.create(), rectangle.x - 1, rectangle.y, rectangle.width + 2, rectangle.height + 1);
                    }
                    rectangle = null;
                    ++n2;
                } else if (string.equalsIgnoreCase("<DL>")) {
                    this.inWhat.push("DL");
                    n11 = 0;
                    this.lbuf.setLength(0);
                } else if (string.equalsIgnoreCase("</DL>") && !this.inWhat.empty()) {
                    this.inWhat.pop();
                    n11 = 0;
                    this.lbuf.setLength(0);
                } else if (string.equalsIgnoreCase("<DT>")) {
                    graphics.setFont(this.fonts.push(this.boldFont));
                    bl2 = true;
                    n10 = this.paragraphSpacing > 1.0f ? (int)((float)n10 + (float)this.getLineHeight(this.lbuf.toString(), this.font) * (this.paragraphSpacing - 0.0f)) : (n10 += this.getLineHeight(this.lbuf.toString(), this.font));
                    if (nArray[1] > 0) {
                        n10 += nArray[1] - n9;
                    }
                    if ((nArray = this.getLineOffsets(this.msgBucket, n13))[0] > 0) {
                        n10 += nArray[0] - n8;
                    }
                    n11 = 0;
                    this.lbuf.setLength(0);
                } else if (string.equalsIgnoreCase("<DD>")) {
                    if (this.fonts.size() > 1) {
                        this.fonts.pop();
                    }
                    if (!this.fonts.empty()) {
                        this.font = (Font)this.fonts.peek();
                        graphics.setFont(this.font);
                    }
                    bl2 = false;
                    n11 = 0;
                    this.lbuf.setLength(0);
                }
            } else if (bl2) {
                if (n13 < n6) {
                    string = (String)this.msgBucket.elementAt(n13);
                    if (bl4 && string.equals("\u2014\u2014\u2014") && this.font == this.preFont) {
                        string = string.substring(0, 2);
                    }
                    graphics.drawString(string, insets.left + n7 + this.indentWhat(this.inWhat) - 19, n10);
                    if (bl4) {
                        n16 = (int)this.getLineMetrics(string, this.font).getStrikethroughOffset();
                        n15 = insets.left + n7 + this.indentWhat(this.inWhat) - 19;
                        graphics.drawLine(n15, n10 - n16, n15 + this.getLineWidth(string, this.font), n10 - n16);
                    }
                    if (bl5) {
                        n14 = (int)this.getLineMetrics(string, this.font).getUnderlineOffset() + 2;
                        n15 = insets.left + n7 + this.indentWhat(this.inWhat) - 19;
                        graphics.drawLine(n15, n10 + n14, n15 + this.getLineWidth(string, this.font) - 1, n10 + n14);
                    } else if (!bl) {
                        char c2 = Character.toUpperCase((char)this.getDisplayedMnemonic());
                        int n23 = string.toUpperCase().indexOf(c2);
                        if (c2 != '\u0000' && n23 > -1) {
                            n14 = (int)this.getLineMetrics(string, this.font).getUnderlineOffset() + 2;
                            n18 = insets.left + n7 + n11 + this.indentWhat(this.inWhat) + this.getLineWidth(string.substring(0, n23), this.font);
                            n17 = this.getLineWidth(string.substring(n23, n23 + 1), this.font);
                            graphics.drawLine(n18, n10 + n14, n18 + n17 - 1, n10 + n14);
                            bl = true;
                        }
                    }
                    n10 += this.getLineHeight(this.lbuf.toString(), this.font);
                    if (nArray[1] > 0) {
                        n10 += nArray[1] - n9;
                    }
                    if ((nArray = this.getLineOffsets(this.msgBucket, n13))[0] > 0) {
                        n10 += nArray[0] - n8;
                    }
                    n11 = 0;
                    this.lbuf.setLength(0);
                }
            } else {
                if (bl4 && string.equals("\u2014\u2014\u2014") && !this.fonts.empty() && (Font)this.fonts.peek() == this.preFont) {
                    string = string.substring(0, 2);
                }
                graphics.drawString(string, insets.left + n7 + n11 + this.indentWhat(this.inWhat), n10);
                if (bl4) {
                    n16 = (int)this.getLineMetrics(string, this.font).getStrikethroughOffset();
                    n15 = insets.left + n7 + n11 + this.indentWhat(this.inWhat);
                    graphics.drawLine(n15, n10 - n16, n15 + this.getLineWidth(string, this.font), n10 - n16);
                }
                if (bl5) {
                    n14 = (int)this.getLineMetrics(string, this.font).getUnderlineOffset() + 2;
                    n15 = insets.left + n7 + n11 + this.indentWhat(this.inWhat);
                    graphics.drawLine(n15, n10 + n14, n15 + this.getLineWidth(string, this.font) - 1, n10 + n14);
                } else if (!bl) {
                    char c3 = Character.toUpperCase((char)this.getDisplayedMnemonic());
                    int n24 = string.toUpperCase().indexOf(c3);
                    if (c3 != '\u0000' && n24 > -1) {
                        n14 = (int)this.getLineMetrics(string, this.font).getUnderlineOffset() + 2;
                        n18 = insets.left + n7 + n11 + this.indentWhat(this.inWhat) + this.getLineWidth(string.substring(0, n24), this.font);
                        n17 = this.getLineWidth(string.substring(n24, n24 + 1), this.font);
                        graphics.drawLine(n18, n10 + n14, n18 + n17 - 1, n10 + n14);
                        bl = true;
                    }
                }
                n11 += this.getLineWidth(string, this.font);
                this.lbuf.append(string);
            }
            ++n13;
        }
    }

    public void setBorderColor(Color color) {
        this.borderColor = color;
    }

    public void setBackground(Color color) {
        this.backColor = color;
        super.setBackground(color);
    }

    public void setForeground(Color color) {
        this.foreColor = color;
        super.setForeground(color);
    }

    public void setViewRect(Rectangle rectangle) {
        this.viewRect = rectangle;
        this.gnosis = null;
    }

    public int getLineHeight() {
        return this.getLineHeight(this.getDiagnosis().getDescription(), this.getFont());
    }

    public int getLineHeight(String string, Font font) {
        LineMetrics lineMetrics = AssistManager.getLineMetrics(string, this, font);
        return (int)(lineMetrics.getHeight() + lineMetrics.getLeading());
    }

    public int getLineWidth(String string, Font font) {
        return AssistManager.getStringWidth(string, this, font);
    }

    public LineMetrics getLineMetrics(String string, Font font) {
        return AssistManager.getLineMetrics(string, this, font);
    }

    public int getLeastWidth() {
        return this.leastWidth;
    }

    public void setFont(Font font) {
        if (font.isBold() || font.isItalic()) {
            super.setFont(font);
            this.setFonts(font);
        } else {
            super.setFont(AppearanceManager.getLanguageDependentDefaultFont(font));
            this.setFonts(this.getFont());
        }
    }

    protected void setFonts(Font font) {
        String string = AssistManager.getPreferredLanguage().toString();
        String string2 = font.getName();
        int n2 = font.getSize();
        this.normalFont = font;
        this.boldFont = AppearanceManager.getLanguageDependentFont(string2, 1, n2);
        this.italFont = AppearanceManager.getLanguageDependentFont(string2, 2, n2);
        this.bolditalFont = AppearanceManager.getLanguageDependentFont(string2, 3, n2);
        this.preFont = string.equals("ko_KR") ? this.normalFont : new Font("Monospaced", 0, this.normalFont.getSize()).deriveFont(this.normalFont.getTransform());
    }

    public Diagnosis getDiagnosis() {
        return this.gnosis;
    }

    protected boolean onNewline(int n2) {
        if (n2 > 0) {
            String string = (String)this.msgBucket.elementAt(n2 - 1);
            if (string.equalsIgnoreCase("<BR>") || string.equalsIgnoreCase("<P>") || string.equalsIgnoreCase("<DT>") || string.equalsIgnoreCase("<LI>")) {
                return true;
            }
            if (string.trim().length() == 0) {
                string = (String)this.msgBucket.elementAt(n2 - 2);
                return string.equalsIgnoreCase("<BR>") || string.equalsIgnoreCase("<P>") || string.equalsIgnoreCase("<DT>") || string.equalsIgnoreCase("<LI>");
            }
        }
        return false;
    }

    protected boolean removeTag(String string) {
        if (this.paragraphSpacing > 1.0f && "<BR>".equals(string)) {
            return false;
        }
        int n2 = this.msgBucket.size();
        if (n2 > 0) {
            if (((String)this.msgBucket.elementAt(n2 - 1)).equalsIgnoreCase(string)) {
                this.msgBucket.removeElementAt(n2 - 1);
                return true;
            }
            if (((String)this.msgBucket.elementAt(n2 - 1)).trim().length() == 0 && ((String)this.msgBucket.elementAt(n2 - 2)).equalsIgnoreCase(string)) {
                this.msgBucket.removeElementAt(n2 - 1);
                this.msgBucket.removeElementAt(n2 - 2);
                return true;
            }
        }
        return false;
    }

    protected void removeBlanks() {
        String string;
        int n2 = this.msgBucket.size();
        if (n2 > 0 && (string = (String)this.msgBucket.lastElement()).trim().length() == 0) {
            this.msgBucket.removeElementAt(n2 - 1);
        }
    }

    protected int skipBlanks(String string, int n2) {
        int n3 = n2;
        while (n3 < string.length() && Character.isWhitespace(string.charAt(n3))) {
            ++n3;
        }
        return n3;
    }

    protected String mdashes(String string, StringBuffer stringBuffer) {
        int n2 = 0;
        int n3 = string.indexOf("&#8212;");
        stringBuffer.setLength(0);
        while (n3 > -1) {
            stringBuffer.append(string.substring(n2, n3));
            stringBuffer.append("<S>");
            stringBuffer.append("&nbsp;&nbsp;&nbsp;");
            stringBuffer.append("</S>");
            n2 = n3 + 7;
            n3 = string.indexOf("&#8212;", n2);
        }
        if (n2 < string.length()) {
            stringBuffer.append(string.substring(n2));
        }
        String string2 = stringBuffer.toString();
        stringBuffer.setLength(0);
        return string2;
    }

    protected static boolean isTrailingPunctuation(String string) {
        char c2 = string.charAt(0);
        int n2 = Character.getType(c2);
        if (n2 == 22 || n2 == 24 && otherEndPunctuationMarks.indexOf(c2) > -1) {
            if (c2 == ':') {
                if (string.length() == 1) {
                    return false;
                }
                return Character.isWhitespace(string.charAt(1));
            }
            return true;
        }
        return false;
    }

    protected int getPreviousTextIndex() {
        int n2 = this.msgBucket.size();
        if (n2 < 1) {
            return -1;
        }
        String string = ((String)this.msgBucket.elementAt(n2 - 1)).trim();
        boolean bl = false;
        if (string.length() > 0 && string.charAt(string.length() - 1) == '>') {
            bl = true;
        }
        --n2;
        while (n2 > 0 && bl) {
            string = ((String)this.msgBucket.elementAt(n2 - 1)).trim();
            if (string.length() > 0 && string.charAt(string.length() - 1) != '>') {
                bl = false;
                continue;
            }
            --n2;
        }
        if (bl) {
            return -1;
        }
        return n2 - 1;
    }

    protected boolean isLeadingPunctuation(String string) {
        int n2;
        if (string == null) {
            n2 = this.msgBucket.size();
            if (n2 < 1) {
                return false;
            }
            string = ((String)this.msgBucket.elementAt(n2 - 1)).trim();
            boolean bl = false;
            if (string.length() > 0 && string.charAt(string.length() - 1) == '>' && string.charAt(0) == '<') {
                bl = true;
            }
            --n2;
            while (n2 > 0 && bl) {
                string = ((String)this.msgBucket.elementAt(n2 - 1)).trim();
                if (string.length() > 0 && string.charAt(string.length() - 1) != '>') {
                    bl = false;
                    continue;
                }
                --n2;
            }
            if (n2 == 0) {
                return false;
            }
        }
        return (n2 = Character.getType(string.charAt(string.length() - 1))) == 21;
    }

    protected static int tagScan(String string, int n2, int n3) {
        char c2 = '\n';
        if (n3 >= n2) {
            return n3 + 1;
        }
        char c3 = string.charAt(n3);
        if (c3 == '\n' || c3 == c2 || c3 == '\r') {
            return n3 + 1;
        }
        if (c3 == '<') {
            int n4 = n3 + 1;
            if (n4 == n2) {
                return n4;
            }
            c3 = string.charAt(n4);
            while (c3 != '>' && n4 < n2) {
                if (++n4 >= n2) continue;
                c3 = string.charAt(n4);
            }
            if (c3 == '>') {
                return n4 + 1;
            }
            return n4;
        }
        int n5 = n3;
        while (c3 != '<' && c3 != '\n' && c3 != c2 && c3 != '\r' && n5 < n2) {
            if (++n5 >= n2) continue;
            c3 = string.charAt(n5);
        }
        return n5;
    }

    protected boolean supportedTag(String string) {
        return string.equalsIgnoreCase("\n") || string.equalsIgnoreCase("BR") || string.equalsIgnoreCase("P") || string.equalsIgnoreCase("B") || string.equalsIgnoreCase("/B") || string.equalsIgnoreCase("STRONG") || string.equalsIgnoreCase("/STRONG") || string.equalsIgnoreCase("I") || string.equalsIgnoreCase("/I") || string.equalsIgnoreCase("EM") || string.equalsIgnoreCase("/EM") || string.equalsIgnoreCase("CITE") || string.equalsIgnoreCase("/CITE") || string.equalsIgnoreCase("VAR") || string.equalsIgnoreCase("/VAR") || string.equalsIgnoreCase("TT") || string.equalsIgnoreCase("/TT") || string.equalsIgnoreCase("CODE") || string.equalsIgnoreCase("/CODE") || string.equalsIgnoreCase("SAMP") || string.equalsIgnoreCase("/SAMP") || string.equalsIgnoreCase("S") || string.equalsIgnoreCase("/S") || string.equalsIgnoreCase("STRIKE") || string.equalsIgnoreCase("/STRIKE") || string.equalsIgnoreCase("U") || string.equalsIgnoreCase("/U") || string.equalsIgnoreCase("UL") || string.equalsIgnoreCase("/UL") || string.equalsIgnoreCase("OL") || string.equalsIgnoreCase("/OL") || string.equalsIgnoreCase("LI") || string.equalsIgnoreCase("DL") || string.equalsIgnoreCase("/DL") || string.equalsIgnoreCase("PRE") || string.equalsIgnoreCase("/PRE") || string.equalsIgnoreCase("DT") || string.equalsIgnoreCase("DD") || string.equalsIgnoreCase("IMG") || this.hyperLinkPolicy && string.equalsIgnoreCase("A") || this.hyperLinkPolicy && string.equalsIgnoreCase("/A");
    }

    protected int countMetaChars(String string, char c2) {
        int n2 = 0;
        int n3 = string.length();
        int n4 = 0;
        while (n4 < n3) {
            if (string.charAt(n4) == c2) {
                ++n2;
            }
            ++n4;
        }
        return n2;
    }

    protected int[] getLineOffsets(Vector vector, int n2) {
        Object object;
        String string;
        StringBuffer stringBuffer = new StringBuffer(75);
        Vector<String> vector2 = null;
        int n3 = vector.size();
        boolean bl = true;
        int[] nArray = new int[4];
        ++n2;
        while (bl && n2 < n3) {
            string = (String)vector.elementAt(n2);
            if (string.length() > 0 && string.charAt(0) == '<') {
                if (string.equalsIgnoreCase("<P>") || string.equalsIgnoreCase("<BR>") || string.equalsIgnoreCase("<LI>") || string.equalsIgnoreCase("<DT>") || string.equalsIgnoreCase("<DD>")) {
                    bl = false;
                    continue;
                }
                if (string.toUpperCase().startsWith("<IMG ")) {
                    if (vector2 == null) {
                        vector2 = new Vector<String>();
                    }
                    vector2.addElement(string);
                    vector2.addElement((String)vector.elementAt(++n2));
                }
                ++n2;
                continue;
            }
            stringBuffer.append(string);
            ++n2;
        }
        if (stringBuffer.length() > 0) {
            object = this.getLineMetrics(stringBuffer.toString(), this.font);
            nArray[2] = (int)((LineMetrics)object).getAscent();
            nArray[3] = (int)((LineMetrics)object).getDescent();
        }
        if (vector2 != null) {
            int n4 = 0;
            while (n4 < vector2.size()) {
                Icon icon;
                string = (String)vector2.elementAt(n4);
                String string2 = (String)vector2.elementAt(++n4);
                object = string.substring(5).toUpperCase();
                if (imageCache != null && (icon = (Icon)imageCache.get(string2)) != null) {
                    int n5 = icon.getIconHeight();
                    int n6 = 0;
                    int n7 = 0;
                    if (((String)object).equalsIgnoreCase("TOP>") || ((String)object).equalsIgnoreCase("TEXTTOP>")) {
                        n6 = nArray[2];
                        n7 = n5 - nArray[2];
                    } else if (((String)object).equalsIgnoreCase("MIDDLE>") || ((String)object).equalsIgnoreCase("CENTER>") || ((String)object).equalsIgnoreCase("ABSCENTER>")) {
                        n6 = (nArray[2] + nArray[3]) / 2 + n5 / 2 - Math.min(nArray[2], nArray[3]);
                        n7 = n5 - n6;
                    } else {
                        n6 = n5 - nArray[3];
                        n7 = nArray[3];
                    }
                    nArray[0] = Math.max(nArray[0], n6);
                    nArray[1] = Math.max(nArray[1], n7);
                }
                ++n4;
            }
        }
        return nArray;
    }

    protected int indentWhat(Stack stack) {
        int n2 = 3;
        Enumeration enumeration = stack.elements();
        while (enumeration.hasMoreElements()) {
            Object e2 = enumeration.nextElement();
            if (e2 instanceof String) {
                if (e2.equals("UL")) {
                    n2 += 10;
                    continue;
                }
                if (!e2.equals("DL")) continue;
                n2 += 20;
                continue;
            }
            if (!(e2 instanceof Integer)) continue;
            n2 += 10;
        }
        return n2;
    }

    public void addLinkListener(LinkListener linkListener) {
        if (this.ears == null) {
            this.ears = new Vector();
        }
        if (this.ears.indexOf(linkListener) == -1) {
            this.ears.addElement(linkListener);
        }
    }

    public void removeLinkListener(LinkListener linkListener) {
        int n2;
        if (this.ears != null && (n2 = this.ears.indexOf(linkListener)) > -1) {
            this.ears.removeElementAt(n2);
        }
    }

    public void addMultiLineListener(MultiLineListener multiLineListener) {
        this.listenerList.add(class$com$ibm$db2$tools$common$MultiLineListener == null ? (class$com$ibm$db2$tools$common$MultiLineListener = DiagnosisRenderer.class$("com.ibm.db2.tools.common.MultiLineListener")) : class$com$ibm$db2$tools$common$MultiLineListener, multiLineListener);
    }

    public void removeMultiLineListener(MultiLineListener multiLineListener) {
        this.listenerList.remove(class$com$ibm$db2$tools$common$MultiLineListener == null ? (class$com$ibm$db2$tools$common$MultiLineListener = DiagnosisRenderer.class$("com.ibm.db2.tools.common.MultiLineListener")) : class$com$ibm$db2$tools$common$MultiLineListener, multiLineListener);
    }

    private String getAttrValue(String string, String string2) {
        int n2 = string.length();
        int n3 = 0;
        int n4 = string2.length();
        char c2 = '\u0000';
        while (n3 < n4 - n2 && !string2.substring(n3, n3 + n2).equalsIgnoreCase(string)) {
            ++n3;
        }
        if (string2.substring(n3, n3 + n2).equalsIgnoreCase(string)) {
            n3 += n2;
            while (string2.charAt(n3) != '=') {
                ++n3;
            }
            char c3 = string2.charAt(++n3);
            while (c3 == ' ' || c3 == '\'' || c3 == '\"') {
                if (c3 != ' ') {
                    c2 = c3;
                }
                c3 = string2.charAt(++n3);
            }
            int n5 = n3 + 1;
            c3 = string2.charAt(n5 - 1);
            while (c2 != '\u0000' && c3 != c2 && c3 != '>' || c2 == '\u0000' && c3 != ' ' && c3 != '>' && c3 != '\'' && c3 != '\"') {
                c3 = string2.charAt(++n5 - 1);
            }
            return string2.substring(n3, n5 - 1);
        }
        return null;
    }

    private URL getSourceURL(String string) {
        if (string == null) {
            return null;
        }
        try {
            URL uRL = new URL(string);
            return uRL;
        }
        catch (MalformedURLException malformedURLException) {
            System.err.println("DiagnosisRenderer.getSourceURL error: " + malformedURLException);
            return null;
        }
    }

    protected String getHref(Point point) {
        if (this.anchors != null) {
            int n2 = 0;
            while (n2 < this.anchors.size()) {
                Anchor anchor = (Anchor)this.anchors.elementAt(n2);
                if (anchor.contains(point)) {
                    return anchor.getHref();
                }
                ++n2;
            }
        }
        return null;
    }

    protected int anchorIndex(String string) {
        if (this.anchors != null) {
            int n2 = 0;
            while (n2 < this.anchors.size()) {
                Anchor anchor = (Anchor)this.anchors.elementAt(n2);
                if (anchor.getHref().equals(string)) {
                    return n2;
                }
                ++n2;
            }
        }
        return -1;
    }

    public int getDisplayedMnemonic() {
        return 0;
    }

    public boolean isFocusTraversable() {
        return super.isFocusTraversable() || this.hyperLinkPolicy && this.anchors != null && this.anchors.size() > 0;
    }

    public boolean isRequestFocusEnabled() {
        return this.isFocusTraversable();
    }

    public boolean isManagingFocus() {
        return this.isFocusTraversable();
    }

    protected void processFocusEvent(FocusEvent focusEvent) {
        super.processFocusEvent(focusEvent);
        this.invalidate();
        this.repaint();
        String string = this.getFocusedLink();
        if (string != null) {
            this.fireLinkChanged(string, 1001);
        }
    }

    public String getFocusedLink() {
        if (this.hasFocus() && this.anchors != null && this.anchors.size() > 0) {
            return ((Anchor)this.anchors.elementAt(this.focusAnchor)).getHref();
        }
        return null;
    }

    public void processKeyEvent(KeyEvent keyEvent) {
        if (this.hasFocus() && this.anchors != null && this.anchors.size() > 0) {
            int n2 = keyEvent.getID();
            char c2 = keyEvent.getKeyChar();
            int n3 = keyEvent.getKeyCode();
            int n4 = keyEvent.getModifiers();
            if (n2 == 401) {
                if (n3 == 10) {
                    Anchor anchor = (Anchor)this.anchors.elementAt(this.focusAnchor);
                    String string = anchor.getHref();
                    if (string != null) {
                        this.fireLinkChanged(string, 1000);
                        keyEvent.consume();
                    }
                } else if (n3 == 9 || c2 == '\t') {
                    if ((n4 & 1) == 0) {
                        if ((n4 & 2) == 0 && this.focusAnchor < this.anchors.size() - 1) {
                            this.fireLinkChanged(this.getFocusedLink(), 1002);
                            ++this.focusAnchor;
                            String string = this.getFocusedLink();
                            if (string != null) {
                                this.fireLinkChanged(this.getFocusedLink(), 1001);
                            }
                        } else {
                            this.fireLinkChanged(this.getFocusedLink(), 1002);
                            FocusManager.getCurrentManager().focusNextComponent(this);
                        }
                    } else if ((n4 & 2) == 0 && this.focusAnchor > 0) {
                        this.fireLinkChanged(this.getFocusedLink(), 1002);
                        --this.focusAnchor;
                        String string = this.getFocusedLink();
                        if (string != null) {
                            this.fireLinkChanged(this.getFocusedLink(), 1001);
                        }
                    } else {
                        this.fireLinkChanged(this.getFocusedLink(), 1002);
                        FocusManager.getCurrentManager().focusPreviousComponent(this);
                    }
                    keyEvent.consume();
                    this.invalidate();
                    this.repaint();
                }
            } else if (n2 != 401 && (n3 == 9 || c2 == '\t')) {
                keyEvent.consume();
            }
        }
        if (!keyEvent.isConsumed()) {
            super.processKeyEvent(keyEvent);
        }
    }

    protected void fireLinkChanged(String string, int n2) {
        Object[] objectArray = this.listenerList.getListenerList();
        if (objectArray.length > 0) {
            MultiLineEvent multiLineEvent = new MultiLineEvent(this, string, n2);
            int n3 = objectArray.length - 2;
            while (n3 >= 0) {
                if (objectArray[n3] == (class$com$ibm$db2$tools$common$MultiLineListener == null ? DiagnosisRenderer.class$("com.ibm.db2.tools.common.MultiLineListener") : class$com$ibm$db2$tools$common$MultiLineListener)) {
                    ((MultiLineListener)objectArray[n3 + 1]).linkStateChanged(multiLineEvent);
                }
                n3 -= 2;
            }
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.isFocusTraversable()) {
            this.grabFocus();
        }
        if (this.curHref != null) {
            this.focusAnchor = this.anchorIndex(this.curHref);
            this.invalidate();
            this.repaint();
            if (this.ears != null && this.ears.size() > 0) {
                LinkEvent linkEvent = new LinkEvent(this, this.curHref, 1000);
                Enumeration enumeration = this.ears.elements();
                while (enumeration.hasMoreElements()) {
                    ((LinkListener)enumeration.nextElement()).linkStateChanged(linkEvent);
                }
            }
            this.fireLinkChanged(this.curHref, 1000);
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        String string = this.getHref(mouseEvent.getPoint());
        if (string != null) {
            if (!string.equals(this.curHref)) {
                if (this.ears != null && this.ears.size() > 0) {
                    LinkEvent linkEvent = new LinkEvent(this, string, 1001);
                    Enumeration enumeration = this.ears.elements();
                    while (enumeration.hasMoreElements()) {
                        ((LinkListener)enumeration.nextElement()).linkStateChanged(linkEvent);
                    }
                }
                this.fireLinkChanged(string, 1001);
                this.curHref = string;
                this.setCursor(Cursor.getPredefinedCursor(12));
            }
        } else if (this.curHref != null) {
            if (this.ears != null && this.ears.size() > 0) {
                LinkEvent linkEvent = new LinkEvent(this, string, 1002);
                Enumeration enumeration = this.ears.elements();
                while (enumeration.hasMoreElements()) {
                    ((LinkListener)enumeration.nextElement()).linkStateChanged(linkEvent);
                }
            }
            this.fireLinkChanged(this.curHref, 1002);
            this.curHref = null;
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.mouseEntered(mouseEvent);
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleDiagnosisRenderer();
        }
        return this.accessibleContext;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        otherEndPunctuationMarks = ".!,:;?";
    }

    protected class AccessibleDiagnosisRenderer
    extends JComponent.AccessibleJComponent {
        private static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
        protected AccessibleRole role = AccessibleRole.TOOL_TIP;

        protected AccessibleDiagnosisRenderer() {
            super(DiagnosisRenderer.this);
        }

        public void setAccessibleRole(AccessibleRole accessibleRole) {
            this.role = accessibleRole;
        }

        public AccessibleRole getAccessibleRole() {
            return this.role;
        }

        public String getAccessibleName() {
            Diagnosis diagnosis;
            String string = super.getAccessibleName();
            if (string == null && (diagnosis = DiagnosisRenderer.this.getDiagnosis()) != null) {
                string = diagnosis.getDescription();
            }
            return string;
        }

        public String getAccessibleDescription() {
            String string = super.getAccessibleDescription();
            if (string == null) {
                string = DiagnosisRenderer.this.multiLineMsg;
            }
            return string;
        }
    }

    protected class Anchor
    implements Serializable {
        protected String href;
        protected Vector rectangles;

        public Anchor(String string) {
            this.href = string;
            this.rectangles = new Vector();
        }

        public void addRectangle(Rectangle rectangle) {
            if (!this.rectangles.contains(rectangle)) {
                this.rectangles.addElement(rectangle);
            }
        }

        public boolean contains(Point point) {
            int n2 = 0;
            while (n2 < this.rectangles.size()) {
                Rectangle rectangle = (Rectangle)this.rectangles.elementAt(n2);
                if (rectangle.contains(point)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        public String getHref() {
            return this.href;
        }
    }
}

