/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common.smartx.support;

import com.ibm.db2.tools.common.smartx.event.Diagnosis;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.AbstractListModel;

public class DiagnosisModel
extends AbstractListModel
implements Serializable {
    private static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    Vector diags = new Vector();

    public void fireResized(int n2) {
        this.fireContentsChanged(this, n2, n2);
    }

    public int findDiagnosis(Diagnosis diagnosis) {
        Object object = diagnosis.getContext();
        int n2 = 0;
        Enumeration enumeration = this.diags.elements();
        while (enumeration.hasMoreElements()) {
            if (object.equals(((Diagnosis)enumeration.nextElement()).getContext())) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public void addDiagnosis(Diagnosis diagnosis) {
        int n2 = this.findDiagnosis(diagnosis);
        if (n2 > -1) {
            this.diags.setElementAt(diagnosis, n2);
            this.fireContentsChanged(this, n2, n2);
        } else {
            this.diags.addElement(diagnosis);
            n2 = this.diags.size() - 1;
            this.fireIntervalAdded(this, n2, n2);
        }
    }

    public void removeDiagnosis(Diagnosis diagnosis) {
        int n2 = this.diags.indexOf(diagnosis);
        this.diags.removeElementAt(n2);
        this.fireIntervalRemoved(this, n2, n2);
    }

    public void removeDiagnosis(Object object) {
        int n2 = this.diags.size();
        int n3 = 0;
        while (n3 < n2 && ((Diagnosis)this.diags.elementAt(n3)).getContext() != object) {
            ++n3;
        }
        if (n3 < n2) {
            this.diags.removeElementAt(n3);
            this.fireIntervalRemoved(this, n3, n3);
        }
    }

    public int getSize() {
        if (this.diags == null) {
            return 0;
        }
        return this.diags.size();
    }

    public void setSize(int n2) {
        int n3 = this.diags.size();
        this.diags.setSize(n2);
        if (n3 > n2) {
            this.fireIntervalRemoved(this, n2, n3 - 1);
        } else if (n3 < n2) {
            this.fireIntervalAdded(this, n3, n2 - 1);
        }
    }

    public Object getElementAt(int n2) {
        if (this.diags == null) {
            return null;
        }
        return (Diagnosis)this.diags.elementAt(n2);
    }

    public Diagnosis getDiagnosisAt(int n2) {
        if (this.diags == null) {
            return null;
        }
        return (Diagnosis)this.diags.elementAt(n2);
    }
}

