/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common.smartx.support;

import com.ibm.db2.tools.common.smartx.event.Diagnosis;
import com.ibm.db2.tools.common.smartx.event.SmartListener;
import com.ibm.db2.tools.common.smartx.support.DiagnosisModel;
import com.ibm.db2.tools.common.smartx.support.DiagnosisRenderer;
import com.ibm.db2.tools.common.smartx.support.DiagnosisView;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Toolkit;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;

public class DiagnosisManager
implements Serializable {
    private static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected DiagnosisModel model;
    protected JList list;
    protected JScrollPane scrollPane;
    protected WrappingCellRenderer listRenderer;
    protected boolean dialogView;
    protected DiagnosisView view;

    public DiagnosisManager() {
        this(false);
    }

    public DiagnosisManager(boolean bl) {
        this.dialogView = bl;
        this.model = new DiagnosisModel();
        this.createList();
    }

    protected void createList() {
        this.list = new JList(this.model);
        this.list.setBackground(UIManager.getColor("text"));
        this.list.setSelectionMode(2);
        this.list.setVisibleRowCount(4);
        if (this.model.getSize() > 0) {
            this.list.setSelectedIndex(0);
        }
        this.listRenderer = new WrappingCellRenderer(this.model);
        this.list.setCellRenderer(this.listRenderer);
        this.scrollPane = new JScrollPane(this.list);
        this.scrollPane.setHorizontalScrollBarPolicy(31);
        this.scrollPane.setVerticalScrollBarPolicy(22);
        this.scrollPane.setBorder(BorderFactory.createLoweredBevelBorder());
    }

    public JList getList() {
        return this.list;
    }

    public JScrollPane getScrollPane() {
        return this.scrollPane;
    }

    public DiagnosisModel getModel() {
        return this.model;
    }

    public void resizeList() {
        if (this.listRenderer != null) {
            this.listRenderer.resize();
        }
    }

    public void showDiagnosisView(JFrame jFrame, String string) {
        if (this.dialogView) {
            if (this.view == null) {
                this.view = new DiagnosisView(this, jFrame, string);
                Insets insets = this.view.getInsets();
                ((Component)this.view).setSize(insets.left + insets.right + 400, insets.top + insets.bottom + 300);
                Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
                if (dimension != null) {
                    int n2 = dimension.width / 10 << 2;
                    int n3 = dimension.height / 10;
                    ((Component)this.view).setLocation(n2, n3);
                }
            }
            ((Component)this.view).setVisible(true);
        }
    }

    public Diagnosis addDiagnosis(SmartListener smartListener, Object object, String string, Diagnosis diagnosis) {
        diagnosis.setSmartListener(smartListener);
        diagnosis.setContext(object);
        diagnosis.setDescription(string);
        this.model.addDiagnosis(diagnosis);
        return diagnosis;
    }

    public Diagnosis addDiagnosis(SmartListener smartListener, Object object, String string, Vector vector, Vector vector2) {
        Diagnosis diagnosis = new Diagnosis(smartListener, object, string, vector, vector2);
        this.model.addDiagnosis(diagnosis);
        return diagnosis;
    }

    public void removeDiagnosis(Diagnosis diagnosis) {
        this.model.removeDiagnosis(diagnosis);
    }

    public void removeDiagnosis(Object object) {
        this.model.removeDiagnosis(object);
    }

    public void openListener(int n2) {
        Diagnosis diagnosis = this.model.getDiagnosisAt(n2);
        diagnosis.getSmartListener().openWithDiagnosis(diagnosis.getContext(), diagnosis);
    }

    public void fixListener(int n2) {
        Diagnosis diagnosis = this.model.getDiagnosisAt(n2);
        diagnosis.getSmartListener().openWithFix(diagnosis.getContext(), diagnosis);
    }

    class WrappingCellRenderer
    implements ListCellRenderer,
    Serializable {
        DiagnosisModel model;
        Vector rends;

        public WrappingCellRenderer(DiagnosisModel diagnosisModel) {
            this.model = diagnosisModel;
            this.rends = new Vector(10);
        }

        public void resize() {
            int n2 = DiagnosisManager.this.scrollPane.getViewport().getWidth();
            if (n2 > 0) {
                int n3 = 0;
                Enumeration enumeration = this.rends.elements();
                while (enumeration.hasMoreElements() && n3 < this.model.getSize()) {
                    DiagnosisRenderer diagnosisRenderer = (DiagnosisRenderer)enumeration.nextElement();
                    if (diagnosisRenderer != null && diagnosisRenderer.getDiagnosis() != null) {
                        diagnosisRenderer.wrap(n2);
                        this.model.fireResized(n3);
                    }
                    ++n3;
                }
            }
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n2, boolean bl, boolean bl2) {
            Color color;
            Color color2;
            if (this.rends.size() <= n2) {
                while (this.rends.size() <= n2) {
                    this.rends.addElement(new DiagnosisRenderer());
                }
            }
            if (bl) {
                color2 = UIManager.getColor("textHighlightText");
                color = UIManager.getColor("textHighlight");
            } else {
                color2 = UIManager.getColor("textText");
                color = UIManager.getColor("text");
            }
            DiagnosisRenderer diagnosisRenderer = (DiagnosisRenderer)this.rends.elementAt(n2);
            diagnosisRenderer.setForeground(color2);
            diagnosisRenderer.setBackground(color);
            Diagnosis diagnosis = diagnosisRenderer.getDiagnosis();
            if (diagnosis == null || diagnosis != (Diagnosis)object) {
                int n3 = DiagnosisManager.this.scrollPane.getViewport().getWidth();
                if (n3 > 0) {
                    diagnosisRenderer.configure(jList.getGraphics(), (Diagnosis)object);
                    diagnosisRenderer.wrap(n3);
                    this.model.fireResized(n2);
                } else {
                    diagnosisRenderer.setPreferredSize(new Dimension(365, diagnosisRenderer.getLineHeight() * 2));
                }
            }
            return diagnosisRenderer;
        }
    }
}

