/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common.smartx.event;

import com.ibm.db2.tools.common.smartx.event.SmartListener;
import com.ibm.db2.tools.common.smartx.support.SmartResources;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

public class Diagnosis
implements Serializable {
    private static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected SmartListener listener;
    protected Object context;
    protected String description;
    protected Vector diagCodes;
    protected Vector diagMsgs;
    protected String attachedInfoPop;
    protected Diagnosis nextDiagnosis;

    public Diagnosis(SmartListener smartListener, Object object, String string, Vector vector, Vector vector2) {
        this.listener = smartListener;
        this.context = object;
        this.description = string;
        this.diagCodes = vector;
        this.diagMsgs = vector2;
        this.attachedInfoPop = null;
    }

    public Diagnosis(Vector vector, Vector vector2) {
        this.diagCodes = vector;
        this.diagMsgs = vector2;
    }

    public Diagnosis() {
        this.diagCodes = new Vector(2, 2);
        this.diagMsgs = new Vector(2, 2);
    }

    public Diagnosis(String string) {
        this.description = string;
    }

    public void addDiagnostic(int n2, String string) {
        this.diagCodes.addElement(new Integer(n2));
        this.diagMsgs.addElement(string);
    }

    public boolean equals(Object object) {
        Vector vector;
        if (object == null || !(object instanceof Diagnosis)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        int n2 = this.diagCodes.size();
        if (n2 != (vector = ((Diagnosis)object).getCodes()).size()) {
            return false;
        }
        int n3 = 0;
        while (n3 < n2) {
            if (!this.diagCodes.elementAt(n3).equals(vector.elementAt(n3))) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.diagMsgs.elements();
        while (enumeration.hasMoreElements()) {
            stringBuffer.append(enumeration.nextElement());
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public String taggedString() {
        if (this.diagMsgs == null) {
            return this.description;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<html><body><p><b>");
        stringBuffer.append(this.getDescription()).append("</b><ul>");
        Enumeration enumeration = this.diagMsgs.elements();
        while (enumeration.hasMoreElements()) {
            stringBuffer.append("<li>").append(enumeration.nextElement()).append("</li>");
        }
        stringBuffer.append("</ul>");
        if (this.attachedInfoPop != null) {
            stringBuffer.append("<p><b>");
            stringBuffer.append(SmartResources.get(218));
            stringBuffer.append("</b>");
            stringBuffer.append(this.attachedInfoPop);
        }
        stringBuffer.append("</body></html>");
        return stringBuffer.toString();
    }

    public void setSmartListener(SmartListener smartListener) {
        this.listener = smartListener;
    }

    public SmartListener getSmartListener() {
        return this.listener;
    }

    public void setContext(Object object) {
        this.context = object;
    }

    public Object getContext() {
        return this.context;
    }

    public String stripParens(String string) {
        int n2 = string.indexOf("(");
        if (n2 > -1) {
            return string.substring(0, n2).trim();
        }
        return string;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public String getDescription() {
        return this.description;
    }

    public int getLastCode() {
        if (this.diagCodes != null && this.diagCodes.size() > 0) {
            return (Integer)this.diagCodes.lastElement();
        }
        return 0;
    }

    public Vector getCodes() {
        return this.diagCodes;
    }

    public Vector getDiagnoses() {
        return this.diagMsgs;
    }

    public void clearDiagnoses() {
        if (this.diagCodes != null) {
            this.diagCodes.setSize(0);
        }
        if (this.diagMsgs != null) {
            this.diagMsgs.setSize(0);
        }
    }

    public int[] getCodesArray() {
        int[] nArray = new int[this.diagCodes.size()];
        int n2 = 0;
        Enumeration enumeration = this.diagCodes.elements();
        while (enumeration.hasMoreElements()) {
            nArray[n2] = (Integer)enumeration.nextElement();
            ++n2;
        }
        return nArray;
    }

    public boolean hasCode(int n2) {
        if (this.diagCodes != null) {
            Enumeration enumeration = this.diagCodes.elements();
            while (enumeration.hasMoreElements()) {
                if ((Integer)enumeration.nextElement() != n2) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasError() {
        if (this.diagCodes != null) {
            Enumeration enumeration = this.diagCodes.elements();
            while (enumeration.hasMoreElements()) {
                if ((Integer)enumeration.nextElement() >= 0) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasDiagnosis() {
        if (this.diagCodes != null) {
            return this.diagCodes.size() > 0;
        }
        return false;
    }

    public String[] getDiagnosesArray() {
        Object[] objectArray = new String[this.diagMsgs.size()];
        this.diagMsgs.copyInto(objectArray);
        return objectArray;
    }

    public void include(Diagnosis diagnosis) {
        Vector vector = diagnosis.getCodes();
        Vector vector2 = diagnosis.getDiagnoses();
        int n2 = vector.size();
        int n3 = 0;
        while (n3 < n2) {
            Integer n4 = (Integer)vector.elementAt(n3);
            if (!this.diagCodes.contains(n4)) {
                this.diagMsgs.addElement(vector2.elementAt(n3));
                this.diagCodes.addElement(n4);
            }
            ++n3;
        }
    }

    public void attachInfoPop(String string) {
        this.attachedInfoPop = string;
    }

    public void setNextDiagnosis(Diagnosis diagnosis) {
        this.nextDiagnosis = diagnosis;
    }

    public Diagnosis getNextDiagnosis() {
        return this.nextDiagnosis;
    }
}

