/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common.smartx;

import com.ibm.db2.tools.common.AssistEllipsis;
import com.ibm.db2.tools.common.AssistField;
import com.ibm.db2.tools.common.AssistTable;
import com.ibm.db2.tools.common.event.AssistListener;
import com.ibm.db2.tools.common.smartx.SmartArea;
import com.ibm.db2.tools.common.smartx.SmartCheck;
import com.ibm.db2.tools.common.smartx.SmartCombo;
import com.ibm.db2.tools.common.smartx.SmartEllipsis;
import com.ibm.db2.tools.common.smartx.SmartField;
import com.ibm.db2.tools.common.smartx.SmartPassword;
import com.ibm.db2.tools.common.smartx.SmartSpinner;
import com.ibm.db2.tools.common.smartx.event.Diagnosis;
import com.ibm.db2.tools.common.smartx.event.DiagnosisEvent;
import com.ibm.db2.tools.common.smartx.event.DiagnosisListener;
import com.ibm.db2.tools.common.smartx.event.UniquenessListener;
import com.ibm.db2.tools.common.smartx.support.DiagnosisRenderer;
import com.ibm.db2.tools.common.smartx.support.SmartComboBoxModel;
import com.ibm.db2.tools.common.smartx.support.SmartComponent;
import com.ibm.db2.tools.common.smartx.support.SmartConstraints;
import com.ibm.db2.tools.common.smartx.support.SmartManager;
import com.ibm.db2.tools.common.smartx.support.SmartMenu;
import com.ibm.db2.tools.common.smartx.support.SmartMenuItem;
import com.ibm.db2.tools.common.smartx.support.SmartPopup;
import com.ibm.db2.tools.common.smartx.support.SmartResources;
import com.ibm.db2.tools.common.smartx.support.SmartTableCellEditor;
import com.ibm.db2.tools.common.smartx.support.SmartTableCellRenderer;
import com.ibm.db2.tools.common.smartx.support.SmartTableModel;
import com.ibm.db2.tools.common.smartx.support.SmartVerifier;
import com.ibm.db2.tools.common.support.AssistComponent;
import com.ibm.db2.tools.common.support.AssistManager;
import com.ibm.db2.tools.common.support.AssistTableCellEditor;
import com.ibm.db2.tools.common.support.AssistTableModel;
import com.ibm.db2.tools.common.support.CellExpander;
import com.ibm.db2.tools.common.support.CellExpanderManager;
import com.ibm.db2.tools.common.support.CellExpanderRenderer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.TextComponent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.font.LineMetrics;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.Timer;
import javax.swing.border.Border;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.text.JTextComponent;

public class SmartTable
extends AssistTable
implements SmartComponent,
DiagnosisListener,
UniquenessListener,
ActionListener,
Serializable {
    private static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected Hashtable previousDiagnoses;
    protected DiagnosisEvent diagnosisEvent;
    protected Hashtable diagnosisContexts;
    protected Timer diagTimer;
    protected int delay;
    protected SmartPopup mPopup;
    public SmartMenuItem miEdit;
    public SmartMenuItem miSort;
    public SmartMenu miMarkSort;
    public SmartMenuItem miAsc;
    public SmartMenuItem miDesc;
    public SmartMenuItem miUnmark;
    public MenuElement[] editMenuElements;
    protected boolean editable;
    static /* synthetic */ Class class$javax$swing$JTextField;
    static /* synthetic */ Class class$com$ibm$db2$tools$common$smartx$SmartField;
    static /* synthetic */ Class class$javax$swing$JPasswordField;
    static /* synthetic */ Class class$com$ibm$db2$tools$common$AssistPassword;
    static /* synthetic */ Class class$javax$swing$JTextArea;
    static /* synthetic */ Class class$com$ibm$db2$tools$common$smartx$SmartArea;
    static /* synthetic */ Class class$javax$swing$JCheckBox;
    static /* synthetic */ Class class$com$ibm$db2$tools$common$smartx$SmartCheck;
    static /* synthetic */ Class class$javax$swing$JButton;
    static /* synthetic */ Class class$javax$swing$JPanel;
    static /* synthetic */ Class class$com$ibm$db2$tools$common$smartx$SmartEllipsis;
    static /* synthetic */ Class class$com$ibm$db2$tools$common$smartx$SmartSpinner;
    static /* synthetic */ Class class$com$ibm$db2$tools$common$support$AssistCheck;

    public SmartTable(Frame frame, SmartTableModel smartTableModel, String[] stringArray, String string, boolean bl, boolean bl2) {
        super(frame, smartTableModel, stringArray, string, bl, bl2);
    }

    public SmartTable(Frame frame, SmartTableModel smartTableModel, String[] stringArray, String string, boolean bl) {
        super(frame, smartTableModel, stringArray, string, bl);
    }

    public SmartTable(Frame frame, SmartTableModel smartTableModel, String[] stringArray, boolean bl) {
        super(frame, smartTableModel, stringArray, bl);
    }

    protected void init(boolean bl, AssistTableModel assistTableModel, String[] stringArray, String string, boolean bl2, boolean bl3) {
        this.diagnosisContexts = new Hashtable(2);
        this.previousDiagnoses = new Hashtable(20);
        super.init(false, assistTableModel, stringArray, string, bl2, bl3);
        this.mPopup = new SmartPopup();
        this.add(this.mPopup);
        this.miEdit = new SmartMenuItem(SmartResources.get(199), SmartResources.getMnemonic(199));
        this.miSort = new SmartMenuItem(SmartResources.get(200), SmartResources.getMnemonic(200));
        this.miMarkSort = new SmartMenu(SmartResources.get(201));
        this.miMarkSort.setMnemonic(SmartResources.getMnemonic(201));
        this.miAsc = new SmartMenuItem(SmartResources.get(202), SmartResources.getMnemonic(202));
        this.miDesc = new SmartMenuItem(SmartResources.get(203), SmartResources.getMnemonic(203));
        this.miUnmark = new SmartMenuItem(SmartResources.get(204), SmartResources.getMnemonic(204));
        int n2 = this.columnModel.getColumnCount();
        this.editable = false;
        int n3 = 0;
        while (n3 < n2) {
            if (assistTableModel.isColEditable(n3)) {
                this.editable = true;
                break;
            }
            ++n3;
        }
        if (this.editable) {
            this.mPopup.add(this.miEdit);
        }
        this.miMarkSort.add(this.miAsc);
        this.miMarkSort.add(this.miDesc);
        this.miMarkSort.add(this.miUnmark);
        this.editMenuElements = new MenuElement[2];
        this.editMenuElements[0] = this.miSort;
        this.editMenuElements[1] = this.miMarkSort;
        this.miEdit.setAccelerator(KeyStroke.getKeyStroke(SmartResources.getAcceleratorCode(199), SmartResources.getAcceleratorModifierMask(199)));
        this.miSort.setAccelerator(KeyStroke.getKeyStroke(SmartResources.getAcceleratorCode(200), SmartResources.getAcceleratorModifierMask(200)));
        this.miAsc.setAccelerator(KeyStroke.getKeyStroke(SmartResources.getAcceleratorCode(202), SmartResources.getAcceleratorModifierMask(202)));
        this.miDesc.setAccelerator(KeyStroke.getKeyStroke(SmartResources.getAcceleratorCode(203), SmartResources.getAcceleratorModifierMask(203)));
        this.miUnmark.setAccelerator(KeyStroke.getKeyStroke(SmartResources.getAcceleratorCode(204), SmartResources.getAcceleratorModifierMask(204)));
        this.miEdit.addActionListener(this);
        this.miSort.addActionListener(this);
        this.miAsc.addActionListener(this);
        this.miDesc.addActionListener(this);
        this.miUnmark.addActionListener(this);
    }

    public void addDiagnosisListener(DiagnosisListener diagnosisListener, Object object) {
        this.removeDiagnosisListener(diagnosisListener);
        this.assistListeners.add(SmartManager.getClass("DiagnosisListener"), diagnosisListener);
        this.diagnosisContexts.put(diagnosisListener, object);
        if (this.diagnosisEvent == null) {
            this.diagnosisEvent = new DiagnosisEvent(this);
        }
        if (this.assistContext == null) {
            this.assistContext = object;
        }
        this.verifySmartEditors();
        this.valuePreviouslyValid = this.dataValid && this.modelValid;
        diagnosisListener.diagnosisChanged(this.diagnosisEvent);
    }

    public void removeDiagnosisListener(DiagnosisListener diagnosisListener) {
        if (this.diagnosisContexts.get(diagnosisListener) != null) {
            this.diagnosisContexts.remove(diagnosisListener);
            this.assistListeners.remove(SmartManager.getClass("DiagnosisListener"), diagnosisListener);
        }
    }

    protected void verifySmartEditors() {
        if (this.previousDiagnoses == null) {
            return;
        }
        int n2 = this.dataModel.getRowCount();
        int n3 = this.columnModel.getColumnCount();
        int n4 = 0;
        while (n4 < n3) {
            if (((AssistTableModel)this.dataModel).isColEditable(this.convertColumnIndexToModel(n4))) {
                int n5 = 0;
                while (n5 < n2) {
                    Component component = this.getEditingComponent(n5, n4);
                    if (component instanceof JScrollPane) {
                        component = ((JScrollPane)component).getViewport().getView();
                    }
                    if (component instanceof SmartComponent) {
                        ((SmartComponent)((Object)component)).addDiagnosisListener(this, "");
                        ((SmartComponent)((Object)component)).removeDiagnosisListener(this);
                    }
                    ++n5;
                }
            }
            ++n4;
        }
    }

    public Diagnosis getDiagnosis() {
        if (this.dataValid) {
            return null;
        }
        Diagnosis diagnosis = null;
        Enumeration enumeration = this.previousDiagnoses.elements();
        if (enumeration.hasMoreElements()) {
            diagnosis = (Diagnosis)enumeration.nextElement();
        }
        while (enumeration.hasMoreElements()) {
            diagnosis.setNextDiagnosis((Diagnosis)enumeration.nextElement());
        }
        if (diagnosis != null) {
            diagnosis.setNextDiagnosis(null);
        }
        return diagnosis;
    }

    public Object getDiagnosisContext(DiagnosisListener diagnosisListener) {
        return this.diagnosisContexts.get(diagnosisListener);
    }

    public void setTipPosition(int n2) {
    }

    public int getTipPosition() {
        return -1;
    }

    public boolean allowLink() {
        return false;
    }

    public boolean allowPopup() {
        return false;
    }

    public void setAllowLink(boolean bl) {
    }

    public void setAllowPopup(boolean bl) {
    }

    public void showPopup(Component component, Point point) {
    }

    public void hidePopup() {
    }

    public boolean verifyData(TableModelEvent tableModelEvent) {
        this.dataValid = true;
        if (this.previousDiagnoses == null) {
            return true;
        }
        if (this.isEnabled()) {
            int n2 = this.getRowCount();
            int n3 = this.columnModel.getColumnCount();
            int n4 = 0;
            while (n4 < n2) {
                int n5 = 0;
                while (n5 < n3) {
                    JComponent jComponent;
                    if (this.dataModel.isCellEditable(n4, this.convertColumnIndexToModel(n5)) && (jComponent = this.getEditingComponent(n4, n5)) != null && this.previousDiagnoses.get(jComponent) != null) {
                        this.dataValid = false;
                        return false;
                    }
                    ++n5;
                }
                ++n4;
            }
        }
        return this.dataValid;
    }

    public void diagnosisChanged(DiagnosisEvent diagnosisEvent) {
        this.fireValidityChanged(diagnosisEvent);
    }

    protected void fireValidityChanged() {
        this.delay = SmartManager.getDelayPolicy();
        if (this.delay > 0 && this.diagTimer == null) {
            this.diagTimer = new Timer(this.delay, this);
            this.diagTimer.setInitialDelay(this.delay);
            this.diagTimer.setRepeats(false);
        }
        if (this.diagnosisEvent == null) {
            this.diagnosisEvent = new DiagnosisEvent(this);
        }
        if (this.delay > 0) {
            this.diagTimer.restart();
        } else {
            this.fireValidityChanged(this.diagnosisEvent);
        }
    }

    public void fireValidityChanged(Diagnosis diagnosis) {
        if (this.diagnosisEvent == null) {
            this.diagnosisEvent = new DiagnosisEvent(this);
        }
        this.fireValidityChanged(this.diagnosisEvent);
    }

    protected void fireValidityChanged(DiagnosisEvent diagnosisEvent) {
        Object object;
        if (this.assistListeners == null) {
            return;
        }
        SmartComponent smartComponent = (SmartComponent)diagnosisEvent.getSource();
        Diagnosis diagnosis = null;
        if (smartComponent != this) {
            diagnosis = diagnosisEvent.getDiagnosis();
        }
        if (diagnosis != null) {
            object = (String)smartComponent.getConstraints().getConstraint("TipDescription");
            if (object == null) {
                object = SmartResources.get(217);
            }
            diagnosis.setDescription((String)object);
        }
        if (((Object[])(object = this.assistListeners.getListenerList())).length > 0) {
            int n2 = ((Object[])object).length - 2;
            while (n2 >= 0) {
                if (object[n2] == SmartManager.getClass("AssistListener") && this.valuePreviouslyValid != (this.modelValid && this.dataValid)) {
                    ((AssistListener)object[n2 + 1]).validityChanged(this.assistEvent);
                } else if (object[n2] == SmartManager.getClass("DiagnosisListener")) {
                    if (smartComponent == this) {
                        ((DiagnosisListener)object[n2 + 1]).diagnosisChanged(this.diagnosisEvent);
                    } else if (diagnosis != null && !diagnosis.equals(this.previousDiagnoses.get(smartComponent))) {
                        this.previousDiagnoses.put(smartComponent, diagnosis);
                        this.verifyData(null);
                        ((DiagnosisListener)object[n2 + 1]).diagnosisChanged(this.diagnosisEvent);
                    } else if (diagnosis == null && this.previousDiagnoses.get(smartComponent) != null) {
                        this.previousDiagnoses.remove(smartComponent);
                        this.verifyData(null);
                        ((DiagnosisListener)object[n2 + 1]).diagnosisChanged(this.diagnosisEvent);
                    }
                }
                n2 -= 2;
            }
        }
        this.valuePreviouslyValid = this.modelValid && this.dataValid;
    }

    public TableCellRenderer getDefaultRenderer(Class clazz) {
        Object object = this.defaultRenderersByColumnClass.get(clazz);
        if (object == null || object instanceof String) {
            if (clazz == (class$javax$swing$JTextField == null ? (class$javax$swing$JTextField = SmartTable.class$("javax.swing.JTextField")) : class$javax$swing$JTextField) || clazz == (class$com$ibm$db2$tools$common$smartx$SmartField == null ? (class$com$ibm$db2$tools$common$smartx$SmartField = SmartTable.class$("com.ibm.db2.tools.common.smartx.SmartField")) : class$com$ibm$db2$tools$common$smartx$SmartField)) {
                SmartField smartField = new SmartField();
                smartField.setRequired(true);
                object = new SmartTableCellRenderer(smartField);
                this.defaultRenderersByColumnClass.put(clazz, object);
            } else if (clazz == SmartManager.getClass("char[]") || clazz == (class$javax$swing$JPasswordField == null ? (class$javax$swing$JPasswordField = SmartTable.class$("javax.swing.JPasswordField")) : class$javax$swing$JPasswordField) || clazz == (class$com$ibm$db2$tools$common$AssistPassword == null ? (class$com$ibm$db2$tools$common$AssistPassword = SmartTable.class$("com.ibm.db2.tools.common.AssistPassword")) : class$com$ibm$db2$tools$common$AssistPassword)) {
                SmartPassword smartPassword = new SmartPassword();
                object = new SmartTableCellRenderer(smartPassword);
                this.defaultRenderersByColumnClass.put(clazz, object);
            } else if (clazz == SmartManager.getClass("Number")) {
                SmartField smartField = new SmartField(new SmartConstraints(true, 12288), null);
                smartField.setHorizontalAlignment(4);
                object = new SmartTableCellRenderer(smartField);
                this.defaultRenderersByColumnClass.put(clazz, object);
            } else if (clazz == SmartManager.getClass("Vector")) {
                SmartCombo smartCombo = new SmartCombo((ComboBoxModel)new SmartComboBoxModel());
                smartCombo.setBorder(null);
                smartCombo.setRequired(true);
                object = new SmartTableCellRenderer(smartCombo);
                this.defaultRenderersByColumnClass.put(clazz, object);
            } else if (clazz == SmartManager.getClass("StringBuffer") || clazz == (class$javax$swing$JTextArea == null ? (class$javax$swing$JTextArea = SmartTable.class$("javax.swing.JTextArea")) : class$javax$swing$JTextArea) || clazz == (class$com$ibm$db2$tools$common$smartx$SmartArea == null ? (class$com$ibm$db2$tools$common$smartx$SmartArea = SmartTable.class$("com.ibm.db2.tools.common.smartx.SmartArea")) : class$com$ibm$db2$tools$common$smartx$SmartArea)) {
                SmartArea smartArea = new SmartArea();
                smartArea.setLineWrap(true);
                smartArea.setWrapStyleWord(true);
                smartArea.setRequired(true);
                object = new SmartTableCellRenderer(smartArea);
                this.defaultRenderersByColumnClass.put(clazz, object);
            } else if (clazz == SmartManager.getClass("Boolean") || clazz == (class$javax$swing$JCheckBox == null ? (class$javax$swing$JCheckBox = SmartTable.class$("javax.swing.JCheckBox")) : class$javax$swing$JCheckBox) || clazz == (class$com$ibm$db2$tools$common$smartx$SmartCheck == null ? (class$com$ibm$db2$tools$common$smartx$SmartCheck = SmartTable.class$("com.ibm.db2.tools.common.smartx.SmartCheck")) : class$com$ibm$db2$tools$common$smartx$SmartCheck)) {
                SmartCheck smartCheck = new SmartCheck();
                smartCheck.setHorizontalAlignment(0);
                object = new SmartTableCellRenderer(smartCheck);
                this.defaultRenderersByColumnClass.put(clazz, object);
            } else if (clazz == (class$javax$swing$JButton == null ? (class$javax$swing$JButton = SmartTable.class$("javax.swing.JButton")) : class$javax$swing$JButton) || clazz == (class$javax$swing$JPanel == null ? (class$javax$swing$JPanel = SmartTable.class$("javax.swing.JPanel")) : class$javax$swing$JPanel) || clazz == (class$com$ibm$db2$tools$common$smartx$SmartEllipsis == null ? (class$com$ibm$db2$tools$common$smartx$SmartEllipsis = SmartTable.class$("com.ibm.db2.tools.common.smartx.SmartEllipsis")) : class$com$ibm$db2$tools$common$smartx$SmartEllipsis)) {
                SmartEllipsis smartEllipsis = new SmartEllipsis();
                object = new SmartTableCellRenderer(smartEllipsis);
                this.defaultRenderersByColumnClass.put(clazz, object);
            } else if (clazz == (class$com$ibm$db2$tools$common$smartx$SmartSpinner == null ? (class$com$ibm$db2$tools$common$smartx$SmartSpinner = SmartTable.class$("com.ibm.db2.tools.common.smartx.SmartSpinner")) : class$com$ibm$db2$tools$common$smartx$SmartSpinner)) {
                SmartSpinner smartSpinner = new SmartSpinner();
                object = new SmartTableCellRenderer(smartSpinner);
                this.defaultRenderersByColumnClass.put(clazz, object);
            } else {
                object = super.getDefaultRenderer(clazz);
            }
        }
        return (TableCellRenderer)object;
    }

    public TableCellEditor getDefaultEditor(Class clazz) {
        Object object = this.defaultEditorsByColumnClass.get(clazz);
        if (object == null || object instanceof String) {
            object = this.constructDefaultEditorByClass(clazz);
            this.defaultEditorsByColumnClass.put(clazz, object);
        }
        return (TableCellEditor)object;
    }

    public TableCellEditor getDefaultEditor(Class clazz, int n2) {
        Object object = this.defaultEditorsByColumnClass.get(new Integer(n2));
        if (object == null || object instanceof String) {
            object = this.constructDefaultEditorByClass(clazz);
            this.defaultEditorsByColumnClass.put(new Integer(n2), object);
        }
        return (TableCellEditor)object;
    }

    protected TableCellEditor constructDefaultEditorByClass(Class clazz) {
        TableCellEditor tableCellEditor = null;
        if (clazz == SmartManager.getClass("Object") || clazz == (class$javax$swing$JTextField == null ? (class$javax$swing$JTextField = SmartTable.class$("javax.swing.JTextField")) : class$javax$swing$JTextField) || clazz == (class$com$ibm$db2$tools$common$smartx$SmartField == null ? (class$com$ibm$db2$tools$common$smartx$SmartField = SmartTable.class$("com.ibm.db2.tools.common.smartx.SmartField")) : class$com$ibm$db2$tools$common$smartx$SmartField)) {
            SmartField smartField = new SmartField();
            smartField.setRequired(true);
            tableCellEditor = new SmartTableCellEditor((JTable)this, smartField);
        } else if (clazz == SmartManager.getClass("char[]") || clazz == (class$javax$swing$JPasswordField == null ? (class$javax$swing$JPasswordField = SmartTable.class$("javax.swing.JPasswordField")) : class$javax$swing$JPasswordField) || clazz == (class$com$ibm$db2$tools$common$AssistPassword == null ? (class$com$ibm$db2$tools$common$AssistPassword = SmartTable.class$("com.ibm.db2.tools.common.AssistPassword")) : class$com$ibm$db2$tools$common$AssistPassword)) {
            SmartPassword smartPassword = new SmartPassword();
            tableCellEditor = new SmartTableCellEditor((JTable)this, smartPassword);
        } else if (clazz == SmartManager.getClass("Number")) {
            SmartField smartField = new SmartField(new SmartConstraints(true, 12288), null);
            smartField.setHorizontalAlignment(4);
            tableCellEditor = new SmartTableCellEditor((JTable)this, smartField);
        } else if (clazz == SmartManager.getClass("Vector")) {
            SmartCombo smartCombo = new SmartCombo((ComboBoxModel)new SmartComboBoxModel());
            smartCombo.setBorder(null);
            smartCombo.setRequired(true);
            tableCellEditor = new SmartTableCellEditor((JTable)this, smartCombo);
        } else if (clazz == SmartManager.getClass("StringBuffer") || clazz == (class$javax$swing$JTextArea == null ? (class$javax$swing$JTextArea = SmartTable.class$("javax.swing.JTextArea")) : class$javax$swing$JTextArea) || clazz == (class$com$ibm$db2$tools$common$smartx$SmartArea == null ? (class$com$ibm$db2$tools$common$smartx$SmartArea = SmartTable.class$("com.ibm.db2.tools.common.smartx.SmartArea")) : class$com$ibm$db2$tools$common$smartx$SmartArea)) {
            SmartArea smartArea = new SmartArea();
            smartArea.setLineWrap(true);
            smartArea.setWrapStyleWord(true);
            smartArea.setRequired(true);
            tableCellEditor = new SmartTableCellEditor((JTable)this, smartArea);
        } else if (clazz == SmartManager.getClass("Boolean") || clazz == (class$javax$swing$JCheckBox == null ? (class$javax$swing$JCheckBox = SmartTable.class$("javax.swing.JCheckBox")) : class$javax$swing$JCheckBox) || clazz == (class$com$ibm$db2$tools$common$support$AssistCheck == null ? (class$com$ibm$db2$tools$common$support$AssistCheck = SmartTable.class$("com.ibm.db2.tools.common.support.AssistCheck")) : class$com$ibm$db2$tools$common$support$AssistCheck) || clazz == (class$com$ibm$db2$tools$common$smartx$SmartCheck == null ? (class$com$ibm$db2$tools$common$smartx$SmartCheck = SmartTable.class$("com.ibm.db2.tools.common.smartx.SmartCheck")) : class$com$ibm$db2$tools$common$smartx$SmartCheck)) {
            SmartCheck smartCheck = new SmartCheck();
            smartCheck.setHorizontalAlignment(0);
            tableCellEditor = new SmartTableCellEditor((JTable)this, smartCheck);
        } else if (clazz == (class$javax$swing$JButton == null ? (class$javax$swing$JButton = SmartTable.class$("javax.swing.JButton")) : class$javax$swing$JButton) || clazz == (class$javax$swing$JPanel == null ? (class$javax$swing$JPanel = SmartTable.class$("javax.swing.JPanel")) : class$javax$swing$JPanel) || clazz == (class$com$ibm$db2$tools$common$smartx$SmartEllipsis == null ? (class$com$ibm$db2$tools$common$smartx$SmartEllipsis = SmartTable.class$("com.ibm.db2.tools.common.smartx.SmartEllipsis")) : class$com$ibm$db2$tools$common$smartx$SmartEllipsis)) {
            SmartEllipsis smartEllipsis = new SmartEllipsis();
            tableCellEditor = new SmartTableCellEditor((JTable)this, smartEllipsis);
        } else if (clazz == (class$com$ibm$db2$tools$common$smartx$SmartSpinner == null ? (class$com$ibm$db2$tools$common$smartx$SmartSpinner = SmartTable.class$("com.ibm.db2.tools.common.smartx.SmartSpinner")) : class$com$ibm$db2$tools$common$smartx$SmartSpinner)) {
            SmartSpinner smartSpinner = new SmartSpinner();
            tableCellEditor = new SmartTableCellEditor((JTable)this, smartSpinner);
        } else {
            tableCellEditor = super.getDefaultEditor(clazz);
        }
        return tableCellEditor;
    }

    public void setModel(TableModel tableModel) {
        if (!(tableModel instanceof SmartTableModel)) {
            throw new IllegalArgumentException("SmartTable requires a SmartTableModel");
        }
        super.setModel(tableModel);
        this.editable = false;
        int n2 = this.columnModel.getColumnCount();
        int n3 = 0;
        while (n3 < n2) {
            if (((SmartTableModel)tableModel).isColEditable(n3)) {
                this.editable = true;
                break;
            }
            ++n3;
        }
    }

    public void setColumnsEditable(String string) {
        super.setColumnsEditable(string);
        this.editable = false;
        int n2 = this.columnModel.getColumnCount();
        int n3 = 0;
        while (n3 < n2) {
            if (((SmartTableModel)this.dataModel).isColEditable(n3)) {
                this.editable = true;
                break;
            }
            ++n3;
        }
    }

    protected void setClickCountToEdit(TableColumn tableColumn) {
        TableCellEditor tableCellEditor = tableColumn.getCellEditor();
        if (tableCellEditor instanceof DefaultCellEditor) {
            ((DefaultCellEditor)tableCellEditor).setClickCountToStart(this.clickCountToEdit);
        } else if (tableCellEditor instanceof AssistTableCellEditor) {
            ((AssistTableCellEditor)tableCellEditor).setClickCountToStart(this.clickCountToEdit);
        } else if (tableCellEditor instanceof SmartTableCellEditor) {
            ((SmartTableCellEditor)tableCellEditor).setClickCountToStart(this.clickCountToEdit);
        }
    }

    public CellExpander createCellExpander(MouseEvent mouseEvent) {
        Object object;
        Object object2;
        int n2;
        Point point;
        int n3;
        boolean bl;
        if (this.cellExpander == null) {
            this.cellExpander = new CellExpander(this);
            this.cellExpander.putClientProperty("UAKey", this.getClientProperty("UAKey"));
        }
        boolean bl2 = (bl = this.isCellSelected(n3 = this.rowAtPoint(point = mouseEvent.getPoint()), n2 = this.columnAtPoint(point))) && this.isColumnSelected(n2);
        TableColumn tableColumn = this.getColumn(n2);
        if (tableColumn == null) {
            return null;
        }
        TableCellRenderer tableCellRenderer = tableColumn.getCellRenderer();
        Object object3 = this.dataModel.getValueAt(n3, this.convertColumnIndexToModel(n2));
        if (tableCellRenderer == null) {
            tableCellRenderer = this.getDefaultRenderer((Class)this.getColumnClass(n2));
        }
        Component component = tableCellRenderer.getTableCellRendererComponent(this, object3, bl, bl2, n3, n2);
        this.cellExpander.setForeground(component.getForeground());
        this.cellExpander.setBackground(component.getBackground());
        this.cellExpander.setAlignmentX(((JComponent)component).getAlignmentX());
        this.cellExpander.setAlignmentY(((JComponent)component).getAlignmentY());
        this.cellExpander.setFont(component.getFont());
        Insets insets = ((JComponent)component).getInsets();
        Border border = ((JComponent)component).getBorder();
        this.cellExpander.setBorder(BorderFactory.createCompoundBorder(AssistManager.getBorder("Cell.expansion.border"), border));
        if (component instanceof CellExpanderRenderer) {
            this.cellExpander.setTipText(CellExpanderManager.untag(((CellExpanderRenderer)((Object)component)).getText()));
        } else if (component instanceof JLabel) {
            object2 = ((JLabel)component).getIcon();
            if (object2 != null) {
                switch (((JLabel)component).getVerticalAlignment()) {
                    case 1: {
                        object = "TOP";
                        break;
                    }
                    case 0: {
                        object = "MIDDLE";
                        break;
                    }
                    default: {
                        object = "BOTTOM";
                    }
                }
                StringBuffer stringBuffer = new StringBuffer();
                DiagnosisRenderer.putIcon("CellExpander", (Icon)object2);
                stringBuffer.append("<img align=").append((String)object).append(" src=\"").append("CellExpander").append("\"").append(" hspace=").append(((JLabel)component).getIconTextGap()).append(">").append(CellExpanderManager.untag(((JLabel)component).getText()));
                this.cellExpander.setTipText(stringBuffer.toString());
            } else {
                this.cellExpander.setTipText(CellExpanderManager.untag(((JLabel)component).getText()));
            }
        } else if (component instanceof JTextComponent) {
            this.cellExpander.setTipText(CellExpanderManager.untag(object3.toString()));
        } else {
            this.cellExpander.setTipText(CellExpanderManager.untag(component.toString()));
        }
        object2 = new Dimension(this.cellExpander.getMinimumSize());
        object = this.getIntercellSpacing();
        int n4 = this.getRowHeight() + ((Dimension)object).height;
        LineMetrics lineMetrics = AssistManager.getLineMetrics(this.cellExpander.getTipText(), this.cellExpander, this.cellExpander.getFont());
        int n5 = Math.round(lineMetrics.getHeight());
        Point point2 = new Point();
        point2.x -= insets.left;
        point2.y = (n4 - n5) / 2 - insets.top + n4 % 2;
        point2.x -= ((Dimension)object).width + ((Dimension)object).width;
        point2.y -= ((Dimension)object).height + ((Dimension)object).height;
        this.cellExpander.putClientProperty("translate.point", point2);
        if (((Dimension)object2).height < n4 * 2) {
            ((Dimension)object2).height = n4;
            this.cellExpander.setPreferredSize((Dimension)object2);
        }
        return this.cellExpander;
    }

    protected int getValueWidth(TableCellRenderer tableCellRenderer, Object object, int n2, int n3) {
        Object object2;
        int n4 = 0;
        if (tableCellRenderer == null) {
            tableCellRenderer = this.getDefaultRenderer((Class)this.getColumnClass(n3));
        }
        Component component = this.getRenderingComponent(tableCellRenderer, this.dataModel.getValueAt(n2, this.convertColumnIndexToModel(n3)), n2, n3);
        String string = null;
        if (component instanceof CellExpanderRenderer) {
            string = ((CellExpanderRenderer)((Object)component)).getText();
            if (string.length() == 0) {
                n4 = 0;
            } else {
                n4 = ((CellExpanderRenderer)((Object)component)).getTextOffset();
                n4 += AssistManager.getStringWidth(string, this, this.getFont());
            }
        } else if (component instanceof JLabel) {
            string = ((JLabel)component).getText();
            if (string.length() == 0) {
                n4 = 0;
            } else {
                object2 = ((JLabel)component).getIcon();
                if (object2 != null) {
                    n4 = object2.getIconWidth() + ((JLabel)component).getIconTextGap();
                }
                n4 += AssistManager.getStringWidth(string, this, this.getFont());
            }
        } else {
            if (component instanceof AssistField || component instanceof SmartField) {
                string = this.dataModel.getValueAt(n2, this.convertColumnIndexToModel(n3)).toString();
            } else if (component instanceof JTextComponent) {
                string = ((JTextComponent)component).getText();
            } else if (component instanceof Label) {
                string = ((Label)component).getText();
            } else if (component instanceof TextComponent) {
                string = ((TextComponent)component).getText();
            }
            n4 = string == null || string.length() == 0 ? 0 : AssistManager.getStringWidth(string, this, this.getFont());
        }
        if (n4 != 0) {
            object2 = ((JComponent)component).getInsets();
            n4 += ((Insets)object2).right + ((Insets)object2).left;
        }
        return n4;
    }

    protected String getRenderingText(TableCellRenderer tableCellRenderer, Object object, int n2, int n3) {
        Component component;
        if (tableCellRenderer == null) {
            tableCellRenderer = this.getDefaultRenderer((Class)this.getColumnClass(n3));
        }
        if ((component = this.getRenderingComponent(tableCellRenderer, object, n2, n3)) instanceof CellExpanderRenderer) {
            return ((CellExpanderRenderer)((Object)component)).getText();
        }
        if (component instanceof JLabel) {
            return ((JLabel)component).getText();
        }
        if (component instanceof AssistField || component instanceof SmartField) {
            Object object2 = this.dataModel.getValueAt(n2, this.convertColumnIndexToModel(n3));
            return object2 == null ? "" : object2.toString();
        }
        if (component instanceof JTextComponent) {
            return ((JTextComponent)component).getText();
        }
        if (component instanceof Label) {
            return ((Label)component).getText();
        }
        if (component instanceof TextComponent) {
            return ((TextComponent)component).getText();
        }
        return "?";
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        Object object = mouseEvent.getSource();
        if (object == this && (mouseEvent.getModifiers() & 0xC) > 0) {
            this.showPopup(mouseEvent.getPoint());
        }
        super.mouseReleased(mouseEvent);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (this.diagTimer != null && object == this.diagTimer) {
            this.fireValidityChanged(this.diagnosisEvent);
        } else if (object == this.miEdit) {
            this.mPopup.setVisible(false);
            int n2 = this.getSelectedRow();
            int n3 = this.getSelectedColumn();
            if (n2 != -1 && n3 != -1) {
                this.editCellAt(n2, n3, actionEvent);
            }
        } else if (object == this.miSort) {
            this.sort(this.getSelectedColumn());
        } else if (object == this.miAsc) {
            this.manageSortingColumn(this.getSelectedColumn(), 16);
        } else if (object == this.miDesc) {
            this.manageSortingColumn(this.getSelectedColumn(), 256);
        } else if (object == this.miUnmark) {
            this.manageSortingColumn(this.getSelectedColumn(), 1);
        }
    }

    public void focusLost(FocusEvent focusEvent) {
        if (this.mPopup != null && this.mPopup.isVisible()) {
            return;
        }
        Object object = focusEvent.getSource();
        Component component = this.editorComp;
        if (component != null) {
            if (component instanceof JScrollPane) {
                component = ((JScrollPane)component).getViewport().getView();
            } else if (component instanceof SmartEllipsis) {
                return;
            }
        }
        if (object == component && !focusEvent.isTemporary() && this.isEditing()) {
            if (component instanceof SmartComponent && (((SmartComponent)((Object)component)).allowLink() || ((SmartComponent)((Object)component)).allowPopup())) {
                if (!((SmartComponent)((Object)component)).allowPopup()) {
                    component.validate();
                }
            } else {
                this.stopCellEditing();
            }
        }
        this.mousingAround = false;
    }

    public void processKeyEvent(KeyEvent keyEvent) {
        if (this.mPopup != null && this.mPopup.isVisible()) {
            AssistManager.redirectKeyEvent(keyEvent, this.mPopup);
            return;
        }
        int n2 = keyEvent.getModifiers();
        int n3 = keyEvent.getID();
        int n4 = keyEvent.getKeyCode();
        Object object = keyEvent.getSource();
        if (n3 == 401 || n3 == 400) {
            if (n4 == 9 || keyEvent.getKeyChar() == '\t') {
                if ((n2 & 2) == 0 && this.editorComp != null && this.editorComp instanceof AssistEllipsis) {
                    if ((n2 & 1) > 0) {
                        if (((AssistEllipsis)this.editorComp).getButton().hasFocus()) {
                            ((AssistEllipsis)this.editorComp).getTextField().requestFocus();
                            keyEvent.consume();
                        }
                    } else if (((AssistEllipsis)this.editorComp).getTextField().hasFocus()) {
                        ((AssistEllipsis)this.editorComp).getButton().requestFocus();
                        keyEvent.consume();
                    }
                }
                if (!keyEvent.isConsumed()) {
                    Point point = null;
                    if (!(object instanceof JTextArea)) {
                        this.stopCellEditing();
                    }
                    if ((n2 & 2) == 0 && !(object instanceof JTextArea) || (n2 & 2) > 0) {
                        int n5 = this.getSelectedRow();
                        int n6 = this.getSelectedColumn();
                        if ((n2 & 1) > 0) {
                            if (n6 > 0) {
                                point = this.findEditableCell(n5, --n6, false);
                            } else if (n5 > 0) {
                                n6 = this.columnModel.getColumnCount() - 1;
                                point = this.findEditableCell(--n5, n6, false);
                            }
                        } else if (n6 < this.columnModel.getColumnCount() - 1) {
                            point = this.findEditableCell(n5, ++n6, true);
                        } else if (n5 < this.getRowCount() - 1) {
                            n6 = 0;
                            point = this.findEditableCell(++n5, n6, true);
                        }
                        if (point != null) {
                            this.selectAndScrollToRow(point.y);
                            if (this.getColumnSelectionAllowed()) {
                                this.setColumnSelectionInterval(point.x, point.x);
                            }
                            this.editCellAt(point.y, point.x, keyEvent);
                            keyEvent.consume();
                        }
                    }
                }
            }
        } else if (n3 == 402) {
            if (n2 == 1 && n4 == 121) {
                if (this.mPopup != null) {
                    Rectangle rectangle = this.getCellRect(this.getSelectedRow(), this.getSelectedColumn(), false);
                    Point point = new Point(rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 2);
                    this.showPopup(point);
                    keyEvent.consume();
                }
            } else if (n4 == 113) {
                int n7 = this.getSelectedRow();
                int n8 = this.getSelectedColumn();
                if (n7 != -1 && n8 != -1 && this.editCellAt(n7, n8, keyEvent)) {
                    keyEvent.consume();
                }
            } else if (n4 == 32) {
                Class<?> clazz;
                int n9 = this.getSelectedRow();
                int n10 = this.getSelectedColumn();
                if (n9 > -1 && n10 > -1 && this.dataModel.isCellEditable(n9, this.convertColumnIndexToModel(n10)) && ((clazz = this.getColumnClass(n10)) == SmartManager.getClass("Boolean") || clazz == (class$javax$swing$JCheckBox == null ? (class$javax$swing$JCheckBox = SmartTable.class$("javax.swing.JCheckBox")) : class$javax$swing$JCheckBox) || clazz == (class$com$ibm$db2$tools$common$smartx$SmartCheck == null ? (class$com$ibm$db2$tools$common$smartx$SmartCheck = SmartTable.class$("com.ibm.db2.tools.common.smartx.SmartCheck")) : class$com$ibm$db2$tools$common$smartx$SmartCheck)) && this.editCellAt(n9, n10, keyEvent)) {
                    ((SmartCheck)this.editorComp).doClick();
                    keyEvent.consume();
                }
            }
        }
        if (!keyEvent.isConsumed()) {
            super.processKeyEvent(keyEvent);
        }
    }

    protected Point findEditableCell(int n2, int n3, boolean bl) {
        if (this.mPopup == null || !this.mPopup.isVisible()) {
            return super.findEditableCell(n2, n3, bl);
        }
        return null;
    }

    public boolean stopCellEditing() {
        boolean bl = false;
        if (this.cellEditor != null) {
            Component component = this.editorComp;
            if (component != null) {
                if (component instanceof JScrollPane) {
                    component = ((JScrollPane)component).getViewport().getView();
                } else if (component instanceof SmartEllipsis) {
                    component = ((SmartEllipsis)component).getTextField();
                } else if (component instanceof SmartSpinner) {
                    component = ((SmartSpinner)component).getTextField();
                }
                if (component instanceof JTextComponent || component instanceof JComboBox) {
                    component.removeKeyListener(this);
                }
                component.removeFocusListener(this);
                if (component instanceof SmartComponent) {
                    ((SmartComponent)((Object)component)).removeDiagnosisListener(this);
                }
            }
            this.stoppingEditing = true;
            bl = this.cellEditor.stopCellEditing();
            this.stoppingEditing = false;
            if (component != null) {
                if (component instanceof SmartComponent) {
                    ((SmartComponent)((Object)component)).verify(false);
                } else if (component instanceof AssistComponent) {
                    ((AssistComponent)((Object)component)).verify();
                }
            }
        }
        return bl;
    }

    public void cancelCellEditing() {
        if (this.cellEditor != null) {
            Component component = this.editorComp;
            if (component != null) {
                if (component instanceof JScrollPane) {
                    component = ((JScrollPane)component).getViewport().getView();
                } else if (component instanceof SmartEllipsis) {
                    component = ((SmartEllipsis)component).getTextField();
                } else if (component instanceof SmartSpinner) {
                    component = ((SmartSpinner)component).getTextField();
                }
                if (component instanceof JTextComponent || component instanceof JComboBox) {
                    component.removeKeyListener(this);
                }
                component.removeFocusListener(this);
                if (component instanceof SmartComponent) {
                    int n2 = this.getEditingRow();
                    int n3 = this.getEditingColumn();
                    this.cellEditor.getTableCellEditorComponent(this, this.dataModel.getValueAt(n2, this.convertColumnIndexToModel(n3)), true, n2, n3);
                    ((SmartComponent)((Object)component)).removeDiagnosisListener(this);
                }
            }
            this.stoppingEditing = true;
            this.cellEditor.cancelCellEditing();
            this.stoppingEditing = false;
        }
    }

    public JComponent getEditingComponent(Class clazz) {
        TableCellEditor tableCellEditor = this.getDefaultEditor(clazz);
        if (tableCellEditor != null && tableCellEditor instanceof SmartTableCellEditor) {
            return ((SmartTableCellEditor)tableCellEditor).getEditingComponent();
        }
        return null;
    }

    public JComponent getEditingComponent(int n2) {
        TableColumn tableColumn = this.getColumn(n2);
        TableCellEditor tableCellEditor = tableColumn.getCellEditor();
        if (tableCellEditor == null) {
            tableCellEditor = this.getDefaultEditor((Class)this.getColumnClass(n2));
            tableColumn.setCellEditor(tableCellEditor);
        }
        if (tableCellEditor instanceof SmartTableCellEditor) {
            return ((SmartTableCellEditor)tableCellEditor).getEditingComponent();
        }
        return null;
    }

    public JComponent getEditingComponent(int n2, int n3) {
        TableColumn tableColumn = this.getColumn(n3);
        TableCellEditor tableCellEditor = tableColumn.getCellEditor();
        if (tableCellEditor == null) {
            tableCellEditor = this.getDefaultEditor((Class)this.getColumnClass(n3));
            tableColumn.setCellEditor(tableCellEditor);
        }
        if (tableCellEditor instanceof SmartTableCellEditor) {
            return ((SmartTableCellEditor)tableCellEditor).getEditingComponent(n2, n3);
        }
        return null;
    }

    public void configureCellEditor(SmartConstraints smartConstraints, SmartVerifier smartVerifier, Class clazz) {
        TableCellEditor tableCellEditor = this.getDefaultEditor(clazz);
        if (tableCellEditor != null && tableCellEditor instanceof SmartTableCellEditor) {
            ((SmartTableCellEditor)tableCellEditor).configureCellEditor(smartConstraints, smartVerifier);
        }
    }

    public void configureCellEditor(SmartConstraints smartConstraints, SmartVerifier smartVerifier, int n2) {
        TableColumn tableColumn = this.getColumn(n2);
        TableCellEditor tableCellEditor = tableColumn.getCellEditor();
        if (tableCellEditor == null) {
            tableCellEditor = this.getDefaultEditor(this.getColumnClass(n2), n2);
            tableColumn.setCellEditor(tableCellEditor);
        }
        if (tableCellEditor instanceof SmartTableCellEditor) {
            ((SmartTableCellEditor)tableCellEditor).configureCellEditor(smartConstraints, smartVerifier);
        }
    }

    public void configureCellEditor(SmartConstraints smartConstraints, SmartVerifier smartVerifier, int n2, int n3) {
        TableColumn tableColumn = this.getColumn(n3);
        TableCellEditor tableCellEditor = tableColumn.getCellEditor();
        if (tableCellEditor == null) {
            tableCellEditor = this.getDefaultEditor(this.getColumnClass(n3), n3);
            tableColumn.setCellEditor(tableCellEditor);
        }
        if (tableCellEditor instanceof SmartTableCellEditor) {
            ((SmartTableCellEditor)tableCellEditor).configureCellEditor(smartConstraints, smartVerifier, n2, n3);
        }
    }

    public void clearEditorRendererComponents(int n2) {
        TableCellRenderer tableCellRenderer;
        TableColumn tableColumn = this.getColumn(n2);
        TableCellEditor tableCellEditor = tableColumn.getCellEditor();
        if (tableCellEditor == null) {
            tableCellEditor = this.getDefaultEditor(this.getColumnClass(n2), n2);
            tableColumn.setCellEditor(tableCellEditor);
        }
        if (tableCellEditor instanceof SmartTableCellEditor) {
            ((SmartTableCellEditor)tableCellEditor).clearEditorComponents();
        }
        if ((tableCellRenderer = tableColumn.getCellRenderer()) == null) {
            tableCellRenderer = this.getDefaultRenderer((Class)this.getColumnClass(n2));
            tableColumn.setCellRenderer(tableCellRenderer);
        }
        if (tableCellRenderer instanceof SmartTableCellRenderer) {
            ((SmartTableCellRenderer)tableCellRenderer).clearRendererComponents();
        }
    }

    public boolean editCellAt(int n2, int n3, EventObject eventObject) {
        if (this.mPopup != null && this.mPopup.isVisible()) {
            return false;
        }
        boolean bl = super.editCellAt(n2, n3, eventObject);
        if (bl) {
            Component component;
            if (this.editorComp instanceof SmartComponent) {
                ((SmartComponent)((Object)this.editorComp)).addDiagnosisListener(this, "");
            } else if (this.editorComp instanceof JScrollPane && (component = ((JScrollPane)this.editorComp).getViewport().getView()) instanceof SmartComponent) {
                ((SmartComponent)((Object)component)).addDiagnosisListener(this, "");
            }
        }
        if (this.editorComp instanceof SmartSpinner) {
            ((JComponent)this.editorComp).updateUI();
        }
        return bl;
    }

    public Vector getExistingNames(Object object) {
        Vector<String> vector = new Vector<String>();
        int n2 = this.getEditingColumn();
        int n3 = this.getEditingRow();
        int n4 = 0;
        while (n4 < this.getRowCount()) {
            if (n4 != n3) {
                vector.addElement(this.dataModel.getValueAt(n4, this.convertColumnIndexToModel(n2)).toString());
            }
            ++n4;
        }
        return vector;
    }

    public void showPopup(Point point) {
        this.cancelCellEditing();
        int n2 = this.getSelectedColumn();
        if (n2 < 0) {
            return;
        }
        int n3 = this.getSelectedRow();
        if (n3 < 0) {
            return;
        }
        if (this.editable && !this.mPopup.isAncestorOf(this.miEdit)) {
            this.mPopup.add(this.miEdit);
        } else if (!this.editable && this.mPopup.isAncestorOf(this.miEdit)) {
            this.mPopup.remove(this.miEdit);
        }
        if (this.mPopup.isAncestorOf(this.miEdit)) {
            this.miEdit.setEnabled(this.dataModel.isCellEditable(n3, this.convertColumnIndexToModel(n2)));
        }
        if (this.getSorted()) {
            if (!this.mPopup.isAncestorOf(this.miSort)) {
                if (this.mPopup.isAncestorOf(this.miEdit)) {
                    this.mPopup.addSeparator();
                }
                this.mPopup.add(this.miSort);
                this.mPopup.add(this.miMarkSort);
            }
            this.configureTableEditorActions();
        }
        if (this.mPopup.getComponentCount() > 0) {
            this.mPopup.show(this, point.x, point.y);
            this.mousingAround = true;
        }
    }

    public MenuElement[] getTableEditorActions() {
        if (this.getSorted()) {
            return this.editMenuElements;
        }
        return null;
    }

    public void configureTableEditorActions() {
        if (this.getSorted()) {
            int n2 = this.getSelectedColumn();
            if (n2 < 0) {
                return;
            }
            int n3 = this.getSortableIndicators(n2);
            int n4 = this.getSort(n2);
            int n5 = this.getSortOrdinal(n2);
            this.miSort.setEnabled(n3 != 0);
            this.miAsc.setEnabled((n3 & 0x10) > 0 && (n4 != 16 || n5 != 1));
            this.miDesc.setEnabled((n3 & 0x100) > 0 && (n4 != 256 || n5 != 1));
            this.miUnmark.setEnabled((n3 & 1) > 0 && n5 > 0);
            this.miMarkSort.setEnabled(n3 != 0 && (this.miAsc.isEnabled() || this.miDesc.isEnabled() || this.miUnmark.isEnabled()));
        }
    }

    public void enableValid() {
        Border border = null;
        border = this.hasFocus() && SmartManager.getSmartBordersPolicy() ? SmartManager.getBorder("TextField.border", true, true, this.prevBorderType) : AssistManager.getBorder("TextField.border");
        this.setBorder(AssistManager.padBorder(this, border, this.prevBorderType));
        this.modelValid = true;
        this.dataValid = true;
    }

    public void constraintChanged(Object object, Object object2, Object object3) {
    }

    public void constraintFlagChanged(int n2, boolean bl) {
    }

    public SmartConstraints getConstraints() {
        return null;
    }

    public void setConstraints(SmartConstraints smartConstraints) {
    }

    public Enumeration getSmartVerifiers() {
        return null;
    }

    public void setSmartVerifier(SmartVerifier smartVerifier) {
    }

    public void addSmartVerifier(SmartVerifier smartVerifier) {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

