/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common.smartx;

import com.ibm.db2.tools.common.AssistSpinner;
import com.ibm.db2.tools.common.smartx.SmartField;
import com.ibm.db2.tools.common.smartx.event.Diagnosis;
import com.ibm.db2.tools.common.smartx.event.DiagnosisListener;
import com.ibm.db2.tools.common.smartx.support.SmartComponent;
import com.ibm.db2.tools.common.smartx.support.SmartConstraints;
import com.ibm.db2.tools.common.smartx.support.SmartVerifier;
import com.ibm.db2.tools.common.smartx.support.VerifierUtil;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.util.Enumeration;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;

public class SmartSpinner
extends AssistSpinner
implements SmartComponent {
    protected static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public SmartSpinner() {
        super(true, Long.MIN_VALUE, Long.MAX_VALUE, new SmartField(), true);
        this.configureSpinField(null, null);
    }

    public SmartSpinner(int n2, int n3) {
        super(true, (long)n2, (long)n3, new SmartField(), true);
        this.configureSpinField(null, null);
    }

    public SmartSpinner(SmartField smartField, boolean bl) {
        super(true, Long.MIN_VALUE, Long.MAX_VALUE, smartField, bl);
        this.configureSpinField(null, null);
    }

    public SmartSpinner(long l2, long l3, SmartField smartField, boolean bl) {
        super(true, l2, l3, smartField, true);
        this.configureSpinField(null, null);
    }

    public SmartSpinner(SmartConstraints smartConstraints, SmartVerifier smartVerifier) {
        super(true, Long.MIN_VALUE, Long.MAX_VALUE, new SmartField(), true);
        Integer n2 = (Integer)smartConstraints.getConstraint("MinimumSize");
        Integer n3 = (Integer)smartConstraints.getConstraint("MaximumSize");
        if (n2 != null && n3 != null) {
            this.setRange(n2.intValue(), n3.intValue());
        }
        this.configureSpinField(smartConstraints, smartVerifier);
    }

    public SmartSpinner(SmartConstraints smartConstraints, SmartVerifier smartVerifier, int n2, int n3) {
        super(true, (long)n2, (long)n3, new SmartField(), true);
        smartConstraints.setConstraint("MinimumSize", new Integer(n2));
        smartConstraints.setConstraint("MaximumSize", new Integer(n3));
        this.configureSpinField(smartConstraints, smartVerifier);
    }

    public SmartSpinner(SmartConstraints smartConstraints, SmartVerifier smartVerifier, SmartField smartField, boolean bl) {
        super(true, Long.MIN_VALUE, Long.MAX_VALUE, smartField, bl);
        Long l2 = (Long)smartConstraints.getConstraint("MinimumSize");
        Long l3 = (Long)smartConstraints.getConstraint("MaximumSize");
        if (l2 != null && l3 != null) {
            this.setRange(l2.intValue(), l3.intValue());
        }
        this.configureSpinField(smartConstraints, smartVerifier);
    }

    public SmartSpinner(SmartConstraints smartConstraints, SmartVerifier smartVerifier, long l2, long l3, SmartField smartField, boolean bl) {
        super(true, l2, l3, smartField, bl);
        smartConstraints.setConstraint("MinimumSize", new Long(l2));
        smartConstraints.setConstraint("MaximumSize", new Long(l3));
        this.configureSpinField(smartConstraints, smartVerifier);
    }

    protected void configureSpinField(SmartConstraints smartConstraints, SmartVerifier smartVerifier) {
        if (smartConstraints == null) {
            smartConstraints = new SmartConstraints(this.getRequired(), 12288);
            smartConstraints.setConstraint("MinimumSize", new Long(this.upperBound));
            smartConstraints.setConstraint("MaximumSize", new Long(this.lowerBound));
        }
        ((SmartField)this.spinField).setConstraints(smartConstraints);
        if (smartVerifier != null) {
            ((SmartField)this.spinField).addSmartVerifier(smartVerifier);
        } else {
            ((SmartField)this.spinField).addSmartVerifier(VerifierUtil.getSharedVerifier(12288));
        }
        Object object = smartConstraints.getDefaultValue();
        if (object != null) {
            try {
                long l2 = object instanceof Number ? ((Number)object).longValue() : Long.parseLong(object.toString());
                super.setDefaultValue(l2);
            }
            catch (NumberFormatException numberFormatException) {
                long l3 = 0L;
            }
        }
        ((SmartField)this.spinField).setNestedBorders(true);
        ((SmartField)this.spinField).setContainingComponent(this);
    }

    public void setConstraints(SmartConstraints smartConstraints) {
        if (this.spinField == null) {
            this.configureSpinField(smartConstraints, null);
        } else {
            ((SmartField)this.spinField).setConstraints(smartConstraints);
        }
    }

    public SmartConstraints getConstraints() {
        if (this.spinField == null) {
            return null;
        }
        return ((SmartField)this.spinField).getConstraints();
    }

    public void setSmartVerifier(SmartVerifier smartVerifier) {
        if (this.spinField == null) {
            this.configureSpinField(null, smartVerifier);
        } else {
            ((SmartField)this.spinField).setSmartVerifier(smartVerifier);
        }
    }

    public void addSmartVerifier(SmartVerifier smartVerifier) {
        if (this.spinField == null) {
            this.configureSpinField(null, smartVerifier);
        } else {
            ((SmartField)this.spinField).addSmartVerifier(smartVerifier);
        }
    }

    public AssistSpinner getRenderer(boolean bl, String string) {
        SmartSpinner smartSpinner = new SmartSpinner(new SmartConstraints(this.required, 12288), null, this.lowerBound, this.upperBound, (SmartField)((SmartField)this.getTextField()).clone(string), bl);
        smartSpinner.setText(string);
        smartSpinner.setBorder(this.getBorder());
        smartSpinner.setClearDisabled(this.clearDisabled);
        smartSpinner.setNestedBorders(true);
        ((SmartField)smartSpinner.getTextField()).setTipPosition(-1);
        return smartSpinner;
    }

    public Diagnosis getDiagnosis() {
        return ((SmartField)this.spinField).getDiagnosis();
    }

    public void addDiagnosisListener(DiagnosisListener diagnosisListener, Object object) {
        ((SmartField)this.spinField).addDiagnosisListener(diagnosisListener, object);
    }

    public void removeDiagnosisListener(DiagnosisListener diagnosisListener) {
        ((SmartField)this.spinField).removeDiagnosisListener(diagnosisListener);
    }

    public Object getDiagnosisContext(DiagnosisListener diagnosisListener) {
        return ((SmartField)this.spinField).getDiagnosisContext(diagnosisListener);
    }

    public void setTipPosition(int n2) {
        ((SmartField)this.spinField).setTipPosition(n2);
    }

    public int getTipPosition() {
        return ((SmartField)this.spinField).getTipPosition();
    }

    public void setShowInitialDiagnosis(boolean bl) {
        ((SmartField)this.spinField).setShowInitialDiagnosis(bl);
    }

    public boolean getShowInitialDiagnosis() {
        return ((SmartField)this.spinField).getShowInitialDiagnosis();
    }

    public boolean allowLink() {
        return ((SmartField)this.spinField).allowLink();
    }

    public boolean allowPopup() {
        return ((SmartField)this.spinField).allowPopup();
    }

    public void setAllowPopup(boolean bl) {
        ((SmartField)this.spinField).setAllowPopup(bl);
    }

    public void setAllowLink(boolean bl) {
        ((SmartField)this.spinField).setAllowLink(bl);
    }

    public void showPopup(Component component, Point point) {
        ((SmartField)this.spinField).showPopup(component, point);
    }

    public void hidePopup() {
        ((SmartField)this.spinField).hidePopup();
    }

    public void fireValidityChanged() {
        if (this.spinField != null) {
            ((SmartField)this.spinField).fireValidityChanged();
        }
    }

    public void fireValidityChanged(Diagnosis diagnosis) {
        ((SmartField)this.spinField).fireValidityChanged(diagnosis);
    }

    public void constraintChanged(Object object, Object object2, Object object3) {
        if (this.spinField != null) {
            ((SmartField)this.spinField).constraintChanged(object, object2, object3);
        }
    }

    public void constraintFlagChanged(int n2, boolean bl) {
        if (this.spinField != null) {
            ((SmartField)this.spinField).constraintFlagChanged(n2, bl);
        }
    }

    public Enumeration getSmartVerifiers() {
        if (this.spinField == null) {
            return null;
        }
        return ((SmartField)this.spinField).getSmartVerifiers();
    }

    public void enableValid() {
        if (this.spinField != null) {
            ((SmartField)this.spinField).enableValid();
        }
    }

    protected String filterText(String string) {
        return string;
    }

    protected void filterKey(KeyEvent keyEvent) {
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleSmartSpinner();
        }
        return this.accessibleContext;
    }

    protected class AccessibleSmartSpinner
    extends AssistSpinner.AccessibleAssistSpinner {
        private static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

        public int getAccessibleChildrenCount() {
            return super.getAccessibleChildrenCount() + 1;
        }

        public Accessible getAccessibleChild(int n2) {
            Accessible accessible = super.getAccessibleChild(n2);
            if (accessible == null && n2 < this.getAccessibleChildrenCount()) {
                return ((SmartField)SmartSpinner.this.spinField).getPopup();
            }
            return null;
        }
    }
}

