/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common.smartx;

import com.ibm.db2.tools.common.AssistField;
import com.ibm.db2.tools.common.event.AssistListener;
import com.ibm.db2.tools.common.smartx.SmartCombo;
import com.ibm.db2.tools.common.smartx.SmartTable;
import com.ibm.db2.tools.common.smartx.event.Diagnosis;
import com.ibm.db2.tools.common.smartx.event.DiagnosisEvent;
import com.ibm.db2.tools.common.smartx.event.DiagnosisListener;
import com.ibm.db2.tools.common.smartx.event.UniquenessListener;
import com.ibm.db2.tools.common.smartx.support.EditPopup;
import com.ibm.db2.tools.common.smartx.support.SmartComponent;
import com.ibm.db2.tools.common.smartx.support.SmartConstraints;
import com.ibm.db2.tools.common.smartx.support.SmartEditPopup;
import com.ibm.db2.tools.common.smartx.support.SmartManager;
import com.ibm.db2.tools.common.smartx.support.SmartResources;
import com.ibm.db2.tools.common.smartx.support.SmartTipManager;
import com.ibm.db2.tools.common.smartx.support.SmartUndoManager;
import com.ibm.db2.tools.common.smartx.support.SmartUtil;
import com.ibm.db2.tools.common.smartx.support.SmartVerifier;
import com.ibm.db2.tools.common.smartx.support.VerifierUtil;
import com.ibm.db2.tools.common.support.AssistComponent;
import com.ibm.db2.tools.common.support.AssistEditorKit;
import com.ibm.db2.tools.common.support.AssistManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.MenuElement;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.plaf.TextUI;
import javax.swing.text.Document;

public class SmartField
extends AssistField
implements SmartComponent,
ItemListener,
UndoableEditListener,
ActionListener,
CaretListener,
Serializable {
    private static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected SmartConstraints constraints;
    protected Vector verifierInstances;
    protected SmartUndoManager undoMgr;
    protected SmartCombo magCombo;
    protected boolean fixing;
    protected boolean verifying;
    protected boolean checking;
    protected boolean changing;
    protected int prevCaretDot;
    protected int prevCaretMark;
    protected boolean button3Up = true;
    protected String foreDoc = "";
    protected String prevDoc = "";
    protected Hashtable textTable;
    protected boolean uniquenessError;
    protected boolean mereDiagnosis;
    protected Diagnosis previousDiagnosis;
    protected DiagnosisEvent diagnosisEvent;
    protected Hashtable diagnosisContexts;
    protected Hashtable uniquenessContexts;
    protected Timer diagTimer;
    protected int tipPosition;
    protected int diagnose;
    protected AssistComponent containingComponent;
    protected JPopupMenu mPopup;
    protected boolean allowLink;
    protected boolean allowPopup;
    protected boolean smartBordersPolicy;
    static /* synthetic */ Class class$javax$swing$JTable;
    static /* synthetic */ Class class$com$ibm$db2$tools$common$event$AssistListener;
    static /* synthetic */ Class class$com$ibm$db2$tools$common$smartx$event$DiagnosisListener;
    static /* synthetic */ Class class$com$ibm$db2$tools$common$smartx$SmartTable;

    public SmartField() {
        this(null, null, null, null, 0);
    }

    public SmartField(String string) {
        this(null, null, null, string, 0);
    }

    public SmartField(Document document, String string, int n2) {
        this(null, null, document, string, n2);
    }

    public SmartField(SmartConstraints smartConstraints, SmartVerifier smartVerifier) {
        this(smartConstraints, smartVerifier, null, null, 0);
    }

    public SmartField(SmartConstraints smartConstraints, SmartVerifier smartVerifier, String string) {
        this(smartConstraints, smartVerifier, null, string, 0);
    }

    public SmartField(SmartConstraints smartConstraints, SmartVerifier smartVerifier, int n2) {
        this(smartConstraints, smartVerifier, null, null, n2);
    }

    public SmartField(SmartConstraints smartConstraints, SmartVerifier smartVerifier, String string, int n2) {
        this(smartConstraints, smartVerifier, null, string, n2);
    }

    public SmartField(SmartConstraints smartConstraints, SmartVerifier smartVerifier, Document document, String string, int n2) {
        this.selectWhenFocusGained = false;
        this.undoMgr = new SmartUndoManager();
        this.undoMgr.discardAllEdits();
        if (smartConstraints == null) {
            smartConstraints = new SmartConstraints(true, 0);
        }
        if (smartVerifier != null) {
            this.setSmartVerifier(smartVerifier);
        }
        this.setConstraints(smartConstraints);
        this.mPopup = smartConstraints.getType() == 0 ? new SmartEditPopup(this, true, false) : new SmartEditPopup(this);
        this.smartBordersPolicy = SmartManager.getSmartBordersPolicy();
        this.setColumns(n2);
        this.textTable = new Hashtable(27);
        this.diagnosisContexts = new Hashtable(2);
        this.uniquenessContexts = new Hashtable(2);
        if (document == null) {
            document = this.createDefaultModel();
        }
        this.setDocument(document);
        this.checking = false;
        this.changing = false;
        if (string == null) {
            this.setToDefault();
        } else {
            this.setText(string);
        }
        this.foreDoc = this.getText();
        this.tipPosition = SmartManager.getTipPositionPolicy();
        this.diagnose = -1;
        AssistEditorKit.enhanceKeymap(this.getKeymap());
        this.addCaretListener(this);
        this.enableEvents(16L);
    }

    public SmartConstraints getConstraints() {
        return this.constraints;
    }

    public void setConstraints(SmartConstraints smartConstraints) {
        boolean bl;
        Diagnosis diagnosis;
        if (smartConstraints == null) {
            smartConstraints = new SmartConstraints(true, 0);
        }
        this.constraints = smartConstraints;
        smartConstraints.setSmartComponent(this);
        String string = (String)smartConstraints.getConstraint("TipDescription");
        if (string == null) {
            string = SmartResources.get(217);
            smartConstraints.setConstraint("TipDescription", string);
        }
        if ((diagnosis = SmartUtil.getDiagnosis(this)) != null) {
            diagnosis.setDescription(string);
        }
        if ((bl = smartConstraints.getConstraintFlag(0).booleanValue()) != this.required && bl && this.isEditable() && this.getText().length() == 0) {
            if (smartConstraints.getDefaultValue() != null) {
                this.setText(smartConstraints.getDefaultString());
            }
            super.setRequired(bl);
        }
        if (smartConstraints.getType() > 0 && (this.verifierInstances == null || this.verifierInstances.size() == 0)) {
            this.setSmartVerifier(VerifierUtil.getSharedVerifier(smartConstraints.getType()));
        }
    }

    public void setSmartVerifier(SmartVerifier smartVerifier) {
        if (smartVerifier == null) {
            return;
        }
        if (this.verifierInstances == null) {
            this.verifierInstances = new Vector(1, 1);
        } else if (this.verifierInstances.size() > 0) {
            this.verifierInstances.clear();
        }
        this.verifierInstances.addElement(smartVerifier);
    }

    public void addSmartVerifier(SmartVerifier smartVerifier) {
        if (smartVerifier == null) {
            return;
        }
        if (this.verifierInstances == null) {
            this.verifierInstances = new Vector(1, 1);
            this.verifierInstances.addElement(smartVerifier);
        } else if (!this.verifierInstances.contains(smartVerifier)) {
            this.verifierInstances.addElement(smartVerifier);
        }
    }

    public Enumeration getSmartVerifiers() {
        if (this.verifierInstances != null) {
            return this.verifierInstances.elements();
        }
        return null;
    }

    public void setRequired(boolean bl) {
        if (this.constraints != null) {
            this.constraints.setConstraintFlag(0, bl);
            Boolean bl2 = this.constraints.getConstraintFlag(4);
            this.constraints.setConstraintFlag(4, Boolean.FALSE);
            this.verifyImmediately(false);
            this.constraints.setConstraintFlag(4, bl2);
        }
    }

    public boolean getRequired() {
        if (this.constraints == null) {
            return super.getRequired();
        }
        Boolean bl = this.constraints.getConstraintFlag(0);
        if (bl == null) {
            bl = Boolean.FALSE;
        }
        return bl;
    }

    public void setBeepPolicy(boolean bl) {
        if (this.constraints != null) {
            this.constraints.setConstraintFlag(4, bl);
        }
    }

    public Boolean getBeepPolicy() {
        if (this.constraints != null) {
            return this.constraints.getConstraintFlag(4);
        }
        return new Boolean(AssistManager.getBeepPolicy());
    }

    public void resetBeepPolicy() {
        if (this.constraints != null) {
            this.constraints.setConstraintFlag(4, AssistManager.getBeepPolicy());
        }
    }

    public void setDocument(Document document) {
        if (this.getDocument() != null) {
            this.getDocument().removeUndoableEditListener(this);
        }
        super.setDocument(document);
        if (document != null) {
            document.addUndoableEditListener(this);
        }
    }

    public void setText(String string) {
        if (SmartManager.getFixPolicy() && this.getText().equals(string)) {
            return;
        }
        if (this.constraints == null) {
            super.setText(string);
        } else {
            Integer n2 = (Integer)this.constraints.getConstraint("Type");
            if (string != null && string.length() > 0 && n2 != null && n2 != 0 && this.constraints.getDefaultValue(n2) == null) {
                this.constraints.setDefaultValue(n2, string);
            }
            Boolean bl = this.constraints.getConstraintFlag(4);
            this.constraints.setConstraintFlag(4, Boolean.FALSE);
            super.setText(string);
            if (!SmartManager.getFixPolicy() && !this.fixing) {
                this.verifyImmediately(false);
            }
            this.constraints.setConstraintFlag(4, bl);
        }
    }

    public void setToDefault() {
        if (this.textTable == null) {
            return;
        }
        Integer n2 = (Integer)this.constraints.getConstraint("Type");
        String string = this.constraints.getDefaultString(n2);
        if (string != null) {
            this.textTable.put(n2, string);
            if (this.isEnabled() || !this.clearDisabled) {
                super.setText(string);
                Boolean bl = this.constraints.getConstraintFlag(4);
                this.constraints.setConstraintFlag(4, Boolean.FALSE);
                if (!SmartManager.getFixPolicy()) {
                    this.verifyImmediately(false);
                }
                this.constraints.setConstraintFlag(4, bl);
                if (this.getText().trim().length() > 0) {
                    this.verifyUniqueness();
                }
            }
        }
    }

    public void setContainingComponent(AssistComponent assistComponent) {
        this.containingComponent = assistComponent;
    }

    public AssistComponent getContainingComponent() {
        return this.containingComponent;
    }

    public AssistField getRenderer(boolean bl, String string) {
        Object object;
        String string2 = this.constraints.getDefaultString();
        if (string2 == null) {
            string2 = string;
        }
        SmartField smartField = new SmartField();
        smartField.setPaintClipped(bl);
        smartField.setConstraints((SmartConstraints)this.constraints.clone());
        if (this.verifierInstances != null) {
            object = this.verifierInstances.elements();
            while (object.hasMoreElements()) {
                smartField.addSmartVerifier((SmartVerifier)object.nextElement());
            }
        }
        smartField.setClearDisabled(this.getClearDisabled());
        smartField.setBorder(this.getBorder());
        smartField.setNestedBorders(this.nested);
        smartField.setContainingComponent(this.containingComponent);
        smartField.setSmartBordersPolicy(this.smartBordersPolicy);
        smartField.setText(string);
        if (!SmartManager.getFixPolicy()) {
            object = this.constraints.getConstraintFlag(4);
            smartField.getConstraints().setConstraintFlag(4, Boolean.FALSE);
            smartField.verifyImmediately(false);
            smartField.getConstraints().setConstraintFlag(4, (Boolean)object);
        }
        return smartField;
    }

    public void setTipPosition(int n2) {
        if (this.diagnose != -1) {
            this.diagnose = n2;
        } else {
            this.tipPosition = n2;
        }
    }

    public int getTipPosition() {
        return this.tipPosition;
    }

    public void setShowInitialDiagnosis(boolean bl) {
        if (bl && this.diagnose != -1) {
            this.tipPosition = this.diagnose;
            this.diagnose = -1;
        } else if (!bl) {
            this.diagnose = this.tipPosition;
            this.tipPosition = -1;
        }
    }

    public boolean getShowInitialDiagnosis() {
        return this.diagnose == -1 && this.tipPosition != -1;
    }

    public SmartCombo getMagnitudeCombo() {
        if (this.magCombo == null) {
            this.magCombo = new SmartCombo();
            this.magCombo.addItem(SmartUtil.getString(185));
            this.magCombo.addItem(SmartUtil.getString(186));
            this.magCombo.addItem(SmartUtil.getString(187));
            this.magCombo.addItem(SmartUtil.getString(188));
            Integer n2 = (Integer)this.constraints.getConstraint("Unit");
            int n3 = 0;
            if (n2 != null) {
                n3 = n2;
            } else {
                this.constraints.setConstraint("Unit", new Integer(n3));
            }
            this.magCombo.setSelectedIndex(n3);
            this.magCombo.addItemListener(this);
        }
        return this.magCombo;
    }

    public void setMagnitudeCombo(SmartCombo smartCombo) {
        if (smartCombo != null) {
            this.constraints.setConstraint("Unit", new Integer(smartCombo.getSelectedIndex()));
            this.magCombo = smartCombo;
            this.magCombo.addItemListener(this);
            if (this.magCombo.getItemCount() != 4) {
                this.magCombo.removeAllItems();
                this.magCombo.addItem(SmartUtil.getString(185));
                this.magCombo.addItem(SmartUtil.getString(186));
                this.magCombo.addItem(SmartUtil.getString(187));
                this.magCombo.addItem(SmartUtil.getString(188));
                Integer n2 = (Integer)this.constraints.getConstraint("Unit");
                int n3 = 0;
                if (n2 != null) {
                    n3 = n2;
                } else {
                    this.constraints.setConstraint("Unit", new Integer(n3));
                }
                this.magCombo.setSelectedIndex(n3);
            }
        } else {
            this.magCombo = null;
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object == this.magCombo) {
            int n2 = (Integer)this.constraints.getConstraint("Unit");
            if (n2 == -1 || this.magCombo.getSelectedIndex() == 0 && this.magCombo.getSelectedItem().equals(" ")) {
                return;
            }
            if (this.isValueValid()) {
                int n3 = this.magCombo.getSelectedIndex();
                if (n3 != n2) {
                    this.constraints.setConstraint("Unit", new Integer(n3));
                    Integer n4 = (Integer)this.constraints.getConstraint("StringLengthType");
                    int n5 = 0;
                    if (n4 == null) {
                        n5 = 408;
                        this.constraints.setConstraint("StringLengthType", new Integer(n5));
                    } else {
                        n5 = n4;
                    }
                    boolean bl = SmartUtil.smartLOBLength(this, n2, n3, n5);
                    n2 = n3;
                    if (bl) {
                        this.fireValidityChanged(null);
                    } else {
                        Object[] objectArray;
                        if (this.tipPosition > 0) {
                            objectArray = SmartUtil.getDiagnosis(this);
                            String string = (String)this.constraints.getConstraint("TipDescription");
                            objectArray.setDescription(string);
                            SmartTipManager.sharedInstance().showDiagnosis(this, this.tipPosition, (Diagnosis)objectArray);
                        }
                        if ((objectArray = this.assistListeners.getListenerList()).length > 0) {
                            int n6 = objectArray.length - 2;
                            while (n6 >= 0) {
                                if (objectArray[n6] == SmartManager.getClass("DiagnosisListener")) {
                                    ((DiagnosisListener)objectArray[n6 + 1]).diagnosisChanged(this.diagnosisEvent);
                                }
                                n6 -= 2;
                            }
                        }
                        if (this.mPopup != null && ((EditPopup)((Object)this.mPopup)).getDiag() != null) {
                            ((EditPopup)((Object)this.mPopup)).getDiag().setEnabled(true);
                        }
                    }
                }
            } else {
                this.fix();
            }
        }
    }

    public String getUIClassID() {
        return "SmartFieldUI";
    }

    public void updateUI() {
        this.setUI((TextUI)UIManager.getUI(this));
        AssistEditorKit.enhanceKeymap(this.getKeymap());
        this.invalidate();
    }

    public void setCompletionCombo(SmartCombo smartCombo) {
    }

    public void setSmartBordersPolicy(boolean bl) {
        this.smartBordersPolicy = bl;
    }

    public boolean getSmartBordersPolicy() {
        return this.smartBordersPolicy;
    }

    public void setBorder() {
        char[] cArray = new char[7];
        cArray[0] = 115;
        cArray[1] = 70;
        cArray[3] = 111;
        cArray[4] = 101;
        cArray[6] = 32;
        String string = null;
        if (this.containingComponent != null) {
            this.containingComponent.setBorder();
            if (!this.valueValid) {
                return;
            }
        }
        Border border = null;
        boolean bl = !this.isEnabled() || !this.isEditable() ? false : this.hasFocus();
        JTable jTable = (JTable)SwingUtilities.getAncestorOfClass(class$javax$swing$JTable == null ? (class$javax$swing$JTable = SmartField.class$("javax.swing.JTable")) : class$javax$swing$JTable, this);
        if (jTable != null) {
            cArray[2] = 116;
            if (this.isEnabled() && !this.isValueValid() && AssistManager.getErrorBordersPolicy()) {
                cArray[5] = 101;
                cArray[6] = 116;
                border = AssistManager.getBorder("Assist.nested.error.border");
            } else {
                cArray[5] = bl ? 102 : 118;
                border = SmartManager.getBorder("Assist.nested.border", true, bl, string);
            }
            string = String.copyValueOf(cArray);
            if (!string.equals(this.prevBorderType)) {
                this.setBorder(border);
            }
        } else if (this.nested) {
            cArray[2] = 110;
            if (this.isEnabled() && !this.isValueValid() && AssistManager.getErrorBordersPolicy()) {
                cArray[5] = 101;
                if (AssistManager.getThinBordersPolicy()) {
                    cArray[6] = 116;
                    border = AssistManager.getBorder("Assist.nested.error.border");
                } else {
                    cArray[6] = 107;
                    border = AssistManager.getBorder("Assist.error.border");
                }
            } else {
                cArray[5] = bl ? 102 : 118;
                border = SmartManager.getBorder("Assist.nested.border", true, bl, string);
            }
            string = String.copyValueOf(cArray);
            if (!string.equals(this.prevBorderType)) {
                this.setBorder(AssistManager.padBorder(2, this, border, string));
            }
        } else {
            cArray[2] = 115;
            if (this.isEnabled() && !this.isValueValid() && AssistManager.getErrorBordersPolicy()) {
                cArray[5] = 101;
                cArray[6] = 107;
                border = SmartManager.getBorder("TextField.border", false, string);
            } else {
                cArray[5] = bl ? 102 : 118;
                border = SmartManager.getBorder("TextField.border", false, bl, string);
            }
            string = String.copyValueOf(cArray);
            if (!string.equals(this.prevBorderType)) {
                this.setBorder(AssistManager.padBorder(4, this, border, string));
            }
        }
        this.prevBorderType = string;
        this.repaint();
    }

    public void setClearDisabled(boolean bl) {
        if (bl != this.clearDisabled && !this.isEnabled()) {
            Integer n2 = (Integer)this.constraints.getConstraint("Type");
            if (bl && this.getText().length() > 0) {
                this.textTable.put(n2, this.getText());
                this.setText("");
            }
            if (!bl && this.getText().length() == 0) {
                this.setText((String)this.textTable.get(n2));
            }
        }
        super.setClearDisabled(bl);
    }

    public void setEnabled(boolean bl) {
        if (this.isEnabled() != bl) {
            Integer n2 = (Integer)this.constraints.getConstraint("Type");
            if (bl) {
                this.undoMgr.enableUndo(((EditPopup)((Object)this.mPopup)).getUndo(), ((EditPopup)((Object)this.mPopup)).getRedo());
                if (this.clearDisabled) {
                    this.setText((String)this.textTable.get(n2));
                }
            } else if (this.clearDisabled) {
                this.textTable.put(n2, this.getText());
            }
        }
        super.setEnabled(bl);
    }

    public void enableValid() {
        Border border = null;
        border = this.hasFocus() && this.smartBordersPolicy ? SmartManager.getBorder("TextField.border", true, true, this.prevBorderType) : AssistManager.getBorder("TextField.border");
        this.setBorder(AssistManager.padBorder(this, border, this.prevBorderType));
        if (this.mPopup != null) {
            this.undoMgr.enableUndo(((EditPopup)((Object)this.mPopup)).getUndo(), ((EditPopup)((Object)this.mPopup)).getRedo());
            if (((EditPopup)((Object)this.mPopup)).getFix() != null) {
                ((EditPopup)((Object)this.mPopup)).getFix().setEnabled(false);
            }
        }
        this.valueValid = true;
    }

    public void constraintChanged(Object object, Object object2, Object object3) {
        if (object.equals("Type")) {
            int n2 = (Integer)object3;
            this.mPopup = n2 == 0 ? new SmartEditPopup(this, true, false) : new SmartEditPopup(this);
            if (n2 == 32 || n2 == 48 || n2 == 64 || n2 == 12288 || n2 == 16384 || n2 == 20480 || n2 == 24576 || n2 == 28672) {
                this.setHorizontalAlignment(4);
            }
        }
    }

    public void constraintFlagChanged(int n2, boolean bl) {
        if (n2 == 0 && bl != this.required && bl && this.isEditable() && this.getText().length() == 0) {
            this.setText(this.constraints.getDefaultString());
        }
    }

    public Diagnosis getDiagnosis() {
        if (this.isValueValid()) {
            return null;
        }
        return SmartUtil.getDiagnosis(this);
    }

    public void addDiagnosisListener(DiagnosisListener diagnosisListener, Object object) {
        this.removeDiagnosisListener(diagnosisListener);
        this.assistListeners.add(SmartManager.getClass("DiagnosisListener"), diagnosisListener);
        this.diagnosisContexts.put(diagnosisListener, object);
        if (this.diagnosisEvent == null) {
            this.diagnosisEvent = new DiagnosisEvent(this);
        }
        if (this.assistContext == null) {
            this.assistContext = object;
        }
        this.valuePreviouslyValid = this.valueValid;
        diagnosisListener.diagnosisChanged(this.diagnosisEvent);
    }

    public void removeDiagnosisListener(DiagnosisListener diagnosisListener) {
        if (this.diagnosisContexts.get(diagnosisListener) != null) {
            this.diagnosisContexts.remove(diagnosisListener);
            this.assistListeners.remove(SmartManager.getClass("DiagnosisListener"), diagnosisListener);
        }
    }

    public Object getDiagnosisContext(DiagnosisListener diagnosisListener) {
        return this.diagnosisContexts.get(diagnosisListener);
    }

    public void addUniquenessListener(UniquenessListener uniquenessListener, Object object) {
        this.assistListeners.remove(SmartManager.getClass("UniquenessListener"), uniquenessListener);
        this.assistListeners.add(SmartManager.getClass("UniquenessListener"), uniquenessListener);
        this.uniquenessContexts.put(uniquenessListener, object);
    }

    public void removeUniquenessListener(UniquenessListener uniquenessListener) {
        this.uniquenessContexts.remove(uniquenessListener);
        this.assistListeners.remove(SmartManager.getClass("UniquenessListener"), uniquenessListener);
    }

    public Object getUniquenessContext(UniquenessListener uniquenessListener) {
        return this.uniquenessContexts.get(uniquenessListener);
    }

    public void select(int n2) {
        char c2 = '\"';
        String string = (String)this.constraints.getConstraint("Delimiter");
        if (string != null && string.length() > 0) {
            c2 = string.charAt(0);
        }
        switch (n2) {
            case 1: {
                int n3 = SmartUtil.getDot(this.getText(), true, c2);
                this.setCaretPosition(0);
                this.moveCaretPosition(n3 - 1);
                break;
            }
            case 2: {
                int n4 = SmartUtil.getDot(this.getText(), true, c2);
                this.setCaretPosition(n4 + 1);
                this.moveCaretPosition(this.getText().length());
                break;
            }
            default: {
                this.selectAll();
            }
        }
    }

    public boolean verifyUniqueness() {
        if (!this.isValueValid()) {
            return false;
        }
        Object[] objectArray = this.assistListeners.getListenerList();
        if (objectArray.length > 0) {
            boolean bl = false;
            Integer n2 = (Integer)this.constraints.getConstraint("Type");
            switch (n2) {
                case 1: 
                case 8: 
                case 16: 
                case 144: {
                    bl = false;
                    break;
                }
                case 2: 
                case 10: 
                case 18: {
                    bl = true;
                    break;
                }
                default: {
                    bl = true;
                }
            }
            String string = this.constraints.getDefaultString();
            int n3 = objectArray.length - 2;
            while (n3 >= 0) {
                if (objectArray[n3] == SmartManager.getClass("UniquenessListener")) {
                    UniquenessListener uniquenessListener = (UniquenessListener)objectArray[n3 + 1];
                    Object v2 = this.uniquenessContexts.get(uniquenessListener);
                    Vector vector = uniquenessListener.getExistingNames(v2);
                    if (vector != null && !SmartUtil.checkUniqueness(this, string, vector, bl)) {
                        this.fireValidityChanged();
                        if (this.mPopup != null && ((EditPopup)((Object)this.mPopup)).getDiag() != null) {
                            ((EditPopup)((Object)this.mPopup)).getDiag().setEnabled(true);
                        }
                        this.uniquenessError = true;
                        return false;
                    }
                    this.fireValidityChanged(null);
                }
                n3 -= 2;
            }
            return true;
        }
        return true;
    }

    public void processKeyEvent(KeyEvent keyEvent) {
        if (this.isPopupShowing()) {
            AssistManager.redirectKeyEvent(keyEvent, this.mPopup);
            return;
        }
        int n2 = keyEvent.getID();
        int n3 = keyEvent.getKeyCode();
        JTable jTable = (JTable)SwingUtilities.getAncestorOfClass(class$javax$swing$JTable == null ? (class$javax$swing$JTable = SmartField.class$("javax.swing.JTable")) : class$javax$swing$JTable, this);
        if (jTable != null) {
            if (n2 == 401 && (n3 == 9 || keyEvent.getKeyChar() == '\t' || n3 == 27)) {
                AssistManager.redirectKeyEvent(keyEvent, jTable);
            } else if (n2 == 402) {
                this.processKeyReleased(keyEvent);
                if (!keyEvent.isConsumed()) {
                    super.processKeyEvent(keyEvent);
                }
            } else {
                super.processKeyEvent(keyEvent);
            }
        } else if ((n3 == 9 || keyEvent.getKeyChar() == '\t') && this.mPopup.isVisible()) {
            keyEvent.consume();
        } else if (n2 == 402) {
            if (n3 == 10) {
                this.verify(false);
                if (this.valueValid) {
                    super.processKeyEvent(keyEvent);
                }
            } else {
                this.processKeyReleased(keyEvent);
            }
        } else if (n2 == 401) {
            if (n3 == 10) {
                super.processKeyEvent(keyEvent);
            } else if (n3 == 27 && SmartTipManager.sharedInstance().isDiagnosisVisible()) {
                SmartTipManager.sharedInstance().hideDiagnosis();
                keyEvent.consume();
            }
        }
        if (!keyEvent.isConsumed()) {
            super.processKeyEvent(keyEvent);
        }
    }

    protected void processKeyReleased(KeyEvent keyEvent) {
        boolean bl = true;
        int n2 = keyEvent.getKeyCode();
        switch (n2) {
            case 9: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 25: 
            case 27: 
            case 29: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 122: 
            case 123: 
            case 144: 
            case 145: 
            case 155: 
            case 156: 
            case 157: {
                bl = false;
                break;
            }
            default: {
                int n3 = keyEvent.getModifiers();
                if (n3 == 1 && n2 == 121) {
                    if (!SmartTipManager.sharedInstance().showPopupMenu()) {
                        Rectangle rectangle = this.getBounds();
                        Point point = new Point(rectangle.width / 2, rectangle.height / 2);
                        this.showPopup(this, point, false);
                    }
                    keyEvent.consume();
                    bl = false;
                    break;
                }
                if (n3 == 2 && n2 == 89 || n3 == 9 && n2 == 8) {
                    if (!this.undoMgr.canRedo()) break;
                    this.undoMgr.redo();
                    this.undoMgr.enableUndo(((EditPopup)((Object)this.mPopup)).getUndo(), ((EditPopup)((Object)this.mPopup)).getRedo());
                    bl = false;
                    if (SmartManager.getFixPolicy()) break;
                    this.verify();
                    break;
                }
                if (n3 == 2 && n2 == 90 || n3 == 8 && n2 == 8 || n3 == 3 && n2 == 90) {
                    if (!this.undoMgr.canUndo()) break;
                    this.undoMgr.undo();
                    this.undoMgr.enableUndo(((EditPopup)((Object)this.mPopup)).getUndo(), ((EditPopup)((Object)this.mPopup)).getRedo());
                    bl = false;
                    if (SmartManager.getFixPolicy()) break;
                    this.verify();
                    break;
                }
                if (n3 == 2 && n2 == 88 || n3 == 1 && n2 == 127) {
                    if (this.prevCaretDot < this.prevCaretMark) {
                        this.prevCaretMark = this.prevCaretDot;
                    } else {
                        this.prevCaretDot = this.prevCaretMark;
                    }
                    this.setCaretColor(Color.black);
                    this.undoMgr.enableUndo(((EditPopup)((Object)this.mPopup)).getUndo(), ((EditPopup)((Object)this.mPopup)).getRedo());
                    if (SmartManager.getFixPolicy()) break;
                    this.verify();
                    break;
                }
                if (n3 == 2 && n2 == 67 || n3 == 2 && n2 == 155) {
                    if (!(this.mPopup instanceof EditPopup) || ((EditPopup)((Object)this.mPopup)).getPaste() == null) break;
                    ((EditPopup)((Object)this.mPopup)).getPaste().setEnabled(true);
                    break;
                }
                if (n3 == 2 && n2 == 86 || n3 == 1 && n2 == 155) {
                    this.prevCaretMark = this.prevCaretDot = this.getCaretPosition();
                    this.setCaretColor(Color.black);
                    this.undoMgr.enableUndo(((EditPopup)((Object)this.mPopup)).getUndo(), ((EditPopup)((Object)this.mPopup)).getRedo());
                    if (SmartManager.getFixPolicy()) break;
                    this.verify();
                    break;
                }
                if (n3 == 2 && n2 == 68) {
                    if (this.mPopup == null || ((EditPopup)((Object)this.mPopup)).getDiag() == null || !((EditPopup)((Object)this.mPopup)).getDiag().isEnabled()) break;
                    this.mereDiagnosis = true;
                    int n4 = SmartManager.getDiagnosisPolicy();
                    if (n4 == -1) {
                        SmartManager.setDiagnosisPolicy(0);
                    }
                    this.showDiagnosis(SmartUtil.getDiagnosis(this));
                    if (n4 == -1) {
                        SmartManager.setDiagnosisPolicy(n4);
                    }
                    this.mereDiagnosis = false;
                    bl = false;
                    break;
                }
                if (n3 == 2 && n2 == 70) {
                    if (((EditPopup)((Object)this.mPopup)).getFix() == null) break;
                    this.fix();
                    bl = false;
                    break;
                }
                if (n3 != 2 || n2 != 10) break;
                if (!SmartManager.getFixPolicy()) {
                    this.verify(false);
                }
                bl = false;
            }
        }
        if (bl) {
            this.undoMgr.enableUndo(((EditPopup)((Object)this.mPopup)).getUndo(), ((EditPopup)((Object)this.mPopup)).getRedo());
        }
    }

    public void verifyImmediately(boolean bl) {
        if (this.verifying) {
            return;
        }
        this.verifying = true;
        boolean bl2 = this.valueValid;
        if (this.isEnabled()) {
            if (this.constraints != null && this.verifierInstances != null) {
                Integer n2 = (Integer)this.constraints.getConstraint("Type");
                if (!this.isEditable() || this.textTable == null) {
                    this.valueValid = true;
                    if (this.valueValid != bl2) {
                        this.fireValidityChanged(null);
                    }
                } else if (n2 == null || n2 == 0) {
                    this.required = this.getConstraints().getRequired();
                    super.verify(bl, true);
                    this.emptyVerify(this.valueValid);
                    if (this.valueValid != bl2) {
                        this.fireValidityChanged(SmartUtil.getDiagnosis(this));
                    }
                } else {
                    this.smartVerify(bl);
                }
            } else {
                this.required = this.getConstraints().getRequired();
                super.verify(bl, true);
                this.emptyVerify(this.valueValid);
                if (this.valueValid != bl2) {
                    this.fireValidityChanged(SmartUtil.getDiagnosis(this));
                }
            }
        } else {
            this.emptyVerify(true);
            if (this.valueValid != bl2) {
                this.fireValidityChanged(null);
            }
        }
        this.setBorder();
        this.verifying = false;
    }

    public void verify() {
        this.verify(false);
    }

    public void verify(boolean bl) {
        if (this.constraints == null) {
            super.verify(bl);
        } else {
            Integer n2 = (Integer)this.constraints.getConstraint("Type");
            if (n2 == null) {
                return;
            }
            if (this.delay > 0 && this.verifyTimer == null) {
                this.verifyTimer = new Timer(this.delay, this);
                this.verifyTimer.setInitialDelay(0);
                this.verifyTimer.setRepeats(false);
            }
            this.verifyTimer.setDelay(bl ? this.delay : this.delay + 1);
            this.verifyTimer.restart();
        }
    }

    public void emptyVerify(boolean bl) {
        Diagnosis diagnosis;
        if (this.verifyTimer != null) {
            this.verifyTimer.stop();
        }
        this.valueValid = bl;
        SmartUtil.smartValueRequired(this, bl);
        String string = null;
        if (this.constraints != null) {
            string = (String)this.constraints.getConstraint("TipDescription");
        }
        if (string != null && (diagnosis = SmartUtil.getDiagnosis(this)) != null) {
            diagnosis.setDescription(string);
        }
    }

    public void smartVerify(boolean bl) {
        if (this.verifyTimer != null) {
            this.verifyTimer.stop();
        }
        if (this.constraints == null || this.verifierInstances == null || this.verifierInstances.size() == 0) {
            return;
        }
        if (!this.constraints.getConstraintFlag(3).booleanValue()) {
            bl = false;
        }
        this.constraints.setConstraintFlag(6, bl);
        this.constraints.setConstraintFlag(7, true);
        this.checking = true;
        boolean bl2 = true;
        boolean bl3 = true;
        Enumeration enumeration = this.verifierInstances.elements();
        if (!enumeration.hasMoreElements()) {
            return;
        }
        SmartVerifier smartVerifier = (SmartVerifier)enumeration.nextElement();
        bl3 = smartVerifier.smartVerify(this, this.constraints);
        if (enumeration.hasMoreElements()) {
            this.constraints.setConstraintFlag(7, false);
            while (enumeration.hasMoreElements()) {
                smartVerifier = (SmartVerifier)enumeration.nextElement();
                bl2 = smartVerifier.smartVerify(this, this.constraints);
                boolean bl4 = bl3 = bl3 && bl2;
            }
        }
        JComponent jComponent = (JComponent)this.constraints.getConstraint("Mate");
        if (bl3 && jComponent != null && jComponent instanceof SmartComponent) {
            Enumeration enumeration2 = ((SmartComponent)((Object)jComponent)).getSmartVerifiers();
            SmartConstraints smartConstraints = ((SmartComponent)((Object)jComponent)).getConstraints();
            smartVerifier = (SmartVerifier)enumeration2.nextElement();
            bl2 = smartVerifier.smartVerify(jComponent, smartConstraints);
            if (enumeration2.hasMoreElements()) {
                this.constraints.setConstraintFlag(7, false);
                while (enumeration2.hasMoreElements()) {
                    smartVerifier = (SmartVerifier)enumeration2.nextElement();
                    bl2 = smartVerifier.smartVerify(jComponent, smartConstraints);
                }
            }
            if (bl2) {
                ((SmartComponent)((Object)jComponent)).enableValid();
                ((SmartComponent)((Object)jComponent)).fireValidityChanged(null);
            }
        }
        this.valueValid = bl3;
        if (this.valueValid) {
            this.valueValid = true;
            this.fireValidityChanged(null);
        } else {
            this.fireValidityChanged();
            if (this.mPopup != null && this.mPopup instanceof EditPopup && ((EditPopup)((Object)this.mPopup)).getDiag() != null) {
                ((EditPopup)((Object)this.mPopup)).getDiag().setEnabled(true);
            }
        }
        if (this.valueValid && !this.fixing && this.getText().trim().length() > 0) {
            this.valueValid = this.verifyUniqueness();
        }
        this.checking = false;
        this.setBorder();
    }

    protected void setValidationState(Diagnosis diagnosis) {
        if (!this.mereDiagnosis && !this.fixing && this.mPopup != null && this.mPopup instanceof EditPopup && ((EditPopup)((Object)this.mPopup)).getFix() != null) {
            if (diagnosis != null) {
                ((EditPopup)((Object)this.mPopup)).getFix().setEnabled(true);
            } else {
                ((EditPopup)((Object)this.mPopup)).getFix().setEnabled(false);
            }
        }
    }

    public void fireValidityChanged() {
        if (this.delay > 0 && this.diagTimer == null) {
            this.diagTimer = new Timer(this.delay, this);
            this.diagTimer.setInitialDelay(this.delay);
            this.diagTimer.setRepeats(false);
        }
        if (this.delay > 0) {
            this.diagTimer.restart();
        } else {
            this.fireValidityChanged(SmartUtil.getDiagnosis(this));
        }
    }

    public void fireValidityChanged(Diagnosis diagnosis) {
        Object object;
        this.setValidationState(diagnosis);
        if (this.tipPosition > 0 && diagnosis == null) {
            SmartTipManager.sharedInstance().hideDiagnosis();
        }
        if (diagnosis != null) {
            object = (String)this.constraints.getConstraint("TipDescription");
            if (object == null) {
                object = SmartResources.get(217);
            }
            diagnosis.setDescription((String)object);
        }
        if (((Object[])(object = this.assistListeners.getListenerList())).length > 0) {
            int n2 = ((Object[])object).length - 2;
            while (n2 >= 0) {
                if (object[n2] == (class$com$ibm$db2$tools$common$event$AssistListener == null ? SmartField.class$("com.ibm.db2.tools.common.event.AssistListener") : class$com$ibm$db2$tools$common$event$AssistListener) && this.valuePreviouslyValid != this.valueValid) {
                    ((AssistListener)object[n2 + 1]).validityChanged(this.assistEvent);
                } else if (object[n2] == (class$com$ibm$db2$tools$common$smartx$event$DiagnosisListener == null ? SmartField.class$("com.ibm.db2.tools.common.smartx.event.DiagnosisListener") : class$com$ibm$db2$tools$common$smartx$event$DiagnosisListener) && diagnosis != null && !diagnosis.equals(this.previousDiagnosis)) {
                    ((DiagnosisListener)object[n2 + 1]).diagnosisChanged(this.diagnosisEvent);
                } else if (object[n2] == (class$com$ibm$db2$tools$common$smartx$event$DiagnosisListener == null ? SmartField.class$("com.ibm.db2.tools.common.smartx.event.DiagnosisListener") : class$com$ibm$db2$tools$common$smartx$event$DiagnosisListener) && diagnosis == null && this.valuePreviouslyValid != this.valueValid) {
                    ((DiagnosisListener)object[n2 + 1]).diagnosisChanged(this.diagnosisEvent);
                }
                n2 -= 2;
            }
        }
        if (diagnosis != null) {
            this.showDiagnosis(diagnosis);
        }
        this.valuePreviouslyValid = this.valueValid;
        this.previousDiagnosis = diagnosis;
    }

    protected void showDiagnosis(Diagnosis diagnosis) {
        if (this.tipPosition > 0 && diagnosis != null) {
            String string = (String)this.constraints.getConstraint("TipDescription");
            diagnosis.setDescription(string);
            SmartTipManager.sharedInstance().showDiagnosis(this, this.tipPosition, diagnosis);
        }
    }

    public void fix() {
        Boolean bl = this.constraints.getConstraintFlag(4);
        this.constraints.setConstraintFlag(4, Boolean.FALSE);
        if (this.mPopup instanceof EditPopup && ((EditPopup)((Object)this.mPopup)).getFix() != null) {
            ((EditPopup)((Object)this.mPopup)).getFix().setEnabled(false);
        }
        this.constraints.setConstraintFlag(5, true);
        this.fixing = true;
        this.verifyImmediately(false);
        if (this.uniquenessError && this.getText().trim().length() > 0) {
            this.verifyUniqueness();
            this.uniquenessError = false;
        }
        this.fixing = false;
        this.constraints.setConstraintFlag(5, false);
        this.constraints.setConstraintFlag(4, bl);
    }

    public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
        if (this.clipped) {
            return;
        }
        if (this.checking) {
            if (!this.changing) {
                this.undoMgr.addEdit(undoableEditEvent.getEdit());
                this.changing = true;
            } else if (this.foreDoc != null) {
                if (this.foreDoc.equals(this.getText())) {
                    this.undoMgr.combine4(undoableEditEvent.getEdit());
                } else {
                    this.undoMgr.combine3(undoableEditEvent.getEdit());
                }
                this.changing = false;
            }
        } else {
            if (this.prevDoc.equals("")) {
                this.undoMgr.combine1(undoableEditEvent.getEdit());
            } else {
                this.undoMgr.addEdit(undoableEditEvent.getEdit());
            }
            this.foreDoc = this.prevDoc;
            this.prevDoc = this.getText();
        }
        if (this.isShowing()) {
            this.setShowInitialDiagnosis(true);
        }
    }

    public void showPopup(Component component, Point point) {
        this.showPopup(component, point, true);
    }

    public void showPopup(Component component, Point point, boolean bl) {
        MenuElement[] menuElementArray;
        SmartTable smartTable = (SmartTable)SwingUtilities.getAncestorOfClass(class$com$ibm$db2$tools$common$smartx$SmartTable == null ? (class$com$ibm$db2$tools$common$smartx$SmartTable = SmartField.class$("com.ibm.db2.tools.common.smartx.SmartTable")) : class$com$ibm$db2$tools$common$smartx$SmartTable, this);
        if (smartTable != null && (menuElementArray = smartTable.getTableEditorActions()) != null) {
            if (!this.mPopup.isAncestorOf((Component)((Object)menuElementArray[0]))) {
                this.mPopup.addSeparator();
                int n2 = 0;
                while (n2 < menuElementArray.length) {
                    this.mPopup.add((JMenuItem)menuElementArray[n2]);
                    ++n2;
                }
            }
            smartTable.configureTableEditorActions();
        }
        if (component != this) {
            point = SwingUtilities.convertPoint(component, point, this);
        }
        if (((EditPopup)((Object)this.mPopup)).getDiag() != null) {
            ((EditPopup)((Object)this.mPopup)).enableDiag(bl);
        }
        ((EditPopup)((Object)this.mPopup)).showPopup(this, point);
        if (this.prevCaretDot == this.prevCaretMark) {
            if (((EditPopup)((Object)this.mPopup)).getCut() != null) {
                ((EditPopup)((Object)this.mPopup)).getCut().setEnabled(false);
            }
            if (((EditPopup)((Object)this.mPopup)).getCopy() != null) {
                ((EditPopup)((Object)this.mPopup)).getCopy().setEnabled(false);
            }
        } else {
            if (this.isEditable()) {
                if (((EditPopup)((Object)this.mPopup)).getCut() != null) {
                    ((EditPopup)((Object)this.mPopup)).getCut().setEnabled(true);
                }
            } else if (((EditPopup)((Object)this.mPopup)).getCut() != null) {
                ((EditPopup)((Object)this.mPopup)).getCut().setEnabled(false);
            }
            if (((EditPopup)((Object)this.mPopup)).getCopy() != null) {
                ((EditPopup)((Object)this.mPopup)).getCopy().setEnabled(true);
            }
        }
        this.allowPopup = true;
    }

    public void hidePopup() {
        if (this.mPopup != null && this.mPopup.isVisible()) {
            this.mPopup.setVisible(false);
            this.allowPopup = false;
        }
    }

    public boolean isPopupShowing() {
        return this.mPopup != null && this.mPopup.isVisible();
    }

    public boolean allowLink() {
        return this.allowLink;
    }

    public boolean allowPopup() {
        return this.allowPopup;
    }

    public void setAllowPopup(boolean bl) {
        this.allowPopup = bl;
    }

    public void setAllowLink(boolean bl) {
        this.allowLink = bl;
    }

    public void caretUpdate(CaretEvent caretEvent) {
        if (this.button3Up) {
            this.prevCaretDot = caretEvent.getDot();
            this.prevCaretMark = caretEvent.getMark();
        }
        if (this.prevCaretDot == this.prevCaretMark) {
            this.setCaretColor(Color.black);
        } else {
            this.setCaretColor(this.getBackground());
            if (this.hasFocus()) {
                this.getCaret().setVisible(true);
            }
        }
    }

    protected void restoreCaret() {
        if (this.prevCaretMark != this.getCaret().getMark() || this.prevCaretDot != this.getCaret().getDot()) {
            this.button3Up = false;
            this.getCaret().setDot(this.prevCaretMark);
            this.getCaret().moveDot(this.prevCaretDot);
            this.button3Up = true;
        }
        if (this.prevCaretDot == this.prevCaretMark) {
            this.setCaretColor(Color.black);
        } else {
            this.setCaretColor(this.getBackground());
            if (this.hasFocus()) {
                this.getCaret().setVisible(true);
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.allowPopup = false;
        Object object = actionEvent.getSource();
        if (object == this.diagTimer) {
            Diagnosis diagnosis = SmartUtil.getDiagnosis(this);
            if (diagnosis != null) {
                this.fireValidityChanged(diagnosis);
            }
        } else if (object == this.verifyTimer) {
            this.verifyImmediately(this.verifyTimer.getDelay() == this.delay);
        } else {
            super.actionPerformed(actionEvent);
        }
        if (this.mPopup != null) {
            if (object == ((EditPopup)((Object)this.mPopup)).getUndo()) {
                this.undoMgr.undo();
                this.undoMgr.enableUndo(((EditPopup)((Object)this.mPopup)).getUndo(), ((EditPopup)((Object)this.mPopup)).getRedo());
                if (!SmartManager.getFixPolicy()) {
                    this.verify();
                }
            } else if (object == ((EditPopup)((Object)this.mPopup)).getRedo()) {
                this.undoMgr.redo();
                this.undoMgr.enableUndo(((EditPopup)((Object)this.mPopup)).getUndo(), ((EditPopup)((Object)this.mPopup)).getRedo());
                if (!SmartManager.getFixPolicy()) {
                    this.verify();
                }
            } else if (object == ((EditPopup)((Object)this.mPopup)).getCut()) {
                this.restoreCaret();
                this.cut();
                if (this.prevCaretDot < this.prevCaretMark) {
                    this.prevCaretMark = this.prevCaretDot;
                } else {
                    this.prevCaretDot = this.prevCaretMark;
                }
                this.setCaretColor(Color.black);
                this.undoMgr.enableUndo(((EditPopup)((Object)this.mPopup)).getUndo(), ((EditPopup)((Object)this.mPopup)).getRedo());
                if (!SmartManager.getFixPolicy()) {
                    this.verify();
                }
            } else if (object == ((EditPopup)((Object)this.mPopup)).getCopy()) {
                this.restoreCaret();
                this.copy();
            } else if (object == ((EditPopup)((Object)this.mPopup)).getPaste() && AssistEditorKit.canPaste(this)) {
                this.restoreCaret();
                this.paste();
                this.prevCaretMark = this.prevCaretDot = this.getCaretPosition();
                this.setCaretColor(Color.black);
                this.undoMgr.enableUndo(((EditPopup)((Object)this.mPopup)).getUndo(), ((EditPopup)((Object)this.mPopup)).getRedo());
                if (!SmartManager.getFixPolicy()) {
                    this.verify();
                }
            } else if (object == ((EditPopup)((Object)this.mPopup)).getDiag()) {
                this.mereDiagnosis = true;
                int n2 = SmartManager.getDiagnosisPolicy();
                if (n2 == -1) {
                    SmartManager.setDiagnosisPolicy(0);
                }
                this.showDiagnosis(SmartUtil.getDiagnosis(this));
                if (n2 == -1) {
                    SmartManager.setDiagnosisPolicy(n2);
                }
                this.mereDiagnosis = false;
            } else if (((EditPopup)((Object)this.mPopup)).getFix() != null && object == ((EditPopup)((Object)this.mPopup)).getFix()) {
                this.fix();
            }
        }
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        int n2 = mouseEvent.getID();
        switch (n2) {
            case 501: 
            case 502: {
                if (mouseEvent.isPopupTrigger()) {
                    this.button3Up = false;
                    this.restoreCaret();
                    this.showPopup(this, mouseEvent.getPoint(), false);
                    mouseEvent.consume();
                    break;
                }
                this.button3Up = true;
                break;
            }
        }
        if (!mouseEvent.isConsumed()) {
            super.processMouseEvent(mouseEvent);
        }
    }

    protected void processFocusEvent(FocusEvent focusEvent) {
        this.button3Up = false;
        super.processFocusEvent(focusEvent);
        this.button3Up = true;
        switch (focusEvent.getID()) {
            case 1004: {
                if (!this.isEnabled() || !this.isValueValid() || !this.smartBordersPolicy) break;
                this.setBorder();
                this.repaint();
                break;
            }
            case 1005: {
                if (focusEvent.isTemporary()) break;
                if (this.allowPopup) {
                    this.requestFocus();
                } else {
                    SmartTable smartTable = (SmartTable)SwingUtilities.getAncestorOfClass(class$com$ibm$db2$tools$common$smartx$SmartTable == null ? (class$com$ibm$db2$tools$common$smartx$SmartTable = SmartField.class$("com.ibm.db2.tools.common.smartx.SmartTable")) : class$com$ibm$db2$tools$common$smartx$SmartTable, this);
                    if (smartTable == null) {
                        this.verifyImmediately(false);
                        this.setBorder();
                        this.repaint();
                    }
                }
                if (System.getProperty("os.name").startsWith("Windows")) {
                    if (this.prevCaretDot < this.prevCaretMark) {
                        this.prevCaretMark = this.prevCaretDot;
                    } else {
                        this.prevCaretDot = this.prevCaretMark;
                    }
                }
                this.setCaretColor(Color.black);
            }
        }
    }

    public void setPopup(JPopupMenu jPopupMenu) {
        this.mPopup = jPopupMenu;
    }

    public JPopupMenu getPopup() {
        return this.mPopup;
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleSmartField();
        }
        return this.accessibleContext;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected class AccessibleSmartField
    extends JTextField.AccessibleJTextField {
        private static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

        public AccessibleSmartField() {
            super(SmartField.this);
        }

        public int getAccessibleChildrenCount() {
            return super.getAccessibleChildrenCount() + 1;
        }

        public Accessible getAccessibleChild(int n2) {
            Accessible accessible = super.getAccessibleChild(n2);
            if (accessible == null && n2 < this.getAccessibleChildrenCount()) {
                return SmartField.this.mPopup;
            }
            return null;
        }
    }
}

