/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common.smartx;

import com.ibm.db2.tools.common.AssistArea;
import com.ibm.db2.tools.common.event.AssistListener;
import com.ibm.db2.tools.common.smartx.SmartTable;
import com.ibm.db2.tools.common.smartx.event.Diagnosis;
import com.ibm.db2.tools.common.smartx.event.DiagnosisEvent;
import com.ibm.db2.tools.common.smartx.event.DiagnosisListener;
import com.ibm.db2.tools.common.smartx.support.EditPopup;
import com.ibm.db2.tools.common.smartx.support.SmartComponent;
import com.ibm.db2.tools.common.smartx.support.SmartConstraints;
import com.ibm.db2.tools.common.smartx.support.SmartEditPopup;
import com.ibm.db2.tools.common.smartx.support.SmartManager;
import com.ibm.db2.tools.common.smartx.support.SmartResources;
import com.ibm.db2.tools.common.smartx.support.SmartTipManager;
import com.ibm.db2.tools.common.smartx.support.SmartUndoManager;
import com.ibm.db2.tools.common.smartx.support.SmartUtil;
import com.ibm.db2.tools.common.smartx.support.SmartVerifier;
import com.ibm.db2.tools.common.smartx.support.VerifierUtil;
import com.ibm.db2.tools.common.support.AssistComponent;
import com.ibm.db2.tools.common.support.AssistEditorKit;
import com.ibm.db2.tools.common.support.AssistManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.MenuElement;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.plaf.TextUI;
import javax.swing.text.Document;

public class SmartArea
extends AssistArea
implements SmartComponent,
UndoableEditListener,
ActionListener,
CaretListener,
Serializable {
    private static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected SmartConstraints constraints;
    protected Vector verifierInstances;
    protected SmartUndoManager undoMgr = new SmartUndoManager();
    protected boolean fixing;
    protected boolean verifying;
    protected boolean checking;
    protected boolean changing;
    protected int prevCaretDot;
    protected int prevCaretMark;
    protected boolean button3Up = true;
    protected String foreDoc = "";
    protected String prevDoc = "";
    protected Hashtable textTable;
    protected boolean mereDiagnosis;
    protected Diagnosis previousDiagnosis;
    protected DiagnosisEvent diagnosisEvent;
    protected Hashtable diagnosisContexts;
    protected Timer diagTimer;
    protected int delay;
    protected int tipPosition;
    protected int diagnose;
    protected AssistComponent containingComponent;
    protected JPopupMenu mPopup;
    protected boolean allowLink;
    protected boolean allowPopup;
    protected boolean smartBordersPolicy;
    static /* synthetic */ Class class$com$ibm$db2$tools$common$smartx$event$DiagnosisListener;
    static /* synthetic */ Class class$javax$swing$JTable;
    static /* synthetic */ Class class$com$ibm$db2$tools$common$event$AssistListener;
    static /* synthetic */ Class class$com$ibm$db2$tools$common$smartx$SmartTable;

    public SmartArea() {
        this(null, null, null, null, 0, 0);
    }

    public SmartArea(String string) {
        this(null, null, null, string, 0, 0);
    }

    public SmartArea(int n2, int n3) {
        this(null, null, null, null, n2, n3);
    }

    public SmartArea(String string, int n2, int n3) {
        this(null, null, null, string, n2, n3);
    }

    public SmartArea(Document document) {
        this(null, null, document, null, 0, 0);
    }

    public SmartArea(Document document, String string, int n2, int n3) {
        this(null, null, document, string, n2, n3);
    }

    public SmartArea(SmartConstraints smartConstraints, SmartVerifier smartVerifier) {
        this(smartConstraints, smartVerifier, null, null, 0, 0);
    }

    public SmartArea(SmartConstraints smartConstraints, SmartVerifier smartVerifier, String string) {
        this(smartConstraints, smartVerifier, null, string, 0, 0);
    }

    public SmartArea(SmartConstraints smartConstraints, SmartVerifier smartVerifier, int n2, int n3) {
        this(smartConstraints, smartVerifier, null, null, n2, n3);
    }

    public SmartArea(SmartConstraints smartConstraints, SmartVerifier smartVerifier, String string, int n2, int n3) {
        this(smartConstraints, smartVerifier, null, string, n2, n3);
    }

    public SmartArea(SmartConstraints smartConstraints, SmartVerifier smartVerifier, Document document) {
        this(smartConstraints, smartVerifier, document, null, 0, 0);
    }

    public SmartArea(SmartConstraints smartConstraints, SmartVerifier smartVerifier, Document document, String string, int n2, int n3) {
        this.undoMgr.discardAllEdits();
        if (smartConstraints == null) {
            smartConstraints = new SmartConstraints(this.getRequired(), 0);
        }
        if (smartVerifier != null) {
            this.setSmartVerifier(smartVerifier);
        }
        this.setConstraints(smartConstraints);
        this.mPopup = smartConstraints.getType() == 0 ? new SmartEditPopup(this, true, false) : new SmartEditPopup(this);
        this.setLineWrap(true);
        this.setWrapStyleWord(true);
        this.smartBordersPolicy = SmartManager.getSmartBordersPolicy();
        this.textTable = new Hashtable(10);
        this.diagnosisContexts = new Hashtable(2);
        if (document == null) {
            document = this.createDefaultModel();
        }
        this.setDocument(document);
        this.checking = false;
        this.changing = false;
        if (string == null) {
            this.setToDefault();
        } else {
            this.setText(string);
        }
        this.foreDoc = this.getText();
        this.setRows(n2);
        this.setColumns(n3);
        this.getDocument().putProperty("tabSize", new Integer(2));
        this.tipPosition = SmartManager.getTipPositionPolicy();
        this.diagnose = -1;
        AssistEditorKit.enhanceKeymap(this.getKeymap());
        this.addCaretListener(this);
        this.enableEvents(16L);
    }

    public SmartConstraints getConstraints() {
        return this.constraints;
    }

    public void setConstraints(SmartConstraints smartConstraints) {
        boolean bl;
        Diagnosis diagnosis;
        if (smartConstraints == null) {
            smartConstraints = new SmartConstraints(true, 0);
        }
        this.constraints = smartConstraints;
        smartConstraints.setSmartComponent(this);
        String string = (String)smartConstraints.getConstraint("TipDescription");
        if (string == null) {
            string = SmartResources.get(217);
            smartConstraints.setConstraint("TipDescription", string);
        }
        if ((diagnosis = SmartUtil.getDiagnosis(this)) != null) {
            diagnosis.setDescription(string);
        }
        if ((bl = smartConstraints.getConstraintFlag(0).booleanValue()) != this.required && bl && this.isEditable() && this.getText().length() == 0) {
            this.setText(smartConstraints.getDefaultString());
            super.setRequired(bl);
        }
        if (smartConstraints.getType() > 0 && (this.verifierInstances == null || this.verifierInstances.size() == 0)) {
            this.setSmartVerifier(VerifierUtil.getSharedVerifier(smartConstraints.getType()));
        }
    }

    public void setSmartVerifier(SmartVerifier smartVerifier) {
        if (smartVerifier == null) {
            return;
        }
        if (this.verifierInstances == null) {
            this.verifierInstances = new Vector(1, 1);
        } else if (this.verifierInstances.size() > 0) {
            this.verifierInstances.clear();
        }
        this.verifierInstances.addElement(smartVerifier);
    }

    public void addSmartVerifier(SmartVerifier smartVerifier) {
        if (this.verifierInstances == null) {
            this.verifierInstances = new Vector(1, 1);
            this.verifierInstances.addElement(smartVerifier);
        } else if (!this.verifierInstances.contains(smartVerifier)) {
            this.verifierInstances.addElement(smartVerifier);
        }
    }

    public Enumeration getSmartVerifiers() {
        if (this.verifierInstances != null) {
            return this.verifierInstances.elements();
        }
        return null;
    }

    public void setRequired(boolean bl) {
        if (this.constraints != null) {
            this.constraints.setConstraintFlag(0, bl);
            Boolean bl2 = this.constraints.getConstraintFlag(4);
            this.constraints.setConstraintFlag(4, Boolean.FALSE);
            this.verifyImmediately(false);
            this.constraints.setConstraintFlag(4, bl2);
        }
    }

    public boolean getRequired() {
        if (this.constraints == null) {
            return false;
        }
        Boolean bl = this.constraints.getConstraintFlag(0);
        if (bl == null) {
            bl = Boolean.FALSE;
        }
        return bl;
    }

    public void setBeepPolicy(boolean bl) {
        if (this.constraints != null) {
            this.constraints.setConstraintFlag(4, bl);
        }
    }

    public Boolean getBeepPolicy() {
        if (this.constraints != null) {
            return this.constraints.getConstraintFlag(4);
        }
        return new Boolean(AssistManager.getBeepPolicy());
    }

    public void resetBeepPolicy() {
        this.constraints.setConstraintFlag(4, AssistManager.getBeepPolicy());
    }

    public void updateUI() {
        this.setUI((TextUI)UIManager.getUI(this));
        AssistEditorKit.enhanceKeymap(this.getKeymap());
        this.invalidate();
    }

    public void setDocument(Document document) {
        if (this.getDocument() != null) {
            this.getDocument().removeUndoableEditListener(this);
        }
        super.setDocument(document);
        if (document != null) {
            document.addUndoableEditListener(this);
        }
    }

    public void setText(String string) {
        if (SmartManager.getFixPolicy() && this.getText().equals(string)) {
            return;
        }
        if (this.constraints == null) {
            super.setText(string);
        } else {
            Integer n2 = (Integer)this.constraints.getConstraint("Type");
            if (string != null && string.length() > 0 && n2 != null && n2 != 0 && this.constraints.getDefaultValue(n2) == null) {
                this.constraints.setDefaultValue(n2, string);
            }
            Boolean bl = this.constraints.getConstraintFlag(4);
            this.constraints.setConstraintFlag(4, Boolean.FALSE);
            super.setText(string);
            if (!SmartManager.getFixPolicy() && !this.fixing) {
                this.verifyImmediately(false);
            }
            this.constraints.setConstraintFlag(4, bl);
        }
    }

    public void setToDefault() {
        if (this.textTable == null) {
            return;
        }
        Integer n2 = (Integer)this.constraints.getConstraint("Type");
        String string = this.constraints.getDefaultString(n2);
        if (string != null) {
            this.textTable.put(n2, string);
            if (this.isEnabled() || !this.clearDisabled) {
                super.setText(string);
                Boolean bl = this.constraints.getConstraintFlag(4);
                this.constraints.setConstraintFlag(4, Boolean.FALSE);
                if (!SmartManager.getFixPolicy()) {
                    this.verifyImmediately(false);
                }
                this.constraints.setConstraintFlag(4, bl);
            }
        }
    }

    public void setContainingComponent(AssistComponent assistComponent) {
        this.containingComponent = assistComponent;
    }

    public AssistComponent getContainingComponent() {
        return this.containingComponent;
    }

    public AssistArea clone(String string) {
        String string2 = "";
        if (this.constraints != null) {
            string2 = this.constraints.getDefaultString();
        }
        if (string2 == null) {
            string2 = string;
        }
        SmartArea smartArea = new SmartArea();
        smartArea.setFont(this.getFont());
        smartArea.setRows(this.getRows());
        smartArea.setColumns(this.getColumns());
        smartArea.setLineWrap(this.getLineWrap());
        smartArea.setWrapStyleWord(this.getWrapStyleWord());
        smartArea.setConstraints((SmartConstraints)this.constraints.clone());
        Enumeration enumeration = this.verifierInstances.elements();
        while (enumeration.hasMoreElements()) {
            smartArea.addSmartVerifier((SmartVerifier)enumeration.nextElement());
        }
        smartArea.setClearDisabled(this.getClearDisabled());
        smartArea.setBorder(this.getBorder());
        smartArea.setNestedBorders(this.nested);
        smartArea.setContainingComponent(this.containingComponent);
        smartArea.setSmartBordersPolicy(this.smartBordersPolicy);
        smartArea.setText(string);
        if (this.constraints != null && !SmartManager.getFixPolicy()) {
            Boolean bl = this.constraints.getConstraintFlag(4);
            smartArea.getConstraints().setConstraintFlag(4, Boolean.FALSE);
            smartArea.verifyImmediately(false);
            smartArea.getConstraints().setConstraintFlag(4, bl);
        }
        return smartArea;
    }

    public void setTipPosition(int n2) {
        if (this.diagnose != -1) {
            this.diagnose = n2;
        } else {
            this.tipPosition = n2;
        }
    }

    public int getTipPosition() {
        return this.tipPosition;
    }

    public void setShowInitialDiagnosis(boolean bl) {
        if (bl && this.diagnose != -1) {
            this.tipPosition = this.diagnose;
            this.diagnose = -1;
        } else if (!bl) {
            this.diagnose = this.tipPosition;
            this.tipPosition = -1;
        }
    }

    public boolean getShowInitialDiagnosis() {
        return this.diagnose == -1 && this.tipPosition != -1;
    }

    public void setSmartBordersPolicy(boolean bl) {
        this.smartBordersPolicy = bl;
    }

    public boolean getSmartBordersPolicy() {
        return this.smartBordersPolicy;
    }

    public void setBorder() {
        boolean bl;
        char[] cArray = new char[7];
        cArray[0] = 115;
        cArray[1] = 65;
        cArray[4] = 101;
        cArray[3] = 112;
        cArray[6] = 32;
        String string = null;
        if (this.containingComponent != null) {
            this.containingComponent.setBorder();
            if (!this.valueValid) {
                return;
            }
        }
        Border border = null;
        boolean bl2 = bl = !this.isEnabled() || !this.isEditable() ? false : this.hasFocus();
        if (this.nested) {
            cArray[2] = 110;
            if (this.isEnabled() && !this.isValueValid() && AssistManager.getErrorBordersPolicy()) {
                cArray[5] = 101;
                cArray[6] = 116;
                border = AssistManager.getBorder("Assist.nested.error.border");
            } else {
                cArray[5] = bl ? 102 : 118;
                string = String.copyValueOf(cArray);
                border = SmartManager.getBorder("Assist.nested.border", true, bl, string);
            }
        } else {
            cArray[2] = 115;
            if (this.isEnabled() && !this.isValueValid() && AssistManager.getErrorBordersPolicy()) {
                cArray[5] = 101;
                cArray[6] = 107;
                string = String.copyValueOf(cArray);
                border = SmartManager.getBorder("TextField.border", false, string);
            } else {
                cArray[5] = bl ? 102 : 118;
                string = String.copyValueOf(cArray);
                border = SmartManager.getBorder("TextField.border", false, bl, string);
            }
        }
        if (string == null) {
            string = String.copyValueOf(cArray);
        }
        if (border == null && this.getBorder() != null || !string.equals(this.prevBorderType)) {
            this.setBorder(AssistManager.padBorder(this, border, string));
            this.repaint();
        }
    }

    public void setClearDisabled(boolean bl) {
        if (bl != this.clearDisabled && !this.isEditable()) {
            Integer n2 = (Integer)this.constraints.getConstraint("Type");
            if (bl && this.getText().length() > 0) {
                this.textTable.put(n2, this.getText());
                this.setText("");
            }
            if (!bl && this.getText().length() == 0) {
                this.setText((String)this.textTable.get(n2));
            }
        }
        super.setClearDisabled(bl);
    }

    public void setEnabled(boolean bl) {
        if (this.isEnabled() != bl) {
            Integer n2 = (Integer)this.constraints.getConstraint("Type");
            if (bl) {
                if (this.mPopup instanceof EditPopup) {
                    this.undoMgr.enableUndo(((EditPopup)((Object)this.mPopup)).getUndo(), ((EditPopup)((Object)this.mPopup)).getRedo());
                }
                if (this.clearDisabled) {
                    this.setText((String)this.textTable.get(n2));
                }
            } else if (this.clearDisabled) {
                this.textTable.put(n2, this.getText());
            }
        }
        super.setEnabled(bl);
    }

    public void enableValid() {
        Border border = null;
        border = this.hasFocus() && this.smartBordersPolicy ? SmartManager.getBorder("TextField.border", true, true, this.prevBorderType) : AssistManager.getBorder("TextField.border");
        this.setBorder(AssistManager.padBorder(this, border, this.prevBorderType));
        if (this.mPopup != null && this.mPopup instanceof EditPopup) {
            this.undoMgr.enableUndo(((EditPopup)((Object)this.mPopup)).getUndo(), ((EditPopup)((Object)this.mPopup)).getRedo());
            if (((EditPopup)((Object)this.mPopup)).getFix() != null) {
                ((EditPopup)((Object)this.mPopup)).getFix().setEnabled(false);
            }
        }
        this.valueValid = true;
    }

    public void constraintChanged(Object object, Object object2, Object object3) {
        if (object.equals("Type")) {
            int n2 = (Integer)object3;
            this.mPopup = n2 == 0 ? new SmartEditPopup(this, true, false) : new SmartEditPopup(this);
        }
    }

    public void constraintFlagChanged(int n2, boolean bl) {
        if (n2 == 0 && bl != this.required && bl && this.isEditable() && this.getText().length() == 0) {
            this.setText(this.constraints.getDefaultString());
        }
    }

    public void addDiagnosisListener(DiagnosisListener diagnosisListener, Object object) {
        this.removeDiagnosisListener(diagnosisListener);
        this.assistListeners.add(class$com$ibm$db2$tools$common$smartx$event$DiagnosisListener == null ? (class$com$ibm$db2$tools$common$smartx$event$DiagnosisListener = SmartArea.class$("com.ibm.db2.tools.common.smartx.event.DiagnosisListener")) : class$com$ibm$db2$tools$common$smartx$event$DiagnosisListener, diagnosisListener);
        this.diagnosisContexts.put(diagnosisListener, object);
        if (this.diagnosisEvent == null) {
            this.diagnosisEvent = new DiagnosisEvent(this);
        }
        if (this.assistContext == null) {
            this.assistContext = object;
        }
        this.valuePreviouslyValid = this.valueValid;
        diagnosisListener.diagnosisChanged(this.diagnosisEvent);
    }

    public void removeDiagnosisListener(DiagnosisListener diagnosisListener) {
        if (this.diagnosisContexts.get(diagnosisListener) != null) {
            this.diagnosisContexts.remove(diagnosisListener);
            this.assistListeners.remove(class$com$ibm$db2$tools$common$smartx$event$DiagnosisListener == null ? (class$com$ibm$db2$tools$common$smartx$event$DiagnosisListener = SmartArea.class$("com.ibm.db2.tools.common.smartx.event.DiagnosisListener")) : class$com$ibm$db2$tools$common$smartx$event$DiagnosisListener, diagnosisListener);
        }
    }

    public Diagnosis getDiagnosis() {
        if (this.isValueValid()) {
            return null;
        }
        return SmartUtil.getDiagnosis(this);
    }

    public Object getDiagnosisContext(DiagnosisListener diagnosisListener) {
        return this.diagnosisContexts.get(diagnosisListener);
    }

    public void processKeyEvent(KeyEvent keyEvent) {
        if (this.isPopupShowing()) {
            AssistManager.redirectKeyEvent(keyEvent, this.mPopup);
            return;
        }
        int n2 = keyEvent.getID();
        int n3 = keyEvent.getKeyCode();
        JTable jTable = (JTable)SwingUtilities.getAncestorOfClass(class$javax$swing$JTable == null ? (class$javax$swing$JTable = SmartArea.class$("javax.swing.JTable")) : class$javax$swing$JTable, this);
        if (jTable != null) {
            if (n2 == 401 && (n3 == 9 || keyEvent.getKeyChar() == '\t' || n3 == 27)) {
                AssistManager.redirectKeyEvent(keyEvent, jTable);
            } else if (n2 == 402) {
                this.processKeyReleased(keyEvent);
                if (!keyEvent.isConsumed()) {
                    super.processKeyEvent(keyEvent);
                }
            } else {
                super.processKeyEvent(keyEvent);
            }
        } else if ((n3 == 9 || keyEvent.getKeyChar() == '\t') && this.mPopup.isVisible()) {
            keyEvent.consume();
        } else if (n2 == 401 && n3 == 27 && SmartTipManager.sharedInstance().isDiagnosisVisible()) {
            SmartTipManager.sharedInstance().hideDiagnosis();
            keyEvent.consume();
        } else if (n2 == 402) {
            this.processKeyReleased(keyEvent);
            if (!keyEvent.isConsumed()) {
                super.processKeyEvent(keyEvent);
            }
        } else {
            super.processKeyEvent(keyEvent);
        }
    }

    protected void processKeyReleased(KeyEvent keyEvent) {
        boolean bl = true;
        int n2 = keyEvent.getKeyCode();
        switch (n2) {
            case 9: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 25: 
            case 27: 
            case 29: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 122: 
            case 123: 
            case 144: 
            case 145: 
            case 155: 
            case 156: 
            case 157: {
                bl = false;
                break;
            }
            default: {
                int n3 = keyEvent.getModifiers();
                if (n3 == 1 && n2 == 121) {
                    if (!SmartTipManager.sharedInstance().showPopupMenu()) {
                        Rectangle rectangle = this.getBounds();
                        Point point = new Point(rectangle.width / 2, rectangle.height / 2);
                        this.showPopup(this, point, false);
                    }
                    keyEvent.consume();
                    bl = false;
                    break;
                }
                if (n3 == 2 && n2 == 89 || n3 == 9 && n2 == 8) {
                    if (!this.undoMgr.canRedo()) break;
                    this.undoMgr.redo();
                    if (this.mPopup instanceof EditPopup) {
                        this.undoMgr.enableUndo(((EditPopup)((Object)this.mPopup)).getUndo(), ((EditPopup)((Object)this.mPopup)).getRedo());
                    }
                    bl = false;
                    if (SmartManager.getFixPolicy()) break;
                    this.verify();
                    break;
                }
                if (n3 == 2 && n2 == 90 || n3 == 8 && n2 == 8 || n3 == 3 && n2 == 90) {
                    if (!this.undoMgr.canUndo()) break;
                    this.undoMgr.undo();
                    if (this.mPopup instanceof EditPopup) {
                        this.undoMgr.enableUndo(((EditPopup)((Object)this.mPopup)).getUndo(), ((EditPopup)((Object)this.mPopup)).getRedo());
                    }
                    bl = false;
                    if (SmartManager.getFixPolicy()) break;
                    this.verify();
                    break;
                }
                if (n3 == 2 && n2 == 88 || n3 == 1 && n2 == 127) {
                    if (this.prevCaretDot < this.prevCaretMark) {
                        this.prevCaretMark = this.prevCaretDot;
                    } else {
                        this.prevCaretDot = this.prevCaretMark;
                    }
                    this.setCaretColor(Color.black);
                    if (this.mPopup instanceof EditPopup) {
                        this.undoMgr.enableUndo(((EditPopup)((Object)this.mPopup)).getUndo(), ((EditPopup)((Object)this.mPopup)).getRedo());
                    }
                    if (SmartManager.getFixPolicy()) break;
                    this.verify();
                    break;
                }
                if (n3 == 2 && n2 == 67 || n3 == 2 && n2 == 155) {
                    if (!(this.mPopup instanceof EditPopup) || ((EditPopup)((Object)this.mPopup)).getPaste() == null) break;
                    ((EditPopup)((Object)this.mPopup)).getPaste().setEnabled(true);
                    break;
                }
                if (n3 == 2 && n2 == 86 || n3 == 1 && n2 == 155) {
                    this.prevCaretMark = this.prevCaretDot = this.getCaretPosition();
                    this.setCaretColor(Color.black);
                    if (this.mPopup instanceof EditPopup) {
                        this.undoMgr.enableUndo(((EditPopup)((Object)this.mPopup)).getUndo(), ((EditPopup)((Object)this.mPopup)).getRedo());
                    }
                    if (SmartManager.getFixPolicy()) break;
                    this.verify();
                    break;
                }
                if (n3 == 2 && n2 == 68) {
                    if (this.mPopup == null || !(this.mPopup instanceof EditPopup) || ((EditPopup)((Object)this.mPopup)).getDiag() == null || !((EditPopup)((Object)this.mPopup)).getDiag().isEnabled()) break;
                    this.mereDiagnosis = true;
                    int n4 = SmartManager.getDiagnosisPolicy();
                    if (n4 == -1) {
                        SmartManager.setDiagnosisPolicy(0);
                    }
                    this.showDiagnosis(SmartUtil.getDiagnosis(this));
                    if (n4 == -1) {
                        SmartManager.setDiagnosisPolicy(n4);
                    }
                    this.mereDiagnosis = false;
                    bl = false;
                    break;
                }
                if (n3 != 2 || n2 != 70 || !(this.mPopup instanceof EditPopup) || ((EditPopup)((Object)this.mPopup)).getFix() == null) break;
                this.fix();
                bl = false;
            }
        }
        if (bl) {
            this.verifyImmediately(true);
            if (this.mPopup instanceof EditPopup) {
                this.undoMgr.enableUndo(((EditPopup)((Object)this.mPopup)).getUndo(), ((EditPopup)((Object)this.mPopup)).getRedo());
            }
        }
    }

    private int choose(int n2, int n3) {
        return n2 & n3;
    }

    public void verifyImmediately(boolean bl) {
        if (this.verifying) {
            return;
        }
        this.verifying = true;
        boolean bl2 = this.valueValid;
        if (this.isEnabled()) {
            if (this.constraints != null && this.verifierInstances != null) {
                Integer n2 = (Integer)this.constraints.getConstraint("Type");
                if (!this.isEditable() || this.textTable == null) {
                    this.valueValid = true;
                    if (this.valueValid != bl2) {
                        this.fireValidityChanged(null);
                    }
                } else if (n2 == null || n2 == 0) {
                    this.required = this.getConstraints().getRequired();
                    super.verify(bl, true);
                    this.emptyVerify(this.valueValid);
                    if (this.valueValid != bl2) {
                        this.fireValidityChanged(SmartUtil.getDiagnosis(this));
                    }
                } else {
                    this.smartVerify(bl);
                }
            } else {
                this.required = this.getConstraints().getRequired();
                super.verify(bl, true);
                this.emptyVerify(this.valueValid);
                if (this.valueValid != bl2) {
                    this.fireValidityChanged(SmartUtil.getDiagnosis(this));
                }
            }
        } else {
            this.emptyVerify(true);
            if (this.valueValid != bl2) {
                this.fireValidityChanged(null);
            }
        }
        this.setBorder();
        this.verifying = false;
    }

    public void verify() {
        this.verify(false);
    }

    public void verify(boolean bl) {
        Integer n2 = (Integer)this.constraints.getConstraint("Type");
        if (n2 == null) {
            return;
        }
        if (this.verifyTimer == null) {
            this.verifyTimer = new Timer(1, this);
            this.verifyTimer.setInitialDelay(1);
            this.verifyTimer.setRepeats(false);
        }
        this.verifyTimer.setDelay(bl ? 1 : 2);
        this.verifyTimer.restart();
    }

    public void emptyVerify(boolean bl) {
        Diagnosis diagnosis;
        if (this.verifyTimer != null) {
            this.verifyTimer.stop();
        }
        this.valueValid = bl;
        SmartUtil.smartValueRequired(this, bl);
        String string = null;
        if (this.constraints != null) {
            string = (String)this.constraints.getConstraint("TipDescription");
        }
        if (string != null && (diagnosis = SmartUtil.getDiagnosis(this)) != null) {
            diagnosis.setDescription(string);
        }
    }

    public void smartVerify(boolean bl) {
        if (this.verifyTimer != null) {
            this.verifyTimer.stop();
        }
        if (this.constraints == null || this.verifierInstances == null || this.verifierInstances.size() == 0) {
            return;
        }
        if (!this.constraints.getConstraintFlag(3).booleanValue()) {
            bl = false;
        }
        this.constraints.setConstraintFlag(6, bl);
        this.constraints.setConstraintFlag(7, true);
        this.checking = true;
        boolean bl2 = true;
        boolean bl3 = true;
        Enumeration enumeration = this.verifierInstances.elements();
        if (!enumeration.hasMoreElements()) {
            return;
        }
        SmartVerifier smartVerifier = (SmartVerifier)enumeration.nextElement();
        bl3 = smartVerifier.smartVerify(this, this.constraints);
        if (enumeration.hasMoreElements()) {
            this.constraints.setConstraintFlag(7, false);
            while (enumeration.hasMoreElements()) {
                smartVerifier = (SmartVerifier)enumeration.nextElement();
                bl2 = smartVerifier.smartVerify(this, this.constraints);
                boolean bl4 = bl3 = bl3 && bl2;
            }
        }
        JComponent jComponent = (JComponent)this.constraints.getConstraint("Mate");
        if (bl3 && jComponent != null && jComponent instanceof SmartComponent) {
            Enumeration enumeration2 = ((SmartComponent)((Object)jComponent)).getSmartVerifiers();
            SmartConstraints smartConstraints = ((SmartComponent)((Object)jComponent)).getConstraints();
            smartVerifier = (SmartVerifier)enumeration2.nextElement();
            bl2 = smartVerifier.smartVerify(jComponent, smartConstraints);
            if (enumeration2.hasMoreElements()) {
                this.constraints.setConstraintFlag(7, false);
                while (enumeration2.hasMoreElements()) {
                    smartVerifier = (SmartVerifier)enumeration2.nextElement();
                    bl2 = smartVerifier.smartVerify(jComponent, smartConstraints);
                }
            }
            if (bl2) {
                ((SmartComponent)((Object)jComponent)).enableValid();
                ((SmartComponent)((Object)jComponent)).fireValidityChanged(null);
            }
        }
        this.valueValid = bl3;
        if (this.valueValid) {
            this.valueValid = true;
            this.fireValidityChanged(null);
        } else {
            this.fireValidityChanged();
            if (this.mPopup != null && this.mPopup instanceof EditPopup && ((EditPopup)((Object)this.mPopup)).getDiag() != null) {
                ((EditPopup)((Object)this.mPopup)).getDiag().setEnabled(true);
            }
        }
        this.checking = false;
        this.setBorder();
    }

    protected void setValidationState(Diagnosis diagnosis) {
        if (!this.mereDiagnosis && !this.fixing && this.mPopup != null && this.mPopup instanceof EditPopup && ((EditPopup)((Object)this.mPopup)).getFix() != null) {
            if (diagnosis != null) {
                ((EditPopup)((Object)this.mPopup)).getFix().setEnabled(true);
            } else {
                ((EditPopup)((Object)this.mPopup)).getFix().setEnabled(false);
            }
        }
    }

    public void fireValidityChanged() {
        this.delay = SmartManager.getDelayPolicy();
        if (this.delay > 0 && this.diagTimer == null) {
            this.diagTimer = new Timer(this.delay, this);
            this.diagTimer.setInitialDelay(this.delay);
            this.diagTimer.setRepeats(false);
        }
        if (this.delay > 0) {
            this.diagTimer.restart();
        } else {
            this.fireValidityChanged(SmartUtil.getDiagnosis(this));
        }
    }

    public void fireValidityChanged(Diagnosis diagnosis) {
        Object object;
        this.setValidationState(diagnosis);
        if (this.tipPosition > 0 && diagnosis == null) {
            SmartTipManager.sharedInstance().hideDiagnosis();
        }
        if (diagnosis != null && (object = (String)this.constraints.getConstraint("TipDescription")) == null) {
            object = SmartResources.get(217);
        }
        if (((Object[])(object = this.assistListeners.getListenerList())).length > 0) {
            int n2 = ((Object[])object).length - 2;
            while (n2 >= 0) {
                if (object[n2] == (class$com$ibm$db2$tools$common$event$AssistListener == null ? SmartArea.class$("com.ibm.db2.tools.common.event.AssistListener") : class$com$ibm$db2$tools$common$event$AssistListener) && this.valuePreviouslyValid != this.valueValid) {
                    ((AssistListener)object[n2 + 1]).validityChanged(this.assistEvent);
                } else if (object[n2] == (class$com$ibm$db2$tools$common$smartx$event$DiagnosisListener == null ? SmartArea.class$("com.ibm.db2.tools.common.smartx.event.DiagnosisListener") : class$com$ibm$db2$tools$common$smartx$event$DiagnosisListener) && diagnosis != null && !diagnosis.equals(this.previousDiagnosis)) {
                    ((DiagnosisListener)object[n2 + 1]).diagnosisChanged(this.diagnosisEvent);
                } else if (object[n2] == (class$com$ibm$db2$tools$common$smartx$event$DiagnosisListener == null ? SmartArea.class$("com.ibm.db2.tools.common.smartx.event.DiagnosisListener") : class$com$ibm$db2$tools$common$smartx$event$DiagnosisListener) && diagnosis == null && this.valuePreviouslyValid != this.valueValid) {
                    ((DiagnosisListener)object[n2 + 1]).diagnosisChanged(this.diagnosisEvent);
                }
                n2 -= 2;
            }
        }
        if (diagnosis != null) {
            this.showDiagnosis(diagnosis);
        }
        this.valuePreviouslyValid = this.valueValid;
        this.previousDiagnosis = diagnosis;
    }

    protected void showDiagnosis(Diagnosis diagnosis) {
        if (this.tipPosition > 0 && diagnosis != null) {
            String string = (String)this.constraints.getConstraint("TipDescription");
            diagnosis.setDescription(string);
            SmartTipManager.sharedInstance().showDiagnosis(this, this.tipPosition, diagnosis);
        }
    }

    public void fix() {
        Boolean bl = this.constraints.getConstraintFlag(4);
        this.constraints.setConstraintFlag(4, Boolean.FALSE);
        if (this.mPopup instanceof EditPopup && ((EditPopup)((Object)this.mPopup)).getFix() != null) {
            ((EditPopup)((Object)this.mPopup)).getFix().setEnabled(false);
        }
        this.constraints.setConstraintFlag(5, true);
        this.fixing = true;
        this.verifyImmediately(false);
        this.fixing = false;
        this.constraints.setConstraintFlag(5, false);
        this.constraints.setConstraintFlag(4, bl);
    }

    public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
        if (this.checking) {
            if (!this.changing) {
                this.undoMgr.addEdit(undoableEditEvent.getEdit());
                this.changing = true;
            } else if (this.foreDoc != null) {
                if (this.foreDoc.equals(this.getText())) {
                    this.undoMgr.combine4(undoableEditEvent.getEdit());
                } else {
                    this.undoMgr.combine3(undoableEditEvent.getEdit());
                }
                this.changing = false;
            }
        } else {
            if (this.prevDoc.equals("")) {
                this.undoMgr.combine1(undoableEditEvent.getEdit());
            } else {
                this.undoMgr.addEdit(undoableEditEvent.getEdit());
            }
            this.foreDoc = this.prevDoc;
            this.prevDoc = this.getText();
        }
        if (this.isShowing()) {
            this.setShowInitialDiagnosis(true);
        }
    }

    public void caretUpdate(CaretEvent caretEvent) {
        if (this.button3Up) {
            this.prevCaretDot = caretEvent.getDot();
            this.prevCaretMark = caretEvent.getMark();
        }
        if (this.prevCaretDot == this.prevCaretMark) {
            this.setCaretColor(Color.black);
        } else {
            this.setCaretColor(this.getBackground());
            if (this.hasFocus()) {
                this.getCaret().setVisible(true);
            }
        }
    }

    protected void restoreCaret() {
        if (this.prevCaretMark != this.getCaret().getMark() || this.prevCaretDot != this.getCaret().getDot()) {
            this.button3Up = false;
            this.getCaret().setDot(this.prevCaretMark);
            this.getCaret().moveDot(this.prevCaretDot);
            this.button3Up = true;
        }
        if (this.prevCaretDot == this.prevCaretMark) {
            this.setCaretColor(Color.black);
        } else {
            this.setCaretColor(this.getBackground());
            if (this.hasFocus()) {
                this.getCaret().setVisible(true);
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.allowPopup = false;
        Object object = actionEvent.getSource();
        if (object == this.diagTimer) {
            Diagnosis diagnosis = SmartUtil.getDiagnosis(this);
            if (diagnosis != null) {
                this.fireValidityChanged(diagnosis);
            }
        } else if (object == this.verifyTimer) {
            this.verifyImmediately(this.verifyTimer.getDelay() == 1);
        } else {
            super.actionPerformed(actionEvent);
        }
        if (this.mPopup != null && this.mPopup instanceof EditPopup) {
            if (object == ((EditPopup)((Object)this.mPopup)).getUndo()) {
                this.undoMgr.undo();
                this.undoMgr.enableUndo(((EditPopup)((Object)this.mPopup)).getUndo(), ((EditPopup)((Object)this.mPopup)).getRedo());
                if (!SmartManager.getFixPolicy()) {
                    this.verify();
                }
            } else if (object == ((EditPopup)((Object)this.mPopup)).getRedo()) {
                this.undoMgr.redo();
                this.undoMgr.enableUndo(((EditPopup)((Object)this.mPopup)).getUndo(), ((EditPopup)((Object)this.mPopup)).getRedo());
                if (!SmartManager.getFixPolicy()) {
                    this.verify();
                }
            } else if (object == ((EditPopup)((Object)this.mPopup)).getCut()) {
                this.restoreCaret();
                this.cut();
                if (this.prevCaretDot < this.prevCaretMark) {
                    this.prevCaretMark = this.prevCaretDot;
                } else {
                    this.prevCaretDot = this.prevCaretMark;
                }
                this.setCaretColor(Color.black);
                this.undoMgr.enableUndo(((EditPopup)((Object)this.mPopup)).getUndo(), ((EditPopup)((Object)this.mPopup)).getRedo());
                if (!SmartManager.getFixPolicy()) {
                    this.verify();
                }
            } else if (object == ((EditPopup)((Object)this.mPopup)).getCopy()) {
                this.restoreCaret();
                this.copy();
            } else if (object == ((EditPopup)((Object)this.mPopup)).getPaste() && AssistEditorKit.canPaste(this)) {
                this.restoreCaret();
                this.paste();
                this.prevCaretMark = this.prevCaretDot = this.getCaretPosition();
                this.setCaretColor(Color.black);
                this.undoMgr.enableUndo(((EditPopup)((Object)this.mPopup)).getUndo(), ((EditPopup)((Object)this.mPopup)).getRedo());
                if (!SmartManager.getFixPolicy()) {
                    this.verify();
                }
            } else if (object == ((EditPopup)((Object)this.mPopup)).getDiag()) {
                this.mereDiagnosis = true;
                int n2 = SmartManager.getDiagnosisPolicy();
                if (n2 == -1) {
                    SmartManager.setDiagnosisPolicy(0);
                }
                this.showDiagnosis(SmartUtil.getDiagnosis(this));
                if (n2 == -1) {
                    SmartManager.setDiagnosisPolicy(n2);
                }
                this.mereDiagnosis = false;
            } else if (object == ((EditPopup)((Object)this.mPopup)).getFix()) {
                this.fix();
            }
        }
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        int n2 = mouseEvent.getID();
        switch (n2) {
            case 501: 
            case 502: {
                if (mouseEvent.isPopupTrigger()) {
                    this.button3Up = false;
                    this.restoreCaret();
                    this.showPopup(this, mouseEvent.getPoint(), false);
                    mouseEvent.consume();
                    break;
                }
                this.button3Up = true;
                break;
            }
        }
        if (!mouseEvent.isConsumed()) {
            super.processMouseEvent(mouseEvent);
        }
    }

    public void showPopup(Component component, Point point) {
        this.showPopup(component, point, true);
    }

    public void showPopup(Component component, Point point, boolean bl) {
        int n2;
        Object object;
        SmartTable smartTable = (SmartTable)SwingUtilities.getAncestorOfClass(class$com$ibm$db2$tools$common$smartx$SmartTable == null ? (class$com$ibm$db2$tools$common$smartx$SmartTable = SmartArea.class$("com.ibm.db2.tools.common.smartx.SmartTable")) : class$com$ibm$db2$tools$common$smartx$SmartTable, this);
        if (smartTable != null && (object = smartTable.getTableEditorActions()) != null) {
            if (!this.mPopup.isAncestorOf((Component)((Object)object[0]))) {
                this.mPopup.addSeparator();
                n2 = 0;
                while (n2 < ((MenuElement[])object).length) {
                    this.mPopup.add((JMenuItem)object[n2]);
                    ++n2;
                }
            }
            smartTable.configureTableEditorActions();
        }
        if (component != this) {
            point = SwingUtilities.convertPoint(component, point, this);
        }
        if (this.mPopup instanceof EditPopup) {
            if (((EditPopup)((Object)this.mPopup)).getDiag() != null) {
                ((EditPopup)((Object)this.mPopup)).enableDiag(bl);
            }
            ((EditPopup)((Object)this.mPopup)).showPopup(this, point);
            if (this.prevCaretDot == this.prevCaretMark) {
                if (((EditPopup)((Object)this.mPopup)).getCut() != null) {
                    ((EditPopup)((Object)this.mPopup)).getCut().setEnabled(false);
                }
                if (((EditPopup)((Object)this.mPopup)).getCopy() != null) {
                    ((EditPopup)((Object)this.mPopup)).getCopy().setEnabled(false);
                }
            } else {
                if (this.isEditable()) {
                    if (((EditPopup)((Object)this.mPopup)).getCut() != null) {
                        ((EditPopup)((Object)this.mPopup)).getCut().setEnabled(true);
                    }
                } else if (((EditPopup)((Object)this.mPopup)).getCut() != null) {
                    ((EditPopup)((Object)this.mPopup)).getCut().setEnabled(false);
                }
                if (((EditPopup)((Object)this.mPopup)).getCopy() != null) {
                    ((EditPopup)((Object)this.mPopup)).getCopy().setEnabled(true);
                }
            }
        } else {
            object = this.getBounds();
            n2 = object.x + object.width / 2;
            int n3 = object.y + object.height / 2;
            this.mPopup.show(this, n2, n3);
        }
        this.allowPopup = true;
    }

    public void hidePopup() {
        if (this.mPopup.isVisible()) {
            this.mPopup.setVisible(false);
            this.allowPopup = false;
        }
    }

    public boolean isPopupShowing() {
        return this.mPopup != null && this.mPopup.isVisible();
    }

    public void setPopup(JPopupMenu jPopupMenu) {
        this.mPopup = jPopupMenu;
    }

    public JPopupMenu getPopup() {
        return this.mPopup;
    }

    public boolean allowLink() {
        return this.allowLink;
    }

    public boolean allowPopup() {
        return this.allowPopup;
    }

    public void setAllowPopup(boolean bl) {
        this.allowPopup = bl;
    }

    public void setAllowLink(boolean bl) {
        this.allowLink = bl;
    }

    protected void processFocusEvent(FocusEvent focusEvent) {
        this.button3Up = false;
        super.processFocusEvent(focusEvent);
        this.button3Up = true;
        switch (focusEvent.getID()) {
            case 1004: {
                if (this.isEnabled() && this.isValueValid() && this.smartBordersPolicy) {
                    this.setBorder();
                    this.repaint();
                }
                this.restoreCaret();
                break;
            }
            case 1005: {
                if (focusEvent.isTemporary()) break;
                if (this.allowPopup) {
                    this.requestFocus();
                } else {
                    SmartTable smartTable = (SmartTable)SwingUtilities.getAncestorOfClass(class$com$ibm$db2$tools$common$smartx$SmartTable == null ? (class$com$ibm$db2$tools$common$smartx$SmartTable = SmartArea.class$("com.ibm.db2.tools.common.smartx.SmartTable")) : class$com$ibm$db2$tools$common$smartx$SmartTable, this);
                    if (smartTable == null) {
                        this.verifyImmediately(false);
                        this.setBorder();
                        this.repaint();
                    }
                }
                if (System.getProperty("os.name").startsWith("Windows")) {
                    if (this.prevCaretDot < this.prevCaretMark) {
                        this.prevCaretMark = this.prevCaretDot;
                    } else {
                        this.prevCaretDot = this.prevCaretMark;
                    }
                }
                this.setCaretColor(Color.black);
            }
        }
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleSmartArea();
        }
        return this.accessibleContext;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected class AccessibleSmartArea
    extends JTextArea.AccessibleJTextArea {
        private static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

        public AccessibleSmartArea() {
            super(SmartArea.this);
        }

        public int getAccessibleChildrenCount() {
            return super.getAccessibleChildrenCount() + 1;
        }

        public Accessible getAccessibleChild(int n2) {
            Accessible accessible = super.getAccessibleChild(n2);
            if (accessible == null && n2 < this.getAccessibleChildrenCount()) {
                return SmartArea.this.mPopup;
            }
            return null;
        }
    }
}

