/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common.smartguide;

import com.ibm.db2.tools.common.smartguide.SmartGuide;
import com.ibm.db2.tools.common.support.AssistComponent;
import java.awt.Component;
import java.awt.Container;
import java.util.Vector;
import javax.swing.Icon;

public class SmartGuidePage {
    protected Vector assistFieldVector;
    protected boolean pageContainsMandatory = false;
    private boolean customMandatoryHandling = false;
    private SmartGuide guide = null;
    private Icon icon = null;
    private boolean iconMode = false;
    private String title = "";
    private String shortTitle = "";
    private String description = "";
    private Component client = null;
    private boolean navVisible = true;
    private int pageId = 0;
    private static int pageCnt = 0;
    private Object uidata = null;
    private boolean complete = true;
    private boolean added = false;

    public SmartGuidePage(SmartGuide smartGuide) {
        this.guide = smartGuide;
    }

    public SmartGuide getSmartGuide() {
        return this.guide;
    }

    public void buildAssistFieldVector() {
        if (this.getClient() == null) {
            return;
        }
        if (this.assistFieldVector != null) {
            this.assistFieldVector.removeAllElements();
        } else {
            this.assistFieldVector = new Vector();
        }
        this.buildAssistFieldVector((Container)this.getClient());
        this.guide.fireStateChanged();
    }

    protected void buildAssistFieldVector(Container container) {
        if (container instanceof AssistComponent) {
            this.assistFieldVector.add(container);
            ((AssistComponent)((Object)container)).addAssistListener(this.guide);
        } else {
            Component[] componentArray = container.getComponents();
            int n2 = 0;
            while (n2 < componentArray.length) {
                if (componentArray[n2] instanceof Container && componentArray[n2].isVisible()) {
                    this.buildAssistFieldVector((Container)componentArray[n2]);
                }
                ++n2;
            }
        }
        if (this.assistFieldVector.size() > 0) {
            this.pageContainsMandatory = true;
        }
    }

    public boolean hasEmptyMandatoryField() {
        boolean bl = false;
        int n2 = 0;
        while (n2 < this.assistFieldVector.size()) {
            AssistComponent assistComponent = (AssistComponent)this.assistFieldVector.get(n2);
            bl = !assistComponent.isValueValid();
            if (bl) break;
            ++n2;
        }
        return bl;
    }

    public void setCustomMandatoryHandling(boolean bl) {
        this.customMandatoryHandling = bl;
    }

    public boolean getCustomMandatoryHandling() {
        return this.customMandatoryHandling;
    }

    public void pageSelected() {
    }

    public void changePanels() {
    }

    public boolean canTurnTo(SmartGuidePage smartGuidePage) {
        return true;
    }

    public void pageExited() {
    }

    void setSelected() {
        this.pageSelected();
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public String getTitle() {
        return this.title;
    }

    public void setShortTitle(String string) {
        this.shortTitle = string;
    }

    public String getShortTitle() {
        if (this.shortTitle != null && this.shortTitle.length() > 0) {
            return this.shortTitle;
        }
        return this.title;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public String getDescription() {
        return this.description;
    }

    public void setClient(Component component) {
        this.client = component;
    }

    public Component getClient() {
        return this.client;
    }

    public void setIconMode(boolean bl) {
        this.iconMode = bl;
    }

    public boolean getIconMode() {
        return this.iconMode;
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public boolean isAdded() {
        return this.added;
    }

    void setAdded(boolean bl) {
        this.added = bl;
    }

    public boolean isComplete() {
        return true;
    }

    public final void setPageComplete(boolean bl) {
        if (this.complete != bl) {
            this.complete = bl;
            this.guide.fireStateChanged();
        }
    }

    public final boolean isPageComplete() {
        if (this.pageContainsMandatory && !this.customMandatoryHandling) {
            this.complete = !this.hasEmptyMandatoryField();
        }
        return this.complete;
    }

    public void displayHelp() {
    }

    public String toString() {
        return this.getShortTitle();
    }

    public void setPageContainsMandatory(boolean bl) {
        this.pageContainsMandatory = bl;
    }
}

