/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common.smartguide;

import com.ibm.db2.tools.common.AppearanceManager;
import com.ibm.db2.tools.common.ArrowImageIconFactory;
import com.ibm.db2.tools.common.CmStringPool;
import com.ibm.db2.tools.common.GradientMenuBar;
import com.ibm.db2.tools.common.MultiLineEvent;
import com.ibm.db2.tools.common.MultiLineLabel;
import com.ibm.db2.tools.common.MultiLineListener;
import com.ibm.db2.tools.common.VariableGridLayout;
import com.ibm.db2.tools.common.event.AssistEvent;
import com.ibm.db2.tools.common.event.AssistListener;
import com.ibm.db2.tools.common.smartguide.CustomToggleButton;
import com.ibm.db2.tools.common.smartguide.HidingButton;
import com.ibm.db2.tools.common.smartguide.SmartGuideManager;
import com.ibm.db2.tools.common.smartguide.SmartGuidePage;
import com.ibm.db2.tools.common.support.AssistManager;
import com.ibm.db2.tools.common.support.CellExpanderManager;
import com.ibm.db2.tools.common.uamanager.UAMCustomizerWindowAdapter;
import com.ibm.db2.tools.common.uamanager.UAManager;
import com.ibm.db2.tools.common.uamanager.UAWindowAdapter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Stack;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultFocusManager;
import javax.swing.FocusManager;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.border.EtchedBorder;

public class SmartGuide
extends JDialog
implements MultiLineListener,
ActionListener,
WindowListener,
AssistListener {
    protected JList sgPageList = null;
    protected JButton backButton = null;
    protected JButton nextButton = null;
    protected JButton doneButton = null;
    protected JButton cancelButton = null;
    protected Frame parentFrame = null;
    protected MultiLineLabel sgPageTitle = null;
    protected MultiLineLabel sgPageDescription = null;
    protected JPanel sgTitleDescriptionPanel = null;
    protected JPanel sgPageClient = null;
    protected JPanel sgPagePanel = null;
    protected JLabel sgPagePicture;
    protected JPanel rightPanel = null;
    protected JPanel leftPanel = null;
    protected boolean horizontal = true;
    protected JComponent jsp = null;
    protected JScrollPane tocScroller = null;
    protected JPanel buttonListPanel = new JPanel(new GridLayout(0, 1, 1, 1));
    protected ButtonGroup buttonGroup = new ButtonGroup();
    protected final JPanel moveUpPanel = new JPanel(new BorderLayout());
    protected final JSplitPane splitPane = new JSplitPane(1);
    protected JPanel panel = null;
    protected JPanel splitPanel = null;
    protected JPanel mainPanel = null;
    protected JPanel buttonPanel = null;
    protected SmartGuidePage currentPage = null;
    protected DefaultFocusManager focusMan = null;
    protected int maxTOCWidth = 85;
    protected boolean enableMandatoryChecking = false;
    private UAWindowAdapter uaManagerListener = null;
    protected SmartGuidePage pageToExit;
    protected boolean callFromFirst = false;
    protected boolean returnToPageFromError = false;
    protected boolean overrideButtons = false;
    public static final String BACK_BUTTON_TEXT = "BackButtonText";
    public static final String BACK_BUTTON_MNEMONIC = "BackButtonM";
    public static final String BACK_BUTTON_NAME_PROP = "BackButtonName";
    public static final String NEXT_BUTTON_TEXT = "NextButtonText";
    public static final String NEXT_BUTTON_MNEMONIC = "NextButtonM";
    public static final String NEXT_BUTTON_NAME_PROP = "NextButtonName";
    public static final String FINISH_BUTTON_TEXT = "FinishButtonText";
    public static final String FINISH_BUTTON_MNEMONIC = "FinishButtonM";
    public static final String FINISH_BUTTON_NAME_PROP = "FinishButtonName";
    public static final String CANCEL_BUTTON_TEXT = "CancelButtonText";
    public static final String CANCEL_BUTTON_NAME_PROP = "CancelButtonName";
    private static final int DEFAULT_HEIGHT = 600;
    private static final int DEFAULT_WIDTH = 800;

    public SmartGuide(Frame frame) {
        this(frame, "");
    }

    public SmartGuide(Frame frame, String string) {
        this(frame, string, true);
    }

    public SmartGuide(Frame frame, String string, boolean bl) {
        this(frame, string, bl, false);
    }

    public SmartGuide(Frame frame, String string, boolean bl, boolean bl2) {
        super(frame, string, bl);
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.parentFrame = frame;
        this.setUAWindowAdapter(new UAMCustomizerWindowAdapter(this.getUAMToken()));
        this.addWindowListener(this);
        this.sgPageTitle = new MultiLineLabel("");
        AppearanceManager.updateFont(this.sgPageTitle);
        if (!Locale.TAIWAN.equals(AssistManager.getPreferredLanguage())) {
            this.sgPageTitle.setFont(AppearanceManager.getLanguageDependentDefaultFont(new Font(this.sgPageTitle.getFont().getName(), 1, (int)((double)this.sgPageTitle.getFont().getSize() * 1.5))));
        }
        this.sgPageDescription = new MultiLineLabel("");
        AppearanceManager.updateFont(this.sgPageDescription);
        this.sgTitleDescriptionPanel = new JPanel(new VariableGridLayout(2, 1, 5, 5));
        this.sgTitleDescriptionPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
        this.jsp = this.getMainContainer(null);
        this.jsp.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.sgPagePicture = new JLabel();
        this.buttonListPanel.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.sgPagePanel = new JPanel(new BorderLayout());
        this.sgPagePanel.add((Component)this.sgTitleDescriptionPanel, "North");
        this.sgPagePanel.add((Component)this.jsp, "Center");
        this.sgPagePanel.add((Component)this.sgPagePicture, "East");
        if (this.scrollTOCPanel()) {
            this.tocScroller = new JScrollPane(this.buttonListPanel, 20, 30);
            this.moveUpPanel.add((Component)this.tocScroller, "North");
        } else {
            this.moveUpPanel.add((Component)this.buttonListPanel, "North");
        }
        this.leftPanel = new JPanel(new BorderLayout());
        this.leftPanel.add((Component)this.moveUpPanel, "Center");
        this.splitPane.setDividerSize(2);
        this.splitPane.setLeftComponent(this.leftPanel);
        this.splitPane.setRightComponent(this.sgPagePanel);
        this.splitPanel = new JPanel(new BorderLayout());
        this.splitPanel.add((Component)new GradientBar(), "North");
        this.splitPanel.add((Component)this.splitPane, "Center");
        this.splitPanel.setBorder(new EtchedBorder());
        this.backButton = new HidingButton();
        this.backButton.setIcon(ArrowImageIconFactory.getArrowImageIcon(this.backButton, 270));
        this.nextButton = new HidingButton();
        this.nextButton.setIcon(ArrowImageIconFactory.getArrowImageIcon(this.nextButton, 90));
        SmartGuideManager smartGuideManager = SmartGuideManager.getManager();
        this.backButton.setText((String)smartGuideManager.getProperty(BACK_BUTTON_TEXT));
        this.backButton.setName((String)smartGuideManager.getProperty(BACK_BUTTON_NAME_PROP));
        this.backButton.setMnemonic((Integer)smartGuideManager.getProperty(BACK_BUTTON_MNEMONIC));
        this.backButton.setVerticalTextPosition(0);
        this.backButton.setHorizontalTextPosition(4);
        this.backButton.addActionListener(this);
        this.nextButton.setText((String)smartGuideManager.getProperty(NEXT_BUTTON_TEXT));
        this.nextButton.setName((String)smartGuideManager.getProperty(NEXT_BUTTON_NAME_PROP));
        this.nextButton.setMnemonic((Integer)smartGuideManager.getProperty(NEXT_BUTTON_MNEMONIC));
        this.nextButton.setVerticalTextPosition(0);
        this.nextButton.setHorizontalTextPosition(2);
        this.nextButton.addActionListener(this);
        this.doneButton = new HidingButton((String)smartGuideManager.getProperty(FINISH_BUTTON_TEXT));
        this.doneButton.setName((String)smartGuideManager.getProperty(FINISH_BUTTON_NAME_PROP));
        this.doneButton.setMnemonic((Integer)smartGuideManager.getProperty(FINISH_BUTTON_MNEMONIC));
        this.doneButton.setVerticalTextPosition(0);
        this.doneButton.setEnabled(false);
        this.doneButton.addActionListener(this);
        this.cancelButton = new JButton((String)smartGuideManager.getProperty(CANCEL_BUTTON_TEXT));
        this.cancelButton.setName((String)smartGuideManager.getProperty(CANCEL_BUTTON_NAME_PROP));
        this.cancelButton.setVerticalTextPosition(0);
        this.cancelButton.addActionListener(this);
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new BoxLayout(this.buttonPanel, 0));
        this.buttonPanel.setBorder(BorderFactory.createEmptyBorder(5, 2, 2, 2));
        this.buttonPanel.add(Box.createHorizontalGlue());
        this.buttonPanel.add(this.backButton);
        this.buttonPanel.add(Box.createRigidArea(new Dimension(10, 0)));
        this.buttonPanel.add(this.nextButton);
        this.buttonPanel.add(Box.createRigidArea(new Dimension(10, 0)));
        this.buttonPanel.add(this.doneButton);
        this.buttonPanel.add(Box.createRigidArea(new Dimension(10, 0)));
        this.buttonPanel.add(this.cancelButton);
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new BorderLayout());
        this.mainPanel.add((Component)this.splitPanel, "Center");
        this.mainPanel.add((Component)this.buttonPanel, "South");
        this.getContentPane().add(this.mainPanel);
        this.setUAKeys();
        this.focusMan = (DefaultFocusManager)FocusManager.getCurrentManager();
        if (this.scrollTOCPanel()) {
            this.tocScroller.setPreferredSize(new Dimension(this.getPreferredTOCWidth(), 505));
        }
    }

    protected boolean scrollTOCPanel() {
        return false;
    }

    public int getMaxTOCWidth() {
        return this.maxTOCWidth;
    }

    public void setMaxTOCWidth(int n2) {
        this.maxTOCWidth = n2;
    }

    public int getPreferredTOCWidth() {
        Dimension dimension = this.buttonListPanel.getPreferredSize();
        return dimension.width + 10;
    }

    protected JComponent getMainContainer(Component component) {
        if (this.jsp == null) {
            this.jsp = new JScrollPane();
        }
        if (component != null) {
            ((JScrollPane)this.jsp).setViewportView(component);
        }
        return this.jsp;
    }

    protected JPanel getButtonPanel() {
        return this.buttonPanel;
    }

    public void linkStateChanged(MultiLineEvent multiLineEvent) {
    }

    public void addHyperlinkListener(MultiLineListener multiLineListener) {
        this.sgPageDescription.addMultiLineListener(multiLineListener);
    }

    public void removeHyperlinkListener(MultiLineListener multiLineListener) {
        this.sgPageDescription.removeMultiLineListener(multiLineListener);
    }

    public void showCentered() {
        Dimension dimension = this.getSize();
        Dimension dimension2 = this.getToolkit().getScreenSize();
        this.adjustSize(dimension, dimension2);
        this.selectFirstPage();
        Point point = null;
        if (this.parentFrame != null) {
            dimension = this.parentFrame.getSize();
            point = this.parentFrame.getLocation();
        } else {
            point = new Point(0, 0);
            dimension = dimension2;
        }
        Dimension dimension3 = this.getSize();
        int n2 = point.x + dimension.width / 2;
        int n3 = point.y + dimension.height / 2;
        int n4 = n2 - dimension3.width / 2;
        int n5 = n3 - dimension3.height / 2;
        n4 = this.limitCoordinate(n4, 0, dimension2.width - dimension3.width);
        n5 = this.limitCoordinate(n5, 0, dimension2.height - dimension3.height);
        super.setLocation(n4, n5);
        super.setCursor(Cursor.getDefaultCursor());
        ((Component)this).setVisible(true);
        this.selectFirstPage();
    }

    protected void adjustSize(Dimension dimension, Dimension dimension2) {
        dimension.width = Math.max(dimension.width, 800);
        dimension.height = Math.max(dimension.height, 600);
        dimension.width = Math.min(dimension.width, dimension2.width);
        dimension.height = Math.min(dimension.height, dimension2.height);
        super.setSize(dimension);
    }

    int limitCoordinate(int n2, int n3, int n4) {
        return n2 < n3 ? n3 : (n2 > n4 ? n4 : n2);
    }

    public void addPage(SmartGuidePage smartGuidePage) {
        CustomToggleButton customToggleButton = new CustomToggleButton(smartGuidePage);
        customToggleButton.setFocusPainted(false);
        customToggleButton.setHorizontalAlignment(2);
        this.buttonGroup.add(customToggleButton);
        customToggleButton.setName("BUTTON" + this.buttonGroup.getButtonCount());
        this.buttonListPanel.add(customToggleButton);
        customToggleButton.addActionListener(this);
        this.setButtonNumbers();
        if (this.enableMandatoryChecking) {
            smartGuidePage.buildAssistFieldVector();
        }
        this.fireStateChanged();
    }

    protected void setButtonNumbers() {
        int n2 = 0;
        Enumeration<AbstractButton> enumeration = this.buttonGroup.getElements();
        while (enumeration.hasMoreElements()) {
            CustomToggleButton customToggleButton = (CustomToggleButton)enumeration.nextElement();
            customToggleButton.setButtonNumber(++n2);
        }
    }

    public boolean removePage(SmartGuidePage smartGuidePage) {
        boolean bl = false;
        Enumeration<AbstractButton> enumeration = this.buttonGroup.getElements();
        while (enumeration.hasMoreElements()) {
            CustomToggleButton customToggleButton = (CustomToggleButton)enumeration.nextElement();
            if (customToggleButton.getSmartGuidePage() != smartGuidePage) continue;
            this.buttonGroup.remove(customToggleButton);
            this.buttonListPanel.remove(customToggleButton);
            CellExpanderManager.sharedInstance().unregisterComponent(customToggleButton);
            this.moveUpPanel.revalidate();
            bl = true;
            break;
        }
        this.setButtonNumbers();
        this.fireStateChanged();
        return bl;
    }

    public void setEnableMandatoryChecking(boolean bl) {
        this.enableMandatoryChecking = bl;
    }

    public boolean getEnableMandatoryChecking() {
        return this.enableMandatoryChecking;
    }

    public void validityChanged(AssistEvent assistEvent) {
        this.fireStateChanged();
    }

    public boolean insertPageAfter(SmartGuidePage smartGuidePage, SmartGuidePage smartGuidePage2) {
        boolean bl = false;
        boolean bl2 = false;
        CustomToggleButton customToggleButton = null;
        SmartGuidePage smartGuidePage3 = null;
        Vector<SmartGuidePage> vector = new Vector<SmartGuidePage>();
        Vector<SmartGuidePage> vector2 = new Vector<SmartGuidePage>();
        Enumeration<AbstractButton> enumeration = this.buttonGroup.getElements();
        while (enumeration.hasMoreElements()) {
            customToggleButton = (CustomToggleButton)enumeration.nextElement();
            if (!bl) {
                smartGuidePage3 = customToggleButton.getSmartGuidePage();
                if (!smartGuidePage3.equals(smartGuidePage2)) continue;
                bl = true;
                continue;
            }
            smartGuidePage3 = customToggleButton.getSmartGuidePage();
            vector2.addElement(smartGuidePage3);
            vector.addElement(smartGuidePage3);
        }
        while (!vector2.isEmpty()) {
            this.removePage((SmartGuidePage)vector2.firstElement());
            vector2.removeElementAt(0);
        }
        this.addPage(smartGuidePage);
        while (!vector.isEmpty()) {
            this.addPage((SmartGuidePage)vector.firstElement());
            vector.removeElementAt(0);
        }
        return bl;
    }

    public boolean replacePageWith(SmartGuidePage smartGuidePage, SmartGuidePage smartGuidePage2) {
        boolean bl = false;
        Enumeration<AbstractButton> enumeration = this.buttonGroup.getElements();
        while (enumeration.hasMoreElements()) {
            CustomToggleButton customToggleButton = (CustomToggleButton)enumeration.nextElement();
            SmartGuidePage smartGuidePage3 = customToggleButton.getSmartGuidePage();
            if (!smartGuidePage3.equals(smartGuidePage2)) continue;
            bl = true;
            this.insertPageAfter(smartGuidePage, smartGuidePage3);
            this.removePage(smartGuidePage3);
        }
        return bl;
    }

    public void removeAllPages() {
        SmartGuidePage smartGuidePage;
        Vector<SmartGuidePage> vector = new Vector<SmartGuidePage>();
        Enumeration<AbstractButton> enumeration = this.buttonGroup.getElements();
        while (enumeration.hasMoreElements()) {
            CustomToggleButton customToggleButton = (CustomToggleButton)enumeration.nextElement();
            smartGuidePage = customToggleButton.getSmartGuidePage();
            vector.add(smartGuidePage);
        }
        int n2 = 0;
        while (n2 < vector.size()) {
            smartGuidePage = (SmartGuidePage)vector.get(n2);
            this.removePage(smartGuidePage);
            ++n2;
        }
    }

    protected void selectFirstPage() {
        Enumeration<AbstractButton> enumeration = this.buttonGroup.getElements();
        if (enumeration.hasMoreElements()) {
            CustomToggleButton customToggleButton = (CustomToggleButton)enumeration.nextElement();
            this.callFromFirst = true;
            this.turnToPage(customToggleButton.getSmartGuidePage());
            this.callFromFirst = false;
            this.pageToExit = customToggleButton.getSmartGuidePage();
        }
    }

    public void turnToPage(final SmartGuidePage smartGuidePage) {
        Enumeration<AbstractButton> enumeration = this.buttonGroup.getElements();
        while (enumeration.hasMoreElements()) {
            Object object;
            CustomToggleButton customToggleButton = (CustomToggleButton)enumeration.nextElement();
            if (customToggleButton.getSmartGuidePage() != smartGuidePage) continue;
            if (this.callFromFirst ? true : this.pageToExit != null && this.pageToExit.canTurnTo(smartGuidePage)) {
                if (!this.callFromFirst && !this.returnToPageFromError) {
                    this.pageToExit.pageExited();
                }
                this.returnToPageFromError = false;
                smartGuidePage.changePanels();
                this.sgTitleDescriptionPanel.removeAll();
                this.sgPageTitle.setText(smartGuidePage.getTitle());
                this.sgPageDescription.setText(smartGuidePage.getDescription());
                this.sgTitleDescriptionPanel.add(this.sgPageTitle);
                this.sgTitleDescriptionPanel.add(this.sgPageDescription);
                object = smartGuidePage.getIcon();
                if (smartGuidePage.getIconMode()) {
                    this.sgPagePicture.setIcon((Icon)object);
                } else {
                    this.sgPagePicture.setIcon(null);
                }
                customToggleButton.setSelected(true);
                this.currentPage = customToggleButton.getSmartGuidePage();
                this.getMainContainer(smartGuidePage.getClient());
                AppearanceManager.updateFont(this.jsp);
                this.revalidateAndRepaint();
                smartGuidePage.setSelected();
                UAManager.updateUAMClient((JComponent)smartGuidePage.getClient(), this);
                if (!this.overrideButtons) {
                    this.toggleDoneButton();
                }
                this.pageToExit = this.currentPage;
                if (((HidingButton)this.nextButton).isHidden()) {
                    this.getRootPane().setDefaultButton(this.doneButton);
                } else {
                    this.getRootPane().setDefaultButton(this.nextButton);
                }
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        SmartGuide.this.focusMan.focusNextComponent(smartGuidePage.getClient());
                    }
                });
                break;
            }
            object = this.buttonGroup.getElements();
            while (object.hasMoreElements()) {
                CustomToggleButton customToggleButton2 = (CustomToggleButton)object.nextElement();
                if (customToggleButton2.getSmartGuidePage() != this.pageToExit) continue;
                customToggleButton2.setSelected(true);
            }
        }
    }

    public void returnToPageFromError(SmartGuidePage smartGuidePage) {
        this.returnToPageFromError = true;
        this.turnToPage(smartGuidePage);
    }

    public SmartGuidePage getCurrentPage() {
        return this.currentPage;
    }

    public void revalidateAndRepaint() {
        this.sgTitleDescriptionPanel.revalidate();
        this.sgTitleDescriptionPanel.repaint();
        this.sgPagePanel.revalidate();
        this.sgPagePanel.repaint();
        this.sgPagePicture.revalidate();
        this.sgPagePicture.repaint();
        this.splitPanel.revalidate();
        this.splitPanel.repaint();
        this.invalidate();
        this.repaint();
    }

    public int getIndexOfPage(SmartGuidePage smartGuidePage) {
        int n2 = -1;
        if (smartGuidePage != null) {
            Enumeration<AbstractButton> enumeration = this.buttonGroup.getElements();
            while (enumeration.hasMoreElements()) {
                ++n2;
                CustomToggleButton customToggleButton = (CustomToggleButton)enumeration.nextElement();
                if (customToggleButton.getSmartGuidePage() == smartGuidePage) break;
            }
        }
        return n2;
    }

    public int getPageCount() {
        int n2 = 0;
        Enumeration<AbstractButton> enumeration = this.buttonGroup.getElements();
        while (enumeration.hasMoreElements()) {
            ++n2;
            enumeration.nextElement();
        }
        return n2;
    }

    public SmartGuidePage getPageAt(int n2) throws IndexOutOfBoundsException {
        if (n2 < 0 || n2 > this.getPageCount() - 1) {
            throw new IndexOutOfBoundsException();
        }
        SmartGuidePage smartGuidePage = null;
        int n3 = 0;
        Enumeration<AbstractButton> enumeration = this.buttonGroup.getElements();
        while (enumeration.hasMoreElements()) {
            CustomToggleButton customToggleButton = (CustomToggleButton)enumeration.nextElement();
            smartGuidePage = customToggleButton.getSmartGuidePage();
            if (n3 == n2) break;
            ++n3;
        }
        return smartGuidePage;
    }

    public boolean isPageInSmartGuide(SmartGuidePage smartGuidePage) {
        boolean bl = false;
        Enumeration<AbstractButton> enumeration = this.buttonGroup.getElements();
        while (enumeration.hasMoreElements()) {
            CustomToggleButton customToggleButton = (CustomToggleButton)enumeration.nextElement();
            if (customToggleButton.getSmartGuidePage() != smartGuidePage) continue;
            bl = true;
            break;
        }
        return bl;
    }

    protected void fireStateChanged() {
        this.toggleDoneButton();
    }

    protected void toggleDoneButton() {
        boolean bl = true;
        Enumeration<AbstractButton> enumeration = this.buttonGroup.getElements();
        while (enumeration.hasMoreElements()) {
            CustomToggleButton customToggleButton = (CustomToggleButton)enumeration.nextElement();
            customToggleButton.setEnabled(bl);
            if (customToggleButton.getSmartGuidePage().isPageComplete()) continue;
            bl = false;
        }
        this.doneButton.setEnabled(bl);
        this.toggleBackNextButtons();
    }

    protected void toggleBackNextButtons() {
        boolean bl = true;
        Enumeration<AbstractButton> enumeration = this.buttonGroup.getElements();
        while (enumeration.hasMoreElements()) {
            CustomToggleButton customToggleButton = (CustomToggleButton)enumeration.nextElement();
            if (customToggleButton.isSelected()) {
                this.nextButton.setEnabled(enumeration.hasMoreElements() && customToggleButton.getSmartGuidePage().isPageComplete());
                ((HidingButton)this.nextButton).setHidden(!enumeration.hasMoreElements());
                this.backButton.setEnabled(!bl);
                ((HidingButton)this.backButton).setHidden(bl);
                break;
            }
            bl = false;
        }
    }

    protected void rebuildButtonPanelWithNextButton(boolean bl) {
    }

    public Frame getParentFrame() {
        return this.parentFrame;
    }

    protected boolean done() {
        return true;
    }

    protected boolean cancel() {
        return true;
    }

    protected void next() {
        Enumeration<AbstractButton> enumeration = this.buttonGroup.getElements();
        while (enumeration.hasMoreElements()) {
            CustomToggleButton customToggleButton = (CustomToggleButton)enumeration.nextElement();
            if (!customToggleButton.isSelected() || !enumeration.hasMoreElements()) continue;
            customToggleButton = (CustomToggleButton)enumeration.nextElement();
            this.turnToPage(customToggleButton.getSmartGuidePage());
            break;
        }
    }

    protected void back() {
        CustomToggleButton customToggleButton = null;
        Stack<CustomToggleButton> stack = new Stack<CustomToggleButton>();
        Enumeration<AbstractButton> enumeration = this.buttonGroup.getElements();
        while (enumeration.hasMoreElements()) {
            customToggleButton = (CustomToggleButton)enumeration.nextElement();
            if (customToggleButton.isSelected()) {
                if (stack.empty()) break;
                customToggleButton = (CustomToggleButton)stack.pop();
                this.turnToPage(customToggleButton.getSmartGuidePage());
                break;
            }
            stack.push(customToggleButton);
        }
    }

    void executeFinish() {
        if (this.done()) {
            this.dispose();
        }
    }

    void executeCancel() {
        if (this.cancel()) {
            Enumeration<AbstractButton> enumeration = this.buttonGroup.getElements();
            while (enumeration.hasMoreElements()) {
                CustomToggleButton customToggleButton = (CustomToggleButton)enumeration.nextElement();
                CellExpanderManager.sharedInstance().unregisterComponent(customToggleButton);
            }
            this.dispose();
        }
    }

    void executeCustom() {
        Enumeration<AbstractButton> enumeration = this.buttonGroup.getElements();
        while (enumeration.hasMoreElements()) {
            CustomToggleButton customToggleButton = (CustomToggleButton)enumeration.nextElement();
            if (!customToggleButton.isSelected()) continue;
            this.turnToPage(customToggleButton.getSmartGuidePage());
            break;
        }
    }

    public void addPageForSizing(SmartGuidePage smartGuidePage) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.backButton) {
            this.back();
        } else if (object == this.nextButton) {
            this.next();
        } else if (object == this.doneButton) {
            this.executeFinish();
        } else if (object == this.cancelButton) {
            this.executeCancel();
        } else if (object instanceof CustomToggleButton) {
            this.executeCustom();
        }
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.executeCancel();
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
        int n2 = this.getPreferredTOCWidth();
        if (this.scrollTOCPanel()) {
            n2 += this.tocScroller.getVerticalScrollBar().getWidth();
        }
        if (n2 > this.maxTOCWidth) {
            this.splitPane.setDividerLocation(this.maxTOCWidth);
        } else {
            this.splitPane.setDividerLocation(n2);
        }
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.getID() == 401 && keyEvent.getKeyCode() == 27) {
            keyEvent.consume();
            this.executeCancel();
        } else {
            super.processKeyEvent(keyEvent);
        }
    }

    public void setButtonsEnabled(boolean bl) {
        Enumeration<AbstractButton> enumeration = this.buttonGroup.getElements();
        while (enumeration.hasMoreElements()) {
            CustomToggleButton customToggleButton = (CustomToggleButton)enumeration.nextElement();
            customToggleButton.setEnabled(bl);
        }
        this.backButton.setEnabled(bl);
        this.nextButton.setEnabled(bl);
        this.doneButton.setEnabled(bl);
        this.cancelButton.setEnabled(bl);
        boolean bl2 = this.overrideButtons = !bl;
        if (bl) {
            this.toggleDoneButton();
        }
    }

    public void setUAWindowAdapter(UAWindowAdapter uAWindowAdapter) {
        if (this.uaManagerListener != null) {
            this.removeWindowListener(this.uaManagerListener);
        }
        this.uaManagerListener = uAWindowAdapter;
        if (this.uaManagerListener != null) {
            this.addWindowListener(this.uaManagerListener);
        }
    }

    protected String getUAMToken() {
        String string = this.getClass().getName();
        int n2 = string.lastIndexOf(46);
        if (n2 > 0) {
            string = string.substring(0, n2);
        }
        string = string.substring(string.lastIndexOf(46) + 1);
        return string;
    }

    protected void setUAKeys() {
        block11: {
            try {
                boolean bl = false;
                if (this.backButton != null) {
                    this.backButton.putClientProperty("UAKey", "SmartGuide_backButton");
                } else {
                    bl = true;
                }
                if (this.nextButton != null) {
                    this.nextButton.putClientProperty("UAKey", "SmartGuide_nextButton");
                } else {
                    bl = true;
                }
                if (this.doneButton != null) {
                    this.doneButton.putClientProperty("UAKey", "SmartGuide_doneButton");
                } else {
                    bl = true;
                }
                if (this.cancelButton != null) {
                    this.cancelButton.putClientProperty("UAKey", "SmartGuide_cancelButton");
                } else {
                    bl = true;
                }
                if (bl) {
                    throw new NullPointerException();
                }
            }
            catch (Exception exception) {
                if (!UAManager.getDebug()) break block11;
                exception.printStackTrace();
            }
        }
    }

    protected void useCloseButton(boolean bl) {
        if (bl) {
            this.cancelButton.setText(CmStringPool.getString(25));
            ((HidingButton)this.doneButton).setHidden(true);
        } else {
            this.cancelButton.setText(CmStringPool.getString(24));
            this.cancelButton.setMnemonic(CmStringPool.getMnemonic(32));
            ((HidingButton)this.doneButton).setHidden(false);
        }
    }

    protected class SpacePanel
    extends JPanel {
        public SpacePanel() {
            this.setPreferredSize(new Dimension(40, 0));
        }
    }

    protected class GradientBar
    extends GradientMenuBar {
        public GradientBar() {
            this.setPreferredSize(new Dimension(0, 22));
        }

        public boolean isFocusTraversable() {
            return false;
        }
    }
}

