/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common.smartguide;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;

public class HidingButton
extends JButton {
    private static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected boolean hiding = false;
    protected Object uakey;

    public HidingButton() {
        this(null, null);
    }

    public HidingButton(Icon icon) {
        this(null, icon);
    }

    public HidingButton(String string) {
        this(string, null);
    }

    public HidingButton(Action action) {
        this(null, null);
        this.setAction(action);
    }

    public HidingButton(String string, Icon icon) {
        super(string, icon);
    }

    public void setHidden(boolean bl) {
        this.hiding = bl;
        if (bl) {
            this.uakey = this.getClientProperty("UAKey");
            if (this.uakey != null) {
                this.putClientProperty("UAKey", null);
            }
        } else if (this.uakey != null) {
            this.putClientProperty("UAKey", this.uakey);
            this.uakey = null;
        }
    }

    public boolean isHidden() {
        return this.hiding;
    }

    protected void paintComponent(Graphics graphics) {
        if (this.hiding) {
            Color color = graphics.getColor();
            graphics.setColor(super.getParent().getBackground());
            Dimension dimension = super.getSize();
            graphics.fillRect(0, 0, dimension.width, dimension.height);
            graphics.setColor(color);
        } else {
            super.paintComponent(graphics);
        }
    }

    protected void paintBorder(Graphics graphics) {
        if (!this.hiding) {
            super.paintBorder(graphics);
        }
    }
}

