/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common.sg;

import com.ibm.db2.tools.common.AppearanceManager;
import com.ibm.db2.tools.common.ArrowImageIconFactory;
import com.ibm.db2.tools.common.CmStringPool;
import com.ibm.db2.tools.common.GradientMenuBar;
import com.ibm.db2.tools.common.MultiLineEvent;
import com.ibm.db2.tools.common.MultiLineLabel;
import com.ibm.db2.tools.common.MultiLineListener;
import com.ibm.db2.tools.common.sg.CustomToggleButton;
import com.ibm.db2.tools.common.sg.HidingButton;
import com.ibm.db2.tools.common.sg.SmartGuideManager;
import com.ibm.db2.tools.common.sg.SmartGuidePage;
import com.ibm.db2.tools.common.support.AssistManager;
import com.ibm.db2.tools.common.support.CellExpanderManager;
import com.ibm.db2.tools.common.support.WrappingComponent;
import com.ibm.db2.tools.common.uamanager.UAManager;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultFocusManager;
import javax.swing.FocusManager;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.border.EtchedBorder;

public class SmartGuidePanel
extends JPanel
implements ActionListener,
PropertyChangeListener {
    private static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private boolean resetFocus = false;
    protected JButton backButton = null;
    protected JButton nextButton = null;
    protected JButton doneButton = null;
    protected JButton cancelButton = null;
    protected CardLayout cardLayout;
    protected JPanel cardPanel = null;
    protected JPanel sgPagePanel = null;
    protected JPanel leftPanel = null;
    protected JScrollPane tocScroller = null;
    protected JPanel buttonListPanel = null;
    protected GridBagConstraints tocConstraints;
    protected ButtonGroup buttonGroup = new ButtonGroup();
    protected final JSplitPane splitPane = new JSplitPane(1);
    protected JPanel splitPanel = null;
    protected JPanel buttonPanel = null;
    protected int currentPage = -1;
    protected DefaultFocusManager focusMan = null;
    protected Window parentWindow;
    protected int maxTOCWidth = 85;
    protected boolean enableMandatoryChecking = false;
    public String pageToExitTitle;
    public boolean callFromFirst = false;
    public boolean returnToPageFromError = false;
    public boolean overrideButtons = false;
    protected boolean scrollTOC = false;
    public static final int DEFAULT_HEIGHT = 600;
    public static final int DEFAULT_WIDTH = 800;
    public static final String BACK_BUTTON_TEXT = "BackButtonText";
    public static final String BACK_BUTTON_MNEMONIC = "BackButtonM";
    public static final String BACK_BUTTON_NAME_PROP = "BackButtonName";
    public static final String NEXT_BUTTON_TEXT = "NextButtonText";
    public static final String NEXT_BUTTON_MNEMONIC = "NextButtonM";
    public static final String NEXT_BUTTON_NAME_PROP = "NextButtonName";
    public static final String FINISH_BUTTON_TEXT = "FinishButtonText";
    public static final String FINISH_BUTTON_MNEMONIC = "FinishButtonM";
    public static final String FINISH_BUTTON_NAME_PROP = "FinishButtonName";
    public static final String CANCEL_BUTTON_TEXT = "CancelButtonText";
    public static final String CANCEL_BUTTON_NAME_PROP = "CancelButtonName";

    public SmartGuidePanel() {
        this((Window)null);
    }

    public SmartGuidePanel(Window window) {
        this.parentWindow = window;
        this.buttonListPanel = new JPanel();
        this.buttonListPanel.setLayout(new BoxLayout(this.buttonListPanel, 1));
        this.cardLayout = new CardLayout();
        this.cardPanel = new JPanel(this.cardLayout);
        this.leftPanel = new JPanel(new BorderLayout());
        this.leftPanel.add((Component)this.buttonListPanel, "North");
        this.leftPanel.add(Box.createVerticalGlue(), "Center");
        if (this.getScrollTOCPanel()) {
            this.tocScroller = new JScrollPane(this.leftPanel, 20, 31);
            this.splitPane.setLeftComponent(this.tocScroller);
        } else {
            this.splitPane.setLeftComponent(this.leftPanel);
        }
        this.splitPane.setDividerSize(2);
        this.splitPane.setRightComponent(this.cardPanel);
        this.splitPanel = new JPanel(new BorderLayout());
        this.splitPanel.add((Component)new GradientBar(), "North");
        this.splitPanel.add((Component)this.splitPane, "Center");
        this.splitPanel.setBorder(new EtchedBorder());
        this.backButton = new HidingButton();
        this.backButton.setActionCommand(BACK_BUTTON_TEXT);
        this.backButton.setIcon(ArrowImageIconFactory.getArrowImageIcon(this.backButton, 270));
        this.nextButton = new HidingButton();
        this.nextButton.setActionCommand(NEXT_BUTTON_TEXT);
        this.nextButton.setIcon(ArrowImageIconFactory.getArrowImageIcon(this.nextButton, 90));
        SmartGuideManager smartGuideManager = SmartGuideManager.getManager();
        this.backButton.setText((String)smartGuideManager.getProperty(BACK_BUTTON_TEXT));
        this.backButton.setName((String)smartGuideManager.getProperty(BACK_BUTTON_NAME_PROP));
        this.backButton.setMnemonic((Integer)smartGuideManager.getProperty(BACK_BUTTON_MNEMONIC));
        this.backButton.setVerticalTextPosition(0);
        this.backButton.setHorizontalTextPosition(4);
        this.nextButton.setText((String)smartGuideManager.getProperty(NEXT_BUTTON_TEXT));
        this.nextButton.setName((String)smartGuideManager.getProperty(NEXT_BUTTON_NAME_PROP));
        this.nextButton.setMnemonic((Integer)smartGuideManager.getProperty(NEXT_BUTTON_MNEMONIC));
        this.nextButton.setVerticalTextPosition(0);
        this.nextButton.setHorizontalTextPosition(2);
        this.doneButton = new HidingButton((String)smartGuideManager.getProperty(FINISH_BUTTON_TEXT));
        this.doneButton.setName((String)smartGuideManager.getProperty(FINISH_BUTTON_NAME_PROP));
        this.doneButton.setActionCommand(FINISH_BUTTON_TEXT);
        this.doneButton.setMnemonic((Integer)smartGuideManager.getProperty(FINISH_BUTTON_MNEMONIC));
        this.doneButton.setVerticalTextPosition(0);
        this.doneButton.setEnabled(false);
        this.cancelButton = new JButton((String)smartGuideManager.getProperty(CANCEL_BUTTON_TEXT));
        this.cancelButton.setName((String)smartGuideManager.getProperty(CANCEL_BUTTON_NAME_PROP));
        this.cancelButton.setActionCommand(CANCEL_BUTTON_TEXT);
        this.cancelButton.setVerticalTextPosition(0);
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new BoxLayout(this.buttonPanel, 0));
        this.buttonPanel.setBorder(BorderFactory.createEmptyBorder(5, 2, 2, 2));
        this.buttonPanel.add(Box.createHorizontalGlue());
        this.buttonPanel.add(this.backButton);
        this.buttonPanel.add(Box.createHorizontalStrut(10));
        this.buttonPanel.add(this.nextButton);
        this.buttonPanel.add(Box.createHorizontalStrut(10));
        this.buttonPanel.add(this.doneButton);
        this.buttonPanel.add(Box.createHorizontalStrut(10));
        this.buttonPanel.add(this.cancelButton);
        this.setLayout(new BorderLayout());
        this.add((Component)this.splitPanel, "Center");
        this.add((Component)this.buttonPanel, "South");
        this.setUAKeys();
        this.focusMan = (DefaultFocusManager)FocusManager.getCurrentManager();
        this.splitPane.addPropertyChangeListener(this);
    }

    public JButton getBackButton() {
        return this.backButton;
    }

    public JButton getNextButton() {
        return this.nextButton;
    }

    public JButton getDoneButton() {
        return this.doneButton;
    }

    public JButton getCancelButton() {
        return this.cancelButton;
    }

    public void addButtonListener(ActionListener actionListener) {
        this.backButton.addActionListener(actionListener);
        this.nextButton.addActionListener(actionListener);
        this.doneButton.addActionListener(actionListener);
        this.cancelButton.addActionListener(actionListener);
    }

    public void removeButtonListener(ActionListener actionListener) {
        this.backButton.removeActionListener(actionListener);
        this.nextButton.removeActionListener(actionListener);
        this.doneButton.removeActionListener(actionListener);
        this.cancelButton.removeActionListener(actionListener);
    }

    public void setScrollTOCPanel(boolean bl) {
        this.scrollTOC = bl;
        if (this.scrollTOC) {
            this.tocScroller = new JScrollPane(this.leftPanel, 20, 31);
            this.splitPane.setLeftComponent(this.tocScroller);
        } else {
            this.splitPane.setLeftComponent(this.leftPanel);
        }
        if (bl) {
            this.tocScroller.setPreferredSize(new Dimension(this.getPreferredTOCWidth(), 505));
        }
    }

    public boolean getScrollTOCPanel() {
        return this.scrollTOC;
    }

    public int getMaxTOCWidth() {
        return this.maxTOCWidth;
    }

    public void setMaxTOCWidth(int n2) {
        CustomToggleButton customToggleButton;
        int n3;
        this.maxTOCWidth = n2;
        Enumeration<AbstractButton> enumeration = this.getButtonGroup().getElements();
        if (enumeration.hasMoreElements() && (n3 = (customToggleButton = (CustomToggleButton)enumeration.nextElement()).getMaxWidth()) != n2) {
            while (enumeration.hasMoreElements()) {
                customToggleButton = (CustomToggleButton)enumeration.nextElement();
                customToggleButton.setMaxWidth(n2);
                customToggleButton.invalidate();
            }
        }
    }

    public int getPreferredTOCWidth() {
        Dimension dimension = this.buttonListPanel.getPreferredSize();
        return dimension.width + 10;
    }

    public void setTOCDividerLocation() {
        int n2 = this.getPreferredTOCWidth();
        if (this.getScrollTOCPanel()) {
            n2 += this.tocScroller.getVerticalScrollBar().getWidth();
        }
        if (n2 > this.getMaxTOCWidth()) {
            this.splitPane.setDividerLocation(this.getMaxTOCWidth());
        } else {
            this.splitPane.setDividerLocation(n2);
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("dividerLocation")) {
            Integer n2 = (Integer)propertyChangeEvent.getNewValue();
            this.setMaxTOCWidth(n2);
        }
    }

    public JComponent getMainContainer(SmartGuidePage smartGuidePage) {
        return new JScrollPane(smartGuidePage.getClient());
    }

    protected JPanel getButtonPanel() {
        return this.buttonPanel;
    }

    protected ButtonGroup getButtonGroup() {
        return this.buttonGroup;
    }

    public void linkStateChanged(MultiLineEvent multiLineEvent) {
    }

    public SGPagePanel getSGPanel(String string) {
        Component[] componentArray = this.cardPanel.getComponents();
        int n2 = 0;
        while (n2 < componentArray.length) {
            if (((SGPagePanel)componentArray[n2]).getOriginalTitle().equals(string)) {
                return (SGPagePanel)componentArray[n2];
            }
            ++n2;
        }
        int n3 = 0;
        while (n3 < componentArray.length) {
            if (((SGPagePanel)componentArray[n3]).getSmartGuidePage().getShortTitle().equals(string)) {
                return (SGPagePanel)componentArray[n3];
            }
            ++n3;
        }
        int n4 = 0;
        while (n4 < componentArray.length) {
            if (((SGPagePanel)componentArray[n4]).getSmartGuidePage().getTitle().equals(string)) {
                return (SGPagePanel)componentArray[n4];
            }
            ++n4;
        }
        return null;
    }

    public SmartGuidePage getPage(String string) {
        SGPagePanel sGPagePanel = this.getSGPanel(string);
        if (sGPagePanel != null) {
            return sGPagePanel.getSmartGuidePage();
        }
        return null;
    }

    public void setDescriptionComponent(SmartGuidePage smartGuidePage, WrappingComponent wrappingComponent) {
        if (smartGuidePage != null && wrappingComponent != null) {
            this.setDescriptionComponent(smartGuidePage.getTitle(), wrappingComponent);
        }
    }

    public void setDescriptionComponent(String string, WrappingComponent wrappingComponent) {
        SGPagePanel sGPagePanel;
        if (wrappingComponent != null && (sGPagePanel = this.getSGPanel(string)) != null) {
            sGPagePanel.setDescriptionComponent(wrappingComponent);
        }
    }

    public WrappingComponent getDescriptionComponent(SmartGuidePage smartGuidePage) {
        return this.getDescriptionComponent(smartGuidePage.getTitle());
    }

    public WrappingComponent getDescriptionComponent(String string) {
        SGPagePanel sGPagePanel = this.getSGPanel(string);
        if (sGPagePanel != null) {
            return sGPagePanel.getDescriptionComponent();
        }
        return null;
    }

    public void addHyperlinkListener(MultiLineListener multiLineListener) {
        Component[] componentArray = this.cardPanel.getComponents();
        int n2 = 0;
        while (n2 < componentArray.length) {
            ((SGPagePanel)componentArray[n2]).addMultiLineListener(multiLineListener);
            ++n2;
        }
    }

    public void removeHyperlinkListener(MultiLineListener multiLineListener) {
        Component[] componentArray = this.cardPanel.getComponents();
        int n2 = 0;
        while (n2 < componentArray.length) {
            ((SGPagePanel)componentArray[n2]).removeMultiLineListener(multiLineListener);
            ++n2;
        }
    }

    protected int limitCoordinate(int n2, int n3, int n4) {
        return n2 < n3 ? n3 : (n2 > n4 ? n4 : n2);
    }

    public void refreshPage(SmartGuidePage smartGuidePage) {
        Component[] componentArray = this.cardPanel.getComponents();
        int n2 = 0;
        while (n2 < componentArray.length) {
            if (((SGPagePanel)componentArray[n2]).getSmartGuidePage() == smartGuidePage) {
                ((SGPagePanel)componentArray[n2]).refresh();
                return;
            }
            ++n2;
        }
    }

    public void addPage(SmartGuidePage smartGuidePage) {
        this.addPage(smartGuidePage, smartGuidePage.getTitle());
    }

    public void addPage(SmartGuidePage smartGuidePage, String string) {
        CustomToggleButton customToggleButton = this.addButton(smartGuidePage.getShortTitle());
        this.cardPanel.add((Component)new SGPagePanel(smartGuidePage, customToggleButton, string), string);
        if (this.enableMandatoryChecking) {
            smartGuidePage.buildAssistFieldVector();
        }
        smartGuidePage.setAdded(true);
        this.fireStateChanged();
    }

    public CustomToggleButton addButton(String string) {
        CustomToggleButton customToggleButton = new CustomToggleButton(string);
        this.getButtonGroup().add(customToggleButton);
        customToggleButton.setName("BUTTON" + this.buttonGroup.getButtonCount());
        this.buttonListPanel.add(customToggleButton);
        customToggleButton.addActionListener(this);
        customToggleButton.setButtonNumber(this.buttonListPanel.getComponents().length);
        this.fireStateChanged();
        return customToggleButton;
    }

    public void setButtonNumbers() {
        int n2 = 0;
        Enumeration<AbstractButton> enumeration = this.getButtonGroup().getElements();
        while (enumeration.hasMoreElements()) {
            CustomToggleButton customToggleButton = (CustomToggleButton)enumeration.nextElement();
            customToggleButton.setButtonNumber(++n2);
        }
    }

    public boolean removePage(SmartGuidePage smartGuidePage) {
        return this.removePage(smartGuidePage.getTitle());
    }

    public boolean removePage(String string) {
        boolean bl = this.removeButton(string);
        if (bl) {
            SGPagePanel sGPagePanel = this.getSGPanel(string);
            this.cardPanel.remove(sGPagePanel);
            sGPagePanel.getSmartGuidePage().setAdded(false);
            this.fireStateChanged();
        }
        return bl;
    }

    public CustomToggleButton getButton(String string) {
        SGPagePanel sGPagePanel = this.getSGPanel(string);
        if (sGPagePanel != null) {
            return sGPagePanel.getButton();
        }
        return null;
    }

    public boolean removeButton(String string) {
        boolean bl = false;
        CustomToggleButton customToggleButton = this.getButton(string);
        if (customToggleButton != null) {
            this.getButtonGroup().remove(customToggleButton);
            this.buttonListPanel.remove(customToggleButton);
            CellExpanderManager.sharedInstance().unregisterComponent(customToggleButton);
            this.setButtonNumbers();
            this.leftPanel.revalidate();
            this.fireStateChanged();
            bl = true;
        }
        return bl;
    }

    public void setEnableMandatoryChecking(boolean bl) {
        this.enableMandatoryChecking = bl;
    }

    public boolean getEnableMandatoryChecking() {
        return this.enableMandatoryChecking;
    }

    public boolean insertPageAfter(SmartGuidePage smartGuidePage, SmartGuidePage smartGuidePage2) {
        boolean bl = false;
        int n2 = this.getIndexOfPage(smartGuidePage2.getTitle());
        if (n2 < 0) {
            return false;
        }
        int n3 = this.getPageCount();
        if (this.currentPage > n2) {
            ++this.currentPage;
        }
        if (n2 == n3 - 1) {
            this.addPage(smartGuidePage);
        } else {
            SGPagePanel sGPagePanel;
            Vector<Component> vector = new Vector<Component>();
            int n4 = n2 + 1;
            while (n4 < n3) {
                vector.addElement(this.cardPanel.getComponent(n4));
                ++n4;
            }
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                sGPagePanel = (SGPagePanel)enumeration.nextElement();
                this.removePage(sGPagePanel.getOriginalTitle());
            }
            this.addPage(smartGuidePage);
            Enumeration enumeration2 = vector.elements();
            while (enumeration2.hasMoreElements()) {
                sGPagePanel = (SGPagePanel)enumeration2.nextElement();
                CustomToggleButton customToggleButton = sGPagePanel.getButton();
                this.getButtonGroup().add(customToggleButton);
                customToggleButton.setName("BUTTON" + this.buttonGroup.getButtonCount());
                this.buttonListPanel.add(customToggleButton);
                this.cardPanel.add((Component)sGPagePanel, sGPagePanel.getOriginalTitle());
            }
            this.setButtonNumbers();
            this.fireStateChanged();
        }
        return true;
    }

    public boolean replacePageWith(SmartGuidePage smartGuidePage, SmartGuidePage smartGuidePage2) {
        boolean bl = false;
        String string = smartGuidePage.getTitle();
        String string2 = smartGuidePage2.getTitle();
        int n2 = this.getIndexOfPage(string2);
        CustomToggleButton customToggleButton = this.getButton(string2);
        if (customToggleButton != null) {
            bl = true;
            customToggleButton.setTitle(smartGuidePage.getShortTitle());
            this.cardPanel.remove(this.getSGPanel(string2));
            this.cardPanel.add(new SGPagePanel(smartGuidePage, customToggleButton, string), string, n2);
            smartGuidePage2.setAdded(false);
            smartGuidePage.setAdded(true);
            if (this.enableMandatoryChecking) {
                smartGuidePage.buildAssistFieldVector();
            }
        }
        return bl;
    }

    public void removeAllPages() {
        String string;
        Vector<String> vector = new Vector<String>();
        Enumeration<AbstractButton> enumeration = this.getButtonGroup().getElements();
        while (enumeration.hasMoreElements()) {
            CustomToggleButton customToggleButton = (CustomToggleButton)enumeration.nextElement();
            string = customToggleButton.getTitle();
            vector.add(string);
        }
        int n2 = 0;
        while (n2 < vector.size()) {
            string = (String)vector.get(n2);
            this.removePage(string);
            ++n2;
        }
    }

    public void selectFirstPage() {
        this.callFromFirst = true;
        SGPagePanel sGPagePanel = (SGPagePanel)this.cardPanel.getComponent(0);
        this.turnToPage(sGPagePanel.getSmartGuidePage());
        this.callFromFirst = false;
        this.pageToExitTitle = sGPagePanel.getOriginalTitle();
    }

    public void turnToPage(SmartGuidePage smartGuidePage) {
        this.turnToPage(smartGuidePage.getTitle());
    }

    public void turnToPage(String string) {
        SGPagePanel sGPagePanel = this.getSGPanel(string);
        String string2 = sGPagePanel.getOriginalTitle();
        if (sGPagePanel != null) {
            if (this.callFromFirst || this.pageToExitTitle != null && this.getSGPanel(this.pageToExitTitle).getSmartGuidePage().canTurnTo(sGPagePanel.getSmartGuidePage())) {
                SmartGuidePage smartGuidePage = sGPagePanel.getSmartGuidePage();
                if (!this.callFromFirst && !this.returnToPageFromError) {
                    SmartGuidePage smartGuidePage2 = this.getSGPanel(this.pageToExitTitle).getSmartGuidePage();
                    smartGuidePage2.pageExited();
                }
                this.returnToPageFromError = false;
                this.cardLayout.show(this.cardPanel, string2);
                smartGuidePage.changePanels();
                sGPagePanel.getButton().setSelected(true);
                this.currentPage = this.getIndexOfPage(smartGuidePage);
                this.revalidateAndRepaint();
                smartGuidePage.setSelected();
                if (this.parentWindow == null) {
                    this.findParentWindow();
                } else {
                    UAManager.updateUAMClient((JComponent)smartGuidePage.getClient(), this.parentWindow);
                }
                if (!this.overrideButtons) {
                    this.toggleDoneButton();
                }
                this.pageToExitTitle = string2;
                if (((HidingButton)this.nextButton).isHidden()) {
                    this.getRootPane().setDefaultButton(this.doneButton);
                } else {
                    this.getRootPane().setDefaultButton(this.nextButton);
                }
                this.resetFocus(sGPagePanel);
            } else {
                sGPagePanel.getButton().setSelected(true);
            }
        }
    }

    public void resetFocus(SGPagePanel sGPagePanel) {
        final SmartGuidePage smartGuidePage = sGPagePanel.getSmartGuidePage();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (SmartGuidePanel.this.resetFocus) {
                    if (smartGuidePage.getInitFocusComponent() == null) {
                        SmartGuidePanel.this.focusMan.focusNextComponent(smartGuidePage.getClient());
                        smartGuidePage.resetInitFocusComponent();
                    } else {
                        Component component = smartGuidePage.getInitFocusComponent();
                        if (component instanceof JComponent) {
                            ((JComponent)component).grabFocus();
                        } else {
                            component.requestFocus();
                        }
                    }
                } else {
                    SmartGuidePanel.this.focusMan.focusNextComponent(smartGuidePage.getClient());
                }
            }
        });
    }

    public void setResetFocus(boolean bl) {
        this.resetFocus = bl;
    }

    public boolean isResetFocus() {
        return this.resetFocus;
    }

    public void returnToPageFromError(SmartGuidePage smartGuidePage) {
        this.returnToPageFromError = true;
        this.turnToPage(smartGuidePage);
    }

    public SmartGuidePage getCurrentPage() {
        if (this.currentPage < 0) {
            return null;
        }
        return this.getPageAt(this.currentPage);
    }

    public void revalidateAndRepaint() {
        Component component;
        this.cardPanel.revalidate();
        this.splitPanel.revalidate();
        if (this.currentPage > -1 && (component = this.getPageAt(this.currentPage).getClient()) instanceof JComponent) {
            ((JComponent)component).revalidate();
        }
        this.revalidate();
        this.doLayout();
    }

    public int getIndexOfPage(SmartGuidePage smartGuidePage) {
        int n2 = -1;
        if (smartGuidePage != null && (n2 = this.getIndexOfPage(smartGuidePage.getShortTitle())) < 0) {
            n2 = this.getIndexOfPage(smartGuidePage.getTitle());
        }
        return n2;
    }

    public int getIndexOfPage(String string) {
        if (string != null) {
            Component[] componentArray = this.cardPanel.getComponents();
            int n2 = 0;
            while (n2 < componentArray.length) {
                if (((SGPagePanel)componentArray[n2]).getOriginalTitle().equals(string)) {
                    return n2;
                }
                ++n2;
            }
            n2 = 0;
            while (n2 < componentArray.length) {
                if (((SGPagePanel)componentArray[n2]).getSmartGuidePage().getShortTitle().equals(string)) {
                    return n2;
                }
                ++n2;
            }
            n2 = 0;
            while (n2 < componentArray.length) {
                if (((SGPagePanel)componentArray[n2]).getSmartGuidePage().getTitle().equals(string)) {
                    return n2;
                }
                ++n2;
            }
        }
        return -1;
    }

    public int getPageCount() {
        return this.cardPanel.getComponentCount();
    }

    public SmartGuidePage getPageAt(int n2) throws IndexOutOfBoundsException {
        return ((SGPagePanel)this.cardPanel.getComponent(n2)).getSmartGuidePage();
    }

    public boolean isPageInSmartGuide(SmartGuidePage smartGuidePage) {
        return this.isPageInSmartGuide(smartGuidePage.getTitle());
    }

    public boolean isPageInSmartGuide(String string) {
        return this.getSGPanel(string) != null;
    }

    public void fireStateChanged() {
        this.toggleDoneButton();
    }

    protected void toggleDoneButton() {
        boolean bl = true;
        Component[] componentArray = this.cardPanel.getComponents();
        int n2 = 0;
        while (n2 < componentArray.length) {
            SmartGuidePage smartGuidePage = ((SGPagePanel)componentArray[n2]).getSmartGuidePage();
            CustomToggleButton customToggleButton = ((SGPagePanel)componentArray[n2]).getButton();
            customToggleButton.setEnabled(bl);
            if (!smartGuidePage.isPageComplete()) {
                bl = false;
            }
            ++n2;
        }
        this.doneButton.setEnabled(bl);
        this.toggleBackNextButtons();
    }

    public void toggleBackNextButtons() {
        if (this.currentPage > -1) {
            int n2 = this.getPageCount();
            SGPagePanel sGPagePanel = (SGPagePanel)this.cardPanel.getComponent(this.currentPage);
            SmartGuidePage smartGuidePage = sGPagePanel.getSmartGuidePage();
            this.nextButton.setEnabled(this.currentPage < n2 - 1 && smartGuidePage.isPageComplete());
            ((HidingButton)this.nextButton).setHidden(this.currentPage == n2 - 1);
            this.backButton.setEnabled(this.currentPage > 0);
            ((HidingButton)this.backButton).setHidden(this.currentPage < 1);
        }
    }

    public void next() {
        int n2 = this.getPageCount();
        if (this.currentPage < n2 - 1) {
            this.turnToPage(this.getPageAt(this.currentPage + 1));
        }
    }

    public void back() {
        if (this.currentPage > 0) {
            this.turnToPage(this.getPageAt(this.currentPage - 1));
        }
    }

    public void unregister() {
        Enumeration<AbstractButton> enumeration = this.getButtonGroup().getElements();
        while (enumeration.hasMoreElements()) {
            CustomToggleButton customToggleButton = (CustomToggleButton)enumeration.nextElement();
            CellExpanderManager.sharedInstance().unregisterComponent(customToggleButton);
        }
    }

    public void executeCustom() {
        this.turnToPage(this.getCurrentPage());
    }

    public void addPageForSizing(SmartGuidePage smartGuidePage) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        SmartGuidePage smartGuidePage;
        Object object = actionEvent.getSource();
        if (object instanceof CustomToggleButton && (smartGuidePage = this.getPage(((CustomToggleButton)object).getTitle())) != null) {
            this.turnToPage(smartGuidePage);
        }
    }

    public void setButtonsEnabled(boolean bl) {
        Enumeration<AbstractButton> enumeration = this.getButtonGroup().getElements();
        while (enumeration.hasMoreElements()) {
            CustomToggleButton customToggleButton = (CustomToggleButton)enumeration.nextElement();
            customToggleButton.setEnabled(bl);
        }
        this.backButton.setEnabled(bl);
        this.nextButton.setEnabled(bl);
        this.doneButton.setEnabled(bl);
        this.cancelButton.setEnabled(bl);
        boolean bl2 = this.overrideButtons = !bl;
        if (bl) {
            this.toggleDoneButton();
        }
    }

    protected void useCloseButton(boolean bl) {
        if (bl) {
            this.cancelButton.setText(CmStringPool.getString(25));
            ((HidingButton)this.doneButton).setHidden(true);
        } else {
            this.cancelButton.setText(CmStringPool.getString(24));
            this.cancelButton.setMnemonic(CmStringPool.getMnemonic(32));
            ((HidingButton)this.doneButton).setHidden(false);
        }
    }

    public void setUAKeys() {
        block11: {
            try {
                boolean bl = false;
                if (this.backButton != null) {
                    this.backButton.putClientProperty("UAKey", "SmartGuide_backButton");
                } else {
                    bl = true;
                }
                if (this.nextButton != null) {
                    this.nextButton.putClientProperty("UAKey", "SmartGuide_nextButton");
                } else {
                    bl = true;
                }
                if (this.doneButton != null) {
                    this.doneButton.putClientProperty("UAKey", "SmartGuide_doneButton");
                } else {
                    bl = true;
                }
                if (this.cancelButton != null) {
                    this.cancelButton.putClientProperty("UAKey", "SmartGuide_cancelButton");
                } else {
                    bl = true;
                }
                if (bl) {
                    throw new NullPointerException();
                }
            }
            catch (Exception exception) {
                if (!UAManager.getDebug()) break block11;
                exception.printStackTrace();
            }
        }
    }

    private void findParentWindow() {
        Container container = this;
        while (container != null && !(container instanceof Window)) {
            container = container.getParent();
        }
        this.parentWindow = container != null ? (Window)container : null;
    }

    protected class GradientBar
    extends GradientMenuBar {
        private static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

        public GradientBar() {
            super.setPreferredSize(new Dimension(0, 22));
        }

        public boolean isFocusTraversable() {
            return false;
        }
    }

    protected class SGPagePanel
    extends JPanel {
        private static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
        protected SmartGuidePage page;
        protected CustomToggleButton button;
        protected String origtitle;
        protected JComponent jsp = null;
        protected MultiLineLabel sgPageTitle = null;
        protected WrappingComponent sgPageDescription = null;
        protected JLabel sgPagePicture = null;
        protected GridBagConstraints gbcDesc;

        public SGPagePanel(SmartGuidePage smartGuidePage, CustomToggleButton customToggleButton, String string) {
            super(new GridBagLayout());
            this.page = smartGuidePage;
            this.button = customToggleButton;
            this.origtitle = string;
            this.sgPageTitle = new MultiLineLabel(this.page.getTitle());
            AppearanceManager.updateFont(this.sgPageTitle);
            if (!Locale.TAIWAN.equals(AssistManager.getPreferredLanguage())) {
                this.sgPageTitle.setFont(AppearanceManager.getLanguageDependentDefaultFont(new Font(this.sgPageTitle.getFont().getName(), 1, (int)((double)this.sgPageTitle.getFont().getSize() * 1.5))));
            }
            this.sgPageDescription = new MultiLineLabel(this.page.getDescription());
            AppearanceManager.updateFont((Component)((Object)this.sgPageDescription));
            this.jsp = SmartGuidePanel.this.getMainContainer(this.page);
            this.jsp.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            this.sgPagePicture = this.page.getIcon() != null ? new JLabel(this.page.getIcon()) : new JLabel();
            SmartGuidePanel.this.buttonListPanel.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
            Insets insets = new Insets(0, 10, 0, 10);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            AssistManager.setGridBagConstraints(gridBagConstraints, 0, 0, 0, 1, 2, insets, -1, 1.0, 0.0);
            this.gbcDesc = new GridBagConstraints();
            AssistManager.setGridBagConstraints(this.gbcDesc, 0, 1, 0, 1, 2, insets, -1, 1.0, 0.0);
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            AssistManager.setGridBagConstraints(gridBagConstraints2, 0, 2, 1, 0, 1, null, -1, 1.0, 1.0);
            super.add((Component)this.sgPageTitle, gridBagConstraints);
            super.add((Component)((Object)this.sgPageDescription), this.gbcDesc);
            super.add((Component)this.jsp, gridBagConstraints2);
            if (this.sgPagePicture != null) {
                GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
                AssistManager.setGridBagConstraints(gridBagConstraints3, 1, 2, 0, 0, 3, null, -1, 0.0, 1.0);
                super.add((Component)this.sgPagePicture, gridBagConstraints3);
            }
        }

        public void refresh() {
            if (!this.button.getTitle().equals(this.page.getTitle())) {
                this.button.setTitle(this.page.getShortTitle());
                this.sgPageTitle.setText(this.page.getTitle());
            }
            if (!this.sgPageDescription.getText().equals(this.page.getDescription())) {
                this.sgPageDescription.setText(this.page.getDescription());
            }
            if (this.sgPagePicture.getIcon() != this.page.getIcon()) {
                this.sgPagePicture.setIcon(this.page.getIcon());
            }
            if (this.jsp instanceof JScrollPane) {
                if (((JScrollPane)this.jsp).getViewport().getView() != this.page.getClient()) {
                    ((JScrollPane)this.jsp).getViewport().setView(this.page.getClient());
                }
            } else {
                super.remove(this.jsp);
                this.jsp = SmartGuidePanel.this.getMainContainer(this.page);
                this.jsp.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                AssistManager.setGridBagConstraints(gridBagConstraints, 0, 2, 1, 0, 1, null, -1, 1.0, 1.0);
                super.add((Component)this.jsp, gridBagConstraints);
            }
        }

        public SmartGuidePage getSmartGuidePage() {
            return this.page;
        }

        public CustomToggleButton getButton() {
            return this.button;
        }

        public String getOriginalTitle() {
            return this.origtitle;
        }

        public void setDescriptionComponent(WrappingComponent wrappingComponent) {
            super.getLayout().removeLayoutComponent((Component)((Object)this.sgPageDescription));
            super.remove((Component)((Object)this.sgPageDescription));
            this.sgPageDescription = wrappingComponent;
            this.sgPageDescription.setText(this.page.getDescription());
            super.add((Component)((Object)this.sgPageDescription), this.gbcDesc);
            AppearanceManager.updateFont((Component)((Object)this.sgPageDescription));
            SmartGuidePanel.this.revalidateAndRepaint();
        }

        public WrappingComponent getDescriptionComponent() {
            return this.sgPageDescription;
        }

        public void addMultiLineListener(MultiLineListener multiLineListener) {
            this.sgPageDescription.addMultiLineListener(multiLineListener);
        }

        public void removeMultiLineListener(MultiLineListener multiLineListener) {
            this.sgPageDescription.removeMultiLineListener(multiLineListener);
        }
    }
}

