/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common.sg;

import com.ibm.db2.tools.common.CommonFrame;
import com.ibm.db2.tools.common.MultiLineEvent;
import com.ibm.db2.tools.common.MultiLineListener;
import com.ibm.db2.tools.common.event.AssistEvent;
import com.ibm.db2.tools.common.event.AssistListener;
import com.ibm.db2.tools.common.sg.SmartGuideInterface;
import com.ibm.db2.tools.common.sg.SmartGuidePanel;
import com.ibm.db2.tools.common.uamanager.UAMCustomizerWindowAdapter;
import com.ibm.db2.tools.common.uamanager.UAWindowAdapter;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JPanel;

public class SmartGuideFrame
extends CommonFrame
implements SmartGuideInterface,
ActionListener,
AssistListener,
MultiLineListener,
WindowListener {
    private static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected SmartGuidePanel mainpanel;
    private UAWindowAdapter uaManagerListener = null;

    public SmartGuideFrame() {
        this("");
    }

    public SmartGuideFrame(String string) {
        super(string, false);
        this.constructSmartGuideFrame();
    }

    public SmartGuideFrame(String string, Window window) {
        super(string, window, false);
        this.constructSmartGuideFrame();
    }

    protected void constructSmartGuideFrame() {
        this.setOverridesAppearanceManager(true);
        this.mainpanel = new SmartGuidePanel();
        this.mainpanel.addButtonListener(this);
        this.registerKeyboardAction(this, "CancelButtonText", 27);
        this.getContentPane().add(this.mainpanel);
        this.mainpanel.setScrollTOCPanel(this.scrollTOCPanel());
        this.setUAWindowAdapter(new UAMCustomizerWindowAdapter(this.getUAMToken()));
        this.addWindowListener(this);
    }

    public SmartGuidePanel getMainPanel() {
        return this.mainpanel;
    }

    public void setMainPanel(SmartGuidePanel smartGuidePanel) {
        this.mainpanel.removeButtonListener(this);
        this.getContentPane().remove(this.mainpanel);
        this.mainpanel = smartGuidePanel;
        this.mainpanel.addButtonListener(this);
        this.getContentPane().add(this.mainpanel);
        this.mainpanel.setScrollTOCPanel(this.scrollTOCPanel());
    }

    protected boolean scrollTOCPanel() {
        return false;
    }

    public JPanel getButtonPanel() {
        return this.getMainPanel().getButtonPanel();
    }

    public void linkStateChanged(MultiLineEvent multiLineEvent) {
    }

    public void showCentered() {
        Dimension dimension = this.getSize();
        Dimension dimension2 = this.getToolkit().getScreenSize();
        this.adjustSize(dimension, dimension2);
        this.getMainPanel().selectFirstPage();
        Point point = null;
        Window window = this.getParentWindow();
        if (window != null && window != this) {
            dimension = window.getSize();
            point = window.getLocation();
        } else {
            point = new Point(0, 0);
            dimension = dimension2;
        }
        Dimension dimension3 = this.getSize();
        int n2 = point.x + dimension.width / 2;
        int n3 = point.y + dimension.height / 2;
        int n4 = n2 - dimension3.width / 2;
        int n5 = n3 - dimension3.height / 2;
        n4 = this.limitCoordinate(n4, 0, dimension2.width - dimension3.width);
        n5 = this.limitCoordinate(n5, 0, dimension2.height - dimension3.height);
        super.setLocation(n4, n5);
        super.setCursor(Cursor.getDefaultCursor());
        this.setVisible(true);
        this.getMainPanel().selectFirstPage();
    }

    protected void adjustSize(Dimension dimension, Dimension dimension2) {
        int n2 = dimension.width;
        this.getMainPanel();
        dimension.width = Math.max(n2, 800);
        int n3 = dimension.height;
        this.getMainPanel();
        dimension.height = Math.max(n3, 600);
        dimension.width = Math.min(dimension.width, dimension2.width);
        dimension.height = Math.min(dimension.height, dimension2.height);
        super.setSize(dimension);
    }

    int limitCoordinate(int n2, int n3, int n4) {
        return n2 < n3 ? n3 : (n2 > n4 ? n4 : n2);
    }

    protected boolean done() {
        return true;
    }

    protected boolean cancel() {
        return true;
    }

    protected void next() {
        this.getMainPanel().next();
    }

    protected void back() {
        this.getMainPanel().back();
    }

    void executeFinish() {
        if (this.done()) {
            this.getMainPanel().unregister();
            this.dispose();
        }
    }

    void executeCancel() {
        if (this.cancel()) {
            this.getMainPanel().unregister();
            this.dispose();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        this.getMainPanel();
        if (string == "BackButtonText") {
            this.back();
        } else {
            this.getMainPanel();
            if (string == "NextButtonText") {
                this.next();
            } else {
                this.getMainPanel();
                if (string == "FinishButtonText") {
                    this.executeFinish();
                } else {
                    this.getMainPanel();
                    if (string == "CancelButtonText") {
                        this.executeCancel();
                    } else {
                        this.getMainPanel().actionPerformed(actionEvent);
                    }
                }
            }
        }
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.executeCancel();
        super.windowClosing(windowEvent);
    }

    public void windowOpened(WindowEvent windowEvent) {
        super.windowOpened(windowEvent);
        this.getMainPanel().setTOCDividerLocation();
    }

    public void windowClosed(WindowEvent windowEvent) {
        super.windowClosed(windowEvent);
    }

    public void windowIconified(WindowEvent windowEvent) {
        super.windowIconified(windowEvent);
    }

    public void windowDeiconified(WindowEvent windowEvent) {
        super.windowDeiconified(windowEvent);
    }

    public void windowActivated(WindowEvent windowEvent) {
        super.windowActivated(windowEvent);
    }

    public void windowDeactivated(WindowEvent windowEvent) {
        super.windowDeactivated(windowEvent);
    }

    public String getUAMToken() {
        String string = this.getClass().getName();
        int n2 = string.lastIndexOf(46);
        if (n2 > 0) {
            string = string.substring(0, n2);
        }
        string = string.substring(string.lastIndexOf(46) + 1);
        return string;
    }

    public void setUAWindowAdapter(UAWindowAdapter uAWindowAdapter) {
        if (this.uaManagerListener != null) {
            this.removeWindowListener(this.uaManagerListener);
        }
        this.uaManagerListener = uAWindowAdapter;
        if (this.uaManagerListener != null) {
            this.addWindowListener(this.uaManagerListener);
        }
    }

    public void validityChanged(AssistEvent assistEvent) {
        this.getMainPanel().fireStateChanged();
    }
}

